#ifndef AUTHORIZATIONPLUGIN_H
#define AUTHORIZATIONPLUGIN_H

#include <Security/Authorization.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*Plug-in Interface Version

The version of the interface implemented by the plug-in.

enum {
   kAuthorizationPluginInterfaceVersion =  0
};
Discussion

The plug-in interface is defined by the AuthorizationPluginInterface structure and described in “Functions Implemented By the Plug-in”.*/
enum {
   kAuthorizationPluginInterfaceVersion =  0
};

/*Authorization Result

The result of an authorization evaluation.

enum {
   kAuthorizationResultAllow,
   kAuthorizationResultDeny,
   kAuthorizationResultUndefined,
   kAuthorizationResultUserCanceled,
};
Constants
kAuthorizationResultAllow

The authorization operation succeeded and authorization should be granted.

Available in Mac OS X v10.4 and later.
kAuthorizationResultDeny

The authorization operation succeeded and authorization should be denied.

Available in Mac OS X v10.4 and later.
kAuthorizationResultUndefined

The authorization operation failed and should not be retried for this session. 

Available in Mac OS X v10.4 and later.
kAuthorizationResultUserCanceled

The user has requested that the authorization evaluation be terminated.

Available in Mac OS X v10.4 and later.*/
enum {
   kAuthorizationResultAllow,
   kAuthorizationResultDeny,
   kAuthorizationResultUndefined,
   kAuthorizationResultUserCanceled,
};

/*AuthorizationPluginRef

Handle passed by the plug-in to the authorization engine when the plug-in is initiated.

typedef void *AuthorizationPluginRef;
Discussion

Your AuthorizationPluginCreate function assigns this value and returns it to the authorization engine. The authorization engine passes this reference back to you in any subsequent calls to your MechanismCreate and PluginDestroy functions.
Availability
Available in Mac OS X v10.4 and later.*/
typedef void *AuthorizationPluginRef;

/*Authorization Engine Interface Version

The version of the interface implemented by the authorization engine.

enum {
   kAuthorizationCallbacksVersion =        0
};
Discussion

The authorization engine interface is defined by the AuthorizationCallbacks structure and described in “Calling the Authorization Engine”.*/
enum {
   kAuthorizationCallbacksVersion =        0
};

/*AuthorizationSessionId

A unique value for an authorization session, provided by the authorization engine.

typedef void *AuthorizationSessionId;
Discussion

You can call the GetSessionID function to retrieve the authorization session ID.
Availability
Available in Mac OS X v10.4 and later.*/
typedef void *AuthorizationSessionId;

/*AuthorizationValue

Used to pass data between the authorization engine and the plug-in mechanism.

typedef struct AuthorizationValue {
UInt32          length;
void            *data;
} AuthorizationValue;*/
typedef struct AuthorizationValue {
UInt32          length;
void            *data;
} AuthorizationValue;

/*Authorization Context Flags

Defines flags that specify whether authentication data should be made available to the authorization client.

typedef UInt32 AuthorizationContextFlags;
enum {
   kAuthorizationContextFlagExtractable =  (1 << 0),
   kAuthorizationContextFlagVolatile =     (1 << 1)
};
Constants
kAuthorizationContextFlagExtractable

It is possible for the authorization client to use the AuthorizationCopyInfo function to obtain the value.

Available in Mac OS X v10.4 and later.
kAuthorizationContextFlagVolatile

The value is not saved for the authorization client.

Available in Mac OS X v10.4 and later.*/
typedef UInt32 AuthorizationContextFlags;
enum {
   kAuthorizationContextFlagExtractable =  (1 << 0),
   kAuthorizationContextFlagVolatile =     (1 << 1)
};

/*AuthorizationResult

The data type for the result of an authorization evaluation.

typedef UInt32 AuthorizationResult;
Discussion

The permissible values for an authorization result are enumerated in “Authorization Result”.
Availability
Available in Mac OS X v10.4 and later.*/
typedef UInt32 AuthorizationResult;

/*AuthorizationEngineRef

Handle passed from the authorization engine to an instance of a mechanism in a plug-in.

typedef struct __OpaqueAuthorizationEngine *AuthorizationEngineRef;
Discussion

The authorization engine passes one of these opaque handles to your plug-in when it calls your MechanismCreate function. Your mechanism must pass this handle back to the authorization engine when you call one of the engine’s callback functions (see “Calling the Authorization Engine”).
Availability
Available in Mac OS X v10.4 and later.*/
typedef struct __OpaqueAuthorizationEngine *AuthorizationEngineRef;


/*AuthorizationValueVector

Used to pass arguments from the authorization policy database to the authorization mechanism.

typedef struct AuthorizationValueVector {
UInt32              count;
AuthorizationValue  *values;
} AuthorizationValueVector;*/
typedef struct AuthorizationValueVector {
UInt32              count;
AuthorizationValue  *values;
} AuthorizationValueVector;

/*AuthorizationCallbacks

The interface implemented by the Security Server.

typedef struct AuthorizationCallbacks {
UInt32 version;
OSStatus (*SetResult)(
AuthorizationEngineRef inEngine,
AuthorizationResult inResult);
OSStatus (*RequestInterrupt)(
AuthorizationEngineRef inEngine);
OSStatus (*DidDeactivate)(
AuthorizationEngineRef inEngine);
OSStatus (*GetContextValue)(
AuthorizationEngineRef inEngine,
AuthorizationString inKey,
AuthorizationContextFlags *outContextFlags,
const AuthorizationValue **outValue);
OSStatus (*SetContextValue)(
AuthorizationEngineRef inEngine,
AuthorizationString inKey,
AuthorizationContextFlags inContextFlags,
const AuthorizationValue *inValue);
OSStatus (*GetHintValue)(
AuthorizationEngineRef inEngine,
AuthorizationString inKey,
const AuthorizationValue **outValue);
OSStatus (*SetHintValue)(
AuthorizationEngineRef inEngine,
AuthorizationString inKey,
const AuthorizationValue *inValue);
OSStatus (*GetArguments)(
AuthorizationEngineRef inEngine,
const AuthorizationValueVector **outArguments);
OSStatus (*GetSessionId)(
AuthorizationEngineRef inEngine,
AuthorizationSessionId *outSessionId);
} AuthorizationCallbacks;
Discussion

This structure is passed to your plug-in through the AuthorizationPluginCreate function. The functions defined by this structure are described in “Calling the Authorization Engine”.*/
typedef struct AuthorizationCallbacks {
UInt32 version;
OSStatus (*SetResult)(
AuthorizationEngineRef inEngine,
AuthorizationResult inResult);
OSStatus (*RequestInterrupt)(
AuthorizationEngineRef inEngine);
OSStatus (*DidDeactivate)(
AuthorizationEngineRef inEngine);
OSStatus (*GetContextValue)(
AuthorizationEngineRef inEngine,
AuthorizationString inKey,
AuthorizationContextFlags *outContextFlags,
const AuthorizationValue **outValue);
OSStatus (*SetContextValue)(
AuthorizationEngineRef inEngine,
AuthorizationString inKey,
AuthorizationContextFlags inContextFlags,
const AuthorizationValue *inValue);
OSStatus (*GetHintValue)(
AuthorizationEngineRef inEngine,
AuthorizationString inKey,
const AuthorizationValue **outValue);
OSStatus (*SetHintValue)(
AuthorizationEngineRef inEngine,
AuthorizationString inKey,
const AuthorizationValue *inValue);
OSStatus (*GetArguments)(
AuthorizationEngineRef inEngine,
const AuthorizationValueVector **outArguments);
OSStatus (*GetSessionId)(
AuthorizationEngineRef inEngine,
AuthorizationSessionId *outSessionId);
} AuthorizationCallbacks;

/*AuthorizationMechanismID

The mechanism ID specified in the authorization policy database is passed to the plug-in to create the appropriate mechanism.

typedef const AuthorizationString AuthorizationMechanismId;
Availability
Available in Mac OS X v10.4 and later.*/
typedef const AuthorizationString AuthorizationMechanismId;

/*AuthorizationMechanismRef

Handle passed by the plug-in to the authorization engine when creating an instance of a mechanism.

typedef void *AuthorizationMechanismRef;
Discussion

Your MechanismCreate function assigns this value and returns it to the authorization engine. The authorization engine passes this reference back to you in any subsequent calls to your MechanismInvoke, MechanismDeactivate, and MechanismDestroy functions.
Availability
Available in Mac OS X v10.4 and later.*/
typedef void *AuthorizationMechanismRef;

/*AuthorizationPluginInterface

The interface that must be implemented by your plug-in.

typedef struct AuthorizationPluginInterface
UInt32 version;
OSStatus (*PluginDestroy)(
AuthorizationPluginRef inPlugin);
OSStatus (*MechanismCreate)(
AuthorizationPluginRef inPlugin,
AuthorizationEngineRef inEngine,
AuthorizationMechanismId mechanismId,
AuthorizationMechanismRef *outMechanism);
OSStatus (*MechanismInvoke)(
AuthorizationMechanismRef inMechanism);
OSStatus (*MechanismDeactivate)(
AuthorizationMechanismRef inMechanism);
OSStatus (*MechanismDestroy)(
AuthorizationMechanismRef inMechanism);
} AuthorizationPluginInterface;
Discussion

Your plug-in passes this interface to the authorization engine through the AuthorizationPluginCreate function. The functions defined by this structure are described in “Functions Implemented By the Plug-in”.
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct AuthorizationPluginInterface {
UInt32 version;
OSStatus (*PluginDestroy)(
AuthorizationPluginRef inPlugin);
OSStatus (*MechanismCreate)(
AuthorizationPluginRef inPlugin,
AuthorizationEngineRef inEngine,
AuthorizationMechanismId mechanismId,
AuthorizationMechanismRef *outMechanism);
OSStatus (*MechanismInvoke)(
AuthorizationMechanismRef inMechanism);
OSStatus (*MechanismDeactivate)(
AuthorizationMechanismRef inMechanism);
OSStatus (*MechanismDestroy)(
AuthorizationMechanismRef inMechanism);
} AuthorizationPluginInterface;

#if defined(__cplusplus)
}
#endif

#endif
