#ifndef QTML_H
#define QTML_H

#ifndef CARBON_H
#include <Carbon/Carbon.h>
#endif

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#include <APPLE/QuickTime/QTML.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*General Utilities

These general utilities convert handles and strings from one form to another:
GetPictFromDIB creates a Macintosh QuickDraw PicHandle from a handle to a Windows DIB.
GetDIBFromPict creates a handle to a DIB from a PicHandle.
NativeRegionToMacRegion converts a Windows HRGN to a Mac region handle.
MacRegionToNativeRegion converts a Mac region handle to a Windows HRGN.
NativeEventToMacEvent converts Win32 messages to Macintosh events. (An earlier version, WinEventToMacEvent, is now a macro that calls NativeEventToMacEvent).
c2pstr converts a C-formatted string to Pascal format in place.
p2cstr converts a Pascal-formatted string to C format in place.*/
#define WinEventToMacEvent  NativeEventToMacEvent

/*QTMLMutex

Represents a type used by the Windows API API.

typedef long QTMLMutex;
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
typedef long QTMLMutex;

/*QTMLGrabMutex

Confers ownership of a mutex created by QTMLCreateMutex.

void QTMLGrabMutex (
   QTMLMutex    mu );
Parameters
mu

A mutex object.
Discussion

Call this function when you require exclusive ownership of the resource guarded by a mutex. This function will return when you have gained this ownership. In the case where another thread or process holds the mutex, this function waits until that process or thread relinquishes control. If you need to determine if you can grab the mutex, without actually grabbing it, call QTMLTryGrabMutex.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
void QTMLGrabMutex (
   QTMLMutex    mu );

/*QTMLCreateMutex

Creates a synchronization object to facilitate mutually exclusive access to a Windows data structure.

QTMLMutex QTMLCreateMutex ( void );
Discussion

This function creates a mutex object for guarded access to data structures and routines that require mutually exclusive access. In a multithreaded preemptive environment, such as Windows NT, you can use the various mutex utility functions such as QTMLGrabMutex to protect a shared resource from simultaneous access by multiple threads or processes. Mutex objects are used throughout QTML to provide such protection.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
QTMLMutex QTMLCreateMutex ( void );

/*QTMLDestroyMutex

Deallocates a synchronization object created by QTMLCreateMutex.

void QTMLDestroyMutex (
   QTMLMutex    mu );
Parameters
mu

A mutex object.
Discussion

Call this function to deallocate the mutex object created by QTMLCreateMutex.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
void QTMLDestroyMutex (
   QTMLMutex    mu );

/*QTMLReturnMutex

Releases ownership of a QTMLMutex object.

void QTMLReturnMutex (
   QTMLMutex    mu );
Parameters
mu

A mutex object.
Discussion

Call this function to balance a call to QTMLGrabMutex when you are ready to relinquish control of the mutex and corresponding shared resource. By making this call, you allow other processes or threads waiting for the release of this mutex to gain access.
Version Notes

Introduced in QuickTime 3 or earlier.
Availability
Available in Mac OS X v10.3 and later.
Declared In
QTML.h*/
void QTMLReturnMutex (
   QTMLMutex    mu );

/*initializing and Terminating QTML and QuickTime

Before your program can perform any QuickTime operations, you must initialize the QuickTime Media Layer and then QuickTime itself. The first is accomplished by calling a routine named InitializeQTML, the second with EnterMovies.

InitializeQTML must be called at the very beginning of your program, before any other QuickTime call. The recommended place to call it is in your WinMain function, before creating your main window. The function is defined as follows:OSErr InitializeQTML (long flag);*/
OSErr InitializeQTML (long flag);

/*On the Windows platform, however, your window is normally designated by a Windows-style handle (HWND) rather than a QTML pointer (CWindowPtr). To allow QuickTime to draw into the window, you must first register it with QTML by calling the QTML routine CreatePortAssociation.
void CreatePortAssociation
        (void  *theWnd,
         Ptr   storage
         long  flags);


This creates a graphics port and associates it with this window in an internal data structure maintained by QTML. The first parameter (theWnd) is your Windows-style window handle, of type HWND. The second parameter (storage) allows you to supply your own storage for the CGrafPort record, if you wish. Generally, you will always pass nil, allowing the call to allocate memory. (If you leave this parameter null, QTML will allocate the space for you.)*/
void CreatePortAssociation
        (void  *theWnd,
         Ptr   storage,
         long  flags);

/*gain, you can test the result and do whatever is appropriate in case of failure.

At the end of the program, your initialization calls to InitializeQTML and EnterMovies should be balanced by corresponding calls to the termination routines ExitMovies and TerminateQTML. Both of these functions take no parameters and return no result.void ExitMovies (void)
void TerminateQTML (void)*/
void TerminateQTML (void);

#ifdef __cplusplus
}
#endif
#endif