#ifndef  ATSUNICODEGLYPHS_H
#define ATSUNICODEGLYPHS_H

#ifndef  ATSUNICODETYPES_H
#include <QD/ATSUnicodeTypes.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*ATSQuadraticClosePathProcPtr

Defines a pointer to a quadratic close-path callback for drawing glyphs that overrides ATSUI’s quadratic close-path operation for drawing glyphs.

typedef OSStatus(* ATSQuadraticClosePathProcPtr)
(
   void *callBackDataPtr
);

If you name your function MyATSQuadraticClosePathCallback, you would declare it like this:

OSStatus MyATSQuadraticClosePathCallback
(
   void *callBackDataPtr
);

Parameters
callBackDataPtr

A pointer to any data your callback function needs. You pass this pointer to the function ATSUGlyphGetQuadraticPaths. Then, ATSUI passes the pointer through to your callback function when your callback function is invoked.
Return Value

A value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetQuadraticPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr.
Discussion

You supply a pointer to your customized quadratic close-path callback as a parameter to the function ATSUGlyphGetQuadraticPaths.

To provide a pointer to your quadratic close-path callback, you create a universal procedure pointer (UPP) of type ATSQuadraticClosePathUPP, using the function NewATSQuadraticClosePathUPP. You can do so with code similar to the following:ATSQuadraticClosePathUPP MyQuadraticClosePathUPP;
MyQuadraticClosePathUPP = NewATSQuadraticClosePathUPP  (&MyATSQuadraticClosePathCallback);


When you no longer need to use your quadratic close-path callback, you should use the function DisposeATSQuadraticClosePathUPP to dispose of the universal procedure pointer associated with the callback.*/
typedef OSStatus(* ATSQuadraticClosePathProcPtr)
(
   void *callBackDataPtr
);

/*ATSQuadraticClosePathUPP

Defines a universal procedure pointer to a quadratic close-path callback. 

typedef ATSQuadraticClosePathProcPtr ATSQuadraticClosePathUPP;
Discussion

For more information, see the description of the ATSQuadraticClosePathProcPtr callback function.*/
typedef ATSQuadraticClosePathProcPtr ATSQuadraticClosePathUPP;

/*ATSQuadraticCurveProcPtr

Defines a pointer to a quadratic curve callback for drawing glyphs that overrides ATSUI’s quadratic curve operation for drawing glyphs.

typedef OSStatus(* ATSQuadraticCurveProcPtr)
(
   const Float32Point *pt1,
   const Float32Point *controlPt,
   const Float32Point *pt2,
   void *callBackDataPtr
);

If you name your function MyATSQuadraticCurveCallback, you would declare it like this:

OSStatus MyATSQuadraticCurveCallback (
   const Float32Point *pt1,
   const Float32Point *controlPt,
   const Float32Point *pt2,
   void *callBackDataPtr
);

Parameters
pt1

A Float32Point data structure that contains the x and y coordinates for the relative point that defines the start of the curve (an on-curve point) for this segment of the glyph.
controlPt

A Float32Point data structure that contains the x and y coordinates for the relative point that defines the control point (an off-curve point) for this segment of the glyph.
pt2

A Float32Point data structure that contains the x and y coordinates for the relative point that defines the end of the curve (an on-curve point) for this segment of the glyph.
callBackDataPtr

A pointer to any data your callback function needs. You pass this pointer to the function ATSUGlyphGetQuadraticPaths. Then, ATSUI passes the pointer through to your callback function when your callback function is invoked.
Return Value

A value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetQuadraticPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr.
Discussion

You supply a pointer to your customized quadratic curve callback as a parameter to the function ATSUGlyphGetQuadraticPaths.

To provide a pointer to your quadratic curve callback, you create a universal procedure pointer (UPP) of type ATSQuadraticCurveUPP, using the function NewATSQuadraticCurveUPP. You can do so with code similar to the following:ATSQuadraticCurveUPP MyQuadraticCurveUPP;
MyQuadraticCurveUPP = NewATSQuadraticCurveUPP (&MyATSQuadraticCurveCallback);


When you no longer need to use your quadratic curve callback, you should use the function DisposeATSQuadraticCurveUPP to dispose of the universal procedure pointer associated with the callback.*/
typedef OSStatus(* ATSQuadraticCurveProcPtr)
(
   const Float32Point *pt1,
   const Float32Point *controlPt,
   const Float32Point *pt2,
   void *callBackDataPtr
);

/*ATSQuadraticCurveUPP

Defines a universal procedure pointer to a quadratic curve callback.

typedef ATSQuadraticCurveProcPtr ATSQuadraticCurveUPP;
Discussion

For more information, see the description of the ATSQuadraticCurveProcPtr callback function.*/
typedef ATSQuadraticCurveProcPtr ATSQuadraticCurveUPP;

/*ATSQuadraticLineProcPtr

Defines a pointer to a quadratic line callback for drawing glyphs that overrides ATSUI’s quadratic line operation for drawing glyphs.

typedef OSStatus(* ATSQuadraticLineProcPtr)
(
   const Float32Point *pt1,
   const Float32Point *pt2,
   void *callBackDataPtr
);

If you name your function MyATSQuadraticLineCallback, you would declare it like this:

OSStatus MyATSQuadraticLineCallback (
   const Float32Point *pt1,
   const Float32Point *pt2,
   void *callBackDataPtr
);

Parameters
pt1

A Float32Point data structure that contains the x and y coordinates for the relative point that defines the start of the line for this segment of the glyph.
pt2

A Float32Point data structure that contains the x and y coordinates for the relative point that defines the end of the line for this segment of the glyph.
callBackDataPtr

A pointer to any data your callback function needs. You pass this pointer to the function ATSUGlyphGetQuadraticPaths. Then, ATSUI passes the pointer through to your callback function when your callback function is invoked.
Return Value

A value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetQuadraticPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr.
Discussion

You supply a pointer to your customized quadratic line callback as a parameter to the function ATSUGlyphGetQuadraticPaths.

To provide a pointer to your quadratic line callback, you create a universal procedure pointer (UPP) of type ATSQuadraticLineUPP, using the function NewATSQuadraticLineUPP. You can do so with code similar to the following:ATSQuadraticLineUPP MyQuadraticLineUPP;
MyQuadraticLineUPP = NewATSQuadraticLineUPP (&MyATSQuadraticLineCallback);


When you no longer need to use your quadratic line callback, you should use the function DisposeATSQuadraticLineUPP to dispose of the universal procedure pointer associated with the callback.*/
typedef OSStatus(* ATSQuadraticLineProcPtr)
(
   const Float32Point *pt1,
   const Float32Point *pt2,
   void *callBackDataPtr
);

/*ATSQuadraticLineUPP

Defines a universal procedure pointer to a quadratic line callback.

typedef ATSQuadraticLineProcPtr ATSQuadraticLineUPP;

Discussion

For more information, see the description of the ATSQuadraticLineProcPtr callback function.*/
typedef ATSQuadraticLineProcPtr ATSQuadraticLineUPP;

/*ATSQuadraticNewPathProcPtr

Defines a pointer to a quadratic new-path callback for drawing glyphs that overrides ATSUI’s quadratic new-path operation for drawing glyphs.

typedef OSStatus(* ATSQuadraticNewPathProcPtr)
(
   void *callBackDataPtr
);

If you name your function MyATSQuadraticNewPathCallback, you would declare it like this:

OSStatus MyATSQuadraticNewPathCallback
(
   void *callBackDataPtr
);

Parameters
callBackDataPtr

A pointer to any data your callback function needs. You pass this pointer to the function ATSUGlyphGetQuadraticPaths. Then, ATSUI passes the pointer through to your callback function when your callback function is invoked.
Return Value

A value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetQuadraticPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr.
Discussion

You supply a pointer to your customized quadratic new-path callback as a parameter to the function ATSUGlyphGetQuadraticPaths.

To provide a pointer to your quadratic new-path callback, you create a universal procedure pointer (UPP) of type ATSQuadraticNewPathUPP, using the function NewATSQuadraticNewPathUPP. You can do so with code similar to the following:ATSQuadraticNewPathUPP MyQuadraticNewPathUPP;
MyQuadraticNewPathUPP = NewATSQuadraticNewPathUPP  (&MyATSQuadraticNewPathCallback);


When you no longer need to use your quadratic new-path callback, you should use the function DisposeATSQuadraticNewPathUPP to dispose of the universal procedure pointer associated with the callback.*/
typedef OSStatus(* ATSQuadraticNewPathProcPtr)
(
   void *callBackDataPtr
);


/*ATSQuadraticNewPathUPP

Defines a universal procedure pointer to a quadratic new-path callback.

typedef ATSQuadraticNewPathProcPtr ATSQuadraticNewPathUPP;
Discussion

For more information, see the description of the ATSQuadraticNewPathProcPtr callback function.*/
typedef ATSQuadraticNewPathProcPtr ATSQuadraticNewPathUPP;

/*ATSCubicMoveToProcPtr

Defines a pointer to a cubic move-to function for drawing glyphs that overrides ATSUI’s cubic move-to operation for drawing glyphs.

typedef OSStatus(* ATSCubicMoveToProcPtr)
(
   const Float32Point *pt,
   void *callBackDataPtr
);

If you name your function MyATSCubicMoveToCallback, you would declare it like this:

OSStatus MyATSCubicMoveToCallback (
   const Float32Point *pt,
   void *callBackDataPtr
);

Parameters
pt

A Float32Point data structure that contains the x and y coordinates for the relative point to which the pen should move before it begins drawing this segment of the glyph.
callBackDataPtr

A pointer to any data your callback function needs. You pass this pointer to the function ATSUGlyphGetCurvePaths. Then, ATSUI passes the pointer through to your callback function when your callback function is invoked. 
Return Value

A value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetCubicPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr.
Discussion

You supply a pointer to your customized cubic move-to callback as a parameter to the function ATSUGlyphGetCubicPaths.

To provide a pointer to your cubic move-to callback, you create a universal procedure pointer (UPP) of type ATSCubicMoveToUPP, using the function NewATSCubicMoveToUPP. You can do so with code similar to the following:ATSCubicMoveToUPP MyCubicMoveToUPP;
MyCubicMoveToUPP = ATSCubicMoveToUPP (&MyATSCubicMoveToCallback);


When you no longer need to use your cubic move-to callback, you should use the function DisposeATSCubicMoveToUPP to dispose of the universal procedure pointer associated with the callback.*/
typedef OSStatus(* ATSCubicMoveToProcPtr)
(
   const Float32Point *pt,
   void *callBackDataPtr
);

/*ATSCubicMoveToUPP

Defines a universal procedure pointer to a cubic move-to callback. 

typedef ATSCubicMoveToProcPtr ATSCubicMoveToUPP;
Discussion

For more information, see the description of the ATSCubicMoveToProcPtr callback function.*/
typedef ATSCubicMoveToProcPtr ATSCubicMoveToUPP;

/*ATSCubicLineToProcPtr

Defines a pointer to a cubic line-to callback for drawing glyphs that overrides ATSUI’s cubic line-to operation for drawing glyphs.

typedef OSStatus(* ATSCubicLineToProcPtr)
(
   const Float32Point *pt,
   void *callBackDataPtr
);

If you name your function MyATSCubicLineToCallback, you would declare it like this:

OSStatus MyATSCubicLineToCallback (
   const Float32Point *pt,
   void *callBackDataPtr
);

Parameters
pt

A Float32Point data structure that contains the x and y coordinates for the relative point to which the pen should draw a line. 
callBackDataPtr

A pointer to any data your callback function needs. You pass this pointer to the function ATSUGlyphGetCurvePaths. Then, ATSUI passes the pointer through to your callback function when your callback function is invoked.
Return Value

A value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetCubicPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr.
Discussion

You supply a pointer to your customized cubic line-to callback as a parameter to the function ATSUGlyphGetCubicPaths.

To provide a pointer to your cubic line-to callback, you create a universal procedure pointer (UPP) of type ATSCubicLineToUPP, using the function NewATSCubicLineToUPP. You can do so with code similar to the following:ATSCubicLineToUPP MyCubicLineToUPP;
MyCubicLineToUPP = NewATSCubicLineToUPP (&MyATSCubicLineToCallback);


When you no longer need to use your cubic line-to callback, you should use the function DisposeATSCubicLineToUPP to dispose of the universal procedure pointer associated with the callback.*/
typedef OSStatus(* ATSCubicLineToProcPtr)
(
   const Float32Point *pt,
   void *callBackDataPtr
);

typedef ATSCubicLineToProcPtr        ATSCubicLineToUPP;

/*ATSCubicClosePathProcPtr

Defines a pointer to a cubic close-path callback for drawing glyphs that overrides ATSUI’s cubic close-path operation for drawing glyphs.

typedef OSStatus(* ATSCubicClosePathProcPtr)
(
   void *callBackDataPtr
);

If you name your function MyATSCubicClosePathCallback, you would declare it like this:

OSStatus MyATSCubicClosePathCallback (
   void *callBackDataPtr
);

Parameters
callBackDataPtr

A pointer to any data your callback function needs. You pass this pointer to the function ATSUGlyphGetCurvePaths. Then, ATSUI passes the pointer through to your callback function when your callback function is invoked.
Return Value

A value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetCubicPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr.
Discussion

You supply a pointer to your customized cubic close-path callback as a parameter to the function ATSUGlyphGetCubicPaths.

To provide a pointer to your cubic close-path callback, you create a universal procedure pointer (UPP) of type ATSCubicClosePathUPP, using the function NewATSCubicClosePathUPP. You can do so with code similar to the following:ATSCubicClosePathUPP MyCubicClosePathUPP;
MyCubicClosePathUPP = NewATSCubicClosePathUPP (&MyATSCubicClosePathCallback);


When you no longer need to use your cubic close-path callback, you should use the function DisposeATSCubicClosePathUPP to dispose of the universal procedure pointer associated with the callback.*/
typedef OSStatus(* ATSCubicClosePathProcPtr)
(
   void *callBackDataPtr
);


/*ATSCubicClosePathUPP

Defines a universal procedure pointer to a cubic close-path callback.

typedef ATSCubicClosePathProcPtr ATSCubicClosePathUPP;

Discussion

For more information, see the description of the ATSCubicClosePathProcPtr callback function.*/
typedef ATSCubicClosePathProcPtr ATSCubicClosePathUPP;

/*ATSCubicCurveToProcPtr

Defines a pointer to a cubic curve-to callback for drawing glyphs that overrides ATSUI’s cubic curve-to operation for drawing glyphs.

typedef OSStatus(* ATSCubicCurveToProcPtr)
(
   const Float32Point *pt1,
   const Float32Point *pt2,
   const Float32Point *pt3,
   void *callBackDataPtr
);

If you name your function MyATSCubicCurveToCallback, you would declare it like this:

OSStatus MyATSCubicCurveToCallback (
   const Float32Point *pt1,
   const Float32Point *pt2,
   const Float32Point *pt3,
   void *callBackDataPtr
);

Parameters
pt1

A Float32Point data structure that contains the x and y coordinates for the relative point that defines the first off-curve point for this segment of the glyph.
pt2

A Float32Point data structure that contains the x and y coordinates for the relative point that defines the second off-curve point for this segment of the glyph.
pt3

A Float32Point data structure that contains the x and y coordinates for the relative point that defines the end of the curve (an on-curve point) for this segment of the glyph.
callBackDataPtr

A pointer to any data your callback function needs. You pass this pointer to the function ATSUGlyphGetCurvePaths. Then, ATSUI passes the pointer through to your callback function when your callback function is invoked.
Return Value

A value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetCubicPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr.
Discussion

You supply a pointer to your customized cubic curve-to function as a parameter to the function ATSUGlyphGetCubicPaths.

To provide a pointer to your cubic curve-to callback, you create a universal procedure pointer (UPP) of type ATSCubicCurveToUPP, using the function NewATSCubicCurveToUPP. You can do so with code similar to the following:ATSCubicCurveToUPP MyCubicCurveToUPP;
MyCubicCurveToUPP = NewATSCubicCurveToUPP (&MyATSCubicCurveToCallback);


When you no longer need to use your cubic curve-to callback, you should use the function DisposeATSCubicCurveToUPP to dispose of the universal procedure pointer associated with the callback.*/
typedef OSStatus(* ATSCubicCurveToProcPtr)
(
   const Float32Point *pt1,
   const Float32Point *pt2,
   const Float32Point *pt3,
   void *callBackDataPtr
);


/*ATSCubicCurveToUPP

Defines a universal procedure pointer to a cubic curve-to callback.

typedef ATSCubicCurveToProcPtr ATSCubicCurveToUPP;
Discussion

For more information, see the description of the ATSCubicCurveToProcPtr callback function.*/
typedef ATSCubicCurveToProcPtr ATSCubicCurveToUPP;

//function

/*ATSUGetNativeCurveType

Obtains the type of outline path used for glyphs associated with a given style object.

OSStatus ATSUGetNativeCurveType (
   ATSUStyle iATSUStyle,
   ATSCurveType *oCurveType
);
Parameters
iATSUStyle

An ATSUStyle value specifying the style object to examine. 
oCurveType

A pointer to an ATSCurveType value. On return, the value provides a constant specifying the type of outline path being used. Possible values include kATSCubicCurveType, kATSQuadCurveType, and kATSOtherCurveType. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

You can call the ATSUGetNativeCurveType function to obtain the type of outline path used for glyphs associated with a given style object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
OSStatus ATSUGetNativeCurveType (
   ATSUStyle iATSUStyle,
   ATSCurveType *oCurveType
);

/*ATSUGetGlyphInfo

Obtains a copy of the style and layout information for each glyph in a line. (Deprecated in Mac OS X v10.3. Use functions from “Accessing Glyph Data” instead.)

Not recommended.

OSStatus ATSUGetGlyphInfo (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineStart,
   UniCharCount iLineLength,
   ByteCount *ioBufferSize,
   ATSUGlyphInfoArray *oGlyphInfoPtr
);

Parameters
iTextLayout

An ATSUTextLayout value specifying the text layout object to examine. 
iLineStart

A UniCharArrayOffset value specifying the offset from the beginning of the text buffer to the first character of the line to examine. To indicate that the line starts at the beginning of the text buffer, you can pass the constant kATSUFromTextBeginning. To specify the entire text buffer, pass kATSUFromTextBeginning in this parameter and kATSUToTextEnd in the iLineLength parameter. 
iLineLength

A UniCharCount value specifying the length of the line. If you want the line to extend to the end of the text buffer, you can pass the constant kATSUToTextEnd.
ioBufferSize

A pointer to a ByteCount value specifying the size of the buffer you have allocated for the ATSUGlyphInfoArray structure produced in the oGlyphInfoPtr parameter. On return, the value specifies the actual size of the ATSUGlyphInfoArray structure.
oGlyphInfoPtr

A pointer to an ATSUGlyphInfoArray structure. On return, the structure contains values identifying the text layout object, the number of glyphs in the specified line, and an array of ATSUGlyphInfo structures for each of the glyphs. Each ATSUGlyphInfo structure contains information identifying the glyph, the style object with which it is associated, and other related layout values. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The ATSUGetGlyphInfo function obtains a copy of the style and layout information for each glyph in a line of text. Copying can be slow, so it’s best to use this function only if you do not plan to modify the glyph information. If you do modify the glyph information, you can only draw the modified glyphs by calling the function ATSUDrawGlyphInfo. Because you are working with a copy of the glyph data and not the actual data that ATSUI has, if you try to draw text by calling the ATSUDrawText function, none of the changes you make to the glyph information will be reflected in the drawn text. 

Note that is you obtain glyph information with the function ATSUGetGlyphInfo and then draw glyphs using ATSUDrawGlyphInfo, ATSUI does not take synthetic styles into account when it draw. This means that font substitution will not work.

If you want to modify glyph information you should instead use the ATSUI direct-access functions ATSUGlyphGetQuadraticPaths or ATSUGlyphGetCubicPaths. You use each of these functions along with callback functions you supply for drawing the glyphs. When you modify and draw glyphs using ATSUI’s direct-access functions, you obtain access to the same information as that supplied by the function ATSUGetGlyphInfo, but in a way that allows font substitution to work. For more information on retrieving and drawing glyph outlines, see Inside Mac OS X: Rendering Unicode Text With ATSUI.

The Unicode characters in the text layout object (ATSUTextLayout) and the glyphs returned by the function ATSUGetGlyphInfo do not necessarily have a one-to-one correspondence. For example, the accented Latin character é can be represented by an e with a combining ´ accent. In this case, two characters map to one glyph.

Common ligatures such as ﬁ also form automatically for some fonts, causing two characters to map to one glyph. Right-to-left scripts such as Arabic, and complex scripts such as Devanagari or Thai have even more complicated mappings from characters to glyphs.

For this reason it's best to use the high level ATSUI functions whenever possible, and to associate a paragraph of text with a text layout object. Your application is then completely insulated from such issues.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.3.
Declared In
ATSUnicodeGlyphs.h*/
OSStatus ATSUGetGlyphInfo (
   ATSUTextLayout iTextLayout,
   UniCharArrayOffset iLineStart,
   UniCharCount iLineLength,
   ByteCount *ioBufferSize,
   ATSUGlyphInfoArray *oGlyphInfoPtr
);

/*DisposeATSQuadraticClosePathUPP

Disposes of a universal procedure pointer (UPP) to a quadratic close-path callback.

void DisposeATSQuadraticClosePathUPP (
   ATSQuadraticClosePathUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSQuadraticClosePathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSQuadraticClosePathUPP (
   ATSQuadraticClosePathUPP userUPP
);

/*DisposeATSQuadraticCurveUPP

Disposes of a universal procedure pointer (UPP) to a quadratic curve callback.

void DisposeATSQuadraticCurveUPP (
   ATSQuadraticCurveUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSQuadraticCurveProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSQuadraticCurveUPP (
   ATSQuadraticCurveUPP userUPP
);

/*DisposeATSQuadraticLineUPP

Disposes of a universal procedure pointer (UPP) to a quadratic line callback.

void DisposeATSQuadraticLineUPP (
   ATSQuadraticLineUPP userUPP
);
Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSQuadraticLineProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSQuadraticLineUPP (
   ATSQuadraticLineUPP userUPP
);

/*DisposeATSQuadraticNewPathUPP

Disposes of a universal procedure pointer (UPP) to a quadratic new-path callback.

void DisposeATSQuadraticNewPathUPP (
   ATSQuadraticNewPathUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSQuadraticNewPathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/

void DisposeATSQuadraticNewPathUPP (
   ATSQuadraticNewPathUPP userUPP
);

/*ATSUGlyphGetQuadraticPaths

Obtains the quadratic outline paths for a glyph.

OSStatus ATSUGlyphGetQuadraticPaths (
   ATSUStyle iATSUStyle,
   GlyphID iGlyphID,
   ATSQuadraticNewPathUPP iNewPathProc,
   ATSQuadraticLineUPP iLineProc,
   ATSQuadraticCurveUPP iCurveProc,
   ATSQuadraticClosePathUPP iClosePathProc,
   void *iCallbackDataPtr,
   OSStatus *oCallbackResult
);

Parameters
iATSUStyle

An ATSUStyle value specifying the style object to examine. 
iGlyphID

A GlyphID value identifying the glyph for which to obtain an outline path. 
iNewPathProc

A pointer to your callback function for handling the new-path operation.
iLineProc

A pointer to your callback function for handling the line operation.
iCurveProc

A pointer to your callback function for handling the curve operation.
iClosePathProc

A pointer to your callback function for handling the close-path operation.
iCallbackDataPtr

A pointer to any data your callback functions need. This pointer is passed through to your callback functions.
oCallbackResult

On output, a value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetQuadraticPaths function stops parsing the path outline and returns the result kATSOutlineParseAbortedErr. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The glyph outlines that are returned are the hinted outlines at the font size specified in the style object. If you want to use unhinted outlines, set the font size to a very large size, (for example, 1000 points) and then scale down the returned curves to the desired size.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
OSStatus ATSUGlyphGetQuadraticPaths (
   ATSUStyle iATSUStyle,
   GlyphID iGlyphID,
   ATSQuadraticNewPathUPP iNewPathProc,
   ATSQuadraticLineUPP iLineProc,
   ATSQuadraticCurveUPP iCurveProc,
   ATSQuadraticClosePathUPP iClosePathProc,
   void *iCallbackDataPtr,
   OSStatus *oCallbackResult
);

/*NewATSQuadraticClosePathUPP

Creates a new universal procedure pointer (UPP) to a quadratic close-path callback.

ATSQuadraticClosePathUPP NewATSQuadraticClosePathUPP (
   ATSQuadraticClosePathProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your quadratic close-path callback. 
Return Value

On return, a UPP to the quadratic close-path callback.
Discussion

See the callback ATSQuadraticClosePathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSQuadraticClosePathUPP NewATSQuadraticClosePathUPP (
   ATSQuadraticClosePathProcPtr userRoutine
);

/*NewATSQuadraticCurveUPP

Creates a new universal procedure pointer (UPP) to a quadratic curve callback.

ATSQuadraticCurveUPP NewATSQuadraticCurveUPP (
   ATSQuadraticCurveProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your quadratic curve callback. 
Return Value

On return, a UPP to the quadratic curve callback.
Discussion

See the callback ATSQuadraticCurveProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSQuadraticCurveUPP NewATSQuadraticCurveUPP (
   ATSQuadraticCurveProcPtr userRoutine
);

/*NewATSCubicMoveToUPP

Creates a new universal procedure pointer (UPP) to a cubic move-to callback.

ATSCubicMoveToUPP NewATSCubicMoveToUPP (
   ATSCubicMoveToProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your cubic move-to callback. 
Return Value

On return, a UPP to the cubic move-to callback.
Discussion

See the callback ATSCubicMoveToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSCubicMoveToUPP NewATSCubicMoveToUPP (
   ATSCubicMoveToProcPtr userRoutine
);

/*NewATSQuadraticLineUPP

Creates a new universal procedure pointer (UPP) to a quadratic line callback.

ATSQuadraticLineUPP NewATSQuadraticLineUPP (
   ATSQuadraticLineProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your quadratic line callback. 
Return Value

On return, a UPP to the quadratic line callback.
Discussion

See the callback ATSQuadraticLineProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSQuadraticLineUPP NewATSQuadraticLineUPP (
   ATSQuadraticLineProcPtr userRoutine
);

/*NewATSQuadraticNewPathUPP

Creates a new universal procedure pointer (UPP) to a quadratic new-path callback.

ATSQuadraticNewPathUPP NewATSQuadraticNewPathUPP (
   ATSQuadraticNewPathProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your quadratic new-path callback. 
Return Value

On return, a UPP to the quadratic new-path callback.
Discussion

See the callback ATSQuadraticNewPathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSQuadraticNewPathUPP NewATSQuadraticNewPathUPP (
   ATSQuadraticNewPathProcPtr userRoutine
);

/*NewATSCubicLineToUPP

Creates a new universal procedure pointer (UPP) to a cubic line-to callback.

ATSCubicLineToUPP NewATSCubicLineToUPP (
   ATSCubicLineToProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your cubic line-to callback. 
Return Value

On return, a UPP to the cubic line-to callback.
Discussion

See the callback ATSCubicLineToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSCubicLineToUPP NewATSCubicLineToUPP (
   ATSCubicLineToProcPtr userRoutine
);

/*DisposeATSCubicClosePathUPP

Disposes of a universal procedure pointer (UPP) to a cubic close-path callback.

void DisposeATSCubicClosePathUPP (
   ATSCubicClosePathUPP userUPP
);
Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSCubicClosePathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSCubicClosePathUPP (
   ATSCubicClosePathUPP userUPP
);

/*DisposeATSCubicCurveToUPP

Disposes of a universal procedure pointer (UPP) to a cubic curve-to callback.

void DisposeATSCubicCurveToUPP (
   ATSCubicCurveToUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSCubicCurveToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/

void DisposeATSCubicCurveToUPP (
   ATSCubicCurveToUPP userUPP
);

/*NewATSCubicClosePathUPP

Creates a new universal procedure pointer (UPP) to a cubic close-path callback.

ATSCubicClosePathUPP NewATSCubicClosePathUPP (
   ATSCubicClosePathProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your cubic close-path callback. 
Return Value

On return, a UPP to the cubic close-path callback.
Discussion

See the callback ATSCubicClosePathProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSCubicClosePathUPP NewATSCubicClosePathUPP (
   ATSCubicClosePathProcPtr userRoutine
);


/*ATSUGlyphGetCubicPaths

Obtains the cubic outline paths for a glyph.

OSStatus ATSUGlyphGetCubicPaths (
   ATSUStyle iATSUStyle,
   GlyphID iGlyphID,
   ATSCubicMoveToUPP iMoveToProc,
   ATSCubicLineToUPP iLineToProc,
   ATSCubicCurveToUPP iCurveToProc,
   ATSCubicClosePathUPP iClosePathProc,
   void *iCallbackDataPtr,
   OSStatus *oCallbackResult
);
Parameters
iATSUStyle

An ATSUStyle value specifying the style object to examine. 
iGlyphID

A GlyphID value identifying the glyph for which to obtain an outline path. 
iMoveToProc

A pointer to your callback function for handling the pen move-to operation.
iLineToProc

A pointer to your callback function for handling the line-to operation.
iCurveToProc

A pointer to your callback function for handling the curve-to operation.
iClosePathProc

A pointer to your callback function for handling the close-path operation.
iCallbackDataPtr

A pointer to any data your callback functions need. This pointer is passed through to your callback functions.
oCallbackResult

On output, a value that indicates the status of your callback function. When a callback function returns any value other than 0, the ATSGlyphGetCubicPaths function stops parsing the glyph path outline and returns the result kATSOutlineParseAbortedErr. 
Return Value

A result code. See “ATSUI Result Codes”.
Discussion

The glyph outlines that are returned are the hinted outlines at the font size specified in the style object. If you want to use unhinted outlines, set the font size to a very large size, (for example, 1000 points) and then scale down the returned curves to the desired size.

As of Mac OS X version 10.1, the curves returned by this function are derived from quadratic curves, irrespective of the native curve type of the font.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/


OSStatus ATSUGlyphGetCubicPaths (
   ATSUStyle iATSUStyle,
   GlyphID iGlyphID,
   ATSCubicMoveToUPP iMoveToProc,
   ATSCubicLineToUPP iLineToProc,
   ATSCubicCurveToUPP iCurveToProc,
   ATSCubicClosePathUPP iClosePathProc,
   void *iCallbackDataPtr,
   OSStatus *oCallbackResult
);

/*DisposeATSCubicMoveToUPP

Disposes of a universal procedure pointer (UPP) to a cubic move-to callback.

void DisposeATSCubicMoveToUPP (
   ATSCubicMoveToUPP userUPP
);

Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSCubicMoveToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSCubicMoveToUPP (
   ATSCubicMoveToUPP userUPP
);

/*DisposeATSCubicLineToUPP

Disposes of a universal procedure pointer (UPP) to a cubic line-to callback.

void DisposeATSCubicLineToUPP (
   ATSCubicLineToUPP userUPP
);
Parameters
userUPP

The universal procedure pointer.
Discussion

See the callback ATSCubicLineToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
void DisposeATSCubicLineToUPP (
   ATSCubicLineToUPP userUPP
);

/*NewATSCubicCurveToUPP

Creates a new universal procedure pointer (UPP) to a cubic curve-to callback.

ATSCubicCurveToUPP NewATSCubicCurveToUPP (
   ATSCubicCurveToProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your cubic curve-to callback. 
Return Value

On return, a UPP to the cubic curve-to callback.
Discussion

See the callback ATSCubicCurveToProcPtr for more information.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ATSUnicodeGlyphs.h*/
ATSCubicCurveToUPP NewATSCubicCurveToUPP (
   ATSCubicCurveToProcPtr userRoutine
);


#ifdef __cplusplus
}
#endif

#endif