#ifndef OSAGENERIC_H
#define OSAGENERIC_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef OSA_H
#include <OpenScripting/OSA.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*OSAGenericToRealID

Converts a generic script ID to the corresponding component-speciﬁc script ID. 

OSAError OSAGenericToRealID (
   ComponentInstance genericScriptingComponent,
   OSAID * theScriptID,
   ComponentInstance * theExactComponent
);
Parameters
genericScriptingComponent

A component instance for the generic scripting component, created by a prior call to the Component Manager function OpenDefaultComponent or OpenComponent. 
theScriptID

A pointer to the generic script ID that you want to convert. The OSAGenericToRealID function returns, in this parameter, the component-speciﬁc script ID that corresponds to the generic script ID that you pass in this parameter. See the OSAID data type.
theExactComponent

On return, a pointer to the component instance that created the script ID returned in the theScriptID parameter. 
Return Value

A result code. See “Result Codes”.
Discussion

You can’t use the generic scripting component and a generic script ID with component-speciﬁc routines. Instead, you can use the component instance and script ID returned by OSAGenericToRealID. 

Given a generic script ID (that is, a script ID returned by a call to a standard component routine via the generic scripting component), the OSAGenericToRealID function returns the equivalent component-speciﬁc script ID and the component instance that created that script ID. The OSAGenericToRealID function modiﬁes the script ID in place, changing the generic script ID you pass in the theScriptID parameter to the corresponding component-speciﬁc script ID. 
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
OSAGeneric.h*/
OSAError OSAGenericToRealID (
   ComponentInstance genericScriptingComponent,
   OSAID * theScriptID,
   ComponentInstance * theExactComponent
);

#ifdef __cplusplus
}
#endif
#endif