#ifndef ASDEBUGGING_H
#define ASDEBUGGING_H

#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

#ifndef APPLESCRIPT_H
#include <OpenScripting/AppleScript.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*OSAGetHandlerNames

Gets a list of all handler names in the specified script as an AEDescList of descriptors of type typeChar.

OSAError OSAGetHandlerNames (
   ComponentInstance scriptingComponent,
   long modeFlags,
   OSAID contextID,
   AEDescList * resultingHandlerNames
);
Parameters
scriptingComponent

Identifies the current scripting component. See the Component Manager documentation for a description of the ComponentInstance data type.
modeFlags

Information for use by the scripting component. No mode flags are applicable for this function, so pass the value kOSAModeNull. 
contextID

See the OSAID data type.
resultingHandlerNames

On return, a list of all handler names, as an AEDescList of descriptors of type typeChar. See Apple Event Manager Reference for a description of the AEDescList data type.
Return Value

A result code. See “Result Codes”.
Availability
Available in CarbonLib 1.0 and later when AppleScript 1.1 or later is present.
Available in Mac OS X version 10.0 and later.
Declared In
ASDebugging.h*/
OSAError OSAGetHandlerNames (
   ComponentInstance scriptingComponent,
   long modeFlags,
   OSAID contextID,
   AEDescList * resultingHandlerNames
);

#ifdef __cplusplus
}
#endif

#endif