#ifndef OPENGL_H
#define OPENGL_H

#ifdef  __OBJC__
#include <ADD/Cocoa/Cocoa.h>
#endif


#include <AvailabilityMacros.h>
#include <OpenGL/CGLCurrent.h>
#include <OpenGL/gl.h>//hys

#ifdef __cplusplus
extern "C" {
#endif

/*CGLGetCurrentContext

Returns the current rendering context.

CGLContextObj CGLGetCurrentContext(void);
Return Value

The current rendering context. If there is none, returns NULL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetCurrentContext*/
CGLContextObj CGLGetCurrentContext(void);

/*CGLLockContext

Locks a CGL rendering context.

CGLError CGLLockContext(CGLContextObj ctx)
Parameters
ctx

The CGL context to lock.
Return Value

A result code. See “CGL Result Codes”.
Discussion

The function CGLLockContext blocks the thread it is on until all other threads have unlocked the same context using the function CGLUnlockContext. You can use CGLLockContext recursively. Context-specific CGL calls by themselves do not require locking, but you can guarantee serial processing for a group of calls by surrounding them with CGLLockContext and CGLUnlockContext. Keep in mind that calls from the OpenGL API (the API provided by the Architecture Review Board) require locking.

Applications that use NSOpenGL classes with multithreading can lock contexts using the functions CGLLockContext and CGLUnlockContext. To perform rendering in a thread other than the main one, you can lock the context that you want to access and safely execute OpenGL commands. The locking calls must be placed around all OpenGL calls in all threads.

For more information on multithreading OpenGL applications, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.4 and later.
Declared In
OpenGL.h
See Also
CGLUnlockContext*/
CGLError CGLLockContext(CGLContextObj ctx);

/*CGLUnlockContext

Unlocks a CGL rendering context.

CGLError CGLUnlockContext(CGLContextObj ctx)
Parameters
ctx

The CGL context to unlock.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.4 and later.
Declared In
OpenGL.h
See Also
CGLLockContext*/

CGLError CGLUnlockContext(CGLContextObj ctx);

/*CGLGetParameter

Retrieves the value of a rendering context parameter.

CGLError CGLGetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   long  *params);
Parameters
ctx

A rendering context.
pname

The parameter whose value you want to retrieve. For a list of possible parameters, see Context Parameters.
params

On return, points to the value of the parameter.
Return Value

A result code. See “CGL Result Codes”.
Discussion

Some parameters may need to have a corresponding context option enabled for their value to take effect. You can enable, disable, and test whether an option is enabled with CGLEnable, CGLDisable, and CGLIsEnabled.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetParameter*/
CGLError CGLGetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   long  *params);

/*CGLQueryRendererInfo

Creates a renderer information object that contains properties and values for all renderers driving the specified displays.

CGLError CGLQueryRendererInfo(unsigned long display_mask,
   CGLRendererInfoObj  *rend,
   long *nrend);
Parameters
display_mask

A bit field that contains the bitwise OR of OpenGL display masks returned by the CGDisplayIDToOpenGLDisplayMask function. If you want to obtain information for all renderers in the system, set every bit in display_mask to true.
rend

The memory address of a renderer information object. On return, points to a renderer information object that describes all renderers that are able to drive the displays specified by the display_mask parameter. If display_mask does not specify any displays, the value of rend is set to NULL.
nrend

On return, points to the number of renderers described in the renderer information object. If display_mask does not specify any displays, the value of nrend is set to 0.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLDescribeRenderer
CGLDestroyRendererInfo*/
CGLError CGLQueryRendererInfo(unsigned long display_mask,
   CGLRendererInfoObj  *rend,
   long *nrend);

/*CGLDescribeRenderer

Obtains the value associated with a renderer property.

CGLError CGLDescribeRenderer(CGLRendererInfoObj rend,
   long rend_num,
   CGLRendererProperty prop,
   long *value);
Parameters
rend

An opaque renderer information object that contains a description of the renderer capabilities you want to inspect. You can obtain a renderer information object by calling the function CGLQueryRendererInfo.
rend_num

The index of the renderer inside the renderer information object—a value between 0 and the number of renderers minus one. The number of renderers can be obtained by calling CGLDescribeRenderer, passing in rend, renderer number 0, and the renderer property kCGLRPRendererCount.
prop

The renderer property whose value you want to obtain. See Renderer Properties for a list of the constants you can supply for this parameter.
value

On return, points to the value of the requested property. 
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h*/
CGLError CGLDescribeRenderer(CGLRendererInfoObj rend,
   long rend_num,
   CGLRendererProperty prop,
   long *value);

/*CGLDestroyRendererInfo

Frees resources associated with a renderer information object.

CGLError CGLDestroyRendererInfo(CGLRendererInfoObj rend);
Parameters
rend

The renderer information object to destroy.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLQueryRendererInfo*/
CGLError CGLDestroyRendererInfo(CGLRendererInfoObj rend);

/*CGLChoosePixelFormat

Creates a pixel format object that satisfies the constraints of the specified buffer and renderer attributes.

CGLError CGLChoosePixelFormat(const CGLPixelFormatAttribute *attribs,
   CGLPixelFormatObj *pix,
   long *npix);
Parameters
attribs

A NULL terminated array that contains a list of buffer and renderer attributes. The existence of a Boolean attribute implies a true value. If an attribute is not Boolean in nature, you must supply the desired value immediately following the attribute. For information on the attributes that you can supply, see Buffer and Renderer Attributes.
pix

The memory address of a pixel format object. On return, points to a new pixel format object that contains pixel format information and a list of virtual screens. If there are no pixel formats or virtual screens that satisfy the constraints of the buffer and renderer attributes, the value of pix is set to NULL.
npix

On return, points to the number of virtual screens referenced by pix. If pix is NULL, the value of npix is set to 0.
Return Value

A result code. See “CGL Result Codes”.
Discussion

After a pixel format object is created successfully, the integer attributes are set to values that are as close to the desired value as can be provided by the system. Attributes can have different values for each virtual screen. You can use the kCGLPFAMinimumPolicy and kCGLPFAMaximumPolicy attributes to control how the system chooses the setting. For more information on choosing attributes, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h*/
CGLError CGLChoosePixelFormat(const CGLPixelFormatAttribute *attribs,
   CGLPixelFormatObj *pix,
   long *npix);

/*CGLCreateContext

Creates a CGL rendering context.

CGLError CGLCreateContext(CGLPixelFormatObj pix,
   CGLContextObj share,
   CGLContextObj *ctx);
Parameters
pix

A pixel format object creating by calling the function CGLChoosePixelFormat.
share

The rendering context with which to share the OpenGL object state—including texture objects, programs and shader display lists, vertex array objects, vertex buffer objects, pixel buffer objects, and frame buffer objects—and the object state associated which each of these object types. Pass NULL to indicate that no sharing is to take place.
ctx

The memory address of a context object. On return, points to a new context object with the buffers and attributes specified by the pix parameter. If the context can not be created as specified, the value of ctx is set to NULL.
Return Value

A result code. See “CGL Result Codes”. 
Discussion

If the pixel format object you supply is able to support multiple graphics devices, then the rendering context can render transparently across the supported devices. With a multiple device rendering context, sharing is possible only when the relationship between the renderers and the graphics devices they support is the same for all rendering contexts that are shared. Normally you achieve the best display by using the same pixel format object for all shared rendering contexts. For more information, see OpenGL Programming Guide for Mac OS X.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetCurrentContext
CGLDestroyContext*/
CGLError CGLCreateContext(CGLPixelFormatObj pix,
   CGLContextObj share,
   CGLContextObj *ctx);

/*CGLDestroyPixelFormat

Frees the memory associated with a pixel format object.

CGLError CGLDestroyPixelFormat(CGLPixelFormatObj pix);
Parameters
pix

The pixel format object to destroy.
Return Value

A result code. See “CGL Result Codes”.
Discussion

The system makes a copy of the pixel format object when you call the function CGLCreateContext, so you can free a pixel format object immediately after passing it to the context creation function.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLChoosePixelFormat*/
CGLError CGLDestroyPixelFormat(CGLPixelFormatObj pix);

/*CGLSetCurrentContext

Sets the specified rendering context as the current rendering context.

CGLError CGLSetCurrentContext(CGLContextObj ctx);
Parameters
ctx

The rendering context to set as the current rendering context. Pass NULL to release the current rendering context without assigning a new one.
Return Value

A result code. See “CGL Result Codes”. If the function fails, the current context remains unchanged.
Discussion

There can be only one current rendering context. Subsequent OpenGL rendering calls operate on the current rendering context to modify the drawable object associated with it. 

You can use AGL macros to bypass the current rendering context mechanism and maintain your own current rendering context.

A context is current on a per-thread basis. Multiple threads must serialize calls into the same context.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLGetCurrentContext*/
CGLError CGLSetCurrentContext(CGLContextObj ctx);

/*CGLDestroyContext

Frees the resources associated with a rendering context.

CGLError CGLDestroyContext(CGLContextObj ctx);
Parameters
ctx

The rendering context to destroy. 
Return Value

A result code. See “CGL Result Codes”.
Discussion

This function frees all the resources used by the rendering context passed to it. If the rendering context that you pass is the current rendering context, the current context is set to NULL and there is no current rendering context after the function executes.

After you call this function, you must make sure that you do not use the destroyed rendering context. This includes using CGL macros in which the rendering context is explicitly passed to OpenGL.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLCreateContext*/
CGLError CGLDestroyContext(CGLContextObj ctx);

/*CGLSetParameter

Sets the value of a rendering context parameter.

CGLError CGLSetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   const long  *params);
Parameters
ctx

A rendering context.
pname

The parameter whose value you want to set. For a list of possible parameters, see Context Parameters.
params

A pointer to the value to the parameter to.
Return Value

A result code. See “CGL Result Codes”.
Discussion

Some parameters may need to have a corresponding context option enabled for their value to take effect. You can enable, disable, and test whether an option is enabled with CGLEnable, CGLDisable, and CGLIsEnabled.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLGetParameter*/
CGLError CGLSetParameter(CGLContextObj ctx,
   CGLContextParameter  pname,
   const long  *params);

/*CGLDisable

Disables an option for a rendering context.

CGLError CGLDisable(CGLContextObj ctx,
   CGLContextEnable pname);
Parameters
ctx

A rendering context.
pname

The option to disable. For a list of possible options, see Context Options.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLEnable
CGLIsEnabled*/
CGLError CGLDisable(CGLContextObj ctx,
   CGLContextEnable pname);

/*CGLEnable

Enables an option for a rendering context.

CGLError CGLEnable(CGLContextObj ctx,
   CGLContextEnable pname);
Parameters
ctx

A rendering context.
pname

The option to enable. For a list of possible options, see Context Options.
Return Value

A result code. See “CGL Result Codes”.
Discussion

Some context options have values associated with them. Use CGLSetParameter and CGLGetParameter to set and get context parameter values.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLDisable
CGLIsEnabled*/
CGLError CGLEnable(CGLContextObj ctx,
   CGLContextEnable pname);

/*CGLErrorString

Returns a string that describes the specified result code.

const char *CGLErrorString(CGLError error);
Parameters
error

The CGL result code constant returned from a CGL function. For a description of these constants, see “CGL Result Codes”.
Return Value

An error string that describes the result code constant passed in the error parameter. If the result code is invalid, returns the string “No such error code.”
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h*/
const char *CGLErrorString(CGLError error);

/*CGLSetFullScreen

Attaches a rendering context to its full-screen drawable object.

CGLError CGLSetFullScreen(CGLContextObj ctx);

Parameters
ctx

A rendering context.
Return Value

A result code. See “CGL Result Codes”.
Discussion

Before calling this function, you must set up the rendering context using a pixel format object created with the kCGLPFAFullScreen attribute (see Buffer and Renderer Attributes). Some OpenGL renderers, such as the software renderer, do not support full-screen mode. After you call the function CGLChoosePixelFormat with the full-screen attribute, you need to check whether the pixel format object is created successfully.

You must capture the display prior to entering full-screen mode and release it after exiting. After calling this function subsequent OpenGL drawing is rendered into the entire screen. For more information, see OpenGL Programming Guide for Mac OS X.

To exit full-screen mode, call CGLClearDrawable.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h*/
CGLError CGLSetFullScreen(CGLContextObj ctx);

/*CGLClearDrawable

Disassociates a rendering context from any drawable objects attached to it.

CGLError CGLClearDrawable(CGLContextObj ctx);
Parameters
ctx

A rendering context.
Return Value

A result code. See “CGL Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h
See Also
CGLSetOffScreen
CGLSetFullScreen*/
CGLError CGLClearDrawable(CGLContextObj ctx);

/*CGLFlushDrawable

Copies the back buffer of a double-buffered context to the front buffer.

CGLError CGLFlushDrawable(CGLContextObj ctx);

Parameters
ctx

The context object.
Return Value

A result code. See “CGL Result Codes”.
Discussion

To create a double-buffered context, specify the kCGLPFADoubleBuffer attribute (see Buffer and Renderer Attributes) when you create the pixel format object for the rendering context. If the backing store attribute is set to false the buffers may be exchanged rather than copied. This is often the case in full-screen mode. If the receiver is not a double-buffered context, this call does nothing.

If you set the swap interval attribute (kCGLCPSwapInterval) appropriately, the copy takes place during the vertical retrace of the monitor, rather than immediately after CGLFlushDrawable is called. An implicit glFlush is performed by CGLFlushDrawable before it returns. For optimal performance, an application should not call glFlush immediately before calling CGLFlushDrawable. Subsequent OpenGL commands can be issued immediately after calling CGLFlushDrawable, but are not executed until the buffer copy is completed. For more information about kCGLCPSwapInterval, see Context Parameters.
Availability
Available in Mac OS X v10.0 and later.
Declared In
OpenGL.h*/
CGLError CGLFlushDrawable(CGLContextObj ctx);

#ifdef __cplusplus
}
#endif
#endif