#ifndef CGLTYPES_H
#define CGLTYPES_H
//#include <HYS/OpenGL/CGLTypes.h>
#include <APPLE/OpenGL/CGLTypes.h>
#ifdef __cplusplus
extern "C" {
#endif

/* CGL Result Codes

The following result code constants, declared in the CGLTypes.h header file, can be used as parameters to the function CGLErrorString.
Result Code	Value	Description
kCGLNoError	0	
No error.
kCGLBadAttribute	10000	
Invalid pixel format attribute. Valid attributes can be found in Buffer and Renderer Attributes.
kCGLBadProperty	10001	
Invalid renderer property. Valid renderer properties can be found in Renderer Property Constants.
kCGLBadPixelFormat	10002	
Invalid pixel format object. A valid pixel format object can be obtained by calling the function CGLChoosePixelFormat.
kCGLBadRendererInfo	10003	
Invalid renderer information object. A valid renderer information object can be obtained by calling the function CGLQueryRendererInfo.
kCGLBadContext	10004	
Invalid context object. A valid context object can be obtained by calling the function CGLCreateContext.
kCGLBadDrawable	10005	
Invalid drawable object. This error occurs when you attempt to attach a second, incompatible, rendering context to a drawable object. For more information about incompatible contexts, see the discussion section of the function CGLCreateContext. This error also occurs when you attempt to attach a context to a full-screen drawable object, and the color depth of the drawable object is different than that specified by the pixel format object used to create the context. The kCGLPFAColorSize attribute, described in Buffer and Renderer Attributes, specifies the color depth of a pixel format.
kCGLBadDisplay	10006	
Invalid display.
kCGLBadState	10007	
Invalid context state. This error occurs when a context state is inspected for readiness to switch renderers. To be in a valid state, a context be in render mode and have an attribute stack depth of 0, and a modelview, projection, and texture stack depth of 1. For more information about state verification, see the context enable constant kCGLCEStateValidation, described in Context Option Constants.
kCGLBadValue	10008	
Invalid numerical value.
kCGLBadMatch	10009	
Invalid share context. Two contexts are a bad match if their pixel format objects use different renderers.
kCGLBadEnumeration	10010	
Invalid constant. 
kCGLBadOffScreen	10011	
Invalid offscreen drawable object.
kCGLBadFullScreen	10012	
Invalid full-screen drawable object.
kCGLBadWindow	10013	
Invalid window.
kCGLBadAddress	10014	
Invalid memory address. This error occurs when you pass an invalid pointer into a function that requires a memory address other than NULL.
kCGLBadCodeModule	10015	
Invalid code module.
kCGLBadAlloc	10016	
Invalid memory allocation. This error occurs when CGL is unable to allocate memory.
kCGLBadConnection	10017	
Invalid connection to Core Graphics.*/
enum CGLError  {
kCGLNoError	=0	,
//No error.
kCGLBadAttribute	=10000	,
//Invalid pixel format attribute. Valid attributes can be found in Buffer and Renderer Attributes.
kCGLBadProperty	=10001	,
//Invalid renderer property. Valid renderer properties can be found in Renderer Property Constants.
kCGLBadPixelFormat	=10002	,
//Invalid pixel format object. A valid pixel format object can be obtained by calling the function CGLChoosePixelFormat.
kCGLBadRendererInfo=	10003	,
//Invalid renderer information object. A valid renderer information object can be obtained by calling the function CGLQueryRendererInfo.
kCGLBadContext	=10004	,
//Invalid context object. A valid context object can be obtained by calling the function CGLCreateContext.
kCGLBadDrawable=	10005	,
//Invalid drawable object. This error occurs when you attempt to attach a second, incompatible, rendering context to a drawable object. For more information about incompatible contexts, see the discussion section of the function CGLCreateContext. This error also occurs when you attempt to attach a context to a full-screen drawable object, and the color depth of the drawable object is different than that specified by the pixel format object used to create the context. The kCGLPFAColorSize attribute, described in Buffer and Renderer Attributes, specifies the color depth of a pixel format.
kCGLBadDisplay	=10006	,
//Invalid display.
kCGLBadState	=10007	,
//Invalid context state. This error occurs when a context state is inspected for readiness to switch renderers. To be in a valid state, a context be in render mode and have an attribute stack depth of 0, and a modelview, projection, and texture stack depth of 1. For more information about state verification, see the context enable constant kCGLCEStateValidation, described in Context Option Constants.
kCGLBadValue	=10008	,
//Invalid numerical value.
kCGLBadMatch=	10009	,
//Invalid share context. Two contexts are a bad match if their pixel format objects use different renderers.
kCGLBadEnumeration	=10010	,
//Invalid constant. 
kCGLBadOffScreen=	10011	,
//Invalid offscreen drawable object.
kCGLBadFullScreen	=10012	,
//Invalid full-screen drawable object.
kCGLBadWindow	=10013	,
//Invalid window.
kCGLBadAddress	=10014	,
//Invalid memory address. This error occurs when you pass an invalid pointer into a function that requires a memory address other than NULL.
kCGLBadCodeModule=	10015	,
//Invalid code module.
kCGLBadAlloc	=10016	,
//Invalid memory allocation. This error occurs when CGL is unable to allocate memory.
kCGLBadConnection	=10017	,
};
typedef enum CGLError CGLError;

/*Buffer and Renderer Attributes

Specify attributes used to choose pixel formats and virtual screens.

typedef enum _CGLPixelFormatAttribute {
   kCGLPFAAllRenderers       =   1,
   kCGLPFADoubleBuffer       =   5,
   kCGLPFAStereo             =   6,
   kCGLPFAAuxBuffers         =   7,
   kCGLPFAColorSize          =   8,
   kCGLPFAAlphaSize          =  11,
   kCGLPFADepthSize          =  12,
   kCGLPFAStencilSize        =  13,
   kCGLPFAAccumSize          =  14,
   kCGLPFAMinimumPolicy      =  51,
   kCGLPFAMaximumPolicy      =  52,
   kCGLPFAOffScreen          =  53,
   kCGLPFAFullScreen         =  54,
   kCGLPFASampleBuffers      =  55,
   kCGLPFASamples            =  56,
   kCGLPFAAuxDepthStencil    =  57,
   kCGLPFAColorFloat         =  58,
   kCGLPFAMultisample        =  59,
   kCGLPFASupersample        =  60,
   kCGLPFASampleAlpha        =  61,
   kCGLPFARendererID         =  70,
   kCGLPFASingleRenderer     =  71,
   kCGLPFANoRecovery         =  72,
   kCGLPFAAccelerated        =  73,
   kCGLPFAClosestPolicy      =  74,
   kCGLPFARobust             =  75,
   kCGLPFABackingStore       =  76,
   kCGLPFAMPSafe             =  78,
   kCGLPFAWindow             =  80,
   kCGLPFAMultiScreen        =  81,
   kCGLPFACompliant          =  83,
   kCGLPFADisplayMask        =  84,
   kCGLPFAPBuffer            =  90,
   kCGLPFARemotePBuffer      =  91,
   kCGLPFAVirtualScreenCount = 128,
} CGLPixelFormatAttribute;
Constants
kCGLPFAAllRenderers

If true, pixel format selection is open to all available renderers, including debug and special-purpose renderers that are not OpenGL compliant.

Available in Mac OS X v10.0 and later.
kCGLPFADoubleBuffer

If true, only double-buffered pixel formats are considered. Otherwise, only single-buffered pixel formats are considered.

Available in Mac OS X v10.0 and later.
kCGLPFAStereo

If true, only stereo pixel formats are considered. Otherwise, only monoscopic pixel formats are considered.

Available in Mac OS X v10.0 and later.
kCGLPFAAuxBuffers

The associated value is a nonnegative integer that indicates the desired number of auxiliary buffers. Pixel formats with the smallest number of auxiliary buffers that meet or exceeds the specified number are preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAColorSize

The associated value is a nonnegative buffer size specification. A color buffer that most closely matches the specified size is preferred. If unspecified, OpenGL chooses a color size that matches the screen.

Available in Mac OS X v10.0 and later.
kCGLPFAAlphaSize

The associated value is a nonnegative buffer size specification. An alpha buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFADepthSize

The associated value is a nonnegative depth buffer size specification. A depth buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAStencilSize

The associated value is a nonnegative integer that indicates the desired number of stencil bitplanes. The smallest stencil buffer of at least the specified size is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAAccumSize

The associated value is a nonnegative buffer size specification. An accumulation buffer that most closely matches the specified size is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAMinimumPolicy

If true, the pixel format choosing policy is altered for the color, depth, and accumulation buffers such that only buffers of size greater than or equal to the desired size are considered.

Available in Mac OS X v10.0 and later.
kCGLPFAMaximumPolicy

If true, the pixel format choosing policy is altered for the color, depth, and accumulation buffers such that, if a nonzero buffer size is requested, the largest available buffer is preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAOffScreen

If true, only renderers that are capable of rendering to an off-screen memory area and have buffer depth exactly equal to the desired buffer depth are considered. The kCGLPFAClosestPolicy attribute is implied.

Available in Mac OS X v10.0 and later.
kCGLPFAFullScreen

If true, only renderers that are capable of rendering to a full-screen drawable object are considered. The kCGLPFASingleRenderer attribute is implied.

Available in Mac OS X v10.0 and later.
kCGLPFAAuxDepthStencil

If true, each auxiliary buffer has its own depth stencil.

Available in Mac OS X v10.2 and later.
kCGLPFAColorFloat

If true, color buffers store floating-point pixels.

Available in Mac OS X v10.3 and later.
kCGLPFAMultisample

If true, choose multisampling.

Available in Mac OS X v10.3 and later.
kCGLPFASupersample

If true, choose supersampling.

Available in Mac OS X v10.3 and later.
kCGLPFASampleAlpha

If true, request alpha filtering.

Available in Mac OS X v10.3 and later.
kCGLPFASampleBuffers

The number of multisample buffers. The associated value is a nonnegative integer that indicates the number of existing independent sample buffers. Typically, the value is 0 if no multi-sample buffer exists or 1. This attribute is not useful in the attribute array.

Available in Mac OS X v10.1 and later.
kCGLPFASamples

The number of samples per multisample buffer. The associated value is a nonnegative integer that indicates the desired number of samples that can be taken within a single pixel. The smallest sample buffer with at least the specified number of samples is preferred.

Available in Mac OS X v10.1 and later.
kCGLPFARendererID

The associated value is a nonnegative renderer ID number and can be any of the constants defined in Renderer IDs. OpenGL renderers that match the specified ID are preferred. Of note is kCGLRendererGenericID which selects the Apple software renderer. The other constants select renderers for specific hardware vendors.

Available in Mac OS X v10.0 and later.
kCGLPFASingleRenderer

If true, a single rendering engine is chosen. On systems with multiple screens, this disables ability of OpenGL to drive different monitors through different graphics accelerator cards with a single context. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFANoRecovery

If true, the OpenGL failure recovery mechanisms are disabled. Normally, if an accelerated renderer fails due to lack of resources, OpenGL automatically switches to another renderer. This attribute disables these features so that rendering is always performed by the chosen renderer. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFAAccelerated

If true, only hardware accelerated renderers are considered. If false, accelerated renderers are still preferred.

Available in Mac OS X v10.0 and later.
kCGLPFAClosestPolicy

If true, the pixel format choosing policy is altered for the color buffer such that the buffer closest to the requested size is preferred, regardless of the actual color buffer depth of the supported graphics device.

Available in Mac OS X v10.0 and later.
kCGLPFARobust

If true, only renderers that do not have any failure modes associated with a lack of video card resources are considered. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFABackingStore

If true, OpenGL only considers renderers that have a back color buffer the full size of the drawable object and that guarantee the back buffer contents to be valid after a call to CGLFlushDrawable.

Available in Mac OS X v10.0 and later.
kCGLPFAMPSafe

If true, OpenGL only considers renderers that are thread-safe. Because all renderers are thread-safe, this attribute is not useful.

Available in Mac OS X v10.0 and later.
kCGLPFAWindow

If true, only renderers that are capable of rendering to a window are considered. This attribute is implied if neither kCGLPFAFullScreen nor kCGLPFAOffScreen is specified. Because CGL only supports full-screen of off-screen drawable objects, this attribute is not useful.

Available in Mac OS X v10.0 and later.
kCGLPFAMultiScreen

If true, only renderers capable of driving multiple screens are considered. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFACompliant

If true, pixel format selection is only open to OpenGL compliant renderers. This attribute is implied unless kCGLPFAAllRenderers is specified. This attribute is not useful in the attribute array.

Available in Mac OS X v10.0 and later.
kCGLPFADisplayMask

The associated value is a bit mask of supported physical screens. All screens specified in the bit mask are guaranteed to be supported by the pixel format. Screens not specified in the bit mask may still be supported. The bit mask is managed by the Quartz Display Services, available in the CGDirectDisplay.h header of the Application Services umbrella framework. A CGDirectDisplayID must be converted to an OpenGL display mask using the function CGDisplayIDToOpenGLDisplayMask. This attribute is not generally useful.

Available in Mac OS X v10.0 and later.
kCGLPFAPBuffer

If true, format can be used to render to a Pbuffer.

Available in Mac OS X v10.3 and later.
kCGLPFARemotePBuffer

If true, format can be used to render offline to a Pbuffer.

Available in Mac OS X v10.3 and later.
kCGLPFAVirtualScreenCount

This attribute may be used to obtain the number of virtual screens specified by an existing pixel format object. To retrieve the value, call the function CGLDescribePixelFormat, passing the pixel format object, the virtual screen number 0, and this attribute. This attribute is not useful in the attribute array that's used to create a pixel format object.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used by CGLChoosePixelFormat and CGLDescribePixelFormat. The existence of a Boolean attribute in the attribute array of CGLChoosePixelFormat implies a true value. Other attribute constants must be followed by a value.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef enum _CGLPixelFormatAttribute {
   kCGLPFAAllRenderers       =   1,
   kCGLPFADoubleBuffer       =   5,
   kCGLPFAStereo             =   6,
   kCGLPFAAuxBuffers         =   7,
   kCGLPFAColorSize          =   8,
   kCGLPFAAlphaSize          =  11,
   kCGLPFADepthSize          =  12,
   kCGLPFAStencilSize        =  13,
   kCGLPFAAccumSize          =  14,
   kCGLPFAMinimumPolicy      =  51,
   kCGLPFAMaximumPolicy      =  52,
   kCGLPFAOffScreen          =  53,
   kCGLPFAFullScreen         =  54,
   kCGLPFASampleBuffers      =  55,
   kCGLPFASamples            =  56,
   kCGLPFAAuxDepthStencil    =  57,
   kCGLPFAColorFloat         =  58,
   kCGLPFAMultisample        =  59,
   kCGLPFASupersample        =  60,
   kCGLPFASampleAlpha        =  61,
   kCGLPFARendererID         =  70,
   kCGLPFASingleRenderer     =  71,
   kCGLPFANoRecovery         =  72,
   kCGLPFAAccelerated        =  73,
   kCGLPFAClosestPolicy      =  74,
   kCGLPFARobust             =  75,
   kCGLPFABackingStore       =  76,
   kCGLPFAMPSafe             =  78,
   kCGLPFAWindow             =  80,
   kCGLPFAMultiScreen        =  81,
   kCGLPFACompliant          =  83,
   kCGLPFADisplayMask        =  84,
   kCGLPFAPBuffer            =  90,
   kCGLPFARemotePBuffer      =  91,
   kCGLPFAVirtualScreenCount = 128,
} CGLPixelFormatAttribute;

/*CGLPixelFormatObj

Represents a pointer to an opaque pixel format object.

typedef struct _CGLPixelFormatObject *CGLPixelFormatObj;
Discussion

This data type points to a structure that CGL uses to maintain pixel format and virtual screen information for a given set of renderer and buffer options. Use the functions described in “Managing Pixel Format Objects” to create, manage, access, and free a pixel format object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef struct _CGLPixelFormatObject *CGLPixelFormatObj;

/*CGLContextObj

Represents a pointer to an opaque CGL context object.

typedef struct _CGLContextObject *CGLContextObj;
Discussion

This data type points to a structure that CGL uses to maintain state and other information associated with an OpenGL rendering context. Use the functions described in “Managing Contexts” and “Getting and Setting Context Options” to create, manage, access, and free a CGL context object. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef struct _CGLContextObject *CGLContextObj;


/*Context Parameters

Specify parameters that apply to a specific rendering context.

typedef enum _CGLContextParameter {
   kCGLCPSwapRectangle    = 200,
   kCGLCPSwapInterval     = 222,
   kCGLCPDispatchTableSize = 224,
   kCGLCPClientStorage    = 226,
   kCGLCPSurfaceTexture    = 228,
   kCGLCPSurfaceOrder      = 235,
   kCGLCPSurfaceOpacity    = 236,
   kCGLCPSurfaceBackingSize = 304,
   kCGLCPSurfaceSurfaceVolatile = 306,
   kCGLCPReclaimResources  = 308
} CGLContextParameter;
Constants
kCGLCPSwapRectangle

Set or get the swap rectangle. The swap rectangle is represented as an array of four long values: {x, y, width, height}. For this rectangle to affect the outcome of calling the function CGLFlushDrawable, the context option kCGLCESwapRectangle must be enabled. For more information about kCGLCESwapRectangle, see Context Options.

Available in Mac OS X v10.0 and later.
kCGLCPSwapInterval

Set or get the swap interval. The swap interval is represented as one long value. If the swap interval is set to 0 (the default), CGLFlushDrawable executes as soon as possible, without regard to the vertical refresh rate of the monitor. If the swap interval is set to 1, the buffers are swapped only during the vertical retrace of the monitor. 

Available in Mac OS X v10.0 and later.
kCGLCPDispatchTableSize

Set or get the dispatch table size.

Available in Mac OS X v10.4 and later.
kCGLCPClientStorage

Set or get an arbitrary 32-bit value. A typical usage would be to store a pointer to application-specific data associated with the context.

Available in Mac OS X v10.0 and later.
kCGLCPSurfaceTexture

Set the surface texture. Supply a surface ID, target, and internal format.

Available in Mac OS X v10.4 and later.
kCGLCPSurfaceOrder

Set or get the position of the OpenGL surface relative to the window. A value of 1 means that the position is above the window; a value of –1 specifies a position that is below the window.

Available in Mac OS X v10.2 and later.
kCGLCPSurfaceOpacity

Set or get the surface opacity. A value of 1 means the surface is opaque (the default); 0 means completely transparent. 

Available in Mac OS X v10.2 and later.
kCGLCPSurfaceBackingSize

Set or get the height and width of the back buffer. You can use this to let the system scale an image automatically on swap to a variable size buffer. The back buffer size remains fixed at the size that you set up regardless of whether the image is resized to display larger onscreen.

Available in Mac OS X v10.4 and later.
kCGLCPSurfaceSurfaceVolatile

Set or get the volatile state of a surface.

Available in Mac OS X v10.4 and later.
kCGLCPReclaimResources

Enable or disable reclaiming resources.

Available in Mac OS X v10.4 and later.
Discussion

These constants are used by the functions CGLSetParameter and CGLGetParameter.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef enum _CGLContextParameter {
   kCGLCPSwapRectangle    = 200,
   kCGLCPSwapInterval     = 222,
   kCGLCPDispatchTableSize = 224,
   kCGLCPClientStorage    = 226,
   kCGLCPSurfaceTexture    = 228,
   kCGLCPSurfaceOrder      = 235,
   kCGLCPSurfaceOpacity    = 236,
   kCGLCPSurfaceBackingSize = 304,
   kCGLCPSurfaceSurfaceVolatile = 306,
   kCGLCPReclaimResources  = 308
} CGLContextParameter;

/*CGLRendererInfoObj

Represents a pointer to an opaque renderer information object.

typedef struct _CGLRendererInfoObject *CGLRendererInfoObj;
Discussion

This data type points to a structure that CGL uses to maintain information about the renderers associated with a display. Use the functions described in “Getting Renderer Information” to create, access, and free a renderer information object.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef struct _CGLRendererInfoObject *CGLRendererInfoObj;

/*Renderer Properties

Specify renderer properties.

typedef enum _CGLRendererProperty {
   kCGLRPOffScreen           =  53,
   kCGLRPFullScreen          =  54,
   kCGLRPRendererID          =  70,
   kCGLRPAccelerated         =  73,
   kCGLRPRobust              =  75,
   kCGLRPBackingStore        =  76,
   kCGLRPMPSafe              =  78,
   kCGLRPWindow              =  80,
   kCGLRPMultiScreen         =  81,
   kCGLRPCompliant           =  83,
   kCGLRPDisplayMask         =  84,
   kCGLRPBufferModes         = 100,
   kCGLRPColorModes          = 103,
   kCGLRPAccumModes          = 104,
   kCGLRPDepthModes          = 105,
   kCGLRPStencilModes        = 106,
   kCGLRPMaxAuxBuffers       = 107,
   kCGLRPMaxSampleBuffers    = 108,
   kCGLRPMaxSamples          = 109,
   kCGLRPSampleModes         = 110,
   kCGLRPSampleAlpha         = 111,
   kCGLRPVideoMemory         = 120,
   kCGLRPTextureMemory       = 121,
   kCGLRPRendererCount       = 128,
} CGLRendererProperty;
Constants
kCGLRPOffScreen

If true, the renderer supports offscreen drawable objects.

Available in Mac OS X v10.0 and later.
kCGLRPFullScreen

If true, the renderer supports full screen drawable objects.

Available in Mac OS X v10.0 and later.
kCGLRPRendererID

The associated value is the renderer ID. Renderer ID constants are associated with specific hardware vendors. See Renderer IDs.

Available in Mac OS X v10.0 and later.
kCGLRPAccelerated

If true, the renderer is hardware accelerated.

Available in Mac OS X v10.0 and later.
kCGLRPRobust

If true, the renderer does not have any failure modes caused by a lack of video card resources.

Available in Mac OS X v10.0 and later.
kCGLRPBackingStore

If true, the renderer can provide a back color buffer the full size of the drawable object and can guarantee the back buffer contents to be valid after a call to CGLFlushDrawable.

Available in Mac OS X v10.0 and later.
kCGLRPMPSafe

If true, the renderer is thread-safe. All renderers are thread-safe in Mac OS X.

Available in Mac OS X v10.0 and later.
kCGLRPWindow

If true, the renderer supports window drawable objects.

Available in Mac OS X v10.0 and later.
kCGLRPMultiScreen

If true, the renderer is presently attached to multiple displays.

Available in Mac OS X v10.0 and later.
kCGLRPCompliant

If true, the renderer is OpenGL compliant. All renderers are OpenGL compliant in Mac OS X.

Available in Mac OS X v10.0 and later.
kCGLRPDisplayMask

The associated value is a bit mask of physical displays that the renderer can drive. The bit mask is managed by Quartz Display Services. A CGDirectDisplayID data type must be converted to an OpenGL display mask using the function CGDisplayIDToOpenGLDisplayMask. For more information on this function, see Quartz Display Services Reference.

Available in Mac OS X v10.0 and later.
kCGLRPBufferModes

The associated value is the bitwise OR of buffer mode flags supported by the renderer. The value can be any of the constants defined in Buffer Mode Flags.

Available in Mac OS X v10.0 and later.
kCGLRPColorModes

The associated value is the bitwise OR of color format flags supported by the renderer. The value can be any of the constants defined in Color and Accumulation Buffer Format Flags.

Available in Mac OS X v10.0 and later.
kCGLRPAccumModes

The associated value is the bitwise OR of color/accumulation buffer format flags supported by the renderer. The value can be any of the constants defined in Color and Accumulation Buffer Format Flags.

Available in Mac OS X v10.0 and later.
kCGLRPDepthModes

The associated value is the bitwise OR of depth/stencil buffer depth flags supported by the renderer. The value can be any of the constants defined in Stencil and Depth Modes. 

Available in Mac OS X v10.0 and later.
kCGLRPStencilModes

The associated value is the bitwise OR of depth/stencil buffer depth flags supported by the renderer. The value can be any of the constants defined in Stencil and Depth Modes.

Available in Mac OS X v10.0 and later.
kCGLRPMaxAuxBuffers

The associated value is the maximum number of auxiliary buffers supported by the renderer.

Available in Mac OS X v10.0 and later.
kCGLRPMaxSampleBuffers

The associated value is the maximum number of independent sample buffers supported by the renderer. Typically, the value is 0 if no multisample buffer exists, or 1 if one exists.

Available in Mac OS X v10.1 and later.
kCGLRPMaxSamples

The associated value is the maximum number of samples per pixel that the renderer supports.

Available in Mac OS X v10.1 and later.
kCGLRPSampleModes

A bit field of supported sample modes.

Available in Mac OS X v10.3 and later.
kCGLRPSampleAlpha

If true, there is support for alpha sampling.

Available in Mac OS X v10.3 and later.
kCGLRPVideoMemory

The associated value is the number of bytes of video memory available to the renderer.

Available in Mac OS X v10.0 and later.
kCGLRPTextureMemory

The associated value is the number of bytes of texture memory available to the renderer.

Available in Mac OS X v10.0 and later.
kCGLRPRendererCount

The associated value is the number of renderers in a specific renderer information object. To determine the number of renderers in a renderer information object, call the function CGLDescribeRenderer, passing in the object, renderer number 0, and this renderer property.

Available in Mac OS X v10.0 and later.
Discussion

These constants are used by the function CGLDescribeRenderer.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CGLTypes.h*/
typedef enum _CGLRendererProperty {
   kCGLRPOffScreen           =  53,
   kCGLRPFullScreen          =  54,
   kCGLRPRendererID          =  70,
   kCGLRPAccelerated         =  73,
   kCGLRPRobust              =  75,
   kCGLRPBackingStore        =  76,
   kCGLRPMPSafe              =  78,
   kCGLRPWindow              =  80,
   kCGLRPMultiScreen         =  81,
   kCGLRPCompliant           =  83,
   kCGLRPDisplayMask         =  84,
   kCGLRPBufferModes         = 100,
   kCGLRPColorModes          = 103,
   kCGLRPAccumModes          = 104,
   kCGLRPDepthModes          = 105,
   kCGLRPStencilModes        = 106,
   kCGLRPMaxAuxBuffers       = 107,
   kCGLRPMaxSampleBuffers    = 108,
   kCGLRPMaxSamples          = 109,
   kCGLRPSampleModes         = 110,
   kCGLRPSampleAlpha         = 111,
   kCGLRPVideoMemory         = 120,
   kCGLRPTextureMemory       = 121,
   kCGLRPRendererCount       = 128,
} CGLRendererProperty;


#ifdef __cplusplus
}
#endif

#endif