#ifndef __WINE_WINDOWS_H

#ifndef OPENTRANSPORTPROVIDERS_H
#define OPENTRANSPORTPROVIDERS_H

#ifndef OPENTRANSPORT_H
#include <OSServices/OpenTransport.h>
#endif

#include <AvailabilityMacros.h>
//#include <HYS/OSServices/OpenTransportProviders.h>
#include <APPLE/OSServices/OpenTransportProviders.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Table 12-2 Protocol identifiers for use in configuring AppleTalk providers 
Constant	Configuration 
  string value  	Type of provider configured
kNBPName  	"nbp"	NBP mapper provider
kDDPName	"ddp"	DDP endpoint provider
kATPName	"atp"	ATP endpoint provider
kADSPName	"adsp"	ADSP endpoint provider
kPAPName	"pap"	PAP endpoint provider*/
enum {
kNBPName  	='nbp',//	NBP mapper provider
kDDPName	='ddp',//	DDP endpoint provider
kATPName	='atp',//	ATP endpoint provider
kADSPName	='adsp',//	ADSP endpoint provider
kPAPName	='pap'	//PAP endpoint provider*/
};

/*TCP_NODELAY


enum {
   TCP_NODELAY = 0x01,
   TCP_MAXSEG = 0x02,
   TCP_NOTIFY_THRESHOLD = 0x10,
   TCP_ABORT_THRESHOLD = 0x11,
   TCP_CONN_NOTIFY_THRESHOLD = 0x12,
   TCP_CONN_ABORT_THRESHOLD = 0x13,
   TCP_OOBINLINE = 0x14,
   TCP_URGENT_PTR_TYPE = 0x15,
   TCP_KEEPALIVE = 0x0008
};
Constants
TCP_NODELAY

Available in Mac OS X v10.0 and later.
TCP_MAXSEG

Available in Mac OS X v10.0 and later.
TCP_NOTIFY_THRESHOLD

Available in Mac OS X v10.0 and later.
TCP_ABORT_THRESHOLD

Available in Mac OS X v10.0 and later.
TCP_CONN_NOTIFY_THRESHOLD

Available in Mac OS X v10.0 and later.
TCP_CONN_ABORT_THRESHOLD

Available in Mac OS X v10.0 and later.
TCP_OOBINLINE

Available in Mac OS X v10.0 and later.
TCP_URGENT_PTR_TYPE

Available in Mac OS X v10.0 and later.
TCP_KEEPALIVE

Available in Mac OS X v10.0 and later.*/
enum {
   TCP_NODELAY = 0x01,
   TCP_MAXSEG = 0x02,
   TCP_NOTIFY_THRESHOLD = 0x10,
   TCP_ABORT_THRESHOLD = 0x11,
   TCP_CONN_NOTIFY_THRESHOLD = 0x12,
   TCP_CONN_ABORT_THRESHOLD = 0x13,
   TCP_OOBINLINE = 0x14,
   TCP_URGENT_PTR_TYPE = 0x15,
   TCP_KEEPALIVE = 0x0008
};


/*_OPTIONS


enum {
   IP_OPTIONS = 1,
   IP_TOS = 2,
   IP_TTL = 3,
   IP_REUSEADDR = 4,
   IP_DONTROUTE = 16,
   IP_BROADCAST = 32,
   IP_REUSEPORT = 512,
   IP_HDRINCL = 4098,
   IP_RCVOPTS = 4101,
   IP_RCVDSTADDR = 4103,
   IP_MULTICAST_IF = 4112,
   IP_MULTICAST_TTL = 4113,
   IP_MULTICAST_LOOP = 4114,
   IP_ADD_MEMBERSHIP = 4115,
   IP_DROP_MEMBERSHIP = 4116,
   IP_BROADCAST_IFNAME = 4117,
   IP_RCVIFADDR = 4118
};
Constants
IP_OPTIONS

Available in Mac OS X v10.0 and later.
IP_TOS

Available in Mac OS X v10.0 and later.
IP_TTL

Available in Mac OS X v10.0 and later.
IP_REUSEADDR
IP_DONTROUTE
IP_BROADCAST
IP_REUSEPORT
IP_HDRINCL

Available in Mac OS X v10.0 and later.
IP_RCVOPTS
IP_RCVDSTADDR
IP_MULTICAST_IF

Available in Mac OS X v10.0 and later.
IP_MULTICAST_TTL

Available in Mac OS X v10.0 and later.
IP_MULTICAST_LOOP

Available in Mac OS X v10.0 and later.
IP_ADD_MEMBERSHIP

Available in Mac OS X v10.0 and later.
IP_DROP_MEMBERSHIP

Available in Mac OS X v10.0 and later.
IP_BROADCAST_IFNAME
IP_RCVIFADDR*/

enum {
#ifndef  IP_OPTIONS
   IP_OPTIONS  = 1,
#endif

#ifndef IP_TOS
   IP_TOS = 2,
#endif

#ifndef IP_TTL
   IP_TTL = 3,
#endif

   IP_REUSEADDR = 4,
   IP_DONTROUTE = 16,
   IP_BROADCAST = 32,
   IP_REUSEPORT = 512,
#ifndef IP_HDRINCL
   IP_HDRINCL = 4098,
#endif 

   IP_RCVOPTS = 4101,
   IP_RCVDSTADDR = 4103,
#ifndef   IP_MULTICAST_IF 
   IP_MULTICAST_IF = 4112,
#endif 
#ifndef     IP_MULTICAST_TTL
   IP_MULTICAST_TTL = 4113,
#endif 
#ifndef  IP_MULTICAST_LOOP
   IP_MULTICAST_LOOP = 4114,
#endif 
#ifndef   IP_ADD_MEMBERSHIP
   IP_ADD_MEMBERSHIP = 4115,
#endif 
#ifndef   IP_DROP_MEMBERSHIP
   IP_DROP_MEMBERSHIP = 4116,
#endif 
   IP_BROADCAST_IFNAME = 4117,
   IP_RCVIFADDR = 4118
};


/*kDefaultInternetServicesPath


enum {
   kDefaultInternetServicesPath = -3
};
Constants
kDefaultInternetServicesPath

Available in Mac OS X v10.0 and later.*/

enum {
   kDefaultInternetServicesPath = -3
};


/*InetSvcRef


typedef struct OpaqueInetSvcRef * InetSvcRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef struct OpaqueInetSvcRef * InetSvcRef;

/*INET_IP


enum {
   INET_IP = 0x00,
   INET_TCP = 0x06,
   INET_UDP = 0x11
};
Constants
INET_IP

Available in Mac OS X v10.0 and later.
INET_TCP

Available in Mac OS X v10.0 and later.
INET_UDP

Available in Mac OS X v10.0 and later.*/

enum {
   INET_IP = 0x00,
   INET_TCP = 0x06,
   INET_UDP = 0x11
};


/*kIP_OPTIONS


enum {
   kIP_OPTIONS = 0x01,
   kIP_TOS = 0x02,
   kIP_TTL = 0x03,
   kIP_REUSEADDR = 0x04,
   kIP_DONTROUTE = 0x10,
   kIP_BROADCAST = 0x20,
   kIP_REUSEPORT = 0x0200,
   kIP_HDRINCL = 0x1002,
   kIP_RCVOPTS = 0x1005,
   kIP_RCVDSTADDR = 0x1007,
   kIP_MULTICAST_IF = 0x1010,
   kIP_MULTICAST_TTL = 0x1011,
   kIP_MULTICAST_LOOP = 0x1012,
   kIP_ADD_MEMBERSHIP = 0x1013,
   kIP_DROP_MEMBERSHIP = 0x1014,
   kIP_BROADCAST_IFNAME = 0x1015,
   kIP_RCVIFADDR = 0x1016
};
Constants
kIP_OPTIONS

Available in Mac OS X v10.0 and later.
kIP_TOS

Available in Mac OS X v10.0 and later.
kIP_TTL

Available in Mac OS X v10.0 and later.
kIP_REUSEADDR

AvailablekIP_OPTIONS


enum {
   kIP_OPTIONS = 0x01,
   kIP_TOS = 0x02,
   kIP_TTL = 0x03,
   kIP_REUSEADDR = 0x04,
   kIP_DONTROUTE = 0x10,
   kIP_BROADCAST = 0x20,
   kIP_REUSEPORT = 0x0200,
   kIP_HDRINCL = 0x1002,
   kIP_RCVOPTS = 0x1005,
   kIP_RCVDSTADDR = 0x1007,
   kIP_MULTICAST_IF = 0x1010,
   kIP_MULTICAST_TTL = 0x1011,
   kIP_MULTICAST_LOOP = 0x1012,
   kIP_ADD_MEMBERSHIP = 0x1013,
   kIP_DROP_MEMBERSHIP = 0x1014,
   kIP_BROADCAST_IFNAME = 0x1015,
   kIP_RCVIFADDR = 0x1016
};
Constants
kIP_OPTIONS

Available in Mac OS X v10.0 and later.
kIP_TOS

Available in Mac OS X v10.0 and later.
kIP_TTL

Available in Mac OS X v10.0 and later.
kIP_REUSEADDR

Available in Mac OS X v10.0 and later.
kIP_DONTROUTE

Available in Mac OS X v10.0 and later.
kIP_BROADCAST

Available in Mac OS X v10.0 and later.
kIP_REUSEPORT

Available in Mac OS X v10.0 and later.
kIP_HDRINCL

Available in Mac OS X v10.0 and later.
kIP_RCVOPTS

Available in Mac OS X v10.0 and later.
kIP_RCVDSTADDR

Available in Mac OS X v10.0 and later.
kIP_MULTICAST_IF

Available in Mac OS X v10.0 and later.
kIP_MULTICAST_TTL

Available in Mac OS X v10.0 and later.
kIP_MULTICAST_LOOP

Available in Mac OS X v10.0 and later.
kIP_ADD_MEMBERSHIP

Available in Mac OS X v10.0 and later.
kIP_DROP_MEMBERSHIP

Available in Mac OS X v10.0 and later.
kIP_BROADCAST_IFNAME

Available in Mac OS X v10.0 and later.
kIP_RCVIFADDR

Available in Mac OS X v10.0 and later. in Mac OS X v10.0 and later.
kIP_DONTROUTE

Available in Mac OS X v10.0 and later.
kIP_BROADCAST

Available in Mac OS X v10.0 and later.
kIP_REUSEPORT

Available in Mac OS X v10.0 and later.
kIP_HDRINCL

Available in Mac OS X v10.0 and later.
kIP_RCVOPTS

Available in Mac OS X v10.0 and later.
kIP_RCVDSTADDR

Available in Mac OS X v10.0 and later.
kIP_MULTICAST_IF

Available in Mac OS X v10.0 and later.
kIP_MULTICAST_TTL

Available in Mac OS X v10.0 and later.
kIP_MULTICAST_LOOP

Available in Mac OS X v10.0 and later.
kIP_ADD_MEMBERSHIP

Available in Mac OS X v10.0 and later.
kIP_DROP_MEMBERSHIP

Available in Mac OS X v10.0 and later.
kIP_BROADCAST_IFNAME

Available in Mac OS X v10.0 and later.
kIP_RCVIFADDR

Available in Mac OS X v10.0 and later.*/
enum {
   kIP_OPTIONS = 0x01,
   kIP_TOS = 0x02,
   kIP_TTL = 0x03,
   kIP_REUSEADDR = 0x04,
   kIP_DONTROUTE = 0x10,
   kIP_BROADCAST = 0x20,
   kIP_REUSEPORT = 0x0200,
   kIP_HDRINCL = 0x1002,
   kIP_RCVOPTS = 0x1005,
   kIP_RCVDSTADDR = 0x1007,
   kIP_MULTICAST_IF = 0x1010,
   kIP_MULTICAST_TTL = 0x1011,
   kIP_MULTICAST_LOOP = 0x1012,
   kIP_ADD_MEMBERSHIP = 0x1013,
   kIP_DROP_MEMBERSHIP = 0x1014,
   kIP_BROADCAST_IFNAME = 0x1015,
   kIP_RCVIFADDR = 0x1016
};


/*Basic Types and Constants
You use the following 16 bit value to distinguish among ports.

typedef UInt16 InetPort;
You can use the protocol names kTCPName, kUDPName, and kRawIPName when calling the OTCreateConfiguration function to configure an endpoint. You can use the protocol name kDNRName when calling the OTCreateConfiguration function to configure a mapper. The OTCreateConfiguration function is described in the chapter "Initializing and Closing Open Transport Reference" in this book.

#define kTCPName        "tcp"
#define kUDPName        "udp"
#define kRawIPName      "rawip"
#define kDNRName        "dnr"
You can use the constant kDefaultInternetServicesPath to create a TCP/IP service provider. Its value is a pointer to a configuration structure, so you do not use the OTCreateConfiguration function with this constant. Instead you use this constant as a parameter when calling the OTAsyncOpenInternetServices and the OTOpenInternetServices functions that create TCP/IP service providers.

#define kDefaultInternetServicesPath ((OTConfiguration*)-3)
You use the AF_INET and AF_DNS values as address types when filling in address structures. For details, see "Internet Address Structure" and "DNS Address Structure".

enum {
      AF_INET        = 2,     
      AF_DNS         = 42     
};
You can use the kOTAnyInetAddress value with the OTBind function when you are not concerned with the specific IP interface you are binding to.

enum {
      kOTAnyInetAddress = 0   
};
enum { 
      kMaxHostAddrs     = 10,
      kMaxSysStringLen  = 32,
      kMaxHostNameLen   = 255
};
typedef char InetDomainName[kMaxHostNameLen];
kMaxHostAddrs 
The maximum number of hosts returned by the function OTInetStringToAddress. 
kMaxSysStringLen 
The maximum length of the strings returned by the function OTInetSysInfo. 
kMaxHostNameLen 
The maximum length of an Internet domain name. 
Note 
The maximum valid domain-name length for fully qualified domain names includes the trailing period (.). Names not terminated with a period are limited to 
254 bytes.  
The following completion event codes are sent by TCP/IP service 
provider functions:

enum {
      T_DNRSTRINGTOADDRCOMPLETE  = 0x10000001,
      T_DNRADDRTONAMECOMPLETE    = 0x10000002,
      T_DNRSYSINFOCOMPLETE       = 0x10000003,
      T_DNRMAILEXCHANGECOMPLETE  = 0x10000004,
      T_DNRQUERYCOMPLETE         = 0x10000005
};
enum {
      kDefaultInetInterface      = -1,
      kInetInterfaceInfoVersion  = 2
};
kDefaultInetInterface 

Value passed to OTInetGetInterfaceInfo to get the interface configured in the TCP/IP control panel. 
kInetInterfaceInfoVersion 

Version number of the correct InetInterfaceInfo structure. 
The SET_TOS macro is used when negotiating IP_TOS option.

#define SET_TOS(prec,tos)(((0x7 & (prec)) << 5) | (0x1c & (tos)))*/
typedef UInt16 InetPort;

#define kTCPName        "tcp"
#define kUDPName        "udp"
#define kRawIPName      "rawip"
#define kDNRName        "dnr"


enum {
#ifndef AF_INET
      AF_INET        = 2,
#endif
      AF_DNS         = 42
};

enum {
      kOTAnyInetAddress = 0   
};
enum { 
      kMaxHostAddrs     = 10,
      kMaxSysStringLen  = 32,
      kMaxHostNameLen   = 255
};
//typedef char InetDomainName[kMaxHostNameLen];
enum {
      T_DNRSTRINGTOADDRCOMPLETE  = 0x10000001,
      T_DNRADDRTONAMECOMPLETE    = 0x10000002,
      T_DNRSYSINFOCOMPLETE       = 0x10000003,
      T_DNRMAILEXCHANGECOMPLETE  = 0x10000004,
      T_DNRQUERYCOMPLETE         = 0x10000005
};
enum {
    //  kDefaultInetInterface      = -1,
      kInetInterfaceInfoVersion  = 2
};

#define SET_TOS(prec,tos)(((0x7 & (prec)) << 5) | (0x1c & (tos)))

/*kDefaultInetInterface


enum {
   kDefaultInetInterface = -1
};
Constants
kDefaultInetInterface

Available in Mac OS X v10.0 and later.*/

enum {
   kDefaultInetInterface = -1
};

/*InetDomainName


typedef  InetDomainName[256];
Availability
Available in Mac OS X v10.0 and later.*/
typedef char   InetDomainName[256];

/*InetHost


typedef UInt32 InetHost;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 InetHost;

/*InetPort


typedef UInt16 InetPort;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 InetPort;

/*Internet Interface Information Structure
The OTInetGetInterfaceInfo function returns information about an interface on the local host in an internet interface information structure. The internet interface information structure is defined by the InetInterfaceInfo data type.

struct InetInterfaceInfo {
   InetHost       fAddress;         
   InetHost       fNetmask;         
   InetHost       fBroadcastAddr;
   InetHost       fDefaultGatewayAddr; 
   InetHost       fDNSAddr       
   UInt16         fVersion;      
   UInt16         fHWAddrLen  
   UInt8*         fHWAddr;       
   UInt32         fIfMTU            
   UInt8*         fReservedPtrs[2]; 
   InetDomainName fDomainName;      
   UInt32         fIPSecondaryCount;
   UInt8          fReserved[256];   
};
typedef struct InetInterfaceInfo InetInterfaceInfo;
Field Description
fAddress 
The IP address of the interface. 
fNetMask 
The subnet mask of the local IP network. 
fBroadcastAddr 
The broadcast address for the interface. 
fDefaultGatewayAddr 
The IP address of the default router. The default is a router that can forward any packet destined outside the locally connected subnet. 
fDNSAddr 
The address of a domain name server. This value can be returned by a server or typed in by the user during configuration of the TCP/IP interface. 
fDNSAddr 
The address of a domain name server. This value can be returned by a server or typed in by the user during configuration of the TCP/IP interface. If multiple DNS servers are available, only the first is returned. 
fVersion 
The version of the OTInetGetInterfaceInfo function; currently equal to kInetInterfaceInfoVersion. 
fHWAddrLen 
The length (in bytes) of the hardware address. This points into the fReserved field of this structure. It can be nil if the interface has no hardware address or if it won't fit. 
fHWAddr 
A pointer to the hardware address. 
fIfMTU 
The maximum transmission unit size in bytes permitted for this interface's hardware. 
fReservedPtrs 
Reserved. 
fDomainName 
The default domain name of the host as configured in the TCP/IP control panel. This name doesn't include the host name. 
fIPSecondaryCount 
The number of IP secondary address available. 
fReserved 
Reserved.*/

struct InetInterfaceInfo {
   InetHost       fAddress;
   InetHost       fNetmask;
   InetHost       fBroadcastAddr;
   InetHost       fDefaultGatewayAddr; 
   InetHost       fDNSAddr;
   UInt16         fVersion;
   UInt16         fHWAddrLen;
   UInt8*         fHWAddr;
   UInt32         fIfMTU;
   UInt8*         fReservedPtrs[2];
   InetDomainName fDomainName;
   UInt32         fIPSecondaryCount;
   UInt8          fReserved[256];
};
typedef struct InetInterfaceInfo InetInterfaceInfo;

/*DNS Address Structure

Holds host names, partially or fully-qualified domain names, or dotted-decimal format Internet addresses for use with a variety of Open Transport functions.

struct DNSAddress {
   OTAddressType fAddressType;
   InetDomainName fName;
};
typedef struct DNSAddress DNSAddress;
Fields
fAddressType

The address type. For a DNSAddress structure, this should be AF_DNS. 
fName

The name to be resolved by the DNR. 
Discussion

You can use the DNS (domain name system) address structure with the OTConnect function (TCP), with the OTSndUData function (UDP), or with the OTResolveAddress function (either TCP or UDP). If you do so, TCP/IP will resolve the name for you automatically. You can use the OTInitDNSAddress function to fill in a DNS address structure. The DNS address structure is defined by the DNSAddress data type. 

The address you specify can be just the host name (“otteam”), a partially qualified domain name (“otteam.ssw”), a fully qualified domain name (“otteam.ssw.apple.com.”), or an internet address in dotted-decimal format (“17.202.99.99”), and can optionally include a port number (“otteam.ssw.apple.com:25” or “17.202.99.99:25”).

Because the port number is not actually part of the domain name, it is possible to have a domain name–port number combination that exceeds 255 bytes. If you wish to specify such a string, you must provide a structure based on the DNS address structure that has sufficient space to contain the full string. In any case, the domain name itself cannot exceed 255 bytes.
Availability
Available in Mac OS X v10.0 and later.*/
struct DNSAddress {
   OTAddressType fAddressType;
   InetDomainName fName;
};
typedef struct DNSAddress DNSAddress;


/*Internet Host Information Sructure

Holds a set of IP addresses associated with an Internet host for use by the OTInetStringToAddress function.

struct InetHostInfo {
   InetDomainName name;
   InetHost addrs[10];
};
typedef struct InetHostInfo InetHostInfo;
Fields
name

The canonical name of the host. The canonical name is a fully qualified domain nam, never an alias. 
addrs

Up to ten IP addresses associated with this host name. Only multihomed hosts have more than one IP address. 
Availability
Available in Mac OS X v10.0 and later.*/
struct InetHostInfo {
   InetDomainName name;
   InetHost addrs[10];
};
typedef struct InetHostInfo InetHostInfo;

/*Internet Address Structure

Used for providing a TCP or UDP address to the OTConnect, OTSndURequest, or OTBind functions.

struct InetAddress {
   OTAddressType fAddressType;
   InetPort fPort;
   InetHost fHost;
   UInt8 fUnused[8];
};
typedef struct InetAddress InetAddress;
Fields
fAddressType

The address type. The field should be AF_INET, which identifies the structure as an InetAddress. 
fPort

The port number. 
fHost

The 32-bit IP address of the host. 
fUnused

Reserved.
Availability
Available in Mac OS X v10.0 and later.*/
struct InetAddress {
   OTAddressType fAddressType;
   InetPort fPort;
   InetHost fHost;
   UInt8 fUnused[8];
};
typedef struct InetAddress InetAddress;

/*DDPAddress


struct DDPAddress {
   OTAddressType fAddressType;
   UInt16 fNetwork;
   UInt8 fNodeID;
   UInt8 fSocket;
   UInt8 fDDPType;
   UInt8 fPad;
};
typedef struct DDPAddress DDPAddress;
Fields
fAddressType
fNetwork
fNodeID
fSocket
fDDPType
fPad
Availability
Available in Mac OS X v10.0 and later.*/
struct DDPAddress {
   OTAddressType fAddressType;
   UInt16 fNetwork;
   UInt8 fNodeID;
   UInt8 fSocket;
   UInt8 fDDPType;
   UInt8 fPad;
};
typedef struct DDPAddress DDPAddress;

/*AF_ATALK_FAMILY


enum {
   AF_ATALK_FAMILY = 0x0100,
   AF_ATALK_DDP = 0x0100,
   AF_ATALK_DDPNBP = AF_ATALK_FAMILY + 1,
   AF_ATALK_NBP = AF_ATALK_FAMILY + 2,
   AF_ATALK_MNODE = AF_ATALK_FAMILY + 3
};
Constants
AF_ATALK_FAMILY

Available in Mac OS X v10.0 and later.
AF_ATALK_DDP

Available in Mac OS X v10.0 and later.
AF_ATALK_DDPNBP

Available in Mac OS X v10.0 and later.
AF_ATALK_NBP

Available in Mac OS X v10.0 and later.
AF_ATALK_MNODE

Available in Mac OS X v10.0 and later.*/
enum {
   AF_ATALK_FAMILY = 0x0100,
   AF_ATALK_DDP = 0x0100,
   AF_ATALK_DDPNBP = AF_ATALK_FAMILY + 1,
   AF_ATALK_NBP = AF_ATALK_FAMILY + 2,
   AF_ATALK_MNODE = AF_ATALK_FAMILY + 3
};

/*kNBPMaxNameLength


enum {
   kNBPMaxNameLength = 32,
   kNBPMaxTypeLength = 32,
   kNBPMaxZoneLength = 32,
   kNBPSlushLength = 9,
   kNBPMaxEntityLength = (kNBPMaxNameLength + kNBPMaxTypeLength
+ kNBPMaxZoneLength + 3),
   kNBPEntityBufferSize = (kNBPMaxNameLength + kNBPMaxTypeLength
+ kNBPMaxZoneLength + kNBPSlushLength),
   kNBPWildCard = 0x3D,
   kNBPImbeddedWildCard = 0xC5,
   kNBPDefaultZone = 0x2A
};
Constants
kNBPMaxNameLength

Available in Mac OS X v10.0 and later.
kNBPMaxTypeLength

Available in Mac OS X v10.0 and later.
kNBPMaxZoneLength

Available in Mac OS X v10.0 and later.
kNBPSlushLength

Available in Mac OS X v10.0 and later.
kNBPMaxEntityLength

Available in Mac OS X v10.0 and later.
kNBPEntityBufferSize

Available in Mac OS X v10.0 and later.
kNBPWildCard

Available in Mac OS X v10.0 and later.
kNBPImbeddedWildCard

Available in Mac OS X v10.0 and later.
kNBPDefaultZone

Available in Mac OS X v10.0 and later.*/
enum {
   kNBPMaxNameLength = 32,
   kNBPMaxTypeLength = 32,
   kNBPMaxZoneLength = 32,
   kNBPSlushLength = 9,
   kNBPMaxEntityLength = (kNBPMaxNameLength + kNBPMaxTypeLength
+ kNBPMaxZoneLength + 3),
   kNBPEntityBufferSize = (kNBPMaxNameLength + kNBPMaxTypeLength
+ kNBPMaxZoneLength + kNBPSlushLength),
   kNBPWildCard = 0x3D,
   kNBPImbeddedWildCard = 0xC5,
   kNBPDefaultZone = 0x2A
};


//function


/*OTInetHostToString

Converts an an address in InetHost format into a character string in dotted-decimal notation. (Deprecated in Mac OS X v10.4.)

void OTInetHostToString (
   InetHost host,
   char * str
);
Parameters
host
str

A pointer to a C string containing an IP address in dotteddecimal notation (for example, “12.13.14.15”). You must allocate storage for this string and provide the pointer to the function.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

void OTInetHostToString (
   InetHost host,
   char * str
);

/*OTInetGetInterfaceInfo

Returns internet address information about the local host. (Deprecated in Mac OS X v10.4.)

OSStatus OTInetGetInterfaceInfo (
   InetInterfaceInfo * info,
   SInt32 val
);
Parameters
info
val

An index into the local host’s array of configured IP interfaces. Specify 0 for information about the first interface. Specify kDefaultInetInterface to get information about the primary interface.
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Because the architecture of Open Transport TCP/IP provides for multihoming, in principle a given host can receive packets simultaneously through more than one network interface. For each IP interface configured for the local host, the OTInetGetInterfaceInfo function provides the internet address and subnet mask, a default gateway (that is, a gateway, if any exists, that can be used to route any packet to all destinations outside the locally connected subnet), and a domain name server, if any is known. The function also returns the version number of the OTInetGetInterfaceInfo function and, if available, the broadcast address for each interface. If the broadcast address is not available, you can determine it from the internet address and subnet mask.

Because multihoming has not been implemented in the initial release of Open Transport, the OTInetGetInterfaceInfo function never returns information for more than one interface.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

OSStatus OTInetGetInterfaceInfo (
   InetInterfaceInfo * info,
   SInt32 val
);

/*OTInitDNSAddress

Fills in a DNSAddress structure with the data you provide. (Deprecated in Mac OS X v10.4.)

OTByteCount OTInitDNSAddress (
   DNSAddress * addr,
   char * str
);
Parameters
addr
str

A pointer to a domain name string. This string can be just a host name (otteam), a partially qualified domain name (for example, “otteam.ssw”), a fully qualified domain name (for example, “otteam.ssw.apple.com.”), or an internet address in dotteddecimal format (for example, “17.202.99.99”), and can optionally include the port number (for example, “otteam.ssw.apple.com:25” or “17.202.99.99:25”).
Return Value

See the description of the OTByteCount data type.
Discussion

This function fills in the fAddressType field of the DNSAddress structure with the value AF_DNS, fills in the fName field with the address string you specify, and returns the size of the resulting DNSAddress structure as an unsigned integer. You can use the DNSAddress structure to provide an address when you use a UDP or TCP endpoint. If you do so, the domain name resolver resolves the address for you automatically.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/

OTByteCount OTInitDNSAddress (
   DNSAddress * addr,
   char * str
);

/*OTInitInetAddress

Fills in an InetAddress structure with the data you provide. (Deprecated in Mac OS X v10.4.)

void OTInitInetAddress (
   InetAddress * addr,
   InetPort port,
   InetHost host
);
Parameters
addr
port
host
Discussion

This function fills in the fAddressType field of the InetAddress structure with the value AF_INET. You use the InetAddress structure when providing a TCP or UDP address to the Open Transport functions OTConnect, OTSndURequest, and OTBind. You are not required to use the OTInitInetAddress function when creating an InetAddress structure; this function is provided for your convenience only.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/
void OTInitInetAddress (
   InetAddress * addr,
   InetPort port,
   InetHost host
);

/*OTInetStringToAddress

Resolves a domain name to its equivalent internet addresses. (Deprecated in Mac OS X v10.4.)

OSStatus OTInetStringToAddress (
   InetSvcRef ref,
   char * name,
   InetHostInfo * hinfo
);
Parameters
ref
name

A pointer to the domain name you want to resolve. This can be a host name, a partially qualified domain name, a fully qualified domain name, or an internet address in dotted-decimal format.
hinfo
Return Value

A result code. See “Open Transport Result Codes”.
Discussion

Because the architecture of Open Transport TCP/IP provides for multihoming, a single host can be associated with multiple internet addresses. You can use the OTInetStringToAddress function to return multiple addresses for multihomed hosts.

Because multihoming has not been implemented in the initial release of Open Transport, the OTInetStringToAddress function never returns more than one address.

If you specify an internet address in dotted-decimal format for the hinfo parameter, the OTInetStringToAddress function places that address in the InetHostInfo.name field instead of a canonical domain name.

If you call the OTInetStringToAddress function asynchronously, the TCP/IP service provider calls your notifier function with the T_DNRSTRINGTOADDRCOMPLETE completion event code when the function completes. The cookie parameter to the notifier function contains the pointer you specified in the hinfo parameter. If you had more than one simultaneous outstanding call to the OTInetStringToAddress function, you can use this information to determine which call has completed execution.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
OpenTransportProviders.h*/
OSStatus OTInetStringToAddress (
   InetSvcRef ref,
   char * name,
   InetHostInfo * hinfo
);

/*OTAsyncOpenInternetServices
C INTERFACE
OSStatus OTAsyncOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OTNotifyProcPtr proc,
                                         
C++ INTERFACE
None. C++ clients use the C interface to this function.

PARAMETERS
cfig 
A pointer to a network configuration structure. You can obtain the default configuration by using the constant kDefaultInternetServicesPath for this parameter. 
oflag 
Reserved. Must be set to 0. 
proc 
A pointer to your notifier function. The TCP/IP service provider passes the internet services reference to your notifier function in the cookie parameter. 
contextPtr 
A pointer for your use. The TCP/IP service provider passes this value unchanged to your notifier function. 
function result 
A result code. See Appendix B for additional information. 
DISCUSSION
You must open a TCP/IP service provider before calling any TCP/IP services functions other than the address utility functions. You must provide the Internet services reference when calling any of these non-utility functions. The OTAsyncOpenInternetServices function runs asynchronously and sets the mode of the TCP/IP service provider as asynchronous.

For information on how to specify options using the cfig parameter, see Table 11-2.

SEE ALSO
The OTOpenInternetServices function.*/
OSStatus OTAsyncOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OTNotifyProcPtr proc,
                                           int contextPtr/*hys*/);
                  
                       
/*OTOpenInternetServices
Opens the TCP/IP service provider and returns an internet services reference. 

C INTERFACE
InetSvcRef OTOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OSStatus *
C++ INTERFACE
None. C++ clients use the C interface to this function.

PARAMETERS
cfig 
A pointer to a network configuration structure. You can obtain the default configuration by using the constant kDefaultInternetServicesPath for this parameter. 
oflag 
Reserved. Must be set to 0. 
err 
A pointer to the function result. 
function result 
An internet services reference. 
DISCUSSION
You must open a TCP/IP service provider before calling any TCP/IP service functions other than the address utility functions. The return value of this function is the internet services reference. You must provide the internet services reference when calling any of these non-utility functions. The OTOpenInternetServices function runs synchronously and also sets the mode of the TCP/IP service provider as synchronous.

If you want to set an option as part of the configuration string, you should translate the option's constant name, given in the header files, into a string that the configuration functions can parse. For the TCP/IP options, Table 11-2 provides the constant name used in "Options" and the value to used in the configuration string

SEE ALSO
The OTAsyncOpenInternetServices function.*/

InetSvcRef OTOpenInternetServices (OTConfiguration *cfig,
                                          OTOpenFlags oflag,
                                          OSStatus *err);

#ifdef __cplusplus
}

#endif

#endif

#endif