#ifndef __IOFireWireFamilyCommon_H__
#define __IOFireWireFamilyCommon_H__


#ifndef __IOKIT_IOTYPES_H
	#include <IOKit/IOTypes.h>
#endif

#include <IOKit/IOKitLib.h>

#include <APPLE/IOKit/firewire/IOFireWireFamilyCommon.h>

/*IOFireWireFamily error codes

See Also:
kIOFireWireBusReset
kIOConfigNoEntry
kIOFireWirePending
kIOFireWireLastDCLToken
kIOFireWireConfigROMInvalid
kIOFireWireAlreadyRegistered
kIOFireWireMultipleTalkers
kIOFireWireChannelActive
kIOFireWireNoListenerOrTalker
kIOFireWireNoChannels
kIOFireWireChannelNotAvailable
kIOFireWireSeparateBus
kIOFireWireBadSelfIDs
kIOFireWireLowCableVoltage
kIOFireWireInsufficientPower
kIOFireWireOutOfTLabels
kIOFireWireBogusDCLProgram
kIOFireWireTalkingAndListening
kIOFireWireHardwareSlept
kIOFireWireCompleting
kIOFWMessageServiceIsRequestingClose
kIOFWMessagePowerStateChanged
kIOFWMessageTopologyChanged
#define kIOFireWireBusReset ( ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x10)+kFWResponseBusResetError) //! e0008020 
    Bus reset during command execution (current bus generation does not match that specified in 
    command)
#define kIOConfigNoEntry ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x1) //! e0008001 Can't find requested entry 
    in ROM
#define kIOFireWirePending ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x2) //! e0008002 In pending queue waiting to
    execute
#define kIOFireWireLastDCLToken ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x3) //! e0008003 Last DCL callback of 
    program ( internal use)
#define kIOFireWireConfigROMInvalid ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x4) //! e0008004 Config ROM is invalid
#define kIOFireWireAlreadyRegistered ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x5) //! e0008005 Already registered
#define kIOFireWireMultipleTalkers ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x6) //! e0008006 There are multiple talkers
#define kIOFireWireChannelActive ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x7) //! e0008007 The channel is active
#define kIOFireWireNoListenerOrTalker ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x8) //! e0008008 The is no listener or 
    talker
#define kIOFireWireNoChannels ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x9) //! e0008009 There are no channels
#define kIOFireWireChannelNotAvailable ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0xA) //! e000800A The channel is not 
    available
#define kIOFireWireSeparateBus ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xB) //! e000800B Separate bus
#define kIOFireWireBadSelfIDs ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xC) //! e000800C The self IDs are bad
#define kIOFireWireLowCableVoltage ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xD) //! e000800D There is low cable voltage
#define kIOFireWireInsufficientPower ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xE) //! e000800E There is not enough power
#define kIOFireWireOutOfTLabels ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xF) //! e000800f There are no more T labels
#define kIOFireWireBogusDCLProgram ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x101) //! e0008101 Not a valid DCL program. 
    Used for address space response code.
#define kIOFireWireTalkingAndListening ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x102) //! e0008102 Talking and listening. 
    Used for address space response code.
#define kIOFireWireHardwareSlept ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x103) //! e0008103 Hardware slept. Used for 
    address space response code.
#define kIOFireWireCompleting ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x104) //! e0008104 In the middle of 
    completing. Used for address space response code.
#define kIOFWMessageServiceIsRequestingClose ( UInt32) ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x7D0) //! e00087d0 The service is requesting
    close
#define kIOFWMessagePowerStateChanged ( UInt32) ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x7D1) //! e00087D1 The power state has 
    changed
#define kIOFWMessageTopologyChanged ( UInt32) ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x7D2) //! e00087D2 The bus topology has 
    changed*/
#define kIOFireWireBusReset ( ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x10)+kFWResponseBusResetError) //! e0008020 \
    Bus reset during command execution (current bus generation does not match that specified in \
    command)
#define kIOConfigNoEntry ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x1) //! e0008001 Can't find requested entry \
    in ROM
#define kIOFireWirePending ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x2) //! e0008002 In pending queue waiting to\
    execute
#define kIOFireWireLastDCLToken ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x3) //! e0008003 Last DCL callback of \
    program ( internal use)
#define kIOFireWireConfigROMInvalid ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x4) //! e0008004 Config ROM is invalid
#define kIOFireWireAlreadyRegistered ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x5) //! e0008005 Already registered
#define kIOFireWireMultipleTalkers ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x6) //! e0008006 There are multiple talkers
#define kIOFireWireChannelActive ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x7) //! e0008007 The channel is active
#define kIOFireWireNoListenerOrTalker ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x8) //! e0008008 The is no listener or \
    talker
#define kIOFireWireNoChannels ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0x9) //! e0008009 There are no channels
#define kIOFireWireChannelNotAvailable ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0xA) //! e000800A The channel is not \
    available
#define kIOFireWireSeparateBus ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xB) //! e000800B Separate bus
#define kIOFireWireBadSelfIDs ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xC) //! e000800C The self IDs are bad
#define kIOFireWireLowCableVoltage ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xD) //! e000800D There is low cable voltage
#define kIOFireWireInsufficientPower ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xE) //! e000800E There is not enough power
#define kIOFireWireOutOfTLabels ( ( ( ( 0x38)&0x3f)<<26)| ( ( ( 2)&0xfff)<<14)|0xF) //! e000800f There are no more T labels
#define kIOFireWireBogusDCLProgram ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x101) //! e0008101 Not a valid DCL program. \
    Used for address space response code.
#define kIOFireWireTalkingAndListening ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x102) //! e0008102 Talking and listening. \
    Used for address space response code.
#define kIOFireWireHardwareSlept ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x103) //! e0008103 Hardware slept. Used for \
    address space response code.
#define kIOFireWireCompleting ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x104) //! e0008104 In the middle of \
    completing. Used for address space response code.
#define kIOFWMessageServiceIsRequestingClose ( UInt32) ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x7D0) //! e00087d0 The service is requesting\
    close
#define kIOFWMessagePowerStateChanged ( UInt32) ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x7D1) //! e00087D1 The power state has \
    changed
#define kIOFWMessageTopologyChanged ( UInt32) ( ( ( ( 0x38)&0x3f)<<26)| ( ( (2)&0xfff)<<14)|0x7D2) //! e00087D2 The bus topology has \
    changed


#endif 
