#ifndef __IOKIT_IOWORKLOOP_H
#define __IOKIT_IOWORKLOOP_H

#include <libkern/c++/OSObject.h>
#include <IOKit/IOReturn.h>
#include <IOKit/IOLib.h>
#include <IOKit/IOLocks.h>

#include <IOKit/system.h>

class IOEventSource;
class IOTimerEventSource;
class IOCommandGate;

class IOWorkLoop : public OSObject
{
    OSDeclareDefaultStructors(IOWorkLoop)

public:

/*removeEventSource

public

virtual IOReturn removeEventSource(
    IOEventSource *toRemove); 
Parameters
toRemove
Pointer to IOEventSource subclass to remove.
Return Value

Returns kIOReturnSuccess if successful, kIOReturnBadArgument if toRemove couldn't be found. 
Discussion 

Remove an event source from the work loop. This function does not return until the work loop has acknowledged the removal of the event source. When an event has been removed the threadMain will always restart its loop and check all outstanding events. The event source will be released before return.*/
virtual IOReturn removeEventSource(
    IOEventSource *toRemove); 

/*addEventSource

public

virtual IOReturn addEventSource(
    IOEventSource *newEvent); 
Parameters
newEvent
Pointer to IOEventSource subclass to add.
Return Value

Always returns kIOReturnSuccess. 
Discussion 

Add an event source to be monitored by the work loop. This function does not return until the work loop has acknowledged the arrival of the new event source. When a new event has been added the threadMain will always restart its loop and check all outstanding events. The event source is retained by the work loop.*/
virtual IOReturn addEventSource(
    IOEventSource *newEvent); 

};


#endif
