#ifndef _IOKIT_IOSERVICE_H
#define _IOKIT_IOSERVICE_H

#include <IOKit/IORegistryEntry.h>
#include <IOKit/IOReturn.h>
#include <IOKit/IODeviceMemory.h>
#include <IOKit/IONotifier.h>
#include <IOKit/IOLocks.h>

#include <IOKit/IOKitDebug.h>
#include <IOKit/IOInterrupts.h>


#include <IOKit/pwr_mgt/IOPMpowerState.h>
#include <IOKit/IOServicePM.h>

//#include <IOKit/IOWorkLoop.h>//hys

extern "C" {
#include <kern/thread_call.h>
}

class IOPMinformee;
class IOPowerConnection;
class IOUserClient;
class IOPlatformExpert;

class IOWorkLoop;//hys

class IOService: public IORegistryEntry{
OSDeclareDefaultStructors(IOService)

public:
/*start


During an IOService instantiation, the start method is called when the IOService has been selected to run on the provider. 
public

virtual bool start(
    IOService *provider ); 
Return Value

true if the start was successful; false otherwise (which will cause the instance to be detached and usually freed). 
Discussion 

The registration process for an IOService (the provider) includes instantiating possible driver clients. The start method is called in the client instance when it has been selected (by its probe score and match category) to be the winning client. The client is already attached to the provider when start is called.*/
virtual bool start(
    IOService *provider ); 

/*close


Release active access to a provider. 
public

virtual void close(
    IOService *forClient, 
    IOOptionBits options = 0 ); 
Parameters
forClient
Designates the client of the provider requesting the close.
options
Options available for the close. The provider family may implement options for close; IOService defines none.
arg
Family specific arguments, ignored by IOService.
Discussion 

IOService provides generic open and close semantics to track clients of a provider that have established an active datapath. The use of open & close, and rules regarding ownership are family defined, and defined by the handleOpen / handleClose methods in the provider.*/
virtual void close(
    IOService *forClient, 
    IOOptionBits options = 0 ); 

/*stop


During an IOService termination, the stop method is called in its clients before they are detached & it is destroyed. 
public

virtual void stop(
    IOService *provider ); 
Discussion 

The termination process for an IOService (the provider) will call stop in each of its clients, after they have closed the provider if they had it open, or immediately on termination.*/
virtual void stop(
    IOService *provider ); 

/*isOpen


Determine whether a specific, or any, client has an IOService open. 
public

virtual bool isOpen(
    const IOService *forClient = 0 ) const; 
Parameters
forClient
If non-zero, isOpen returns the open state for that client. If zero is passed, isOpen returns the open state for all clients.
Return Value

true if the specific, or any, client has the IOService open. 
Discussion 

Returns the open state of an IOService with respect to the specified client, or when it is open by any client.*/
virtual bool isOpen(
    const IOService *forClient = 0 ) const; 

/*attach


Attaches an IOService client to a provider in the registry. 
public

virtual bool attach(
    IOService *provider ); 
Parameters
provider
The IOService object which will serve as this objects provider.
Return Value

false if the provider is inactive or on a resource failure; otherwise true. 
Discussion 

This function called in an IOService client enters the client into the registry as a child of the provider in the service plane. The provider must be active or the attach will fail. Multiple attach calls to the same provider are no-ops and return success. A client may be attached to multiple providers. Entering an object into the registry will retain both the client and provider until they are detached.*/
virtual bool attach(
    IOService *provider ); 

/*registerService


Start the registration process for a newly discovered IOService. 
public

virtual void registerService(
    IOOptionBits options = 0 ); 
Parameters
options
The default zero options mask is recommended & should be used in most cases. The registration process is usually asynchronous, with possible driver probing & notification occurring some time later. kIOServiceSynchronous may be passed to carry out the matching and notification process for currently registered clients before returning to the caller.
Discussion 

This function allows an IOService subclass to be published and made available to possible clients, by starting the registration process and delivering notifications to registered clients. The object should be completely setup and ready to field requests from clients before registerService is called.*/
virtual void registerService(
    IOOptionBits options = 0 ); 

/*getProvider


Returns an IOService's primary provider. 
public

virtual IOService * getProvider(
    void ) const; 
Return Value

Returns the first provider of the client, or zero if the IOService is not attached into the registry. The provider is retained while the client is attached, and should not be released by the caller. 
Discussion 

This function called in an IOService client will return the provider to which it was first attached. Since the majority of IOService objects have only one provider, this is a useful simplification and also supports caching of the provider when the registry is unchanged.*/
virtual IOService * getProvider(
    void ) const; 

/*terminate


Make an IOService inactive and begin its destruction. 
public

virtual bool terminate(
    IOOptionBits options = 0 ); 
Parameters
options
In most cases no options are needed. kIOServiceSynchronous may be passed to cause terminate to not return until the service is finalized.
Discussion 

Registering an IOService informs possible clients of its existance and instantiates drivers that may be used with it; terminate involves the opposite process of informing clients that an IOService is no longer able to be used and will be destroyed. By default, if any client has the service open, terminate fails. If the kIOServiceRequired flag is passed however, terminate will be sucessful though further progress in the destruction of the IOService will not proceed until the last client has closed it. The service will be made inactive immediately upon successful termination, and all its clients will be notified via their message method with a message of type kIOMessageServiceIsTerminated. Both these actions take place on the caller's thread. After the IOService is made inactive, further matching or attach calls will fail on it. Each client has its stop method called upon their close of an inactive IOService, or on its termination if they do not have it open. After stop, detach is called in each client. When all clients have been detached, the finalize method is called in the inactive service. The terminate process is inherently asynchronous since it will be deferred until all clients have chosen to close.*/

virtual bool terminate(
    IOOptionBits options = 0 ); 

/*finalize


The last stage in an IOService destruction. 
public

virtual bool finalize(
    IOOptionBits options ); 
Parameters
options
The options passed to the terminate method of the IOService are passed on to finalize.
Return Value

true. 
Discussion 

The finalize method is called in an inactive (ie. terminated) IOService after the last client has detached. IOService's implementation will call stop, close, and detach on each provider. When finalize returns, the object's retain count will have no references generated by IOService's registration process.*/
virtual bool finalize(
    IOOptionBits options ); 

/*message


Receive a generic message delivered from an attached provider. 
public

virtual IOReturn message(
    UInt32 type,
    IOService *provider, 
    void *argument = 0 ); 
Parameters
type
A type defined in IOMessage.h or defined by the provider family.
provider
The provider from which the message originates.
argument
An argument defined by the provider family, not used by IOService.
Return Value

An IOReturn code defined by the message type. 
Discussion 

A provider may deliver messages via the message method to its clients informing them of state changes, for example kIOMessageServiceIsTerminated or kIOMessageServiceIsSuspended. Certain messages are defined by IOKit in IOMessage.h while others may family dependent. This method is implemented in the client to receive messages.*/

virtual IOReturn message(
    UInt32 type,
    IOService *provider, 
    void *argument = 0 ); 

/*didTerminate


Passes a termination up the stack. 
public

virtual bool didTerminate(
    IOService *provider,
    IOOptionBits options,
    bool *defer ); 
Parameters
provider
The terminated provider of this object.
options
Options originally passed to terminate.
defer
If there is pending I/O that requires this object to persist, and the provider is not opened by this object set defer to true and call the IOService::didTerminate() implementation when the I/O completes. Otherwise, leave defer set to its default value of false.
Return Value

true. 
Discussion 

Notification that a provider has been terminated, sent after recursing up the stack, in leaf-to-root order.*/
virtual bool didTerminate(
    IOService *provider,
    IOOptionBits options,
    bool *defer ); 

/*willTerminate


Passes a termination up the stack. 
public

virtual bool willTerminate(
    IOService *provider,
    IOOptionBits options ); 
Parameters
provider
The terminated provider of this object.
options
Options originally passed to terminate.
Return Value

true. 
Discussion 

Notification that a provider has been terminated, sent before recursing up the stack, in root-to-leaf order.*/
virtual bool willTerminate(
    IOService *provider,
    IOOptionBits options );

/*probe


During an IOService instantiation probe a matched service to see if it can be used. 
public

virtual IOService * probe(
    IOService *provider, 
    SInt32 *score ); 
Parameters
provider
The registered IOService which matches a driver personality's matching dictionary.
score
Pointer to the current driver's probe score, which is used to order multiple matching drivers in the same match category. It defaults to the value of the IOProbeScore property in the drivers property table, or kIODefaultProbeScore if none is specified. The probe method may alter the score to affect start order.
Return Value

Returns an IOService instance or zero when the probe is unsuccessful. In almost all cases the value of this is returned on success. If another IOService object is returned, the probed instance is detached and freed, and the returned instance is used in its stead for start. 
Discussion 

The registration process for an IOService (the provider) includes instantiating possible driver clients. The probe method is called in the client instance to check the matched service can be used before the driver is considered to be started. Since matching screens many possible providers, in many cases the probe method can be left unimplemented by IOService subclasses. The client is already attached to the provider when probe is called.*/
virtual IOService * probe(
    IOService *provider, 
    SInt32 *score ); 

/*isInactive


Check the IOService has been terminated, and is in the process of being destroyed. 
public

bool isInactive(
    void ) const; 
Return Value

true if the IOService has been terminated. 
Discussion 

When an IOService is successfully terminated, it is immediately made inactive, which blocks further attach()es, matching or notifications occuring on the object. It remains inactive until the last client closes, and is then finalized and destroyed.*/
bool isInactive(
    void ) const; 

/*open


Request active access to a provider. 
public

virtual bool open(
    IOService *forClient, 
    IOOptionBits options = 0, 
    void *arg = 0 ); 
Parameters
forClient
Designates the client of the provider requesting the open.
options
Options for the open. The provider family may implement options for open; IOService defines only kIOServiceSeize to request the device be withdrawn from its current owner.
Return Value

true if the open was successful; false otherwise. 
Discussion 

IOService provides generic open and close semantics to track clients of a provider that have established an active datapath. The use of open & close, and rules regarding ownership are family defined, and defined by the handleOpen / handleClose methods in the provider. Some families will limit access to a provider based on its open state.*/
virtual bool open(
    IOService *forClient, 
    IOOptionBits options = 0, 
    void *arg = 0 );

/*getWorkLoop


Returns the current work loop or provider->getWorkLoop(). 
public

virtual IOWorkLoop * getWorkLoop() const; 
Return Value

Always returns a work loop, either the current work loop or it walks up the getProvider chain calling getWorkLoop. Eventually it will reach a valid work loop based driver or the root of the io tree where it will return a system wide work loop. Returns 0 if it fails to find (or create) 
Discussion 

This function returns a valid work loop that a client can use to add an IOCommandGate to. The intention is that an IOService client has data that needs to be protected but doesn't want to pay the cost of an entire dedicated thread. This data has to be accessed from a providers call out context as well. So to achieve both of these goals the client creates an IOCommandGate to lock access to his data but he registers it with the providers work loop, i.e. the work loop which will make the completion call outs. In one fell swoop we avoid a potentially nasty deadlock 'cause a work loop's gate is recursive.*/;

virtual IOWorkLoop * getWorkLoop() const;

/*setProperties


Optionally supported external method to set properties in a registry entry. 
public

virtual IOReturn setProperties(
    OSObject *properties ); 
Parameters
properties
Any OSObject subclass, to be interpreted by the implementing method - for example an OSDictionary, OSData etc. may all be appropriate.
Return Value

An IOReturn code to be returned to the caller. 
Discussion 

This method is not implemented by IORegistryEntry, but is available to kernel and non-kernel clients to set properties in a registry entry. IOUserClient provides connection based, more controlled access to this functionality and may be more appropriate for many uses, since there is no differentiation between clients available to this method.*/
virtual IOReturn setProperties(
    OSObject *properties ); 

};


#endif