#ifndef TEXTSERVICES_H
#define TEXTSERVICES_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif

#ifndef AEINTERACTION_H
#include <HIToolbox/AEInteraction.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef ATSUNICODE_H
#include <QD/ATSUnicode.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Low-level Routine Selectors

Specify low level routines which are dispatched directly to the Component Manager.

enum {
   kCMGetScriptLangSupport = 0x0001,
   kCMInitiateTextService = 0x0002,
   kCMTerminateTextService = 0x0003,
   kCMActivateTextService = 0x0004,
   kCMDeactivateTextService = 0x0005,
   kCMTextServiceEvent = 0x0006,
   kCMGetTextServiceMenu = 0x0007,
   kCMTextServiceMenuSelect = 0x0008,
   kCMFixTextService = 0x0009,
   kCMSetTextServiceCursor = 0x000A,
   kCMHidePaletteWindows = 0x000B,
   kCMGetTextServiceProperty = 0x000C,
   kCMSetTextServiceProperty = 0x000D
};
Constants
kCMGetScriptLangSupport

Specifies the function GetScriptLanguageSupport; Component Manager call selector 1.

Available in Mac OS X v10.0 and later.
kCMInitiateTextService

Specifies the function InitiateTextService; Component Manager call selector 2.

Available in Mac OS X v10.0 and later.
kCMTerminateTextService

Specifies the function TerminateTextService; Component Manager call selector 3.

Available in Mac OS X v10.0 and later.
kCMActivateTextService

Specifies the function ActivateTextService; Component Manager call selector 4.

Available in Mac OS X v10.0 and later.
kCMDeactivateTextService

Specifies the function DeactivateTextService; Component Manager call selector 5.

Available in Mac OS X v10.0 and later.
kCMTextServiceEvent

Specifies the function TextServiceEventRef; Component Manager call selector 6.

Available in Mac OS X v10.0 and later.
kCMGetTextServiceMenu

Specifies the function GetTextServiceMenu; Component Manager call selector 7.

Available in Mac OS X v10.0 and later.
kCMTextServiceMenuSelect

Component Manager call selector 8.

Available in Mac OS X v10.0 and later.
kCMFixTextService

Specifies the function FixTextService; Component Manager call selector 9.

Available in Mac OS X v10.0 and later.
kCMSetTextServiceCursor

Component Manager call selector 10.

Available in Mac OS X v10.0 and later.
kCMHidePaletteWindows

Specifies the function HidePaletteWindows; Component Manager call selector 11.

Available in Mac OS X v10.0 and later.
kCMGetTextServiceProperty

Specifies the function GetTextServiceProperty; Component Manager call selector 12.

Available in Mac OS X v10.0 and later.
kCMSetTextServiceProperty

Specifies the function SetTextServiceProperty; Component Manager call selector 13.

Available in Mac OS X v10.0 and later.*/
enum {
   kCMGetScriptLangSupport = 0x0001,
   kCMInitiateTextService = 0x0002,
   kCMTerminateTextService = 0x0003,
   kCMActivateTextService = 0x0004,
   kCMDeactivateTextService = 0x0005,
   kCMTextServiceEvent = 0x0006,
   kCMGetTextServiceMenu = 0x0007,
   kCMTextServiceMenuSelect = 0x0008,
   kCMFixTextService = 0x0009,
   kCMSetTextServiceCursor = 0x000A,
   kCMHidePaletteWindows = 0x000B,
   kCMGetTextServiceProperty = 0x000C,
   kCMSetTextServiceProperty = 0x000D
};

/*ScriptLanguageRecord

Identifies a specific script-language combination.

struct ScriptLanguageRecord {
   ScriptCode fScript;
   LangCode fLanguage;
};
typedef struct ScriptLanguageRecord ScriptLanguageRecord;
Fields
fScript

A ScriptCode value identifying a particular set of written characters (for example, Roman versus Cyrillic) and their encoding. 
fLanguage

A LangCode value identifying a particular language (for example, English), as represented using a particular ScriptCode value.
Discussion

Structures of type ScriptLanguageRecord are used in the functions SetDefaultInputMethod, GetDefaultInputMethod, SetTextServiceLanguage, and GetTextServiceLanguage. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ScriptLanguageRecord {
   ScriptCode fScript;
   LangCode fLanguage;
};
typedef struct ScriptLanguageRecord ScriptLanguageRecord;

/*ScriptLanguageSupport

Lists a component’s supported scripts and languages.

struct ScriptLanguageSupport {
   short fScriptLanguageCount;
   ScriptLanguageRecord fScriptLanguageArray[1];
};
typedef struct ScriptLanguageSupport ScriptLanguageSupport;
typedef ScriptLanguageSupport * ScriptLanguageSupportPtr;
typedef ScriptLanguageSupportPtr * ScriptLanguageSupportHandle;
Fields
fScriptLanguageCount

An integer specifying the number of ScriptLanguageRecord structures provided in the fScriptLanguageArray field.
fScriptLanguageArray

A variable-length array of structures of type ScriptLanguageRecord. Each of these structures identifies a specific script-language combination. 
Discussion

A structure of type ScriptLanguageSupport is used in the function GetScriptLanguageSupport to list all of a component’s supported scripts and languages. If you are a component developer filling out a ScriptLanguageSupport structure, you should start with the component’s primary script and language as specified in the componentFlags field of its ComponentDescription structure. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ScriptLanguageSupport {
   short fScriptLanguageCount;
   ScriptLanguageRecord fScriptLanguageArray[1];
};
typedef struct ScriptLanguageSupport ScriptLanguageSupport;
typedef ScriptLanguageSupport * ScriptLanguageSupportPtr;
typedef ScriptLanguageSupportPtr * ScriptLanguageSupportHandle;

//function

/*SendTextInputEvent

Sends Carbon text input events from a text service component to a client application.

OSStatus SendTextInputEvent (
   EventRef inEvent
);
Parameters
inEvent

A reference to the Carbon event to be sent. 
Return Value

A result code. See “Text Services Manager Result Codes”. The SendTextInputEvent function returns noErr if the event is successfully handled. If the event is not handled, the function may return a Carbon Event Manager error, as well as Apple event or Text Encoding Conversion Manager errors.
Discussion

The SendTextInputEvent function allows a Carbon text service component on Mac OS X to send a Carbon text input event to the Text Services Manager for dispatching to a client application. This function can be used for events of Carbon event class kEventClassTextInput as well as for events of class kEventClassTSMDocumentAccess.

If the client application does not handle a particular Carbon text input event, the Text Services Manager converts the event to the corresponding Apple event and sends it again. An exception to this is when the application is not Unicode-aware (that is, the active TSM document was not created with the kUnicodeDocument interface type). In this case, a kEventUnicodeForKeyEvent Carbon event would not be converted to the corresponding Apple event (kUnicodeNotFromInputMethod). In every case, if the application handles neither the Unicode Carbon text input event nor the corresponding Apple event, the Text Services Manager converts the component’s text input event into a stream of “classic” key events for delivery to WaitNextEvent clients.

If the application has no active TSM documents or has called the function UseInputWindow to request input via the Text Services Manager’s floating input window—that is, if the application does not handle the event at all—the Text Services Manager routes the component’s text input event to the floating input window to allow bottom-line input. 
Availability
Not available in CarbonLib.
Available in Mac OS X v 10.0 and later.
Carbon Porting Notes

Note that this function replaces the function SendAEFromTSMComponent on Mac OS X only. With Mac OS X, text service components must be Carbon clients. This is in contrast to Mac OS 8 and 9, where text service components must not be Carbon clients. (This restriction is due to the fact that it is potentially destabilizing for a Carbon-based component to load Carbon in the context of a non-Carbon application.) Therefore, text service components use Carbon text input events and the SendTextInputEvent function only on Mac OS X. The function SendAEFromTSMComponent must be used by components running on Mac OS 8 and 9.

On any system, the Text Services Manager automatically converts component-originated text input events to the proper form for client applications. On Mac OS X, the Text Services Manager automatically converts component-originated Carbon events to Apple events, if a client application does not provide handlers for Carbon events. Conversely, on Mac OS 8 and 9, the Text Services Manager automatically converts component-originated Apple events to Carbon events and provides these Carbon events to applications, so they have the option of handling them.
Declared In
TextServices.h*/

OSStatus SendTextInputEvent (
   EventRef inEvent
);


#ifdef __cplusplus
}
#endif

#endif