#ifndef CONTROLDEFINITIONS_H
#define CONTROLDEFINITIONS_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef APPEARANCE_H
#include <HIToolbox/Appearance.h>
#endif

#ifndef CARBONEVENTS_H
#include <HIToolbox/CarbonEvents.h>
#endif

#ifndef CONTROLS_H
#include <HIToolbox/Controls.h>
#endif

#ifndef LISTS_H
#include <HIToolbox/Lists.h>
#endif

#ifndef MACHELP_H
#include <HIToolbox/MacHelp.h>
#endif

#ifndef MENUS_H
#include <HIToolbox/Menus.h>
#endif


//#include <HYS/HIToolbox/ControlDefinitions.h>
#include <APPLE/HIToolbox/ControlDefinitions.h>

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Control Kind Clock Constant

enum {
   kControlKindClock = 'clck'
};*/
enum {
   kControlKindClock = 'clck'
};

/*Control Kind Push and Radio Button Constants

enum {
   kControlKindPushButton = 'push',
   kControlKindPushIconButton = 'picn',
   kControlKindRadioButton = 'rdio',
   kControlKindCheckBox = 'cbox'
};*/
enum {
   kControlKindPushButton = 'push',
   kControlKindPushIconButton = 'picn',
   kControlKindRadioButton = 'rdio',
   kControlKindCheckBox = 'cbox'
};

/*DataBrowserDragFlags

Defines a data type for values used in drag callbacks. 

typedef unsigned long DataBrowserDragFlags;
Discussion

This data type is used as a return value for the item-accept-drag callback (DataBrowserItemAcceptDragProcPtr) and as a parameter to the item-receive-drag callback (DataBrowserItemReceiveDragProcPtr). The values associated with this data type are kDataBrowserItemIsDragTarget and kDataBrowserItemNoState. See “Item States” for more information on these constants.
Availability
Available in Mac OS X v10.0 and later.*/
typedef unsigned long DataBrowserDragFlags;

/*Bevel Button Menu Control Data Tag Constants

enum {
   kControlBevelButtonLastMenuTag = 'lmnu',
   kControlBevelButtonMenuDelayTag = 'mdly'
};
Constants
kControlBevelButtonLastMenuTag

Gets the menu ID of the last menu selected in the submenu or main menu. Available with Appearance Manager 1.0.1 and later.

Data type returned: SInt16

Available in Mac OS X v10.0 and later.
kControlBevelButtonMenuDelayTag

Gets or sets the delay (in number of ticks) before the menu is displayed. Available with Appearance Manager 1.0.1 and later.

Data type returned or set: SInt32

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function.*/
enum {
   kControlBevelButtonLastMenuTag = 'lmnu',
   kControlBevelButtonMenuDelayTag = 'mdly'
};

/*Control Kind Scroll Bar Constant

enum {
   kControlKindScrollBar = 'sbar'
};*/
enum {
   kControlKindScrollBar = 'sbar'
};

/*Control Kind Edit Unicode Text Constant

enum {
   kControlKindEditUnicodeText = 'eutx'
};*/
enum {
   kControlKindEditUnicodeText = 'eutx'
};

/*Radio Button Value Constants

enum {
   kControlRadioButtonUncheckedValue = 0,
   kControlRadioButtonCheckedValue = 1,
   kControlRadioButtonMixedValue = 2
};
Constants
kControlRadioButtonUncheckedValue

The radio button is unselected.

Available in Mac OS X v10.0 and later.
kControlRadioButtonCheckedValue

The radio button is selected.

Available in Mac OS X v10.0 and later.
kControlRadioButtonMixedValue

Mixed value. Indicates that a setting is on for some elements in a selection and off for others. This state only applies to standard Appearance-compliant radio buttons. 

Available in Mac OS X v10.0 and later.
Discussion

These constants specify the value of a standard radio button control and are passed in the newValue parameter of SetControlValue and are returned by GetControlValue. 
Version Notes

The radio button value constants are changed with Appearance Manager 1.0 to support mixed-value radio buttons.*/
enum {
   kControlRadioButtonUncheckedValue = 0,
   kControlRadioButtonCheckedValue = 1,
   kControlRadioButtonMixedValue = 2
};


/*Control Slider Orientation Constants

typedef UInt16 ControlSliderOrientation;
enum {
   kControlSliderPointsDownOrRight = 0,
   kControlSliderPointsUpOrLeft = 1,
   kControlSliderDoesNotPoint = 2
};*/
typedef UInt16 ControlSliderOrientation;
enum {
   kControlSliderPointsDownOrRight = 0,
   kControlSliderPointsUpOrLeft = 1,
   kControlSliderDoesNotPoint = 2
};


/*Control Picture Handle Tag Constant

enum {
   kControlPictureHandleTag = 'pich'
};*/
enum {
   kControlPictureHandleTag = 'pich'
};

/*List View Header Description Version

Defines the version of the list view header description data structure.

enum {
   kDataBrowserListViewLatestHeaderDesc = 0
};
Constants
kDataBrowserListViewLatestHeaderDesc

A convenience constant that specifies the version of the list view header description data structure.

Available in Mac OS X v10.0 and later.*/
enum {
   kDataBrowserListViewLatestHeaderDesc = 0
};


/*DataBrowserTableViewColumnIndex

Defines a data type for a value that specifies column position in a table view. 

typedef UInt32 DataBrowserTableViewColumnIndex;
Discussion

This data type is typically used for table-view formatting. Column indices are zero based.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 DataBrowserTableViewColumnIndex;


/*Scroll Bar Control Definition ID Constants

enum {
   kControlScrollBarProc = 384,
   kControlScrollBarLiveProc = 386
};
Constants
kControlScrollBarProc

Resource ID: 24

Appearance-compliant scroll bar. This control definition is new with the Appearance Manager and is not supported unless the Appearance Manager is available.

Available in Mac OS X v10.0 and later.
kControlScrollBarLiveProc

Resource ID: 24

Appearance-compliant scroll bar with live feedback. This control definition is new with the Appearance Manager and is not supported unless the Appearance Manager is available.

Available in Mac OS X v10.0 and later.
Discussion

When creating a control, your application supplies a control definition ID to one of the Control Manager control-creation functions or to the control resource; see 'CNTL'. The control definition ID indicates the type of control to create. A control definition ID is an integer that contains the resource ID of a control definition function in its upper 12 bits and a variation code in its lower 4 bits. A control definition ID is derived as follows:

control definition ID = 16 * ( 'CDEF' resource ID) + variation code

A control definition function determines how a control generally looks and behaves. Control definition functions are stored as resources of type 'CDEF'. Various Control Manager functions call a control definition function whenever they need to perform some control-dependent action, such as drawing the control on the screen. For more information on how to create a control definition function, see ControlDefProcPtr.

A control definition function, in turn, can use a variation code to describe variations of the same basic control. For example, all pop-up arrows share the same basic control definition function, which is stored in a resource of type 'CDEF' and has a resource ID of 12. The standard pop-up arrow is large and points to the right; it has a control definition ID of 192. A variation of this is a large, left-pointing arrow, which has a control definition ID of 193. Still another variation, in which the arrow points up, has a control definition ID of 194.

Your application can use the constants listed here in place of control definition IDs.*/
enum {
   kControlScrollBarProc = 384,
   kControlScrollBarLiveProc = 386
};


/*User Pane Control Definition ID Constant

enum {
   kControlUserPaneProc = 256
};
Constants
kControlUserPaneProc

Resource ID: 16

User pane. This control definition is new with the Appearance Manager and is not supported unless the Appearance Manager is available.

Available in Mac OS X v10.0 and later.
Discussion

When creating a control, your application supplies a control definition ID to one of the Control Manager control-creation functions or to the control resource; see 'CNTL'. The control definition ID indicates the type of control to create. A control definition ID is an integer that contains the resource ID of a control definition function in its upper 12 bits and a variation code in its lower 4 bits. A control definition ID is derived as follows:

control definition ID = 16 * ( 'CDEF' resource ID) + variation code

A control definition function determines how a control generally looks and behaves. Control definition functions are stored as resources of type 'CDEF'. Various Control Manager functions call a control definition function whenever they need to perform some control-dependent action, such as drawing the control on the screen. For more information on how to create a control definition function, see ControlDefProcPtr.

A control definition function, in turn, can use a variation code to describe variations of the same basic control. For example, all pop-up arrows share the same basic control definition function, which is stored in a resource of type 'CDEF' and has a resource ID of 12. The standard pop-up arrow is large and points to the right; it has a control definition ID of 192. A variation of this is a large, left-pointing arrow, which has a control definition ID of 193. Still another variation, in which the arrow points up, has a control definition ID of 194.

Your application can use the constant listed here in place of a control definition ID.*/
enum {
   kControlUserPaneProc = 256
};



/*Bevel Button Control Data Tag Constants

enum {
   kControlBevelButtonContentTag = 'cont',
   kControlBevelButtonTransformTag = 'tran',
   kControlBevelButtonTextAlignTag = 'tali',
   kControlBevelButtonTextOffsetTag = 'toff',
   kControlBevelButtonGraphicAlignTag = 'gali',
   kControlBevelButtonGraphicOffsetTag = 'goff',
   kControlBevelButtonTextPlaceTag = 'tplc',
   kControlBevelButtonMenuValueTag = 'mval',
   kControlBevelButtonMenuHandleTag = 'mhnd',
   kControlBevelButtonMenuRefTag = 'mhnd',
   kControlBevelButtonCenterPopupGlyphTag = 'pglc',
   kControlBevelButtonIsMultiValueMenuTag = 'mult'
};
Constants
kControlBevelButtonContentTag

Gets or sets a bevel button’s content type for drawing see “Bevel Button Menu Constant”.

Data type returned or set: ControlButtonContentInfostructure

Available in Mac OS X v10.0 and later.
kControlBevelButtonTransformTag

Gets or sets a transform that is added to the standard transform of a bevel button

Data type returned or set: IconTransformType

Available in Mac OS X v10.0 and later.
kControlBevelButtonTextAlignTag

Gets or sets the alignment of text in a bevel button; see “Bevel Button Menu Constant”.

Data type returned or set: ControlButtonTextAlignment

Available in Mac OS X v10.0 and later.
kControlBevelButtonTextOffsetTag

Gets or sets the number of pixels that text is offset in a bevel button from the button’s left or right edge this is used with left, right, or system justification, but it is ignored when the text is center aligned.

Data type returned or set: SInt16

Available in Mac OS X v10.0 and later.
kControlBevelButtonGraphicAlignTag

Gets or sets the alignment of graphics in a bevel button in relation to any text the button may contain; see “Bevel Button Menu Constant”.

Data type returned or set: ControlButtonGraphicAlignment

Available in Mac OS X v10.0 and later.
kControlBevelButtonGraphicOffsetTag

Gets or sets the horizontal and vertical amounts that a graphic element contained in a bevel button is offset from the button’s edges this value is ignored when the graphic is specified to be center aligned on the button. Note that offset values should not be used for bevel buttons with content of type kControlContentIconRef, because IconRef based icons may change with a theme switch; see “Bevel Button Menu Constant”.

Data type returned or set: point

Available in Mac OS X v10.0 and later.
kControlBevelButtonTextPlaceTag

Gets or sets the placement of a bevel button’s text see “Bevel Button Menu Constant”.

Data type returned or set: ControlButtonTextPlacement

Available in Mac OS X v10.0 and later.
kControlBevelButtonMenuValueTag

Gets the menu value for a bevel button with an attached menu; see “Bevel Button Menu Constant”.

Data type returned: SInt16

Available in Mac OS X v10.0 and later.
kControlBevelButtonMenuHandleTag

Gets or sets the menu handle for a bevel button with an attached menu. To set a non-resource-based menu for a bevel button, you must pass in a non-zero value in the initialValue parameter of the NewControl function, then call the SetControlData function with the kControlBevelButtonMenuHandleTag constant and the return value from a call to the NewMenu function.

Data type returned: MenuHandle

Available in Mac OS X v10.0 and later.
kControlBevelButtonCenterPopupGlyphTag

Gets or sets the position of the pop-up arrow in a bevel button when a pop-up menu is attached.

Data type returned or set: Boolean; if true, glyph is vertically centered on the right; if false, glyph is on the bottom right.

Available in Mac OS X v10.0 and later.
kControlBevelButtonMultiValueMenuTag

Gets or sets whether the associated menu is a multi-value menu. Available in Mac OS X v10.3 and later.

Data type returned or set: Boolean; if true, the menu can have multiple selections; otherwise, false.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message.

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlBevelButtonContentTag = 'cont',
   kControlBevelButtonTransformTag = 'tran',
   kControlBevelButtonTextAlignTag = 'tali',
   kControlBevelButtonTextOffsetTag = 'toff',
   kControlBevelButtonGraphicAlignTag = 'gali',
   kControlBevelButtonGraphicOffsetTag = 'goff',
   kControlBevelButtonTextPlaceTag = 'tplc',
   kControlBevelButtonMenuValueTag = 'mval',
   kControlBevelButtonMenuHandleTag = 'mhnd',
   kControlBevelButtonMenuRefTag = 'mhnd',
   kControlBevelButtonCenterPopupGlyphTag = 'pglc',
   kControlBevelButtonIsMultiValueMenuTag = 'mult'
};


/*Control Bevel Button Menu Placement Constants

typedef UInt16 ControlBevelButtonMenuPlacement;
enum {
   kControlBevelButtonMenuOnBottom = 0,
   kControlBevelButtonMenuOnRight = (1 << 2)
};*/

typedef UInt16 ControlBevelButtonMenuPlacement;
enum {
   kControlBevelButtonMenuOnBottom = 0,
   kControlBevelButtonMenuOnRight = (1 << 2)
};


/*ControlBevelButtonMenuBehavior

typedef UInt16 ControlBevelButtonMenuBehavior;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 ControlBevelButtonMenuBehavior;

/*ControlBevelButtonBehavior

typedef UInt16 ControlBevelButtonBehavior;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt16 ControlBevelButtonBehavior;

/*Control Bevel Thickness Constants

typedef UInt16 ControlBevelThickness;
enum {
   kControlBevelButtonSmallBevel = 0,
   kControlBevelButtonNormalBevel = 1,
   kControlBevelButtonLargeBevel = 2
};*/
typedef UInt16 ControlBevelThickness;
enum {
   kControlBevelButtonSmallBevel = 0,
   kControlBevelButtonNormalBevel = 1,
   kControlBevelButtonLargeBevel = 2
};


/*Item States

Indicate the current state of an item in the data browser.

typedef UInt32 DataBrowserItemState;
enum {
   kDataBrowserItemNoState = 0,
   kDataBrowserItemAnyState = (unsigned long) (-1),
   kDataBrowserItemIsSelected = 1 << 0,
   kDataBrowserContainerIsOpen = 1 << 1,
   kDataBrowserItemIsDragTarget = 1 << 2
};
Constants
kDataBrowserItemNoState

The state is undefined.

Available in Mac OS X v10.0 and later.
kDataBrowserItemAnyState

Any state is acceptable.

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsSelected

The item is selected.

Available in Mac OS X v10.0 and later.
kDataBrowserContainerIsOpen

The item container is open. This state applies to:
A parent item in a hierarchical list in list view
An item in column view if the item’s contents are displayed in the next column

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsDragTarget

The item is a drag target.

Available in Mac OS X v10.0 and later.*/

typedef UInt32 DataBrowserItemState;
enum {
   kDataBrowserItemNoState = 0,
   kDataBrowserItemAnyState = (unsigned long) (-1),
   kDataBrowserItemIsSelected = 1 << 0,
   kDataBrowserContainerIsOpen = 1 << 1,
   kDataBrowserItemIsDragTarget = 1 << 2
};



/*User Selection Flags

Specify allowable selection behavior.

typedef UInt32 DataBrowserSelectionFlags;
enum {
   kDataBrowserDragSelect = 1 << 0,
   kDataBrowserSelectOnlyOne = 1 << 1,
   kDataBrowserResetSelection = 1 << 2,
   kDataBrowserCmdTogglesSelection = 1 << 3,
   kDataBrowserNoDisjointSelection = 1 << 4,
   kDataBrowserAlwaysExtendSelection = 1 << 5,
   kDataBrowserNeverEmptySelectionSet = 1 << 6
};
Constants
kDataBrowserDragSelect

Allows items to be selected by dragging. If the user to clicks the mouse to select a nondraggable item and drags the mouse, any item the pointer moves over is selected. This is on by default.

Available in Mac OS X v10.0 and later.
kDataBrowserSelectOnlyOne

Only one item can be selected at a time. If you use this flag in conjunction with the flag kDataBrowserDragSelect, then as the user drags, previous items are deselected as each new item is dragged over.

Available in Mac OS X v10.0 and later.
kDataBrowserResetSelection

Clears all selected items before processing the next selection. This is on by default.

Available in Mac OS X v10.0 and later.
kDataBrowserCmdTogglesSelection

Enables use of a command to toggle items in and out of a selection. This is on by default.

Available in Mac OS X v10.0 and later.
kDataBrowserNoDisjointSelection

Prevents a discontinuous selection.

Available in Mac OS X v10.0 and later.
kDataBrowserAlwaysExtendSelection

Multiple items can be selected without holding down a modifier key.

Available in Mac OS X v10.0 and later.
kDataBrowserNeverEmptySelectionSet

There must always be at least one selected item; the user cannot deselect the last selected item.

Available in Mac OS X v10.0 and later.
Discussion

You can use one or more of these flags together.*/

typedef UInt32 DataBrowserSelectionFlags;
enum {
   kDataBrowserDragSelect = 1 << 0,
   kDataBrowserSelectOnlyOne = 1 << 1,
   kDataBrowserResetSelection = 1 << 2,
   kDataBrowserCmdTogglesSelection = 1 << 3,
   kDataBrowserNoDisjointSelection = 1 << 4,
   kDataBrowserAlwaysExtendSelection = 1 << 5,
   kDataBrowserNeverEmptySelectionSet = 1 << 6
};

/*View Styles

Specify a style to use when displaying data in a data browser.

typedef OSType DataBrowserViewStyle;
enum {
   kDataBrowserNoView = '????',
   kDataBrowserListView = 'lstv',
   kDataBrowserColumnView = 'clmv'
};
Constants
kDataBrowserNoView

There is no view.

Available in Mac OS X v10.0 and later.
kDataBrowserListView

Display data in a list. Lists can be hierarchical.

Available in Mac OS X v10.0 and later.
kDataBrowserColumnView

Display data in columns that can be browsed.

Available in Mac OS X v10.0 and later.*/

typedef OSType DataBrowserViewStyle;
enum {
   kDataBrowserNoView = '0x3F3F3F3F',
   kDataBrowserListView = 'lstv',
   kDataBrowserColumnView = 'clmv'
};


/*DataBrowserPropertyFlags

Defines a data type for a value that specifies the behavior and look of a data browser.

typedef unsigned long DataBrowserPropertyFlags;
Discussion

These constants in the following sections are DataBrowserPropertyFlags data types:
“Property Flags: Universal”. Bits 0–7 modify the appearance or behavior of display properties.
“Property Flags: Modifiers”. Bits 8–15 specify how the data associated with a display type is displayed.
“Property Flags: Offset and Mask for List View Properties”. Specify an offset and mask for bits 16–23.
“Property Flags: List View Column Behavior”. Bits 16–23 specify behaviors for columns in list view. 
“Property Flags: Offset and Mask for Client-Defined Properties”. Specify an offset and mask for bits 24–31. 
Availability
Available in Mac OS X v10.0 and later.*/

typedef unsigned long DataBrowserPropertyFlags;


/*Data Browser Result Codes

The most common result codes returned by the data browser are listed here.
Result Code	Value	Description
errDataBrowserNotConfigured	-4970	
The data browser is not properly configured.
errDataBrowserItemNotFound	-4971	
The item is not in the data browser.
errDataBrowserPropertyNotFound	-4972	
The property is not in the data browser.
errDataBrowserInvalidPropertyPart	-4973	
The property part is not valid.
errDataBrowserInvalidPropertyData	-4974	
The property data is not valid.
errDataBrowserItemNotAdded	-4975	
The item was not added to the data browser.
errDataBrowserPropertyNotSupported	-4979	
The property is not supported in the data browser. */
enum {
errDataBrowserNotConfigured	 =-4970	,
errDataBrowserItemNotFound	=-4971	,
errDataBrowserPropertyNotFound	=-4972	,
errDataBrowserInvalidPropertyPart	=-4973	,
errDataBrowserInvalidPropertyData	=-4974	,
errDataBrowserItemNotAdded	=-4975	,
errDataBrowserPropertyNotSupported	=-4979	
};

 


/*User Item and User Pane Control Data Tag Constants

enum {
   kControlUserItemDrawProcTag = 'uidp',
   kControlUserPaneDrawProcTag = 'draw',
   kControlUserPaneHitTestProcTag = 'hitt',
   kControlUserPaneTrackingProcTag = 'trak',
   kControlUserPaneIdleProcTag = 'idle',
   kControlUserPaneKeyDownProcTag = 'keyd',
   kControlUserPaneActivateProcTag = 'acti',
   kControlUserPaneFocusProcTag = 'foci',
   kControlUserPaneBackgroundProcTag = 'back'
};
Constants
kControlUserItemDrawProcTag

Gets or sets an application-defined item drawing function. If an embedding hierarchy is established, a user pane drawing function should be used instead of an item drawing function.

Data type returned or set: UserItemUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneDrawProcTag

Gets or sets a user pane drawing function; see ControlUserPaneBackgroundProcPtr. Indicates that the Control Manager needs to draw a control.

Data type returned or set: ControlUserPaneDrawingUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneHitTestProcTag

Gets or sets a user pane hit-testing function. Indicates that the Control Manager needs to determine if a control part was hit; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneHitTestUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneTrackingProcTag

Gets or sets a user pane tracking function, which will be called when a control definition function returns the kControlHandlesTracking feature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane handles its own tracking; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneTrackingUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneIdleProcTag

Gets or sets a user pane idle function, which will be called when a control definition function returns the kControlWantsIdle feature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane performs idle processing; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneIdleUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneKeyDownProcTag

Gets or sets a user pane key down function, which will be called when a control definition function returns the kControlSupportsFocus feature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane performs keyboard event processing; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneKeyDownUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneActivateProcTag

Gets or sets a user pane activate function, which will be called when a control definition function returns the kControlWantsActivatefeature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane wants to be informed of activate and deactivate events; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneActivateUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneFocusProcTag

Gets or sets a user pane keyboard focus function, which will be called when a control definition function returns the kControlSupportsFocus feature bit in response to a kControlMsgGetFeatures message. Indicates that a user pane handles keyboard focus; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneFocusUPP

Available in Mac OS X v10.0 and later.
kControlUserPaneBackgroundProcTag

Gets or sets a user pane background function, which will be called when a control definition function returns the kControlHasSpecialBackgroundand kControlSupportsEmbeddingfeature bits in response to a kControlMsgGetFeatures message. Indicates that a user pane can set its background color or pattern; see ControlUserPaneBackgroundProcPtr.

Data type returned or set: ControlUserPaneBackgroundUPP

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlUserItemDrawProcTag = 'uidp',
   kControlUserPaneDrawProcTag = 'draw',
   kControlUserPaneHitTestProcTag = 'hitt',
   kControlUserPaneTrackingProcTag = 'trak',
   kControlUserPaneIdleProcTag = 'idle',
   kControlUserPaneKeyDownProcTag = 'keyd',
   kControlUserPaneActivateProcTag = 'acti',
   kControlUserPaneFocusProcTag = 'foci',
   kControlUserPaneBackgroundProcTag = 'back'
};

/*Pop-up Button Control Data Tag Constants

enum {
   kControlPopupButtonMenuHandleTag = 'mhan',
   kControlPopupButtonMenuRefTag = 'mhan',
   kControlPopupButtonMenuIDTag = 'mnid'
};
Constants
kControlPopupButtonMenuHandleTag

Gets or sets the menu handle for a popup button. Available with Appearance Manager 1.0.1 and later.

Data type returned or set: MenuHandle

Available in Mac OS X v10.0 and later.
kControlPopupButtonMenuRefTag

Gets or sets the menu reference assigned to a popup button. If setting the menu reference, the popup button does not own the menu, so you must dispose of it yourself. To allow the popup button to take ownership of the menu, use the kControlPopupButtonOwnedMenuRefTag tag (defined in “Mac OS 8.5 Pop-up Button Control Data Tag Constants”) instead. 

Data type returned or set: MenuRef

Available in Mac OS X v10.0 and later.
kControlPopupButtonMenuIDTag

Gets or sets the menu ID for a popup button. Available with Appearance Manager 1.0.1 and later.

Data type returned or set: SInt16

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function.*/

enum {
   kControlPopupButtonMenuHandleTag = 'mhan',
   kControlPopupButtonMenuRefTag = 'mhan',
   kControlPopupButtonMenuIDTag = 'mnid'
};


/*Clock Control Data Tag Constants

enum {
   kControlClockLongDateTag = 'date',
   kControlClockFontStyleTag = kControlFontStyleTag,
   kControlClockAnimatingTag = 'anim'
};
Constants
kControlClockLongDateTag

Gets or sets the clock control’s time or date. 

Data type returned or set: LongDateRec structure. Note that depending on the variant of clock control specified, some of the fields in the longDateRec structure may not be valid. For example, if the control variant displays only a non-live user-adjustable date, the hour and minute fields are not valid and will contain garbage. 

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlClockLongDateTag = 'date',
   kControlClockFontStyleTag = kControlFontStyleTag,
   kControlClockAnimatingTag = 'anim'
};

/*Icon Control Data Tag Constants

enum {
   kControlClockLongDateTag = 'date',
   kControlClockFontStyleTag = kControlFontStyleTag,
   kControlClockAnimatingTag = 'anim'
};enum {
   kControlIconTransformTag = 'trfm',
   kControlIconAlignmentTag = 'algn'
};
Constants
kControlIconTransformTag

Gets or sets a transform that is added to the standard transform of an icon see “Icon Utilities.”

Data type returned or set: IconTransformType

Available in Mac OS X v10.0 and later.
kControlIconAlignmentTag

Gets or sets an icon’s position (centered, left, right).

Data type returned or set: IconAlignmentType

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message.

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlIconTransformTag = 'trfm',
   kControlIconAlignmentTag = 'algn'
};


/*List Box Control Data Tag Constants

enum {
   kControlListBoxListHandleTag = 'lhan',
   kControlListBoxKeyFilterTag = kControlKeyFilterTag,
   kControlListBoxFontStyleTag = kControlFontStyleTag
};
enum {
   kControlListBoxDoubleClickTag = 'dblc',
   kControlListBoxLDEFTag = 'ldef'
};
Constants
kControlListBoxListHandleTag

Gets a handle to a list box.

Data type returned: ListHandle

Available in Mac OS X v10.0 and later.
kControlListBoxDoubleClickTag

Checks to see whether the most recent click in a list box was a double click. Available with Appearance 1.0.1 and later.

Data type returned: Boolean; if true, the last click was a double click; if false, not.

Available in Mac OS X v10.0 and later.
kControlListBoxLDEFTag

Sets the 'LDEF' resource to be used to draw a list box’s contents this is useful for creating a list box without an 'ldes' resource. Available with Appearance 1.0.1 and later.

Data type set: SInt16

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlListBoxListHandleTag = 'lhan',
   kControlListBoxKeyFilterTag = kControlKeyFilterTag,
   kControlListBoxFontStyleTag = kControlFontStyleTag
};
enum {
   kControlListBoxDoubleClickTag = 'dblc',
   kControlListBoxLDEFTag = 'ldef'
};

/*Push Button Control Data Tag Constants

enum {
   kControlPushButtonDefaultTag = 'dflt',
   kControlPushButtonCancelTag = 'cncl'
};
Constants
kControlPushButtonDefaultTag

Tells Appearance-compliant button whether to draw a default ring, or returns whether the Appearance Manager draws a default ring for the button.

Data type returned or set: Boolean

Available in Mac OS X v10.0 and later.
kControlPushButtonCancelTag

Gets or sets whether a given push button in a dialog or alert should be drawn with the theme-specific adornments for a Cancel button.

Data type retrieved or set: Boolean; default is false.

Available in Mac OS X v10.0 and later.
Discussion

The Mac OS 8.5 Control Manager defines this new control data tag constant. This constant is passed in the inTagName parameters of the functions SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass this constant in the inTagName parameter of the function GetControlDataSize if you wish to determine the size of variable-length control data. This constant can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message.

The data that your application gets or sets can be of various types. The description here shows the data type for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function.*/
enum {
   kControlPushButtonDefaultTag = 'dflt',
   kControlPushButtonCancelTag = 'cncl'
};


/*Progress Bar Control Data Tag Constants

enum {
   kControlProgressBarIndeterminateTag = 'inde',
   kControlProgressBarAnimatingTag = 'anim'
};
Constants
kControlProgressBarIndeterminateTag

Gets or sets whether a progress indicator is determinate or indeterminate.

Data type returned or set: Boolean; if true, switches to an indeterminate progress indicator; if false, switches to an determinate progress indicator.

Available in Mac OS X v10.0 and later.
Discussion

You can use this control data tag constant to set or obtain data that is associated with a control. This constant is passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass this constant in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. This constant can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message.

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the description of this control data tag constant lists the data type for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

This control data tag constant is available with Appearance Manager 1.0 and later.*/
enum {
   kControlProgressBarIndeterminateTag = 'inde',
   kControlProgressBarAnimatingTag = 'anim'
};


/*ControlEditTextSelectionRec

struct ControlEditTextSelectionRec {
   SInt16 selStart;
   SInt16 selEnd;
};
typedef struct ControlEditTextSelectionRec ControlEditTextSelectionRec;
typedef ControlEditTextSelectionRec * ControlEditTextSelectionPtr;
Fields
selStart

The start of the editable text selection. 
selEnd

The end of the editable text selection.
Discussion

You can use the ControlEditTextSelectionRec type to specify a selection range in an editable text control. You pass a pointer to the editable text selection structure to GetControlData and SetControlData to access and set the current selection range in an editable text control. 
Version Notes

The ControlEditTextSelectionRec type is available with Appearance Manager 1.0 and later.
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlEditTextSelectionRec {
   SInt16 selStart;
   SInt16 selEnd;
};
typedef struct ControlEditTextSelectionRec ControlEditTextSelectionRec;
typedef ControlEditTextSelectionRec * ControlEditTextSelectionPtr;


/*Editable Text Control Data Tag Constants

enum {
   kControlEditTextStyleTag = kControlFontStyleTag,
   kControlEditTextTextTag = 'text',
   kControlEditTextTEHandleTag = 'than',
   kControlEditTextKeyFilterTag = kControlKeyFilterTag,
   kControlEditTextSelectionTag = 'sele',
   kControlEditTextPasswordTag = 'pass'
};
enum {
   kControlEditTextKeyScriptBehaviorTag = 'kscr',
   kControlEditTextLockedTag = 'lock',
   kControlEditTextFixedTextTag = 'ftxt',
   kControlEditTextValidationProcTag = 'vali',
   kControlEditTextInlinePreUpdateProcTag = 'prup',
   kControlEditTextInlinePostUpdateProcTag = 'poup'
};
enum {
   kControlEditTextCFStringTag = 'cfst',
   kControlEditTextPasswordCFStringTag = 'pwcf'
};
Constants
kControlEditTextTextTag

Gets or sets text in an editable text control.

Data type returned or set: character buffer 

Available in Mac OS X v10.0 and later.
kControlEditTextTEHandleTag

Gets a handle to a text edit structure.

Data type returned: TEHandle

Available in Mac OS X v10.0 and later.
kControlEditTextSelectionTag

Gets or sets the selection in an editable text control.

Data type returned or set: ControlEditTextSelectionRec structure

Available in Mac OS X v10.0 and later.
kControlEditTextKeyScriptBehaviorTag

Gets or sets the kind of behavior to be used in an editable text control with respect to changing and locking the keyboard menu as the field is focused.

Data type retrieved or set: ControlKeyScriptBehavior. The default for password fields is kControlKeyScriptBehaviorPrefersRoman. The default for non-password fields is kControlKeyScriptBehaviorAllowAnyScript. See ControlEditTextValidationProcPtr for descriptions of possible values.

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextLockedTag

Gets or sets whether the text in an editable text control is currently editable.

Data type retrieved or set: Boolean; if true, the text is locked and cannot be edited; if false, the text is editable.

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextFixedTextTag

Gets or sets inline input text in an editable text control, after confirming any text in the active input area with the Text Services Manager function FixTSMDocument.

Data type retrieved or set: character buffer

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextValidationProcTag

Gets or sets a universal procedure pointer to a callback function such as that described in ControlEditTextValidationProcPtr, which can be used to validate editable text after an operation that changes the text, such as inline text entry, a cut, or paste.

Data type retrieved or set: ControlEditTextValidationUPP

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextInlinePreUpdateProcTag

Gets or sets a universal procedure pointer to a Text Services Manager pre-update callback function.

Data type retrieved or set: TSMTEPreUpdateUPP

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextInlinePostUpdateProcTag

Gets or sets a universal procedure pointer to a Text Services Manager post-update callback function.

Data type retrieved or set: TSMTEPostUpdateUPP

Available in Appearance 1.1 or Mac OS 8.5 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextCFStringTag

Retrieves the contents of the edit text field as a CFString. 

Data type retrieved: CFStringRef. You must release the string when you no longer need it. 

Available in CarbonLib 1.5 and Mac OS X v10.0 and later. 

Available in Mac OS X v10.0 and later.
kControlEditTextPasswordCFStringTag

Extract the content of the edit text field if it is a password field. 

Data type retrieved: CFStringRef. You must release the string when you no longer need it. 

Available in CarbonLib 1.5 and Mac OS X v10.0 and later. 

Available in Mac OS X v10.1 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data (e.g., text in an editable text control). These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlEditTextStyleTag = kControlFontStyleTag,
   kControlEditTextTextTag = 'text',
   kControlEditTextTEHandleTag = 'than',
   kControlEditTextKeyFilterTag = kControlKeyFilterTag,
   kControlEditTextSelectionTag = 'sele',
   kControlEditTextPasswordTag = 'pass'
};
enum {
   kControlEditTextKeyScriptBehaviorTag = 'kscr',
   kControlEditTextLockedTag = 'lock',
   kControlEditTextFixedTextTag = 'ftxt',
   kControlEditTextValidationProcTag = 'vali',
   kControlEditTextInlinePreUpdateProcTag = 'prup',
   kControlEditTextInlinePostUpdateProcTag = 'poup'
};
enum {
   kControlEditTextCFStringTag = 'cfst',
   kControlEditTextPasswordCFStringTag = 'pwcf'
};



/*Callback Data Structure Version

Specifies the version of the latest standard callback data structure.

enum {
   kDataBrowserLatestCallbacks = 0
};
Constants
kDataBrowserLatestCallbacks

A convenience constant used in the DataBrowserCallbacks data structure to specify the version of the structure.

Available in Mac OS X v10.0 and later.*/
enum {
   kDataBrowserLatestCallbacks = 0
};


/*Properties

Specify attributes for items, containers, and columns.

enum {
   kDataBrowserItemNoProperty = 0L,
   kDataBrowserItemIsActiveProperty = 1L,
   kDataBrowserItemIsSelectableProperty = 2L,
   kDataBrowserItemIsEditableProperty = 3L,
   kDataBrowserItemIsContainerProperty = 4L,
   kDataBrowserContainerIsOpenableProperty = 5L,
   kDataBrowserContainerIsClosableProperty = 6L,
   kDataBrowserContainerIsSortableProperty = 7L,
   kDataBrowserItemSelfIdentityProperty = 8L,
   kDataBrowserContainerAliasIDProperty = 9L,
   kDataBrowserColumnViewPreviewProperty = 10L,
   kDataBrowserItemParentContainerProperty = 11L
};
Constants
kDataBrowserItemNoProperty

No property; no associated data.

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsActiveProperty

The active state of the item. The associated data is of type Boolean. The default value true indicates the item is active.

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsSelectableProperty

The selection capability of the item. The associated data is of type Boolean. The default value true indicates the item can be selected.

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsEditableProperty

The editing capability of the item. The associated data is of type Boolean. The default value false indicates the item cannot be edited.

Available in Mac OS X v10.0 and later.
kDataBrowserItemIsContainerProperty

The container attribute for an item. The associated data is of type Boolean. The default value false indicates the item cannot contain other items.

Available in Mac OS X v10.0 and later.
kDataBrowserContainerIsOpenableProperty

The opening capability of a container item. The associated data is of type Boolean. The default value true indicates the container can be opened.

Available in Mac OS X v10.0 and later.
kDataBrowserContainerIsClosableProperty

The closing capability of a container item. The associated data is of type Boolean. The default value true indicates the container can be closed.

Available in Mac OS X v10.0 and later.
kDataBrowserContainerIsSortableProperty

The sorting capability of container item. The associated data is of type Boolean. The default value true indicates the items in the container can be sorted.

Available in Mac OS X v10.0 and later.
kDataBrowserItemSelfIdentityProperty

This property is used only in column view for the item-data and item-compare callbacks. You should not use this property for anything else. It is passed to your item-data callback when the data browser needs to know the data to draw to represent the item. It is your responsibility to provide the data to display for that item in whatever format would be appropriate for the column view display type, which is kDataBrowserIconAndTextType. 

Available in Mac OS X v10.0 and later.
kDataBrowserContainerAliasIDProperty

An alias or symbolic link from an item to a container item. The associated data is of type DataBrowserItemID. This property is sent to your item-data callback to provide your application with a chance to follow an alias that the item might represent. If the incoming item is an alias to another item, you can call the function SetDataBrowserItemDataItemID to inform the data browser which other item the incoming item points to.

This property is sent only from column view. Your support for it is optional. Your response allows the data browser to be a bit more memory efficient with its internal storage. If a given item is an alias to an item whose contents are already displayed in one column of the column view, the contents can be shared between those two columns.

Available in Mac OS X v10.0 and later.
kDataBrowserColumnViewPreviewProperty

The column displays a preview. There is no associated data. Available only in column view. This property is sent to your draw-item callback to indicate the need for you to draw a preview of the given item. It can be sent to other callbacks to provide an opportunity for your application to draw or track in the preview column. 

You can also pass this in the propertyID parameter of the function RevealDataBrowserItem (along with the appropriate item ID of the item whose preview is displayed) to make sure the preview column is visible to the user.

Available in Mac OS X v10.0 and later.
kDataBrowserItemParentContainerProperty

Designates the parent of the specified item. The associated data is of type DataBrowserItemID. This is sent to your item-data callback when the data browser needs to know the parent container item for a given item.

In column view, this allows the function SetDataBrowserTarget to process the data properly. The target is the leaf node item whose contents you want to display, which is the rightmost column in column view. However, unlike SetDataBrowserColumnViewPath, the function SetDataBrowserTarget doesn’t offer a way for you to communicate the item IDs of the rest of the column containers, so SetDataBrowserTarget asks for them explicitly by requesting the item’s parent, then the parent of the item’s parent, and so on. (Your item-data callback might be called with the parent container property at times other than an explicit call to SetDataBrowserTarget, so your item-data callback should support this property.)

In list view, this property allows you to pass a non-container to SetDataBrowserTarget. In this case, the data browser requests the parent of the target so it knows which container to display the contents of in the list view. (Again, your item-data callback might be called with the parent container property at times other than an explicit call to SetDataBrowserTarget, so your item-data callback should be sure to support this property.)

Available in Mac OS X v10.0 and later.
Discussion

You can use these constants along with the appropriate value to manage the attributes of items in a data browser. Typically your item-data callback responds to inquires about these properties by calling the appropriate accessor function from within the callback. See DataBrowserItemDataProcPtr for more information on the item-data callback. “Getting and Setting Item Data” describes the accessor functions.*/
enum {
   kDataBrowserItemNoProperty = 0L,
   kDataBrowserItemIsActiveProperty = 1L,
   kDataBrowserItemIsSelectableProperty = 2L,
   kDataBrowserItemIsEditableProperty = 3L,
   kDataBrowserItemIsContainerProperty = 4L,
   kDataBrowserContainerIsOpenableProperty = 5L,
   kDataBrowserContainerIsClosableProperty = 6L,
   kDataBrowserContainerIsSortableProperty = 7L,
   kDataBrowserItemSelfIdentityProperty = 8L,
   kDataBrowserContainerAliasIDProperty = 9L,
   kDataBrowserColumnViewPreviewProperty = 10L,
   kDataBrowserItemParentContainerProperty = 11L
};


/*No Item Constant

Specifies that there is no item to provide or obtain.

enum {
   kDataBrowserNoItem = 0L
};
Constants
kDataBrowserNoItem

A convenience constant used when there is no item to provide or obtain. This value is of type DataBrowserItemID.

Available in Mac OS X v10.0 and later.*/
enum {
   kDataBrowserNoItem = 0L
};

/*DataBrowserItemDataRef

Defines a data type for a pointer that specifies an item.

typedef void *DataBrowserItemDataRef;
Discussion

Functions listed in “Getting and Setting Item Data” are called from within a data browser item-data callback routine (DataBrowserItemDataProcPtr). Each of these functions use a DataBrowserItemDataRef data type to specify the item to get or set data for.
Availability
Available in Mac OS X v10.0 and later.*/
typedef void *DataBrowserItemDataRef;

/*DataBrowserPropertyID

Defines a data type for a value that identifies a column independent of its position in a data browser.

typedef UInt32 DataBrowserPropertyID;
Discussion

Typically, this is a four-character sequence that you assign to represent a column in list view. For example, a column that displays song titles could be assigned a property ID of SONG and you’d assign it to a constant in your application using code similar to the following:

kSongColumn = SONG;

Then, each time call a function that requires a parameter of type DataBrowserPropertyID, supply the appropriate application-defined constant.
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 DataBrowserPropertyID;

/*DataBrowserItemID

Defines a data type for a value that identifies an item independent of its position in a data browser.

typedef UInt32 DataBrowserItemID;
Availability
Available in Mac OS X v10.0 and later.*/
typedef UInt32 DataBrowserItemID;

/*DataBrowserItemDataProcPtr

Defines a pointer to an item-data callback function that gets and sets properties for individual items in a data browser.

typedef OSStatus (*DataBrowserItemDataProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   DataBrowserItemDataRef itemData,
   Boolean setValue
);

You would declare an item-data callback function named MyDataBrowserItemDataCallback like this:

OSStatus MyDataBrowserItemDataCallback (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   DataBrowserItemDataRef itemData,
   Boolean setValue
);
Parameters
browser

The data browser.
item

The item ID of the item whose data is set or obtained.
property

A property ID. This value can be any of the following: 
A four-character sequence that you assign to represent a column in list view.
Any of the API-defined properties, such as kDataBrowserItemSelfIdentityProperty for a column in column view or kDataBrowserItemIsContainerProperty for an item in list or column view that has children. See “Properties” for a complete list and more information on the API-defined properties. 
itemData

The data buffer that either contains the data to set or receives the data to obtain. 
setValue

A value that indicates whether data is to be obtained or set. This value is false if your application needs to set the value of the item by calling one of the set functions described in the section “Getting and Setting Item Data”. This value is true if the value of the item has changed. In this case, you should call the appropriate get function, passing the item data reference provided to you in the itemData parameter. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

The item-data callback communicates data between the data browser and your application. When the data browser needs to display a value for an item, it invokes your callback to request the data. If the user changes the value, the data browser invokes your callback with a new copy of the data that you can use to replace your application’s internal copy. Your application must supply an item-data callback; otherwise, your data browser will not contain any data.

Your callback determines the kind of data is associated with an item and whether data needs to be obtained or set. Then, your callback takes the appropriate action by calling one of the functions listed in “Getting and Setting Item Data”. 

To provide a pointer to your item-data callback, you create a universal procedure pointer (UPP) of type DataBrowserItemDataUPP, using the function NewDataBrowserItemDataUPP. You can do so with code similar to the following: DataBrowserItemDataUPP MyDataBrowserItemDataUPP;
MyDataBrowserItemDataUPP = NewDataBrowserItemDataUPP
                            (&MyDataBrowserItemDataCallback);


You can then assign MyDataBrowserItemDataUPP to the itemDataCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserItemDataUPP function.*/
typedef OSStatus (*DataBrowserItemDataProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   DataBrowserItemDataRef itemData,
   Boolean setValue
);




/*Control Part Code Constants

enum {
   kControlLabelPart = 1,
   kControlMenuPart = 2,
   kControlTrianglePart = 4,
   kControlEditTextPart = 5,
   kControlPicturePart = 6,
   kControlIconPart = 7,
   kControlClockPart = 8,
   kControlListBoxPart = 24,
   kControlListBoxDoubleClickPart = 25,
   kControlImageWellPart = 26,
   kControlRadioGroupPart = 27,
   kControlButtonPart = 10,
   kControlCheckBoxPart = 11,
   kControlRadioButtonPart = 11,
   kControlUpButtonPart = 20,
   kControlDownButtonPart = 21,
   kControlPageUpPart = 22,
   kControlPageDownPart = 23,
   kControlClockHourDayPart = 9,
   kControlClockMinuteMonthPart = 10,
   kControlClockSecondYearPart = 11,
   kControlClockAMPMPart = 12,
   kControlDataBrowserPart = 24,
   kControlDataBrowserDraggedPart = 25
};
Constants
kControlLabelPart

Identifies the label of a pop-up menu control.

Available in Mac OS X v10.0 and later.
kControlMenuPart

Identifies the menu of a pop-up menu control. For bevel buttons with a menu attached, this part code specifies a menu item of the bevel button.

Available in Mac OS X v10.0 and later.
kControlTrianglePart

Identifies a disclosure triangle control.

Available in Mac OS X v10.0 and later.
kControlEditTextPart

Identifies an editable text control.

Available with Appearance Manager 1.0 and later.
kControlPicturePart

Identifies a picture control.

Available with Appearance Manager 1.0 and later.
kControlIconPart

Identifies an icon control.

Available with Appearance Manager 1.0 and later.
kControlClockPart

Identifies a clock control.

Available with Appearance Manager 1.0 and later.
kControlListBoxPart

Identifies a list box control.

Available with Appearance Manager 1.0 and later.
kControlListBoxDoubleClickPart

Identifies a double-click in a list box control.

Available with Appearance Manager 1.0 and later.
kControlImageWellPart

Identifies an image well control.

Available with Appearance Manager 1.0 and later.
kControlRadioGroupPart

Identifies a radio group control.

Available with Appearance Manager 1.0.2 and later.
kControlButtonPart

Identifies either a push button or bevel button control. For bevel buttons with a menu attached, this part code specifies the button but not the attached menu.

Available in Mac OS X v10.0 and later.
kControlCheckBoxPart

Identifies a checkbox control.

Available in Mac OS X v10.0 and later.
kControlRadioButtonPart

Identifies a radio button control.

Available in Mac OS X v10.0 and later.
kControlUpButtonPart

Identifies the up button of a scroll bar control (the arrow at the top or the left).

Available in Mac OS X v10.0 and later.
kControlDownButtonPart

Identifies the down button of a scroll bar control (the arrow at the right or the bottom).

Available in Mac OS X v10.0 and later.
kControlPageUpPart

Identifies the page-up part of a scroll bar control.

Available in Mac OS X v10.0 and later.
kControlPageDownPart

Identifies the page-down part of a scroll bar control.

Available in Mac OS X v10.0 and later.
kControlClockHourDayPart

Identifies the part of a clock control that contains the hour or the day. The Mac OS 8.5 Control Manager defines this new control part code constant. 

Available in Mac OS X v10.0 and later.
kControlClockMinuteMonthPart

Identifies the part of a clock control that contains the minute or the month. The Mac OS 8.5 Control Manager defines this new control part code constant. 

Available in Mac OS X v10.0 and later.
kControlClockSecondYearPart

Identifies the part of a clock control that contains the second or the year. The Mac OS 8.5 Control Manager defines this new control part code constant. 

Available in Mac OS X v10.0 and later.
kControlClockAMPMPart

Identifies the part of a clock control that contains the AM/PM information. The Mac OS 8.5 Control Manager defines this new control part code constant. 

Available in Mac OS X v10.0 and later.
Discussion

Constants of type ControlPartCode identify specific parts of controls.

Part codes are meaningful only within the scope of a single control definition function. For example, the standard tab control uses part codes 1...N, where N is the number of tabs, even though those numbers do collide with part codes defined for use with other control definition functions. Therefore, when you wish to specify part codes for the tab control for use with the function SetControlData, for example, you should use a part code corresponding to a 1-based index of the tab whose data you wish to set. In other words, the first tab is part code 1, the second tab is part code 2, and so on.*/
enum {
   kControlLabelPart = 1,
   kControlMenuPart = 2,
   kControlTrianglePart = 4,
   kControlEditTextPart = 5,
   kControlPicturePart = 6,
   kControlIconPart = 7,
   kControlClockPart = 8,
   kControlListBoxPart = 24,
   kControlListBoxDoubleClickPart = 25,
   kControlImageWellPart = 26,
   kControlRadioGroupPart = 27,
   kControlButtonPart = 10,
   kControlCheckBoxPart = 11,
   kControlRadioButtonPart = 11,
   kControlUpButtonPart = 20,
   kControlDownButtonPart = 21,
   kControlPageUpPart = 22,
   kControlPageDownPart = 23,
   kControlClockHourDayPart = 9,
   kControlClockMinuteMonthPart = 10,
   kControlClockSecondYearPart = 11,
   kControlClockAMPMPart = 12,
   kControlDataBrowserPart = 24,
   kControlDataBrowserDraggedPart = 25
};


/*Little Arrows Control Tag Constant

enum {
   kControlLittleArrowsIncrementValueTag = 'incr'
};
Constants
kControlLittleArrowsIncrementValueTag

Gets or sets the increment value of the control. Currently, the little arrows control does not use the increment value because the control does not change the value itself. You must use an action proc to change the value. Available in Mac OS X v10.3 and later.

Data type retrieved: SInt32

Available in Mac OS X v10.3 and later.*/
enum {
   kControlLittleArrowsIncrementValueTag = 'incr'
};

/*Tab Control Info Tag Constant

enum {
   kControlTabInfoTag = 'tabi'
};
Constants
kControlTabInfoTag

Gets or sets information for a tab in a tab control; see ControlTabInfoRec.

Data type returned or set: ControlTabInfoRec.

Available in Mac OS X v10.0 and later.
Discussion

You can use this control data tag constant to set or obtain data that is associated with a control. This constant is passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass this constant in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. This constant can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the description of this control data tag constant lists the data type for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

This control data tag constant is available with Appearance Manager 1.0.1 and later.*/
enum {
   kControlTabInfoTag = 'tabi'
};

/*Control Tab Info Version Constants

enum {
   kControlTabInfoVersionZero = 0,
   kControlTabInfoVersionOne = 1
};*/
enum {
   kControlTabInfoVersionZero = 0,
   kControlTabInfoVersionOne = 1
};

/*ControlTabInfoRecV1

struct ControlTabInfoRecV1 {
   SInt16 version;
   SInt16 iconSuiteID;
   CFStringRef name;
};
typedef struct ControlTabInfoRecV1 ControlTabInfoRecV1;
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlTabInfoRecV1 {
   SInt16 version;
   SInt16 iconSuiteID;
   CFStringRef name;
};
typedef struct ControlTabInfoRecV1 ControlTabInfoRecV1;

/*ControlTabEntry

struct ControlTabEntry {
   ControlButtonContentInfo * icon;
   CFStringRef name;
   Boolean enabled;
};
typedef struct ControlTabEntry ControlTabEntry;
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlTabEntry {
   ControlButtonContentInfo * icon;
   CFStringRef name;
   Boolean enabled;
};
typedef struct ControlTabEntry ControlTabEntry;

/*Control Tab Direction Constants

typedef UInt16 ControlTabDirection;
enum {
   kControlTabDirectionNorth = 0,
   kControlTabDirectionSouth = 1,
   kControlTabDirectionEast = 2,
   kControlTabDirectionWest = 3
};*/
typedef UInt16 ControlTabDirection;
enum {
   kControlTabDirectionNorth = 0,
   kControlTabDirectionSouth = 1,
   kControlTabDirectionEast = 2,
   kControlTabDirectionWest = 3
};

/*Control Tab Size Constants

typedef UInt16 ControlTabSize;
enum {
   kControlTabSizeLarge = kControlSizeNormal,
   kControlTabSizeSmall = kControlSizeSmall
};*/
typedef UInt16 ControlTabSize;
enum {
   kControlTabSizeLarge = kControlSizeNormal,
   kControlTabSizeSmall = kControlSizeSmall
};

/*Static Text Control Data Tag Constants

enum {
   kControlStaticTextStyleTag = kControlFontStyleTag,
   kControlStaticTextTextTag = 'text',
   kControlStaticTextTextHeightTag = 'thei',
   kControlStaticTextTruncTag = 'trun',
   kControlStaticTextCFStringTag = 'cfst',
   kControlStaticTextIsMultilineTag = 'stim'
};
Constants
kControlStaticTextTextTag

Gets or sets text in a static text control. 

Data type returned or set: character buffer.

Available with Appearance Manager 1.0 and later.
kControlStaticTextTextHeightTag

Gets the height of text in a static text control. Available with Appearance Manager 1.0 and later.

Data type returned or set:SInt16

Available in Mac OS X v10.0 and later.
kControlStaticTextTruncTag

Gets or sets the control’s text truncation style. Truncation will not occur unless kControlStaticTextIsMultilineTag is set to false. 

Data type returned or set: TruncCode. The value truncEnd indicates that characters are truncated off the end of the string; the value truncMiddle indicates that characters are truncated from the middle of the string. Default is a value of -1, which indicates that no truncation occurs and the text is wrapped instead.

Available with Appearance Manager 1.1 (Mac OS 8.5) and later.

Available in Mac OS X v10.0 and later.
kControlStaticTextCFStringTag

Gets or sets the control’s current text. When setting the text, the control retains the string, so you may release the string after calling SetControlData. If the string you set is mutable, the control will make a copy of the string, so any changes to the string after calling SetControlData will not affect the control. When retrieving the text, the control retains the string before returning it to you, so you must release the string after you are done with it. 

Data type returned or set: CFStringRef

Available in CarbonLib 1.5 and later, and Mac OS X v10.0 and later.

Available in Mac OS X v10.0 and later.
kControlStaticTextIsMultilineTag

Gets or sets a flag specifying whether the control draws its text in multiple lines if the text is too wide for the control bounds. If false, the control always draws the text in a single line. 

Data type returned or set: Boolean

Available in Mac OS X v10.1 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function.*/
enum {
   kControlStaticTextStyleTag = 'kControlFontStyleTag',
   kControlStaticTextTextTag = 'text',
   kControlStaticTextTextHeightTag = 'thei',
   kControlStaticTextTruncTag = 'trun',
   kControlStaticTextCFStringTag = 'cfst',
   kControlStaticTextIsMultilineTag = 'stim'
};

/*Item Notifications

Specify notifications provided by the data browser to your application.

typedef UInt32 DataBrowserItemNotification;
enum {
   kDataBrowserItemAdded = 1,
   kDataBrowserItemRemoved = 2,
   kDataBrowserEditStarted = 3,
   kDataBrowserEditStopped = 4,
   kDataBrowserItemSelected = 5,
   kDataBrowserItemDeselected = 6,
   kDataBrowserItemDoubleClicked = 7,
   kDataBrowserContainerOpened = 8,
   kDataBrowserContainerClosing = 9,
   kDataBrowserContainerClosed = 10,
   kDataBrowserContainerSorting = 11,
   kDataBrowserContainerSorted = 12,
   kDataBrowserUserStateChanged = 13,
   kDataBrowserSelectionSetChanged = 14,
   kDataBrowserTargetChanged = 15,
   kDataBrowserUserToggledContainer = 16
};
Constants
kDataBrowserItemAdded

The specified item has been added to a container in the data browser.

Available in Mac OS X v10.0 and later.
kDataBrowserItemRemoved

The specified item has been removed from a container in the data browser.

Available in Mac OS X v10.0 and later.
kDataBrowserEditStarted

An text editing session has started for the specified item.

Available in Mac OS X v10.0 and later.
kDataBrowserEditStopped

An text editing session has stopped for the specified item.

Available in Mac OS X v10.0 and later.
kDataBrowserItemSelected

An item has been added to the selection set.

Available in Mac OS X v10.0 and later.
kDataBrowserItemDeselected

An item has been removed from the selection set.

Available in Mac OS X v10.0 and later.
kDataBrowserItemDoubleClicked

The user double-clicked an item.

Available in Mac OS X v10.0 and later.
kDataBrowserContainerOpened

A container has been opened. 

Available in Mac OS X v10.0 and later.
kDataBrowserContainerClosing

A container is about to close. This notification is sent at the start of the close operation. The container still contains its child items and it is still valid to pass them to data browser functions. The data browser handles closing automatically, so typically applications do not look for this notification. You’d use this only if you are interested in fetching information on the items before the close actually happens. 

Available in Mac OS X v10.0 and later.
kDataBrowserContainerClosed

A container has been closed. This notification is sent after the close operation, so it is no longer valid to pass child items to data browser functions.

Available in Mac OS X v10.0 and later.
kDataBrowserContainerSorting

A container is about to be sorted. 

Available in Mac OS X v10.0 and later.
kDataBrowserContainerSorted

A container has been sorted.

Available in Mac OS X v10.0 and later.
kDataBrowserUserStateChanged

The user has reformatted the view for the target. For example, the user changed a sorting order or a column width.

Available in Mac OS X v10.0 and later.
kDataBrowserSelectionSetChanged

The selection set has been modified.

Available in Mac OS X v10.0 and later.
kDataBrowserTargetChanged

The target has changed to the specified item.

Available in Mac OS X v10.0 and later.
kDataBrowserUserToggledContainer

The user has toggled opened or closed a container by clicking a disclosure triangle.

Available in Mac OS X v10.0 and later.
Discussion

These notifications are used with the callbacks DataBrowserItemNotificationProcPtr and DataBrowserItemNotificationWithItemProcPtr. Notifications sent for containers are the same regardless of whether the container opens to an expandable row or to individual rows for each item in the container.*/
typedef UInt32 DataBrowserItemNotification;
enum {
   kDataBrowserItemAdded = 1,
   kDataBrowserItemRemoved = 2,
   kDataBrowserEditStarted = 3,
   kDataBrowserEditStopped = 4,
   kDataBrowserItemSelected = 5,
   kDataBrowserItemDeselected = 6,
   kDataBrowserItemDoubleClicked = 7,
   kDataBrowserContainerOpened = 8,
   kDataBrowserContainerClosing = 9,
   kDataBrowserContainerClosed = 10,
   kDataBrowserContainerSorting = 11,
   kDataBrowserContainerSorted = 12,
   kDataBrowserUserStateChanged = 13,
   kDataBrowserSelectionSetChanged = 14,
   kDataBrowserTargetChanged = 15,
   kDataBrowserUserToggledContainer = 16
};

/*DataBrowserItemNotificationProcPtr

Defines a pointer to an item-notification callback function that notifies your application of changes in the data browser.

typedef void (*DataBrowserItemNotificationProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserItemNotification message
);

You would declare an item-notification callback function named MyDataBrowserItemNotificationCallback like this:

void MyDataBrowserItemNotificationCallback (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserItemNotification message
);
Parameters
browser

A data browser.
item

The item ID of the item that generated the notification. 
message

A notification. See “Item Notifications” for a description of the values that can be provided to your callback.
Discussion

The item-notification callback is called by the data browser to notify your application of actions taken by the user (such as editing started, container opened, container closed) or any other condition that your application might choose to respond to. Your item-notification callback can evaluate the notification and take appropriate action.

To provide a pointer to your item-notification callback, you create a universal procedure pointer (UPP) of type DataBrowserItemNotificationUPP, using the function NewDataBrowserItemNotificationUPP. You can do so with code similar to the following: DataBrowserItemNotificationUPP MyDataBrowserItemNotificationUPP;
MyDataBrowserItemNotificationUPP = NewDataBrowserItemNotificationUPP
                            (&MyDataBrowserItemNotificationCallback);


You can then assign MyDataBrowserItemNotificationUPP to the itemNotificationCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserItemNotificationUPP function. 
Special Considerations

In CarbonLib the item-notification callback is invoked with the three parameters shown in DataBrowserItemNotificationProcPtr. The four-parameter version—DataBrowserItemNotificationWithItemProcPtr—does not provide valid data in the fourth parameter. Any attempt to use the invalid data in a CarbonLib application may result in a crash.

In Mac OS X, the item-notification callback is invoked with the four parameters shown in DataBrowserItemNotificationWithItemProcPtr. In Mac OS X you have the option of using the DataBrowserItemNotificationProcPtr or the DataBrowserItemNotificationWithItemProcPtr. Which one you choose depends on whether your application needs to use the data passed to your callback in the fourth parameter (the itemData parameter).*/
typedef void (*DataBrowserItemNotificationProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserItemNotification message
);

/*ControlUserPaneDrawProcPtr

Draws the content of your user pane control in the rectangle of user pane control.

typedef void (*ControlUserPaneDrawProcPtr) (
   ControlRef control,
   SInt16 part
);

If you name your function MyControlUserPaneDrawProc, you would declare it like this:

void MyControlUserPaneDrawProc (
   ControlRef control,
   SInt16 part
);
Parameters
control

A handle to the user pane control in which you wish drawing to occur. For a description of this data type, see “ControlRef”.
part

The part code of the control you should draw. If 0, draw the entire control.
Discussion

The Control Manager defines the data type ControlUserPaneDrawUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneDrawUPP; 

You typically use the NewControlUserPaneDrawProc macro like this:

ControlUserPaneDrawUPP myControlUserPaneDrawUPP; 

myControlUserPaneDrawUPP = NewControlUserPaneDrawProc(MyControlUserPaneDrawCallback); 

You typically use the CallControlUserPaneDrawProc macro like this:

CallControlUserPaneDrawProc(myControlUserPaneDrawUPP, control, part); 

Application-defined user pane functions provide you with the ability to create a custom theme-compliant control without writing your own control definition function. A user pane is a general purpose stub control; it can be used as the root control for a window, as well as providing a way to hook in application-defined functions such as those described below. When the Appearance Manager is available, user panes should be used in dialog boxes instead of user items.

Once you have provided a user pane application-defined function, you can call the function SetControlData in order to associate your function with a control. User pane application-defined functions are identified to SetControlData by tag constants for a description of the tag constants, see the “Control Manager Constants” section. 

For example, to set a user pane draw function, pass the constant kControlUserPaneDrawProcTag in the tagName parameter of SetControlData.The Control Manager then draws the control using a universal procedure pointer to your user pane draw function. 
Availability
This function is available with Appearance Manager 1.0 and later.*/
typedef void (*ControlUserPaneDrawProcPtr) (
   ControlRef control,
   SInt16 part
);


/*DataBrowserItemCompareProcPtr

Defines a pointer to an item-comparison callback function that orders the values displayed in a column. 

typedef Boolean (*DataBrowserItemCompareProcPtr) (
   ControlRef browser,
   DataBrowserItemID itemOne,
   DataBrowserItemID itemTwo,
   DataBrowserPropertyID sortProperty
);

You would declare an item-comparison callback function named MyDataBrowserItemCompareCallback like this:

Boolean MyDataBrowserItemCompareCallback (
   ControlRef browser,
   DataBrowserItemID itemOne,
   DataBrowserItemID itemTwo,
   DataBrowserPropertyID sortProperty
);
Parameters
browser

A data browser.
itemOne

The item ID of the first item to use in the comparison.
itemTwo

The item ID of the second item to use in the comparison.
sortProperty

The property ID for the column to sort. In list view, this is the four-character sequence that you previously assigned to the column. In column view, this is the property kDataBrowserItemSelfIdentityProperty.
Return Value

Your callback returns true if the value of the data referenced by itemOne is less than the value of the data referenced by itemTwo. It returns false if the value of the data referenced by itemOne is greater than or equal to the value of the data referenced by itemTwo.
Discussion

The item-comparison callback is called by the data browser when it needs to order the values displayed in a column. Your callback determines the display type of the data, then carries out the appropriate comparison for that data.

If you want your callback to use secondary and tertiary sorting, your application must keep track of previous sorting operations. Then you must make sure that each time a user clicks a column, the column is sorted, but the associated sorting orders for secondary and tertiary items in the column are preserved.

To provide a pointer to your item-comparison callback, you create a universal procedure pointer (UPP) of type DataBrowserItemCompareUPP, using the function NewDataBrowserItemCompareUPP. You can do so with code similar to the following: DataBrowserItemCompareUPP MyDataBrowserItemCompareUPP;
MyDataBrowserItemCompareUPP = NewDataBrowserItemCompareUPP
                            (&MyDataBrowserItemCompareCallback);


You can then assign MyDataBrowserItemCompareUPP to the itemCompareCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserItemCompareUPP function.*/
typedef Boolean (*DataBrowserItemCompareProcPtr) (
   ControlRef browser,
   DataBrowserItemID itemOne,
   DataBrowserItemID itemTwo,
   DataBrowserPropertyID sortProperty
);

/*DataBrowserAcceptDragProcPtr

Defines a pointer to an accept-drag callback function that determines whether your application can accept a drag object in the specified location.

typedef Boolean (*DataBrowserAcceptDragProcPtr) (
   ControlRef browser,
   DragRef theDrag,
   DataBrowserItemID item
);

You would declare an accept-drag callback function named MyDataBrowserAcceptDragCallback like this:

Boolean MyDataBrowserAcceptDragCallback (
   ControlRef browser,
   DragRef theDrag,
   DataBrowserItemID item
);
Parameters
browser

A data browser.
theDrag

The drag reference provided by the data browser to your callback.
item

The item ID of the item the drag object is held over. If the drag object is over the data browser but not over any specific item, the item parameter contains the item ID that represents one of the following:
In list view, the target. (See SetDataBrowserTarget.)
In column view, the item ID of the column the drag object is over
Return Value

Your callback returns true if it is capable of accepting the drag object in the location designated by the item parameter. Otherwise, your callback returns false.
Discussion

The accept-drag callback is called by the data browser when your application needs to determine if it can accept a drag object in a particular location. 

To provide a pointer to your accept-drag callback, you create a universal procedure pointer (UPP) of type DataBrowserAcceptDragUPP, using the function NewDataBrowserAcceptDragUPP. You can do so with code similar to the following: DataBrowserAcceptDragUPP MyDataBrowserAcceptDragUPP;
MyDataBrowserAcceptDragUPP = NewDataBrowserAcceptDragUPP/*
                        (&MyDataBrowserAcceptDragCallback);


You can then assign MyDataBrowserAcceptDragUPP to the acceptDragCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserAcceptDragUPP function.*/

typedef Boolean (*DataBrowserAcceptDragProcPtr) (
   ControlRef browser,
   DragRef theDrag,
   DataBrowserItemID item
);


/*DataBrowserReceiveDragProcPtr

Defines a pointer to a receive-drag callback function that extract items from a drag object and handles the drag item appropriately.

typedef Boolean (*DataBrowserReceiveDragProcPtr) (
   ControlRef browser,
   DragRef theDrag,
   DataBrowserItemID item
);

You would declare a receive-drag callback function named MyDataBrowserReceiveDragCallback like this:

Boolean MyDataBrowserReceiveDragCallback (
   ControlRef browser,
   DragRef theDrag,
   DataBrowserItemID item
);
Parameters
browser

A data browser.
theDrag

The drag reference provided by the data browser to your callback.
item

The item ID of the item over which the drop operation occurred. If the drag object is over the data browser, but not over any specific item, the item parameter contains the item ID that represents one of the following:
In list view, the target. (See SetDataBrowserTarget.)
In column view, the item ID that represents the column the drag object is over
Return Value

Your callback returns true if it successfully processes the information in the drag object. Otherwise, your callback returns false to have zoom-back animation occur for the drag object, thereby indicating to the user that the drag operation was not successful.
Discussion

The receive-drag callback is called by the data browser when your application needs to receive a drag object. Your application extracts the items it needs from the drag object and processes them appropriately. 

To provide a pointer to your receive-drag callback, you create a universal procedure pointer (UPP) of type DataBrowserReceiveDragUPP, using the function NewDataBrowserReceiveDragUPP. You can do so with code similar to the following: DataBrowserReceiveDragUPP MyDataBrowserReceiveDragUPP;
MyDataBrowserReceiveDragUPP = NewDataBrowserReceiveDragUPP
                        (&MyDataBrowserReceiveDragCallback);


You can then assign MyDataBrowserReceiveDragUPP to the receiveDragCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserReceiveDragUPP function.*/

typedef Boolean (*DataBrowserReceiveDragProcPtr) (
   ControlRef browser,
   DragRef theDrag,
   DataBrowserItemID item
);


/*DataBrowserAddDragItemProcPtr

Defines a pointer to an add-drag-item callback function that adds an item to a drag reference.

typedef Boolean (*DataBrowserAddDragItemProcPtr) (
   ControlRef browser,
   DragRef theDrag,
   DataBrowserItemID item,
   ItemRef *itemRef
);

You would declare an add-drag-item callback function named MyDataBrowserAddDragItemCallback like this:

Boolean MyDataBrowserAddDragItemCallback (
   ControlRef browser,
   DragRef theDrag,
   DataBrowserItemID item,
   ItemRef *itemRef
);
Parameters
browser

A data browser.
theDrag

The drag reference provided by the data browser to your callback. 
item

The item ID of the item to add to the drag object.
itemRef

A pointer to a drag item reference variable. Your callback must set this to the DragItemRef value that it passes to the Drag Manager function AddDragItemFlavor.
Return Value

Your callback returns true to indicate the item should be or is part of the drag object. Your callback returns false if the item isn’t part of the drag object.
Discussion

The add-drag-item callback is called by the data browser when a drag operation needs to be started. The data browser iterates through the selected items, invoking your callback for each item. Your callback is called after the drag reference is created by the data browser but before the function TrackDrag is called by the system. 

Your callback adds an item to the drag reference calling the function AddDragItemFlavor. When you call AddDragItemFlavor, you must provide a unique drag item reference (DragItemRef) for each data browser item that you add to the drag. You must also provide the data type of the added item (drag flavor type) and set the appropriate drag flavor flags.

The data browser handles imaging and adds transparency for you. As a result, you do not need to create or add your own transparency information to the drag reference.

To provide a pointer to your add-drag-item callback, you create a universal procedure pointer (UPP) of type DataBrowserAddDragItemUPP, using the function NewDataBrowserAddDragItemUPP. You can do so with code similar to the following: DataBrowserAddDragItemUPP MyDataBrowserAddDragItemUPP;
MyDataBrowserAddDragItemUPP = NewDataBrowserAddDragItemUPP
                        (&MyDataBrowserAddDragItemCallback);


You can then assign MyDataBrowserAddDragItemUPP to the addDragItemCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserAddDragItemUPP function.*/
typedef ItemReference ItemRef;

typedef Boolean (*DataBrowserAddDragItemProcPtr) (
   ControlRef browser,
   DragRef theDrag,
   DataBrowserItemID item,
   ItemRef *itemRef
);

/*DataBrowserItemHelpContentProcPtr

Defines a pointer to an item-help-content callback function that provides help tag content for an item.

typedef void (*DataBrowserItemHelpContentProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   HMContentRequest inRequest,
   HMContentProvidedType *outContentProvided,
   HMHelpContentPtr ioHelpContent
);

You would declare an item-help-content callback function named MyDataBrowserItemHelpContentCallback like this:

void DataBrowserItemHelpContentCallback (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   HMContentRequest inRequest,
   HMContentProvidedType *outContentProvided,
   HMHelpContentPtr ioHelpContent
);
Parameters
browser

A data browser.
item

The item ID of the item to provide help for.
property

The property ID of the column to provide help for. In list view, this is the four-character sequence that you previously assigned to the column. In column view, this is the property kDataBrowserItemSelfIdentityProperty.
inRequest

On input, a value that indicates the nature of the help tag content request. Your callback is passed one of the following constants:
kHMSupplyContent indicates your callback needs to supply help content.
kHMDisposeContent indicates your callback must dispose of help content.

outContentProvided

On input, a help-content-type variable. On return, the variable is set to one of the following constants that indicate whether your item-help callback was able to fulfill the request specified in the inRequest parameter:
kHMContentProvided indicates help content is provided in the ioHelpContent parameter.
kHMContentNotProvided indicates help content is not provided. When your callback returns this constant, the Carbon Help Manager consults other help content providers in the hierarchy until the request for help tag content is fulfilled, the top of the hierarchy is reached, or a help tag callback notifies the Carbon Help Manager to stop propagating the request.
kHMContentNotProvidedDontPropogate indicates help content is not provided. When your callback returns this constant, the Carbon Help Manager assumes that there is no help content for the data browser item and does not propagate the request. 

See Carbon Help Manager Reference for more information on these constants.
ioHelpContent

A help tag structure that describes the help tag for the item. On input, the data browser passes a value in the version field. If the value of the inRequest parameter is kHMSupplyContent, your callback must fill in the remaining fields of the structure or specify that it is unable to fulfill the help tag content request. 
Discussion

The item-help-content callback is called by the data browser when the user hovers the pointer over an item in a data browser for which you’ve registered a help tag callback. Your application fills in the help tag structure pointed to by the ioHelpContent parameter.

When the help tag for the item is no longer needed, the data browser invokes your callback with a kHMDisposeContent request. When you receive this request, free any memory allocated for the help tag content and perform any other cleanup tasks that are necessary.

To provide a pointer to your item-help-content callback, you create a universal procedure pointer (UPP) of type DataBrowserItemHelpContentUPP, using the function NewDataBrowserItemHelpContentUPP. You can do so with code similar to the following: DataBrowserItemHelpContentUPP MyDataBrowserItemHelpContentUPP;
MyDataBrowserItemHelpContentUPP = NewDataBrowserItemHelpContentUPP
                        (&MyDataBrowserItemHelpContentCallback);


You can then assign MyDataBrowserItemHelpContentUPP to the itemHelpContentCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserItemHelpContentUPP function.*/

typedef void (*DataBrowserItemHelpContentProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   HMContentRequest inRequest,
   HMContentProvidedType *outContentProvided,
   HMHelpContentPtr ioHelpContent
);

/*DataBrowserGetContextualMenuProcPtr

Defines a pointer to a get-contextual-menu callback function that obtains a menu and information about the menu.

typedef void (*DataBrowserGetContextualMenuProcPtr) (
   ControlRef browser,
   MenuRef *menu,
   UInt32 *helpType,
   CFStringRef *helpItemString,
   AEDesc *selection
);

You would declare a get-contextual-menu callback function named MyDataBrowserGetContextualMenuCallback like this:

void MyDataBrowserGetContextualMenuCallback (
   ControlRef browser,
   MenuRef *menu,
   UInt32 *helpType,
   CFStringRef *helpItemString,
   AEDesc *selection
);
Parameters
browser

A data browser.
menu

On input, a pointer to a menu. Your callback must set the pointer to the menu that you want to have displayed for the given item. Your application is responsible for disposing of the menu; you typically perform this task in the callback DataBrowserSelectContextualMenuProcPtr.
helpType

On input, a pointer to an unsigned 32-bit integer. On return, this value specifies the type of help available for this item. This value is then passed by the data browser to the Menu Manager function ContextualMenuSelect. You can provide one of the following values:
kCMHelpItemNoHelp if your application does not support help. The Menu Manager inserts an appropriate string into the menu and then disables the associated help item. 
kCMHelpItemAppleGuide if your application supports Apple Guide help. The Menu Manager inserts the name of the main Apple Guide file into the menu and enables the associated help item. You can pass this in Mac OS 9. Apple Guide is not supported in Mac OS X. In Mac OS X, this value is ignored; a generic, but inactive, help item is displayed.
kCMHelpItemOtherHelp if your application supports some other form of help. In this case, your application must pass a valid string in the helpItemString parameter. The Menu Manager inserts the string in the menu and enables the associated help item. 

See Menu Manager Reference for more information about these constants.
helpItemString

On input, a CFStringRef variable. On return, a CFString object that contains the name of the item to display in the contextual menu. This is the first item that appears in the contextual menu. If you pass NULL, the default string (“Help”) is displayed. Your application is responsible for disposing of the CFString object.
selection

On input, a pointer to an empty AEDesc data structure. On return, the structure contains the data supplied by your callback. The data browser passes this structure to the function ContextualMenuSelect.
Discussion

The get-contextual-menu callback is called by the data browser when the user Control-clicks in the data browser. You application provides a menu and information about help that is (or is not) available for the data browser. You can determine what to provide for the content of the menu and what information to put in the AEDesc structure by calling the function GetDataBrowserItems with the state parameter set to kDataBrowserItemsIsSelected. This tells you what items are selected, which you can then use to choose the appropriate information to supply.

To provide a pointer to your get-contextual-menu callback, you create a universal procedure pointer (UPP) of type DataBrowserGetContextualMenuUPP, using the function NewDataBrowserGetContextualMenuUPP. You can do so with code similar to the following: DataBrowserGetContextualMenuUPP MyDataBrowserGetContextualMenuUPP;
MyDataBrowserGetContextualMenuUPP = NewDataBrowserGetContextualMenuUPP
                        (&MyDataBrowserGetContextualMenuCallback);


You can then assign MyDataBrowserGetContextualMenuUPP to the getContextualMenuCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserGetContextualMenuUPP function.*/
typedef void (*DataBrowserGetContextualMenuProcPtr) (
   ControlRef browser,
   MenuRef *menu,
   UInt32 *helpType,
   CFStringRef *helpItemString,
   AEDesc *selection
);

/*DataBrowserTableViewColumnID

Defines a data type for a value that identifies a column independent of its position in a data browser.

typedef DataBrowserPropertyID DataBrowserTableViewColumnID;
Discussion

For details on using this data type, see DataBrowserPropertyID.
Availability
Available in Mac OS X v10.0 and later.*/
typedef DataBrowserPropertyID DataBrowserTableViewColumnID;

/*Table View Highlighting Styles

Specify a highlighting style to use in list view.

typedef UInt32 DataBrowserTableViewHiliteStyle;
enum {
   kDataBrowserTableViewMinimalHilite = 0,
   kDataBrowserTableViewFillHilite = 1
};
Constants
kDataBrowserTableViewMinimalHilite

Use minimal highlighting. This is the highlighting used by the Finder for list view prior to Mac OS X v. 10.3. For this style, the highlight color for active items is kThemeBrushPrimaryHighlightColor and for inactive items the color is kThemeBrushSecondaryHighlightColor.

Available in Mac OS X v10.0 and later.
kDataBrowserTableViewFillHilite

Use full-row highlighting. This is the highlighting used by the Finder for list view in Mac OS X v. 10.3. For this style, the highlight color in Mac OS X v. 10.3 for active items is kThemeBrushAlternatePrimaryHighlightColor and for inactive items the color is kThemeBrushSecondaryHighlightColor. Prior to Mac OS X v. 10.3 the highlight color for active and inactive items is kThemeBrushPrimaryHighlightColor.

Available in Mac OS X v10.0 and later.*/

typedef UInt32 DataBrowserTableViewHiliteStyle;
enum {
   kDataBrowserTableViewMinimalHilite = 0,
   kDataBrowserTableViewFillHilite = 1
};


/*Control Data Tags

Define data-browser-specific tags for use with the Control Manager functions GetControlData and SetControlData.

enum {
   kControlDataBrowserIncludesFrameAndFocusTag = 'brdr',
   kControlDataBrowserKeyFilterTag = kControlEditTextKeyFilterTag,
   kControlDataBrowserEditTextKeyFilterTag =
   kControlDataBrowserKeyFilterTag,
   kControlDataBrowserEditTextValidationProcTag =
   kControlEditTextValidationProcTag
};
Constants
kControlDataBrowserIncludesFrameAndFocusTag

Include the frame and user focus. The associated data is of type Boolean.

Available in Mac OS X v10.0 and later.
kControlDataBrowserKeyFilterTag

Use a filter. The associated data is a universal procedure pointer to a ControlKeyFilterProcPtr callback. This callback is invoked when the user edits an item.

Available in Mac OS X v10.0 and later.
kControlDataBrowserEditTextKeyFilterTag

Use a text filter. This is a duplicate of kControlDataBrowserKeyFilterTag.

Available in Mac OS X v10.0 and later.
kControlDataBrowserEditTextValidationProcTag

Use a callback to validate the text. The associated data is a universal procedure pointer to a ControlEditTextValidataionProcPtr callback. This callback is invoked when the user finishes editing an item.

Available in Mac OS X v10.0 and later.
Discussion

You can use these options with the Control Manger functions GetControlData and SetControlData.*/
enum {
   kControlDataBrowserIncludesFrameAndFocusTag = 'brdr',
   kControlDataBrowserKeyFilterTag = kControlEditTextKeyFilterTag,
   kControlDataBrowserEditTextKeyFilterTag =
   kControlDataBrowserKeyFilterTag,
   kControlDataBrowserEditTextValidationProcTag =
   kControlEditTextValidationProcTag
};

/*Property Flags: Modifiers

Specify how to display the data associated with a display type.

enum {
   kDataBrowserPropertyFlagsOffset = 8,
   kDataBrowserPropertyFlagsMask =
   0xFF << kDataBrowserPropertyFlagsOffset,
   kDataBrowserCheckboxTriState  =
   1 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserDateTimeRelative  =
   1 << (kDataBrowserPropertyFlagsOffset),
   kDataBrowserDateTimeDateOnly  =
   1 << (kDataBrowserPropertyFlagsOffset + 1),
   kDataBrowserDateTimeTimeOnly  =
   1 << (kDataBrowserPropertyFlagsOffset + 2),
   kDataBrowserDateTimeSecondsToo =
   1 << (kDataBrowserPropertyFlagsOffset + 3),
   kDataBrowserSliderPlainThumb  =
   kThemeThumbPlain << kDataBrowserPropertyFlagsOffset,
   kDataBrowserSliderUpwardThumb =
   kThemeThumbUpward << kDataBrowserPropertyFlagsOffset,
   kDataBrowserSliderDownwardThumb =
   kThemeThumbDownward << kDataBrowserPropertyFlagsOffset,
   kDataBrowserDoNotTruncateText =
   3 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserTruncateTextAtEnd =
   2 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserTruncateTextMiddle =
   0 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserTruncateTextAtStart =
   1 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserPopupMenuButtonless =
   1 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserPropertyModificationFlags =
   kDataBrowserPropertyFlagsMask,
   kDataBrowserRelativeDateTime  = kDataBrowserDateTimeRelative
};
Constants
kDataBrowserPropertyFlagsOffset

The offset value for this set of property flags.

Available in Mac OS X v10.0 and later.
kDataBrowserPropertyFlagsMask

Use to set or test for property modifier flags.

Available in Mac OS X v10.0 and later.
kDataBrowserCheckboxTriState

Modifies the kDataBrowserCheckboxType display type to display a checkbox that can have on, off, and mixed-mode states instead of just on and off states.

Available in Mac OS X v10.0 and later.
kDataBrowserDateTimeRelative

Modifies the kDataBrowserDateTimeType display type to display relative date and time.

Available in Mac OS X v10.0 and later.
kDataBrowserDateTimeDateOnly

Modifies the kDataBrowserDateTimeType display type to display only the date.

Available in Mac OS X v10.0 and later.
kDataBrowserDateTimeTimeOnly

Modifies the kDataBrowserDateTimeType display type to display only the time.

Available in Mac OS X v10.0 and later.
kDataBrowserDateTimeSecondsToo

Modifies the kDataBrowserDateTimeType display type to display the time with seconds.

Available in Mac OS X v10.0 and later.
kDataBrowserSliderPlainThumb

Modifies the kDataBrowserSliderType display type to display a round thumb.

Available in Mac OS X v10.0 and later.
kDataBrowserSliderUpwardThumb

Modifies the kDataBrowserSliderType display type to display a directional thumb that points up.

Available in Mac OS X v10.0 and later.
kDataBrowserSliderDownwardThumb

Modifies the kDataBrowserSliderType display type to display a directional thumb that points down.

Available in Mac OS X v10.0 and later.
kDataBrowserDoNotTruncateText

Modifies the kDataBrowserTextType and the kDataBrowserIconAndTextType display types so they do not truncate text.

Available in Mac OS X v10.0 and later.
kDataBrowserTruncateTextAtEnd

Modifies the kDataBrowserTextType and the kDataBrowserIconAndTextType display types so they truncate text, if needed, at the end of the text string.

Available in Mac OS X v10.0 and later.
kDataBrowserTruncateTextMiddle

Modifies the kDataBrowserTextType and the kDataBrowserIconAndTextType display types so they truncate text, if needed, in the middle of the text string.

Available in Mac OS X v10.0 and later.
kDataBrowserTruncateTextAtStart

Modifies the kDataBrowserTextType and the kDataBrowserIconAndTextType display type so they truncate text, if needed, at the beginning of the text string.

Available in Mac OS X v10.0 and later.
kDataBrowserPopupMenuButtonless

This flag is only for use with columns of type kDataBrowserPopupMenuType and indicates that the popup is to be drawn in a sleek buttonless fashion. The text is drawn next to a popup glyph, and the whole cell is clickable.

Available on Mac OS X v10.4 and later.
kDataBrowserPropertyModificationFlags

Old name. Instead use kDataBrowserPropertyFlagsMask.

Available in Mac OS X v10.0 and later.
kDataBrowserRelativeDateTime

Old name. Instead use kDataBrowserDateTimeRelative.

Available in Mac OS X v10.0 and later.
Discussion

These constants reside in bits 8–15 of the DataBrowserPropertyFlags data type.*/
enum {
   kDataBrowserPropertyFlagsOffset = 8,
   kDataBrowserPropertyFlagsMask =
   0xFF << kDataBrowserPropertyFlagsOffset,
   kDataBrowserCheckboxTriState  =
   1 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserDateTimeRelative  =
   1 << (kDataBrowserPropertyFlagsOffset),
   kDataBrowserDateTimeDateOnly  =
   1 << (kDataBrowserPropertyFlagsOffset + 1),
   kDataBrowserDateTimeTimeOnly  =
   1 << (kDataBrowserPropertyFlagsOffset + 2),
   kDataBrowserDateTimeSecondsToo =
   1 << (kDataBrowserPropertyFlagsOffset + 3),
   kDataBrowserSliderPlainThumb  =
   kThemeThumbPlain << kDataBrowserPropertyFlagsOffset,
   kDataBrowserSliderUpwardThumb =
   kThemeThumbUpward << kDataBrowserPropertyFlagsOffset,
   kDataBrowserSliderDownwardThumb =
   kThemeThumbDownward << kDataBrowserPropertyFlagsOffset,
   kDataBrowserDoNotTruncateText =
   3 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserTruncateTextAtEnd =
   2 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserTruncateTextMiddle =
   0 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserTruncateTextAtStart =
   1 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserPopupMenuButtonless =
   1 << kDataBrowserPropertyFlagsOffset,
   kDataBrowserPropertyModificationFlags =
   kDataBrowserPropertyFlagsMask,
   kDataBrowserRelativeDateTime  = kDataBrowserDateTimeRelative
};

/*ControlUserPaneBackgroundProcPtr

Sets the background color or pattern for user panes that support embedding.

typedef void (*ControlUserPaneBackgroundProcPtr) (
   ControlRef control,
   ControlBackgroundPtr info
);

If you name your function MyControlUserPaneBackgroundProc, you would declare it like this:

void MyControlUserPaneBackgroundProc (
   ControlRef control,
   ControlBackgroundPtr info
);
Parameters
control

A handle to the control for which the background color or pattern is to be set. 
info

A pointer to information such as the depth and type of the drawing device. For a description of the ControlBackgroundPtr data type, see “ControlBackgroundRec”.
Discussion

The Control Manager defines the data type ControlUserPaneBackgroundUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneBackgroundUPP; 

You typically use the NewControlUserPaneBackgroundProc macro like this:

ControlUserPaneBackgroundUPP myControlUserPaneBackgroundUPP; 

myControlUserPaneBackgroundUPP = NewControlUserPaneBackgroundProc (MyControlUserPaneBackgroundCallback); 

You typically use the CallControlUserPaneBackgroundProc macro like this:

CallControlUserPaneBackgroundProc(myControlUserPaneBackgroundUPP, control, info); 

Your MyControlUserPaneBackgroundCallback function should set the user pane background color or pattern to whatever is appropriate given the bit depth and device type passed in. Your MyControlUserPaneBackgroundCallback function is called to set up the background color. This ensures that when an embedded control calls EraseRgn or EraseRect, the background is erased to the correct color or pattern.

This function is called only if there is a control embedded in the user pane and if you’ve set the kControlHasSpecialBackground and kControlSupportsEmbedding feature bits on creation of the user pane control.

Once you have provided a user pane application-defined function, you can call the function SetControlData in order to associate your function with a control. User pane application-defined functions are identified to SetControlData by tag constants for a description of the tag constants, see the “Control Manager Constants” section. For example, once you have created the function MyControlUserPaneBackgroundCallback, pass kControlUserPaneBackgroundProcTag in the tagName parameter of SetControlData.
Availability
This function is available with Appearance Manager 1.0 and later.*/

typedef void (*ControlUserPaneBackgroundProcPtr) (
   ControlRef control,
   ControlBackgroundPtr info
);

/*DataBrowserDrawItemProcPtr

Defines a pointer to a draw-item callback function that draws a custom item. 

typedef void (*DataBrowserDrawItemProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   DataBrowserItemState itemState,
   const Rect *theRect,
   SInt16 gdDepth,
   Boolean colorDevice
);

You would declare a draw-item callback function named MyDataBrowserDrawItemCallback like this:

void MyDataBrowserDrawItemCallback (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   DataBrowserItemState itemState,
   const Rect *theRect,
   SInt16 gdDepth,
   Boolean colorDevice
);
Parameters
browser

A data browser. 
item

The item ID for the item to draw.
property

The property ID for the item. In list view, this is the four-character sequence that you previously assigned to the column. In column view, this is the property kDataBrowserItemSelfIdentityProperty.
itemState

The state to use when drawing the item. See “Item States” for a description of the constants that can be provided to your callback. 
theRect

A pointer to the bounding rectangle (in local coordinates, relative to the port) that specifies where to draw the item. This rectangle is the content rectangle, not the enclosing rectangle.
gdDepth

The bit depth of the current QuickDraw graphics port. The data browser sets the current QuickDraw port to the port that you draw into. This may not always be the port of the data browser’s own window.
colorDevice

A value that specifies whether the current QuickDraw port is a color device (true) or is not (false).
Discussion

The draw-item callback is called by the data browser when an item whose display type is kDataBrowserCustomType needs to be drawn. Your application draws the item so it reflects the state specified by the itemState parameter.

To provide a pointer to your draw-item callback, you create a universal procedure pointer (UPP) of type DataBrowserDrawItemUPP, using the function NewDataBrowserDrawItemUPP. You can do so with code similar to the following: DataBrowserDrawItemUPP MyDataBrowserDrawItemUPP;
MyDataBrowserDrawItemUPP = NewDataBrowserDrawItemUPP
                        (&MyDataBrowserDrawItemCallback);


You can then assign MyDataBrowserDrawItemUPP to the drawItemCallback field of the structure DataBrowserCustomCallbacks. You install your data browser custom callbacks using the function SetDataBrowserCustomCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserDrawItemUPP function.*/

typedef void (*DataBrowserDrawItemProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   DataBrowserItemState itemState,
   const Rect *theRect,
   SInt16 gdDepth,
   Boolean colorDevice
);


/*ControlUserPaneHitTestProcPtr

Returns the part code of the control that the point was in when the mouse-down event occurred.

typedef ControlPartCode (*ControlUserPaneHitTestProcPtr) (
   ControlRef control,
   Point where
);

If you name your function MyControlUserPaneHitTestProc, you would declare it like this:

ControlPartCode MyControlUserPaneHitTestProc (
   ControlRef control,
   Point where
);
Parameters
control

A handle to the control in which the mouse-down event occurred. For a description of this data type, see “ControlRef”.
where

The point, in a window’s local coordinates, where the mouse-down event occurred. 
Return Value

The part code of the control where the mouse-down event occurred. If the point was not over a control, your function should return kControlNoPart. For a description of this data type, see “ControlPartCode”.
Discussion

The Control Manager defines the data type ControlUserPaneHitTestUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneHitTestUPP; 

You typically use the NewControlUserPaneHitTestProc macro like this:

ControlUserPaneHitTestUPP myControlUserPaneHitTestUPP; 

myControlUserPaneHitTestUPP = NewControlUserPaneHitTestProc(MyControlUserPaneHitTestCallback); 

You typically use the CallControlUserPaneHitTestProc macro like this:

CallControlUserPaneHitTestProc(myControlUserPaneHitTestUPP, control, where); 

Once you have provided a user pane application-defined function, you can call the function SetControlData in order to associate your function with a control. User pane application-defined functions are identified to SetControlData by tag constants for a description of the tag constants, see the “Control Manager Constants” section. For example, once you have created the function MyControlUserPaneHitTestCallback, pass kControlUserPaneHitTestProcTag in the tagName parameter of SetControlData.
Availability
This function is available with Appearance Manager 1.0 and later.*/
typedef ControlPartCode (*ControlUserPaneHitTestProcPtr) (
   ControlRef control,
   Point where
);

/*The Control Manager defines the data type ControlUserPaneTrackingUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneTrackingUPP;*/
typedef UniversalProcPtr ControlUserPaneTrackingUPP;

/*ControlUserPaneTrackingProcPtr

Tracks a control while the user holds down the mouse button.

typedef ControlPartCode (*ControlUserPaneTrackingProcPtr) (
   ControlRef control,
   Point startPt,
   ControlActionUPP actionProc
);

If you name your function MyControlUserPaneTrackingProc, you would declare it like this:

ControlPartCode MyControlUserPaneTrackingProc (
   ControlRef control,
   Point startPt,
   ControlActionUPP actionProc
);
Parameters
control

A handle to the control in which the mouse-down event occurred. For a description of this data type, see “ControlRef”.
startPt

The location of the cursor at the time the mouse button was first pressed, in local coordinates. Your application retrieves this point from the where field of the event structure. 
actionProc

A pointer to an action function defining what action your application takes while the user holds down the mouse button. The value of the actionProc parameter can be a valid procPtr, NULL, or -1. A value of -1 indicates that the control should either perform auto tracking, or if it is incapable of doing so, do nothing (like NULL). For a description of this data type, see “ControlActionProcPtr”.
Return Value

The part code of the control part that was tracked. If tracking was unsuccessful, kControlNoPartCode is returned. For a description of this data type, see “ControlPartCode”.
Discussion

The Control Manager defines the data type ControlUserPaneTrackingUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneTrackingUPP; 

You typically use the NewControlUserPaneTrackingingProc macro like this:

ControlUserPaneTrackingUPP myControlUserPaneTrackingUPP; 

myControlUserPaneTrackingUPP = NewControlUserPaneTrackingProc(MyControlUserPaneTrackingCallback); 

You typically use the CallControlUserPaneTrackingingProc macro like this:

CallControlUserPaneTrackingProc(myControlUserPaneTrackingUPP, control, startPt, actionProc); 

Your MyControlUserPaneTrackingCallback function should track the control by repeatedly calling the action function specified in the actionProc parameter until the mouse button is released. When the mouse button is released, your function should return the part code of the control part that was tracked. This function is called only if you’ve set the kControlHandlesTracking feature bit on creation of the user pane control.

Once you have provided a user pane application-defined function, you can call the function SetControlData in order to associate your function with a control. User pane application-defined functions are identified to SetControlData by tag constants for a description of the tag constants, see the “Control Manager Constants” section. For example, once you have created the function MyControlUserPaneTrackingCallback, pass kControlUserPaneTrackingProcTag in the tagName parameter of SetControlData.
Availability
This function is available with Appearance Manager 1.0 and later.*/

typedef ControlPartCode (*ControlUserPaneTrackingProcPtr) (
   ControlRef control,
   Point startPt,
   ControlActionUPP actionProc
);

/*The Control Manager defines the data type UserPaneKeyDownUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneKeyDownUPP;*/
typedef UniversalProcPtr ControlUserPaneKeyDownUPP;

/*ControlUserPaneKeyDownProcPtr

Handles keyboard event processing.

typedef ControlPartCode (*ControlUserPaneKeyDownProcPtr) (
   ControlRef control,
   SInt16 keyCode,
   SInt16 charCode,
   SInt16 modifiers
);

If you name your function MyControlUserPaneKeyDownProc, you would declare it like this:

ControlPartCode MyControlUserPaneKeyDownProc (
   ControlRef control,
   SInt16 keyCode,
   SInt16 charCode,
   SInt16 modifiers
);
Parameters
control

A handle to the control in which the keyboard event occurred. For a description of this data type, see “ControlRef”.
keyCode

The virtual key code derived from event structure. This value represents the key pressed or released by the user. It is always the same for a specific physical key on a particular keyboard regardless of which modifier keys were also pressed. 
charCode

A particular character derived from the event structure. This value depends on the virtual key code, the state of the modifier keys, and the current 'KCHR' resource.
modifiers

The constant in the modifiers field of the event structure specifying the state of the modifier keys and the mouse button at the time the event was posted.
Return Value

The part code of the control where the keyboard event occurred. If the keyboard event did not occur in a control, your function should return kControlNoPart. For a description of this data type, see “ControlPartCode”.
Discussion

The Control Manager defines the data type UserPaneKeyDownUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneKeyDownUPP; 

You typically use the NewControlUserPaneKeyDownProc macro like this:

ControlUserPaneKeyDownUPP myControlUserPaneKeyDownUPP; 

myControlUserPaneKeyDownUPP = NewControlUserPaneKeyDownProc(MyControlUserPaneKeyDownCallback); 

You typically use the CallControlUserPaneKeyDownProc macro like this:

CallControlUserPaneKeyDownProc(myControlUserPaneKeyDownUPP, control, keyCode, charCode, modifiers); 

Your MyUserPaneKeyDownCallback function should handle the key pressed or released by the user and return the part code of the control where the keyboard event occurred. This function is called only if you’ve set the kControlSupportsFocus feature bit on creation of the user pane control.

Once you have provided a user pane application-defined function, you can call the function SetControlData in order to associate your function with a control. User pane application-defined functions are identified to SetControlData by tag constants for a description of the tag constants, see the “Control Manager Constants” section. For example, once you have created the function MyControlUserPaneKeyDownCallback, pass kControlUserPaneKeyDownProcTag in the tagName parameter of SetControlData.
Availability
This function is available with Appearance Manager 1.0 and later.*/

typedef ControlPartCode (*ControlUserPaneKeyDownProcPtr) (
   ControlRef control,
   SInt16 keyCode,
   SInt16 charCode,
   SInt16 modifiers
);

/*The Control Manager defines the data type UserPaneActivateUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneActivateUPP;*/
typedef UniversalProcPtr ControlUserPaneActivateUPP;

/*ControlUserPaneActivateProcPtr

Handles activate and deactivate event processing.

typedef void (*ControlUserPaneActivateProcPtr) (
   ControlRef control,
   Boolean activating
);

If you name your function MyControlUserPaneActivateProc, you would declare it like this:

void MyControlUserPaneActivateProc (
   ControlRef control,
   Boolean activating
);
Parameters
control

A handle to the control in which the activate event occurred. 
activating

If true, the control is being activated. If false, the control is being deactivated. 
Discussion

The Control Manager defines the data type UserPaneActivateUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneActivateUPP;

You typically use the NewControlUserPaneActivateProc macro like this:

ControlUserPaneActivateUPP myControlUserPaneActivateUPP; 

myControlUserPaneActivateUPP = NewControlUserPaneActivateProc (MyControlUserPaneActivateCallback); 

You typically use the CallControlUserPaneActivateProc macro like this:

CallControlUserPaneActivateProc(myControlUserPaneActivateUPP, control, activating); 

Your MyControlUserPaneActivateCallback function should perform any special processing before the user pane becomes activated or deactivated. For example, it should deactivate its TEHandle or ListHandle if the user pane is about to be deactivated.

This function is called only if you’ve set the kControlWantsActivate feature bit on creation of the user pane control.

Once you have provided a user pane application-defined function, you can call the function SetControlData in order to associate your function with a control. User pane application-defined functions are identified to SetControlData by tag constants for a description of the tag constants, see the “Control Manager Constants” section. For example, once you have created the function MyControlUserPaneActivateCallback, pass kControlUserPaneActivateProcTag in the tagName parameter of SetControlData.
Availability
This function is available with Appearance Manager 1.0 and later.*/
typedef void (*ControlUserPaneActivateProcPtr) (
   ControlRef control,
   Boolean activating
);

/*The Control Manager defines the data type ControlUserPaneFocusUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneFocusUPP;*/
typedef UniversalProcPtr ControlUserPaneFocusUPP;

/*ControlUserPaneFocusProcPtr

Handles keyboard focus.

typedef ControlPartCode (*ControlUserPaneFocusProcPtr) (
   ControlRef control,
   ControlFocusPart action
);

If you name your function MyControlUserPaneFocusProc, you would declare it like this:

ControlPartCode MyControlUserPaneFocusProc (
   ControlRef control,
   ControlFocusPart action
);
Parameters
control

A handle to the control that is to adjust its focus. 
action

The part code of the user pane to receive keyboard focus; see ControlDefProcPtr. 
Return Value

The part of the user pane actually focused. The constant kControlFocusNoPart is returned if the user pane has lost the focus or cannot be focused. For a description of this data type, see “ControlPartCode”.
Discussion

The Control Manager defines the data type ControlUserPaneFocusUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneFocusUPP; 

You typically use the NewControlUserPaneFocusProc macro like this:

ControlUserPaneFocusUPP myControlUserPaneFocusUPP; 

myControlUserPaneFocusUPP = NewControlUserPaneFocusProc (MyControlUserPaneFocusCallback); 

You typically use the CallControlUserPaneFocusProc macro like this:

CallControlUserPaneFocusProc(myControlUserPaneFocusUPP, control, action); 

Your MyControlUserPaneFocusCallback function is called in response to a change in keyboard focus. It should respond by changing keyboard focus based on the part code passed in the action parameter. This function is called only if you’ve set the kControlSupportsFocus feature bit on creation of the user pane control.

Once you have provided a user pane application-defined function, you can call the function SetControlData in order to associate your function with a control. User pane application-defined functions are identified to SetControlData by tag constants for a description of the tag constants, see the “Control Manager Constants” section. For example, once you have created the function MyControlUserPaneFocusCallback, pass kControlUserPaneFocusProcTag in the tagName parameter of SetControlData.
Availability
This function is available with Appearance Manager 1.0 and later.*/
typedef ControlPartCode (*ControlUserPaneFocusProcPtr) (
   ControlRef control,
   ControlFocusPart action
);

/*The Control Manager defines the data type ControlUserPaneIdleUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneIdleUPP;*/
typedef UniversalProcPtr ControlUserPaneIdleUPP;

/*ControlUserPaneIdleProcPtr

Performs idle processing.

typedef void (*ControlUserPaneIdleProcPtr) (
   ControlRef control
);

If you name your function MyControlUserPaneIdleProc, you would declare it like this:

void MyControlUserPaneIdleProc (
   ControlRef control
);
Parameters
control

A handle to the control for which you wish to perform idle processing. For a description of this data type, see “ControlRef”.
Discussion

The Control Manager defines the data type ControlUserPaneIdleUPP to identify the universal procedure pointer for this application-defined function:

typedef UniversalProcPtr ControlUserPaneIdleUPP; 

You typically use the NewControlUserPaneIdleProc macro like this:

ControlUserPaneIdleUPP myControlUserPaneIdleUPP; 

myControlUserPaneIdleUPP = NewControlUserPaneIdleProc(MyControlUserPaneIdleCallback); 

You typically use the CallControlUserPaneIdleProc macro like this:

CallControlUserPaneIdleProc(myControlUserPaneIdleUPP, control); 

This function is called only if you’ve set the kControlWantsIdle feature bit on creation of the user pane control.

Once you have provided a user pane application-defined function, you can call the function SetControlData in order to associate your function with a control. User pane application-defined functions are identified to SetControlData by tag constants for a description of the tag constants, see the “Control Manager Constants” section. For example, once you have created the function MyControlUserPaneIdleCallback, pass kControlUserPaneIdleProcTag in the tagName parameter of SetControlData.
Availability
This function is available with Appearance Manager 1.0 and later.*/
typedef void (*ControlUserPaneIdleProcPtr) (
   ControlRef control
);

/*Display Types

Specify a data type or control to display in a column. 

typedef OSType DataBrowserPropertyType;
enum {
   kDataBrowserCustomType = 0x3F3F3F3F,
   kDataBrowserIconType = 'icnr',
   kDataBrowserTextType = 'text',
   kDataBrowserDateTimeType = 'date',
   kDataBrowserSliderType = 'sldr',
   kDataBrowserCheckboxType = 'chbx',
   kDataBrowserProgressBarType = 'prog',
   kDataBrowserRelevanceRankType = 'rank',
   kDataBrowserPopupMenuType = 'menu',
   kDataBrowserIconAndTextType = 'ticn'
};
Constants
kDataBrowserCustomType

Displays custom data defined by your application. You must install callbacks to handle items of this type. Use custom types with caution. In some cases custom types do not display properly or exhibit the appropriate behavior.

Available in Mac OS X v10.0 and later.
kDataBrowserIconType

Displays icons. The associated data for the icon can be of type IconRef, IconTransformType, and RGBColor. 

Available in Mac OS X v10.0 and later.
kDataBrowserTextType

Displays text. The associated data is a CFString object.

Available in Mac OS X v10.0 and later.
kDataBrowserDateTimeType

Displays date and time information. The associated data can be of type DateTime or LongDateTime.

Available in Mac OS X v10.0 and later.
kDataBrowserSliderType

Displays slider controls. The associated data are values that define the minimum and maximum values and the current value for the slider. Avoid using slider controls in a data browser because, in some cases, they do not display properly onscreen. 

Available in Mac OS X v10.0 and later.
kDataBrowserCheckboxType

Displays checkbox controls. The associated data is the current value of the checkbox and a ThemeButtonValue value. Avoid using checkbox controls in a data browser because, in some cases, they do not display properly onscreen.

Available in Mac OS X v10.0 and later.
kDataBrowserProgressBarType

Displays progress bar controls. The associated data are values that define the minimum and maximum values and the current setting for the progress bar.

Available in Mac OS X v10.0 and later.
kDataBrowserRelevanceRankType

Displays relevance indicators. The associated data are values that define the minimum and maximum values and the current setting for the relevance indicator. Avoid using relevance indicators in a data browser because, in some cases, they do not display properly onscreen.

Available in Mac OS X v10.0 and later.
kDataBrowserPopupMenuType

Displays pop-up menus. The associated data is a MenuRef data type, a menu item ID, and the value of the pop-up menu, which indicates the item of the menu to draw in the pop-up menu. Avoid using pop-up menu controls in a data browser because, in some cases, they do not display properly onscreen.

Available in Mac OS X v10.0 and later.
kDataBrowserIconAndTextType

Displays icon and text data. The associated data can be of any data type used for icons or text, such as an IconRef data type and a CFString object.

Available in Mac OS X v10.0 and later.
Discussion

You can use these constants to define what is displayed in a column. Each constant defines a presentation style and implies a specific set of primitive types or data structures.*/
typedef OSType DataBrowserPropertyType;
enum {
   kDataBrowserCustomType = 0x3F3F3F3F,
   kDataBrowserIconType = 'icnr',
   kDataBrowserTextType = 'text',
   kDataBrowserDateTimeType = 'date',
   kDataBrowserSliderType = 'sldr',
   kDataBrowserCheckboxType = 'chbx',
   kDataBrowserProgressBarType = 'prog',
   kDataBrowserRelevanceRankType = 'rank',
   kDataBrowserPopupMenuType = 'menu',
   kDataBrowserIconAndTextType = 'ticn'
};


/*DataBrowserPropertyDesc

Contains property and display information for a list view column.

struct DataBrowserPropertyDesc {
   DataBrowserPropertyID propertyID;
   DataBrowserPropertyType propertyType;
   DataBrowserPropertyFlags propertyFlags;
};
typedef struct DataBrowserPropertyDesc DataBrowserPropertyDesc;
Fields
propertyID

A four-character sequence that uniquely identifies the column. If you use Interface Builder to design the data browser, this is the unique value you enter in the Property ID field in the column paned of the Info window for a list view column. (For example, mTxt or BLUE). The four-character sequence must have at least one uppercase letter in it because sequences that are all lowercase are reserved for Apple.
propertyType

The data type or control type to be displayed in the column. See “Display Types” for a list of the possible values for this field.
propertyFlags

A value that contains property flags that control the display or interaction provided by the column. This is a 32-bit value that is divided into four parts as follows: 
Bits 0–7 specify properties applied to the data browser as a whole—see “Property Flags: Universal”
Bits 8–15 modify display behavior—see “Property Flags: Modifiers”
Bits 16–23 are properties specific to list view—see “Property Flags: Offset and Mask for List View Properties” and “Property Flags: List View Column Behavior”
Bits 24–31 can be defined by your application—see “Property Flags: Offset and Mask for Client-Defined Properties”
Availability
Available in Mac OS X v10.0 and later.*/
struct DataBrowserPropertyDesc {
   DataBrowserPropertyID propertyID;
   DataBrowserPropertyType propertyType;
   DataBrowserPropertyFlags propertyFlags;
};
typedef struct DataBrowserPropertyDesc DataBrowserPropertyDesc;


/*DataBrowserTableViewColumnDesc

Defines a data type for a table view column description.

typedef DataBrowserPropertyDesc DataBrowserTableViewColumnDesc;
Discussion

See the DataBrowserPropertyDesc data structure for more information.
Availability
Available in Mac OS X v10.0 and later.*/
typedef DataBrowserPropertyDesc DataBrowserTableViewColumnDesc;

/*Sorting Orders

Specify the order in which to sort data.

typedef UInt16 DataBrowserSortOrder;
enum {
   kDataBrowserOrderUndefined = 0,
   kDataBrowserOrderIncreasing = 1,
   kDataBrowserOrderDecreasing = 2
};
Constants
kDataBrowserOrderUndefined

This constant has no meaning in the context of your application; don’t use it.

Available in Mac OS X v10.0 and later.
kDataBrowserOrderIncreasing

Sort in increasing order.

Available in Mac OS X v10.0 and later.
kDataBrowserOrderDecreasing

Sort in decreasing order. 

Available in Mac OS X v10.0 and later.*/
typedef UInt16 DataBrowserSortOrder;
enum {
   kDataBrowserOrderUndefined = 0,
   kDataBrowserOrderIncreasing = 1,
   kDataBrowserOrderDecreasing = 2
};


/*DataBrowserListViewHeaderDesc

Describes the appearance of a column title in list view.

struct DataBrowserListViewHeaderDesc {
   UInt32 version;
   UInt16 minimumWidth;
   UInt16 maximumWidth;
   SInt16 titleOffset;
   CFStringRef titleString;
   DataBrowserSortOrder initialOrder;
   ControlFontStyleRec btnFontStyle;
   ControlButtonContentInfo btnContentInfo;
};
typedef struct DataBrowserListViewHeaderDesc DataBrowserListViewHeaderDesc;
Fields
version

The format of the structure. Set this field to the value kDataBrowserListViewLatestHeaderDesc.
minimumWidth

For resizable columns, the smallest width to which the column can be resized. If the column is not resizable, set this to the same value as the maximumWidth field.
maximumWidth

For resizable columns, the largest width to which the column can be resized. If the column is not resizable, set this to the same value as the minimumWidth field.
titleOffset

An offset, in pixels, from the left side of the column that specifies where the title text will be drawn. The title alignment (set in the just field of the btnFontStyle parameter) and the titleOffset values dictate the alignment and offset (inset by default) of the content of the column when displaying one of he predefined display types. Typically the title offset is set to 0.
titleString

The text to use for the column title. Set the string to NULL if you do not want to display a title.
initialOrder

The initial sorting order to use for the column when the column is the current sort column. After the data browser is visible, the user can change the sorting order. You can assign one of the following values: 
kDataBrowserOrderIncreasing means this column sorts in ascending order.
kDataBrowserOrderDecreasing means this column sorts in descending order.
btnFontStyle

A structure that describes the contents of the column heading and how to draw them. This allows you to customize the font that the column title is drawn with, which is independent of the font used to draw the data in the column.
btnContentInfo

A structure that defines the icon, if any, to use for the column heading.
Availability
Available in Mac OS X v10.0 and later.*/
struct DataBrowserListViewHeaderDesc {
   UInt32 version;
   UInt16 minimumWidth;
   UInt16 maximumWidth;
   SInt16 titleOffset;
   CFStringRef titleString;
   DataBrowserSortOrder initialOrder;
   ControlFontStyleRec btnFontStyle;
   ControlButtonContentInfo btnContentInfo;
};
typedef struct DataBrowserListViewHeaderDesc DataBrowserListViewHeaderDesc;

/*DataBrowserListViewColumnDesc

Contains property information for a list view column and specifies display information for the column title.

struct DataBrowserListViewColumnDesc {
   DataBrowserTableViewColumnDesc propertyDesc;
   DataBrowserListViewHeaderDesc headerBtnDesc;
};
typedef struct DataBrowserListViewColumnDesc DataBrowserListViewColumnDesc;
Fields
propertyDesc

A structure that contains property and display information for a column. See DataBrowserTableViewColumnDesc for more information.
headerBtnDesc

A structure that contains display information for the column title. See DataBrowserListViewHeaderDesc for more information.
Availability
Available in Mac OS X v10.0 and later.*/
struct DataBrowserListViewColumnDesc {
   DataBrowserTableViewColumnDesc propertyDesc;
   DataBrowserListViewHeaderDesc headerBtnDesc;
};
typedef struct DataBrowserListViewColumnDesc DataBrowserListViewColumnDesc;

/*Property Flags: Offset and Mask for List View Properties

Specify an offset and mask for bits 16–23 of the DataBrowserPropertyFlag data type.

enum {
   kDataBrowserViewSpecificFlagsOffset = 16,
   kDataBrowserViewSpecificFlagsMask =
   0xFF << kDataBrowserViewSpecificFlagsOffset,
   kDataBrowserViewSpecificPropertyFlags =
   kDataBrowserViewSpecificFlagsMask
};
Constants
kDataBrowserViewSpecificFlagsOffset

The offset value for this set of property flags.

Available in Mac OS X v10.0 and later.
kDataBrowserViewSpecificFlagsMask

Use to set or test for view-specific property flags.

Available in Mac OS X v10.0 and later.
kDataBrowserViewSpecificPropertyFlags

Old name. Instead use kDataBrowserViewSpecificFlagsMask.

Available in Mac OS X v10.0 and later.
Discussion

See also “Property Flags: List View Column Behavior”.*/

enum {
   kDataBrowserViewSpecificFlagsOffset = 16,
   kDataBrowserViewSpecificFlagsMask =
   0xFF << kDataBrowserViewSpecificFlagsOffset,
   kDataBrowserViewSpecificPropertyFlags =
   kDataBrowserViewSpecificFlagsMask
};


/*Table View Property Flag

Specifies a table view property.

typedef UInt32 DataBrowserTableViewPropertyFlags;
enum {
   kDataBrowserTableViewSelectionColumn = 1 <<  kDataBrowserViewSpecificFlagsOffset
};
Constants
kDataBrowserTableViewSelectionColumn

The column can be selected. 

Available in Mac OS X v10.0 and later.*/
typedef UInt32 DataBrowserTableViewPropertyFlags;
enum {
   kDataBrowserTableViewSelectionColumn = 1 <<  kDataBrowserViewSpecificFlagsOffset
};


/*Property Flags: List View Column Behavior

Specify behaviors for columns in list view. 

typedef DataBrowserPropertyFlags DataBrowserListViewPropertyFlags;
enum {
   kDataBrowserListViewSelectionColumn =
   kDataBrowserTableViewSelectionColumn,
   kDataBrowserListViewMovableColumn =
   1 << (kDataBrowserViewSpecificFlagsOffset  + 1),
   kDataBrowserListViewSortableColumn =
   1 << (kDataBrowserViewSpecificFlagsOffset  + 2),
   kDataBrowserListViewTypeSelectColumn =
   1 << (kDataBrowserViewSpecificFlagsOffset  + 3),
   kDataBrowserListViewNoGapForIconInHeaderButton =
   1 << (kDataBrowserViewSpecificFlagsOffset  + 4),
   kDataBrowserListViewDefaultColumnFlags =
   kDataBrowserListViewMovableColumn +
   kDataBrowserListViewSortableColumn
};
Constants
kDataBrowserListViewSelectionColumn

If you are using a minimally highlighted list, this indicates to draw the contents of this column as highlighted when the item is selected. (Minimal highlighting is the highlighting used by the Finder for list view prior to Mac OS X version 10.3.)

Available in Mac OS X v10.0 and later.
kDataBrowserListViewMovableColumn

The column is movable.

Available in Mac OS X v10.0 and later.
kDataBrowserListViewSortableColumn

The column can be sorted.

Available in Mac OS X v10.0 and later.
kDataBrowserListViewTypeSelectColumn

The column is capable of being selected and having text entered. If one or more of your list view columns are marked as type-selectable, the data browser handles type-selection for you automatically. You can use this flag with columns whose display type is kDataBrowserTextType, kDataBrowserIconAndTextType, or kDataBrowserDateTimeType. If you set this flag for a column of another type, the type-select behavior is undefined. Turning on this flag causes the data browser to obtain keyboard input using a Carbon event handler instead of relying on calls to the function HandleControlKey.

Available in Mac OS X 10.3 and later.
kDataBrowserListViewNoGapForIconInHeaderButton

Normally the text in a header button for a column of type kDataBrowserIconAndTextType is aligned as though it has an icon next to it even if no icon is specified for the header button. This flag indicates that space should not be reserved for an icon if no icon is provided for the header button. This flag allows a client to justify the left edge of the text in a header button to the left edge of the icon in the cells beneath it.

Available in Mac OS X v10.4 and later.
kDataBrowserListViewDefaultColumnFlags

The default properties. You can assign this flag to the propertyFlags field of the DataBrowserPropertyDesc structure if all you need is the default behavior for list view. 

Available in Mac OS X v10.0 and later.
Discussion

These constants reside in bits 16–23 of the DataBrowserPropertyFlags data type and are specific to a list view.*/
typedef DataBrowserPropertyFlags DataBrowserListViewPropertyFlags;
enum {
   kDataBrowserListViewSelectionColumn =
   kDataBrowserTableViewSelectionColumn,
   kDataBrowserListViewMovableColumn =
   1 << (kDataBrowserViewSpecificFlagsOffset  + 1),
   kDataBrowserListViewSortableColumn =
   1 << (kDataBrowserViewSpecificFlagsOffset  + 2),
   kDataBrowserListViewTypeSelectColumn =
   1 << (kDataBrowserViewSpecificFlagsOffset  + 3),
   kDataBrowserListViewNoGapForIconInHeaderButton =
   1 << (kDataBrowserViewSpecificFlagsOffset  + 4),
   kDataBrowserListViewDefaultColumnFlags =
   kDataBrowserListViewMovableColumn +
   kDataBrowserListViewSortableColumn
};

/*inLabel

enum {
   inLabel = kControlLabelPart,
   inMenu = kControlMenuPart,
   inTriangle = kControlTrianglePart,
   inButton = kControlButtonPart,
   inCheckBox = kControlCheckBoxPart,
   inUpButton = kControlUpButtonPart,
   inDownButton = kControlDownButtonPart,
   inPageUp = kControlPageUpPart,
   inPageDown = kControlPageDownPart
};*/
enum {
   inLabel = kControlLabelPart,
   inMenu = kControlMenuPart,
   inTriangle = kControlTrianglePart,
   inButton = kControlButtonPart,
   inCheckBox = kControlCheckBoxPart,
   inUpButton = kControlUpButtonPart,
   inDownButton = kControlDownButtonPart,
   inPageUp = kControlPageUpPart,
   inPageDown = kControlPageDownPart
};

/*PopupPrivateData

struct PopupPrivateData {
   MenuRef mHandle;
   SInt16 mID;
};
typedef PopupPrivateData PopupPrivateData;
Discussion

Use of this structure is not recommended. When the Appearance Manager is available, you should pass the value kControlPopupButtonMenuHandleTag in the tagName parameter of the GetControlData function to get the menu handle of a button, and the menu handle and the menu ID of the menu associated with a pop-up menu. 
Availability
Available in Mac OS X v10.0 and later.*/
struct PopupPrivateData {
   MenuRef mHandle;
   SInt16 mID;
};
typedef struct PopupPrivateData PopupPrivateData;

/*PopupPrivateDataPtr

typedef PopupPrivateData* PopupPrivateDataPtr;
Availability
Available in Mac OS X v10.0 and later.*/
typedef PopupPrivateData* PopupPrivateDataPtr;

/*PopupPrivateDataHandle

typedef PopupPrivateDataPtr* PopupPrivateDataHandle;
Availability
Available in Mac OS X v10.0 and late*/
typedef PopupPrivateDataPtr* PopupPrivateDataHandle;

/*ControlEditTextValidationProcPtr

Ensures that the content of an editable text control is valid.

typedef void (*ControlEditTextValidationProcPtr) (
   ControlRef control
);

If you name your function MyControlEditTextValidationProc, you would declare it like this:

void MyControlEditTextValidationProc (
   ControlRef control
);
Parameters
control

A handle to the control containing the editable text to be validated. For a description of this data type, see “ControlRef”.
Discussion

Your application typically uses a MyControlEditTextValidationCallback function in conjunction with a key filter function to ensure that editable text is valid in cases such as a cut, paste, or clear, where a key filter cannot be called. Use the kControlEditTextValidationProcTag control data tag constant, described in “Editable Text Control Data Tag Constants”, with the functions SetControlData and GetControlData to set or retrieve a MyControlEditTextValidationCallback function.

Note that if you are using the inline input editable text control variant, the Control Manager will not call your MyControlEditTextValidationCallback function during inline input. Instead, you may install your own Text Services Manager TSMTEPostUpdateUPP callback function to validate text during inline input, or your application can validate the input itself, immediately prior to using the text.

When you implement your editable text validation function, the pointer that you pass to SetControlData must be a universal procedure pointer of the following type: typedef ControlEditTextValidationProcPtr ControlEditTextValidationUPP;


To create a universal procedure pointer for your application-defined editable text validation function, you should use the NewControlEditTextValidationProc macro as follows: ControlEditTextValidationUPP myControlEditTextValidationUPP;
 myControlEditTextValidationUPP = NewControlEditTextValidationProc
(MyControlEditTextValidationCallback);


You can then pass myControlEditTextValidationUPP in the inData parameter of SetControlData. When you no longer need the universal procedure pointer, you should remove it using the DisposeRoutineDescriptor function.

If you need to call your application-defined function from outside your application for some reason (for example, from a plug-in), you should use the CallControlEditTextValidationProc macro to make the call, as follows: ControlEditTextValidationUPP myControlEditTextValidationUPP;
 CallControlEditTextValidationProc (myControlEditTextValidationUPP,  control);


Using this macro ensures that the call is made through a universal procedure pointer. 
Availability
This callback is available with Mac OS 8.5 and later.*/
typedef void (*ControlEditTextValidationProcPtr) (
   ControlRef control
);
typedef ControlEditTextValidationProcPtr ControlEditTextValidationUPP;


/*ControlTabInfoRec

struct ControlTabInfoRec {
   SInt16 version;
   SInt16 iconSuiteID;
   Str255 name;
};
typedef struct ControlTabInfoRec ControlTabInfoRec;
Fields
version

The version of the tab information structure. The only currently available version value is 0. 
iconSuiteID

The ID of an icon suite to use for the tab label. If the specified ID is not found, no icon is displayed for the tab label. Pass 0 for no icon.
name

The title to be used for the tab label. 
Discussion

You can use the ControlTabInfoRec type to specify the icon and title for a tab control. If you are not creating a tab control with a 'tab#' resource, you can call SetControlMaximum to set the number of tabs in a tab control. Then use the functions SetControlData and GetControlData with the ControlTabInfoRec structure to access information for an individual tab in a tab control. 
Version Notes

The ControlTabInfoRec type is available with Appearance Manager 1.0.1 and later.
Availability
Available in Mac OS X v10.0 and later.*/
struct ControlTabInfoRec {
   SInt16 version;
   SInt16 iconSuiteID;
   Str255 name;
};
typedef struct ControlTabInfoRec ControlTabInfoRec;

/*Tab Control Data Tag Constants

enum {
   kControlTabContentRectTag = 'rect',
   kControlTabEnabledFlagTag = 'enab',
   kControlTabFontStyleTag = kControlFontStyleTag
};
Constants
kControlTabContentRectTag

Gets the content rectangle of a tab control.

Data type returned: Rect

Available in Mac OS X v10.0 and later.
kControlTabEnabledFlagTag

Enables or disables a single tab in a tab control.

Data type returned or set: Boolean; if true, enabled; if false, disabled.

Available in Mac OS X v10.0 and later.
Discussion

You can use the control data tag constants to set or obtain data that is associated with a control. The control data tag constants are passed in the inTagName parameters of SetControlData and GetControlData to specify the piece of data in a control that you wish to set or get. You can also pass these constants in the inTagName parameter of GetControlDataSize if you wish to determine the size of variable-length control data. These constants can also be used by custom control definition functions that return the feature bit kControlSupportsDataAccess in response to a kControlMsgGetFeatures message. 

The data that your application sets or obtains can be of various types, dependent upon the control. Therefore, the descriptions of the control data tag constants list the data types for the information that you can set in the inData parameter to the SetControlData function and that you can get in the inBuffer parameter to the GetControlData function. 
Version Notes

The control data tag constants are available with Appearance Manager 1.0 and later.*/
enum {
   kControlTabContentRectTag = 'rect',
   kControlTabEnabledFlagTag = 'enab',
   kControlTabFontStyleTag = kControlFontStyleTag
};

/*DataBrowserPostProcessDragProcPtr

Defines a pointer to a postprocess-drag callback function that performs necessary cleanup tasks, such as deallocating resources that were allocated by your other drag processing callbacks.

typedef void (*DataBrowserPostProcessDragProcPtr) (
   ControlRef browser,
   DragRef theDrag,
   OSStatus trackDragResult
);

You would declare a postprocess-drag callback function named MyDataBrowserPostProcessDragCallback like this:

void MyDataBrowserPostProcessDragCallback (
   ControlRef browser,
   DragRef theDrag,
   OSStatus trackDragResult
);
Parameters
browser

A data browser.
theDrag

The drag reference provided by the data browser to your callback.
trackDragResult

The result returned by the function TrackDrag and passed to your callback by the data browser.
Discussion

This callback is called after starting a drag from within the data browser. It is not called if the drag originated from somewhere else.

The postprocess-drag callback is called by the data browser after a drag process is complete and any drag processing callback routines you installed (add drag, accept drag, or receive drag callbacks) were called during the drag operation. Your postprocess-drag callback deallocates any resources that were allocated by your other drag-processing callbacks. Your postprocess-drag callback is called immediately before the drag reference is deallocated by the data browser so your application should not assume the drag reference exists after your callback completes.

To provide a pointer to your postprocess-drag callback, you create a universal procedure pointer (UPP) of type DataBrowserPostProcessDragUPP, using the function NewDataBrowserPostProcessDragUPP. You can do so with code similar to the following: DataBrowserPostProcessDragUPP MyDataBrowserPostProcessDragUPP;
MyDataBrowserPostProcessDragUPP = NewDataBrowserPostProcessDragUPP
                        (&MyDataBrowserPostProcessDragCallback);


You can then assign MyDataBrowserPostProcessDragUPP to the postProcessDragCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserPostProcessDragUPP function.*/
typedef void (*DataBrowserPostProcessDragProcPtr) (
   ControlRef browser,
   DragRef theDrag,
   OSStatus trackDragResult
);

/*DataBrowserSelectContextualMenuProcPtr

Defines a pointer to a select-contextual-menu callback function that processes a contextual menu selection.

typedef void (*DataBrowserSelectContextualMenuProcPtr) (
   ControlRef browser,
   MenuRef menu,
   UInt32 selectionType,
   SInt16 menuID,
   MenuItemIndex menuItem
);

You would declare a select-contextual-menu callback function named MyDataBrowserSelectContextualMenuCallback like this:

void MyDataBrowserSelectContextualMenuCallback (
   ControlRef browser,
   MenuRef menu,
   UInt32 selectionType,
   SInt16 menuID,
   MenuItemIndex menuItem
);
Parameters
browser

A data browser.
menu

On input, the menu reference your application provided to the data browser in the callback DataBrowserGetContextualMenuProcPtr. 
selectionType

On input, the selection type provided to the data browser from the Menu Manager function ContextualMenuSelect.
menuID

On input, the menu ID of the menu selected. This value is 0 if no selection was made.
menuItem

The menu item index of the item selected.
Discussion

The select-contextual-menu callback is called by the data browser when the user finishes interacting with a contextual menu. Your callback needs to:
Check whether the user chose an item from the menu. If so, process the selection appropriately. Note that your callback is invoked even if the user does not choose an item from the menu.
Optionally dispose of the menu you allocated in your get-contextual-menu callback, and that is passed to your select-contextual-menu callback in the menu parameter.

To provide a pointer to your select-contextual-menu callback, you create a universal procedure pointer (UPP) of type DataBrowserSelectContextualMenuUPP, using the function NewDataBrowserSelectContextualMenuUPP. You can do so with code similar to the following: DataBrowserSelectContextualMenuUPP MyDataBrowserSelectContextualMenuUPP;
MyDataBrowserSelectContextualMenuUPP =
                 NewDataBrowserSelectContextualMenuUPP
                (&MyDataBrowserSelectContextualMenuCallback);


You can then assign MyDataBrowserSelectContextualMenuUPP to the selectContextualMenuCallback field of the structure DataBrowserCallbacks. You install your data browser callbacks using the function SetDataBrowserCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserSelectContextualMenuUPP function.*/
typedef void (*DataBrowserSelectContextualMenuProcPtr) (
   ControlRef browser,
   MenuRef menu,
   UInt32 selectionType,
   SInt16 menuID,
   MenuItemIndex menuItem
);

/*DataBrowserEditItemProcPtr

Defines a pointer to an edit-item callback function that determines if the data browser should start an edit session for a custom item. 

Not Recommended

typedef Boolean (*DataBrowserEditItemProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   CFStringRef theString,
   Rect *maxEditTextRect,
   Boolean *shrinkToFit
);

You would declare an edit-item callback function named MyDataBrowserEditItemCallback like this:

Boolean MyDataBrowserEditItemCallback (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   CFStringRef theString,
   Rect *maxEditTextRect,
   Boolean *shrinkToFit
);
Parameters
browser

A data browser. 
item

The item ID number for the item.
property

The property ID for the item. In list view, this is the four-character sequence that you previously assigned to the column. In column view, this is the property kDataBrowserItemSelfIdentityProperty.
theString

The string to be edited. See Special Considerations for more information.
maxEditTextRect

On input, a pointer to a rectangle structure. On return, set the rectangle to the largest size the edit field can grow to. If the text grows beyond the size of the edit field, the text scrolls as the user types. This parameter is used only if the parameter shrinkToFit is true. Otherwise, the current size of the text editing field is used. 
shrinkToFit

On input, a pointer to a Boolean variable. On return, set this variable to true if you want the data browser to expand or shrink the text editing field to match the width of the text in the edit field. Note that this parameter is currently ignored; shrinkToFit is always true by default.
Return Value

A value that indicates whether or not you want to start an edit operation for the given property of the item. If your application performs the editing operation, your callback returns true. Otherwise, your callback returns false.
Discussion

The edit-item callback is called by the data browser for an item whose property is kDataBrowserCustomType. Your callback must determine whether an editing session should be started and, if so, set the string to be edited, set the size of the edit rectangle, and specify whether the text editing field can adjust to match the width of the text in the edit field.

To provide a pointer to your edit-item callback, you create a universal procedure pointer (UPP) of type DataBrowserEditItemUPP, using the function NewDataBrowserEditItemUPP. You can do so with code similar to the following: DataBrowserEditItemUPP MyDataBrowserEditItemUPP;
MyDataBrowserEditItemUPP = NewDataBrowserEditItemUPP
                        (&MyDataBrowserEditItemCallback);


You can then assign MyDataBrowserEditItemUPP to the editItemCallback field of the structure DataBrowserCustomCallbacks. You install your data browser custom callbacks using the function SetDataBrowserCustomCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserEditItemUPP function.
Special Considerations

This callback does not work properly. The theString parameter is an immutable sting, which means it is not possible for the callback to set the string to the text that is to be edited.*/
typedef Boolean (*DataBrowserEditItemProcPtr) (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserPropertyID property,
   CFStringRef theString,
   Rect *maxEditTextRect,
   Boolean *shrinkToFit
);

/*DataBrowserHitTestProcPtr

Defines a pointer to a hit-test callback function that determines if the pointer is over content that can be selected or dragged.

typedef Boolean (*DataBrowserHitTestProcPtr) (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   const Rect *mouseRect
);

You would declare a hit-test callback function named MyDataBrowserHitTestCallback like this:

Boolean MyDataBrowserHitTestCallback (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   const Rect *mouseRect
);
Parameters
browser

A data browser. 
itemID

The item ID number for the item over which the pointer is located.
property

The property ID for the column in which the pointer is located. In list view, this is the four-character sequence that you previously assigned to the column. In column view, this is the property kDataBrowserItemSelfIdentityProperty.
theRect

A pointer to the bounding rectangle, in local coordinates, of the item. 
mouseRect

A pointer to a rectangle structure that contains the local coordinates of the selection. If the top-left and bottom-right coordinates of this rectangle are identical, then a single point is being tested. If they differ, then the data browser is testing to see whether your custom item is inside of the bounding rectangle of a selection.
Return Value

Your application returns a true value for either of the following conditions: 
The pointer is located over the part of the item that can be selected or dragged.
The rectangle provided in the parameter mouseRect intersects with the content area of the item that can be selected or dragged.
Discussion

The hit-test callback is called by the data browser when the user hovers the pointer over, clicks the mouse within, or drags within an item whose display type is kDataBrowserCustomType. Your callback can use the functions SetRect or SectRgn to determine if the selectable content of the custom item is part of the selection. Figure 2 illustrates a situation for which the selectable or draggable content area differs from the background area in which the item is displayed.


Figure 2  Differentiation between the selectable content and background



To provide a pointer to your hit-test callback, you create a universal procedure pointer (UPP) of type DataBrowserHitTestItemUPP, using the function NewDataBrowserHitTestUPP. You can do so with code similar to the following: DataBrowserHitTestUPP MyDataBrowserHitTestUPP;
MyDataBrowserHitTestUPP = NewDataBrowserHitTestUPP
                        (&MyDataBrowserHitTestCallback);


You can then assign MyDataBrowserHitTestUPP to the hitTestCallback field of the structure DataBrowserCustomCallbacks. You install your data browser custom callbacks using the function SetDataBrowserCustomCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserHitTestUPP function.*/
typedef Boolean (*DataBrowserHitTestProcPtr) (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   const Rect *mouseRect
);

/*Tracking Results

Specify the outcome of tracking a drag operation.

typedef SInt16 DataBrowserTrackingResult;
enum {
   kDataBrowserContentHit = 1,
   kDataBrowserNothingHit = 0,
   kDataBrowserStopTracking = -1
};
Constants
kDataBrowserContentHit

Indicates that a selectable portion of the item was hit. The data browser will select the item and do other relevant actions as appropriate.

Available in Mac OS X v10.0 and later.
kDataBrowserNothingHit

Indicates that a nonselectable portion—whitespace—was hit. The data browser won’t select the item, but it could, for example, start a selection rectangle.

Available in Mac OS X v10.0 and later.
kDataBrowserStopTracking

Indicates the callback handled the click completely. The data browser will not attempt to display a contextual menu, start a drag, process a double-click, or draw a selection rectangle. The callback is responsible for all facets of click handling if it returns this value.

Available in Mac OS X v10.0 and later.
Discussion

These constants are returned from the custom tracking callback, DataBrowserTrackingProcPtr.*/
typedef SInt16 DataBrowserTrackingResult;
enum {
   kDataBrowserContentHit = 1,
   kDataBrowserNothingHit = 0,
   kDataBrowserStopTracking = -1
};

/*DataBrowserTrackingProcPtr

Defines a pointer to a tracking callback function that implements tracking behavior for such tasks as highlighting a button or providing animation when the user clicks a custom item. 

typedef DataBrowserTrackingResult (*DataBrowserTrackingProcPtr)  (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   Point startPt,
   EventModifiers modifiers
);

You would declare a tracking callback function named MyDataBrowserTrackingCallback like this:

DataBrowserTrackingResult MyDataBrowserTrackingCallback (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   Point startPt,
   EventModifiers modifiers
);
Parameters
browser

A data browser. 
itemID

The item ID number for the item the user clicked.
property

The property ID for the column in which the pointer is located. In list view, this is the four-character sequence that you previously assigned to the column. In column view, this is the property kDataBrowserItemSelfIdentityProperty.
theRect

A pointer to the bounding rectangle of the item, in local coordinates relative to the current port.
startPt

The location of the pointer at the start of the click.
modifiers

The state of the modifier keys. See Event Manager Reference in Carbon Events & Other Input Documentation for a list of the constants that can be passed to your callback.
Return Value

A tracking result that indicates whether further processing is required by the data browser. Your callback returns kDataBrowserStopTracking, kDataBrowserContentHit, or kDataBrowserNothingHit. See the Discussion for more details.
Discussion

The tracking callback is called by the data browser for an item whose display type is kDataBrowserCustomType when a mouse click is inside the content area of the item. Your tracking callback is called only for mouse-down events and only after your DataBrowserHitTestProcPtr callback returns true. Your tracking callback performs one of following tasks:
Provides its own custom tracking behavior and animation and returns the result kDataBrowserStopTracking. This result informs the data browser that your application handled the click and no further processing is required. The data browser does not attempt to display a contextual menu, start a drag operation, process a double-click, or draw a selection rectangle. You are responsible for all facets of click handling if you return kDataBrowserStopTracking.
Returns the value kDataBrowserNothingHit to indicate a negative hit and no further processing needs to take place. This result indicates that a nonselectable portion—whitespace—was hit. The data browser won’t select the item, but it could, for example, start a selection rectangle.
Returns the value kDataBrowserContentHit to request that the data browser continues to process the click. This result indicates that a selectable portion of the item is hit. The data browser selects the item and takes other appropriate actions.

To provide a pointer to your tracking callback, you create a universal procedure pointer (UPP) of type DataBrowserTrackingUPP, using the function NewDataBrowserTrackingUPP. You can do so with code similar to the following: DataBrowserTrackingUPP MyDataBrowserTrackingUPP;
MyDataBrowserTrackingUPP = NewDataBrowserTrackingUPP
                        (&MyDataBrowserTrackingCallback);


You can then assign MyDataBrowserTrackingUPP to the trackingCallback field of the structure DataBrowserCustomCallbacks. You install your data browser custom callbacks using the function SetDataBrowserCustomCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserTrackingUPP function.*/
typedef DataBrowserTrackingResult (*DataBrowserTrackingProcPtr)  (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   Point startPt,
   EventModifiers modifiers
);

/*DataBrowserItemDragRgnProcPtr

Defines a pointer to an item-drag-region callback function that determines which part of the item rectangle to use when creating a transparent image for a dragged custom item.

typedef void (*DataBrowserItemDragRgnProcPtr) (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   RgnHandle dragRgn
);

You would declare an item-drag-region callback function named MyDataBrowserItemDragRgnCallback like this:

void MyDataBrowserItemDragRgnCallback (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   RgnHandle dragRgn
);
Parameters
browser

A data browser. 
itemID

The item ID number for the row for which the drag image is generated.
property

The property ID for the column for which the drag image is generated. In list view, this is the four-character sequence that you previously assigned to the column. In column view, this is the property kDataBrowserItemSelfIdentityProperty.
theRect

A pointer to the bounding rectangle of the item, in local coordinates. 
dragRgn

On return, the drag region set to the portion of the rectangle to use for the transparent drag image. Typically this is the boundary of the content area inside your custom item. This region is used as a mask when passed to your custom draw-item callback.
Discussion

The item-drag-region callback is called by the data browser for an item whose display type is kDataBrowserCustomType when a drag is about to begin. Your application determines which part of the item rectangle to use when creating the transparent image that appears during a drag operation. The data browser uses this area as a clipping region when it invokes your draw-item callback. 

Do not call the function SetOrigin in this or any of the other drag processing callbacks.

To provide a pointer to your item-drag-region callback, you create a universal procedure pointer (UPP) of type DataBrowserItemDragRgnUPP, using the function NewDataBrowserItemDragRgnUPP. You can do so with code similar to the following: DataBrowserItemDragRgnUPP MyDataBrowserItemDragRgnUPP;
MyDataBrowserItemDragRgnUPP = NewDataBrowserItemDragRgnUPP
                        (&MyDataBrowserItemDragRgnCallback);


You can then assign MyDataBrowserItemDragRgnUPP to the itemDragRgnCallback field of the structure DataBrowserCustomCallbacks. You install your data browser custom callbacks using the function SetDataBrowserCustomCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserItemDragRgnUPP function.*/
typedef void (*DataBrowserItemDragRgnProcPtr) (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   RgnHandle dragRgn
);

/*DataBrowserItemAcceptDragProcPtr

Defines a pointer to an item-accept-drag callback function that determines if a custom item can accept a drag object. 

typedef DataBrowserDragFlags (*DataBrowserItemAcceptDragProcPtr)  (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   DragRef theDrag
);

You would declare an item-accept-drag callback function named MyDataBrowserItemAcceptDragCallback like this:

DataBrowserDragFlags MyDataBrowserItemAcceptDragCallback (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   DragRef theDrag
);
Parameters
browser

A data browser. 
itemID

The item ID number for the item the drag object is held over. If the drag object is over the data browser but not over any specific item, the item parameter contains the item ID that represents one of the following:
The target in list view. (See SetDataBrowserTarget.)
The column the drag object is over in column view
property

The property ID of the column the dragged object is over. In list view, this is the four-character sequence that you previously assigned to the column. In column view, this is the property kDataBrowserItemSelfIdentityProperty.
theRect

A pointer to the bounding rectangle of the item, in local coordinates relative to the current port. 
theDrag

The drag reference provided by the data browser to your callback.
Return Value

If your callback determines the drag object can be accepted, return a nonzero value that has the bit kDataBrowserItemIsDragTarget set. Otherwise return kDataBrowserItemNoState. The return value is then passed to your item-receive-drag callback in the dragFlags parameter. 
Discussion

The item-accept-drag callback is called by the data browser for an item whose display type is kDataBrowserCustomType when a drag object is moved over the item. Your application determines whether or not the associated item can accept the drag object. If the item cannot accept the drag object, return 0. Otherwise, if the item is an acceptable drop location for the drag object, return a nonzero value. 

If the drag object was acceptable and the drop occurs over that same item ID and property ID pair, the DataBrowserDragFlags values you returned from your item-accept-drag callback are passed in the dragFlags parameter to your item-receive-drag callback. This allows you to generate state information during drag tracking that can be communicated to you at drop time.

Do not call the function SetOrigin in this or any of the other drag processing callbacks.

To provide a pointer to your item-accept-drag callback, you create a universal procedure pointer (UPP) of type DataBrowserItemAcceptDragUPP, using the function NewDataBrowserItemAcceptDragUPP. You can do so with code similar to the following: DataBrowserItemAcceptDragUPP MyDataBrowserItemAcceptDragUPP;
MyDataBrowserItemAcceptDragUPP = NewDataBrowserItemAcceptDragUPP
                        (&MyDataBrowserItemAcceptDragCallback);


You can then assign MyDataBrowserItemAcceptDragUPP to the itemAcceptDragCallback field of the structure DataBrowserCustomCallbacks. You install your data browser custom callbacks using the function SetDataBrowserCustomCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserItemAcceptDragUPP function.*/
typedef DataBrowserDragFlags (*DataBrowserItemAcceptDragProcPtr)  (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   const Rect *theRect,
   DragRef theDrag
);

/*DataBrowserItemReceiveDragProcPtr

Defines a pointer to an item-receive-drag callback function that receives a drop over a custom item.

typedef Boolean (*DataBrowserItemReceiveDragProcPtr) (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   DataBrowserDragFlags dragFlags,
   DragRef theDrag
);

You would declare an item-receive-drag callback function named MyDataBrowserItemReceiveDragCallback like this:

Boolean MyDataBrowserItemReceiveDragCallback (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   DataBrowserDragFlags dragFlags,
   DragRef theDrag
);
Parameters
browser

A data browser. 
itemID

The item ID number for the item over which the drop occurred.
property

The property ID for the column in which the drop occurred. In list view, this is the four-character sequence that you previously assigned to the column. In column view, this is the property kDataBrowserItemSelfIdentityProperty.
dragFlags

A drag flag. This value is kDataBrowserItemIsDragTarget if your item-accept-drag callback determined the drag object can be accepted.
theDrag

The drag reference provided by the data browser to your callback.
Return Value

A value that indicates whether the drop is received. Your callback returns true if it successfully receives the drag object. If it returns false, zoom-back animation occurs.
Discussion

After your item-accept-drag callback has determined that a location can accept a drag object and after a drop operation occurs, the data browser calls your item-receive-drag callback. Your application takes whatever actions necessary to add the dropped data to the data browser. 

Do not call the function SetOrigin in this or any of the drag processing callbacks.

To provide a pointer to your item-receive-drag callback, you create a universal procedure pointer (UPP) of type DataBrowserItemReceiveDragUPP, using the function NewDataBrowserItemReceiveDragUPP. You can do so with code similar to the following: DataBrowserItemReceiveDragUPP MyDataBrowserItemReceiveDragUPP;
MyDataBrowserItemReceiveDragUPP = NewDataBrowserItemReceiveDragUPP
                        (&MyDataBrowserItemReceiveDragCallback);


You can then assign MyDataBrowserItemReceiveDragUPP to the itemReceiveDragCallback field of the structure DataBrowserCustomCallbacks. You install your data browser custom callbacks using the function SetDataBrowserCustomCallbacks.

When you no longer need the UPP, remove it using the DisposeDataBrowserItemReceiveDragUPP function.*/
typedef Boolean (*DataBrowserItemReceiveDragProcPtr) (
   ControlRef browser,
   DataBrowserItemID itemID,
   DataBrowserPropertyID property,
   DataBrowserDragFlags dragFlags,
   DragRef theDrag
);

#include <APPLE/HIToolbox/ControlDefinitions_E.h>

/*DataBrowserCallbacks

Contains universal procedure pointers (UPPs) to callback functions used to obtain information from your application or notify your application of changes to the data browser.

struct DataBrowserCallbacks {
   UInt32 version
   union {
      struct {
         DataBrowserItemDataUPP itemDataCallback;
         DataBrowserItemCompareUPP itemCompareCallback;
         DataBrowserItemNotificationUPP itemNotificationCallback;
         DataBrowserAddDragItemUPP addDragItemCallback;
         DataBrowserAcceptDragUPP acceptDragCallback;
         DataBrowserReceiveDragUPP receiveDragCallback;
         DataBrowserPostProcessDragUPP postProcessDragCallback;
         DataBrowserItemHelpContentUPP itemHelpContentCallback;
         DataBrowserGetContextualMenuUPP getContextualMenuCallback;
         DataBrowserSelectContextualMenuUPP selectContextualMenuCallback;
      } v1;
   } u;
};
typedef struct DataBrowserCallbacks DataBrowserCallbacks;
Fields
version

The version of the custom callbacks structure. Set this field to the constant kDataBrowserLatestCallbacks.
u.v1.itemDataCallback

A universal procedure pointer to an item-data callback.
u.v1.itemCompareCallback

A universal procedure pointer to an item-compare callback.
u.v1.itemNotificationCallback

A universal procedure pointer to an item-notification callback or item-notification-with-data callback.
u.v1.addDragItemCallback

A universal procedure pointer to an add-drag-item callback.
u.v1.acceptDragCallback

A universal procedure pointer to an accept-drag callback.
u.v1.receiveDragCallback

A universal procedure pointer to a receive-drag callback.
u.v1.postProcessDragCallback

A universal procedure pointer to a postprocess-drag callback.
u.v1.itemHelpContentCallback

A universal procedure pointer to an item-help-content callback.
u.v1.getContextualMenuCallback

A universal procedure pointer to a get-contextual-menu callback.
u.v1.selectContextualMenuCallback

A universal procedure pointer to a select-contextual-menu callback.
Discussion

Your application does not need to fill out the entire data structure. It must provide a UPP to an item-data callback. You provide UPPs only for the other tasks your application wants to handle. For more information on installing callbacks, see the functions InitDataBrowserCallbacks and SetDataBrowserCallbacks. 
Availability
Available in Mac OS X v10.0 and later.*/

struct DataBrowserCallbacks {
   UInt32 version;
   union {
      struct {
         DataBrowserItemDataUPP itemDataCallback;
         DataBrowserItemCompareUPP itemCompareCallback;
         DataBrowserItemNotificationUPP itemNotificationCallback;
         DataBrowserAddDragItemUPP addDragItemCallback;
         DataBrowserAcceptDragUPP acceptDragCallback;
         DataBrowserReceiveDragUPP receiveDragCallback;
         DataBrowserPostProcessDragUPP postProcessDragCallback;
         DataBrowserItemHelpContentUPP itemHelpContentCallback;
         DataBrowserGetContextualMenuUPP getContextualMenuCallback;
         DataBrowserSelectContextualMenuUPP selectContextualMenuCallback;
      } v1;
   } u;
};
typedef struct DataBrowserCallbacks DataBrowserCallbacks;


/*DataBrowserCustomCallbacks

Contains universal procedure pointers (UPPs) to callback functions that implement custom drawing and user interaction for columns that have the display type kDataBrowserCustomType.

struct DataBrowserCustomCallbacks {
   UInt32 version
   union {
      struct {
         DataBrowserDrawItemUPP drawItemCallback;
         DataBrowserEditItemUPP editTextCallback;
         DataBrowserHitTestUPP hitTestCallback;
         DataBrowserTrackingUPP trackingCallback;
         DataBrowserItemDragRgnUPP dragRegionCallback;
         DataBrowserItemAcceptDragUPP acceptDragCallback;
         DataBrowserItemReceiveDragUPP receiveDragCallback;
      } v1;
   } u;
};
typedef struct DataBrowserCustomCallbacks DataBrowserCustomCallbacks;
Fields
version

The version of the custom callbacks structure. Use kDataBrowserLatestCustomCallbacks.
u.v1.drawItemCallback

A universal procedure pointer to a draw-item callback.
u.v1.editTextCallback

A universal procedure pointer to an edit-text callback.
u.v1.hitTestCallback

A universal procedure pointer to a hit-test callback
u.v1.trackingCallback

A universal procedure pointer to a tracking callback.
u.v1.dragRegionCallback

A universal procedure pointer to an item-drag-region callback.
u.v1.acceptDragCallback

A universal procedure pointer to an item-accept-drag callback.
u.v1.receiveDragCallback

A universal procedure pointer to an item-receive-drag callback.
Discussion

Your application can use the DataBrowserCustomCallbacks structure to provide callbacks that control the presentation of user interface elements displayed inside a data browser. Your application does not need to fill out the entire data structure. You need to provide UPPs only for tasks your application wants to handle. For more information on installing callbacks, see the functions InitDataBrowserCustomCallbacks and SetDataBrowserCustomCallbacks.
Availability
Available in Mac OS X v10.0 and later.*/

struct DataBrowserCustomCallbacks {
   UInt32 version;
   union {
      struct {
         DataBrowserDrawItemUPP drawItemCallback;
         DataBrowserEditItemUPP editTextCallback;
         DataBrowserHitTestUPP hitTestCallback;
         DataBrowserTrackingUPP trackingCallback;
         DataBrowserItemDragRgnUPP dragRegionCallback;
         DataBrowserItemAcceptDragUPP acceptDragCallback;
         DataBrowserItemReceiveDragUPP receiveDragCallback;
      } v1;
   } u;
};
typedef struct DataBrowserCustomCallbacks DataBrowserCustomCallbacks;

/*Property Flags: Universal

Modify the appearance or behavior of display properties.

enum {
   kDataBrowserUniversalPropertyFlagsMask = 0xFF,
   kDataBrowserPropertyIsMutable = 1 << 0,
   kDataBrowserDefaultPropertyFlags = 0 << 0,
   kDataBrowserUniversalPropertyFlags =  kDataBrowserUniversalPropertyFlagsMask,
   kDataBrowserPropertyIsEditable = kDataBrowserPropertyIsMutable
};

Constants
kDataBrowserUniversalPropertyFlagsMask

Test for universal property flags. This constant is used by the data browser; your application doesn’t need to use it.

Available in Mac OS X v10.0 and later.
kDataBrowserPropertyIsMutable

The property is mutable. You can assign this flag to the propertyFlags field of the DataBrowserPropertyDesc structure. You must set this flag is you want to allow editing of the text part of the property.

Available in Mac OS X v10.0 and later.
kDataBrowserDefaultPropertyFlags

The default properties. You can assign this flag to the propertyFlags field of the DataBrowserPropertyDesc structure if all you need is the default behavior. The default is for all flags to be off.

Available in Mac OS X v10.0 and later.
kDataBrowserUniversalPropertyFlags

Universal property flags. This constant is used by the data browser; your application doesn’t need to use it.

Available in Mac OS X v10.0 and later.
kDataBrowserPropertyIsEditable

The data can be edited. You must set this flag if you want to allow editing of the text part of the property. This flag can be set if the values displayed in the column can be changed. If your application specifies this flag, then it must also provide a callback that allows the data browser to retrieve and store data values displayed in this column. You can assign this flag to the propertyFlags field of the DataBrowserPropertyDesc structure.

Available in Mac OS X v10.0 and later.
Discussion

These constants reside in bits 0–7 of the DataBrowserPropertyFlags data type.*/
enum {
   kDataBrowserUniversalPropertyFlagsMask = 0xFF,
   kDataBrowserPropertyIsMutable = 1 << 0,
   kDataBrowserDefaultPropertyFlags = 0 << 0,
   kDataBrowserUniversalPropertyFlags =  kDataBrowserUniversalPropertyFlagsMask,
   kDataBrowserPropertyIsEditable = kDataBrowserPropertyIsMutable
};

/*Control Pop-up Button Check Current Tag Constant

enum {
   kControlPopupButtonCheckCurrentTag = 'chck'
};*/
enum {
   kControlPopupButtonCheckCurrentTag = 'chck'
};

//function


/*CreateTabsControl

Creates a tabs control.

OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
size

The control tab size. See Control Tab Size Constants for possible values.
direction

The control tab direction. See Control Tab Direction Constants for possible values.
numTabs

The initial number of tabs.
tabArray

Information about each tab. There must be the same number of entries as specified by the numTabs parameter.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

If you want to customize the accessibility information provided for individual tabs of a tabs control, such as by handling various kEventClassAccessibility Carbon Events and by calling HIObjectSetAuxiliaryAccessibilityAttribute, you need to know how to build or interpret AXUIElement reference that represent individual tabs. The AXUIElement representing an individual tab must be constructed using the tab control’s ControlRef and the UInt64 identifier of the one-based index of the tab to which the element refers. A UInt64 identifier of 0 represents the tabs control as a whole. You cannot interpret or create tab control elements whose identifiers are greater than the count of tabs in the tabs control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateTabsControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlTabSize size,
   ControlTabDirection direction,
   UInt16 numTabs,
   const ControlTabEntry * tabArray,
   ControlRef * outControl
);

/*CreateUserPaneControl

Creates a user pane control.

OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
features

The user pane features with which the user pane is to be created. For possible constants, see “Control Features Constants”. 
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

User panes have two primary purposes: to allow easy implementation of a custom control by the developer, and to provide a generic container for embedding other controls.

In Carbon, with the advent of Carbon-event-based controls, you may find it easier to write a new control from scratch than to customize a user pane control. The set of callbacks provided by the user pane will not be extended to support new Control Manager features; instead, you should just write a real control.User panes do not, by default, support embedding. If you try to embed a control into a user pane, you will get the errControlIsNotEmbedder. You can make a user pane support embedding by passing the kControlSupportsEmbedding flag in the features parameter when you create the control.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateUserPaneControl (
   WindowRef window,
   const Rect * boundsRect,
   UInt32 features,
   ControlRef * outControl
);

/*CreateStaticTextControl

Creates a new static text control.

OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateStaticTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);

/*CreatePushButtonControl

Creates a push button control.

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The control title. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreatePushButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlRef * outControl
);

/*CreateLittleArrowsControl

Creates a little arrows control.

OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value the control can have.
maximum

The maximum value the control can have.
increment

The amount to increment each time an arrow is clicked.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements the little up and down arrows seen in the Date & Time system preferences panel. To change the value of this control, you need to create a control action proc. The following sample code creates the control and sets the action proc:CreateLittleArrowsControl(&rect, minimum, maximum, increment,  value);
SetControlAction(Arrows, LittleArrowActionProc);


Here is sample code for the action proc:void LittleArrowActionProc(ControlRef cref, ControlPartCode part)  {
    SInt32 val = GetControl32BitValue(cref);
    SInt32 s = 0;
    GetControlData(MWArrows, 0, kControlLittleArrowsIncrementValueTag,  sizeof(SInt32), &s, nil;
    switch (part) {
        case kControlUpButtonPart:
            SetControl32BitValue(cref, val+s);
            break;
        case kControlDownButtonPart:
            SetControl32BitValue(cref, val-s);
            break;
        };
    };

Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateLittleArrowsControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 increment,
   ControlRef * outControl
);

/*SetDataBrowserCallbacks

Sets the callback routines to use with a data browser, replacing any previously installed callbacks.

OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks
);
Parameters
browser

A data browser.
callbacks

A pointer to a DataBrowserCallbacks structure that is filled out with universal procedure pointers (UPPs) to the callback routines your application provides. At a minimum, you need to provide a UPP to an item-data callback (DataBrowserItemDataProcPtr).
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling the function SetDataBrowserCallbacks you must first call InitDataBrowserCallbacks to initialize the data browser callback structure. Calling SetDataBrowserCallbacks replaces any callback routines you installed previously by calling this function.

You can supply the following callbacks. If you don’t supply callbacks in cases for which it’s optional, you get the default behavior provided by the data browser API.
DataBrowserItemDataProcPtr. You must provide this callback because communicates the text, icons, or other data to display in list view. It also communicates the metadata that defines how data is displayed, such as whether or not an item is a container or has a parent. If you set up your data browser to allow the user to edit, this callback informs your application when the user makes a change.
DataBrowserItemCompareProcPtr. You must provide a sorting callback if you want users to be able to sort the items in a column. If you want containers in a hierarchical list to be sorted independently, then you must provide a sorting callback that handles the hierarchical lists appropriately.
DataBrowserItemNotificationProcPtr. You must provide this (or the next) callback if you have hierarchical data in a list, or if you use column view.
DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr. You can provide this callback to allow dragging out of your data browser. 
DataBrowserAcceptDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to accept a drag item.
DataBrowserReceiveDragProcPtr. You can provide this callback to allow dragging into your data browser; use this to receive a drag item.
DataBrowserPostProcessDragProcPtr. If you provide callbacks to allow dragging into your data browser, you can optionally provide a postprocess-drag callback to perform cleanup tasks.
DataBrowserGetContextualMenuProcPtr. You can optionally support a contextual menu. If so, you’ll need to provide the next callback too.
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr. You can optionally provide help tags.

Note that this function sets a different set of callbacks from those that are set by calling the function SetDataBrowserCustomCallbacks.

To replace a callback, you first need to get the current set of callbacks by calling the function GetDataBrowserCallbacks. Set the appropriate fields in the DataBrowserCallbacks structure to your callback. Then you call the function SetDataBrowserCallbacks. Your application can set as many callbacks as appropriate. 

The following code shows how to assign UPPs to the callbacks structure and then call the function SetDataBrowserCallbacks. The code assumes you have already called the function InitDataBrowserCallbacks to initialize the data browser callback structure.myCallbacks.u.v1.itemNotificationCallback =
        NewDataBrowserItemNotificationUPP (MyItemNotificationCallback);
 
myCallbacks.u.v1.acceptDragCallback =
        NewDataBrowserAcceptDragUPP (MyAcceptDragCallback);
myCallbacks.u.v1.receiveDragCallback =
        NewDataBrowserReceiveDragUPP (MyReceiveDragCallback);
myCallbacks.u.v1.addDragItemCallback =
        NewDataBrowserAddDragItemUPP (MyAddDragItemCallback);
myCallbacks.u.v1.itemHelpContentCallback =
        NewDataBrowserItemHelpContentUPP (MyItemHelpContentCallback);
myCallbacks.u.v1.getContextualMenuCallback =
        NewDataBrowserGetContextualMenuUPP (MyGetContextualMenuCallback);
myCallbacks.u.v1.selectContextualMenuCallback =
        NewDataBrowserSelectContextualMenuUPP (
                    MySelectContextualMenuCallback);
SetDataBrowserCallbacks (browser, &myCallbacks);

Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserCallbacks (
   ControlRef browser,
   const DataBrowserCallbacks *callbacks
);

/*NewDataBrowserItemDataUPP

Creates a universal procedure pointer to an item-data callback function.

DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-data callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemDataProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemDataUPP NewDataBrowserItemDataUPP (
   DataBrowserItemDataProcPtr userRoutine
);

/*InitDataBrowserCallbacks

Initializes a data browser callback structure in preparation for adding your own callbacks to the structure.

OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks
);
Parameters
callbacks

A pointer to a DataBrowserCallbacks structure. Before calling the function InitDataBrowserCallbacks, set the version field of this structure to kDataBrowserLatestCallbacks. On return, the fields in this structure are set to NULL.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

After you call this function, set the appropriate fields in the DataBrowserCallbacks structure to your callbacks. The DataBrowserCallbacks structure contains fields for the following:
DataBrowserItemDataProcPtr
DataBrowserItemCompareProcPtr
DataBrowserItemNotificationProcPtr or DataBrowserItemNotificationWithItemProcPtr (Mac OS X only)
DataBrowserAddDragItemProcPtr
DataBrowserAcceptDragProcPtr
DataBrowserReceiveDragProcPtr
DataBrowserPostProcessDragProcPtr
DataBrowserGetContextualMenuProcPtr
DataBrowserSelectContextualMenuProcPtr
DataBrowserItemHelpContentProcPtr

After you assign your callbacks to the appropriate field, call the function SetDataBrowserCallbacks.

Note that this is a different set of callbacks from those that are assigned to fields in the DataBrowserCustomCallbacks data structure.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus InitDataBrowserCallbacks (
   DataBrowserCallbacks *callbacks
);

/*IsDataBrowserItemSelected

Checks to see if a data item is selected.

Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item
);
Parameters
browser

A data browser.
item

The item ID of the item to check.
Return Value

A value of true if the item is a member of the current selection. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
Boolean IsDataBrowserItemSelected (
   ControlRef browser,
   DataBrowserItemID item
);

/*SetDataBrowserItemDataText

Specifies the text to draw.

OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData
);
Parameters
itemData

The item data reference for the item whose text you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataText. 
theData

The CFString object that contains the text you want to draw. You are responsible for releasing the CFString object.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

You call the function SetDataBrowserItemDataText from inside a data callback routine when the item being drawn is inside a column that has the kDataBrowserTextType display type or the kDataBrowserIconAndTextType display type. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataText (
   DataBrowserItemDataRef itemData,
   CFStringRef theData
);

/*AddDataBrowserItems

Adds one or more items to a data browser. 

OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container to which you want to add items. Adding one or more items to an existing container opens the container. If you a pass kDataBrowserNoItem, the items are added to the root container.
numItems

The number of items in the array pointed to by the items parameter.
items

A pointer to an array of item ID values for the items you want to add to the data browser. You supply item ID values based on your own identification scheme. If you pass NULL, each time you call AddDataBrowserItems the data browser generates item ID values starting at 1. Calling the function in this way clears whatever items are in the container. Because of this clearing behavior, passing NULL is not recommended unless your application uses a data browser to display a simple list that is populated only once with data.
preSortProperty

The property ID of the column whose sorting order matches the sorting order of the items array. A property ID is a four-character sequence that you assign to represent a column in list view. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order of your data. You’ll get the best performance from this function if you provide a sorting order. 
Return Value

A result code. If the item ID specified by the container parameter is not classified as a container, returns errDataBrowserItemNotAdded if you attempt to add subitems to it. See “Data Browser Result Codes”.
Discussion

Hierarchical lists are constructed in a top-down fashion. Your application must install all the top-level, or parent, item IDs in the data browser before it associates a list of item ID values as subitems. You can add items to a parent item only after the parent item is classified as a container. A container is an item for which the property kDataBrowserItemIsContainerProperty is set to true. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus AddDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);

/*RemoveDataBrowserItems

Removes one or more items from a data browser.

OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. Pass the item ID that uniquely identifies the container from which you want to remove items. Pass kDataBrowserNoItem to remove items from the root container.
numItems

The number of items in the array pointed to by the items parameter. To remove all items pass 0 and also pass NULL in the items parameter.
items

A pointer to an array of item ID values for the items you want to remove from the data browser. You can delete an arbitrary list of items from a container. To remove all items, pass NULL, and also pass 0 in the numItems parameter. 
preSortProperty

The property ID of the column whose sorting order is the same as the sorting order of the items array. A property ID is a value that identifies a column independent of its position in a data browser. Pass kDataBrowserItemNoProperty if the items array is not sorted or if you don’t know the sorting order. You’ll get the best performance from this function if you provide a sorting order.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus RemoveDataBrowserItems (
   ControlRef browser,
   DataBrowserItemID container,
   UInt32 numItems,
   const DataBrowserItemID *items,
   DataBrowserPropertyID preSortProperty
);

/*CreateEditUnicodeTextControl

Creates a new edit text control.

OSStatus CreateEditUnicodeTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
isPassword

A Boolean indicating whether the field is to be used as a password field. Passing false indicates that text entered in the field is to be displayed normally. Passing true means that the field is to be used as a password field; any text typed into the field is displayed as bullets.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This function is the preferred way of creating edit text controls. Use it instead of the CreateEditTextControl function. The resulting control handles Unicode text and draws its text using anti-aliasing. Controls created by CreateEditTextControl do not handle Unicode text and are not drawn with anti-aliasing.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateEditUnicodeTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);

/*NewDataBrowserItemNotificationUPP

Creates a universal procedure pointer to an item-notification callback function.

DataBrowserItemNotificationUPP NewDataBrowserItemNotificationUPP  (
   DataBrowserItemNotificationProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-notification callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemNotificationProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemNotificationUPP NewDataBrowserItemNotificationUPP  (
   DataBrowserItemNotificationProcPtr userRoutine
);

/*NewControlUserPaneDrawUPP

ControlUserPaneDrawUPP NewControlUserPaneDrawUPP (
   ControlUserPaneDrawProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneDrawUPP NewControlUserPaneDrawUPP (
   ControlUserPaneDrawProcPtr userRoutine
);

/*NewDataBrowserItemCompareUPP

Creates a universal procedure pointer to an item-comparison callback function.

DataBrowserItemCompareUPP NewDataBrowserItemCompareUPP (
   DataBrowserItemCompareProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-comparison callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemCompareProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

DataBrowserItemCompareUPP NewDataBrowserItemCompareUPP (
   DataBrowserItemCompareProcPtr userRoutine
);


/*NewDataBrowserAcceptDragUPP

Creates a universal procedure pointer to an accept-drag callback function.

DataBrowserAcceptDragUPP NewDataBrowserAcceptDragUPP (
   DataBrowserAcceptDragProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your accept-drag callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserAcceptDragProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserAcceptDragUPP NewDataBrowserAcceptDragUPP (
   DataBrowserAcceptDragProcPtr userRoutine
);



/*NewDataBrowserReceiveDragUPP

Creates a universal procedure pointer to a receive-drag callback function.

DataBrowserReceiveDragUPP NewDataBrowserReceiveDragUPP (
   DataBrowserReceiveDragProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your receive-drag callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserReceiveDragProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserReceiveDragUPP NewDataBrowserReceiveDragUPP (
   DataBrowserReceiveDragProcPtr userRoutine
);

/*NewDataBrowserAddDragItemUPP

Creates a universal procedure pointer to an add-drag-item callback function.

DataBrowserAddDragItemUPP NewDataBrowserAddDragItemUPP (
   DataBrowserAddDragItemProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your add-drag-item callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserAddDragItemProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

DataBrowserAddDragItemUPP NewDataBrowserAddDragItemUPP (
   DataBrowserAddDragItemProcPtr userRoutine
);


/*NewDataBrowserItemHelpContentUPP

Creates a universal procedure pointer to an item-help-content callback function.

DataBrowserItemHelpContentUPP NewDataBrowserItemHelpContentUPP (
   DataBrowserItemHelpContentProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your item-help-content callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserItemHelpContentProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserItemHelpContentUPP NewDataBrowserItemHelpContentUPP (
   DataBrowserItemHelpContentProcPtr userRoutine
);

/*Creates a universal procedure pointer to a get-contextual-menu callback function.

DataBrowserGetContextualMenuUPP NewDataBrowserGetContextualMenuUPP  (
   DataBrowserGetContextualMenuProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your get-contextual-menu callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserGetContextualMenuProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

DataBrowserGetContextualMenuUPP NewDataBrowserGetContextualMenuUPP  (
   DataBrowserGetContextualMenuProcPtr userRoutine
);

/*SetDataBrowserTarget

Sets the target for a data browser.

OSStatus SetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID target
);
Parameters
browser

A data browser. 
target

The item ID to assign as the target for the browser control. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application can set an item ID to use as a target if you do not want to use the default target set by the data browser. By default, the target is a container whose ID is kDataBrowserNoItem. For the list view, the target can be thought of as the root container. For the column view, the target is the rightmost column. When an item is dragged over a data browser but not dropped over any particular item, the target becomes the destination.

SetDataBrowserTarget changes the container that the data browser displays, thereby populating the data browser with items. If you use the function in column view, you must make sure your item-data callback responds to the property kDataBrowserItemParentContainerProperty by providing the item ID of the target’s parent. This allows the function SetDataBrowserColumnViewPath to process the data properly. The target is the leaf node item whose contents you want to display. However, unlike GetDataBrowserColumnViewPathLength, the function SetDataBrowserTarget doesn’t offer a way for you to communicate the item IDs of the rest of the column containers, so SetDataBrowserTarget asks for them explicitly by requesting the item’s parent, then the parent of the item’s parent, and so on.

You can pass a noncontainer item to this function in either list or column views. If you do, you must also respond to the property kDataBrowserItemParentContainerProperty. The data browser requests the parent of the target so it knows which container to display the contents of in the list view. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID target
);

/*GetDataBrowserActiveItems

Obtains what determines the active state of the items in a data browser.

OSStatus GetDataBrowserActiveItems (
   ControlRef browser,
   Boolean *active
);
Parameters
browser

A data browser. 
active

On input, a pointer to a Boolean variable. On return, the variable is set to true if the active state of each item in the list is determined by the item property kDataBrowserItemIsActiveProperty. Otherwise, the variable is set to false to indicate that all items are inactive.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserActiveItems (
   ControlRef browser,
   Boolean *active
);

/*GetDataBrowserHasScrollBars

Obtains the display state of horizontal and vertical scroll bars for a list view data browser.

OSStatus GetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean *horiz,
   Boolean *vert
);
Parameters
browser

A list view data browser. 
horiz

On input, a pointer to a Boolean variable. On return, the variable is set to true if the browser control has a horizontal scroll bar. 
vert

On input, a pointer to a Boolean variable. On return, the variable is set to true if the browser control has a vertical scroll bar.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

The function GetDataBrowserHasScrollBars is useful for determining if the browser control currently has scroll bars. For example, you would call the function AutoSizeDataBrowserListViewColumns only after you have determined the data browser does not have a horizontal scroll bar.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean *horiz,
   Boolean *vert
);

/*GetDataBrowserTableViewGeometry

Determines whether columns and rows are set to have variable widths.

OSStatus GetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean *variableWidthColumns,
   Boolean *variableHeightRows
);
Parameters
browser

A data browser. 
variableWidthColumns

On input, a pointer to a Boolean variable. On return, the variable is set to true if column widths can be changed or false if they cannot be changed.
variableHeightRows

On input, a pointer to a Boolean variable. On return, the variable is set to true if row heights can be changed or false if they cannot be changed. 
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean *variableWidthColumns,
   Boolean *variableHeightRows
);

/*GetDataBrowserListViewDisclosureColumn

Obtains the property ID of the column whose items can display a disclosure triangle, and tells whether a disclosed item expands the row or adds rows.

OSStatus GetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID *column,
   Boolean *expandableRows
);
Parameters
browser

A data browser. 
column

On input, a pointer to a column ID variable. On return, the variable is set to the property ID of the currently selected column. If there is no disclosure column, the variable is set to kDataBrowserItemNoProperty. The DataBrowserTableViewColumnID data type is the same as the DataBrowserPropertyID data type.
expandableRows

On input, a pointer to a Boolean variable. On return, the variable specifies how a disclosed row behaves. The value true means that a container opens as a single row with an expanded height. The value false means a container opens to expose individual rows. See the Discussion for more details on expandable rows.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

When the expandableRows variable is set to true:
Disclosure triangles are drawn top-justified in the row. 
Custom row height, if any, for that row is respected only while the row is disclosed. At other times, the default row height is used.

When the expandableRows variable is set to false:
Disclosure triangles are centered vertically in the row.
Custom row height, if any, for that row is always respected.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID *column,
   Boolean *expandableRows
);

/*GetDataBrowserPropertyFlags

Obtains the appearance and behavior attributes for a column.

OSStatus GetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags *flags
);
Parameters
browser

A data browser. 
property

The property ID of the column whose properties you want to obtain.
flags

On input, a data browser property flags variable. On return, the variable is set to the property flags that specify the appearance and behavior attributes for a column. A DataBrowserPropertyFlags value is a 32-bit value that is divided into four parts as follows: 
Bits 0–7 specify properties applied to the data browser as a whole—see “Property Flags: Universal”
Bits 8–15 modify display behavior—see “Property Flags: Modifiers”
Bits 16–23 are properties specific to list view—see “Property Flags: Offset and Mask for List View Properties” and “Property Flags: List View Column Behavior”
Bits 24–31 can be defined by your application—see “Property Flags: Offset and Mask for Client-Defined Properties”
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags *flags
);

/*GetDataBrowserTableViewHiliteStyle

Obtains the highlighting style used for a list view data browser.

OSStatus GetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle *hiliteStyle
);
Parameters
browser

A list view data browser. 
hiliteStyle

On input, a pointer to a highlighting style variable. On return, the variable is set to the highlighting style in use. See “Table View Highlighting Styles” for a description of the values that can be returned.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle *hiliteStyle
);

/*GetDataBrowserListViewHeaderBtnHeight

Obtains the height of the rectangular area where the column title appears.

OSStatus GetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 *height
);
Parameters
browser

A data browser. 
height

On input, a pointer to an unsigned 16-bit integer. On return, this value is set to the height of the rectangular area where the column title appears. You can save this value if you plan to call the function SetDataBrowserListViewHeaderBtnHeight to turn off header button display. You can then use the value later to turn on header button display.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 *height
);

/*GetDataBrowserListViewUsePlainBackground

Determines whether list view is set to use a plain white background.

OSStatus GetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean *usePlainBackground
);
Parameters
browser

A data browser. 
usePlainBackground

On input, a pointer to a Boolean variable. On return, the variable is true if list view is set to use a plain white background. Regardless of the value that is returned, Mac OS X supports only a plain white background. Mac OS 9 supports a plain white background as well as a shaded background. 
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean *usePlainBackground
);

/*SetDataBrowserListViewDisclosureColumn

Specifies whether there is a column that has disclosure triangles and, if so, which column.

OSStatus SetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID column,
   Boolean expandableRows
);
Parameters
browser

A data browser. 
column

The property ID for the column for which you want to set as disclosure column. Only one column in list view can be designated as a disclosure column. Pass kDataBrowserNoItemProperty if you do not want a disclosure column. The DataBrowserTableViewColumnID data type is the same as the DataBrowserPropertyID data type.
expandableRows

A value that specifies how a disclosed row behaves. Pass true to have a container open as a single row with an expanded height. Pass false to have a container opens to expose other rows. See the Discussion for more details on expandable rows.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

A disclosure triangle next to an item denotes the item is a container. You can use the expandableRows parameter to specify whether an opened container displays its items in individual rows, as shown in the top of Figure 1 or increases its row height to accommodate the contained information, as shown in the bottom of the figure.


Figure 1  A container can open to more rows or expand to show more information



When the expandableRows parameter is set to true:
Disclosure triangles are drawn top-justified in the row. 
Custom row height, if any, for that row is respected only while the row is disclosed. At other times, the default row height is used.

When the expandableRows parameter is set to false:
Disclosure triangles are centered vertically in the row.
Custom row height, if any, for that row is always respected.

When a disclosure triangle is clicked by the user, your application receives the same notifications regardless of whether expandableRows is set to true or false. When your application receives a notification that an expandable row is toggled to open, call the function SetDataBrowserTableViewItemRowHeight to set the row to the appropriate height.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserListViewDisclosureColumn (
   ControlRef browser,
   DataBrowserTableViewColumnID column,
   Boolean expandableRows
);


/*SetDataBrowserTableViewGeometry

Sets whether columns and rows can have variable widths in list view.

OSStatus SetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean variableWidthColumns,
   Boolean variableHeightRows
);
Parameters
browser

A data browser. 
variableWidthColumns

A Boolean value that specifies whether column widths can be variable (true) or not (false).
variableHeightRows

A Boolean value that specifies whether row heights can be variable (true) or not (false).
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

After you call the function SetDataBrowserTableViewGeometry to set up variable row heights or columns widths in list view, you can modify individual row heights or columns widths in list view by calling the appropriate function—either SetDataBrowserTableViewItemRowHeight or SetDataBrowserTableViewNamedColumnWidth. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserTableViewGeometry (
   ControlRef browser,
   Boolean variableWidthColumns,
   Boolean variableHeightRows
);

/*SetDataBrowserActiveItems

Sets what determines the active state of the items in a data browser.

OSStatus SetDataBrowserActiveItems (
   ControlRef browser,
   Boolean active
);
Parameters
browser

A data browser. 
active

A value that specifies the new active state for the items displayed in the list. Pass true to make the active state of each item determined by what your callback reports for each item’s kDataBrowserItemIsActiveProperty property, or false to make all items inactive. Inactive items appear dimmed.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Passing true for the active parameter does not make all the items active. Instead it sets the active state of each individual item according to the value associated with the kDataBrowserItemIsActiveProperty property for that item. This means if the active property for an item is set to false, and you pass true for the active parameter, then the item is inactive.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserActiveItems (
   ControlRef browser,
   Boolean active
);

/*SetDataBrowserPropertyFlags

Sets the appearance and behavior attributes for a column in list view.

OSStatus SetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags flags
);
Parameters
browser

A data browser. 
property

The property ID of the column whose appearance and behavior you want to set.
flags

The property flags to apply. A DataBrowserPropertyFlags value is a 32-bit value that is divided into four parts as follows: 
Bits 0–7 specify properties applied to the data browser as a whole—see “Property Flags: Universal”
Bits 8–15 modify display behavior—see “Property Flags: Modifiers”
Bits 16–23 are properties specific to list view—see “Property Flags: Offset and Mask for List View Properties” and “Property Flags: List View Column Behavior”
Bits 24–31 can be defined by your application—see “Property Flags: Offset and Mask for Client-Defined Properties”
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserPropertyFlags (
   ControlRef browser,
   DataBrowserPropertyID property,
   DataBrowserPropertyFlags flags
);

/*SetDataBrowserTableViewHiliteStyle

Sets the highlighting style to use for a list view data browser.

OSStatus SetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle hiliteStyle
);
Parameters
browser

A list view data browser. 
hiliteStyle

The highlighting style you want to use. See “Table View Highlighting Styles” for a description of the constants you can supply.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserTableViewHiliteStyle (
   ControlRef browser,
   DataBrowserTableViewHiliteStyle hiliteStyle
);

/*SetDataBrowserHasScrollBars

Sets the display state of horizontal and vertical scroll bars for a list view data browser. 

OSStatus SetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean horiz,
   Boolean vert
);
Parameters
browser

A list view data browser. 
horiz

A value that specifies whether to display the browser control with (true) or without (false) a horizontal scroll bar. 
vert

A value that specifies whether to display the browser control with (true) or without (false) a vertical scroll bar. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

If the list your application displays is small and its coordinates do not extend beyond the bounds of the area used to display the list, then you can call SetDataBrowserHasScrollBars to turn off the display of scroll bars. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserHasScrollBars (
   ControlRef browser,
   Boolean horiz,
   Boolean vert
);


/*GetDataBrowserScrollBarInset

Obtains the inset rectangle used by a data browser to position the scroll bar.

OSStatus GetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
);
Parameters
browser

A data browser.
insetRect

On input, a pointer to a rectangle structure. On return, the rectangle contains the current inset settings for the data browser scroll bars. The left and right fields contain the horizontal inset values for the horizontal scroll bar, and the top and bottom fields contain the vertical inset values for the vertical scroll bar. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application can call the functions GetDataBrowserScrollBarInset and SetDataBrowserScrollBarInset if you want to place placards or controls beside the horizontal scroll bars or above the vertical ones. To do so, first call GetDataBrowserScrollBarInset to obtain the current settings. After modifying the current inset settings to provide space for the placard or control, call SetDataBrowserScrollBarInset with the new values.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
);

/*SetDataBrowserScrollBarInset

Sets the inset values to use for the scroll bars of a data browser.

OSStatus SetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
);
Parameters
browser

A data browser. 
insetRect

A pointer to a rectangle that specifies the inset values you want the data browser to use. The left and right fields contain the horizontal inset values for the horizontal scroll bar, and the top and bottom fields contain the vertical inset values for the vertical scroll bar.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application can call the functions GetDataBrowserScrollBarInset and SetDataBrowserScrollBarInset if you want to place placards or controls beside the horizontal scroll bars or above the vertical ones. To do so, first call GetDataBrowserScrollBarInset to obtain the current settings. After modifying the current inset settings to provide space for the placard or control, call SetDataBrowserScrollBarInset with the new values.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserScrollBarInset (
   ControlRef browser,
   Rect *insetRect
);

/*SetDataBrowserListViewUsePlainBackground

Specifies whether list view uses a plain white background.

OSStatus SetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean usePlainBackground
);
Parameters
browser

A data browser. 
usePlainBackground

A value that specifies whether to use a plain background (true) or not to use a plain background (false). A plain background is an all-white background. In Mac OS X, passing false currently does nothing, as Mac OS X supports only a plain white background. However, pass true if you want a plain white background just in case the API changes in the future. In Mac OS 9, passing false causes the data browser to use a shaded background. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

A list view that does not use a plain background can use colors or patterns to distinguish one column from another. For example, you could specify a color to designate a column as the sorted column.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserListViewUsePlainBackground (
   ControlRef browser,
   Boolean usePlainBackground
);

/*GetDataBrowserViewStyle

Obtains the current view style for the specified data browser.

OSStatus GetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle *style
);
Parameters
browser

A data browser. 
style

On input, a pointer to a view style variable. On return, the variable is set to the current view style for the specified data browser; can be either list view (kDataBrowserListView) or column view (kDataBrowserColumnView). See “View Styles” for more information on these constants.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle *style
);

/*SetDataBrowserViewStyle

Sets the view style of the specified data browser.

OSStatus SetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle style
);
Parameters
browser

A data browser. 
style

The view style to use. Pass the constant kDataBrowserListView to draw the data browser using list view or kDataBrowserColumnView to use column view. See “View Styles” for more information on these constants.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Although you specify a view style when you call the function CreateDataBrowserControl, you can call SetDataBrowserViewStyle to change the style. Use SetDataBrowserViewStyle when you provide users the option of changing between list and column views.

After calling SetDataBrowserViewStyle, you need to perform the necessary tasks to configure the data browser for the view style you switched to. If you switch to list view, you need to set up list view header and column descriptions and call the function AddDataBrowserListViewColumn. You might also need to call other functions such as SetDataBrowserListViewDisclosureColumn (for hierarchical lists).
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserViewStyle (
   ControlRef browser,
   DataBrowserViewStyle style
);

/*SetDataBrowserSelectionFlags

Sets allowable selection behavior for a data browser.

OSStatus SetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags selectionFlags
);
Parameters
browser

A data browser.
selectionFlags

Flags that specify the selection behavior you want to allow in the data browser. The flags control such things as whether discontinuous selections are allowed by the user. See “User Selection Flags” for detailed descriptions of these flags.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags selectionFlags
);

/*GetDataBrowserSelectionFlags

Obtains the current selection behavior for a data browser.

OSStatus GetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags *selectionFlags
);
Parameters
browser

A data browser. 
selectionFlags

On input, a data browser selection flags variable. On return, the variable is set to the current selection flags. See “User Selection Flags” for a list of the flags that can be returned. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Selection flags specify the selection behavior available to the user, such as whether the user can select discontinuous items.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus GetDataBrowserSelectionFlags (
   ControlRef browser,
   DataBrowserSelectionFlags *selectionFlags
);


/*SetDataBrowserListViewHeaderBtnHeight

Sets the height of the rectangular area where the column title appears.

OSStatus SetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 height
);
Parameters
browser

A data browser. 
height

The height, in pixels, to use for the rectangular area where the column title appears. Pass 0 to turn off header button display. To turn on header button display, pass the value previously obtained from the function GetDataBrowserListViewHeaderBtnHeight. The default height is currently 17 pixels.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserListViewHeaderBtnHeight (
   ControlRef browser,
   UInt16 height
);


/*CreateBevelButtonControl

Creates a bevel button control.

OSStatus CreateBevelButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlBevelThickness thickness,
   ControlBevelButtonBehavior behavior,
   ControlButtonContentInfoPtr info,
   SInt16 menuID,
   ControlBevelButtonMenuBehavior menuBehavior,
   ControlBevelButtonMenuPlacement menuPlacement,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the desired control in the window’s local coordinates.
title

The title of the control.
thickness

The thickness of the button. For possible values, see “Control Bevel Thickness Constants”.
behavior

The behavior the button is to have. For possible values, see “Bevel Button Behavior Constants”.
info

A value of type ControlButtonContentInfoPtr for the content information.
menuID

The menu ID. This parameter may be 0 if you don’t have a menu. Icon suite, picture, color icon, and IconRef are supported on Mac OS X v10.0 through Mac OS X v10.4. Values of type CGImageRef are supported in Mac OS X v10.4.
menuBehavior

The behavior of the menu. For possible values, see “Bevel Button Menu Constant”.
menuPlacement

The placement of the menu. For possible values, see “Control Bevel Button Menu Placement Constants”.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreateBevelButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   ControlBevelThickness thickness,
   ControlBevelButtonBehavior behavior,
   ControlButtonContentInfoPtr info,
   SInt16 menuID,
   ControlBevelButtonMenuBehavior menuBehavior,
   ControlBevelButtonMenuPlacement menuPlacement,
   ControlRef * outControl
);

/*NewControlUserPaneBackgroundUPP

ControlUserPaneBackgroundUPP NewControlUserPaneBackgroundUPP (
   ControlUserPaneBackgroundProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneBackgroundUPP NewControlUserPaneBackgroundUPP (
   ControlUserPaneBackgroundProcPtr userRoutine
);

/*SetDataBrowserItemDataBooleanValue

Specifies a Boolean value for an item.

OSStatus SetDataBrowserItemDataBooleanValue (
   DataBrowserItemDataRef itemData,
   Boolean theData
);
Parameters
itemData

The item data reference for the item whose Boolean value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataBooleanValue. 
theData

The value to display.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your item-data callback calls this function in response to an inquiry for the following properties:
kDataBrowserItemIsActiveProperty
kDataBrowserItemIsSelectableProperty
kDataBrowserItemIsEditableProperty
kDataBrowserItemIsContainerProperty
kDataBrowserItemIsOpenableProperty
kDataBrowserItemIsClosableProperty
kDataBrowserItemIsSortableProperty
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataBooleanValue (
   DataBrowserItemDataRef itemData,
   Boolean theData
);

/*InitDataBrowserCustomCallbacks

Initializes the data browser custom callback structure in preparation for adding your own callbacks for custom drawing or custom behavior to the structure.

OSStatus InitDataBrowserCustomCallbacks (
   DataBrowserCustomCallbacks *callbacks
);
Parameters
callbacks

A pointer to a DataBrowserCustomCallbacks structure. Before calling the function InitDataBrowserCustomCallbacks, set the version field of this structure to kDataBrowserLatestCustomCallbacks. On return, the fields in this structure are set to NULL.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Custom callbacks refer to those callback routines that are used to implement custom drawing or custom behavior in your data browser. The data browser API supports a limited set of built-in display types: text, icon and text, checkboxes, and so forth. If you want to display something else, you install custom callbacks to perform drawing and handle user interaction.

After you call the function InitDataBrowserCustomCallbacks, set the appropriate fields in the DataBrowserCustomCallbacks structure to your callbacks. The DataBrowserCustomCallbacks structure contains fields for the following:
DataBrowserDrawItemProcPtr
DataBrowserEditItemProcPtr
DataBrowserHitTestProcPtr
DataBrowserTrackingProcPtr
DataBrowserItemDragRgnProcPtr
DataBrowserItemAcceptDragProcPtr
DataBrowserItemReceiveDragProcPtr

After you assign your custom callbacks to the appropriate field, call the function SetDataBrowserCustomCallbacks.

Note that this is a different set of callbacks from those that are assigned to fields in the DataBrowserCallbacks data structure.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus InitDataBrowserCustomCallbacks (
   DataBrowserCustomCallbacks *callbacks
);

/*NewDataBrowserDrawItemUPP

Creates a universal procedure pointer to a draw-item callback function.

DataBrowserDrawItemUPP NewDataBrowserDrawItemUPP (
   DataBrowserDrawItemProcPtr userRoutine
);
Parameters
userRoutine

A pointer to your draw-item callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserDrawItemProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.1 and later.
Declared In
ControlDefinitions.h*/
DataBrowserDrawItemUPP NewDataBrowserDrawItemUPP (
   DataBrowserDrawItemProcPtr userRoutine
);

/*SetDataBrowserCustomCallbacks

Sets the custom callback routines to use with a data browser, replacing any previously installed custom callbacks.

OSStatus SetDataBrowserCustomCallbacks (
   ControlRef browser,
   const DataBrowserCustomCallbacks *callbacks
);
Parameters
browser

A data browser. 
callbacks

A pointer to a DataBrowserCustomCallbacks structure that is filled out with universal procedure pointers (UPPs) to the custom callback routines your application provides.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling the function SetDataBrowserCustomCallbacks you must first call InitDataBrowserCustomCallbacks to initialize the data browser custom callback structure. Calling SetDataBrowserCustomCallbacks replaces any callback routines you installed previously by calling this function.

You can supply the following custom callback routines. 
DataBrowserDrawItemProcPtr. This callback is invoked by the data browser whenever your content needs to be drawn. You must supply this callback for data whose display type is kDataBrowserCustomType.
DataBrowserEditItemProcPtr. Supply this callback when you want to support editing of your content.
DataBrowserHitTestProcPtr. You can provide this callback to determine if the pointer is over content that can be selected or dragged.
DataBrowserTrackingProcPtr. This callback implements custom tracking behavior.
DataBrowserItemDragRgnProcPtr. You can supply this callback when you need to determine which part of an item to use to create a transparent image for a dragged item.
DataBrowserItemAcceptDragProcPtr. This callback determines if an item can accept a drag object.
DataBrowserItemReceiveDragProcPtr. This callback receives a drop over an item.

Note that this is a different set of callbacks from those that are installed by calling the function SetDataBrowserCallbacks.

To replace a callback, you first need to set the appropriate fields in the DataBrowserCustomCallbacks structure to your callbacks. Then you call the function SetDataBrowserCustomCallbacks. The following code shows how to set custom callbacks. It assumes you have already called the function InitDataBrowserCustomCallbacks to initialize the data browser custom callback structure. Your application can set as many callbacks as appropriate.myCustomCallbacks.u.v1.drawItemCallback =
        NewDataBrowserDrawItemUPP (MyDataBrowserDrawItemCallback);
myCustomCallbacks.u.v1.editItemCallback =
        NewDataBrowserEditItemUPP (MyDataBrowserEditItemCallback);
SetDataBrowserCustomCallbacks (browser,&myCustomCallbacks);

Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserCustomCallbacks (
   ControlRef browser,
   const DataBrowserCustomCallbacks *callbacks
);

/*NewControlUserPaneHitTestUPP

ControlUserPaneHitTestUPP NewControlUserPaneHitTestUPP (
   ControlUserPaneHitTestProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneHitTestUPP NewControlUserPaneHitTestUPP (
   ControlUserPaneHitTestProcPtr userRoutine
);

/*NewControlUserPaneTrackingUPP

ControlUserPaneTrackingUPP NewControlUserPaneTrackingUPP (
   ControlUserPaneTrackingProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

ControlUserPaneTrackingUPP NewControlUserPaneTrackingUPP (
   ControlUserPaneTrackingProcPtr userRoutine
);

/*NewControlUserPaneKeyDownUPP

ControlUserPaneKeyDownUPP NewControlUserPaneKeyDownUPP (
   ControlUserPaneKeyDownProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneKeyDownUPP NewControlUserPaneKeyDownUPP (
   ControlUserPaneKeyDownProcPtr userRoutine
);

/*NewControlUserPaneActivateUPP

ControlUserPaneActivateUPP NewControlUserPaneActivateUPP (
   ControlUserPaneActivateProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneActivateUPP NewControlUserPaneActivateUPP (
   ControlUserPaneActivateProcPtr userRoutine
);

/*NewControlUserPaneFocusUPP

ControlUserPaneFocusUPP NewControlUserPaneFocusUPP (
   ControlUserPaneFocusProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneFocusUPP NewControlUserPaneFocusUPP (
   ControlUserPaneFocusProcPtr userRoutine
);

/*(NewControlUserPaneIdleUPP

ControlUserPaneIdleUPP NewControlUserPaneIdleUPP (
   ControlUserPaneIdleProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlUserPaneIdleUPP NewControlUserPaneIdleUPP (
   ControlUserPaneIdleProcPtr userRoutine
);

/*SetDataBrowserScrollPosition

Scrolls a list to the specified position.

OSStatus SetDataBrowserScrollPosition (
   ControlRef browser,
   UInt32 top,
   UInt32 left
);
Parameters
browser

A data browser. 
top

The vertical scrolling position to use.
left

The horizontal scrolling position to use.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

The scrolling position (0,0) represents the home position, and is located at the top left of the data browser. Horizontal and vertical units are relative to the home position.

You can call this function to scroll a list to any arbitrary scrolling position. Normally, you use the function GetDataBrowserScrollPosition in conjunction with SetDataBrowserScrollPosition to save and restore the scrolling position of a list to the user’s last scrolling position. These functions should not be used to scroll particular cells into the view. For that, call the function RevealDataBrowserItem.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserScrollPosition (
   ControlRef browser,
   UInt32 top,
   UInt32 left
);

/*GetDataBrowserItemCount

Obtains the number of items whose state matches the specified state.

OSStatus GetDataBrowserItemCount (
   ControlRef browser,
   DataBrowserItemID container,
   Boolean recurse,
   DataBrowserItemState state,
   UInt32 *numItems
);
Parameters
browser

A data browser.
container

An item ID or the constant kDataBrowserNoItem. To obtain the number of items that are organized as subitems of a container item, pass the item ID for the container. To obtain the number of items displayed at the root of the data browser, provide the constant kDataBrowserNoItem.
recurse

A value that indicates whether or not to traverse the entire item hierarchy when counting. Pass true to obtain a count for all items in the hierarchy. Pass false if you want to count only those items at the top level of the container or data browser.
state

A value that specifies the state of the items to obtain. Only items that have this state are counted. Pass kDataBrowserItemNoState if you want to count all items regardless of state. Otherwise, pass one of the constants described in Item States.
numItems

On input, a pointer to an unsigned 32-bit integer. On return, this value is set to the number of items in the container that have the specified state.
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserItemCount (
   ControlRef browser,
   DataBrowserItemID container,
   Boolean recurse,
   DataBrowserItemState state,
   UInt32 *numItems
);

/*SetDataBrowserItemDataIcon

Specifies the icon to draw.

OSStatus SetDataBrowserItemDataIcon (
   DataBrowserItemDataRef itemData,
   IconRef theData
);
Parameters
itemData

The item data reference for the item whose icon you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataIcon.
theData

The icon to display. The data browser retains the icon, so you may release the IconRef after the function returns.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

You call the function SetDataBrowserItemDataIcon from within a DataBrowserItemDataProcPtr callback routine to specify an icon to draw. You can specify an icon for any column that has the kDataBrowserIconType display type or the kDataBrowserIconAndTextType display type.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataIcon (
   DataBrowserItemDataRef itemData,
   IconRef theData
);

/*AddDataBrowserListViewColumn

Adds a column to a data browser that uses list view.

OSStatus AddDataBrowserListViewColumn (
   ControlRef browser,
   DataBrowserListViewColumnDesc *columnDesc,
   DataBrowserTableViewColumnIndex position
);
Parameters
browser

A data browser.
columnDesc

A pointer to the list view column description data structure that you have filled out with data that specifies the column property and display information for the column heading.
position

The position, among the columns already installed in the data browser, to insert this column. To insert this column to the right of all other columns, pass kDataBrowserListViewAppendColumn. The value 0 means the leftmost column.
Return Value

A result code; paramErr is returned if the columnDesc parameter is not properly initialized. See “Data Browser Result Codes”.
Discussion

Typically you use the function AddDataBrowserListViewColumn in these cases:
When you create a data browser programmatically. If you use Interface Builder to design and lay out the data browser, you do not need to call the function AddDataBrowserListViewColumn. Interface Builder lets you position a column graphically and then specify the column description in the column pane of the Info window. 
When you switch from column view to list view. Regardless of how you first create a data browser, if your application allows the user to switch between views, you need to add list view columns each time the view switches from column to list view.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus AddDataBrowserListViewColumn (
   ControlRef browser,
   DataBrowserListViewColumnDesc *columnDesc,
   DataBrowserTableViewColumnIndex position
);

/*SetDataBrowserSortProperty

Designates the list view column to use for sorting.

OSStatus SetDataBrowserSortProperty (
   ControlRef browser,
   DataBrowserPropertyID property
);
Parameters
browser

A data browser.
property

The property ID of the column to use for sorting. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

If the list is not currently sorted, or if the list is currently sorted with a different column, then the list is sorted and redrawn. You can all the function GetDataBrowserSortProperty to obtain the property ID of the column currently used for sorting.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserSortProperty (
   ControlRef browser,
   DataBrowserPropertyID property
);

/*SetDataBrowserSortOrder

Sets the sorting order for a list in list view. 

OSStatus SetDataBrowserSortOrder (
   ControlRef browser,
   DataBrowserSortOrder order
);
Parameters
browser

A data browser.
order

The sorting order. See “Sorting Orders” for a list of the constants you can supply.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

List view tracks the sorting order by column. In Mac OS X, setting the sorting order only affects the sorting order of the column currently set for sorting. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserSortOrder (
   ControlRef browser,
   DataBrowserSortOrder order
);

/*CreateDataBrowserControl

Creates a data browser programmatically.

OSStatus CreateDataBrowserControl (
   WindowRef window,
   const Rect *boundsRect,
   DataBrowserViewStyle style,
   ControlRef *outControl
);
Parameters
window

The window in which to place the data browser. 
boundsRect

A pointer to a rectangle that specifies the location where you want the control to appear in the window.
style

The view style to use. Pass the constant kDataBrowserListView to draw the data browser using list view or kDataBrowserColumnView draw the data browser using column view. See “View Styles” for more information on these constants.
outControl

On input, a pointer to a control reference. On return, this is set to the newly created data browser. When you no longer need the data browser, call the Control Manager function DisposeControl to release it. When you dispose of the control, deallocate any universal procedure pointers you allocated for use with the control.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

This function creates a data browser programmatically. If you create a data browser using Interface Builder, you don’t need to call CreateDataBrowserControl. Instead, you call the function GetControlByID to obtain a control reference that points to your data browser.

After you create a data browser by calling CreateDataBrowserControl, you can set such attributes as sorting order, scroll bars, and scroll position. See “Manipulating Data Browser Attributes” for the functions you can use to set data browser attributes.

You need to set up the display characteristics of the data browser by calling the appropriate functions. See “Formatting Table View”, “Formatting List View”, and “Formatting Column View” for information on the formatting functions you can call. 

You need to call the functions InitDataBrowserCallbacks and SetDataBrowserCallbacks to install the callbacks needed for your data browser. At the very least, you must provide an item-data callback to add or change data items; you must do so regardless of the content your data browser displays—noncustom or custom. Otherwise, your data browser will be empty. See DataBrowserItemDataProcPtr for more information. If you present hierarchical data in list view, or use column view for browsing data, you must provide a callback to handle item notifications. See DataBrowserItemNotificationProcPtr and DataBrowserItemNotificationWithItemProcPtr.

You can optionally provide callbacks to:
Perform sorting. See DataBrowserItemCompareProcPtr.
Handle drag-and-drop behavior. See DataBrowserAddDragItemProcPtr, DataBrowserAcceptDragProcPtr, DataBrowserReceiveDragProcPtr, and DataBrowserPostProcessDragProcPtr.
Provide contextual menus. See DataBrowserGetContextualMenuProcPtr and DataBrowserSelectContextualMenuProcPtr.
Display help tags. See DataBrowserItemHelpContentProcPtr.

If your data browser uses a list whose columns require custom drawing or behavior, you must also provide callbacks to handle the custom tasks. See InitDataBrowserCustomCallbacks and SetDataBrowserCustomCallbacks for more information on initializing and installing callbacks for custom behavior. The custom tasks you can handle in list view include:
Drawing custom content. See DataBrowserDrawItemProcPtr.
Supporting editing of custom content. See DataBrowserEditItemProcPtr. Note that editing is built-in for noncustom content. 
Performing hit-testing and tracking. See DataBrowserHitTestProcPtr and DataBrowserTrackingProcPtr.
Handling drag-and-drop behavior. See DataBrowserItemDragRgnProcPtr, DataBrowserItemAcceptDragProcPtr, and DataBrowserItemReceiveDragProcPtr.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateDataBrowserControl (
   WindowRef window,
   const Rect *boundsRect,
   DataBrowserViewStyle style,
   ControlRef *outControl
);

/*SetDataBrowserTableViewRowHeight

Sets the default row height for all rows in a data browser.

OSStatus SetDataBrowserTableViewRowHeight (
   ControlRef  browser,
   UInt16 height
);
Parameters
browser

A data browser. 
height

The row height, in pixels.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

This function sets the default row height for all rows. You override the default row height for an individual row by calling the function SetDataBrowserTableViewItemRowHeight.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus SetDataBrowserTableViewRowHeight (
   ControlRef  browser,
   UInt16 height
);

/*OpenDataBrowserContainer

Opens a data browser container.

OSStatus OpenDataBrowserContainer (
   ControlRef browser,
   DataBrowserItemID container
);
Parameters
browser

A data browser. 
container

The item ID of the container to open.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Normally the user navigates through a data hierarchy by clicking the disclosure triangle next to a container item in list view, or the container item (such as a folder icon) in column view. In either of these cases, the system automatically opens or closes the container. Under some circumstances your application may need to open or close a container programmatically, such as when you are restoring a display to its last known state. In such cases, you can call the function OpenDataBrowserContainer to disclose items in a container or the function CloseDataBrowserContainer to hide items in a container. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus OpenDataBrowserContainer (
   ControlRef browser,
   DataBrowserItemID container
);

/*CreateSliderControl

Creates a slider control.

OSStatus CreateSliderControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   ControlSliderOrientation orientation,
   UInt16 numTickMarks,
   Boolean liveTracking,
   ControlActionUPP liveTrackingProc,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value of the control.
maximum

The maximum value of the control.
orientation

The orientation of the control. For possible values, see “Control Slider Orientation Constants”.
numTickMarks

The number of tick marks the slider control is to have.
liveTracking

A Boolean whose value is true to enable live tracking for the control; otherwise, false.
liveTrackingProc

If the value of the liveTracking parameter is true, a ControlActionUPP callback is to be called as the control live tracks. This callback is called repeatedly as the slider is moved during tracking.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Mac OS X has a “Scroll to here” option in the General pane of System Preferences that allows users to click in the page up or page down regions of a slider and have the indicator jump directly to the clicked position, which alters the value of the slider and moves any associated content appropriately. As long as the mouse button is held down, the click is treated as though the user clicked the indicator. 

If you want the sliders in your application to work with the “Scroll to here” option, you must do the following:
Create live-tracking sliders, not sliders that show a “ghost” thumb when you click on it. You can request live-tracking sliders by passing true in the liveTracking parameter to CreateSliderControl. If you create sliders with NewControl, use the kControlSliderLiveFeedback variant.
Write an appropriate ControlActionProc and associate it with your slider by calling SetControlAction. This allows your application to update its content appropriately when the live-tracking slider is clicked.
When callingHandleControlClick or TrackControl TrackControl, pass -1 in the action proc parameter. This is a request for the Control Manager to use the action proc you associated with your control in step 2. If you rely on the standard window event handler to do your control tracking, this step is handled for you automatically.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateSliderControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   ControlSliderOrientation orientation,
   UInt16 numTickMarks,
   Boolean liveTracking,
   ControlActionUPP liveTrackingProc,
   ControlRef * outControl
);

/*CreateProgressBarControl

Creates a progress bar control.

OSStatus CreateProgressBarControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   Boolean indeterminate,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value of the control.
maximum

The maximum value of the control.
indeterminate

A Boolean whose value is true if you want the control to display a rotating barber pole effect to indicate that something is happening (an indeterminate progress bar) or false if you want to display a determinate progress bar that uses the values of the minimum and maximum parameters to show progress from minimum to maximum. 
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateProgressBarControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   Boolean indeterminate,
   ControlRef * outControl
);

/*CreateScrollBarControl

Creates a scroll bar control.

OSStatus CreateScrollBarControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 viewSize,
   Boolean liveTracking,
   ControlActionUPP liveTrackingProc,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
value

The initial value of the control.
minimum

The minimum value of the control.
maximum

The maximum value of the control.
viewSize

The size of the visible area of the scroll bar content. If this parameter is a non-zero value, this function creates a proportional scroll bar thumb; a value of 0 causes a non-proportional scroll bar thumb to be created.
liveTracking

A Boolean indicating whether or not live tracking is enabled for this scroll bar. If set to true and a valid liveTrackingProc is also passed in, the callback is called repeatedly as the thumb is moved during tracking. If set to false, a semi-transparent thumb called a “ghost thumb” draws and no live tracking occurs.
liveTrackingProc

If the value of the liveTracking parameter is true, a ControlActionUPP callback is to be called as the control live tracks. This callback is called repeatedly as the scroll thumb is moved during tracking.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateScrollBarControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt32 value,
   SInt32 minimum,
   SInt32 maximum,
   SInt32 viewSize,
   Boolean liveTracking,
   ControlActionUPP liveTrackingProc,
   ControlRef * outControl
);

/*CreateCheckBoxControl

Creates a checkbox control.

OSStatus CreateCheckBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt32 initialValue,
   Boolean autoToggle,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the checkbox control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the desired checkbox in the window’s local coordinates.
title

The title of the checkbox.
initialValue

The initial setting of the checkbox. Set to a non-zero value to indicate the checked state. 
autoToggle

If set to true, clicking the checkbox will automatically toggle its state (checked or unchecked).
outControl

On return, outControl points to the new checkbox. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateCheckBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt32 initialValue,
   Boolean autoToggle,
   ControlRef * outControl
);

/*CreatePopupButtonControl

Creates a pop-up button control.

OSStatus CreatePopupButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt16 menuID,
   Boolean variableWidth,
   SInt16 titleWidth,
   SInt16 titleJustification,
   Style titleStyle,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The title of the control.
menuID

The ID of a menu that should be used by the control. A menu with this ID should be inserted into the menubar with InsertMenu(menu, kInsertHierarchicalMenu). You can also pass -12345 to have the control delay its acquisition of a menu; in this case, you can build the menu and later provide it to the control with SetControlData and kControlPopupButtonMenuRefTag or kControlPopupButtonOwnedMenuRefTag.
variableWidth

A Boolean whose value indicates whether the width of the control is allowed to vary according to the width of the selected menu item text (true), or should remain fixed to the original control bounds width (false).
titleWidth

The width of the title.
titleJustification

The justification of the title. Use a TextEdit justification constant (teFlushDefault, teCenter, teFlushRight, or teFlushLeft).
titleStyle

A QuickDraw style bitfield indicating the font style of the title.
outControl

On return, the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreatePopupButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt16 menuID,
   Boolean variableWidth,
   SInt16 titleWidth,
   SInt16 titleJustification,
   Style titleStyle,
   ControlRef * outControl
);

/*CreateEditTextControl

Creates a new edit text control. (Deprecated in Mac OS X v10.4. Use CreateEditUnicodeTextControl instead.)

OSStatus CreateEditTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   Boolean useInlineInput,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. May be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
text

The text of the control. May be NULL.
isPassword

A Boolean indicating whether the field is to be used as a password field. Passing false indicates that the field is to display entered text normally. Passing true means that the field is to be used as a password field; any text typed into the field is displayed as bullets.
useInlineInput

A Boolean indicating whether the control is to accept inline input. Pass true to accept inline input; otherwise pass false.
style

The control’s font style, size, color, and so on. May be NULL.
outControl

On return, the new control.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

Deprecated in Mac OS X v10.4; use CreateEditUnicodeTextControl instead.
Availability
Available in Mac OS X v10.0 and later.
Deprecated in Mac OS X v10.4.
Declared In
ControlDefinitions.h*/
OSStatus CreateEditTextControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef text,
   Boolean isPassword,
   Boolean useInlineInput,
   const ControlFontStyleRec * style,
   ControlRef * outControl
);

/*CreateScrollingTextBoxControl

Creates a scrolling text box control.

OSStatus CreateScrollingTextBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt16 contentResID,
   Boolean autoScroll,
   UInt32 delayBeforeAutoScroll,
   UInt32 delayBetweenAutoScroll,
   UInt16 autoScrollAmount,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
contentResID

The resource ID of ‘TEXT’ and (optionally) ‘style’ resources whose contents are to be displayed. 
autoScroll

A Boolean whose value is true to enable automatic scrolling; otherwise, false.
delayBeforeAutoScroll

The number of ticks to wait before scrolling automatically. This parameter is ignored and can be set to 0 if the value of the autoScroll parameter is false. 
delayBetweenAutoScroll

The number of ticks to wait between automatic scrolls. This parameter is ignored and can be set to 0 if the value of the autoScroll parameter is false.
autoScrollAmount

The number of pixels to scroll. This parameter is ignored and can be set to 0 if the value of the autoScroll parameter is false.
outControl

On return, outControl points to the newly-created control. 
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements a scrolling box of text that cannot be edited. This is useful for credits in about boxes.

The standard version of this control has a scroll bar, but the autoscrolling variant does not. The autoscrolling variant needs two pieces of information to work: delay (in ticks) before the scrolling starts, and time (in ticks) between scrolls. This control scrolls one pixel at a time if created by NewControl, unless changed by calling SetControlData.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateScrollingTextBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   SInt16 contentResID,
   Boolean autoScroll,
   UInt32 delayBeforeAutoScroll,
   UInt32 delayBetweenAutoScroll,
   UInt16 autoScrollAmount,
   ControlRef * outControl
);

/*CreatePictureControl

Creates a picture control.

OSStatus CreatePictureControl (
   WindowRef window,
   const Rect * boundsRect,
   const ControlButtonContentInfo * content,
   Boolean dontTrack,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
content

The descriptor for the picture you want the control to display. Only picture content is supported. You can change the picture by calling SetControlData and passing the kControlPictureHandleTag constant.
dontTrack

A Boolean whose value is true to indicate that the control should not be highlighted when it is clicked; false means that the control should be highlighted and the mouse tracked when the control is clicked.
outControl

On return, the new control.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreatePictureControl (
   WindowRef window,
   const Rect * boundsRect,
   const ControlButtonContentInfo * content,
   Boolean dontTrack,
   ControlRef * outControl
);

/*NewControlEditTextValidationUPP

Creates a UPP for a control edit text validation callback function. 

ControlEditTextValidationUPP NewControlEditTextValidationUPP (
   ControlEditTextValidationProcPtr userRoutine
);
Return Value
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
ControlEditTextValidationUPP NewControlEditTextValidationUPP (
   ControlEditTextValidationProcPtr userRoutine
);

/*CreateListBoxControl

Creates a list box control.

OSStatus CreateListBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   Boolean autoSize,
   SInt16 numRows,
   SInt16 numColumns,
   Boolean horizScroll,
   Boolean vertScroll,
   SInt16 cellHeight,
   SInt16 cellWidth,
   Boolean hasGrowSpace,
   const ListDefSpec * listDef,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
autoSize

A Boolean whose value is true to enable auto-sizing; otherwise, false. When auto-sizing is enabled, the control automatically resizes itself as necessary to ensure that the height of the control is an exact multiple of the cell height.
numRows

The number of rows the control is to have.
numColumns

The number of columns the control is to have.
horizScroll

A Boolean whose value is true if the control is to have a horizontal scroll bar; otherwise, false.
vertScroll

A Boolean whose value is true if the control is to have a vertical scroll bar; otherwise, false.
cellHeight

The height of cells in the control.
cellWidth

The width of cells in the control.
hasGrowSpace

A Boolean whose value is true to indicate that the control is drawn so that there is room for a size box; otherwise, false.
listDef

A pointer to the list definition function you want to associate with the new control. This parameter may be NULL if you want to use the standard list definition function, which only displays text.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

The list is created with default values, and uses the standard LDEF (0) if you don’t specify a custom list definition function in the listDef parameter. You can set the LDEF to use by using kControlListBoxLDEFTag. You can change the list by getting the list handle. To get the list handle, call GetControlData and pass the kControlListBoxListHandletag constant.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateListBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   Boolean autoSize,
   SInt16 numRows,
   SInt16 numColumns,
   Boolean horizScroll,
   Boolean vertScroll,
   SInt16 cellHeight,
   SInt16 cellWidth,
   Boolean hasGrowSpace,
   const ListDefSpec * listDef,
   ControlRef * outControl
);

/*CreateRadioGroupControl

Creates a radio group control.

OSStatus CreateRadioGroupControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Discussion

This control implements a radio group. It is an embedding control and can therefore only be used when a control hierarchy is established for its owning window. You should only embed radio buttons within it. As radio buttons are embedded into it, the group sets up its value, min, and max to represent the number of embedded items. The current value of the control is the index of the sub-control that is the current “on” radio button. To get the current radio button control handle, you can use the Control Manager call GetIndexedSubControl, passing in the value of the radio group. 

Note that when creating radio buttons for use in a radio group control, you should not use the auto-toggle version of the radio button. The radio group control handles toggling the radio button values itself; auto-toggle radio buttons do not work properly in a radio group control on Mac OS 9.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateRadioGroupControl (
   WindowRef window,
   const Rect * boundsRect,
   ControlRef * outControl
);

/*CreateRadioButtonControl

Creates a radio button control.

OSStatus CreateRadioButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt32 initialValue,
   Boolean autoToggle,
   ControlRef * outControl
);
Parameters
window

The window in which the control is to be placed. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the control in the window’s local coordinates.
title

The control title. May be NULL.
initialValue

The initial value of the control. Should be 0 (off), 1 (on), or 2 (mixed). The control is automatically given a minimum value of 0 and a maximum value of 2.
autoToggle

A Boolean whose value indicates whether this control should have auto-toggle behavior. If true, the control automatically toggles between on and off states when clicked. This parameter should be false if the control is embedded into a radio group control; in that case, the radio group handles setting the correct control value in response to a click.
outControl

On return, the new control.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus CreateRadioButtonControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   SInt32 initialValue,
   Boolean autoToggle,
   ControlRef * outControl
);

/*CreateGroupBoxControl

Creates a group box control.

OSStatus CreateGroupBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   Boolean primary,
   ControlRef * outControl
);
Parameters
window

The window that is to contain the control. This parameter may be NULL in Mac OS X v10.3 and later.
boundsRect

The bounds of the desired control in the window’s local coordinates.
title

The title of the control. This parameter can be NULL if you don’t want the control to have a title.
primary

A Boolean whose value is true to create a primary group box or false to create a secondary group box. Secondary group boxes are intended to be contained within primary group boxes and have a slightly different appearance.
outControl

On return, outControl points to the new control. For a description of this data type, see “ControlRef”.
Return Value

A result code. See “Control Manager Result Codes”.
Availability
Available in Mac OS X v10.0 and later.
Declared In
ControlDefinitions.h*/

OSStatus CreateGroupBoxControl (
   WindowRef window,
   const Rect * boundsRect,
   CFStringRef title,
   Boolean primary,
   ControlRef * outControl
);

/*GetDataBrowserTarget

Obtains the target for the data browser

OSStatus GetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID *target
);
Parameters
browser

A data browser. 
target

On input, a pointer to an item ID variable. On return, the variable is set to the item ID for the currently assigned target.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

In column view, the target is the rightmost column. In list view, the target can be thought of as the root container.

Your application can call the function SetDataBrowserTarget to set an item ID to use as a target if you do not want to use the default target set by the data browser. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserTarget (
   ControlRef browser,
   DataBrowserItemID *target
);

/*SetDataBrowserItemDataButtonValue

Specifies a checkbox value.

OSStatus SetDataBrowserItemDataButtonValue (
   DataBrowserItemDataRef itemData,
   ThemeButtonValue theData
);

Parameters
itemData

The item data reference for the item whose checkbox value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataButtonValue.
theData

The checkbox setting. You can supply any of the following theme button value constants defined by the Appearance Manager:
kThemeButtonOff draws a checkbox that is not selected.
kThemeButtonOn draws a checkbox that is selected.
kThemeButtonMixed draws a checkbox that in a mixed state, indicating that a setting is on for some items in a selection and off for others.

See Appearance Manager Reference for more information.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your item-data callback calls this function in response to a set-data request for items that have the display type kDataBrowserCheckboxType.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataButtonValue (
   DataBrowserItemDataRef itemData,
   ThemeButtonValue theData
);

/*NewDataBrowserSelectContextualMenuUPP

Creates a universal procedure pointer to a select-contextual-menu callback function.

DataBrowserSelectContextualMenuUPP NewDataBrowserSelectContextualMenuUPP  (
   DataBrowserSelectContextualMenuProcPtr userRoutine
);

Parameters
userRoutine

A pointer to your select-contextual-menu callback function.
Return Value

The universal procedure pointer.
Discussion

See the DataBrowserSelectContextualMenuProcPtr callback function.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
DataBrowserSelectContextualMenuUPP NewDataBrowserSelectContextualMenuUPP  (
   DataBrowserSelectContextualMenuProcPtr userRoutine
);

/*GetDataBrowserItemState

Obtains the state of an item.

OSStatus GetDataBrowserItemState (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserItemState *state
);

Parameters
browser

A data browser.
item

The item ID of the item whose state you want to check. 
state

On input, a pointer to an item state variable. On return, the variable is set to a value that specifies the state of the item. See “Item States” for a description of the values that can be returned. 
Return Value

A result code. See “Data Browser Result Codes”.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus GetDataBrowserItemState (
   ControlRef browser,
   DataBrowserItemID item,
   DataBrowserItemState *state
);

/*SetDataBrowserItemDataDrawState

Specifies whether to draw a checkbox in the active or inactive state.

OSStatus SetDataBrowserItemDataDrawState (
   DataBrowserItemDataRef itemData,
   ThemeDrawState theData
);

Parameters
itemData

The item data reference for the item whose drawing state you want to set. This value is passed to the callback routine from which you are calling the function SetDataBrowserItemDataDrawState. 
theData

The drawing state to use for the checkbox item. You can supply the following theme drawing state constants:
kThemeStateInactive draws the item in the inactive state.
kThemeStateActive draws the item in the active state.

See Appearance Manager Reference for more information on these constants.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your item-data callback calls this function in response to a set-data request for items that have the display type kDataBrowserCheckboxType.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataDrawState (
   DataBrowserItemDataRef itemData,
   ThemeDrawState theData
);

/*SetDataBrowserItemDataLongDateTime

Specifies, as a 64-bit value, a date and time value to display.

OSStatus SetDataBrowserItemDataLongDateTime (
   DataBrowserItemDataRef itemData,
   const LongDateTime *theData
);
Parameters
itemData

The item data reference for the item whose long date and time value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataLongDateTime.
theData

A pointer to a 64-bit value that represents the time as the number of elapsed seconds since midnight, January 1, 1904. For more information about date and time encodings used in the Mac OS, see Date, Time, and Measurement Utilities Reference in Carbon Text & International Documentation.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

This function works only with items that have the property kDataBrowserDateTimeType. If the column has the property kDataBrowserRelativeDateTime, the date is displayed relative to the current time for the computer. For example, a time 24 hours before the current time is displayed as “Yesterday.” Other examples of relative date and time values are “Today, 1:45 PM” and “Yesterday, 7:30 AM.”
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataLongDateTime (
   DataBrowserItemDataRef itemData,
   const LongDateTime *theData
);

/*SetDataBrowserTableViewItemRowHeight

Sets the row height for a single row in a list view data browser.

OSStatus SetDataBrowserTableViewItemRowHeight (
   ControlRef browser,
   DataBrowserItemID item,
   UInt16 height
);

Parameters
browser

A data browser. 
item

The item ID for the item whose row height you want to set. 
height

The row height, in pixels.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Before calling this function, you must call the function SetDataBrowserTableViewGeometry to set up variable row heights.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserTableViewItemRowHeight (
   ControlRef browser,
   DataBrowserItemID item,
   UInt16 height
);

/*SetDataBrowserItemDataValue

Sets the value of an item; useful for such display types as sliders, progress bars, relevance indicators, and pop-up menus.

OSStatus SetDataBrowserItemDataValue (
   DataBrowserItemDataRef itemData,
   SInt32 theData
);

Parameters
itemData

The item data reference for the item whose integer value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataValue.
theData

The value to display. The value must be between the minimum and maximum values specified by calling the functions SetDataBrowserItemDataMinimum and SetDataBrowserItemDataMaximum. Values displayed by a progress bar can vary between the minimum and maximum values, inclusive.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your application calls the function SetDataBrowserItemDataValue to set a new value for a display type when your item-data callback routine is called with the setValue parameter set to false. 
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataValue (
   DataBrowserItemDataRef itemData,
   SInt32 theData
);

/*SetDataBrowserItemDataItemID

Communicates a property of an item when that property is another item’s ID.

OSStatus SetDataBrowserItemDataItemID (
   DataBrowserItemDataRef itemData,
   DataBrowserItemID theData
);

Parameters
itemData

The item data reference passed to your item-data callback.
theData

The item ID to set.
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

To display hierarchical data correctly the data browser needs to know whether an item is a container and whether the item is in a container (has a parent). So it sends a get-data request for the properties kDataBrowserParentContainerProperty and kDataBrowserContainerAliasIDProperty to your item-data callback. 

The property kDataBrowserContainerAliasIDProperty is sent to your item-data callback to provide your application with a chance to follow an alias that the item might represent. If the incoming item is an alias to another item, you can call SetDataBrowserItemDataItemID to inform the data browser which other item the incoming item points to.

The property kDataBrowserParentContainerProperty is sent to your item-data callback to check whether an item has a parent. If it does, you call SetDataBrowserItemDataItemID, supplying the item ID of the parent in the parameter theData. If the item has no parent, set theData to 0.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataItemID (
   DataBrowserItemDataRef itemData,
   DataBrowserItemID theData
);

/*SetDataBrowserItemDataMenuRef

Sets the pop-up menu to display.

OSStatus SetDataBrowserItemDataMenuRef (
   DataBrowserItemDataRef itemData,
   MenuRef theData
);
Parameters
itemData

The item data reference for the item whose pop-up menu value you want to set. The item data reference is passed to the callback routine from which you are calling the function SetDataBrowserItemDataMenuRef.
theData

The pop-up menu set to the value you want to display. The system retains the menu reference that you pass; you must release it when you no longer need it. Pass NULL if you no longer want a menu. 
Return Value

A result code. See “Data Browser Result Codes”.
Discussion

Your item-data callback calls this function in response to a set-data request for an item whose display type is kDataBrowserPopupMenuType.
Availability
Available in CarbonLib 1.1 and later.
Available in Mac OS X version 10.0 and later.
Declared In
ControlDefinitions.h*/
OSStatus SetDataBrowserItemDataMenuRef (
   DataBrowserItemDataRef itemData,
   MenuRef theData
);

#ifdef __cplusplus
}
#endif

#endif