#ifndef APPERANCE_H
#define APPERANCE_H


#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef COLLECTIONS_H
#include <CarbonCore/Collections.h>
#endif

#ifndef PROCESSES_H
#include <HIServices/Processes.h>
#endif


#ifndef  MACTYPES_H
//#include <CarbonCore/MacTypes.h>//hys
#endif

#ifndef  QUICKDRAW_H
#include <QD/Quickdraw.h>//hys
#endif


//#include <HYS/HIToolbox/Appearance.h>
#include <APPLE/HIToolbox/Appearance.h>

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Theme Text Colors

Identify the text colors appropriate to the contexts in which text is used.

enum {
   kThemeTextColorDialogActive = 1,
   kThemeTextColorDialogInactive = 2,
   kThemeTextColorAlertActive = 3,
   kThemeTextColorAlertInactive = 4,
   kThemeTextColorModelessDialogActive = 5,
   kThemeTextColorModelessDialogInactive = 6,
   kThemeTextColorWindowHeaderActive = 7,
   kThemeTextColorWindowHeaderInactive = 8,
   kThemeTextColorPlacardActive = 9,
   kThemeTextColorPlacardInactive = 10,
   kThemeTextColorPlacardPressed = 11,
   kThemeTextColorPushButtonActive = 12,
   kThemeTextColorPushButtonInactive = 13,
   kThemeTextColorPushButtonPressed = 14,
   kThemeTextColorBevelButtonActive = 15,
   kThemeTextColorBevelButtonInactive = 16,
   kThemeTextColorBevelButtonPressed = 17,
   kThemeTextColorPopupButtonActive = 18,
   kThemeTextColorPopupButtonInactive = 19,
   kThemeTextColorPopupButtonPressed = 20,
   kThemeTextColorIconLabel = 21,
   kThemeTextColorListView = 22
   
//Text colors available in Appearance 1.0.1 and later//
   kThemeTextColorDocumentWindowTitleActive = 23,
   kThemeTextColorDocumentWindowTitleInactive = 24,
   kThemeTextColorMovableModalWindowTitleActive = 25,
   kThemeTextColorMovableModalWindowTitleInactive = 26,
   kThemeTextColorUtilityWindowTitleActive = 27,
   kThemeTextColorUtilityWindowTitleInactive = 28,
   kThemeTextColorPopupWindowTitleActive = 29,
   kThemeTextColorPopupWindowTitleInactive = 30,
   kThemeTextColorRootMenuActive = 31,
   kThemeTextColorRootMenuSelected = 32,
   kThemeTextColorRootMenuDisabled = 33,
   kThemeTextColorMenuItemActive = 34,
   kThemeTextColorMenuItemSelected = 35,
   kThemeTextColorMenuItemDisabled = 36,
   kThemeTextColorPopupLabelActive = 37,
   kThemeTextColorPopupLabelInactive = 38
   
// Text colors available in Appearamce 1.1 and later//
   kThemeTextColorTabFrontActive = 39,
   kThemeTextColorTabNonFrontActive = 40,
   kThemeTextColorTabNonFrontPressed = 41,
   kThemeTextColorTabFrontInactive = 42,
   kThemeTextColorTabNonFrontInactive = 43,
   kThemeTextColorIconLabelSelected = 44,
   kThemeTextColorBevelButtonStickyActive = 45,
   kThemeTextColorBevelButtonStickyInactive = 46
   
//Text colors available in Appearance 1.1.1 and later//
   kThemeTextColorNotification = 47
   
//Text colors available later than Mac OS X 10.1.3
   kThemeTextColorSystemDetail = 48
   
//Specific colors that do not change from theme to theme//
   kThemeTextColorBlack = -1,
   kThemeTextColorWhite = -2
};
typedef SInt16 ThemeTextColor;
Constants
kThemeTextColorDialogActive

Text color for an active dialog box.

Available in Mac OS X v10.0 and later.
kThemeTextColorDialogInactive

Text color for an inactive dialog box.

Available in Mac OS X v10.0 and later.
kThemeTextColorAlertActive

Text color for an active alert box.

Available in Mac OS X v10.0 and later.
kThemeTextColorAlertInactive

Text color for an inactive alert box.

Available in Mac OS X v10.0 and later.
kThemeTextColorModelessDialogActive

Text color for an active modeless dialog box.

Available in Mac OS X v10.0 and later.
kThemeTextColorModelessDialogInactive

Text color for an inactive modeless dialog box.

Available in Mac OS X v10.0 and later.
kThemeTextColorWindowHeaderActive

Text color for the window header of an active window.

Available in Mac OS X v10.0 and later.
kThemeTextColorWindowHeaderInactive

Text color for the window header of an inactive window.

Available in Mac OS X v10.0 and later.
kThemeTextColorPlacardActive

Text color for a placard in an active window.

Available in Mac OS X v10.0 and later.
kThemeTextColorPlacardInactive

Text color for a placard in an inactive window.

Available in Mac OS X v10.0 and later.
kThemeTextColorPlacardPressed

Text color for a placard that is being clicked on by the user. 

Available in Mac OS X v10.0 and later.
kThemeTextColorPushButtonActive

Text color for an active push button.

Available in Mac OS X v10.0 and later.
kThemeTextColorPushButtonInactive

Text color for an inactive push button.

Available in Mac OS X v10.0 and later.
kThemeTextColorPushButtonPressed

Text color for a push button that is being clicked on by the user.

Available in Mac OS X v10.0 and later.
kThemeTextColorBevelButtonActive

Text color for an active bevel button.

Available in Mac OS X v10.0 and later.
kThemeTextColorBevelButtonInactive

Text color for an inactive bevel button.

Available in Mac OS X v10.0 and later.
kThemeTextColorBevelButtonPressed

Text color for a bevel button that is being clicked on by the user.

Available in Mac OS X v10.0 and later.
kThemeTextColorPopupButtonActive

Text color for the menu of an active pop-up menu button. 

Available in Mac OS X v10.0 and later.
kThemeTextColorPopupButtonInactive

Text color for the menu of an inactive pop-up menu button. 

Available in Mac OS X v10.0 and later.
kThemeTextColorPopupButtonPressed

Text color for the menu of a pop-up menu button that is being clicked on by the user.

Available in Mac OS X v10.0 and later.
kThemeTextColorIconLabel

Text color for an icon label.

Available in Mac OS X v10.0 and later.
kThemeTextColorListView

Text color for the contents of a list view column.

Available in Mac OS X v10.0 and later.
kThemeTextColorDocumentWindowTitleActive

Text color for the title of an active document window.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorDocumentWindowTitleInactive

Text color for the title of an inactive document window.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorMovableModalWindowTitleActive

Text color for the title of an active movable modal window.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorMovableModalWindowTitleInactive

Text color for the title of inactive movable modal window.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorUtilityWindowTitleActive

Text color for the title of an active utility (floating) window.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorUtilityWindowTitleInactive

Text color for the title of an inactive utility (floating) window.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorPopupWindowTitleActive

Text color for the title of an active pop-up window.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorPopupWindowTitleInactive

Text color for the title of an inactive pop-up window.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorRootMenuActive

Text color for an active menu bar title.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorRootMenuSelected

Text color for a menu bar title that is being selected by the user.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorRootMenuDisabled

Text color for a disabled menu bar title.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorMenuItemActive

Text color for an active menu item.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorMenuItemSelected

Text color for a menu item that is being selected by the user.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorMenuItemDisabled

Text color for a disabled menu item.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorPopupLabelActive

Text color for the label of an active pop-up menu button.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorPopupLabelInactive

Text color for the label of an inactive pop-up menu button.

Available with Appearance Manager 1.0.1 and later.
kThemeTextColorTabFrontActive

Text color for the front tab of an active tab control.

Available with Appearance Manager 1.1 and later.
kThemeTextColorTabNonFrontActive

Text color for an active tab that is not the frontmost of a tab control.

Available with Appearance Manager 1.1 and later.
kThemeTextColorTabNonFrontPressed

Text color for a tab that is not the frontmost of a tab control, when the tab is being clicked on by the user.

Available with Appearance Manager 1.1 and later.
kThemeTextColorTabFrontInactive

Text color for the front tab of an inactive tab control.

Available with Appearance Manager 1.1 and later.
kThemeTextColorTabNonFrontInactive

Text color for an inactive tab that is not the frontmost of a tab control. The tab may either be inactive because it has been individually disabled or because the tab control as a whole is currently inactive.

Available with Appearance Manager 1.1 and later.
kThemeTextColorIconLabelSelected

Text color for the label of an icon that is currently selected.

Available with Appearance Manager 1.1 and later.
kThemeTextColorBevelButtonStickyActive

Text color for an active bevel button that is currently on.

Available with Appearance Manager 1.1 and later.
kThemeTextColorBevelButtonStickyInactive

Text color for an inactive bevel button that is currently on.

Available with Appearance Manager 1.1 and later.
kThemeTextColorBlack

Black; this color does not change from theme to theme. You may use this constant instead of specifying a direct RGB value.

Available with Appearance Manager 1.1 and later.
kThemeTextColorWhite

White; this color does not change from theme to theme. You may use this constant instead of specifying a direct RGB value.

Available with Appearance Manager 1.1 and later.
Discussion

You can pass a constant of type ThemeTextColor to the function SetThemeTextColor to specify that the Appearance Manager substitute whatever the appropriate text color is for a given context under the current theme. You can use the function GetThemeTextColor to obtain the actual color in use under the current theme for the specified ThemeTextColor constant.*/

enum {
   kThemeTextColorDialogActive = 1,
   kThemeTextColorDialogInactive = 2,
   kThemeTextColorAlertActive = 3,
   kThemeTextColorAlertInactive = 4,
   kThemeTextColorModelessDialogActive = 5,
   kThemeTextColorModelessDialogInactive = 6,
   kThemeTextColorWindowHeaderActive = 7,
   kThemeTextColorWindowHeaderInactive = 8,
   kThemeTextColorPlacardActive = 9,
   kThemeTextColorPlacardInactive = 10,
   kThemeTextColorPlacardPressed = 11,
   kThemeTextColorPushButtonActive = 12,
   kThemeTextColorPushButtonInactive = 13,
   kThemeTextColorPushButtonPressed = 14,
   kThemeTextColorBevelButtonActive = 15,
   kThemeTextColorBevelButtonInactive = 16,
   kThemeTextColorBevelButtonPressed = 17,
   kThemeTextColorPopupButtonActive = 18,
   kThemeTextColorPopupButtonInactive = 19,
   kThemeTextColorPopupButtonPressed = 20,
   kThemeTextColorIconLabel = 21,
   kThemeTextColorListView = 22,

/*Text colors available in Appearance 1.0.1 and later*/
   kThemeTextColorDocumentWindowTitleActive = 23,
   kThemeTextColorDocumentWindowTitleInactive = 24,
   kThemeTextColorMovableModalWindowTitleActive = 25,
   kThemeTextColorMovableModalWindowTitleInactive = 26,
   kThemeTextColorUtilityWindowTitleActive = 27,
   kThemeTextColorUtilityWindowTitleInactive = 28,
   kThemeTextColorPopupWindowTitleActive = 29,
   kThemeTextColorPopupWindowTitleInactive = 30,
   kThemeTextColorRootMenuActive = 31,
   kThemeTextColorRootMenuSelected = 32,
   kThemeTextColorRootMenuDisabled = 33,
   kThemeTextColorMenuItemActive = 34,
   kThemeTextColorMenuItemSelected = 35,
   kThemeTextColorMenuItemDisabled = 36,
   kThemeTextColorPopupLabelActive = 37,
   kThemeTextColorPopupLabelInactive = 38,
   
/* Text colors available in Appearamce 1.1 and later*/
   kThemeTextColorTabFrontActive = 39,
   kThemeTextColorTabNonFrontActive = 40,
   kThemeTextColorTabNonFrontPressed = 41,
   kThemeTextColorTabFrontInactive = 42,
   kThemeTextColorTabNonFrontInactive = 43,
   kThemeTextColorIconLabelSelected = 44,
   kThemeTextColorBevelButtonStickyActive = 45,
   kThemeTextColorBevelButtonStickyInactive = 46,
   
/*Text colors available in Appearance 1.1.1 and later*/
   kThemeTextColorNotification = 47,
   
//Text colors available later than Mac OS X 10.1.3
   kThemeTextColorSystemDetail = 48,
   
/*Specific colors that do not change from theme to theme*/
   kThemeTextColorBlack = -1,
   kThemeTextColorWhite = -2
};
typedef SInt16 ThemeTextColor;


/*Theme Track States

Specify the state of a track control.

enum {
   kThemeTrackActive = 0,
   kThemeTrackDisabled = 1,
   kThemeTrackNothingToScroll = 2,
   kThemeTrackInactive = 3
};
typedef UInt8 ThemeTrackEnableState;
Constants
kThemeTrackActive

A track in the active state.

Available in Mac OS X v10.0 and later.
kThemeTrackDisabled

A track in the disabled state.

Available in Mac OS X v10.0 and later.
kThemeTrackNothingToScroll

For scroll bars, the window containing the track is expanded to a sufficiently large state such that all the content is viewable and there is nothing remaining to scroll.

Available in Mac OS X v10.0 and later.
Discussion

You can use constants of type ThemeTrackEnableState in the ThemeTrackDrawInfo structure and in the functions GetThemeScrollBarTrackRect and HitTestThemeScrollBarArrows. The ThemeTrackEnableState constants are available with Appearance Manager 1.1 and later.*/
enum {
   kThemeTrackActive = 0,
   kThemeTrackDisabled = 1,
   kThemeTrackNothingToScroll = 2,
   kThemeTrackInactive = 3
};
typedef UInt8 ThemeTrackEnableState;

/*Theme Track Attributes

Specify attributes of a track control.

enum {
   kThemeTrackHorizontal = (1 << 0),
   kThemeTrackRightToLeft = (1 << 1),
   kThemeTrackShowThumb = (1 << 2),
   kThemeTrackThumbRgnIsNotGhost = (1 << 3),
   kThemeTrackNoScrollBarArrows = (1 << 4),
   kThemeTrackHasFocus = (1 << 5)
};
typedef UInt16 ThemeTrackAttributes;
Constants
kThemeTrackHorizontal

If the bit specified by this mask is set, the track is horizontally, not vertically, oriented.

Available in Mac OS X v10.0 and later.
kThemeTrackRightToLeft

If the bit specified by this mask is set, values for the track increase from right to left if the track is horizontally oriented, or from bottom to top if the track is vertically oriented.

Available in Mac OS X v10.0 and later.
kThemeTrackShowThumb

If the bit specified by this mask is set, an indicator is drawn for this track.

Available in Mac OS X v10.0 and later.
kThemeTrackThumbRgnIsNotGhost

If the bit specified by this mask is set, the thumb region is drawn opaque, rather than as a ghost.

Available in Mac OS X v10.0 and later.
kThemeTrackNoScrollBarArrows

If the bit specified by this mask is set, the track scroll bar is drawn without arrows. This attribute currently has no effect.

Available in Mac OS X v10.0 and later.
kThemeTrackHasFocus

If the bit specified by this mask is set, the thumb has focus. This attribute currently has effect only on sliders.

Available only in Mac OS X after 10.1.
Discussion

The ThemeTrackAttributes enumeration defines masks your application can use in the ThemeTrackDrawInfo structure to specify various attributes of track controls. The ThemeTrackAttributes constants are available with Appearance Manager 1.1 and later.*/
enum {
   kThemeTrackHorizontal = (1 << 0),
   kThemeTrackRightToLeft = (1 << 1),
   kThemeTrackShowThumb = (1 << 2),
   kThemeTrackThumbRgnIsNotGhost = (1 << 3),
   kThemeTrackNoScrollBarArrows = (1 << 4),
   kThemeTrackHasFocus = (1 << 5)
};
typedef UInt16 ThemeTrackAttributes;


/*Theme Track Kinds

Identify specific kinds of track-based controls to the Appearance Manager.

enum {
   kThemeMediumScrollBar = 0,
   kThemeSmallScrollBar = 1,
   kThemeMediumSlider = 2,
   kThemeMediumProgressBar = 3,
   kThemeMediumIndeterminateBar = 4,
   kThemeRelevanceBar = 5,
   kThemeSmallSlider = 6,
   kThemeLargeProgressBar = 7,
   kThemeLargeIndeterminateBar = 8
};
typedef UInt16 ThemeTrackKind;
Constants
kThemeMediumScrollBar

A scroll bar.

Available in Mac OS X v10.0 and later.
kThemeSmallScrollBar

A small scroll bar.

Available in Mac OS X v10.0 and later.
kThemeMediumSlider

A slider bar.

Available in Mac OS X v10.0 and later.
kThemeMediumProgressBar

A progress bar.

Available in Mac OS X v10.0 and later.
kThemeMediumIndeterminateBar

An indeterminate progress bar.

Available in Mac OS X v10.0 and later.
Discussion

The ThemeTrackKind constants are available with Appearance Manager 1.1 and later.*/
enum {
   kThemeMediumScrollBar = 0,
   kThemeSmallScrollBar = 1,
   kThemeMediumSlider = 2,
   kThemeMediumProgressBar = 3,
   kThemeMediumIndeterminateBar = 4,
   kThemeRelevanceBar = 5,
   kThemeSmallSlider = 6,
   kThemeLargeProgressBar = 7,
   kThemeLargeIndeterminateBar = 8
};
typedef UInt16 ThemeTrackKind;


/*Theme Track Press States

Identify what is pressed in an active scroll bar or slider.

enum {
   kThemeLeftOutsideArrowPressed = 0x01,
   kThemeLeftInsideArrowPressed = 0x02,
   kThemeLeftTrackPressed = 0x04,
   kThemeThumbPressed = 0x08,
   kThemeRightTrackPressed = 0x10,
   kThemeRightInsideArrowPressed = 0x20,
   kThemeRightOutsideArrowPressed = 0x40,
   kThemeTopOutsideArrowPressed = 0x01,
   kThemeTopInsideArrowPressed = 0x02,
   kThemeTopTrackPressed = 0x04,
   kThemeBottomTrackPressed = 0x10,
   kThemeBottomInsideArrowPressed = 0x20,
   kThemeBottomOutsideArrowPressed = 0x40
};
typedef UInt8 ThemeTrackPressState;
Constants
kThemeLeftOutsideArrowPressed

For a horizontal scroll bar containing a single pair of arrows, with one arrow at each end, indicates that the arrow on the left is selected.For a horizontal scroll bar containing a single pair of arrows, with both arrows on the right, this constant is undefined and should not be used.

Available in Mac OS X v10.0 and later.
kThemeLeftInsideArrowPressed

For a horizontal scroll bar containing a single pair of arrows, with one arrow at each end, this constant is undefined and should not be used.

For a horizontal scroll bar containing a single pair of arrows, with both arrows on the right, this constant is undefined and should not be used.

Available in Mac OS X v10.0 and later.
kThemeLeftTrackPressed

For a horizontal scroll bar or slider, indicates that the end of the track to the left of the scroll box or indicator is selected.

Available in Mac OS X v10.0 and later.
kThemeThumbPressed

Indicates that the scroll box or indicator is selected.

Available in Mac OS X v10.0 and later.
kThemeRightTrackPressed

For a horizontal scroll bar or slider, indicates that the end of the track to the right of the scroll box or indicator is selected.

Available in Mac OS X v10.0 and later.
kThemeRightInsideArrowPressed

For a horizontal scroll bar containing a single pair of arrows, with one arrow at each end, this constant is undefined and should not be used.

For a horizontal scroll bar containing a single pair of arrows, with both arrows on the right, indicates that the inner arrow at the right end of the scroll bar is selected.

Available in Mac OS X v10.0 and later.
kThemeRightOutsideArrowPressed

For a horizontal scroll bar containing a single pair of arrows, with one arrow at each end, indicates that the arrow on the right is selected.

For a horizontal scroll bar containing a single pair of arrows, with both arrows on the right, indicates that the outer arrow at the right end of the scroll bar is selected.

Available in Mac OS X v10.0 and later.
kThemeTopOutsideArrowPressed

For a vertical scroll bar containing a single pair of arrows, with one arrow at each end, indicates that the arrow on the top is selected.For a vertical scroll bar containing a single pair of arrows, with both arrows on the bottom, this constant is undefined and should not be used.

Available in Mac OS X v10.0 and later.
kThemeTopInsideArrowPressed

For a vertical scroll bar containing a single pair of arrows, with one arrow at each end, this constant is undefined and should not be used.For a vertical scroll bar containing a single pair of arrows, with both arrows on the bottom, this constant is undefined and should not be used.

Available in Mac OS X v10.0 and later.
kThemeTopTrackPressed

For a vertical scroll bar or slider, indicates that the end of the track above the scroll box or indicator is selected.

Available in Mac OS X v10.0 and later.
kThemeBottomTrackPressed

For a vertical scroll bar or slider, indicates that the end of the track beneath the scroll box or indicator is selected.

Available in Mac OS X v10.0 and later.
kThemeBottomInsideArrowPressed

For a vertical scroll bar containing a single pair of arrows, with one arrow at each end, this constant is undefined and should not be used.For a vertical scroll bar containing a single pair of arrows, with both arrows on the bottom, indicates that the inner arrow at the bottom end of the scroll bar is selected.

Available in Mac OS X v10.0 and later.
kThemeBottomOutsideArrowPressed

For a vertical scroll bar containing a single pair of arrows, with one arrow at each end, indicates that the arrow on the bottom is selected.For a vertical scroll bar containing a single pair of arrows, with both arrows on the bottom, indicates that the outer arrow at the bottom end of the scroll bar is selected.

Available in Mac OS X v10.0 and later.
Discussion

You can use constants of type ThemeTrackPressState in structures of type ScrollBarTrackInfo and SliderTrackInfo to identify what is pressed in an active scroll bar or slider; the press state is ignored if the control is not active. The ThemeTrackPressState constants are available with Appearance Manager 1.1 and later.

Note that some constants are undefined when the corresponding arrows do not exist in the current visual appearance. Prior to using the ThemeTrackPressState constants, your application should call the function GetThemeScrollBarArrowStyle to obtain the type of scroll bar arrows currently being used.*/
enum {
   kThemeLeftOutsideArrowPressed = 0x01,
   kThemeLeftInsideArrowPressed = 0x02,
   kThemeLeftTrackPressed = 0x04,
   kThemeThumbPressed = 0x08,
   kThemeRightTrackPressed = 0x10,
   kThemeRightInsideArrowPressed = 0x20,
   kThemeRightOutsideArrowPressed = 0x40,
   kThemeTopOutsideArrowPressed = 0x01,
   kThemeTopInsideArrowPressed = 0x02,
   kThemeTopTrackPressed = 0x04,
   kThemeBottomTrackPressed = 0x10,
   kThemeBottomInsideArrowPressed = 0x20,
   kThemeBottomOutsideArrowPressed = 0x40
};
typedef UInt8 ThemeTrackPressState;

/*Theme Collection Tags

Identify items in a collection describing a theme.

enum {
   kThemeNameTag = 'name',
   kThemeVariantNameTag = 'varn',
   kThemeVariantBaseTintTag = 'tint',
   kThemeHighlightColorTag = 'hcol',
   kThemeScrollBarArrowStyleTag = 'sbar',
   kThemeScrollBarThumbStyleTag = 'sbth',
   kThemeSoundsEnabledTag = 'snds',
   kThemeDblClickCollapseTag = 'coll'
   kThemeAppearanceFileNameTag = 'thme',
   kThemeSystemFontTag = 'lgsf',
   kThemeSmallSystemFontTag = 'smsf',
   kThemeViewsFontTag = 'vfnt',
   kThemeViewsFontSizeTag = 'vfsz',
   kThemeDesktopPatternNameTag = 'patn',
   kThemeDesktopPatternTag = 'patt',
   kThemeDesktopPictureNameTag = 'dpnm',
   kThemeDesktopPictureAliasTag = 'dpal',
   kThemeDesktopPictureAlignmentTag = 'dpan',
   kThemeHighlightColorNameTag = 'hcnm',
   kThemeExamplePictureIDTag = 'epic',
   kThemeSoundTrackNameTag = 'sndt',
   kThemeSoundMaskTag = 'smsk',
   kThemeUserDefinedTag = 'user',
   kThemeSmoothFontEnabledTag = 'smoo',
   kThemeSmoothFontMinSizeTag = 'smos'
};
Constants
kThemeNameTag

Identifies a collection item containing the name of the theme, e.g. "Mac OS Default". The Appearance Manager only uses this collection item to identify themes within the Appearance control panel, so the GetTheme function does not return this collection item. To specify a theme name, you must create a new collection item of this type before calling the function SetTheme.

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeVariantNameTag

Identifies a collection item containing the color variation used for menus and controls in the theme.

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeHighlightColorTag

Identifies a collection item containing the text highlight color for the theme.

Collection data type: an RGBColor structure

Available in Mac OS X v10.0 and later.
kThemeScrollBarArrowStyleTag

Identifies a collection item containing a value of type ThemeScrollBarArrowStyle identifying the type of scroll bar arrows used in the theme.

Collection data type: ThemeScrollBarArrowStyle

Available in Mac OS X v10.0 and later.
kThemeScrollBarThumbStyleTag

Identifies a collection item containing a value of type ThemeScrollBarThumbStyle identifying the type of scroll boxes used in the theme.

Collection data type: ThemeScrollBarThumbStyle

Available in Mac OS X v10.0 and later.
kThemeSoundsEnabledTag

Identifies a collection item specifying whether theme sounds are enabled for the theme.

Collection data type: Boolean

Available in Mac OS X v10.0 and later.
kThemeDblClickCollapseTag

Identifies a collection item specifying whether the ability to double-click to collapse a window is enabled for the theme.

Collection data type: Boolean

Available in Mac OS X v10.0 and later.
kThemeAppearanceFileNameTag

Identifies a collection item containing the name of the appearance, e.g. "Apple platinum".

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeSystemFontTag

Identifies a collection item containing the name of the large system font for the theme.

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeSmallSystemFontTag

Identifies a collection item containing the name of the small system font for the theme.

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeViewsFontTag

Identifies a collection item containing the name of the views font for the theme.

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeViewsFontSizeTag

Identifies a collection item containing the size of the views font for the theme.

Collection data type: SInt16

Available in Mac OS X v10.0 and later.
kThemeDesktopPatternNameTag

Identifies a collection item containing the name of the desktop pattern for the theme.

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeDesktopPatternTag

Identifies a collection item containing a flattened version of the desktop pattern for the theme.

Collection data type: variable-length data

Available in Mac OS X v10.0 and later.
kThemeDesktopPictureNameTag

Identifies a collection item containing the name of the desktop picture for the theme.

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeDesktopPictureAliasTag

Identifies a collection item containing an alias handle for the desktop picture for the theme.

Collection data type: AliasHandle

Available in Mac OS X v10.0 and later.
kThemeDesktopPictureAlignmentTag

Identifies a collection item containing a value specifying how to position the desktop picture for the theme. Possible values are described in “Desktop Picture Alignments”.

Collection data type: UInt32

Available in Mac OS X v10.0 and later.
kThemeHighlightColorNameTag

Identifies a collection item containing the name of the text highlight color for the theme.

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeExamplePictureIDTag

Identifies a collection item containing the ID of the example picture for the theme.

Collection data type: SInt16

Available in Mac OS X v10.0 and later.
kThemeSoundTrackNameTag

Identifies a collection item containing the name of the soundtrack for the theme.

Collection data type: Str255

Available in Mac OS X v10.0 and later.
kThemeSoundMaskTag

Identifies a collection item containing an unsigned 32-bit integer whose bits are set to reflect the classes of sounds that are enabled for a theme. Possibilities include sounds for menus, windows, controls, and the Finder. See “Theme Sound Masks” for descriptions of possible sound mask values.

Collection data type: UInt32

Available in Mac OS X v10.0 and later.
kThemeUserDefinedTag

Identifies a collection item specifying whether the theme is user-defined; the value contained in a kThemeUserDefinedTag collection should always be true if the kThemeUserDefinedTag collection is present. The Appearance Manager uses this collection item to identify themes that the user can delete. Note that the GetTheme function does not return this collection item.

Collection data type: Boolean

Available in Mac OS X v10.0 and later.
kThemeSmoothFontEnabledTag

Identifies a collection item specifying whether font smoothing is enabled in the theme.

Collection data type: Boolean

Available in Mac OS X v10.0 and later.
kThemeSmoothFontMinSizeTag

Identifies a collection item containing the minimum point size at which font smoothing may be enabled in the theme. Possible values range from 12 to 24, inclusive.

Collection data type: UInt16

Available in Mac OS X v10.0 and later.
Discussion

Your application may use these collection tags with the functions SetTheme and GetTheme to access aspects of a theme. The data type contained in each of the collection items accessed is noted below. Theme collection tags are available with Appearance Manager 1.1 and later.*/

enum {
   kThemeNameTag = 'name',
   kThemeVariantNameTag = 'varn',
   kThemeVariantBaseTintTag = 'tint',
   kThemeHighlightColorTag = 'hcol',
   kThemeScrollBarArrowStyleTag = 'sbar',
   kThemeScrollBarThumbStyleTag = 'sbth',
   kThemeSoundsEnabledTag = 'snds',
   kThemeDblClickCollapseTag = 'coll',
   kThemeAppearanceFileNameTag = 'thme',
   kThemeSystemFontTag = 'lgsf',
   kThemeSmallSystemFontTag = 'smsf',
   kThemeViewsFontTag = 'vfnt',
   kThemeViewsFontSizeTag = 'vfsz',
   kThemeDesktopPatternNameTag = 'patn',
   kThemeDesktopPatternTag = 'patt',
   kThemeDesktopPictureNameTag = 'dpnm',
   kThemeDesktopPictureAliasTag = 'dpal',
   kThemeDesktopPictureAlignmentTag = 'dpan',
   kThemeHighlightColorNameTag = 'hcnm',
   kThemeExamplePictureIDTag = 'epic',
   kThemeSoundTrackNameTag = 'sndt',
   kThemeSoundMaskTag = 'smsk',
   kThemeUserDefinedTag = 'user',
   kThemeSmoothFontEnabledTag = 'smoo',
   kThemeSmoothFontMinSizeTag = 'smos'
};


/*Theme Menu Types

Specify a type of menu.

enum {
   kThemeMenuTypePullDown = 0,
   kThemeMenuTypePopUp = 1,
   kThemeMenuTypeHierarchical = 2,
   kThemeMenuTypeInactive = 0x0100
};
typedef UInt16 ThemeMenuType;
Constants
kThemeMenuTypePullDown

A pull-down menu.

Available with Appearance Manager 1.0.1 and later.
kThemeMenuTypePopUp

A pop-up menu.

Available with Appearance Manager 1.0.1 and later.
kThemeMenuTypeHierarchical

A hierarchical menu.

Available with Appearance Manager 1.0.1 and later.
kThemeMenuTypeInactive

An inactive menu. Add this value to any other menu type if the entire menu is inactive.

Available with Appearance Manager 1.1 and later.
Discussion

You can pass constants of type ThemeMenuType in the inMenuType parameter of GetThemeMenuBackgroundRegion and DrawThemeMenuBackground.*/
enum {
   kThemeMenuTypePullDown = 0,
   kThemeMenuTypePopUp = 1,
   kThemeMenuTypeHierarchical = 2,
   kThemeMenuTypeInactive = 0x0100
};
typedef UInt16 ThemeMenuType;

/*MenuItemDrawingProcPtr

Draws a menu item.

typedef void ( *MenuItemDrawingProcPtr)
(
   const Rect * inBounds,
   SInt16 inDepth,
   Boolean inIsColorDevice,
   SInt32 inUserData
);

If you name your function MyMenuItemDrawingCallback, you would declare it like this:

void MyMenuItemDrawingCallback (
   const Rect * inBounds,
   SInt16 inDepth,
   Boolean inIsColorDevice,
   SInt32 inUserData
);
Parameters
inBounds

A pointer to a structure of type Rect. You are passed a rectangle specifying the dimensions and position in which you should draw your menu item content. Your menu item drawing function is called clipped to the rectangle in which you are allowed to draw your content; do not draw outside this region.
inDepth

A signed 16-bit integer. You are passed the bit depth (in bits per pixel) of the current graphics port.
inIsColorDevice

A value of type Boolean. You are passed true to indicate that you are drawing on a color device; inIsColorDevice is false for a monochrome device.
inUserData

You are passed data specifying how to draw the menu item content from the inUserData parameter of DrawThemeMenuItem.
Discussion

At the time your menu item drawing function is called, the foreground text color and mode is already set to draw in the correct state (enabled, selected, disabled) and correct color for the theme. You do not need to set the color unless you have special drawing needs. If you do have special drawing needs, you should supply the inDepth value and the value of the inIsColorDevice parameter to the function IsThemeInColor to determine whether or not you should draw the menu item content in color.

Note that the Appearance Manager calls your MyMenuItemDrawingCallback function for every device that the inBounds rectangle intersects.

You should refer to your MyMenuItemDrawingCallback function using a MenuItemDrawingUPP, which you can create with NewMenuItemDrawingUPP.

You typically use the NewMenuItemDrawingUPP function like this:MenuItemDrawingUPP myMenuItemDrawingUPP;
myMenuItemDrawingUPP = NewMenuItemDrawingUPP(MyMenuItemDrawingCallback);

Special Considerations

The Appearance Manager draws the background of the menu item prior to calling your menu item drawing function, so you should not erase the item’s background from this function.
Version Notes

This function is available with Appearance Manager 1.0.1 and later.*/
typedef void ( *MenuItemDrawingProcPtr)
(
   const Rect * inBounds,
   SInt16 inDepth,
   Boolean inIsColorDevice,
   SInt32 inUserData
);


/*Theme Menu Item Types

Identify types of menu items.

enum {
   kThemeMenuItemPlain = 0,
   kThemeMenuItemHierarchical = 1,
   kThemeMenuItemScrollUpArrow = 2,
   kThemeMenuItemScrollDownArrow = 3,
   kThemeMenuItemAtTop = 0x0100,
   kThemeMenuItemAtBottom = 0x0200,
   kThemeMenuItemHierBackground = 0x0400,
   kThemeMenuItemPopUpBackground = 0x0800,
   kThemeMenuItemHasIcon = 0x8000,
   kThemeMenuItemNoBackground = 0x4000
};
typedef UInt16 ThemeMenuItemType;
Constants
kThemeMenuItemPlain

A plain menu item.

Available with Appearance Manager 1.0.1 and later.
kThemeMenuItemHierarchical

A hierarchical menu item.

Available with Appearance Manager 1.0.1 and later.
kThemeMenuItemScrollUpArrow

A scroll-up arrow.

Available with Appearance Manager 1.0.1 and later.
kThemeMenuItemScrollDownArrow

A scroll-down arrow.

Available with Appearance Manager 1.0.1 and later.
kThemeMenuItemAtTop

This value may be added to other ThemeMenuItemType constants to specify that the item being drawn appears at the top of the menu.

Available with Appearance Manager 1.1 and later.
kThemeMenuItemAtBottom

This value may be added to other ThemeMenuItemType constants to specify that the item being drawn appears at the bottom of the menu.

Available with Appearance Manager 1.1 and later.
kThemeMenuItemHierBackground

This value may be added to other ThemeMenuItemType constants to specify that the item being drawn is located in a hierarchical menu.

Available with Appearance Manager 1.1 and later.
kThemeMenuItemPopUpBackground

This value may be added to other ThemeMenuItemType constants to specify that the item being drawn is located in a pop-up menu.

Available with Appearance Manager 1.1 and later.
kThemeMenuItemHasIcon

This value may be added to the kThemeMenuItemPlain or kThemeMenuItemHierarchical constants, to specify that an icon is drawn along with the item text. This value may not be used with the kThemeMenuItemScrollUpArrow and kThemeMenuItemScrollDownArrow constants.

Available with Appearance Manager 1.1 and later.
kThemeMenuItemNoBackground

This value may be added to other ThemeMenuItemType constants to specify that the menu background should not be drawn along with the menu item. Available in Mac OS X.

Available in Mac OS X v10.1 and later.
Discussion

Your application may pass a ThemeMenuItemType constant to the function DrawThemeMenuItem to draw a menu item of the specified type, or it may pass a ThemeMenuItemType constant to the function GetThemeMenuItemExtra to retrieve spatial information for the given menu item type under the current theme.*/
enum {
   kThemeMenuItemPlain = 0,
   kThemeMenuItemHierarchical = 1,
   kThemeMenuItemScrollUpArrow = 2,
   kThemeMenuItemScrollDownArrow = 3,
   kThemeMenuItemAtTop = 0x0100,
   kThemeMenuItemAtBottom = 0x0200,
   kThemeMenuItemHierBackground = 0x0400,
   kThemeMenuItemPopUpBackground = 0x0800,
   kThemeMenuItemHasIcon = 0x8000,
   kThemeMenuItemNoBackground = 0x4000
};
typedef UInt16 ThemeMenuItemType;



/*Theme Menu States

Specify the state in which theme-compliant menus are drawn.

enum {
   kThemeMenuActive = 0,
   kThemeMenuSelected = 1,
   kThemeMenuDisabled = 3
};
typedef UInt16 ThemeMenuState;
Constants
kThemeMenuActive

Menu is drawn in its active state. 

Available in Mac OS X v10.0 and later.
kThemeMenuSelected

Menu is drawn in its selected state.

Available in Mac OS X v10.0 and later.
Discussion

You can pass constants of type ThemeMenuState in the inState parameter of DrawThemeMenuItem and DrawThemeMenuTitle. The ThemeMenuState constants are available with Appearance Manager 1.0.1 and later.*/
enum {
   kThemeMenuActive = 0,
   kThemeMenuSelected = 1,
   kThemeMenuDisabled = 3
};
typedef UInt16 ThemeMenuState;

/*Theme Brushes

Specify theme-compliant colors and patterns for particular human interface elements.

enum {
   kThemeBrushDialogBackgroundActive = 1,
   kThemeBrushDialogBackgroundInactive = 2,
   kThemeBrushAlertBackgroundActive = 3,
   kThemeBrushAlertBackgroundInactive = 4,
   kThemeBrushModelessDialogBackgroundActive = 5,
   kThemeBrushModelessDialogBackgroundInactive = 6,
   kThemeBrushUtilityWindowBackgroundActive = 7,
   kThemeBrushUtilityWindowBackgroundInactive = 8,
   kThemeBrushListViewSortColumnBackground = 9,
   kThemeBrushListViewBackground = 10,
   kThemeBrushIconLabelBackground = 11,
   kThemeBrushListViewSeparator = 12,
   kThemeBrushChasingArrows = 13,
   kThemeBrushDragHilite = 14,
   kThemeBrushDocumentWindowBackground = 15,
   kThemeBrushFinderWindowBackground = 16
   
*Brushes introduced with Appearance 1.1 (Mac OS 8.5) and later*
   
   kThemeBrushScrollBarDelimiterActive = 17,
   kThemeBrushScrollBarDelimiterInactive = 18,
   kThemeBrushFocusHighlight = 19,
   kThemeBrushPopupArrowActive = 20,
   kThemeBrushPopupArrowPressed = 21,
   kThemeBrushPopupArrowInactive = 22,
   kThemeBrushAppleGuideCoachmark = 23,
   kThemeBrushIconLabelBackgroundSelected = 24,
   kThemeBrushStaticAreaFill = 25,
   kThemeBrushActiveAreaFill = 26,
   kThemeBrushButtonFrameActive = 27,
   kThemeBrushButtonFrameInactive = 28,
   kThemeBrushButtonFaceActive = 29,
   kThemeBrushButtonFaceInactive = 30,
   kThemeBrushButtonFacePressed = 31,
   kThemeBrushButtonActiveDarkShadow = 32,
   kThemeBrushButtonActiveDarkHighlight = 33,
   kThemeBrushButtonActiveLightShadow = 34,
   kThemeBrushButtonActiveLightHighlight = 35,
   kThemeBrushButtonInactiveDarkShadow = 36,
   kThemeBrushButtonInactiveDarkHighlight = 37,
   kThemeBrushButtonInactiveLightShadow = 38,
   kThemeBrushButtonInactiveLightHighlight = 39,
   kThemeBrushButtonPressedDarkShadow = 40,
   kThemeBrushButtonPressedDarkHighlight = 41,
   kThemeBrushButtonPressedLightShadow = 42,
   kThemeBrushButtonPressedLightHighlight = 43,
   kThemeBrushBevelActiveLight = 44,
   kThemeBrushBevelActiveDark = 45,
   kThemeBrushBevelInactiveLight = 46,
   kThemeBrushBevelInactiveDark = 47
   
*Brushes introduced in Appearance 1.1.1 (Mac OS 9.0) and later
*
   kThemeBrushNotificationWindowBackground = 48
   
*Brushes introduced in Carbon*
   kThemeBrushMovableModalBackground = 49,
   kThemeBrushSheetBackgroundOpaque = 50,
   kThemeBrushDrawerBackground = 51,
   kThemeBrushToolbarBackground = 52,
   kThemeBrushSheetBackgroundTransparent = 53,
   kThemeBrushMenuBackground = 54,
   kThemeBrushMenuBackgroundSelected = 55
   
*Appearance X or later theme brush compatibility synonyms*
   kThemeBrushSheetBackground = 50
   
*meta-brushes*
   kThemeBrushBlack = -1,
   kThemeBrushWhite = -2,
   kThemeBrushPrimaryHighlightColor = -3,
   kThemeBrushSecondaryHighlightColor = -4
};
typedef SInt16 ThemeBrush;
Constants
kThemeBrushDialogBackgroundActive

An active dialog box’s background color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushDialogBackgroundInactive

An inactive dialog box’s background color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushAlertBackgroundActive

An active alert box’s background color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushAlertBackgroundInactive

An inactive alert box’s background color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushModelessDialogBackgroundActive

An active modeless dialog box’s background color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushModelessDialogBackgroundInactive

An inactive modeless dialog box’s background color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushUtilityWindowBackgroundActive

An active utility window’s background color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushUtilityWindowBackgroundInactive

An inactive utility window’s background color or pattern. 

Available in Mac OS X v10.0 and later.
kThemeBrushListViewSortColumnBackground

The background color or pattern of the list view column that is being sorted upon.

Available in Mac OS X v10.0 and later.
kThemeBrushListViewBackground

The background color or pattern of a list view column that is not being sorted upon.

Available in Mac OS X v10.0 and later.
kThemeBrushIconLabelBackground

An icon label’s color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushListViewSeparator

The color or pattern of the horizontal lines that separate rows of items in list view columns.

Available in Mac OS X v10.0 and later.
kThemeBrushChasingArrows

Asynchronous arrows’ color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushDragHilite

The color or pattern used to indicate that an element is a valid drag-and-drop destination

Available in Mac OS X v10.0 and later.
kThemeBrushDocumentWindowBackground

A document window’s background color or pattern.

Available in Mac OS X v10.0 and later.
kThemeBrushFinderWindowBackground

A Finder window’s background color or pattern. Generally, you should not use this constant unless you are trying to create a window that matches a Finder window.

Available in Mac OS X v10.0 and later.
kThemeBrushScrollBarDelimiterActive

The color or pattern used to outline the sides of an active scroll bar.

Available with Appearance Manager 1.1 and later.
kThemeBrushScrollBarDelimiterInactive

The color or pattern used to outline the sides of an inactive scroll bar.

Available with Appearance Manager 1.1 and later.
kThemeBrushFocusHighlight

The color or pattern of the focus ring around an element that is selected.

Available with Appearance Manager 1.1 and later.
kThemeBrushPopupArrowActive

The color or pattern of the arrow on an active pop-up menu button.

Available with Appearance Manager 1.1 and later.
kThemeBrushPopupArrowPressed

The color or pattern of the arrow on a pop-up menu button that is being clicked on by the user.

Available with Appearance Manager 1.1 and later.
kThemeBrushPopupArrowInactive

The color or pattern of the arrow on an inactive pop-up menu button.

Available with Appearance Manager 1.1 and later.
kThemeBrushAppleGuideCoachmark

The color or pattern of an Apple Guide coachmark.

Available with Appearance Manager 1.1 and later.
kThemeBrushIconLabelBackgroundSelected

The color or pattern of the background of an icon’s label area, when the icon is selected.

Available with Appearance Manager 1.1 and later.
kThemeBrushStaticAreaFill

The background color or pattern of an element that does not support user interaction.

Available with Appearance Manager 1.1 and later.
kThemeBrushActiveAreaFill

The color or pattern of an element that supports user interaction.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonFrameActive

The color or pattern that outlines an active button. Your application should draw the button outline outside the edge of the button.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonFrameInactive

The color or pattern that outlines an inactive button. Your application should draw the button outline outside the edge of the button.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonFaceActive

The color or pattern of the face of an active button.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonFaceInactive

The color or pattern of the face of an inactive button.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonFacePressed

The color or pattern of the face of a button that is being clicked on by the user.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonActiveDarkShadow

For an active button with a 2-pixel-wide edge, the color or pattern of the bottom and right sides of the outer ring of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonActiveDarkHighlight

For an active button with a 2-pixel-wide edge, the color or pattern of the top and left sides of the outer ring of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonActiveLightShadow

For an active button with a 2-pixel-wide edge, the color or pattern of the bottom and right sides of the inner ring of the edge. For an active button with a 1-pixel-wide edge, the color or pattern of the bottom and right sides of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonActiveLightHighlight

For an active button with a 2-pixel-wide edge, the color or pattern of the top and left sides of the inner ring of the edge. For an active button with a 1-pixel-wide edge, the color or pattern of the top and left sides of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonInactiveDarkShadow

For an inactive button with a 2-pixel-wide edge, the color or pattern of the bottom and right sides of the outer ring of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonInactiveDarkHighlight

For an inactive button with a 2-pixel-wide edge, the color or pattern of the top and left sides of the outer ring of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonInactiveLightShadow

For an inactive button with a 2-pixel-wide edge, the color or pattern of the bottom and right sides of the inner ring of the edge. For an inactive button with a 1-pixel-wide edge, the color or pattern of the bottom and right sides of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonInactiveLightHighlight

For an inactive button with a 2-pixel-wide edge, the color or pattern of the top and left sides of the inner ring of the edge. For an inactive button with a 1-pixel-wide edge, the color or pattern of the top and left sides of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonPressedDarkShadow

For a button with a 2-pixel-wide edge that is being clicked on by the user, the color or pattern of the bottom and right sides of the outer ring of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonPressedDarkHighlight

For a button with a 2-pixel-wide edge that is being clicked on by the user, the color or pattern of the top and left sides of the outer ring of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonPressedLightShadow

For a button with a 2-pixel-wide edge that is being clicked on by the user, the color or pattern of the bottom and right sides of the inner ring of the edge. For a button with a 1-pixel-wide edge that is being clicked on by the user, the color or pattern of the bottom and right sides of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushButtonPressedLightHighlight

For a button with a 2-pixel-wide edge that is being clicked on by the user, the color or pattern of the top and left sides of the inner ring of the edge. For a button with a 1-pixel-wide edge that is being clicked on by the user, the color or pattern of the top and left sides of the edge.

Available with Appearance Manager 1.1 and later.
kThemeBrushBevelActiveLight

For an active bevel button, the color or pattern of the top and left sides of the bevel.

Available with Appearance Manager 1.1 and later.
kThemeBrushBevelActiveDark

For an active bevel button, the color or pattern of the bottom and right sides of the bevel.

Available with Appearance Manager 1.1 and later.
kThemeBrushBevelInactiveLight

For an inactive bevel button, the color or pattern of the top and left sides of the bevel.

Available with Appearance Manager 1.1 and later.
kThemeBrushBevelInactiveDark

For an inactive bevel button, the color or pattern of the bottom and right sides of the bevel.

Available with Appearance Manager 1.1 and later.
kThemeBrushBlack

Black; this color does not change from theme to theme. You may use this constant instead of specifying a direct RGB value.

Available with Appearance Manager 1.1 and later.
kThemeBrushWhite

White; this color does not change from theme to theme. You may use this constant instead of specifying a direct RGB value.

Available with Appearance Manager 1.1 and later.
Discussion

The Appearance Manager provides the underlying support for RGB color data and overrides System 7 color tables such as 'cctb' and 'mctb' with an abstract mechanism that allows colors and patterns to be coordinated with the current theme. You can pass constants of type ThemeBrush in the inBrush parameter of SetThemeBackground, SetThemePen, and SetThemeWindowBackground to specify that the Appearance Manager substitute whatever the appropriate color or pattern is for a given human interface element in the current theme.*/
enum {
   kThemeBrushDialogBackgroundActive = 1,
   kThemeBrushDialogBackgroundInactive = 2,
   kThemeBrushAlertBackgroundActive = 3,
   kThemeBrushAlertBackgroundInactive = 4,
   kThemeBrushModelessDialogBackgroundActive = 5,
   kThemeBrushModelessDialogBackgroundInactive = 6,
   kThemeBrushUtilityWindowBackgroundActive = 7,
   kThemeBrushUtilityWindowBackgroundInactive = 8,
   kThemeBrushListViewSortColumnBackground = 9,
   kThemeBrushListViewBackground = 10,
   kThemeBrushIconLabelBackground = 11,
   kThemeBrushListViewSeparator = 12,
   kThemeBrushChasingArrows = 13,
   kThemeBrushDragHilite = 14,
   kThemeBrushDocumentWindowBackground = 15,
   kThemeBrushFinderWindowBackground = 16 ,
/*Brushes introduced with Appearance 1.1 (Mac OS 8.5) and later*/
   kThemeBrushScrollBarDelimiterActive = 17,
   kThemeBrushScrollBarDelimiterInactive = 18,
   kThemeBrushFocusHighlight = 19,
   kThemeBrushPopupArrowActive = 20,
   kThemeBrushPopupArrowPressed = 21,
   kThemeBrushPopupArrowInactive = 22,
   kThemeBrushAppleGuideCoachmark = 23,
   kThemeBrushIconLabelBackgroundSelected = 24,
   kThemeBrushStaticAreaFill = 25,
   kThemeBrushActiveAreaFill = 26,
   kThemeBrushButtonFrameActive = 27,
   kThemeBrushButtonFrameInactive = 28,
   kThemeBrushButtonFaceActive = 29,
   kThemeBrushButtonFaceInactive = 30,
   kThemeBrushButtonFacePressed = 31,
   kThemeBrushButtonActiveDarkShadow = 32,
   kThemeBrushButtonActiveDarkHighlight = 33,
   kThemeBrushButtonActiveLightShadow = 34,
   kThemeBrushButtonActiveLightHighlight = 35,
   kThemeBrushButtonInactiveDarkShadow = 36,
   kThemeBrushButtonInactiveDarkHighlight = 37,
   kThemeBrushButtonInactiveLightShadow = 38,
   kThemeBrushButtonInactiveLightHighlight = 39,
   kThemeBrushButtonPressedDarkShadow = 40,
   kThemeBrushButtonPressedDarkHighlight = 41,
   kThemeBrushButtonPressedLightShadow = 42,
   kThemeBrushButtonPressedLightHighlight = 43,
   kThemeBrushBevelActiveLight = 44,
   kThemeBrushBevelActiveDark = 45,
   kThemeBrushBevelInactiveLight = 46,
   kThemeBrushBevelInactiveDark = 47 ,
/*Brushes introduced in Appearance 1.1.1 (Mac OS 9.0) and later
*/
   kThemeBrushNotificationWindowBackground = 48,
/*Brushes introduced in Carbon*/
   kThemeBrushMovableModalBackground = 49,
   kThemeBrushSheetBackgroundOpaque = 50,
   kThemeBrushDrawerBackground = 51,
   kThemeBrushToolbarBackground = 52,
   kThemeBrushSheetBackgroundTransparent = 53,
   kThemeBrushMenuBackground = 54,
   kThemeBrushMenuBackgroundSelected = 55,
/*Appearance X or later theme brush compatibility synonyms*/
   kThemeBrushSheetBackground = 50,
/*meta-brushes*/
   kThemeBrushBlack = -1,
   kThemeBrushWhite = -2,
   kThemeBrushPrimaryHighlightColor = -3,
   kThemeBrushSecondaryHighlightColor = -4
};
typedef SInt16 ThemeBrush;


/*Theme Drawing States

Specify the state in which human interface elements are drawn.

enum {
   kThemeStateInactive = 0,
   kThemeStateActive = 1,
   kThemeStatePressed = 2,
   kThemeStateRollover = 6,
   kThemeStateUnavailable = 7,
   kThemeStateUnavailableInactive = 8
   kThemeStatePressedUp = 2,
   kThemeStatePressedDown = 3
};
typedef UInt32 ThemeDrawState;
Constants
kThemeStateInactive

The element is drawn in the inactive state. 

Available in Mac OS X v10.0 and later.
kThemeStateActive

The element is drawn in the active state. 

Available in Mac OS X v10.0 and later.
kThemeStatePressed

The element is drawn in the selected state.

Available in Mac OS X v10.0 and later.
kThemeStatePressedUp

For increment/decrement buttons (also known as "little arrows" controls), the increment button is drawn in the selected state.

Available with Appearance Manager 1.1 and later.
kThemeStatePressedDown

For increment/decrement buttons (also known as "little arrows" controls), the decrement button is drawn in the selected state.

Available with Appearance Manager 1.1 and later.*/

enum {
   kThemeStateInactive = 0,
   kThemeStateActive = 1,
   kThemeStatePressed = 2,
   kThemeStateRollover = 6,
   kThemeStateUnavailable = 7,
   kThemeStateUnavailableInactive = 8,
   kThemeStatePressedUp = 2,
   kThemeStatePressedDown = 3
};
typedef UInt32 ThemeDrawState;

/*Theme Font IDs

Identify types of fonts.

enum {
   kThemeSystemFont = 0,
   kThemeSmallSystemFont = 1,
   kThemeSmallEmphasizedSystemFont = 2,
   kThemeViewsFont = 3,
   kThemeEmphasizedSystemFont = 4,
   kThemeApplicationFont = 5,
   kThemeLabelFont = 6,
   kThemeMenuTitleFont = 100,
   kThemeMenuItemFont = 101,
   kThemeMenuItemMarkFont = 102,
   kThemeMenuItemCmdKeyFont = 103,
   kThemeWindowTitleFont = 104,
   kThemePushButtonFont = 105,
   kThemeUtilityWindowTitleFont = 106,
   kThemeAlertHeaderFont = 107,
   kThemeSystemFontDetail = 7,
   kThemeSystemFontDetailEmphasized = 8,
   kThemeCurrentPortFont = 200,
   kThemeToolbarFont = 108
};
typedef UInt16 ThemeFontID;
Constants
kThemeSystemFont

The current (large) system font. This is the font used to draw most interface elements. If you can't find a more appropriate ThemeFontID constant, you should use this one. This font is suitable for drawing titles on most custom widgets and buttons, as well as most static text in dialogs and windows.

Available with Appearance Manager 1.1 and later.
kThemeSmallSystemFont

The current small system font. This is the font used to draw interface elements when space is at a premium.

Available with Appearance Manager 1.1 and later.
kThemeSmallEmphasizedSystemFont

The current small, emphasized system font. This constant is identical to kThemeSmallSystemFont, except it draws bold or otherwise emphasized text, as is appropriate for your application’s language and script.

Available with Appearance Manager 1.1 and later.
kThemeViewsFont

The current views font. This is the font used to draw file and folder names in Finder windows or other browsable lists.

Available with Appearance Manager 1.1 and later.
kThemeEmphasizedSystemFont

The current emphasized system font. This constant is identical to kThemeSystemFont, except it draws bold or otherwise emphasized text, as is appropriate for your application’s language and script. 

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeApplicationFont

An analog to the Script Manager's notion of the Application Font. This font is a suitable default choice for your application's document-style text editing areas.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeLabelFont

Generally smaller than kThemeSmallSystemFont, this font is appropriate for drawing text labels next to image content that reinforces the meaning of the text, such as you may use with a bevel button. 

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuTitleFont

The font used to draw menu titles in the menu bar. 

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuItemFont

The font used to draw menu items in menus.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuItemMarkFont

The font used to draw menu item marks in menus.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeMenuItemCmdKeyFont

The font used to draw menu item command key equivalents in menus.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeWindowTitleFont

The font used to draw text in most window title bars.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemePushButtonFont

The font used to draw text labels on push buttons.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeUtilityWindowTitleFont

The font used to draw text in utility window title bars.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeAlertHeaderFont

The font used to draw the first and most important message of an alert window.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeCurrentPortFont

Unlike the other ThemeFontID constants, kThemeCurrentPortFont doesn't map to a font appropriate to your application's language or script. It maps directly to the font, size, and style of the current QuickDraw port. This allows you to get somewhat customized behavior out of the functions that take ThemeFontID constants. 

Note, however, that kThemeCurrentPortFont does not support all QuickDraw styles on all platforms; in particular, outline and shadow style are not supported on Mac OS X. Additionally, kThemeCurrentPortFont is not completely unicode savvy; use of kThemeCurrentPortFont may result in errors having to do with the current port's font not being appropriate for rendering or measuring all glyphs in a given unicode string.

Because of overhead associated with gathering QuickDraw font information and converting it to the native font format on Mac OS X, using kThemeCurrentPortFont may slow down your text drawing and measuring significantly compared to other ThemeFontID constants. Use kThemeCurrentPortFont only as a last resort.

Available in Mac OS X or in CarbonLib 1.3 and later.
kThemeToolbarFont

The font used to draw the label of a toolbar item. 

Available in Mac OS X 10.2 and later.
Discussion

A ThemeFontID constant is a virtual font ID that you can pass to one of the Appearance Manager’s text-related functions. Within these functions, the ThemeFontID is mapped to the appropriate font or fonts, size, and style based on a number of factors, including:
the system appearance (Platinum on Mac OS 9 and Aqua on Mac OS X)
the string to be rendered, if any
the language or script that the application is running in

The ThemeFontID constants allow you to get the correct text appearance for the platform your application is currently running on.*/
enum {
   kThemeSystemFont = 0,
   kThemeSmallSystemFont = 1,
   kThemeSmallEmphasizedSystemFont = 2,
   kThemeViewsFont = 3,
   kThemeEmphasizedSystemFont = 4,
   kThemeApplicationFont = 5,
   kThemeLabelFont = 6,
   kThemeMenuTitleFont = 100,
   kThemeMenuItemFont = 101,
   kThemeMenuItemMarkFont = 102,
   kThemeMenuItemCmdKeyFont = 103,
   kThemeWindowTitleFont = 104,
   kThemePushButtonFont = 105,
   kThemeUtilityWindowTitleFont = 106,
   kThemeAlertHeaderFont = 107,
   kThemeSystemFontDetail = 7,
   kThemeSystemFontDetailEmphasized = 8,
   kThemeCurrentPortFont = 200,
   kThemeToolbarFont = 108
};
typedef UInt16 ThemeFontID;


/*Theme Button Values

Specify the value of a button.

enum {
   kThemeButtonOff = 0,
   kThemeButtonOn = 1,
   kThemeButtonMixed = 2,
   kThemeDisclosureRight = 0,
   kThemeDisclosureDown = 1,
   kThemeDisclosureLeft = 2
};
typedef UInt16 ThemeButtonValue;
Constants
kThemeButtonOff

Identifies a button that is not selected.

Available in Mac OS X v10.0 and later.
kThemeButtonOn

Identifies a button that is selected.

Available in Mac OS X v10.0 and later.
kThemeButtonMixed

Identifies a button that is in the mixed state, indicating that a setting is on for some elements in a selection and off for others. This value typically applies to checkboxes and radio buttons.

Available in Mac OS X v10.0 and later.
kThemeDisclosureRight

Identifies a disclosure triangle that is pointing to the right.

Available in Mac OS X v10.0 and later.
kThemeDisclosureDown
Identifies a disclosure triangle that is pointing down.

Available in Mac OS X v10.0 and later.
kThemeDisclosureLeft

Identifies a disclosure triangle that is pointing to the left.

Available in Mac OS X v10.0 and later.
Discussion

You can use constants of type ThemeButtonValue in the ThemeButtonDrawInfo structure to specify that button controls are drawn with the correct values. The ThemeButtonValue constants are available with Appearance Manager 1.1 and later*/

enum {
   kThemeButtonOff = 0,
   kThemeButtonOn = 1,
   kThemeButtonMixed = 2,
   kThemeDisclosureRight = 0,
   kThemeDisclosureDown = 1,
   kThemeDisclosureLeft = 2
};
typedef UInt16 ThemeButtonValue;


/*Theme Thumb Directions

Specify the direction in which the indicator points in a slider control.

enum {
   kThemeThumbPlain = 0,
   kThemeThumbUpward = 1,
   kThemeThumbDownward = 2
};
typedef UInt8 ThemeThumbDirection;
Constants
kThemeThumbPlain

A plain indicator; that is, one that does not point in any direction.

Available in Mac OS X v10.0 and later.
kThemeThumbUpward

For a horizontal slider, an upward-pointing indicator. For a vertical slider, a left-pointing indicator.

Available in Mac OS X v10.0 and later.
kThemeThumbDownward

For a horizontal slider, a downward-pointing indicator. For a vertical slider, a right-pointing indicator.

Available in Mac OS X v10.0 and later.
Discussion

You can use constants of type ThemeThumbDirection in the SliderTrackInfo structure. You may use these constants with either horizontal or vertical sliders, and the Appearance Manager interprets the direction of the indicator appropriately. The ThemeThumbDirection constants are available with Appearance Manager 1.1 and later.*/

enum {
   kThemeThumbPlain = 0,
   kThemeThumbUpward = 1,
   kThemeThumbDownward = 2
};
typedef UInt8 ThemeThumbDirection;

/*Theme Metrics

enum {
   kThemeMetricScrollBarWidth = 0,
   kThemeMetricSmallScrollBarWidth = 1,
   kThemeMetricCheckBoxHeight = 2,
   kThemeMetricRadioButtonHeight = 3,
   kThemeMetricEditTextWhitespace = 4,
   kThemeMetricEditTextFrameOutset = 5,
   kThemeMetricListBoxFrameOutset = 6,
   kThemeMetricFocusRectOutset = 7,
   kThemeMetricImageWellThickness = 8,
   kThemeMetricScrollBarOverlap = 9,
   kThemeMetricLargeTabHeight = 10,
   kThemeMetricLargeTabCapsWidth = 11,
   kThemeMetricTabFrameOverlap = 12,
   kThemeMetricTabIndentOrStyle = 13,
   kThemeMetricTabOverlap = 14,
   kThemeMetricSmallTabHeight = 15,
   kThemeMetricSmallTabCapsWidth = 16,
   kThemeMetricPushButtonHeight = 19,
   kThemeMetricListHeaderHeight = 20,
   kThemeMetricDisclosureTriangleHeight = 25,
   kThemeMetricDisclosureTriangleWidth = 26,
   kThemeMetricLittleArrowsHeight = 27,
   kThemeMetricLittleArrowsWidth = 28,
   kThemeMetricPopupButtonHeight = 30,
   kThemeMetricSmallPopupButtonHeight = 31,
   kThemeMetricLargeProgressBarThickness = 32,
   kThemeMetricPullDownHeight = 33,
   kThemeMetricSmallPullDownHeight = 34,
   kThemeMetricResizeControlHeight = 38,
   kThemeMetricSmallResizeControlHeight = 39,
   kThemeMetricHSliderHeight = 41,
   kThemeMetricHSliderTickHeight = 42,
   kThemeMetricVSliderWidth = 45,
   kThemeMetricVSliderTickWidth = 46,
   kThemeMetricTitleBarControlsHeight = 49,
   kThemeMetricCheckBoxWidth = 50,
   kThemeMetricRadioButtonWidth = 52,
   kThemeMetricNormalProgressBarThickness = 58,
   kThemeMetricProgressBarShadowOutset = 59,
   kThemeMetricSmallProgressBarShadowOutset = 60,
   kThemeMetricPrimaryGroupBoxContentInset = 61,
   kThemeMetricSecondaryGroupBoxContentInset = 62,
   kThemeMetricMenuMarkColumnWidth = 63,
   kThemeMetricMenuExcludedMarkColumnWidth = 64,
   kThemeMetricMenuMarkIndent = 65,
   kThemeMetricMenuTextLeadingEdgeMargin = 66,
   kThemeMetricMenuTextTrailingEdgeMargin = 67,
   kThemeMetricMenuIndentWidth = 68,
   kThemeMetricMenuIconTrailingEdgeMargin = 69
};
enum {
   kThemeMetricDisclosureButtonHeight = 17,
   kThemeMetricRoundButtonSize = 18,
   kThemeMetricSmallCheckBoxHeight = 21,
   kThemeMetricDisclosureButtonWidth = 22,
   kThemeMetricSmallDisclosureButtonHeight = 23,
   kThemeMetricSmallDisclosureButtonWidth = 24,
   kThemeMetricPaneSplitterHeight = 29,
   kThemeMetricSmallPushButtonHeight = 35,
   kThemeMetricSmallRadioButtonHeight = 36,
   kThemeMetricRelevanceIndicatorHeight = 37,
   kThemeMetricLargeRoundButtonSize = 40,
   kThemeMetricSmallHSliderHeight = 43,
   kThemeMetricSmallHSliderTickHeight = 44,
   kThemeMetricSmallVSliderWidth = 47,
   kThemeMetricSmallVSliderTickWidth = 48,
   kThemeMetricSmallCheckBoxWidth = 51,
   kThemeMetricSmallRadioButtonWidth = 53,
   kThemeMetricSmallHSliderMinThumbWidth = 54,
   kThemeMetricSmallVSliderMinThumbHeight = 55,
   kThemeMetricSmallHSliderTickOffset = 56,
   kThemeMetricSmallVSliderTickOffset = 57
};
typedef UInt32 ThemeMetric;
Constants
kThemeMetricScrollBarWidth

The width of a scroll bar. For horizontal scroll bars, this measurement is actually the scroll bar height.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallScrollBarWidth

The width of a small scroll bar. For horizontal scroll bars, this measurement is actually the scroll bar height.

Available in Mac OS X v10.0 and later.
kThemeMetricCheckBoxHeight

The height of the non-label part of a check box control.

Available in Mac OS X v10.0 and later.
kThemeMetricRadioButtonHeight

The height of the non-label part of a radio button control.

Available in Mac OS X v10.0 and later.
kThemeMetricEditTextWhitespace

The amount of white space surrounding the text rectangle of the text inside of an Edit Text control. If you select all of the text in an Edit Text control, this white space is visible. The metric is the number of pixels, per side, that the text rectangle is outset to create the whitespace rectangle.

Available in Mac OS X v10.0 and later.
kThemeMetricEditTextFrameOutset

The thickness of the Edit Text frame that surrounds the whitespace rectangle (which surrounds the text rectangle). The metric is the number of pixels, per side, that the frame rectangle is outset from the whitespace rectangle.

Available in Mac OS X v10.0 and later.
kThemeMetricListBoxFrameOutset

The number of pixels that the list box frame is outset from the content of the list box.

Available in Mac OS X v10.0 and later.
kThemeMetricFocusRectOutset

This is a deprecated metric and you should not use it. This metric describes how far from a control the focus rectangle was drawn, but control focus drawing no longer uses this information.

Available in Mac OS X v10.0 and later.
kThemeMetricImageWellThickness

The thickness of the frame drawn by DrawThemeGenericWell.

Available in Mac OS X v10.0 and later.
kThemeMetricScrollBarOverlap

The number of pixels a scrollbar should overlap any bounding box which surrounds it and scrollable content. This also includes the window frame when a scrollbar is along an edge of the window.

Available in Mac OS X v10.0 and later.
kThemeMetricLargeTabHeight

The height of the large tab of a tab control.

Available in Mac OS X v10.0 and later.
kThemeMetricLargeTabCapsWidth

The width of the caps, or end pieces, of the large tabs of a tab control.

Available in Mac OS X v10.0 and later.
kThemeMetricTabFrameOverlap

The amount you must add to the tab height, kThemeMetricLargeTabHeight, to find the rectangle height to use with the various tab drawing primitives. This amount is also the amount that each tab overlaps the tab pane.

Available in Mac OS X v10.0 and later.
kThemeMetricTabIndentOrStyle

If less than zero, this indicates that the text should be centered on each tab. If greater than zero, the text should be justified, according to the system script direction, and the amount is the offset from the edge at which the text should start drawing.

Available in Mac OS X v10.0 and later.
kThemeMetricTabOverlap

The amount of space that every tab's drawing rectangle overlapsthat of the tab on either side of it.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallTabHeight

The height of the small tab of a tab control. This includes the pixels that overlap the tab pane and/or tab pane bar.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallTabCapsWidth

The width of the caps, or end pieces, of the small tabs of a tab control.

Available in Mac OS X v10.0 and later.
kThemeMetricPushButtonHeight

The height and the width of the push button control.

Available in Mac OS X v10.0 and later.
kThemeMetricListHeaderHeight

The height of the list header field of the data browser control.

Available in Mac OS X v10.0 and later.
kThemeMetricDisclosureTriangleHeight

The height of a disclosure triangle control. This triangle is the not the center of the disclosure button, but its own control.

Available in Mac OS X v10.0 and later.
kThemeMetricDisclosureTriangleWidth

The width of a disclosure triangle control.

Available in Mac OS X v10.0 and later.
kThemeMetricLittleArrowsHeight

The height of a little arrows control.

Available in Mac OS X v10.0 and later.
kThemeMetricLittleArrowsWidth

The width of a little arrows control.

Available in Mac OS X v10.0 and later.
kThemeMetricPopupButtonHeight

The height of a popup button control.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallPopupButtonHeight

The height of a small popup button control.

Available in Mac OS X v10.0 and later.
kThemeMetricLargeProgressBarThickness

The height of the large progress bar, not including its shadow.

Available in Mac OS X v10.0 and later.
kThemeMetricPullDownHeight

This metric is not used.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallPullDownHeight

This metric is not used.

Available in Mac OS X v10.0 and later.
kThemeMetricResizeControlHeight

The height of the window grow box control.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallResizeControlHeight

The width of the window grow box control.

Available in Mac OS X v10.0 and later.
kThemeMetricHSliderHeight

The height of the horizontal slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricHSliderTickHeight

The height of the tick marks for a horizontal slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricVSliderWidth

The width of the vertical slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricVSliderTickWidth

The width of the tick marks for a vertical slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricTitleBarControlsHeight

The height of the title bar widgets (grow, close, and zoom boxes) for a document window.

Available in Mac OS X v10.0 and later.
kThemeMetricCheckBoxWidth

The width of the non-label part of a check box control.

Available in Mac OS X v10.0 and later.
kThemeMetricRadioButtonWidth

The width of the non-label part of a radio button control.

Available in Mac OS X v10.0 and later.
kThemeMetricNormalProgressBarThickness

The height of the normal progress bar, not including its shadow.

Available in Mac OS X v10.0 and later.
kThemeMetricProgressBarShadowOutset

The number of pixels of shadow depth drawn below the progress bar.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallProgressBarShadowOutset

The number of pixels of shadow depth drawn below the small progress bar.

Available in Mac OS X v10.0 and later.
kThemeMetricPrimaryGroupBoxContentInset

The number of pixels that the content of a primary group box is inset from the bounds of the control.

Available in Mac OS X v10.0 and later.
kThemeMetricSecondaryGroupBoxContentInset

The number of pixels that the content of a secondary group box is from the bounds of the control.

Available in Mac OS X v10.0 and later.
kThemeMetricMenuMarkColumnWidth

The width allocated to draw the mark character in a menu.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuExcludedMarkColumnWidth

The width allocated for the mark character in a menu item when the menu has the attribute kMenuAttrExcludesMarkColumn.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuMarkIndent

The indent into the interior of the mark column at which the mark character is drawn.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuTextLeadingEdgeMargin

The whitespace at the leading edge of menu item text.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuTextTrailingEdgeMargin

The whitespace at the trailing edge of menu item text.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuIndentWidth

The width per indent level of a menu item. This indent is set by the SetMenuItemIndent function.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuIconTrailingEdgeMargin

The whitespace at the trailing edge of a menu icon, if the item also has text.

Available in Mac OS X v10.1 and later.
kThemeMetricDisclosureButtonHeight

The height of a disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricRoundButtonSize

The height and the width of the round button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallCheckBoxHeight

The height of the non-label part of a small check box control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricDisclosureButtonWidth

The width of a disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallDisclosureButtonHeight

The height of a small disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallDisclosureButtonWidth

The width of a small disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricPaneSplitterHeight

The height (or width if vertical) of a pane splitter. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallPushButtonHeight

The height of the small push button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallRadioButtonHeight

The height of the non-label part of a small radio button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricRelevanceIndicatorHeight

The height of the relevance indicator control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricLargeRoundButtonSize

The height and the width of the large round button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderHeight

The height of the small, horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderTickHeight

The height of the tick marks for a small, horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderWidth

The width of the small, vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderTickWidth

The width of the tick marks for a small, vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallCheckBoxWidth

The width of the non-label part of a small check box control. (Mac OS X only.)
Theme Metrics

enum {
   kThemeMetricScrollBarWidth = 0,
   kThemeMetricSmallScrollBarWidth = 1,
   kThemeMetricCheckBoxHeight = 2,
   kThemeMetricRadioButtonHeight = 3,
   kThemeMetricEditTextWhitespace = 4,
   kThemeMetricEditTextFrameOutset = 5,
   kThemeMetricListBoxFrameOutset = 6,
   kThemeMetricFocusRectOutset = 7,
   kThemeMetricImageWellThickness = 8,
   kThemeMetricScrollBarOverlap = 9,
   kThemeMetricLargeTabHeight = 10,
   kThemeMetricLargeTabCapsWidth = 11,
   kThemeMetricTabFrameOverlap = 12,
   kThemeMetricTabIndentOrStyle = 13,
   kThemeMetricTabOverlap = 14,
   kThemeMetricSmallTabHeight = 15,
   kThemeMetricSmallTabCapsWidth = 16,
   kThemeMetricPushButtonHeight = 19,
   kThemeMetricListHeaderHeight = 20,
   kThemeMetricDisclosureTriangleHeight = 25,
   kThemeMetricDisclosureTriangleWidth = 26,
   kThemeMetricLittleArrowsHeight = 27,
   kThemeMetricLittleArrowsWidth = 28,
   kThemeMetricPopupButtonHeight = 30,
   kThemeMetricSmallPopupButtonHeight = 31,
   kThemeMetricLargeProgressBarThickness = 32,
   kThemeMetricPullDownHeight = 33,
   kThemeMetricSmallPullDownHeight = 34,
   kThemeMetricResizeControlHeight = 38,
   kThemeMetricSmallResizeControlHeight = 39,
   kThemeMetricHSliderHeight = 41,
   kThemeMetricHSliderTickHeight = 42,
   kThemeMetricVSliderWidth = 45,
   kThemeMetricVSliderTickWidth = 46,
   kThemeMetricTitleBarControlsHeight = 49,
   kThemeMetricCheckBoxWidth = 50,
   kThemeMetricRadioButtonWidth = 52,
   kThemeMetricNormalProgressBarThickness = 58,
   kThemeMetricProgressBarShadowOutset = 59,
   kThemeMetricSmallProgressBarShadowOutset = 60,
   kThemeMetricPrimaryGroupBoxContentInset = 61,
   kThemeMetricSecondaryGroupBoxContentInset = 62,
   kThemeMetricMenuMarkColumnWidth = 63,
   kThemeMetricMenuExcludedMarkColumnWidth = 64,
   kThemeMetricMenuMarkIndent = 65,
   kThemeMetricMenuTextLeadingEdgeMargin = 66,
   kThemeMetricMenuTextTrailingEdgeMargin = 67,
   kThemeMetricMenuIndentWidth = 68,
   kThemeMetricMenuIconTrailingEdgeMargin = 69
};
enum {
   kThemeMetricDisclosureButtonHeight = 17,
   kThemeMetricRoundButtonSize = 18,
   kThemeMetricSmallCheckBoxHeight = 21,
   kThemeMetricDisclosureButtonWidth = 22,
   kThemeMetricSmallDisclosureButtonHeight = 23,
   kThemeMetricSmallDisclosureButtonWidth = 24,
   kThemeMetricPaneSplitterHeight = 29,
   kThemeMetricSmallPushButtonHeight = 35,
   kThemeMetricSmallRadioButtonHeight = 36,
   kThemeMetricRelevanceIndicatorHeight = 37,
   kThemeMetricLargeRoundButtonSize = 40,
   kThemeMetricSmallHSliderHeight = 43,
   kThemeMetricSmallHSliderTickHeight = 44,
   kThemeMetricSmallVSliderWidth = 47,
   kThemeMetricSmallVSliderTickWidth = 48,
   kThemeMetricSmallCheckBoxWidth = 51,
   kThemeMetricSmallRadioButtonWidth = 53,
   kThemeMetricSmallHSliderMinThumbWidth = 54,
   kThemeMetricSmallVSliderMinThumbHeight = 55,
   kThemeMetricSmallHSliderTickOffset = 56,
   kThemeMetricSmallVSliderTickOffset = 57
};
typedef UInt32 ThemeMetric;

Constants
ThemeMetricScrollBarWidth

The width of a scroll bar. For horizontal scroll bars, this measurement is actually the scroll bar height.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallScrollBarWidth

The width of a small scroll bar. For horizontal scroll bars, this measurement is actually the scroll bar height.

Available in Mac OS X v10.0 and later.
kThemeMetricCheckBoxHeight

The height of the non-label part of a check box control.

Available in Mac OS X v10.0 and later.
kThemeMetricRadioButtonHeight

The height of the non-label part of a radio button control.

Available in Mac OS X v10.0 and later.
kThemeMetricEditTextWhitespace

The amount of white space surrounding the text rectangle of the text inside of an Edit Text control. If you select all of the text in an Edit Text control, this white space is visible. The metric is the number of pixels, per side, that the text rectangle is outset to create the whitespace rectangle.

Available in Mac OS X v10.0 and later.
kThemeMetricEditTextFrameOutset

The thickness of the Edit Text frame that surrounds the whitespace rectangle (which surrounds the text rectangle). The metric is the number of pixels, per side, that the frame rectangle is outset from the whitespace rectangle.
Theme Metrics

enum {
   kThemeMetricScrollBarWidth = 0,
   kThemeMetricSmallScrollBarWidth = 1,
   kThemeMetricCheckBoxHeight = 2,
   kThemeMetricRadioButtonHeight = 3,
   kThemeMetricEditTextWhitespace = 4,
   kThemeMetricEditTextFrameOutset = 5,
   kThemeMetricListBoxFrameOutset = 6,
   kThemeMetricFocusRectOutset = 7,
   kThemeMetricImageWellThickness = 8,
   kThemeMetricScrollBarOverlap = 9,
   kThemeMetricLargeTabHeight = 10,
   kThemeMetricLargeTabCapsWidth = 11,
   kThemeMetricTabFrameOverlap = 12,
   kThemeMetricTabIndentOrStyle = 13,
   kThemeMetricTabOverlap = 14,
   kThemeMetricSmallTabHeight = 15,
   kThemeMetricSmallTabCapsWidth = 16,
   kThemeMetricPushButtonHeight = 19,
   kThemeMetricListHeaderHeight = 20,
   kThemeMetricDisclosureTriangleHeight = 25,
   kThemeMetricDisclosureTriangleWidth = 26,
   kThemeMetricLittleArrowsHeight = 27,
   kThemeMetricLittleArrowsWidth = 28,
   kThemeMetricPopupButtonHeight = 30,
   kThemeMetricSmallPopupButtonHeight = 31,
   kThemeMetricLargeProgressBarThickness = 32,
   kThemeMetricPullDownHeight = 33,
   kThemeMetricSmallPullDownHeight = 34,
   kThemeMetricResizeControlHeight = 38,
   kThemeMetricSmallResizeControlHeight = 39,
   kThemeMetricHSliderHeight = 41,
   kThemeMetricHSliderTickHeight = 42,
   kThemeMetricVSliderWidth = 45,
   kThemeMetricVSliderTickWidth = 46,
   kThemeMetricTitleBarControlsHeight = 49,
   kThemeMetricCheckBoxWidth = 50,
   kThemeMetricRadioButtonWidth = 52,
   kThemeMetricNormalProgressBarThickness = 58,
   kThemeMetricProgressBarShadowOutset = 59,
   kThemeMetricSmallProgressBarShadowOutset = 60,
   kThemeMetricPrimaryGroupBoxContentInset = 61,
   kThemeMetricSecondaryGroupBoxContentInset = 62,
   kThemeMetricMenuMarkColumnWidth = 63,
   kThemeMetricMenuExcludedMarkColumnWidth = 64,
   kThemeMetricMenuMarkIndent = 65,
   kThemeMetricMenuTextLeadingEdgeMargin = 66,
   kThemeMetricMenuTextTrailingEdgeMargin = 67,
   kThemeMetricMenuIndentWidth = 68,
   kThemeMetricMenuIconTrailingEdgeMargin = 69
};
enum {
   kThemeMetricDisclosureButtonHeight = 17,
   kThemeMetricRoundButtonSize = 18,
   kThemeMetricSmallCheckBoxHeight = 21,
   kThemeMetricDisclosureButtonWidth = 22,
   kThemeMetricSmallDisclosureButtonHeight = 23,
   kThemeMetricSmallDisclosureButtonWidth = 24,
   kThemeMetricPaneSplitterHeight = 29,
   kThemeMetricSmallPushButtonHeight = 35,
   kThemeMetricSmallRadioButtonHeight = 36,
   kThemeMetricRelevanceIndicatorHeight = 37,
   kThemeMetricLargeRoundButtonSize = 40,
   kThemeMetricSmallHSliderHeight = 43,
   kThemeMetricSmallHSliderTickHeight = 44,
   kThemeMetricSmallVSliderWidth = 47,
   kThemeMetricSmallVSliderTickWidth = 48,
   kThemeMetricSmallCheckBoxWidth = 51,
   kThemeMetricSmallRadioButtonWidth = 53,
   kThemeMetricSmallHSliderMinThumbWidth = 54,
   kThemeMetricSmallVSliderMinThumbHeight = 55,
   kThemeMetricSmallHSliderTickOffset = 56,
   kThemeMetricSmallVSliderTickOffset = 57
};
typedef UInt32 ThemeMetric;
Constants
kThemeMetricScrollBarWidth

The width of a scroll bar. For horizontal scroll bars, this measurement is actually the scroll bar height.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallScrollBarWidth

The width of a small scroll bar. For horizontal scroll bars, this measurement is actually the scroll bar height.

Available in Mac OS X v10.0 and later.
kThemeMetricCheckBoxHeight

The height of the non-label part of a check box control.

Available in Mac OS X v10.0 and later.
kThemeMetricRadioButtonHeight

The height of the non-label part of a radio button control.

Available in Mac OS X v10.0 and later.
kThemeMetricEditTextWhitespace

The amount of white space surrounding the text rectangle of the text inside of an Edit Text control. If you select all of the text in an Edit Text control, this white space is visible. The metric is the number of pixels, per side, that the text rectangle is outset to create the whitespace rectangle.

Available in Mac OS X v10.0 and later.
kThemeMetricEditTextFrameOutset

The thickness of the Edit Text frame that surrounds the whitespace rectangle (which surrounds the text rectangle). The metric is the number of pixels, per side, that the frame rectangle is outset from the whitespace rectangle.

Available in Mac OS X v10.0 and later.
kThemeMetricListBoxFrameOutset

The number of pixels that the list box frame is outset from the content of the list box.

Available in Mac OS X v10.0 and later.
kThemeMetricFocusRectOutset

This is a deprecated metric and you should not use it. This metric describes how far from a control the focus rectangle was drawn, but control focus drawing no longer uses this information.

Available in Mac OS X v10.0 and later.
kThemeMetricImageWellThickness

The thickness of the frame drawn by DrawThemeGenericWell.

Available in Mac OS X v10.0 and later.
kThemeMetricScrollBarOverlap

The number of pixels a scrollbar should overlap any bounding box which surrounds it and scrollable content. This also includes the window frame when a scrollbar is along an edge of the window.

Available in Mac OS X v10.0 and later.
kThemeMetricLargeTabHeight

The height of the large tab of a tab control.

Available in Mac OS X v10.0 and later.
kThemeMetricLargeTabCapsWidth

The width of the caps, or end pieces, of the large tabs of a tab control.

Available in Mac OS X v10.0 and later.
kThemeMetricTabFrameOverlap

The amount you must add to the tab height, kThemeMetricLargeTabHeight, to find the rectangle height to use with the various tab drawing primitives. This amount is also the amount that each tab overlaps the tab pane.

Available in Mac OS X v10.0 and later.
kThemeMetricTabIndentOrStyle

If less than zero, this indicates that the text should be centered on each tab. If greater than zero, the text should be justified, according to the system script direction, and the amount is the offset from the edge at which the text should start drawing.

Available in Mac OS X v10.0 and later.
kThemeMetricTabOverlap

The amount of space that every tab's drawing rectangle overlapsthat of the tab on either side of it.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallTabHeight

The height of the small tab of a tab control. This includes the pixels that overlap the tab pane and/or tab pane bar.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallTabCapsWidth

The width of the caps, or end pieces, of the small tabs of a tab control.

Available in Mac OS X v10.0 and later.
kThemeMetricPushButtonHeight

The height and the width of the push button control.

Available in Mac OS X v10.0 and later.
kThemeMetricListHeaderHeight

The height of the list header field of the data browser control.

Available in Mac OS X v10.0 and later.
kThemeMetricDisclosureTriangleHeight

The height of a disclosure triangle control. This triangle is the not the center of the disclosure button, but its own control.

Available in Mac OS X v10.0 and later.
kThemeMetricDisclosureTriangleWidth

The width of a disclosure triangle control.

Available in Mac OS X v10.0 and later.
kThemeMetricLittleArrowsHeight

The height of a little arrows control.

Available in Mac OS X v10.0 and later.
kThemeMetricLittleArrowsWidth

The width of a little arrows control.

Available in Mac OS X v10.0 and later.
kThemeMetricPopupButtonHeight

The height of a popup button control.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallPopupButtonHeight

The height of a small popup button control.

Available in Mac OS X v10.0 and later.
kThemeMetricLargeProgressBarThickness

The height of the large progress bar, not including its shadow.

Available in Mac OS X v10.0 and later.
kThemeMetricPullDownHeight

This metric is not used.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallPullDownHeight

This metric is not used.

Available in Mac OS X v10.0 and later.
kThemeMetricResizeControlHeight

The height of the window grow box control.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallResizeControlHeight

The width of the window grow box control.

Available in Mac OS X v10.0 and later.
kThemeMetricHSliderHeight

The height of the horizontal slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricHSliderTickHeight

The height of the tick marks for a horizontal slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricVSliderWidth

The width of the vertical slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricVSliderTickWidth

The width of the tick marks for a vertical slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricTitleBarControlsHeight

The height of the title bar widgets (grow, close, and zoom boxes) for a document window.

Available in Mac OS X v10.0 and later.
kThemeMetricCheckBoxWidth

The width of the non-label part of a check box control.

Available in Mac OS X v10.0 and later.
kThemeMetricRadioButtonWidth

The width of the non-label part of a radio button control.

Available in Mac OS X v10.0 and later.
kThemeMetricNormalProgressBarThickness

The height of the normal progress bar, not including its shadow.

Available in Mac OS X v10.0 and later.
kThemeMetricProgressBarShadowOutset

The number of pixels of shadow depth drawn below the progress bar.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallProgressBarShadowOutset

The number of pixels of shadow depth drawn below the small progress bar.

Available in Mac OS X v10.0 and later.
kThemeMetricPrimaryGroupBoxContentInset

The number of pixels that the content of a primary group box is inset from the bounds of the control.

Available in Mac OS X v10.0 and later.
kThemeMetricSecondaryGroupBoxContentInset

The number of pixels that the content of a secondary group box is from the bounds of the control.

Available in Mac OS X v10.0 and later.
kThemeMetricMenuMarkColumnWidth

The width allocated to draw the mark character in a menu.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuExcludedMarkColumnWidth

The width allocated for the mark character in a menu item when the menu has the attribute kMenuAttrExcludesMarkColumn.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuMarkIndent

The indent into the interior of the mark column at which the mark character is drawn.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuTextLeadingEdgeMargin

The whitespace at the leading edge of menu item text.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuTextTrailingEdgeMargin

The whitespace at the trailing edge of menu item text.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuIndentWidth

The width per indent level of a menu item. This indent is set by the SetMenuItemIndent function.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuIconTrailingEdgeMargin

The whitespace at the trailing edge of a menu icon, if the item also has text.

Available in Mac OS X v10.1 and later.
kThemeMetricDisclosureButtonHeight

The height of a disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricRoundButtonSize

The height and the width of the round button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallCheckBoxHeight

The height of the non-label part of a small check box control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricDisclosureButtonWidth

The width of a disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallDisclosureButtonHeight

The height of a small disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallDisclosureButtonWidth

The width of a small disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricPaneSplitterHeight

The height (or width if vertical) of a pane splitter. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallPushButtonHeight

The height of the small push button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallRadioButtonHeight

The height of the non-label part of a small radio button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricRelevanceIndicatorHeight

The height of the relevance indicator control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricLargeRoundButtonSize

The height and the width of the large round button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderHeight

The height of the small, horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderTickHeight

The height of the tick marks for a small, horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderWidth

The width of the small, vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderTickWidth

The width of the tick marks for a small, vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallCheckBoxWidth

The width of the non-label part of a small check box control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallRadioButtonWidth

The width of the non-label part of a small radio button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderMinThumbWidth

The minimum width of the thumb of a small, horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderMinThumbHeight

The minimum width of the thumb of a small, vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderTickOffset

The offset of the tick marks from the appropriate side of a small horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderTickOffset

The offset of the tick marks from the appropriate side of a small vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
Discussion

Theme metrics allow you to find out the sizes of interface elements in the current environment, such as how wide a scroll bar is, for example.
Available in Mac OS X v10.0 and later.
kThemeMetricListBoxFrameOutset

The number of pixels that the list box frame is outset from the content of the list box.

Available in Mac OS X v10.0 and later.
kThemeMetricFocusRectOutset

This is a deprecated metric and you should not use it. This metric describes how far from a control the focus rectangle was drawn, but control focus drawing no longer uses this information.

Available in Mac OS X v10.0 and later.
kThemeMetricImageWellThickness

The thickness of the frame drawn by DrawThemeGenericWell.

Available in Mac OS X v10.0 and later.
kThemeMetricScrollBarOverlap

The number of pixels a scrollbar should overlap any bounding box which surrounds it and scrollable content. This also includes the window frame when a scrollbar is along an edge of the window.

Available in Mac OS X v10.0 and later.
kThemeMetricLargeTabHeight

The height of the large tab of a tab control.

Available in Mac OS X v10.0 and later.
kThemeMetricLargeTabCapsWidth

The width of the caps, or end pieces, of the large tabs of a tab control.

Available in Mac OS X v10.0 and later.
kThemeMetricTabFrameOverlap

The amount you must add to the tab height, kThemeMetricLargeTabHeight, to find the rectangle height to use with the various tab drawing primitives. This amount is also the amount that each tab overlaps the tab pane.

Available in Mac OS X v10.0 and later.
kThemeMetricTabIndentOrStyle

If less than zero, this indicates that the text should be centered on each tab. If greater than zero, the text should be justified, according to the system script direction, and the amount is the offset from the edge at which the text should start drawing.

Available in Mac OS X v10.0 and later.
kThemeMetricTabOverlap

The amount of space that every tab's drawing rectangle overlapsthat of the tab on either side of it.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallTabHeight

The height of the small tab of a tab control. This includes the pixels that overlap the tab pane and/or tab pane bar.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallTabCapsWidth

The width of the caps, or end pieces, of the small tabs of a tab control.

Available in Mac OS X v10.0 and later.
kThemeMetricPushButtonHeight

The height and the width of the push button control.

Available in Mac OS X v10.0 and later.
kThemeMetricListHeaderHeight

The height of the list header field of the data browser control.

Available in Mac OS X v10.0 and later.
kThemeMetricDisclosureTriangleHeight

The height of a disclosure triangle control. This triangle is the not the center of the disclosure button, but its own control.

Available in Mac OS X v10.0 and later.
kThemeMetricDisclosureTriangleWidth

The width of a disclosure triangle control.

Available in Mac OS X v10.0 and later.
kThemeMetricLittleArrowsHeight

The height of a little arrows control.

Available in Mac OS X v10.0 and later.
kThemeMetricLittleArrowsWidth

The width of a little arrows control.

Available in Mac OS X v10.0 and later.
kThemeMetricPopupButtonHeight

The height of a popup button control.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallPopupButtonHeight

The height of a small popup button control.

Available in Mac OS X v10.0 and later.
kThemeMetricLargeProgressBarThickness

The height of the large progress bar, not including its shadow.

Available in Mac OS X v10.0 and later.
kThemeMetricPullDownHeight

This metric is not used.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallPullDownHeight

This metric is not used.

Available in Mac OS X v10.0 and later.
kThemeMetricResizeControlHeight

The height of the window grow box control.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallResizeControlHeight

The width of the window grow box control.

Available in Mac OS X v10.0 and later.
kThemeMetricHSliderHeight

The height of the horizontal slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricHSliderTickHeight

The height of the tick marks for a horizontal slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricVSliderWidth

The width of the vertical slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricVSliderTickWidth

The width of the tick marks for a vertical slider control.

Available in Mac OS X v10.0 and later.
kThemeMetricTitleBarControlsHeight

The height of the title bar widgets (grow, close, and zoom boxes) for a document window.

Available in Mac OS X v10.0 and later.
kThemeMetricCheckBoxWidth

The width of the non-label part of a check box control.

Available in Mac OS X v10.0 and later.
kThemeMetricRadioButtonWidth

The width of the non-label part of a radio button control.

Available in Mac OS X v10.0 and later.
kThemeMetricNormalProgressBarThickness

The height of the normal progress bar, not including its shadow.

Available in Mac OS X v10.0 and later.
kThemeMetricProgressBarShadowOutset

The number of pixels of shadow depth drawn below the progress bar.

Available in Mac OS X v10.0 and later.
kThemeMetricSmallProgressBarShadowOutset

The number of pixels of shadow depth drawn below the small progress bar.

Available in Mac OS X v10.0 and later.
kThemeMetricPrimaryGroupBoxContentInset

The number of pixels that the content of a primary group box is inset from the bounds of the control.

Available in Mac OS X v10.0 and later.
kThemeMetricSecondaryGroupBoxContentInset

The number of pixels that the content of a secondary group box is from the bounds of the control.

Available in Mac OS X v10.0 and later.
kThemeMetricMenuMarkColumnWidth

The width allocated to draw the mark character in a menu.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuExcludedMarkColumnWidth

The width allocated for the mark character in a menu item when the menu has the attribute kMenuAttrExcludesMarkColumn.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuMarkIndent

The indent into the interior of the mark column at which the mark character is drawn.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuTextLeadingEdgeMargin

The whitespace at the leading edge of menu item text.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuTextTrailingEdgeMargin

The whitespace at the trailing edge of menu item text.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuIndentWidth

The width per indent level of a menu item. This indent is set by the SetMenuItemIndent function.

Available in Mac OS X v10.1 and later.
kThemeMetricMenuIconTrailingEdgeMargin

The whitespace at the trailing edge of a menu icon, if the item also has text.

Available in Mac OS X v10.1 and later.
kThemeMetricDisclosureButtonHeight

The height of a disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricRoundButtonSize

The height and the width of the round button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallCheckBoxHeight

The height of the non-label part of a small check box control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricDisclosureButtonWidth

The width of a disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallDisclosureButtonHeight

The height of a small disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallDisclosureButtonWidth

The width of a small disclosure button. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricPaneSplitterHeight

The height (or width if vertical) of a pane splitter. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallPushButtonHeight

The height of the small push button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallRadioButtonHeight

The height of the non-label part of a small radio button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricRelevanceIndicatorHeight

The height of the relevance indicator control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricLargeRoundButtonSize

The height and the width of the large round button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderHeight

The height of the small, horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderTickHeight

The height of the tick marks for a small, horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderWidth

The width of the small, vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderTickWidth

The width of the tick marks for a small, vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallCheckBoxWidth

The width of the non-label part of a small check box control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallRadioButtonWidth

The width of the non-label part of a small radio button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderMinThumbWidth

The minimum width of the thumb of a small, horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderMinThumbHeight

The minimum width of the thumb of a small, vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderTickOffset

The offset of the tick marks from the appropriate side of a small horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderTickOffset

The offset of the tick marks from the appropriate side of a small vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
Discussion

Theme metrics allow you to find out the sizes of interface elements in the current environment, such as how wide a scroll bar is, for example.
Available in Mac OS X v10.0 and later.
kThemeMetricSmallRadioButtonWidth

The width of the non-label part of a small radio button control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderMinThumbWidth

The minimum width of the thumb of a small, horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderMinThumbHeight

The minimum width of the thumb of a small, vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallHSliderTickOffset

The offset of the tick marks from the appropriate side of a small horizontal slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
kThemeMetricSmallVSliderTickOffset

The offset of the tick marks from the appropriate side of a small vertical slider control. (Mac OS X only.)

Available in Mac OS X v10.0 and later.
Discussion

Theme metrics allow you to find out the sizes of interface elements in the current environment, such as how wide a scroll bar is, for example.*/
enum {
   kThemeMetricScrollBarWidth = 0,
   kThemeMetricSmallScrollBarWidth = 1,
   kThemeMetricCheckBoxHeight = 2,
   kThemeMetricRadioButtonHeight = 3,
   kThemeMetricEditTextWhitespace = 4,
   kThemeMetricEditTextFrameOutset = 5,
   kThemeMetricListBoxFrameOutset = 6,
   kThemeMetricFocusRectOutset = 7,
   kThemeMetricImageWellThickness = 8,
   kThemeMetricScrollBarOverlap = 9,
   kThemeMetricLargeTabHeight = 10,
   kThemeMetricLargeTabCapsWidth = 11,
   kThemeMetricTabFrameOverlap = 12,
   kThemeMetricTabIndentOrStyle = 13,
   kThemeMetricTabOverlap = 14,
   kThemeMetricSmallTabHeight = 15,
   kThemeMetricSmallTabCapsWidth = 16,
   kThemeMetricPushButtonHeight = 19,
   kThemeMetricListHeaderHeight = 20,
   kThemeMetricDisclosureTriangleHeight = 25,
   kThemeMetricDisclosureTriangleWidth = 26,
   kThemeMetricLittleArrowsHeight = 27,
   kThemeMetricLittleArrowsWidth = 28,
   kThemeMetricPopupButtonHeight = 30,
   kThemeMetricSmallPopupButtonHeight = 31,
   kThemeMetricLargeProgressBarThickness = 32,
   kThemeMetricPullDownHeight = 33,
   kThemeMetricSmallPullDownHeight = 34,
   kThemeMetricResizeControlHeight = 38,
   kThemeMetricSmallResizeControlHeight = 39,
   kThemeMetricHSliderHeight = 41,
   kThemeMetricHSliderTickHeight = 42,
   kThemeMetricVSliderWidth = 45,
   kThemeMetricVSliderTickWidth = 46,
   kThemeMetricTitleBarControlsHeight = 49,
   kThemeMetricCheckBoxWidth = 50,
   kThemeMetricRadioButtonWidth = 52,
   kThemeMetricNormalProgressBarThickness = 58,
   kThemeMetricProgressBarShadowOutset = 59,
   kThemeMetricSmallProgressBarShadowOutset = 60,
   kThemeMetricPrimaryGroupBoxContentInset = 61,
   kThemeMetricSecondaryGroupBoxContentInset = 62,
   kThemeMetricMenuMarkColumnWidth = 63,
   kThemeMetricMenuExcludedMarkColumnWidth = 64,
   kThemeMetricMenuMarkIndent = 65,
   kThemeMetricMenuTextLeadingEdgeMargin = 66,
   kThemeMetricMenuTextTrailingEdgeMargin = 67,
   kThemeMetricMenuIndentWidth = 68,
   kThemeMetricMenuIconTrailingEdgeMargin = 69
};
enum {
   kThemeMetricDisclosureButtonHeight = 17,
   kThemeMetricRoundButtonSize = 18,
   kThemeMetricSmallCheckBoxHeight = 21,
   kThemeMetricDisclosureButtonWidth = 22,
   kThemeMetricSmallDisclosureButtonHeight = 23,
   kThemeMetricSmallDisclosureButtonWidth = 24,
   kThemeMetricPaneSplitterHeight = 29,
   kThemeMetricSmallPushButtonHeight = 35,
   kThemeMetricSmallRadioButtonHeight = 36,
   kThemeMetricRelevanceIndicatorHeight = 37,
   kThemeMetricLargeRoundButtonSize = 40,
   kThemeMetricSmallHSliderHeight = 43,
   kThemeMetricSmallHSliderTickHeight = 44,
   kThemeMetricSmallVSliderWidth = 47,
   kThemeMetricSmallVSliderTickWidth = 48,
   kThemeMetricSmallCheckBoxWidth = 51,
   kThemeMetricSmallRadioButtonWidth = 53,
   kThemeMetricSmallHSliderMinThumbWidth = 54,
   kThemeMetricSmallVSliderMinThumbHeight = 55,
   kThemeMetricSmallHSliderTickOffset = 56,
   kThemeMetricSmallVSliderTickOffset = 57
};
typedef UInt32 ThemeMetric;



/*Theme Cursors

Identify types of cursors.

enum {
   kThemeArrowCursor = 0,
   kThemeCopyArrowCursor = 1,
   kThemeAliasArrowCursor = 2,
   kThemeContextualMenuArrowCursor = 3,
   kThemeIBeamCursor = 4,
   kThemeCrossCursor = 5,
   kThemePlusCursor = 6,
   kThemeWatchCursor = 7,
   kThemeClosedHandCursor = 8,
   kThemeOpenHandCursor = 9,
   kThemePointingHandCursor = 10,
   kThemeCountingUpHandCursor = 11,
   kThemeCountingDownHandCursor = 12,
   kThemeCountingUpAndDownHandCursor = 13,
   kThemeSpinningCursor = 14,
   kThemeResizeLeftCursor = 15,
   kThemeResizeRightCursor = 16,
   kThemeResizeLeftRightCursor = 17,
   kThemeNotAllowedCursor = 18
};
typedef UInt32 ThemeCursor;
Constants
kThemeArrowCursor

The cursor identified by this constant is typically used as the standard cursor.

Available in Mac OS X v10.0 and later.
kThemeCopyArrowCursor

The cursor identified by this constant is typically used when the cursor is over a location where a drag action would initiate a copy.

Available in Mac OS X v10.0 and later.
kThemeAliasArrowCursor

The cursor identified by this constant is typically used when the cursor is over a location where a drag action would create an alias or link.

Available in Mac OS X v10.0 and later.
kThemeContextualMenuArrowCursor

The cursor identified by this constant is typically used when the Control key is being pressed and the cursor is over a location where a contextual menu can be activated. 

Available in Mac OS X v10.0 and later.
kThemeIBeamCursor

The cursor identified by this constant is typically used when the cursor is over an area where the user can select text.

Available in Mac OS X v10.0 and later.
kThemeCrossCursor

The cursor identified by this constant is typically used when the cursor is over an area where the user can draw graphics.

Available in Mac OS X v10.0 and later.
kThemePlusCursor

The cursor identified by this constant is typically used when the cursor is over an area where the user can select table cells.

Available in Mac OS X v10.0 and later.
kThemeWatchCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress. You can animate this cursor so that a hand of the watch appears to move.

Available in Mac OS X v10.0 and later.
kThemeClosedHandCursor

The cursor identified by this constant is typically used to indicate that an object has been grabbed and is being moved by the user.

Available in Mac OS X v10.0 and later.
kThemeOpenHandCursor

The cursor identified by this constant is typically used to indicate that an object may be grabbed or moved by the user.

Available in Mac OS X v10.0 and later.
kThemePointingHandCursor

The cursor identified by this constant has the appearance of a pointing hand. You would typically use this constant to indicate that the user may select an object by pressing the mouse button.

Available in Mac OS X v10.0 and later.
kThemeCountingUpHandCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress. You can animate this cursor so that the fingers appear to open from the palm one by one.

Available in Mac OS X v10.0 and later.
kThemeCountingDownHandCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress. You can animate this cursor so that the fingers appear to fold into the palm one by one.

Available in Mac OS X v10.0 and later.
kThemeCountingUpAndDownHandCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress. You can animate this cursor so that the fingers appear to alternate between opening from the palm one by one and folding into the palm one by one.

Available in Mac OS X v10.0 and later.
kThemeSpinningCursor

The cursor identified by this constant is typically used to indicate that an operation is in progress.

Available in Mac OS X v10.0 and later.
kThemeResizeLeftCursor

The cursor identified by this constant is typically used to indicate that an object may be resized by dragging to the left. 

Available in Mac OS X v10.0 and later.
kThemeResizeRightCursor

The cursor identified by this constant is typically used to indicate that an object may be resized by dragging to the right.

Available in Mac OS X v10.0 and later.
kThemeResizeLeftRightCursor

The cursor identified by this constant is typically used to indicate that an object may be resized in either direction horizontally.

Available in Mac OS X v10.0 and later.
Discussion

You can pass constants of type ThemeCursor to the functions SetThemeCursor and SetAnimatedThemeCursor to specify the category of cursor to be displayed for your application. The Appearance Manager substitutes the theme-specific instance of the cursor for the cursor category as is appropriate. The ThemeCursor constants are available with Appearance Manager 1.1 and later.*/
enum {
   kThemeArrowCursor = 0,
   kThemeCopyArrowCursor = 1,
   kThemeAliasArrowCursor = 2,
   kThemeContextualMenuArrowCursor = 3,
   kThemeIBeamCursor = 4,
   kThemeCrossCursor = 5,
   kThemePlusCursor = 6,
   kThemeWatchCursor = 7,
   kThemeClosedHandCursor = 8,
   kThemeOpenHandCursor = 9,
   kThemePointingHandCursor = 10,
   kThemeCountingUpHandCursor = 11,
   kThemeCountingDownHandCursor = 12,
   kThemeCountingUpAndDownHandCursor = 13,
   kThemeSpinningCursor = 14,
   kThemeResizeLeftCursor = 15,
   kThemeResizeRightCursor = 16,
   kThemeResizeLeftRightCursor = 17,
   kThemeNotAllowedCursor = 18
};
typedef UInt32 ThemeCursor;

/*MenuItemDrawingUPP

Defines a universal procedure pointer (UPP) to a menu item drawing function.

typedef MenuItemDrawingProcPtr MenuItemDrawingUPP;
Discussion

See MenuItemDrawingProcPtr for more information.*/
typedef MenuItemDrawingProcPtr MenuItemDrawingUPP;

/*kThemeScrollBar

Obsolete. Use the constants described in "Theme Track Kinds" instead.

enum {
   kThemeScrollBar               = kThemeMediumScrollBar,
   kThemeSlider                  = kThemeMediumSlider,
   kThemeProgressBar             = kThemeMediumProgressBar,
   kThemeIndeterminateBar        = kThemeMediumIndeterminateBar
};*/
enum {
   kThemeScrollBar               = kThemeMediumScrollBar,
   kThemeSlider                  = kThemeMediumSlider,
   kThemeProgressBar             = kThemeMediumProgressBar,
   kThemeIndeterminateBar        = kThemeMediumIndeterminateBar
};

/*SliderTrackInfo

Describes the slider-specific features of a given track control. 

struct SliderTrackInfo {
   ThemeThumbDirection thumbDir;
   ThemeTrackPressState pressState;
};
typedef struct SliderTrackInfo SliderTrackInfo;
Fields
thumbDir

A value of type ThemeThumbDirection, specifying the direction in which the slider indicator points. See “Theme Thumb Directions” for descriptions of possible values.
pressState

A value of type ThemeTrackPressState, specifying the part of the slider that is currently pressed. See “Theme Track Press States” for descriptions of possible values. Pass 0 if nothing is currently pressed.
Discussion

Your application supplies a SliderTrackInfo structure to the ThemeTrackDrawInfo structure.
Version Notes

The SliderTrackInfo structure is available with Appearance Manager 1.1 and later.
Availability
Available in Mac OS X v10.0 and later.*/
struct SliderTrackInfo {
   ThemeThumbDirection thumbDir;
   ThemeTrackPressState pressState;
};
typedef struct SliderTrackInfo SliderTrackInfo;


/*ScrollBarTrackInfo

Describes the scroll bar–specific features of a given track control.

struct ScrollBarTrackInfo {
   SInt32 viewsize;
   ThemeTrackPressState pressState;
};
typedef struct ScrollBarTrackInfo ScrollBarTrackInfo;
Fields
viewsize

A signed 32-bit integer, specifying the size of the content being displayed. This value should be expressed in terms of the same units of measurement as are used for the minimum, maximum, and current settings of the scroll bar.
pressState

A value of type ThemeTrackPressState, specifying what in the scroll bar is currently pressed. See “Theme Track Press States” for descriptions of possible values. Pass 0 if nothing is currently pressed.
Discussion

Your application uses the ScrollBarTrackInfo structure in the ThemeTrackDrawInfo structure.
Version Notes

The ScrollBarTrackInfo structure is available with Appearance Manager 1.1 and later.
Availability
Available in Mac OS X v10.0 and later.*/
struct ScrollBarTrackInfo {
   SInt32 viewsize;
   ThemeTrackPressState pressState;
};
typedef struct ScrollBarTrackInfo ScrollBarTrackInfo;

/*ProgressTrackInfo

Describes the progress bar–specific features of a given track control.

struct ProgressTrackInfo {
   UInt8 phase;
};
typedef struct ProgressTrackInfo ProgressTrackInfo;
Fields
phase

A value specifying the current animation phase for an indeterminate progress bar. You can pass any value of type UInt8. Increment this value to animate the progress bar. Set this field to 0 for a determinate progress bar.
Discussion

Your application supplies a ProgressTrackInfo structure in the ThemeTrackDrawInfo structure.
Version Notes

The ProgressTrackInfo structure is available with Appearance Manager 1.1 and later.
Availability
Available in Mac OS X v10.0 and later.*/
struct ProgressTrackInfo {
   UInt8 phase;
};
typedef struct ProgressTrackInfo ProgressTrackInfo;

/*ThemeTrackDrawInfo

Describes a track control.

struct ThemeTrackDrawInfo {
   ThemeTrackKind kind
   Rect bounds
   SInt32 min
   SInt32 max
   SInt32 value
   UInt32 reserved
   ThemeTrackAttributes attributes
   ThemeTrackEnableState enableState
   UInt8 filler1
   union {
      ScrollBarTrackInfo scrollbar;
      SliderTrackInfo slider;
      ProgressTrackInfo progress;
   } trackInfo;
};
typedef struct ThemeTrackDrawInfo ThemeTrackDrawInfo;
Fields
kind

A value of type ThemeTrackKind, specifying the type of track to be drawn. See “Theme Track Kinds” for descriptions of possible values.
bounds

A structure of type Rect specifying the dimensions and position of the track, in local coordinates.
min

A signed 32-bit integer specifying the minimum value for the track.
max

A signed 32-bit integer specifying the maximum value for the track.
value

A signed 32-bit integer specifying the current value for the track.
reserved

Reserved.
attributes

A value of type ThemeTrackAttributes specifying additional attributes of the track, such as whether the track has an indicator. See “Theme Track Attributes” for descriptions of possible values.
enableState

A value of type ThemeTrackEnableState specifying the current state of the track control; see “Theme Track States” for descriptions of possible values.
filler1
trackInfo

A union of the ScrollBarTrackInfo, SliderTrackInfo, and ProgressTrackInfo structures. Your application fills in the structure that is appropriate for the kind of track with which you are working. See ScrollBarTrackInfo, SliderTrackInfo, and ProgressTrackInfo for details on these structures. 
Discussion

Your application fills out the applicable fields of a ThemeTrackDrawInfo structure to fully describe any given track control. 
Version Notes

The ThemeTrackDrawInfo structure is available with Appearance Manager 1.1 and later.
Availability
Available in Mac OS X v10.0 and later.*/
struct ThemeTrackDrawInfo {
   ThemeTrackKind kind;
   Rect bounds;
   SInt32 min;
   SInt32 max;
   SInt32 value;
   UInt32 reserved;
   ThemeTrackAttributes attributes;
   ThemeTrackEnableState enableState;
   UInt8 filler1;
   union {
      ScrollBarTrackInfo scrollbar;
      SliderTrackInfo slider;
      ProgressTrackInfo progress;
   } trackInfo;
};
typedef struct ThemeTrackDrawInfo ThemeTrackDrawInfo;

/*ThemeEraseProcPtr

Draws a background.

typedef void (*ThemeEraseProcPtr) (
   const Rect * bounds,
   UInt32 eraseData,
   SInt16 depth,
   Boolean isColorDev
);

If you name your function MyThemeEraseCallback, you would declare it like this:

void MyThemeEraseCallback (
   const Rect * bounds,
   UInt32 eraseData,
   SInt16 depth,
   Boolean isColorDev
);
Parameters
bounds

A pointer to a structure of type Rect. The rectangle you are passed is set to the area in which you should draw. Your drawing function is called clipped to the rectangle in which you are allowed to draw; do not draw outside this region.
eraseData

An unsigned 32-bit value. You are passed data specifying how to draw, from the eraseData parameter of DrawThemeChasingArrows, DrawThemePopupArrow, DrawThemeTrack, or DrawThemeTrackTickMarks or from the inUserData parameter of DrawThemeButton.
depth

A signed 16-bit value. You are passed the bit depth (in bits per pixel) of the current graphics port.
isColorDev

A value of type Boolean. If true, indicates that you are drawing on a color device; a value of false indicates a monochrome device.
Discussion

At the time your drawing function is called, the foreground text color and mode is already set to draw in the correct state (active or inactive) and correct color for the theme. You do not need to set the color unless you have special drawing needs. If you do have special drawing needs, you should supply the depth value and the value of the isColorDevice parameter to the function IsThemeInColor to determine whether or not you should draw in color. Note that the Appearance Manager calls your MyThemeEraseCallback function for every device that the bounds rectangle intersects, so your application does not need to call the DeviceLoop function itself.

You should refer to your MyThemeEraseCallback function using a ThemeEraseUPP, which you can create with the NewThemeEraseUPP function.

You typically use the NewThemeEraseUPP function like this:ThemeEraseUPP myThemeEraseUPP;
myThemeEraseUPP = NewThemeEraseUPP(MyThemeEraseCallback);

Version Notes

This function is available with Appearance Manager 1.1 and later.*/
typedef void (*ThemeEraseProcPtr) (
   const Rect * bounds,
   UInt32 eraseData,
   SInt16 depth,
   Boolean isColorDev
);

/*ThemeEraseUPP

Defines a universal procedure pointer (UPP) to a background drawing callback function.

typedef ThemeEraseProcPtr ThemeEraseUPP;*/
typedef ThemeEraseProcPtr ThemeEraseUPP;

//function


/*SetThemeCursor

Sets the cursor to a version of the specified cursor type that is consistent with the current theme.

OSStatus SetThemeCursor (
   ThemeCursor inCursor
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of possible values.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors. Because these are color cursors, they currently cannot be set from interrupt time. 

Your application should call the SetThemeCursor function to ensure that its cursors are theme-compliant, rather than the QuickDraw cursor utilities functions SetCursor or SetCCursor. If you wish an animatable cursor to be theme-compliant, call the function SetAnimatedThemeCursor. 
Special Considerations

Do not call SetThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemeCursor (
   ThemeCursor inCursor
);

/*SetAnimatedThemeCursor

Animates a version of the specified cursor type that is consistent with the current theme.

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
);
Parameters
inCursor

A value of type ThemeCursor. Pass a constant specifying the type of cursor to set; see “Theme Cursors” for a description of the possible values. Note that only cursors designated as able to be animated should be used for this function. If you specify an unanimatable cursor type, SetAnimatedThemeCursor returns the error themeBadCursorIndexErr (–30565).
inAnimationStep

An unsigned 32-bit value. Pass a value specifying the current animation step of the cursor. To animate the cursor, increment the value by 1 with each call to SetAnimatedThemeCursor.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Appearance Manager 1.1 introduces cursors that can change appearance with a theme change. In order to be theme-compliant, your program should use these theme-specific cursors whenever possible, instead of the classic black-and-white cursors.

Your application should call the SetAnimatedThemeCursor function to ensure that its animated cursors are theme-compliant, rather than using any QuickDraw cursor utilities functions such as SetCursor, SetCCursor, SpinCursor, or RotateCursor. If you wish a non-animated cursor to be theme-compliant, call the function SetThemeCursor.

Because these are color cursors, they currently cannot be set from interrupt time. Therefore, if you support animated cursors that are changed at interrupt time you should continue to use your own cursors for now. 
Special Considerations

Do not call SetAnimatedThemeCursor at interrupt time.
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus SetAnimatedThemeCursor (
   ThemeCursor inCursor,
   UInt32 inAnimationStep
);

/*GetThemeMetric

OSStatus GetThemeMetric (
   ThemeMetric inMetric,
   SInt32 * outMetric
);
Return Value

A result code. See “Appearance Manager Result Codes”.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetThemeMetric (
   ThemeMetric inMetric,
   SInt32 * outMetric
);

/*DrawThemeTextBox

Draws text into the area you specify.

OSStatus DrawThemeTextBox (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   const Rect * inBoundingBox,
   SInt16 inJust,
   void * inContext
);
Parameters
inString

A CFStringRef containing the unicode characters you wish to render. You must not pass in a CFStringRef that was allocated with any of the "NoCopy" CFString creation functions; a string created with a "NoCopy" function has transient storage which is incompatible with DrawThemeTextBox's caches.
inFontID

The ThemeFontID describing the font you'd like to render the text with. See “Theme Font IDs” for the values you can use here.
inState

The ThemeDrawState describing the state of the interface element you are drawing the text for. If, for example, you are drawing text for an inactive window, you would pass kThemeStateInactive. The ThemeDrawState is generally only used to determine the shadow characteristics for the text on Mac OS X. 

See “Theme Drawing States” for the values you can use here.

Note that the ThemeDrawState does not imply a color. It is not used as a mechanism for graying the text. If you wish to draw grayed text, you must set up the desired gray color and apply it to either the current QuickDraw port or the CGContextRef, as appropriate.
inWrapToWidth

A Boolean value indicating whether you want to draw multiple lines of text wrapped to a bounding box. False indicates that only one line of text should be drawn without any sort of wrapping.
inBoundingBox

The rectangle, in coordinates relative to the current QuickDraw port, describing the area to draw the text within. The first line of text will be top-justified to this rectangle. Wrapping, if desired, will happen at the horizontal extent of this rectangle. Regardless of the amount of text in your CFStringRef, all drawn text will be clipped to this rectangle.
inJust

The horizontal alignment you would like for your text. You can use one of the standard alignment constants from TextEdit.h.
inContext

The CGContextRef into which you would like to draw the text. On Mac OS X, all text drawing happens in CGContextRefs; if you pass NULL, a transient CGContextRef will be allocated and deallocated for use within the single function call. Relying on the system behavior if transiently creating CGContextRefs may result in performance problems. On Mac OS 9, this parameter is ignored.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

DrawThemeTextBox allows you to draw theme-savvy —that is, Aqua-savvy on Mac OS X— text. It is unicode savvy, although only partially so under CarbonLib, and allows you to customize certain text rendering characteristics such as the font, wrapping behavior, and justification. The text is drawn into the CGContextRef you provide, or into the current QuickDraw port if no CGContextRef is provided. None of DrawThemeTextBox's parameters imply a color, so you must set up the desired text color separately before calling DrawThemeTextBox. If you provide a CGContextRef, its fill color will be used to draw the text. If you do not provide a CGContextRef, a color based on the current QuickDraw port's foreground color and the grayishTextOr mode, if set, will be used to draw the text.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeTextBox (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   const Rect * inBoundingBox,
   SInt16 inJust,
   void * inContext
);

/*GetThemeBrushAsColor

Obtains the color that corresponds to a given theme brush type under the current theme.

OSStatus GetThemeBrushAsColor (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
);
Parameters
inBrush

A value of type ThemeBrush. Pass a constant specifying the theme brush type for which you wish to obtain a color; see “Theme Brushes” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inColorDev

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
outColor

A pointer to a structure of type RGBColor. On return, the structure contains a color corresponding to the color or pattern used by the specified theme brush under the current theme. 
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The GetThemeBrushAsColor function obtains a color that corresponds to that which is in use for a specified theme brush. If, in the current theme, the specified brush draws with a pattern instead of a color, a theme-specified approximate color is obtained. Your application should call GetThemeBrushAsColor only when you must use an RGBColor value for a specific operation; typically, your application should call the functions SetThemeBackground and SetThemePen for greatest fidelity with the current theme. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus GetThemeBrushAsColor (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
);

/*GetTheme

Obtains a collection containing data describing the current theme.

OSStatus GetTheme (
   Collection ioCollection
);
Parameters
ioCollection

A value of type Collection. Pass a reference to a collection object, such as that created by calling the Collection Manager function NewCollection. On return, the collection contains data describing attributes of the current theme. 
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The GetTheme function obtains a collection containing a copy of the data for the current theme. The theme data is in the form of collection items, each corresponding to an attribute of the theme. For a given theme, the actual number of collection items may vary, depending upon how fully the theme’s attributes are specified. See “Theme Collection Tags” for descriptions of the possible theme collection items.

Your application can use theme collection tags, along with various Collection Manager functions, to access the data in the collection.

Also see the function SetTheme. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetTheme (
   Collection ioCollection
);

/*GetThemeMenuItemExtra

Obtains a measurement of the space surrounding a menu item.

OSStatus GetThemeMenuItemExtra (
   ThemeMenuItemType inItemType,
   SInt16 * outHeight,
   SInt16 * outWidth
);
Parameters
inItemType

A value of type ThemeMenuItemType. Pass a constant identifying the type of menu item for which you are interested in getting a measurement. See “Theme Menu Item Types”.
outHeight

A pointer to a signed 16-bit integer. On return, the integer value represents the total amount of padding between the content of the menu item and the top and bottom of its frame (in pixels). Your content’s height plus the measurement provided by the outHeight parameter equals the total item height.
outWidth

A pointer to a signed 16-bit integer. On return, the integer value represents the total amount of padding between the content of the menu item and the left and right limits of the menu (in pixels). Your content’s width plus the measurement provided by the outWidth parameter equals the total item width.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application should call the GetThemeMenuItemExtra function when you are writing your own menu definition function and wish to be theme-compliant. Once you have determined the height and width of the content of a menu item, call GetThemeMenuItemExtra to get a measurement in pixels of the space surrounding a menu item, including any necessary inter-item spacing, in the current theme. By combining the values for your menu item’s content and the extra padding needed by the theme, you can derive the size of the rectangle needed to encompass both the content and the theme element together. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetThemeMenuItemExtra (
   ThemeMenuItemType inItemType,
   SInt16 * outHeight,
   SInt16 * outWidth
);

/*UseThemeFont

Sets the font of the current graphics port to one of the current theme’s system fonts.

OSStatus UseThemeFont (
   ThemeFontID inFontID,
   ScriptCode inScript
);
Parameters
inFontID

A value of type ThemeFontID. Pass a constant specifying the kind of font (that is, the current large, small, or small emphasized system fonts or the views font) to be applied to the current port. See “Theme Font IDs” for descriptions of possible values.
inScript

A value of type ScriptCode. Pass a script code specifying the script system for which you wish to set the current font; you may pass the metascript code smSystemScript to specify the system script.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application can call the UseThemeFont function to draw text in one of the current theme’s system fonts.

Also see the function GetThemeFont. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/


OSStatus UseThemeFont (
   ThemeFontID inFontID,
   ScriptCode inScript
);

/*GetThemeTextDimensions

Tells you the height, width, and baseline for a string.

OSStatus GetThemeTextDimensions (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   Point * ioBounds,
   SInt16 * outBaseline
);
Parameters
inString

A CFStringRef containing the unicode characters you wish to measure. You must not pass in a CFStringRef that was allocated with any of the "NoCopy" CFString creation functions, as mentioned in the description of the DrawThemeTextBox function.
inFontID

The ThemeFontID describing the font you'd like to measure the text with. See “Theme Font IDs” for the values you can use here.
inState

The ThemeDrawState which matches the state you will ultimately render the string with. Drawing state may affect text measurement, so you should be sure the value you pass to GetThemeTextDimensions matches the value you will eventually use for drawing. See “Theme Drawing States” for the values you can use here.
inWrapToWidth

A Boolean indicating whether you want the measurements based on wrapping the text to a specific width. If you pass true, you must specify the desired width in ioBounds->h.
ioBounds

On output, ioBounds->v contains the height of the text. If you pass false in the inWrapToWidth parameter, ioBounds->h will contain the width of the text on output. If you pass true in inWrapToWidth, ioBounds->h must (on input) contain the desired width for wrapping; on output, ioBounds->h contains the same value you specified on input.
outBaseline

On output, outBaseline contains the offset (in QuickDraw space) from the bottom edge of the last line of text to the baseline of the first line of text. outBaseline will generally be a negative value.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

GetThemeTextDimensions measures the given string using the font and drawing state you specify. It always reports the actual height and baseline. It sometimes reports the actual width. It can measure a string that wraps. It is unicode savvy, although only partially so under CarbonLib.
Availability
Available in CarbonLib 1.3 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus GetThemeTextDimensions (
   CFStringRef inString,
   ThemeFontID inFontID,
   ThemeDrawState inState,
   Boolean inWrapToWidth,
   Point * ioBounds,
   SInt16 * outBaseline
);

/*DrawThemeMenuItem

Draws a menu item.

OSStatus DrawThemeMenuItem (
   const Rect * inMenuRect,
   const Rect * inItemRect,
   SInt16 inVirtualMenuTop,
   SInt16 inVirtualMenuBottom,
   ThemeMenuState inState,
   ThemeMenuItemType inItemType,
   MenuItemDrawingUPP inDrawProc,
   UInt32 inUserData
);
Parameters
inMenuRect

A pointer to a structure of type Rect. Before calling DrawThemeMenuItem, set the rectangle to contain the entire menu, in global coordinates. This is the actual menu rectangle as used in your menu definition function.
inItemRect

A pointer to a structure of type Rect. Before calling DrawThemeMenuItem, set the rectangle to contain the menu item, in global coordinates. The menu item’s background is drawn in the rectangle passed in the inItemRect parameter. You should calculate the size of the menu item’s content and then call GetThemeMenuItemExtra to get the amount of padding surrounding menu items in the current theme; the width and height of the menu item rectangle are determined by adding these values together.
inVirtualMenuTop

A signed 16-bit integer. Pass a value representing the actual top of the menu. Normally this value is the top coordinate of the rectangle supplied in the inMenuRect parameter. This value could be different, however, if a menu is scrolled or bigger than can be displayed in the menu rectangle. You typically pass the value of the global variable TopMenuItem into this parameter if you are writing a custom menu definition function.
inVirtualMenuBottom

A signed 16-bit integer. Pass a value representing the actual bottom of the menu. Typically this value is the bottom coordinate of the rectangle supplied in the inMenuRect parameter. This value could be different, however, if a menu is scrolled or bigger than can be displayed in the menu rectangle. You typically pass the value of the global variable AtMenuBottom into this parameter if you are writing a custom menu definition function.
inState

A value of type ThemeMenuState. Pass a constant specifying the state (active, selected, or disabled) in which to draw the menu item; see “Theme Menu States”.
inItemType

A value of type ThemeMenuItemType. If you pass kThemeMenuItemScrollUpArrow or kThemeMenuItemScrollDownArrow, then you should pass NULL for the inDrawProc parameter, since there is no content to be drawn. If you pass kThemeMenuItemHierarchical, the hierarchical arrow is drawn for you. See “Theme Menu Item Types” for descriptions of possible values.
inDrawProc

A value of type MenuItemDrawingUPP. Pass a universal function pointer to a menu item drawing function such as MenuItemDrawingProcPtr. The value of the inDrawProc parameter can be a valid universal function pointer or NULL.
inUserData

An unsigned 32-bit integer. Provide any data to be passed in to the inUserData parameter of MenuItemDrawingProcPtr.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeMenuItem function draws a theme-compliant menu item. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeMenuItem (
   const Rect * inMenuRect,
   const Rect * inItemRect,
   SInt16 inVirtualMenuTop,
   SInt16 inVirtualMenuBottom,
   ThemeMenuState inState,
   ThemeMenuItemType inItemType,
   MenuItemDrawingUPP inDrawProc,
   UInt32 inUserData
);

/*GetThemeMenuSeparatorHeight

Obtains the height of a menu separator line.

OSStatus GetThemeMenuSeparatorHeight (
   SInt16 * outHeight
);
Parameters
outHeight

A pointer to a signed 16-bit integer. On return, the integer value represents the height (in pixels) of the menu separator line.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The GetThemeMenuSeparatorHeight function obtains the height of a menu separator line under the current theme. Your application should call the GetThemeMenuSeparatorHeight function when you are writing your own menu definition function and wish to calculate a menu rectangle for a separator to match the current theme. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus GetThemeMenuSeparatorHeight (
   SInt16 * outHeight
);

/*NormalizeThemeDrawingState

Sets the current graphics port to a default drawing state.

OSStatus NormalizeThemeDrawingState (
);
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The NormalizeThemeDrawingState function sets the background of a graphics port to white; the pen of the port to a size of 1 pixel by 1 pixel, a pattern mode of patCopy, and a pattern of black; and the text mode of the port to srcOr. NormalizeThemeDrawingState also flushes from memory any color foreground or background patterns saved in the port’s GrafPort.pnPat or GrafPort.bkPat fields, respectively. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus NormalizeThemeDrawingState (
);

/*DrawThemeMenuSeparator

Draws a menu item separator line.

OSStatus DrawThemeMenuSeparator (
   const Rect * inItemRect
);
Parameters
inItemRect

A pointer to a structure of type Rect. Before calling DrawThemeMenuSeparator, set the rectangle to contain the menu item separator to be drawn, in global coordinates. The rectangle should be the same height as the height returned by the function GetThemeMenuSeparatorHeight.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeMenuSeparator function draws a theme-compliant menu item separator line. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeMenuSeparator (
   const Rect * inItemRect
);


/*NewMenuItemDrawingUPP

Creates a new universal procedure pointer (UPP) to a menu item drawing function.

MenuItemDrawingUPP NewMenuItemDrawingUPP (
   MenuItemDrawingProcPtr userRoutine
);
Return Value

A UPP. See MenuItemDrawingProcPtr for information on the menu item drawing function. See the description of the MenuItemDrawingUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
MenuItemDrawingUPP NewMenuItemDrawingUPP (
   MenuItemDrawingProcPtr userRoutine
);


/*RegisterAppearanceClient

Registers your program with the Appearance Manager.

OSStatus RegisterAppearanceClient (
);
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceProcessRegisteredErr indicates that your program was already registered when you called the RegisterAppearanceClient function.
Discussion

The RegisterAppearanceClient function must be called at the beginning of your program, prior to initializing or drawing any onscreen elements or invoking any definition functions, such as the menu bar.

You should call RegisterAppearanceClient in order to receive Appearance Manager Apple events. Under Appearance Manager 1.1 and later, when the user changes the current appearance (that is, when a theme switch occurs), the Appearance Manager sends Apple events to all running applications that are registered as clients of the Appearance Manager and which are high-level event aware. Because typical results of a theme switch might include a change in menu bar height or window structure dimensions, as well as changes to the system fonts, colors, and patterns currently in use, you should listen for and respond to the Appearance Manager Apple events under most circumstances. See “Appearance Manager Apple Events” for more details.

When your program calls RegisterAppearanceClient, the Appearance Manager also automatically maps standard pre–Appearance Manager definition functions to their theme-compliant equivalents for your program, whether or not systemwide appearance is active.

See also the function UnregisterAppearanceClient. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus RegisterAppearanceClient ();

/*UnregisterAppearanceClient

Informs the Appearance Manager that your program is no longer its client.

OSStatus UnregisterAppearanceClient (
);
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceProcessNotRegisteredErr indicates that your program was not registered when you called the UnregisterAppearanceClient function.
Discussion

The UnregisterAppearanceClient function is automatically called for you when your program terminates. While you do not typically need to call this function, you might want to call UnregisterAppearanceClient if you are running a plug-in architecture, and you know that a given plug-in is not theme-compliant. In this case you would bracket your use of the plug-in with calls to UnregisterAppearanceClient (before the plug-in is used) and RegisterAppearanceClient (after the plug-in is used), so that the Appearance Manager is turned off for the duration of the plug-in’s usage.

See also the function RegisterAppearanceClient. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus UnregisterAppearanceClient ();

/*DrawThemeGenericWell

Draws an image well frame.

OSStatus DrawThemeGenericWell (
   const Rect * inRect,
   ThemeDrawState inState,
   Boolean inFillCenter
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemeGenericWell, set the rectangle to the position around which to draw the image well frame, in local coordinates.
inState

A value of type ThemeDrawState. Pass a constant specifying the state in which to draw the image well frame; see “Theme Drawing States”. The well can be drawn as active or inactive; passing kThemeStatePressed produces an error.
inFillCenter

A value of type Boolean. Set to true to fill the image well frame with white; otherwise, false.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeGenericWell function draws a theme-compliant image well frame. You can specify that the center of the well be filled in with white. 
Version Notes

This function is available with Appearance Manager 1.0.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemeGenericWell (
   const Rect * inRect,
   ThemeDrawState inState,
   Boolean inFillCenter
);

/*SetThemePen

Applies a theme-compliant color or pattern to the foreground of the current port.

OSStatus SetThemePen (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inIsColorDevice
);
Parameters
inBrush

A value of type ThemeBrush. Pass a constant specifying the theme brush type to which to set the pen; see “Theme Brushes” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inIsColorDevice

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceBadBrushIndexErr indicates that the brush constant passed in was not valid.
Discussion

Your application should call the SetThemePen function each time you wish to draw an element in a specified brush constant.

Because the constant in the inBrush parameter can represent a color or pattern, depending on the current theme, your application must save and restore the current drawing state of the graphics port around calls to SetThemePen. Under Appearance Manager 1.1 and later, you can use the functions GetThemeDrawingState and SetThemeDrawingState to do this. Prior to Appearance Manager 1.1, you must save and restore the pnPixPat and bkPixPat fields of your graphics port when saving the text and background colors. Because patterns in the pnPixPat field override the foreground color of the window, call the QuickDraw function PenPat to set your foreground pattern to a normal white pattern. This ensures that you can use RGBForeColor to set your foreground color to white, call the QuickDraw function PaintRect, and get the expected results. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemePen (
   ThemeBrush inBrush,
   SInt16 inDepth,
   Boolean inIsColorDevice
);

/*DrawThemeEditTextFrame

Draws an editable text frame.

OSStatus DrawThemeEditTextFrame (
   const Rect * inRect,
   ThemeDrawState inState
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemeEditTextFrame, set the rectangle to the position around which to draw the editable text frame, in local coordinates.
inState

A value of type ThemeDrawState. Pass a constant specifying the state in which to draw the editable text frame; see “Theme Drawing States”. The frame can be drawn as active or inactive; passing kThemeStatePressed produces an error.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemeEditTextFrame function draws a theme-compliant frame for an editable text field. The frame is a maximum of 2 pixels thick and is drawn outside the specified rectangle. You should not use this function to draw frames for items other than editable text fields.

To ensure that you get an appropriate focus ring for your editable text field, you should pass the same rectangle that you use with DrawThemeEditTextFrame function to the function DrawThemeFocusRect. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/

OSStatus DrawThemeEditTextFrame (
   const Rect * inRect,
   ThemeDrawState inState
);

/*DrawThemeFocusRect

Draws or erases a focus ring around a specified rectangle.

OSStatus DrawThemeFocusRect (
   const Rect * inRect,
   Boolean inHasFocus
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemeFocusRect, set the rectangle to the position around which to draw the focus ring, in local coordinates. The focus ring is drawn outside the rectangle that is passed in, and it can be outset a maximum of 3 pixels.
inHasFocus

A value of type Boolean. Pass true to draw the focus ring. Pass false to erase the focus ring.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application can use the DrawThemeFocusRect function to draw a theme-compliant focus ring. The presence of a focus ring indicates whether an item has keyboard focus.

If you are drawing a focus ring around an element for which you have drawn a frame using DrawThemeEditTextFrame or DrawThemeListBoxFrame, you must coordinate your drawing sequence to achieve the correct look. When drawing the element, your application should first call DrawThemeEditTextFrame or DrawThemeListBoxFrame and then call DrawThemeFocusRect, passing the same rectangle in the inRect parameter. If you use DrawThemeFocusRect to erase the focus ring around an editable text frame or list box frame, you must redraw the editable text frame or list box frame after calling DrawThemeFocusRect, because there is typically an overlap.
Version Notes

This function is available with Appearance Manager 1.0 and later. 
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemeFocusRect (
   const Rect * inRect,
   Boolean inHasFocus
);

/*DrawThemeTrack

Draws a track.

OSStatus DrawThemeTrack (
   const ThemeTrackDrawInfo * drawInfo,
   RgnHandle rgnGhost,
   ThemeEraseUPP eraseProc,
   UInt32 eraseData
);
Parameters
drawInfo

A pointer to a structure of type ThemeTrackDrawInfo. Before calling DrawThemeTrack, set the structure to contain the current visual characteristics of the track. 
rgnGhost

A value of type RgnHandle. If the track is of a type that contains an indicator, such as a scroll bar or slider, you may pass a handle to the region where DrawThemeTrack is to draw a ghost image of the track indicator. Your application should only use a ghost image with the indicator when a track does not support live feedback. Pass NULL if you do not want to draw a ghost image. 
eraseProc

A value of type ThemeEraseUPP. If you have a custom background, pass a universal function pointer to an application-defined function such as that described in ThemeEraseProcPtr. DrawThemeTrack calls that function to erase the background before drawing the track. If you pass NULL, no erasing occurs.
eraseData

An unsigned 32-bit integer. Provide any data to be passed in to the callback function specified in the eraseProc parameter.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Your application may use the DrawThemeTrack function to draw a theme-compliant slider, progress bar, or scroll bar. If you use DrawThemeTrack to draw a scroll bar, use the function DrawThemeScrollBarArrows to draw the scroll bar’s arrows. If you use DrawThemeTrack to draw a slider, use DrawThemeTrackTickMarks to draw any tick marks for the slider. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Supported in Carbon. Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemeTrack (
   const ThemeTrackDrawInfo * drawInfo,
   RgnHandle rgnGhost,
   ThemeEraseUPP eraseProc,
   UInt32 eraseData
);

/*GetThemeTextColor

Obtains the text color used for a specified element under the current theme.

OSStatus GetThemeTextColor (
   ThemeTextColor inColor,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
);
Parameters
inColor

A value of type ThemeTextColor. Pass a constant specifying the element for which you wish to obtain the current text color; see “Theme Text Colors” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inColorDev

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
outColor

A pointer to a structure of type RGBColor. On return, the structure contains the text color used for the specified element under the current theme. 
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

Also see the function SetThemeTextColor. 
Version Notes

This function is available with Appearance Manager 1.1 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.1 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus GetThemeTextColor (
   ThemeTextColor inColor,
   SInt16 inDepth,
   Boolean inColorDev,
   RGBColor * outColor
);

/*SetThemeTextColor

Sets the current text color to be consistent with that of a specified element.

OSStatus SetThemeTextColor (
   ThemeTextColor inColor,
   SInt16 inDepth,
   Boolean inIsColorDevice
);

Parameters
inColor

A value of type ThemeTextColor. Pass a constant specifying an interface element. SetThemeTextColor sets the current text color to be the same as the color of that element’s text. See “Theme Text Colors” for descriptions of possible values.
inDepth

A signed 16-bit integer. Pass a value specifying the bit depth (in bits per pixel) of the current graphics port.
inIsColorDevice

A value of type Boolean. Pass true to indicate that you are drawing on a color device. Pass false for a monochrome device.
Return Value

A result code. See “Appearance Manager Result Codes”. The result code appearanceBadTextColorIndexErr indicates that the text color index passed was not valid.
Discussion

Your application typically uses the SetThemeTextColor function inside a DeviceLoop drawing function to set the foreground color to a theme-compliant value.

Also see the function GetThemeTextColor. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus SetThemeTextColor (
   ThemeTextColor inColor,
   SInt16 inDepth,
   Boolean inIsColorDevice
);

/*DrawThemePlacard

Draws a placard.

OSStatus DrawThemePlacard (
   const Rect * inRect,
   ThemeDrawState inState
);
Parameters
inRect

A pointer to a structure of type Rect. Before calling DrawThemePlacard, set the rectangle to a size and position that contains the placard, in local coordinates.
inState

A value of type ThemeDrawState. Pass a constant specifying the state in which to draw the placard; see “Theme Drawing States”. The placard can be drawn as active, inactive, or pressed.
Return Value

A result code. See “Appearance Manager Result Codes”.
Discussion

The DrawThemePlacard function draws a theme-compliant placard inside the specified rectangle. 
Version Notes

This function is available with Appearance Manager 1.0 and later.
Availability
Available in CarbonLib 1.0 and later when Appearance 1.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
Appearance.h*/
OSStatus DrawThemePlacard (
   const Rect * inRect,
   ThemeDrawState inState
);

#ifdef __cplusplus
}
#endif

#endif
