#ifndef AXERROR_H
#define AXERROR_H

#include <CoreFoundation/CoreFoundation.h>
//#include <HYS/HIServices/AXError.h>
#include <APPLE/HIServices/AXError.h>
#ifdef __cplusplus
extern "C" {
#endif

/*Errors

enum { 
    kAXErrorSuccess = 0, 
    kAXErrorFailure = -25200, 
    kAXErrorIllegalArgument = -25201, 
    kAXErrorInvalidUIElement = -25202, 
    kAXErrorInvalidUIElementObserver = -25203, 
    kAXErrorCannotComplete = -25204, 
    kAXErrorAttributeUnsupported = -25205, 
    kAXErrorActionUnsupported = -25206, 
    kAXErrorNotificationUnsupported = -25207, 
    kAXErrorNotImplemented = -25208, 
    kAXErrorNotificationAlreadyRegistered = -25209, 
    kAXErrorNotificationNotRegistered = -25210, 
    kAXErrorAPIDisabled = -25211, 
    kAXErrorNoValue = -25212, 
    kAXErrorParameterizedAttributeUnsupported = -25213 
};  
Constants
kAXErrorSuccess
No error occurred.
kAXErrorFailure
A system error occurred, such as the failure to allocate an object.
kAXErrorIllegalArgument
An illegal argument was passed to the function.
kAXErrorInvalidUIElement
The AXUIElementRef passed to the function is invalid.
kAXErrorInvalidUIElementObserver
The AXObserverRef passed to the function is not a valid observer.
kAXErrorCannotComplete
The function cannot complete because messaging failed in some way or because the application with which the function is communicating is busy or unresponsive.
kAXErrorAttributeUnsupported
The attribute is not supported by the AXUIElementRef.
kAXErrorActionUnsupported
The action is not supported by the AXUIElementRef.
kAXErrorNotificationUnsupported
The notification is not supported by the AXUIElementRef.
kAXErrorNotImplemented
Indicates that the function or method is not implemented (this can be returned if a process does not support the accessibility API).
kAXErrorNotificationAlreadyRegistered
This notification has already been registered for.
kAXErrorNotificationNotRegistered
Indicates that a notification is not registered yet.
kAXErrorAPIDisabled
The accessibility API is disabled (as when, for example, the user deselects "Enable access for assistive devices" in Universal Access Preferences).
kAXErrorNoValue
The requested value or AXUIElementRef does not exist.
kAXErrorParameterizedAttributeUnsupported
The parameterized attribute is not supported by the AXUIElementRef.*/
enum { 
    kAXErrorSuccess = 0, 
    kAXErrorFailure = -25200, 
    kAXErrorIllegalArgument = -25201, 
    kAXErrorInvalidUIElement = -25202, 
    kAXErrorInvalidUIElementObserver = -25203, 
    kAXErrorCannotComplete = -25204, 
    kAXErrorAttributeUnsupported = -25205, 
    kAXErrorActionUnsupported = -25206, 
    kAXErrorNotificationUnsupported = -25207, 
    kAXErrorNotImplemented = -25208, 
    kAXErrorNotificationAlreadyRegistered = -25209, 
    kAXErrorNotificationNotRegistered = -25210, 
    kAXErrorAPIDisabled = -25211, 
    kAXErrorNoValue = -25212, 
    kAXErrorParameterizedAttributeUnsupported = -25213 
};  

#ifdef __cplusplus
}
#endif

#endif