#ifndef AXACTIONCONSTANT_H
#define AXACTIONCONSTANTS_H

/*Actions

Define the actions an accessibility object can perform.

// Accessibility actions.
#define kAXPressAction          CFSTR("AXPress")
#define kAXIncrementAction      CFSTR("AXIncrement")
#define kAXDecrementAction      CFSTR("AXDecrement")
#define kAXConfirmAction        CFSTR("AXConfirm")
#define kAXCancelAction         CFSTR("AXCancel")
#define kAXRaiseAction          CFSTR("AXRaise")
#define kAXShowMenuAction       CFSTR("AXShowMenu")
Constants
kAXPressAction

Simulates a single click, such as on a button.
kAXIncrementAction

Increments the value of the accessibility object. The amount the value is incremented by is determined by the value of the kAXValueIncrementAttribute attribute.
kAXDecrementAction

Decrements the value of the accessibility object. The amount the value is decremented by is determined by the value of the kAXValueIncrementAttribute attribute.
kAXConfirmAction

Simulates pressing the Return key.

Available in Mac OS X v10.2 and later.
kAXCancelAction

Simulates pressing a Cancel button.
kAXRaiseAction

Causes a window to become as frontmost as is allowed by the containing application’s circumstances. Note that an application’s floating windows (such as inspector windows) might remain above a window that performs the raise action.

Available in Mac OS X v10.3 and later.
kAXShowMenuAction

Simulates the opening of a contextual menu in the element represented by this accessibility object. This action can also be used to simulate the display of a menu that is preassociated with an element, such as the menu that displays when a user clicks Safari’s back button slowly.

Available in Mac OS X v10.4 and later.*/
#define kAXPressAction          CFSTR("AXPress")
#define kAXIncrementAction      CFSTR("AXIncrement")
#define kAXDecrementAction      CFSTR("AXDecrement")
#define kAXConfirmAction        CFSTR("AXConfirm")
#define kAXCancelAction         CFSTR("AXCancel")
#define kAXRaiseAction          CFSTR("AXRaise")
#define kAXShowMenuAction       CFSTR("AXShowMenu")

/*Roles

Define the values an accessibility object’s role attribute can have.

#define kAXApplicationRole  CFSTR("AXApplication")
#define kAXSystemWideRole   CFSTR("AXSystemWide")
#define kAXWindowRole       CFSTR("AXWindow")
#define kAXSheetRole        CFSTR("AXSheet")
#define kAXDrawerRole       CFSTR("AXDrawer")
#define kAXGrowAreaRole     CFSTR("AXGrowArea")
#define kAXImageRole        CFSTR("AXImage")
#define kAXUnknownRole      CFSTR("AXUnknown")
#define kAXButtonRole       CFSTR("AXButton")
#define kAXRadioButtonRole  CFSTR("AXRadioButton")
#define kAXCheckBoxRole     CFSTR("AXCheckBox")
#define kAXPopUpButtonRole  CFSTR("AXPopUpButton")
#define kAXMenuButtonRole   CFSTR("AXMenuButton")
#define kAXTabGroupRole     CFSTR("AXTabGroup")
#define kAXTableRole        CFSTR("AXTable")
#define kAXColumnRole       CFSTR("AXColumn")
#define kAXRowRole          CFSTR("AXRow")
#define kAXOutlineRole      CFSTR("AXOutline")
#define kAXBrowserRole      CFSTR("AXBrowser")
#define kAXScrollAreaRole   CFSTR("AXScrollArea")
#define kAXScrollBarRole    CFSTR("AXScrollBar")
#define kAXRadioGroupRole   CFSTR("AXRadioGroup")
#define kAXListRole         CFSTR("AXList")
#define kAXGroupRole        CFSTR("AXGroup")
#define kAXValueIndicatorRole CFSTR ("AXValueIndicator")
#define kAXComboBoxRole     CFSTR("AXComboBox")
#define kAXSliderRole       CFSTR("AXSlider")
#define kAXIncrementorRole  CFSTR("AXIncrementor")
#define kAXBusyIndicatorRole CFSTR ("AXBusyIndicator")
#define kAXProgressIndicatorRole  CFSTR("AXProgressIndicator")
#define kAXRelevanceIndicatorRole CFSTR("AXRelevanceIndicator")
#define kAXToolbarRole      CFSTR("AXToolbar")
#define kAXDisclosureTriangleRole CFSTR("AXDisclosureTriangle")
#define kAXTextFieldRole CFSTR("AXTextField")
#definekAXTextAreaRole      CFSTR("AXTextArea")
#define kAXStaticTextRole   CFSTR("AXStaticText")
#define kAXMenuBarRole      CFSTR("AXMenuBar")
#define kAXMenuBarItemRole  CFSTR("AXMenuBarItem")
#define kAXMenuRole         CFSTR("AXMenu")
#define kAXMenuItemRole     CFSTR("AXMenuItem")
#define kAXSplitGroupRole   CFSTR("AXSplitGroup")
#define kAXSplitterRole     CFSTR("AXSplitter")
#define kAXColorWellRole    CFSTR("AXColorWell")
#define kAXTimeFieldRole    CFSTR("AXTimeField")
#define kAXDateFieldRole    CFSTR("AXDateField")
#define kAXHelpTagRole      CFSTR("AXHelpTag")
#define kAXMatteRole        CFSTR("AXMatteRole")
#define kAXDockItemRole     CFSTR("AXDockItem")
Constants
kAXApplicationRole

An application.
kAXSystemWideRole

The system-wide accessibility object.
kAXWindowRole

A window.
kAXSheetRole

A sheet.

Available in Mac OS X v10.2 and later.
kAXDrawerRole

A drawer.
kAXGrowAreaRole

A grow control.

Available in Mac OS X v10.2 and later.
kAXImageRole

An image.

Available in Mac OS X v10.2 and later.
kAXUnknownRole

Generic role value for an unknown accessibility object.
kAXButtonRole

A button.

Available in Mac OS X v10.2 and later.
kAXRadioButtonRole

A radio button.
kAXCheckBoxRole

A check box.

Available in Mac OS X v10.2 and later.
kAXPopUpButtonRole

A pop-up button.
kAXMenuButtonRole

A menu button.

Available in Mac OS X v10.2 and later.
kAXTabGroupRole

A tab view.

Available in Mac OS X v10.2 and later.
kAXTableRole

A table.

Available in Mac OS X v10.2 and later.
kAXColumnRole

A column.
kAXRowRole

A row.

Available in Mac OS X v10.2 and later.
kAXOutlineRole

An accessibility object that displays row-based, hierarchically structured data, such as the list view in a Finder window.
kAXBrowserRole

An accessibility object that displays column-based, hierarchically structured data, such as the column view in a Finder window.
kAXScrollAreaRole

An accessibility object that displays data managed by scrolling controls.

Available in Mac OS X v10.2 and later.
kAXScrollBarRole

A scroll bar control.

Available in Mac OS X v10.2 and later.
kAXRadioGroupRole

A set of radio buttons.

Available in Mac OS X v10.2 and later.
kAXListRole

A list view.
kAXGroupRole

A group box. This role can also be used to group other views without any visual indication of the grouping.

Available in Mac OS X v10.2 and later.
kAXValueIndicatorRole

A control that indicates the value of an accessibility object, such as the scroller of a scroll bar control

Available in Mac OS X v10.2 and later.
kAXComboBoxRole

A combo box control.
kAXSliderRole

A slider control.
kAXIncrementorRole

A stepper control (also known as the “little arrows”).

Available in Mac OS X v10.2 and later.
kAXBusyIndicatorRole

An asynchronous progress indicator.
kAXProgressIndicatorRole

A determinate or indeterminate progress indicator.
kAXRelevanceIndicatorRole

A relevance indicator.
kAXToolbarRole

A toolbar.
kAXDisclosureTriangleRole

A disclosure triangle control.

Available in Mac OS X v10.4 and later.
kAXTextFieldRole

A text field.
kAXTextAreaRole

The editable text area in a control or window.

Available in Mac OS X v10.2 and later.
kAXStaticTextRole

A string of static text displayed in a window that is not part of any control.

Available in Mac OS X v10.2 and later.
kAXMenuBarRole

A menu bar.
kAXMenuBarItemRole

A menu bar item.

Available in Mac OS X v10.3 and later.
kAXMenuRole

A menu.
kAXMenuItemRole

A menu item.
kAXSplitGroupRole

A split view.
kAXSplitterRole

A splitter bar control.
kAXColorWellRole

A color well.

Available in Mac OS X v10.2 and later.
kAXTimeFieldRole

A field that displays time.

Available in Mac OS X v10.3 and later.
kAXDateFieldRole

A field that displays dates.

Available in Mac OS X v10.3 and later.
kAXHelpTagRole

A help tag.

Available in Mac OS X v10.4 and later.
kAXMatteRole

The outer view that represents the entire contents, including the view through the matte hole, the contents hidden by the matte frame, and the resizing and repositioning controls. An example of an object with a matte role is the iChat icon scaling window.

Available in Mac OS X v10.4 and later.
kAXDockItemRole

An icon that represents an item in the Dock.

Available in Mac OS X v10.4 and later.
Discussion

The value of the role attribute describes what the object is, not what it does. See the “Roles and Associated Attributes” appendix in Accessibility Overview for more information on which attributes are associated with each role.*/
#define kAXApplicationRole  CFSTR("AXApplication")
#define kAXSystemWideRole   CFSTR("AXSystemWide")
#define kAXWindowRole       CFSTR("AXWindow")
#define kAXSheetRole        CFSTR("AXSheet")
#define kAXDrawerRole       CFSTR("AXDrawer")
#define kAXGrowAreaRole     CFSTR("AXGrowArea")
#define kAXImageRole        CFSTR("AXImage")
#define kAXUnknownRole      CFSTR("AXUnknown")
#define kAXButtonRole       CFSTR("AXButton")
#define kAXRadioButtonRole  CFSTR("AXRadioButton")
#define kAXCheckBoxRole     CFSTR("AXCheckBox")
#define kAXPopUpButtonRole  CFSTR("AXPopUpButton")
#define kAXMenuButtonRole   CFSTR("AXMenuButton")
#define kAXTabGroupRole     CFSTR("AXTabGroup")
#define kAXTableRole        CFSTR("AXTable")
#define kAXColumnRole       CFSTR("AXColumn")
#define kAXRowRole          CFSTR("AXRow")
#define kAXOutlineRole      CFSTR("AXOutline")
#define kAXBrowserRole      CFSTR("AXBrowser")
#define kAXScrollAreaRole   CFSTR("AXScrollArea")
#define kAXScrollBarRole    CFSTR("AXScrollBar")
#define kAXRadioGroupRole   CFSTR("AXRadioGroup")
#define kAXListRole         CFSTR("AXList")
#define kAXGroupRole        CFSTR("AXGroup")
#define kAXValueIndicatorRole CFSTR ("AXValueIndicator")
#define kAXComboBoxRole     CFSTR("AXComboBox")
#define kAXSliderRole       CFSTR("AXSlider")
#define kAXIncrementorRole  CFSTR("AXIncrementor")
#define kAXBusyIndicatorRole CFSTR ("AXBusyIndicator")
#define kAXProgressIndicatorRole  CFSTR("AXProgressIndicator")
#define kAXRelevanceIndicatorRole CFSTR("AXRelevanceIndicator")
#define kAXToolbarRole      CFSTR("AXToolbar")
#define kAXDisclosureTriangleRole CFSTR("AXDisclosureTriangle")
#define kAXTextFieldRole CFSTR("AXTextField")
#define kAXTextAreaRole      CFSTR("AXTextArea")
#define kAXStaticTextRole   CFSTR("AXStaticText")
#define kAXMenuBarRole      CFSTR("AXMenuBar")
#define kAXMenuBarItemRole  CFSTR("AXMenuBarItem")
#define kAXMenuRole         CFSTR("AXMenu")
#define kAXMenuItemRole     CFSTR("AXMenuItem")
#define kAXSplitGroupRole   CFSTR("AXSplitGroup")
#define kAXSplitterRole     CFSTR("AXSplitter")
#define kAXColorWellRole    CFSTR("AXColorWell")
#define kAXTimeFieldRole    CFSTR("AXTimeField")
#define kAXDateFieldRole    CFSTR("AXDateField")
#define kAXHelpTagRole      CFSTR("AXHelpTag")
#define kAXMatteRole        CFSTR("AXMatteRole")
#define kAXDockItemRole     CFSTR("AXDockItem")


#endif