#ifndef __GXTYPES__
#define __GXTYPES__

#ifndef __MACTYPES__
#include <MacTypes.h>
#endif

#ifndef __MIXEDMODE__
#include <MixedMode.h>
#endif

#ifndef __FIXMATH__
#include <FixMath.h>
#endif

#ifndef __GXMATH__
#include <GXMath.h>
#endif


#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Fill Types

The following constants specify fill types for paths. For more information about fill types, see "Shape Fill" .
// fill types *
enum {
    gxNoFill                = 0,
    gxOpenFrameFill         = 1,
    gxFrameFill             = gxOpenFrameFill,
    gxClosedFrameFill       = 2,
    gxHollowFill            = gxClosedFrameFill,
    gxEvenOddFill           = 3,
    gxSolidFill             = gxEvenOddFill,
    gxWindingFill           = 4,
    gxInverseEvenOddFill    = 5,
    gxInverseSolidFill      = gxInverseEvenOddFill,
    gxInverseFill           = gxInverseEvenOddFill,
    gxInverseWindingFill    = 6
};
Constant descriptions
gxNoFill 
The path is not filled.

gxOpenFrameFill 
The path is framed or stroked along its outline.

gxFrameFill 
The path is framed or stroked along outline.

gxClosedFrameFill 
The path is framed, open ends closed off.

gxHollowFill 
The path is framed, open ends closed off.

gxEvenOddFill 
The path is filled with even odd rule.

gxSolidFill 
The path is filled with even odd rule.

gxWindingFill 
The path is filled using winding rule.

gxInverseEvenOddFill 
The area outside of the path is filled.

gxInverseFill 
The area outside of the path is filled.

gxInverseSolidFill 
The area outside of the path is filled.

gxInverseWindingFill 
The area outside of the winding is filled.*/
enum {
    gxNoFill                = 0,
    gxOpenFrameFill         = 1,
    gxFrameFill             = gxOpenFrameFill,
    gxClosedFrameFill       = 2,
    gxHollowFill            = gxClosedFrameFill,
    gxEvenOddFill           = 3,
    gxSolidFill             = gxEvenOddFill,
    gxWindingFill           = 4,
    gxInverseEvenOddFill    = 5,
    gxInverseSolidFill      = gxInverseEvenOddFill,
    gxInverseFill           = gxInverseEvenOddFill,
    gxInverseWindingFill    = 6
};


#ifdef __cplusplus
}
#endif

#endif 
