
#ifndef  DRERASESESSION_H
#define DRERASESESSION_H

#ifndef DISCRECORDING_H
#import <DiscRecording/DiscRecording.h>
#endif

#ifndef CARBON_H
#import <Carbon/Carbon.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Erase Session Dialog Result Codes

enum { 
    kDREraseSessionOK = 1, 
    kDREraseSessionCancel = 0 
};  
Constants
kDREraseSessionOK
Value returned by the setup dialog when the user has confirmed the erase setup.
kDREraseSessionCancel
Value returned by the setup dialog when the user has canceled the erase setup.
Discussion 

Return codes for the erase session setup dialog.*/
enum { 
    kDREraseSessionOK = 1, 
    kDREraseSessionCancel = 0 
};  


/*Erase Setup Dialog Option Flags

enum { 
    kEraseSessionSetupDialogDefaultOptions = 0x00000000, / use defaults for all the options *
    kEraseSessionSetupDialogDontHandleReservations = 0x00000001, /*
        Don't handle media reservations. Application handles them itself *
};  
Constants
kEraseSessionSetupDialogDefaultOptions
Use defaults for all the options
kEraseSessionSetupDialogDontHandleReservations
Session does not handle media reservations. Application handles them itself
Discussion 

Flags used to configure the erase setup dialog behavior*/
enum { 
    kEraseSessionSetupDialogDefaultOptions = 0x00000000, /* use defaults for all the options */
    kEraseSessionSetupDialogDontHandleReservations = 0x00000001, /* 
        Don't handle media reservations. Application handles them itself */
};  

/*kDREraseProgressSetupCallbacksCurrentVersion struct version

enum { 
    kDREraseProgressSetupCallbacksCurrentVersion = 1 
};  */
enum { 
    kDREraseProgressSetupCallbacksCurrentVersion = 1 
}; 

/*DREraseSessionProgressDialogOptions struct version

enum { 
    kEraseSessionProgressDialogOptionsCurrentVersion = 1 
};  */
enum { 
    kEraseSessionProgressDialogOptionsCurrentVersion = 1 
}; 

/*Erase Progress Dialog Option Flags

enum { 
    kEraseSessionProgressDialogDefaultOptions = 0x00000000 / use defaults for all the options *
};  
Constants
kEraseSessionProgressDialogDefaultOptions
Use defaults for all the options
Discussion 

Flags used to configure the erase progress dialog behavior*/
enum { 
    kEraseSessionProgressDialogDefaultOptions = 0x00000000 /* use defaults for all the options */
};  



/*DREraseSessionSetupDialogOptions struct version

enum { 
    kEraseSessionSetupDialogOptionsCurrentVersion = 1 
};  */

enum { 
    kEraseSessionSetupDialogOptionsCurrentVersion = 1 
};  

/*DREraseSessionSetupCallbacks struct version

enum { 
    kDREraseSessionSetupCallbacksCurrentVersion = 1 
};  */
enum { 
    kDREraseSessionSetupCallbacksCurrentVersion = 1 
};  

/*DREraseSessionProgressDialogOptionFlags


Specifies progress dialog configuration options. 
typedef UInt32 DREraseSessionProgressDialogOptionFlags;  */
typedef UInt32 DREraseSessionProgressDialogOptionFlags;  

/*DREraseSessionSetupDialogOptionFlags


Specifies setup dialog configuration options. 
typedef UInt32 DREraseSessionSetupDialogOptionFlags;  */
typedef UInt32 DREraseSessionSetupDialogOptionFlags;

/*DREraseSessionRef

typedef struct __DREraseSession* DREraseSessionRef;  
Discussion 

This is the type of a reference to DREraseSession instances.*/
typedef struct __DREraseSession* DREraseSessionRef; 

/*DREraseSessionSetupDialogOptions


Options passed into the setup dialog to configure it. 
struct DREraseSessionSetupDialogOptions { 
    UInt32 version; 
    DREraseSessionSetupDialogOptionFlags dialogOptionFlags; / option flags for affecting the dialog's behavior *
};  
Fields
version
Identifies the version of this structure.
dialogOptionFlags
One of several constants defined by the DREraseSessionSetupDialogOptionFlags data type as described in Erase Setup Dialog Option Flags .*/
struct DREraseSessionSetupDialogOptions { 
    UInt32 version; 
    DREraseSessionSetupDialogOptionFlags dialogOptionFlags; /* option flags for affecting the dialog's behavior */
};  
typedef struct DREraseSessionSetupDialogOptions DREraseSessionSetupDialogOptions;


//func

/*DREraseSessionCreate


Creates a new erase session. 
extern DREraseSessionRef DREraseSessionCreate();  
Return Value

A reference to a new DREraseSession. 
Availability
Introduced in Mac OS X v10.3.*/
extern DREraseSessionRef DREraseSessionCreate();  

/*DREraseSessionDeviceCheckProcPtr


Callback used for checking the suitability of a device. 
typedef Boolean (*DREraseSessionDeviceCheckProcPtr)(
    DREraseSessionRef eraseSession,
    DRDeviceRef device);  
Parameters
eraseSession
The erase session object.
device
The device to examine.
Return Value

A Boolean value indicating the suitability of the device. 
Discussion 

This callback is called whenever a new device appears. It's purpose is to allow the application to filter out devices which do not support the operation to be performed. for example, a device may filter our CD-R/Ws if it is a DVD creation appliacation.*/
typedef Boolean (*DREraseSessionDeviceCheckProcPtr)(
    DREraseSessionRef eraseSession,
    DRDeviceRef device);  

/*DREraseSessionMediaCheckProcPtr


Callback used for checking the suitability of media in a device. 
typedef Boolean (*DREraseSessionMediaCheckProcPtr)(
    DREraseSessionRef eraseSession,
    DRDeviceRef device,
    CFStringRef*prompt);  
Parameters
eraseSession
The erase session object.
device
The device containing the media to examine.
prompt
A pointer to a CFStringRef. An application may return a custom message to display in the setup dialog.
Return Value

A Boolean value indicating the suitability of the media. 
Discussion 

This callback is called whenever the state of the media has changed. It's purpose is to allow the application to determine if the media is suitable for the operation to be performed. For example, the application an check to see if there is enough space on the media for the data to be written.*/
typedef Boolean (*DREraseSessionMediaCheckProcPtr)(
    DREraseSessionRef eraseSession,
    DRDeviceRef device,
    CFStringRef*prompt);  

/*DREraseSessionDeviceSelectionNotificationProcPtr


Callback used to notify the application of a new device selected. 
typedef void (*DREraseSessionDeviceSelectionNotificationProcPtr)(
    DREraseSessionRef eraseSession,
    DRDeviceRef selectedDevice);  
Parameters
eraseSession
The erase session object.
selectedDevice
The newly selected device.*/
typedef void (*DREraseSessionDeviceSelectionNotificationProcPtr)(
    DREraseSessionRef eraseSession,
    DRDeviceRef selectedDevice);  


/*DREraseSessionSetupCallbacks


Callback functions passed to the setup dialog. 
struct DREraseSessionSetupCallbacks { 
    UInt32 version; 
    DREraseSessionDeviceCheckProcPtr deviceShouldBeTarget; 
    DREraseSessionMediaCheckProcPtr containsSuitableMedia; 
    DREraseSessionDeviceSelectionNotificationProcPtr deviceSelectionChanged; 
};  
Fields
version
Identifies the version of this structure.
deviceShouldBeTarget
Pointer to a DREraseSessionDeviceCheckProcPtr. The value of this field may be NULL.
containsSuitableMedia
Pointer to a DREraseSessionMediaCheckProcPtr. The value of this field may be NULL.
deviceSelectionChanged
Pointer to a DREraseSessionDeviceSelectionNotificationProcPtr. The value of this field may be NULL.*/

struct DREraseSessionSetupCallbacks { 
    UInt32 version; 
    DREraseSessionDeviceCheckProcPtr deviceShouldBeTarget; 
    DREraseSessionMediaCheckProcPtr containsSuitableMedia; 
    DREraseSessionDeviceSelectionNotificationProcPtr deviceSelectionChanged; 
};  

typedef struct DREraseSessionSetupCallbacks DREraseSessionSetupCallbacks;

/*DREraseSessionProgressDialogOptions


Options passed into the progress dialog to configure it. 
struct DREraseSessionProgressDialogOptions { 
    UInt32 version; 
    DREraseSessionProgressDialogOptionFlags dialogOptionFlags; /*
        option flags for affecting the dialog's behavior *
    CFStringRef description; / optional description of the erase *
};  
Fields
version
Identifies the version of this structure.
dialogOptionFlags
One of several constants defined by the DREraseSessionProgressDialogOptionFlags data type as described in Erase Progress Dialog Option Flags .
description
A CFStringRef that defines a custom description to be used for the dialog. If you do not provide this string (passing NULL), the normal description is used.*/
struct DREraseSessionProgressDialogOptions { 
    UInt32 version; 
    DREraseSessionProgressDialogOptionFlags dialogOptionFlags; /* 
        option flags for affecting the dialog's behavior */
    CFStringRef description; /* optional description of the erase */
};  
typedef struct  DREraseSessionProgressDialogOptions DREraseSessionProgressDialogOptions;

/*DREraseSessionProgressBeginNotificationProcPtr


Callback notifying the application the erase progress is about to begin. 
typedef void (*DREraseSessionProgressBeginNotificationProcPtr)(
    DREraseSessionRef eraseSession);  
Parameters
eraseSession
The erase session object.
Discussion 

This callback is called when the erase progress is about to be displayed. This allows the application to do things such as disable the quit menu item, or the close menu for a document window.*/
typedef void (*DREraseSessionProgressBeginNotificationProcPtr)(
    DREraseSessionRef eraseSession);  

/*DREraseSessionProgressFinishNotificationProcPtr


Callback notifying the application the erase progress has finished. 
typedef void (*DREraseSessionProgressFinishNotificationProcPtr)(
    DREraseSessionRef eraseSession);  
Parameters
eraseSession
The erase session object.
Discussion 

This callback is called when the erase progress has been removed from view. This allows the application to do things such as re-enable the quit menu item, or the close menu for a document window.*/
typedef void (*DREraseSessionProgressFinishNotificationProcPtr)(
    DREraseSessionRef eraseSession);  

/*DREraseSessionEraseCompleteProcPtr


Callback notifying the application the erase has finished. 
typedef Boolean (*DREraseSessionEraseCompleteProcPtr)(
    DREraseSessionRef eraseSession,
    DREraseRef erase);  
Parameters
eraseSession
The erase session object.
erase
The erase instance that just finished.
Return Value

A Boolean value controlling the display of the erase session's error dialog. 
Discussion 

This callback is called when the erase operation completes, either successfully or with an error. This function can be used by the application to present it's own custom end-of-erase handling. If the application wants to present it's own end-of-erase notification, it can do so from this callback. If it does, it can return a false return value to prevent the erase session from presenting it's own notification.*/
typedef Boolean (*DREraseSessionEraseCompleteProcPtr)(
    DREraseSessionRef eraseSession,
    DREraseRef erase);  

/*DREraseSessionProgressCallbacks


Callback functions passed to the progress dialog. 
struct DREraseSessionProgressCallbacks { 
    UInt32 version; 
    DREraseSessionProgressBeginNotificationProcPtr progressWillBegin; 
    DREraseSessionProgressFinishNotificationProcPtr progressDidFinish; 
    DREraseSessionEraseCompleteProcPtr eraseDidFinish; 
};  
Fields
version
Identifies the version of this structure.
progressWillBegin
Pointer to a DREraseSessionProgressBeginNotificationProcPtr. The value of this field may be NULL.
progressDidFinish
Pointer to a DREraseSessionProgressFinishNotificationProcPtr. The value of this field may be NULL.
eraseDidFinish
Pointer to a DREraseSessionEraseCompleteProcPtr. The value of this field may be NULL.*/
struct DREraseSessionProgressCallbacks { 
    UInt32 version; 
    DREraseSessionProgressBeginNotificationProcPtr progressWillBegin; 
    DREraseSessionProgressFinishNotificationProcPtr progressDidFinish; 
    DREraseSessionEraseCompleteProcPtr eraseDidFinish; 
};  
typedef struct  DREraseSessionProgressCallbacks DREraseSessionProgressCallbacks;


//functions

/*DREraseSessionSetupDialog


Presents the setup interface as a modal dialog. 
extern SInt8 DREraseSessionSetupDialog( 
    DREraseSessionRef eraseSession, 
    DREraseSessionSetupDialogOptions*options, 
    DREraseSessionSetupCallbacks*setupCallbacks);  
Parameters
eraseSession
The erase session object
options
A pointer to a structure of type DREraseSessionSetupDialogOptions . This pointer may be NULL if no custom configuration is required.
setupCallbacks
A pointer to a structure of type DREraseSessionSetupCallbacks . This pointer may be NULL if no custom behavior is desired.
Return Value

Returns one of the constants defined by Erase Session Dialog Result Codes . 
Discussion 

This function present the user with a modal dialog that allows them to configure an erase to their custom settings. These include: the device to use and the type of erase to perform. and others. The function does not return until the user dismissed the dialog. 
Availability
Introduced in Mac OS X v10.3.*/
extern SInt8 DREraseSessionSetupDialog( 
    DREraseSessionRef eraseSession, 
    DREraseSessionSetupDialogOptions*options, 
    DREraseSessionSetupCallbacks*setupCallbacks);  

/*DREraseSessionBeginProgressDialog


Presents the progress interface as a non-modal dialog. 
extern void DREraseSessionBeginProgressDialog( 
    DREraseSessionRef eraseSession, 
    DREraseSessionProgressDialogOptions*options, 
    DREraseSessionProgressCallbacks*progressCallbacks);  
Parameters
eraseSession
The erase session object
options
A pointer to a structure of type DREraseSessionSetupDialogOptions .
progressCallbacks
A pointer to a structure of type DREraseSessionProgressCallbacks . This pointer may be NULL if no custom behavior is desired.
Discussion 

This function present the user with a non-modal dialog that shows the erase progress. 
Availability
Introduced in Mac OS X v10.3.*/
extern void DREraseSessionBeginProgressDialog( 
    DREraseSessionRef eraseSession, 
    DREraseSessionProgressDialogOptions*options, 
    DREraseSessionProgressCallbacks*progressCallbacks);  


#ifdef __cplusplus
}
#endif

#endif 


