#ifndef DRCORENOTIFICATIONS_H
#define DRCORENOTIFICATIONS_H

#if PRAGMA_ONCE
#pragma once
#endif

#ifndef DRCOREOBJECT_H
#include <DiscRecordingEngine/DRCoreObject.h>
#endif

#ifndef  AVAILABILITYMACROS_H
#include <AvailabilityMacros.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*DRNotificationCenterRef


The type of a reference to a DRNotificationCenter object. 
typedef struct __DRNotificationCenter* DRNotificationCenterRef*/
typedef struct __DRNotificationCenter* DRNotificationCenterRef;

/*DRNotificationCallback


Delivers a notification. 
typedef void (*DRNotificationCallback)(
    DRNotificationCenterRef center,
    void *observer,
    CFStringRef name,
    DRTypeRef object,
    CFDictionaryRef info);  
Parameters
center
The notification center that this callback is associated with.
observer
The observer specified when this callback was added.
name
The notification name.
object
The object that this notification is associated with, or NULL when there is no associated object.
info
A dictionary object containing additional notification information, or NULL when there is no associated object.*/
typedef void (*DRNotificationCallback)(
    DRNotificationCenterRef center,
    void *observer,
    CFStringRef name,
    DRTypeRef object,
    CFDictionaryRef info);  

//func

/*DRNotificationCenterCreate


Creates a notification center that can be used to register for and receive asyncronous notifications. 
extern DRNotificationCenterRef DRNotificationCenterCreate(
    void) ;  
Return Value

Returns reference to a new DRNotificationCenter object. 
Availability
Introduced in Mac OS X v10.2*/
extern DRNotificationCenterRef DRNotificationCenterCreate(
    void) ;  

/*DRNotificationCenterCreateRunLoopSource


Creates a run-loop source object for a notification center. 
extern CFRunLoopSourceRef DRNotificationCenterCreateRunLoopSource(
    DRNotificationCenterRef center) ;  
Parameters
center
The notification center that the new run-loop source object is for. 

If this parameter is not a valid DRNotificationCenter object, the behavior is undefined.
Return Value

Returns a reference to a CFRunLoopSource object. 
Availability
Introduced in Mac OS X v10.2*/
extern CFRunLoopSourceRef DRNotificationCenterCreateRunLoopSource(
    DRNotificationCenterRef center) ;  

/*DRNotificationCenterAddObserver


Adds an observer callback for a notification center. 
extern void DRNotificationCenterAddObserver(
    DRNotificationCenterRef center,
    const void *observer,
    DRNotificationCallback callback,
    CFStringRef name,
    DRTypeRef object) ;  
Parameters
center
The notification center that the new observer callback is for.
observer
The observer callback to add, which gets passed to the callback.
callback
The observer callback to use for notification delivery.
name
The notification name for adding the observer.
object
The object the notification name is associated with.
Availability
Introduced in Mac OS X v10.2*/
extern void DRNotificationCenterAddObserver(
    DRNotificationCenterRef center,
    const void *observer,
    DRNotificationCallback callback,
    CFStringRef name,
    DRTypeRef object) ;  


#ifdef __cplusplus
}
#endif

#endif 
