#ifndef DRCONTENTTRACK_H
#define DRCONTENTTRACK_H

#ifndef  COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef DRCORETRACK_H
#include <DiscRecordingEngine/DRCoreTrack.h>
#endif

#ifndef DRCONTENTFOLDER_H
#include <DiscRecordingContent/DRContentFolder.h>
#endif

#ifndef DRCONTENTPROPERTIES_H
#include <DiscRecordingContent/DRContentProperties.h>
#endif

#ifndef AVAILABILITYMACROS_H
#include <AvailabilityMacros.h>
#endif

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*DRFilesystemTrackRef

typedef DRTrackRef DRFilesystemTrackRef;  
Discussion 

A DRFilesystemTrack is just a special DRTrack. The type ID of a DRFilesystemTrack is the same as the type ID of a DRTrack.*/
typedef DRTrackRef DRFilesystemTrackRef;  


//func

/*DRFilesystemTrackCreate


Creates a filesystem track capable of burning a folder. 
extern DRFilesystemTrackRef DRFilesystemTrackCreate( 
    DRFolderRef rootFolder) ;  
Parameters
rootFolder
The root folder for the filesystem.
Return Value

A DRFilesystemTrack capable of burning the track. 
Discussion 

You can set the filesystem track's properties using the calls in DRCoreTrack.h - see also DRContentProperties.h for a list of settable track properties. 
Availability
Introduced in Mac OS X v10.2*/
extern DRFilesystemTrackRef DRFilesystemTrackCreate( 
    DRFolderRef rootFolder) ;  


#ifdef __cplusplus
}
#endif

#endif 

