#ifndef DIRSERVICESCONST_H
#define	DIRSERVICESCONST_H

/*Standard Record Types

Constants defined for standard record types.

#define kDSStdRecordTypeAccessControls "dsRecTypeStandard:AccessControls
#define kDSStdRecordTypeAFPServer "dsRecTypeStandard:AFPServer"
#define kDSStdRecordTypeAFPUserAliases "dsRecTypeStandard:AFPUserAliases"
#define kDSStdRecordTypeAliases "dsRecTypeStandard:Aliases"
#define kDSStdRecordTypeAutoServerSetup "dsRecTypeStandard:AutoServerSetup"
#define kDSStdRecordTypeBootp "dsRecTypeStandard:Bootp"
#define kDSStdRecordTypeCertificateAuthorities  "dsRecTypeStandard:CertificateAuthorities
#define kDSStdRecordTypeComputerLists "dsRecTypeStandard:ComputerLists"
#define kDSStdRecordTypeComputers "dsRecTypeStandard:Computers"
#define kDSStdRecordTypeConfig "dsRecTypeStandard:Config"
#define kDSStdRecordTypeEthernets "dsRecTypeStandard:Ethernets"
#define kDSStdRecordTypeFileMakerServers "dsRecTypeStandard:FileMakerServers"
#define kDSStdRecordTypeFTPServer "dsRecTypeStandard:FTPServer"
#define kDSStdRecordTypeGroupAliases "dsRecTypeStandard:GroupAliases"
#define kDSStdRecordTypeGroups "dsRecTypeStandard:Groups"
#define kDSStdRecordTypeHostServices "dsRecTypeStandard:HostServices"
#define kDSStdRecordTypeHosts "dsRecTypeStandard:Hosts"
#define kDSStdRecordTypeLDAPServer "dsRecTypeStandard:LDAPServer"
#define kDSStdRecordTypeLocations "dsRecTypeStandard:Locations"
#define kDSStdRecordTypeMachines "dsRecTypeStandard:Machines"
#define kDSStdRecordTypeMeta "dsRecTypeStandard:AppleMetaRecord"
#define kDSStdRecordTypeMounts "dsRecTypeStandard:Mounts"
#define kDSStdRecordTypeNeighborhoods "dsRecTypeStandard:Neighborhoods"
#define kDSStdRecordTypeNFS "dsRecTypeStandard:NFS"
#define kDSStdRecordTypeNetDomains "dsRecTypeStandard:NetDomains"
#define kDSStdRecordTypeNetGroups "dsRecTypeStandard:NetGroups"
#define kDSStdRecordTypeNetworks "dsRecTypeStandard:Networks"
#define kDSStdRecordTypePasswordServer "dsRecTypeStandard:PasswordServer"
#define kDSStdRecordTypePeople "dsRecTypeStandard:People"
#define kDSStdRecordTypePresetComputerLists  "dsRecTypeStandard:PresetComputerLists"
#define kDSStdRecordTypePresetGroups "dsRecTypeStandard:PresetGroups"
#define kDSStdRecordTypePresetUsers "dsRecTypeStandard:PresetUsers"
#define kDSStdRecordTypePrintService "dsRecTypeStandard:PrintService"
#define kDSStdRecordTypePrintServiceUser "dsRecTypeStandard:PrintServiceUser"
#define kDSStdRecordTypePrinters "dsRecTypeStandard:Printers"
#define kDSStdRecordTypeProtocols "dsRecTypeStandard:Protocols"
#define kDSStdRecordTypeQTSServer "dsRecTypeStandard:QTSServer"
#define kDSStdRecordTypeRPC "dsRecTypeStandard:RPC"
#define kDSStdRecordTypeSMBServer "dsRecTypeStandard:SMBServer"
#define kDSStdRecordTypeServer "dsRecTypeStandard:Server"
#define kDSStdRecordTypeServices "dsRecTypeStandard:Services"
#define kDSStdRecordTypeSharePoints "dsRecTypeStandard:SharePoints"
#define kDSStdRecordTypeUserAliases "dsRecTypeStandard:UserAliases"
#define kDSStdRecordTypeUsers "dsRecTypeStandard:Users"
#define kDSStdRecordTypeWebServer "dsRecTypeStandard:WebServer"
Constants
kDSStdRecordTypeAccessControls

Record type for storing directory access control directives.

Available in Mac OS X v10.4 and later.
kDSStdRecordTypeAFPServer

Record type for storing Apple Filing Protocol (AFP) server records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeAFPUserAliases

Record type for storing AFP user aliases records used exclusively by AFP processes. Not used in Mac OS X v10.4 and later.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeAliases

Record type for representing alias records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeAutoServerSetup

Type for locating automated server set up information.

Available in Mac OS X v10.3 and later.
kDSStdRecordTypeBootp

Record in the local node for storing bootp information.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypeCertificateAuthorities

Record type for storing certificate authority information.

Available in Mac OS X v10.4 and later.
kDSStdRecordTypeComputerLists

Record type for identifying computer record lists.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypeComputers

Record type for identifying computer records.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypeConfig

Record type for identifying configuration records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeEthernets

Record type in the local node for storing Ethernets.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypeFileMakerServers

Record type for storing FileMaker server records that describe FileMaker servers.

Available in Mac OS X v10.4 and later.
kDSStdRecordTypeFTPServer

Record type for storing File Transfer Protocol (FTP) server records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeGroupAliases

Record type for group aliases records. Not supported in Mac OS X v10.4 or later.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeGroups

Record type for identifying group records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeHostServices

Record in the local node for storing host services.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypeHosts

Record type for storing host records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeLDAPServer

Record type for storing Lightweight Directory Access Protocol (LDAP) server records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeLocations

Record type for storing location information.

Available in Mac OS X v10.4 and later.
kDSStdRecordTypeMachines

Record type for storing machine records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeMeta

Record type for identifying meta records. Not used as of Mac OS X v10.4.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeMounts

Record type for identifying mount records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeNeighborhoods

Record type for identifying records that contain a list of computers and other neighborhoods; used for network browsing.

Available in Mac OS X v10.4 and later, and used for Managed Network Views.
kDSStdRecordTypeNFS

Record type for identifying Network File System (NFS) records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeNetDomains

Record type in the local node for storing net domains.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypeNetGroups

Record type in the local node for storing net groups.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypeNetworks

Record type for identifying network records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypePasswordServer

Record type for discovering password servers via Bonjour.

Available in Mac OS X v10.3 and later.
kDSStdRecordTypePeople

Record type for identifying “people” records containing contact information.

Available in Mac OS X v10.3 and later.
kDSStdRecordTypePresetComputerLists

Record type for identifying preset computer list records used in record creation.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypePresetGroups

Record type for identifying preset group records used in record creation.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypePresetUsers

Record type for identifying preset user records used in record creation.

Available in Mac OS X v10.2 and later.
kDSStdRecordTypePrintService

Record type for identifying print service records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypePrintServiceUser

Record type in the local node for storing quota usage for a user.

Available in Mac OS X v10.3 and later.
kDSStdRecordTypePrinters

Record type for identifying printer records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeProtocols

Record type for identifying protocol records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeQTSServer

Record type for identifying QuickTime Streaming Server (QTSS) records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeRPC

Record type for identifying RPC records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeSMBServer

Record type for identifying SMB server records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeServer

Record type for identifying generic server records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeServices

Record type for identifying directory-based service records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeSharePoints

Record type for identifying share point records.

Available in Mac OS X v10.3 and later.
kDSStdRecordTypeUserAliases

Record type for storing user aliases records. Not supported in Mac OS X v10.4 or later.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeUsers

Record type for identifying user records.

Available in Mac OS X v10.0 and later.
kDSStdRecordTypeWebServer

Record type for identifying Web server records.

Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesConst.h*/
#define kDSStdRecordTypeAccessControls "dsRecTypeStandard:AccessControls
#define kDSStdRecordTypeAFPServer "dsRecTypeStandard:AFPServer"
#define kDSStdRecordTypeAFPUserAliases "dsRecTypeStandard:AFPUserAliases"
#define kDSStdRecordTypeAliases "dsRecTypeStandard:Aliases"
#define kDSStdRecordTypeAutoServerSetup "dsRecTypeStandard:AutoServerSetup"
#define kDSStdRecordTypeBootp "dsRecTypeStandard:Bootp"
#define kDSStdRecordTypeCertificateAuthorities  "dsRecTypeStandard:CertificateAuthorities
#define kDSStdRecordTypeComputerLists "dsRecTypeStandard:ComputerLists"
#define kDSStdRecordTypeComputers "dsRecTypeStandard:Computers"
#define kDSStdRecordTypeConfig "dsRecTypeStandard:Config"
#define kDSStdRecordTypeEthernets "dsRecTypeStandard:Ethernets"
#define kDSStdRecordTypeFileMakerServers "dsRecTypeStandard:FileMakerServers"
#define kDSStdRecordTypeFTPServer "dsRecTypeStandard:FTPServer"
#define kDSStdRecordTypeGroupAliases "dsRecTypeStandard:GroupAliases"
#define kDSStdRecordTypeGroups "dsRecTypeStandard:Groups"
#define kDSStdRecordTypeHostServices "dsRecTypeStandard:HostServices"
#define kDSStdRecordTypeHosts "dsRecTypeStandard:Hosts"
#define kDSStdRecordTypeLDAPServer "dsRecTypeStandard:LDAPServer"
#define kDSStdRecordTypeLocations "dsRecTypeStandard:Locations"
#define kDSStdRecordTypeMachines "dsRecTypeStandard:Machines"
#define kDSStdRecordTypeMeta "dsRecTypeStandard:AppleMetaRecord"
#define kDSStdRecordTypeMounts "dsRecTypeStandard:Mounts"
#define kDSStdRecordTypeNeighborhoods "dsRecTypeStandard:Neighborhoods"
#define kDSStdRecordTypeNFS "dsRecTypeStandard:NFS"
#define kDSStdRecordTypeNetDomains "dsRecTypeStandard:NetDomains"
#define kDSStdRecordTypeNetGroups "dsRecTypeStandard:NetGroups"
#define kDSStdRecordTypeNetworks "dsRecTypeStandard:Networks"
#define kDSStdRecordTypePasswordServer "dsRecTypeStandard:PasswordServer"
#define kDSStdRecordTypePeople "dsRecTypeStandard:People"
#define kDSStdRecordTypePresetComputerLists  "dsRecTypeStandard:PresetComputerLists"
#define kDSStdRecordTypePresetGroups "dsRecTypeStandard:PresetGroups"
#define kDSStdRecordTypePresetUsers "dsRecTypeStandard:PresetUsers"
#define kDSStdRecordTypePrintService "dsRecTypeStandard:PrintService"
#define kDSStdRecordTypePrintServiceUser "dsRecTypeStandard:PrintServiceUser"
#define kDSStdRecordTypePrinters "dsRecTypeStandard:Printers"
#define kDSStdRecordTypeProtocols "dsRecTypeStandard:Protocols"
#define kDSStdRecordTypeQTSServer "dsRecTypeStandard:QTSServer"
#define kDSStdRecordTypeRPC "dsRecTypeStandard:RPC"
#define kDSStdRecordTypeSMBServer "dsRecTypeStandard:SMBServer"
#define kDSStdRecordTypeServer "dsRecTypeStandard:Server"
#define kDSStdRecordTypeServices "dsRecTypeStandard:Services"
#define kDSStdRecordTypeSharePoints "dsRecTypeStandard:SharePoints"
#define kDSStdRecordTypeUserAliases "dsRecTypeStandard:UserAliases"
#define kDSStdRecordTypeUsers "dsRecTypeStandard:Users"
#define kDSStdRecordTypeWebServer "dsRecTypeStandard:WebServer"


/*Node Attribute Constants

Constants defined for storing information about nodes.

#define kDS1AttrAuthCredential "dsAttrTypeStandard:AuthCredential"
#define kDS1AttrCapabilities "dsAttrTypeStandard:Capabilities"
#define kDS1AttrOriginalNodeName "dsAttrTypeStandard:OriginalNodeName"
#define kDS1AttrReadOnlyNode "dsAttrTypeStandard:ReadOnlyNode"
#define kDSNAttrMetaNodeLocation "dsAttrTypeStandard:AppleMetaNodeLocation"
#define kDSNAttrNodePath "dsAttrTypeStandard:NodePath"
#define kDSNAttrPlugInInfo "dsAttrTypeStandard:PlugInInfo"
#define kDSNAttrSubNodes "dsAttrTypeStandard:SubNodes"
Constants
kDS1AttrAuthCredential

Single-value attribute for storing an authentication credential used to authenticate to other directory nodes.

Available in Mac OS X v10.0 and later.
kDS1AttrCapabilities

Single-value attribute used to store information about the API capabilities of a directory node.

Available in Mac OS X v10.0 and later.
kDS1AttrOriginalNodeName

Single-value attribute for storing the node name used in local account caching.

Available in Mac OS X v10.3 and later.
kDS1AttrReadOnlyNode

Single-value attribute for storing the read/write status of a node, which can be one of ReadOnly, ReadWrite, or WriteOnly. Attributes of this type can be found by calling dsGetDirNodeInfo. Note that ReadWrite does not imply fully readable or fully writable.

Available in Mac OS X v10.0 and later.
kDSNAttrMetaNodeLocation

Multi-value attribute for storing the registered node name returned by an Open Directory plug-in.

Available in Mac OS X v10.0 and later.
kDSNAttrNodePath

Multi-value attribute for storing, in order, plug-in defined sub-strings of an Open Directory node.

Available in Mac OS X v10.0 and later.
kDSNAttrPlugInInfo

Multi-value attribute for storing information provided by the plug-in that services a particular directory node. Clients can use this attribute to get information about an Open Directory plug-in, such as its version, signature, “about” information, and credits. As of Mac OX X version 10.4, this attribute is not used.

Available in Mac OS X v10.0 and later.
kDSNAttrSubNodes

Multi-value attribute for storing a list of a node’s subnodes. This attribute is supported in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
Declared In
DirectoryService/DirServicesConst.h*/
#define kDS1AttrAuthCredential "dsAttrTypeStandard:AuthCredential"
#define kDS1AttrCapabilities "dsAttrTypeStandard:Capabilities"
#define kDS1AttrOriginalNodeName "dsAttrTypeStandard:OriginalNodeName"
#define kDS1AttrReadOnlyNode "dsAttrTypeStandard:ReadOnlyNode"
#define kDSNAttrMetaNodeLocation "dsAttrTypeStandard:AppleMetaNodeLocation"
#define kDSNAttrNodePath "dsAttrTypeStandard:NodePath"
#define kDSNAttrPlugInInfo "dsAttrTypeStandard:PlugInInfo"
#define kDSNAttrSubNodes "dsAttrTypeStandard:SubNodes"

/*Record Attribute Constants

Constants for accessing attributes that store information about records.

#define kDS1AttrCreationTimestamp "dsAttrTypeStandard:CreationTimeStamp"
#define kDS1AttrDateRecordCreated "dsAttrTypeStandard:DateRecordCreated"
#define kDS1AttrModificationTimestamp  "dsAttrTypeStandard:ModificationTimestamp"
#define kDS1AttrOwner "dsAttrTypeStandard:Owner"
#define kDS1AttrRecordImage "dsAttrTypeStandard:RecordImage"
#define kDS1AttrTimeToLive "dsAttrTypeStandard:TimeToLive"
#define kDS1AttrTotalSize "dsAttrTypeStandard:TotalSize"
#define kDSNAttrAllNames "dsAttrTypeStandard:AllNames"
#define kDSNAttrRecordName "dsAttrTypeStandard:RecordName"
#define kDSNAttrRecordType "dsAttrTypeStandard:RecordType"
Constants
kDS1AttrCreationTimestamp

Single-value attribute for storing the date and time the record was created. The date and time are stored in x.208 format (YYYYMMDDHHMMSSZ) where “Z” is required to be Greenwich Mean Time (GMT). This attribute is available in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
kDS1AttrDateRecordCreated

Single-value attribute for storing the date the record was created.

Available in Mac OS X v10.4 and later.
kDS1AttrModificationTimestamp

Single-value attribute for storing the date and time the record was modified. The date and time are stored in x.208 format (YYYYMMDDHHMMSSZ) where “Z” is required to be GMT. This attribute is available in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
kDS1AttrOwner

Single-value attribute for storing the owner of a record; typically the value is an LDAP distinguished name. This attribute is available in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
kDS1AttrRecordImage

Single-value attribute for storing a record image; clients can use this attribute to force a directory service to generate a binary image of the record and all of its attributes. Not used or implemented.

Available in Mac OS X v10.0 and later.
kDS1AttrTimeToLive

Single-value attribute for storing the recommended amount of time to cache the record’s attribute values. The time is stored as an unsigned 32-bit value representing the number of seconds. For example, 300 is five minutes. This attribute is available in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
kDS1AttrTotalSize

Single-value attribute for storing checksum or meta data. Not used or implemented.

Available in Mac OS X v10.0 and later.
kDSNAttrAllNames

Multi-value attribute for all possible names for a record; retained for backward compatibility but has never been supported.

Available in Mac OS X v10.0 and later.
kDSNAttrRecordName

Multi-value attribute for storing a list of names and keys for a record.

Available in Mac OS X v10.0 and later.
kDSNAttrRecordType

Multi-value attribute for storing record types; a single value is allowed for records and multiple values are allowed for directory nodes.

Available in Mac OS X v10.0 and later.
Declared In
DirectoryService/DirServicesConst.h*/

#define kDS1AttrCreationTimestamp "dsAttrTypeStandard:CreationTimeStamp"
#define kDS1AttrDateRecordCreated "dsAttrTypeStandard:DateRecordCreated"
#define kDS1AttrModificationTimestamp  "dsAttrTypeStandard:ModificationTimestamp"
#define kDS1AttrOwner "dsAttrTypeStandard:Owner"
#define kDS1AttrRecordImage "dsAttrTypeStandard:RecordImage"
#define kDS1AttrTimeToLive "dsAttrTypeStandard:TimeToLive"
#define kDS1AttrTotalSize "dsAttrTypeStandard:TotalSize"
#define kDSNAttrAllNames "dsAttrTypeStandard:AllNames"
#define kDSNAttrRecordName "dsAttrTypeStandard:RecordName"
#define kDSNAttrRecordType "dsAttrTypeStandard:RecordType"

/*Authentication Methods

Constants defined for authentication methods.

#define kDSStdAuth2WayRandom "dsAuthMethodStandard:dsAuth2WayRandom"
#define kDSStdAuth2WayRandomChangePasswd  "dsAuthMethodStandard:dsAuth2WayRandomChangePasswd"
#define kDSStdAuthAPOP "dsAuthMethodStandard:dsAuthAPOP"
#define kDSStdAuthCHAP "dsAuthMethodStandard:dsAuthCHAP"
#define kDSStdAuthCRAM_MD5 "dsAuthMethodStandard:dsAuthNodeCRAM-MD5"
#define kDSStdAuthChangePasswd "dsAuthMethodStandard:dsAuthChangePasswd"
#define kDSStdAuthClearText "dsAuthMethodStandard:dsAuthClearText"
#define kDSStdAuthCrypt "dsAuthMethodStandard:dsAuthCrypt"
#define kDSStdAuthDIGEST_MD5 "dsAuthMethodStandard:dsAuthNodeDIGEST-MD5"
#define kDSStdAuthDeleteUser "dsAuthMethodStandard:dsAuthDeleteUser"
#define kDSStdAuthGetEffectivePolicy  "dsAuthMethodStandard:dsAuthGetEffectivePolicy"
#define kDSStdAuthGetGlobalPolicy "dsAuthMethodStandard:dsAuthGetGlobalPolicy"
#define kDSStdAuthGetKerberosPrincipal  "dsAuthMethodStandard:dsAuthGetKerberosPrincipal"
#define kDSStdAuthGetPolicy "dsAuthMethodStandard:dsAuthGetPolicy"
#define kDSStdAuthGetUserData "dsAuthMethodStandard:dsAuthGetUserData"
#define kDSStdAuthGetUserName "dsAuthMethodStandard:dsAuthGetUserName"
#define kDSStdAuthMASKE_A "dsAuthMethodStandard:dsAuthMASKE-A"
#define kDSStdAuthMASKE_B "dsAuthMethodStandard:dsAuthMASKE-B"
#define kDSStdAuthMPPEMasterKeys "dsAuthMethodsStandard:dsAuthMPPEMasterKeys"
#define kDSStdAuthMSCHAP1 "dsAuthMethodStandard:dsAuthMSCHAP1"
#define kDSStdAuthMSCHAP2 "dsAuthMethodStandard:dsAuthMSCHAP2"
#define kDSStdAuthNTLMv2 "dsAuthMethodsStandard:dsAuthNodeNTLMv2"
#define kDSStdAuthNewUser "dsAuthMethodStandard:dsAuthNewUser"
#define kDSStdAuthNewUserWithPolicy  "dsAuthMethodsStandard:dsAuthNewUserWithPolicy"
#define kDSStdAuthNodeNativeClearTextOK  "dsAuthMethodStandard:dsAuthNodeNativeCanUseClearText"
#define kDSStdAuthNodeNativeNoClearText  "dsAuthMethodStandard:dsAuthNodeNativeCannotUseClearText"
#define kDSStdAuthReadSecureHash "dsAuthMethodStandard:dsAuthReadSecureHash"
#define kDSStdAuthSMBWorkStationCredentialSessionKey  "dsAuthMethodStandard:dsAuthSMBWorkStationCredentialSessionKey"
#define kDSStdAuthSMB_LM_Key "dsAuthMethodStandard:dsAuthSMBLMKey"
#define kDSStdAuthSMB_NT_Key "dsAuthMethodStandard:dsAuthSMBNTKey"
#define kDSStdAuthSMB_NT_UserSessionKey  "dsAuthMethodStandard:dsAuthSMBNTUserSessionKey"
#define kDSStdAuthSecureHash "dsAuthMethodStandard:dsAuthSecureHash"
#define kDSStdAuthSetGlobalPolicy "dsAuthMethodStandard:dsAuthSetGlobalPolicy"
#define kDSStdAuthSetLMHash "dsAuthMethodsStandard:dsAuthSetLMHash"
#define kDSStdAuthSetNTHash "dsAuthMethodsStandard:dsAuthSetNTHash"
#define kDSStdAuthSetPasswd "dsAuthMethodStandard:dsAuthSetPasswd"
#define kDSStdAuthSetPasswdAsRoot "dsAuthMethodStandard:dsAuthSetPasswdAsRoot"
#define kDSStdAuthSetPolicy "dsAuthMethodStandard:dsAuthSetPolicy"
#define kDSStdAuthSetPolicyAsRoot "dsAuthMethodStandard:dsAuthSetPolicyAsRoot"
#define kDSStdAuthSetUserData "dsAuthMethodStandard:dsAuthSetUserData"
#define kDSStdAuthSetUserName "dsAuthMethodStandard:dsAuthSetUserName"
#define kDSStdAuthSetWorkStationPasswd  "dsAuthMethodStandard:dsAuthSetWorkstationPasswd"
#define kDSStdAuthWithAuthorizationRef  "dsAuthMethodStandard:dsAuthWithAuthorizationRef"
#define kDSStdAuthWriteSecureHash "dsAuthMethodStandard:dsAuthWriteSecureHash"
Constants
kDSStdAuth2WayRandom

Two-way random authentication method. Deprecated in Mac OS X v10.3.

Available in Mac OS X v10.0 and later.
kDSStdAuth2WayRandomChangePasswd

Authentication method for changing the password of a user using the two-way random authentication method. Use of this authentication method does not require prior authentication. The packed buffer consists of a four byte length of username, the UTF-8 encoded user name, followed by four bytes specifying the length of the old password that follows, followed by the old password encrypted with the new password, followed by four bytes specifying the length of the new password, followed by the new password encrypted by the old password. Deprecated in Mac OS X v10.3.

Available in Mac OS X v10.2 and later.
kDSStdAuthAPOP

APOP authentication method.

Available in Mac OS X v10.0 and later.
kDSStdAuthCHAP

CHAP authentication.

Available in Mac OS X v10.3 and later.
kDSStdAuthCRAM_MD5

CRAM MD5 authentication method.

Available in Mac OS X v10.2 and later.
kDSStdAuthChangePasswd

Authentication method for changing passwords. When changing a password, send the following information in a single buffer: four bytes containing the length of the user name, the user name in UTF-8 encoding, four bytes containing the length of the old password, the old password in UTF-8 encoding, four bytes containing the length of the new password, and the new password in UTF-8 encoding.

Available in Mac OS X v10.0 and later.
kDSStdAuthClearText

Clear text authentication method.

Available in Mac OS X v10.0 and later.
kDSStdAuthCrypt

Crypt password authentication method. When performing crypt authentication, send the following information in a single buffer: four bytes containing the length of the user name, the user name in UTF-8 encoding, four bytes containing the length of the password, and the password in UTF-8 encoding. Open Directory plug-ins are not required to support this authentication method.

Available in Mac OS X v10.0 and later.
kDSStdAuthDIGEST_MD5

Digest MD5 authentication method.

Available in Mac OS X v10.2 and later.
kDSStdAuthDeleteUser

Authentication method used by the Apple Password Server for deleting a user.

Available in Mac OS X v10.2 and later.
kDSStdAuthGetEffectivePolicy

Used to extract from an Apple Password Server the combination of global and user policies that will be applied to a user.

Available in Mac OS X v10.3 and later.
kDSStdAuthGetGlobalPolicy

Authentication method used by the Apple Password Server plug-in for getting the global password policy.

Available in Mac OS X v10.2 and later.
kDSStdAuthGetKerberosPrincipal

Authentication method for getting the Kerberos Principal name.

Available in Mac OS X v10.3 and later.
kDSStdAuthGetPolicy

The Open Directory plug-in determines which authentication method to use. Prior to Mac OS X v10.4, this authentication method was used only by the Apple Password Server, which does not require authentication to use this authentication method. Starting with Mac OX X version 10.4, Shadow Hash authentication supports password policies, so use of kDSStdAuthGetPolicy is no longer limited to the Apple Password Server. Send the following items in a single buffer: four bytes containing the length of the authenticator’s UserID, the authenticator’s UserID in UTF-8 encoding, four bytes containing the length of the authenticator’s password, the authenticator’s password in UTF-8 encoding, four bytes containing the length of the UserID that follows, and the UserID in UTF-8 encoding of the account for which policies are to be obtained. The first and second items can be empty strings and the third item can be a username if calling a directory node. This authentication method is used by the Apple Password Server, which does not require authentication to use this authentication method.

Available in Mac OS X v10.2 and later.
kDSStdAuthGetUserData

Authentication method used by the Apple Password Server for getting a user’s data.

Available in Mac OS X v10.2 and later.
kDSStdAuthGetUserName

Authentication method used by the Apple Password Server for getting a user’s name.

Available in Mac OS X v10.2 and later.
kDSStdAuthMASKE_A

Retained for backward compatibility only.

Available in Mac OS X v10.2 and later.
kDSStdAuthMASKE_B

Retained for backward compatibility only.

Available in Mac OS X v10.2 and later.
kDSStdAuthMPPEMasterKeys

40- or 128-bit master key generated from MS-CHAPv2 credentials (RFC 3079).

Available in Mac OS X v10.4 and later.
kDSStdAuthMSCHAP1

MS-CHAP1 authentication method.

Available in Mac OS X v10.3 and later.
kDSStdAuthMSCHAP2

MS-CHAP2, a mutual authentication method. The Open Directory plug-in generates the data and sends it back to the client. The input buffer format consists of a four byte value specifying the length of the user name that follows, the user name, a four byte value specifying the length of the server challenge that follows, the server challenge, a four byte value specifying the length of the peer challenge that follows, the peer challenge, a four byte value specifying the length of the client’s digest that follows, and the client’s digest. The output buffer consists of a four byte value specifying the length of the return digest for the client’s challenge.

Available in Mac OS X v10.2 and later.
kDSStdAuthNTLMv2

NTLMv2 session key packed as follows: 4 byte length of username, username in UTF-8 encoding, four byte length of the Samba server challenge, the Samba server challenge, four byte length of the NTLMv2 client data, the client data (which includes 16 bytes of client digest prefixed to the client data), four byte length of the user name used to calculate the digest, the user name used to calculate the digest in UTF-8 encoding, four byte length of the Samba domain, and the Samba domain in UTF-8 encoding. If the NTLMv2 session key is supported, it is returned in the output buffer.

Available in Mac OS X v10.4 and later.
kDSStdAuthNewUser

Create a new user record with an authentication authority. Send the following information in a single buffer: four bytes containing the length of the authenticator’s UserID, the authenticator’s UserID in UTF-8 encoding, four bytes containing the length of the authenticator’s password, the authenticator’s password in UTF-8 encoding, four bytes containing the new user’s Short Name, the user’s Short Name, four byte length of the new user’s password, and the new user’s password. This authentication type is used by the Apple Password Server.

Available in Mac OS X v10.2 and later.
kDSStdAuthNewUserWithPolicy

Create a new user record with an authentication authority and initial policy settings. Send the following information in a single buffer: four bytes containing the length of the authenticator’s UserID, the authenticator’s UserID in UTF-8 encoding, four bytes containing the length of the authenticator’s password, the authenticator’s password in UTF-8 encoding, four bytes containing the new user’s Short Name, the user’s Short Name, four byte length of the user’s password, the new user’s password, four byte length of the policy string, and the policy string in UTF-8 encoding. This authentication type is used by the Apple Password Server.

Available in Mac OS X v10.4 and later.
kDSStdAuthNodeNativeClearTextOK

Native authentication method that allows clear text passwords. The Open Directory plug-in determines which authentication method to use and may decide to use clear text. When using this authentication method, send the following information in a single buffer: four bytes containing the length of the user name, the user name in UTF-8 encoding, four bytes containing the password, and the password in UTF-8 encoding.

Available in Mac OS X v10.0 and later.
kDSStdAuthNodeNativeNoClearText

Native authentication method that does not allow clear text passwords. The Open Directory plug-in determines which authentication method to use but must not use clear text. When using this authentication method, send the following information in a single buffer: four bytes containing the length of the user name, the user name in UTF-8 encoding, four bytes containing the password, and the password in UTF-8 encoding.

Available in Mac OS X v10.0 and later.
kDSStdAuthReadSecureHash

Allows a root process to read the secure hash attribute of a user record directly.

Available in Mac OS X v10.3 and later.
kDSStdAuthSMBNTv2UserSessionKey

Used to generate an NTLMv2 user session key; requires prior authentication using a trusted authentication method. The buffer is packed as follows: four byte length of the directory services name, the directory services name in UTF-8 encoding, four byte length of the server challenge, eight byte server challenge, four byte length of the client response, and the client response buffer.

Available in Mac OS X v10.4 and later.
kDSStdAuthSMBWorkstationCredentialSessionKey

SMB workstation credential session key authentication; used to support PDC SMB iteration with Open Directory.

Available in Mac OS X v10.3 and later.
kDSStdAuthSMB_LM_Key

SMB LAN Manager authentication method that uses DES.

Available in Mac OS X v10.0 and later.
kDSStdAuthSMB_NT_Key

MD5 hash-based SMB authentication method.

Available in Mac OS X v10.0 and later.
kDSStdAuthSMB_NT_UserSessionKey

SMB NT session key authentication; used to support PDC SMB iteration with Open Directory.

Available in Mac OS X v10.3 and later.
kDSStdAuthSecureHash

Secure Hash authentication method.

Available in Mac OS X v10.3 and later.
kDSStdAuthSetGlobalPolicy

Authentication method used by the Apple Password Server plug-in for setting the global password policy, such as the minimum password length, time before a password expires, and maximum number of failed logins allowed. Starting with Mac OS X verion 10.4, this authentication method can also be used with ShadowHash on local NetInfo data.

Available in Mac OS X v10.2 and later.
kDSStdAuthSetLMHash

Used to set the LAN Manager hash for a user; requires prior authentication using a trusted authentication method. The buffer is packed as follows: four byte length of the user name, the user name in UTF-8 encoding, four byte length of the LAN Manager hash, and the LAN Manager hash buffer (24 bytes).

Available in Mac OS X v10.4 and later.
kDSStdAuthSetNTHash

Used to set the NT hash for a user; requires prior authentication using a trusted authentication method. The buffer is packed as follows: four byte length of the user name, the user name in UTF-8 encoding, four byte length of the NT hash, and the NT hash buffer (24 bytes).

Available in Mac OS X v10.4 and later.
kDSStdAuthSetPasswd

Authentication method for setting passwords. The buffer is packed as follows: four byte length of the authenticator username, an authenticator username in UTF-8 encoding, four byte length of the authenticator password, authenticator password in UTF-8 encoding, four byte length of the target username, target username in UTF-8 encoding, four byte length of the new password, and the new password in UTF-8 encoding. The authenticator is usually an administrator that has permission to change the target user’s password.

Available in Mac OS X v10.0 and later.
kDSStdAuthSetPasswdAsRoot

Authentication method used by root processes that allow the setting of passwords using Basic or Shadow Hash authentication on local domains. This authentication method also works if you previously called dsDoDirNodeAuth or dsDoDirNodeAuthOnRecordType and set the inDirNodeAuthOnly or inDirNodeAuthOnlyFlag parameter, respectively, to FALSE. In this case, your previous credentials determine whether the set password operation succeeds. For example, administrators can usually set any user’s password because their credentials have saved by setting the inDirNodeAuthOnly or inDirNoeAuthOnlyFlag parameter to FALSE.

Available in Mac OS X v10.0 and later.
kDSStdAuthSetPolicy

The Open Directory plug-in determines which authentication method to use. Send the following information in a single buffer: four bytes containing the length of authenticator’s UserID, the authenticator’s UserID in UTF-8 encoding, four bytes containing the length of the authenticator’s password, the authenticator’s password in UTF-8 encoding, four bytes containing the length of the UserID of the account that is setting policies, and the UserID of the account that is setting policies in UTF-8 encoding. This authentication type is used by the Apple Password Server and, starting with Mac OS X v10.4, can be used with ShadowHash on local NetInfo data.

Available in Mac OS X v10.2 and later.
kDSStdAuthSetPolicyAsRoot

A two-item buffer version of set policy for the Apple Password Server. Available in Mac OS X v10.3 and later. Starting with Mac OS X v10.4, this authentication method can be used with ShadowHash on local NetInfo data.

Available in Mac OS X v10.3 and later.
kDSStdAuthSetUserData

Authentication method used by the Apple Password Server for setting user’s data.

Available in Mac OS X v10.2 and later.
kDSStdAuthSetUserName

Authentication method used by the Apple Password Server for setting a user’s name.

Available in Mac OS X v10.2 and later.
kDSStdAuthSetWorkstationPasswd

Authentication method used to set the workstation password; used to support PDC SMB iteration with Open Directory.

Available in Mac OS X v10.3 and later.
kDSStdAuthWithAuthorizationRef

Allows access to local directories as root with a valid AuthorizationRef. Input buffer format consists of an externalized AuthorizationRef.

Available in Mac OS X v10.3 and later.
kDSStdAuthWriteSecureHash

Allows a root process to write the secure hash attribute of a user record directly.

Available in Mac OS X v10.3 and later.
Declared In
DirectoryService/DirServicesConst.h*/

#define kDSStdAuth2WayRandom "dsAuthMethodStandard:dsAuth2WayRandom"
#define kDSStdAuth2WayRandomChangePasswd  "dsAuthMethodStandard:dsAuth2WayRandomChangePasswd"
#define kDSStdAuthAPOP "dsAuthMethodStandard:dsAuthAPOP"
#define kDSStdAuthCHAP "dsAuthMethodStandard:dsAuthCHAP"
#define kDSStdAuthCRAM_MD5 "dsAuthMethodStandard:dsAuthNodeCRAM-MD5"
#define kDSStdAuthChangePasswd "dsAuthMethodStandard:dsAuthChangePasswd"
#define kDSStdAuthClearText "dsAuthMethodStandard:dsAuthClearText"
#define kDSStdAuthCrypt "dsAuthMethodStandard:dsAuthCrypt"
#define kDSStdAuthDIGEST_MD5 "dsAuthMethodStandard:dsAuthNodeDIGEST-MD5"
#define kDSStdAuthDeleteUser "dsAuthMethodStandard:dsAuthDeleteUser"
#define kDSStdAuthGetEffectivePolicy  "dsAuthMethodStandard:dsAuthGetEffectivePolicy"
#define kDSStdAuthGetGlobalPolicy "dsAuthMethodStandard:dsAuthGetGlobalPolicy"
#define kDSStdAuthGetKerberosPrincipal  "dsAuthMethodStandard:dsAuthGetKerberosPrincipal"
#define kDSStdAuthGetPolicy "dsAuthMethodStandard:dsAuthGetPolicy"
#define kDSStdAuthGetUserData "dsAuthMethodStandard:dsAuthGetUserData"
#define kDSStdAuthGetUserName "dsAuthMethodStandard:dsAuthGetUserName"
#define kDSStdAuthMASKE_A "dsAuthMethodStandard:dsAuthMASKE-A"
#define kDSStdAuthMASKE_B "dsAuthMethodStandard:dsAuthMASKE-B"
#define kDSStdAuthMPPEMasterKeys "dsAuthMethodsStandard:dsAuthMPPEMasterKeys"
#define kDSStdAuthMSCHAP1 "dsAuthMethodStandard:dsAuthMSCHAP1"
#define kDSStdAuthMSCHAP2 "dsAuthMethodStandard:dsAuthMSCHAP2"
#define kDSStdAuthNTLMv2 "dsAuthMethodsStandard:dsAuthNodeNTLMv2"
#define kDSStdAuthNewUser "dsAuthMethodStandard:dsAuthNewUser"
#define kDSStdAuthNewUserWithPolicy  "dsAuthMethodsStandard:dsAuthNewUserWithPolicy"
#define kDSStdAuthNodeNativeClearTextOK  "dsAuthMethodStandard:dsAuthNodeNativeCanUseClearText"
#define kDSStdAuthNodeNativeNoClearText  "dsAuthMethodStandard:dsAuthNodeNativeCannotUseClearText"
#define kDSStdAuthReadSecureHash "dsAuthMethodStandard:dsAuthReadSecureHash"
#define kDSStdAuthSMBWorkStationCredentialSessionKey  \ "dsAuthMethodStandard:dsAuthSMBWorkStationCredentialSessionKey"
#define kDSStdAuthSMB_LM_Key "dsAuthMethodStandard:dsAuthSMBLMKey"
#define kDSStdAuthSMB_NT_Key "dsAuthMethodStandard:dsAuthSMBNTKey"
#define kDSStdAuthSMB_NT_UserSessionKey  "dsAuthMethodStandard:dsAuthSMBNTUserSessionKey"
#define kDSStdAuthSecureHash "dsAuthMethodStandard:dsAuthSecureHash"
#define kDSStdAuthSetGlobalPolicy "dsAuthMethodStandard:dsAuthSetGlobalPolicy"
#define kDSStdAuthSetLMHash "dsAuthMethodsStandard:dsAuthSetLMHash"
#define kDSStdAuthSetNTHash "dsAuthMethodsStandard:dsAuthSetNTHash"
#define kDSStdAuthSetPasswd "dsAuthMethodStandard:dsAuthSetPasswd"
#define kDSStdAuthSetPasswdAsRoot "dsAuthMethodStandard:dsAuthSetPasswdAsRoot"
#define kDSStdAuthSetPolicy "dsAuthMethodStandard:dsAuthSetPolicy"
#define kDSStdAuthSetPolicyAsRoot "dsAuthMethodStandard:dsAuthSetPolicyAsRoot"
#define kDSStdAuthSetUserData "dsAuthMethodStandard:dsAuthSetUserData"
#define kDSStdAuthSetUserName "dsAuthMethodStandard:dsAuthSetUserName"
#define kDSStdAuthSetWorkStationPasswd  "dsAuthMethodStandard:dsAuthSetWorkstationPasswd"
#define kDSStdAuthWithAuthorizationRef  "dsAuthMethodStandard:dsAuthWithAuthorizationRef"
#define kDSStdAuthWriteSecureHash "dsAuthMethodStandard:dsAuthWriteSecureHash"


/*User and Group Record Attribute Constants

Constants for accessing attributes typically found in records of type kDSStdRecordTypeUsers and kDSStdRecordTypeGroups.

#define kDS1AttrAdminLimits "dsAttrTypeStandard:AdminLimits"
#define kDS1AttrAdminStatus "dsAttrTypeStandard:AdminStatus"
#define kDS1AttrAlternateDatastoreLocation  "dsAttrTypeStandard:AlternateDatastoreLocation"
#define kDS1AttrAuthenticationHint "dsAttrTypeStandard:AuthenticationHint"
#define kDS1AttrChange "dsAttrTypeStandard:Change"
#define kDS1AttrComment "dsAttrTypeStandard:Comment"
#define kDS1AttrDistinguishedName "dsAttrTypeStandard:RealName"
#define kDS1AttrExpire "dsAttrTypeStandard:Expire"
#define kDS1AttrFirstName "dsAttrTypeStandard:FirstName"
#define kDS1AttrGeneratedUID "dsAttrTypeStandard:GeneratedUID"
#define kDS1AttrHomeDirectorySoftQuota  "dsAttrTypeStandard:HomeDirectorySoftQuota"
#define kDS1AttrHomeDirectoryQuota "dsAttrTypeStandard:HomeDirectoryQuota"
#define kDS1AttrHomeLocOwner "dsAttrTypeStandard:HomeLocOwner"
#define kDS1AttrInternetAlias "dsAttrTypeStandard:InetAlias"
#define kDS1AttrLastName "dsAttrTypeStandard:LastName"
#define kDS1AttrMailAttribute "dsAttrTypeStandard:MailAttribute"
#define kDS1AttrMiddleName "dsAttrTypeStandard:MiddleName"
#define kDS1AttrNFSHomeDirectory "dsAttrTypeStandard:NFSHomeDirectory"
#define kDS1AttrOriginalNFSHomeDirectory  "dsAttrTypeStandard:OriginalNFSHomeDirectory"
#define kDS1AttrPassword "dsAttrTypeStandard:Password"
#define kDS1AttrPasswordPlus "dsAttrTypeStandard:PasswordPlus"
#define kDS1AttrPicture "dsAttrTypeStandard:Picture"
#define kDS1AttrPrimaryGroupID "dsAttrTypeStandard:PrimaryGroupID"
#define kDS1AttrRealuserID "dsAttrTypeStandard:RealUserID"
#define kDS1AttrUniqueID "dsAttrTypeStandard:UniqueID"
#define kDS1AttrUserShell "dsAttrTypeStandard:UserShell"
#define kDSNAttrAddressLine1 "dsAttrTypeStandard:AddressLine1"
#define kDS1StandardAttrHomeLocOwner "DS1AttrHomeLocOwner"
#define kDSNAttrAddressLine2 "dsAttrTypeStandard:AddressLine2"
#define kDSNAttrAddressLine3 "dsAttrTypeStandard:AddressLine3"
#define kDSNAttrAreaCode "dsAttrTypeStandard:AreaCode"
#define kDSNAttrAuthenticationAuthority  "dsAttrTypeStandard:AuthenticationAuthority"
#define kDSNAttrBuilding "dsAttrTypeStandard:Building"
#define kDSNAttrCity "dsAttrTypeStandard:City"
#define kDSNAttrCountry "dsAttrTypeStandard:Country"
#define kDSNAttrDepartment "dsAttrTypeStandard:Department"
#define kDSNAttrEMailAddress "dsAttrTypeStandard:EMailAddress"
#define kDSNAttrFaxNumber "dsAttrTypeStandard:FAXNumber"
#define kDSNAttrGroupMembers "dsAttrTypeStandard:GroupMembers
#define kDSNAttrGroupMembership "dsAttrTypeStandard:GroupMembership"
#define kDSNAttrHomeDirectory "dsAttrTypeStandard:HomeDirectory"
#define kDSNAttrIMHandle "dsAttrTypeStandard:IMHandle"
#define kDSNAttrJobTitle "dsAttrTypeStandard:JobTitle"
#define kDSNAttrMobileNumber "dsAttrTypeStandard:MobileNumber"
#define kDSNAttrNamePrefix "dsAttrTypeStandard:NamePrefix"
#define kDSNAttrNameSuffix "dsAttrTypeStandard:NameSuffix"
#define kDSNAttrNestedGroups "dsAttrTypeStandard:NestedGroups"
#define kDSNAttrNetGroups "dsAttrTypeStandard:NetGroups"
#define kDSNAttrNickName "dsAttrTypeStandard:NickName"
#define kDSNAttrOrganizationName "dsAttrTypeStandard:OrganizationName"
#define kDSNAttrOriginalHomeDirectory  "dsAttrTypeStandard:OriginalHomeDirectory"
#define kDSNAttrPagerNumber "dsAttrTypeStandard:PagerNumber"
#define kDSNAttrPhoneNumber "dsAttrTypeStandard:PhoneNumber"
#define kDSNAttrPostalAddress "dsAttrTypeStandard:PostalAddress"
#define kDSNAttrPostalCode "dsAttrTypeStandard:PostalCode"
#define kDSNAttrState "dsAttrTypeStandard:State"
#define kDSNAttrStreet "dsAttrTypeStandard:Street"
Constants
kDS1AttrAdminLimits

Single-value attribute for storing an XML plist indicating what the user can edit as an administrator.

Available in Mac OS X v10.2 and later.
kDS1AttrAdminStatus

Single-value attribute for storing an administrator status; retained for backward compatibility.

Available in Mac OS X v10.0 and later.
kDS1AttrAlternateDatastoreLocation

Single-value attribute for storing the UNIX path to the location at which a user’s e-mail is stored.

Available in Mac OS X v10.3 and later.
kDS1AttrAuthenticationHint

Single-value attribute for storing the authentication hint that is displayed when an incorrect password is entered several times at loginwindow.

Available in Mac OS X v10.0 and later.
kDS1AttrChange

Single-value attribute whose value indicates whether a password needs to be changed. Currently not used and usually set to zero; the Password Server and ShadowHash provide this functionality now.

Available in Mac OS X v10.1 and later.
kDS1AttrComment

Single-value attribute for storing an unformatted comment.

Available in Mac OS X v10.0 and later.
kDSNAttrDepartment

Multi-value attribute for storing the department name of a user or group.

Available in Mac OS X v10.3 and later.
kDS1AttrDistinguishedName

Single-value attribute for storing a user’s real name.

Available in Mac OS X v10.0 and later.
kDS1AttrExpire

Single-value attribute used for storing an expiration date or time, depending on the context. Currently not used and usually set to zero; the Password Server and ShadowHash provide this functionality now.

Available in Mac OS X v10.1 and later.
kDS1AttrFirstName

Single-value attribute for storing a user’s first name.

Available in Mac OS X v10.2 and later.
kDS1AttrGeneratedUID

Single-value attribute for storing a universal unique identifier (UUID) consisting of 32 characters containing hexadecimal data, plus four dash ( - ) characters, for a total of 36 characters, or 128 bits.

Available in Mac OS X v10.0 and later.
kDS1AttrHomeDirectorySoftQuota

Single-value attribute for storing the home directory size limit in bytes at which the user is notified that the hard limit has nearly been reached.

Available in Mac OS X v10.3 and later.
kDS1AttrHomeDirectoryQuota

Single-value attribute for storing the allowed usage in bytes for a user’s home directory.

Available in Mac OS X v10.2 and later.
kDS1AttrHomeLocOwner

Single-value attribute for storing the owner of a workgroup’s shared home directory.

Available in Mac OS X v10.2 and later.
kDS1AttrInternetAlias

Single-value attribute used to track Internet aliases.

Available in Mac OS X v10.0 and later.
kDS1AttrLastName

Single-value attribute for storing a user’s last name.

Available in Mac OS X v10.2 and later.
kDS1AttrMailAttribute

Single-value attribute for storing mail account configuration information.

Available in Mac OS X v10.0 and later.
kDS1AttrMiddleName

Single-value attribute for storing a user’s middle name.

Available in Mac OS X v10.2 and later.
kDS1AttrNFSHomeDirectory

Single-value attribute for storing a user’s home directory path on the local machine.

Available in Mac OS X v10.1 and later.
kDS1AttrOriginalNFSHomeDirectory

Single-value attribute used in local account caching for storing the user’s original NFS home directory path.

Available in Mac OS X v10.3 and later.
kDS1AttrPassword

Single-value attribute for storing a password or credential value.

Available in Mac OS X v10.0 and later.
kDS1AttrPasswordPlus

Single-value attribute for storing marker data to indicate possible authentication redirection.

Available in Mac OS X v10.1 and later.
kDS1AttrPicture

Single-value attribute for storing the path to the picture of each user displayed in the login window.

Available in Mac OS X v10.2 and later.
kDS1AttrPrimaryGroupID

Single-value attribute for storing the signed 32-bit unique ID representing the primary group of which the user is a member, stored in string format.

Available in Mac OS X v10.0 and later.
kDS1AttrRealUserID

Single-value attribute for storing the user’s real user ID; used to support managed desktop features.

Available in Mac OS X v10.3 and later.
kDS1AttrUniqueID

Single-value attribute for storing a 32-bit unique ID representing the user in the legacy manner and stored in string format.

Available in Mac OS X v10.0 and later.
kDS1AttrUserShell

Single-value attribute for storing the user’s shell setting.

Available in Mac OS X v10.0 and later.
kDSNAttrAddressLine1

Multi-value attribute for storing the first line of an address.

Available in Mac OS X v10.2 and later.
kDSNAttrAddressLine2

Multi-value attribute for storing the second line of an address.

Available in Mac OS X v10.2 and later.
kDSNAttrAddressLine3

Multi-value attribute for storing the third line of an address.

Available in Mac OS X v10.2 and later.
kDSNAttrAreaCode

Multi-value attribute for storing area codes.

Available in Mac OS X v10.2 and later.
kDSNAttrAuthenticationAuthority

Multi-value attribute for storing the mechanism to use when verifying or setting a user’s password. If this attribute has multiple values, the first attribute returned takes precedence. This attribute is typically found in records of type kDSStdRecordTypeUsers and kDSStdRecordTypeComputers.

Available in Mac OS X v10.2 and later.
kDSNAttrBuilding

Multi-value attribute for storing the building name of a user or person.

Available in Mac OS X v10.3 and later.
kDSNAttrCity

Multi-value attribute for storing the names of cities; usually found in a record of type kDSStdRecordTypeUsers.

Available in Mac OS X v10.2 and later.
kDSNAttrCountry

Multi-value attribute for storing the country of a user or person; usually found in records of type kDSStdRecordTypeUsers.

Available in Mac OS X v10.3 and later.
kDSNAttrEMailAddress

Multi-value attribute for storing e-mail addresses; usually found in records of type kDSStdRecordTypeUsers. 

Available in Mac OS X v10.0 and later.
kDSNAttrFaxNumber

Multi-value attribute for storing the fax numbers of a user or person; usually found in records of type kDSStdRecordTypeUsers.

Available in Mac OS X v10.3 and later.
kDSNAttrGroupMembers

Multi-value attribute listing member user records by record name. Found in records of type kDSStdRecordTypeGroups.

Available in Mac OS X v10.3 and later.
kDSNAttrGroupMembership

Multi-value attribute for storing the users that belong to a given group record.

Available in Mac OS X v10.0 and later.
kDSNAttrHomeDirectory

Multi-value attribute for storing network home directory URLs.

Available in Mac OS X v10.0 and later.
kDSNAttrIMHandle

Multi-value attribute for storing the Instant Messaging handles of a user. Values should be prefixed with the appropriate IM type, such as AIM:, Jabber:, MSN:, Yahoo:, and ICQ:.

Available in Mac OS X v10.3 and later.
kDSNAttrJobTitle

Multi-value attribute for storing the job title of a user; usually found in records of type kDSStdRecordTypeUsers.

Available in Mac OS X v10.3 and later.
kDSNAttrMobileNumber

Multi-value attribute for storing the mobile numbers of a user or person; usually found in records of type kDSStdRecordTypeUsers.

Available in Mac OS X v10.3 and later.
kDSNAttrNamePrefix

Multi-value attribute for storing the name prefix of a user, such as Mr., Ms., Mrs., or Dr.

Available in Mac OS X v10.3 and later.
kDSNAttrNameSuffix

Multi-value attribute for storing the name suffix of a user, such as Jr., or Sr.

Available in Mac OS X v10.3 and later.
kDSNAttrNestedGroups

Multi-value attribute for storing GUID values for nested groups; found in records of type kDSStdRecordTypeGroups. This attribute is supported in Mac OS X v10.4 and later.

Available in Mac OS X v10.4 and later.
kDSNAttrNetGroups

Multi-value attribute for storing the net groups in which the record is a member. This attribute is found in records of type kDSStdRecordTypeUsers, kDSStdRecordTypeHosts, and kDSStdRecordTypeNetDomains.

Available in Mac OS X v10.2 and later.
kDSNAttrNickName

Multi-value attribute for storing the nickname of a user or group.

Available in Mac OS X v10.3 and later.
kDSNAttrOrganizationName

Multi-value attribute for storing organization names.

Available in Mac OS X v10.2 and later.
kDSNAttrOriginalHomeDirectory

Multi-value attribute for storing home directory URL used in local account caching.

Available in Mac OS X v10.3 and later.
kDSNAttrPagerNumber

Multi-value attribute for storing the pager numbers of a user or person; usually found in records of type kDSStdRecordTypeUsers.

Available in Mac OS X v10.3 and later.
kDSNAttrPhoneNumber

Multi-value attribute for storing phone numbers.

Available in Mac OS X v10.0 and later.
kDSNAttrPostalAddress

Multi-value attribute for storing postal addresses; usually excludes the postal code.

Available in Mac OS X v10.0 and later.
kDSNAttrPostalCode

Multi-value attribute for storing postal codes such as zip codes.

Available in Mac OS X v10.2 and later.
kDSNAttrState

Multi-value attribute for storing the names of states or provinces.

Available in Mac OS X v10.2 and later.
kDSNAttrStreet

Multi-value attribute for storing the street address of a user or person; usually found in records of type kDSStdRecordTypeUsers.

Available in Mac OS X v10.3 and later.
Declared In
DirectoryService/DirServicesConst.h*/
#define kDS1AttrAdminLimits "dsAttrTypeStandard:AdminLimits"
#define kDS1AttrAdminStatus "dsAttrTypeStandard:AdminStatus"
#define kDS1AttrAlternateDatastoreLocation  "dsAttrTypeStandard:AlternateDatastoreLocation"
#define kDS1AttrAuthenticationHint "dsAttrTypeStandard:AuthenticationHint"
#define kDS1AttrChange "dsAttrTypeStandard:Change"
#define kDS1AttrComment "dsAttrTypeStandard:Comment"
#define kDS1AttrDistinguishedName "dsAttrTypeStandard:RealName"
#define kDS1AttrExpire "dsAttrTypeStandard:Expire"
#define kDS1AttrFirstName "dsAttrTypeStandard:FirstName"
#define kDS1AttrGeneratedUID "dsAttrTypeStandard:GeneratedUID"
#define kDS1AttrHomeDirectorySoftQuota  "dsAttrTypeStandard:HomeDirectorySoftQuota"
#define kDS1AttrHomeDirectoryQuota "dsAttrTypeStandard:HomeDirectoryQuota"
#define kDS1AttrHomeLocOwner "dsAttrTypeStandard:HomeLocOwner"
#define kDS1AttrInternetAlias "dsAttrTypeStandard:InetAlias"
#define kDS1AttrLastName "dsAttrTypeStandard:LastName"
#define kDS1AttrMailAttribute "dsAttrTypeStandard:MailAttribute"
#define kDS1AttrMiddleName "dsAttrTypeStandard:MiddleName"
#define kDS1AttrNFSHomeDirectory "dsAttrTypeStandard:NFSHomeDirectory"
#define kDS1AttrOriginalNFSHomeDirectory  "dsAttrTypeStandard:OriginalNFSHomeDirectory"
#define kDS1AttrPassword "dsAttrTypeStandard:Password"
#define kDS1AttrPasswordPlus "dsAttrTypeStandard:PasswordPlus"
#define kDS1AttrPicture "dsAttrTypeStandard:Picture"
#define kDS1AttrPrimaryGroupID "dsAttrTypeStandard:PrimaryGroupID"
#define kDS1AttrRealUserID kDS1AttrRealuserID
#define kDS1AttrRealuserID "dsAttrTypeStandard:RealUserID"
#define kDS1AttrUniqueID "dsAttrTypeStandard:UniqueID"
#define kDS1AttrUserShell "dsAttrTypeStandard:UserShell"
#define kDSNAttrAddressLine1 "dsAttrTypeStandard:AddressLine1"
#define kDS1StandardAttrHomeLocOwner "DS1AttrHomeLocOwner"
#define kDSNAttrAddressLine2 "dsAttrTypeStandard:AddressLine2"
#define kDSNAttrAddressLine3 "dsAttrTypeStandard:AddressLine3"
#define kDSNAttrAreaCode "dsAttrTypeStandard:AreaCode"
#define kDSNAttrAuthenticationAuthority  "dsAttrTypeStandard:AuthenticationAuthority"
#define kDSNAttrBuilding "dsAttrTypeStandard:Building"
#define kDSNAttrCity "dsAttrTypeStandard:City"
#define kDSNAttrCountry "dsAttrTypeStandard:Country"
#define kDSNAttrDepartment "dsAttrTypeStandard:Department"
#define kDSNAttrEMailAddress "dsAttrTypeStandard:EMailAddress"
#define kDSNAttrFaxNumber "dsAttrTypeStandard:FAXNumber"
#define kDSNAttrGroupMembers "dsAttrTypeStandard:GroupMembers"
#define kDSNAttrGroupMembership "dsAttrTypeStandard:GroupMembership"
#define kDSNAttrHomeDirectory "dsAttrTypeStandard:HomeDirectory"
#define kDSNAttrIMHandle "dsAttrTypeStandard:IMHandle"
#define kDSNAttrJobTitle "dsAttrTypeStandard:JobTitle"
#define kDSNAttrMobileNumber "dsAttrTypeStandard:MobileNumber"
#define kDSNAttrNamePrefix "dsAttrTypeStandard:NamePrefix"
#define kDSNAttrNameSuffix "dsAttrTypeStandard:NameSuffix"
#define kDSNAttrNestedGroups "dsAttrTypeStandard:NestedGroups"
#define kDSNAttrNetGroups "dsAttrTypeStandard:NetGroups"
#define kDSNAttrNickName "dsAttrTypeStandard:NickName"
#define kDSNAttrOrganizationName "dsAttrTypeStandard:OrganizationName"
#define kDSNAttrOriginalHomeDirectory  "dsAttrTypeStandard:OriginalHomeDirectory"
#define kDSNAttrPagerNumber "dsAttrTypeStandard:PagerNumber"
#define kDSNAttrPhoneNumber "dsAttrTypeStandard:PhoneNumber"
#define kDSNAttrPostalAddress "dsAttrTypeStandard:PostalAddress"
#define kDSNAttrPostalCode "dsAttrTypeStandard:PostalCode"
#define kDSNAttrState "dsAttrTypeStandard:State"
#define kDSNAttrStreet "dsAttrTypeStandard:Street"


#endif
