#ifndef CGBITMAPCONTEXT_H
#define CGBITMAPCONTEXT_H

#include <CoreGraphics/CGBase.h>
#include <CoreGraphics/CGContext.h>

/*CGBitmapContextCreate

Creates a bitmap graphics context.

CGContextRef CGBitmapContextCreate (
   void * data,
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo
);
Parameters
data

A pointer to the destination in memory where the drawing is to be rendered. The size of this memory block should be at least (bytesPerRow*height) bytes.
width

The width, in pixels, of the required bitmap.
height

The height, in pixels, of the required bitmap.
bitsPerComponent

The number of bits to use for each component of a pixel in memory. For example, for a 32-bit pixel format and an RGB color space, you would specify a value of 8 bits per component. For more information about supported pixel formats, see Quartz 2D Programming Guide.
bytesPerRow

The number of bytes of memory to use per row of the bitmap.
colorspace

The color space to use for the bitmap context. Note that indexed color spaces are not supported for bitmap graphics contexts.
bitmapInfo

A CGBitmapInfo constant that specifies whether the bitmap should contain an alpha channel and its relative location in a pixel, along with whether the components are floating-point or integer values. See CGImage Reference for a description of CGBitmapInfo constants. 
Return Value

A new bitmap context, or NULL if a context could not be created. You are responsible for releasing this object using CGContextRelease.
Discussion

When you call this function, Quartz creates a bitmap drawing environment—that is, a bitmap context—to your specifications. When you draw into this context, Quartz renders your drawing as bitmapped data in the specified block of memory.

The pixel format for a new bitmap context is determined by three parameters—the number of bits per component, the color space, and an alpha option (expressed as a CGBitmapInfo constant). The alpha value determines the opacity of a pixel when it is drawn.

For more information see, Creating a Bitmap Graphics Context.
Availability
Available in Mac OS X version 10.0 and later.
Declared In
CGBitmapContext.h*/

CGContextRef CGBitmapContextCreate (
   void * data,
   size_t width,
   size_t height,
   size_t bitsPerComponent,
   size_t bytesPerRow,
   CGColorSpaceRef colorspace,
   CGBitmapInfo bitmapInfo
);

/*CGBitmapContextCreateImage

Creates an image that is a copy of a bitmap graphics context.

CGImageRef CGBitmapContextCreateImage(
   CGContextRef c
);
Parameters
c

A bitmap graphics context.
Return Value

A CGImage object that contains a snapshot of the bitmap graphics context or NULL if the image is not created.
Discussion

The CGImage object returned by this function is created by a copy operation. Subsequent changes to the bitmap graphics context do not affect the contents of the returned image. In some cases the copy operation actually follows copy-on-write semantics, so that the actual physical copy of the bits occur only if the underlying data in the bitmap graphics context is modified. As a consequence, you may want to use the resulting image and release it before you perform additional drawing into the bitmap graphics context. In this way, you can avoid the actual physical copy of the data.
Availability
Available in Mac OS X v10.4 and later.
Declared In
CGBitmapContext.h*/
CGImageRef CGBitmapContextCreateImage(
   CGContextRef c
);

/*CGBitmapContextGetData

Returns a pointer to the image data associated with a bitmap context.

void *CGBitmapContextGetData (
CGContextRef context
);
Parameters
context

The bitmap context to examine.
Return Value

A pointer to the specified bitmap context’s image data, or NULL if the context is not a bitmap context.
Availability
Available in Mac OS X version 10.2 and later.
Declared In
CGBitmapContext.h*/
void *CGBitmapContextGetData (
CGContextRef context
);


#endif