#ifndef CFSTRINGENCODINGEXT_H
#define CFSTRINGENCODINGEXT_H

#include <CoreFoundation/CFBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*External String Encodings

Encodings that may be supported by CFString.

typedef enum {
   kCFStringEncodingMacJapanese = 1,
   kCFStringEncodingMacChineseTrad = 2,
   kCFStringEncodingMacKorean = 3,
   kCFStringEncodingMacArabic = 4,
   kCFStringEncodingMacHebrew = 5,
   kCFStringEncodingMacGreek = 6,
   kCFStringEncodingMacCyrillic = 7,
   kCFStringEncodingMacDevanagari = 9,
   kCFStringEncodingMacGurmukhi = 10,
   kCFStringEncodingMacGujarati = 11,
   kCFStringEncodingMacOriya = 12,
   kCFStringEncodingMacBengali = 13,
   kCFStringEncodingMacTamil = 14,
   kCFStringEncodingMacTelugu = 15,
   kCFStringEncodingMacKannada = 16,
   kCFStringEncodingMacMalayalam = 17,
   kCFStringEncodingMacSinhalese = 18,
   kCFStringEncodingMacBurmese = 19,
   kCFStringEncodingMacKhmer = 20,
   kCFStringEncodingMacThai = 21,
   kCFStringEncodingMacLaotian = 22,
   kCFStringEncodingMacGeorgian = 23,
   kCFStringEncodingMacArmenian = 24,
   kCFStringEncodingMacChineseSimp = 25,
   kCFStringEncodingMacTibetan = 26,
   kCFStringEncodingMacMongolian = 27,
   kCFStringEncodingMacEthiopic = 28,
   kCFStringEncodingMacCentralEurRoman = 29,
   kCFStringEncodingMacVietnamese = 30,
   kCFStringEncodingMacExtArabic = 31,
   kCFStringEncodingMacSymbol = 33,
   kCFStringEncodingMacDingbats = 34,
   kCFStringEncodingMacTurkish = 35,
   kCFStringEncodingMacCroatian = 36,
   kCFStringEncodingMacIcelandic = 37,
   kCFStringEncodingMacRomanian = 38,
   kCFStringEncodingMacCeltic = 39,
   kCFStringEncodingMacGaelic = 40,
   kCFStringEncodingMacFarsi = 0x8C,
   kCFStringEncodingMacUkrainian = 0x98,
   kCFStringEncodingMacInuit = 0xEC,
   kCFStringEncodingMacVT100 = 0xFC,
   kCFStringEncodingMacHFS = 0xFF,
   kCFStringEncodingISOLatin1 = 0x0201,
   kCFStringEncodingISOLatin2 = 0x0202,
   kCFStringEncodingISOLatin3 = 0x0203,
   kCFStringEncodingISOLatin4 = 0x0204,
   kCFStringEncodingISOLatinCyrillic = 0x0205,
   kCFStringEncodingISOLatinArabic = 0x0206,
   kCFStringEncodingISOLatinGreek = 0x0207,
   kCFStringEncodingISOLatinHebrew = 0x0208,
   kCFStringEncodingISOLatin5 = 0x0209,
   kCFStringEncodingISOLatin6 = 0x020A,
   kCFStringEncodingISOLatinThai = 0x020B,
   kCFStringEncodingISOLatin7 = 0x020D,
   kCFStringEncodingISOLatin8 = 0x020E,
   kCFStringEncodingISOLatin9 = 0x020F,
   kCFStringEncodingISOLatin10 = 0x0210,
   kCFStringEncodingDOSLatinUS = 0x0400,
   kCFStringEncodingDOSGreek = 0x0405,
   kCFStringEncodingDOSBalticRim = 0x0406,
   kCFStringEncodingDOSLatin1 = 0x0410,
   kCFStringEncodingDOSGreek1 = 0x0411,
   kCFStringEncodingDOSLatin2 = 0x0412,
   kCFStringEncodingDOSCyrillic = 0x0413,
   kCFStringEncodingDOSTurkish = 0x0414,
   kCFStringEncodingDOSPortuguese = 0x0415,
   kCFStringEncodingDOSIcelandic = 0x0416,
   kCFStringEncodingDOSHebrew = 0x0417,
   kCFStringEncodingDOSCanadianFrench = 0x0418,
   kCFStringEncodingDOSArabic = 0x0419,
   kCFStringEncodingDOSNordic = 0x041A,
   kCFStringEncodingDOSRussian = 0x041B,
   kCFStringEncodingDOSGreek2 = 0x041C,
   kCFStringEncodingDOSThai = 0x041D,
   kCFStringEncodingDOSJapanese = 0x0420,
   kCFStringEncodingDOSChineseSimplif = 0x0421,
   kCFStringEncodingDOSKorean = 0x0422,
   kCFStringEncodingDOSChineseTrad = 0x0423,
   kCFStringEncodingWindowsLatin1 = 0x0500,
   kCFStringEncodingWindowsLatin2 = 0x0501,
   kCFStringEncodingWindowsCyrillic = 0x0502,
   kCFStringEncodingWindowsGreek = 0x0503,
   kCFStringEncodingWindowsLatin5 = 0x0504,
   kCFStringEncodingWindowsHebrew = 0x0505,
   kCFStringEncodingWindowsArabic = 0x0506,
   kCFStringEncodingWindowsBalticRim = 0x0507,
   kCFStringEncodingWindowsVietnamese = 0x0508,
   kCFStringEncodingWindowsKoreanJohab = 0x0510,
   kCFStringEncodingASCII = 0x0600,
   kCFStringEncodingANSEL = 0x0601,
   kCFStringEncodingJIS_X0201_76 = 0x0620,
   kCFStringEncodingJIS_X0208_83 = 0x0621,
   kCFStringEncodingJIS_X0208_90 = 0x0622,
   kCFStringEncodingJIS_X0212_90 = 0x0623,
   kCFStringEncodingJIS_C6226_78 = 0x0624,
   kCFStringEncodingShiftJIS_X0213_00 = 0x0628,
   kCFStringEncodingShiftJIS_X0213_MenKuTen = 0x0629,
   kCFStringEncodingGB_2312_80 = 0x0630,
   kCFStringEncodingGBK_95 = 0x0631,
   kCFStringEncodingGB_18030_2000 = 0x0632,
   kCFStringEncodingKSC_5601_87 = 0x0640,
   kCFStringEncodingKSC_5601_92_Johab = 0x0641,
   kCFStringEncodingCNS_11643_92_P1 = 0x0651,
   kCFStringEncodingCNS_11643_92_P2 = 0x0652,
   kCFStringEncodingCNS_11643_92_P3 = 0x0653,
   kCFStringEncodingISO_2022_JP = 0x0820,
   kCFStringEncodingISO_2022_JP_2 = 0x0821,
   kCFStringEncodingISO_2022_JP_1 = 0x0822,
   kCFStringEncodingISO_2022_JP_3 = 0x0823,
   kCFStringEncodingISO_2022_CN = 0x0830,
   kCFStringEncodingISO_2022_CN_EXT = 0x0831,
   kCFStringEncodingISO_2022_KR = 0x0840,
   kCFStringEncodingEUC_JP = 0x0920,
   kCFStringEncodingEUC_CN = 0x0930,
   kCFStringEncodingEUC_TW = 0x0931,
   kCFStringEncodingEUC_KR = 0x0940,
   kCFStringEncodingShiftJIS = 0x0A01,
   kCFStringEncodingKOI8_R = 0x0A02,
   kCFStringEncodingBig5 = 0x0A03,
   kCFStringEncodingMacRomanLatin1 = 0x0A04,
   kCFStringEncodingHZ_GB_2312 = 0x0A05,
   kCFStringEncodingBig5_HKSCS_1999 = 0x0A06,
   kCFStringEncodingVISCII = 0x0A07,
   kCFStringEncodingKOI8_U = 0x0A08,
   kCFStringEncodingBig5_E = 0x0A09,
   kCFStringEncodingNextStepLatin = 0x0B01,
   kCFStringEncodingNextStepJapanese = 0x0B02,
   kCFStringEncodingEBCDIC_US = 0x0C01,
   kCFStringEncodingEBCDIC_CP037 = 0x0C02
} CFStringEncodings;
Constants
kCFStringEncodingMacJapanese


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacChineseTrad


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacKorean


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacArabic


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacHebrew


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacGreek


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacCyrillic


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacDevanagari


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacGurmukhi


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacGujarati


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacOriya


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacBengali


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacTamil


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacTelugu


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacKannada


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacMalayalam


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacSinhalese


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacBurmese


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacKhmer


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacThai


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacLaotian


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacGeorgian


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacArmenian


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacChineseSimp


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacTibetan


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacMongolian


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacEthiopic


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacCentralEurRoman


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacVietnamese


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacExtArabic


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacSymbol


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacDingbats


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacTurkish


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacCroatian


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacIcelandic


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacRomanian


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacCeltic


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacGaelic


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacFarsi

Like MacArabic but uses Farsi digits

Available in Mac OS X v10.0 and later.
kCFStringEncodingMacUkrainian


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacInuit


Available in Mac OS X v10.0 and later.
kCFStringEncodingMacVT100

VT100102 font from Comm Toolbox: Latin-1 repertoire + box drawing etc

Available in Mac OS X v10.0 and later.
kCFStringEncodingMacHFS

Meta-value, should never appear in a table

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin2

ISO 8859-2

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin3

ISO 8859-3

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin4

ISO 8859-4

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatinCyrillic

ISO 8859-5

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatinArabic

ISO 8859-6, =ASMO 708, =DOS CP 708

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatinGreek

ISO 8859-7

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatinHebrew

ISO 8859-8

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin5

ISO 8859-9

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin6

ISO 8859-10

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatinThai

ISO 8859-11

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin7

ISO 8859-13

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin8

ISO 8859-14

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin9

ISO 8859-15

Available in Mac OS X v10.0 and later.
kCFStringEncodingISOLatin10

ISO 8859-16

Available in Mac OS X v10.4 and later.
kCFStringEncodingDOSLatinUS

code page 437

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSGreek

code page 737 (formerly code page 437G)

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSBalticRim

code page 775

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSLatin1

code page 850, "Multilingual"

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSGreek1

code page 851

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSLatin2

code page 852, Slavic

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSCyrillic

code page 855, IBM Cyrillic

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSTurkish

code page 857, IBM Turkish

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSPortuguese

code page 860

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSIcelandic

code page 861

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSHebrew

code page 862

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSCanadianFrench

code page 863

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSArabic

code page 864

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSNordic

code page 865

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSRussian

code page 866

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSGreek2

code page 869, IBM Modern Greek

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSThai

code page 874, also for Windows

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSJapanese

code page 932, also for Windows

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSChineseSimplif

code page 936, also for Windows

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSKorean

code page 949, also for Windows; Unified Hangul Code

Available in Mac OS X v10.0 and later.
kCFStringEncodingDOSChineseTrad

code page 950, also for Windows

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsLatin2

code page 1250, Central Europe

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsCyrillic

code page 1251, Slavic Cyrillic

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsGreek

code page 1253

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsLatin5

code page 1254, Turkish

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsHebrew

code page 1255

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsArabic

code page 1256

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsBalticRim

code page 1257

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsVietnamese

code page 1258

Available in Mac OS X v10.0 and later.
kCFStringEncodingWindowsKoreanJohab

code page 1361, for Windows NT

Available in Mac OS X v10.0 and later.
kCFStringEncodingANSEL

ANSEL (ANSI Z39.47)

Available in Mac OS X v10.4 and later.
kCFStringEncodingJIS_X0201_76


Available in Mac OS X v10.0 and later.
kCFStringEncodingJIS_X0208_83


Available in Mac OS X v10.0 and later.
kCFStringEncodingJIS_X0208_90


Available in Mac OS X v10.0 and later.
kCFStringEncodingJIS_X0212_90


Available in Mac OS X v10.0 and later.
kCFStringEncodingJIS_C6226_78


Available in Mac OS X v10.0 and later.
kCFStringEncodingShiftJIS_X0213_00

Shift-JIS format encoding of JIS X0213 planes 1 and 2

Available in Mac OS X v10.2 and later.
kCFStringEncodingShiftJIS_X0213_MenKuTen

JIS X0213 in plane-row-column notation

Available in Mac OS X v10.4 and later.
kCFStringEncodingGB_2312_80


Available in Mac OS X v10.0 and later.
kCFStringEncodingGBK_95

annex to GB 13000-93; for Windows 95

Available in Mac OS X v10.0 and later.
kCFStringEncodingGB_18030_2000


Available in Mac OS X v10.2 and later.
kCFStringEncodingKSC_5601_87

same as KSC 5601-92 without Johab annex

Available in Mac OS X v10.0 and later.
kCFStringEncodingKSC_5601_92_Johab

KSC 5601-92 Johab annex

Available in Mac OS X v10.0 and later.
kCFStringEncodingCNS_11643_92_P1

CNS 11643-1992 plane 1

Available in Mac OS X v10.0 and later.
kCFStringEncodingCNS_11643_92_P2

CNS 11643-1992 plane 2

Available in Mac OS X v10.0 and later.
kCFStringEncodingCNS_11643_92_P3

CNS 11643-1992 plane 3 (was plane 14 in 1986 version)

Available in Mac OS X v10.0 and later.
kCFStringEncodingISO_2022_JP


Available in Mac OS X v10.0 and later.
kCFStringEncodingISO_2022_JP_2


Available in Mac OS X v10.0 and later.
kCFStringEncodingISO_2022_JP_1

RFC 2237

Available in Mac OS X v10.2 and later.
kCFStringEncodingISO_2022_JP_3

JIS X0213

Available in Mac OS X v10.2 and later.
kCFStringEncodingISO_2022_CN


Available in Mac OS X v10.0 and later.
kCFStringEncodingISO_2022_CN_EXT


Available in Mac OS X v10.0 and later.
kCFStringEncodingISO_2022_KR


Available in Mac OS X v10.0 and later.
kCFStringEncodingEUC_JP

ISO 646, 1-byte katakana, JIS 208, JIS 212

Available in Mac OS X v10.0 and later.
kCFStringEncodingEUC_CN

ISO 646, GB 2312-80

Available in Mac OS X v10.0 and later.
kCFStringEncodingEUC_TW

ISO 646, CNS 11643-1992 Planes 1-16

Available in Mac OS X v10.0 and later.
kCFStringEncodingEUC_KR

ISO 646, KS C 5601-1987

Available in Mac OS X v10.0 and later.
kCFStringEncodingShiftJIS

plain Shift-JIS

Available in Mac OS X v10.0 and later.
kCFStringEncodingKOI8_R

Russian internet standard

Available in Mac OS X v10.0 and later.
kCFStringEncodingBig5

Big-5 (has variants)

Available in Mac OS X v10.0 and later.
kCFStringEncodingMacRomanLatin1

Mac OS Roman permuted to align with ISO Latin-1

Available in Mac OS X v10.0 and later.
kCFStringEncodingHZ_GB_2312

HZ (RFC 1842, for Chinese mail & news)

Available in Mac OS X v10.0 and later.
kCFStringEncodingBig5_HKSCS_1999

Big-5 with Hong Kong special char set supplement

Available in Mac OS X v10.2 and later.
kCFStringEncodingVISCII

RFC 1456, Vietnamese

Available in Mac OS X v10.4 and later.
kCFStringEncodingKOI8_U

RFC 2319, Ukrainian

Available in Mac OS X v10.4 and later.
kCFStringEncodingBig5_E

Taiwan Big-5E standard

Available in Mac OS X v10.4 and later.
kCFStringEncodingNextStepJapanese

NextStep Japanese encoding

Available in Mac OS X v10.4 and later.
kCFStringEncodingEBCDIC_US

basic EBCDIC-US

Available in Mac OS X v10.0 and later.
kCFStringEncodingEBCDIC_CP037

code page 037, extended EBCDIC (Latin-1 set) for US,Canada...

Available in Mac OS X v10.0 and later.
Declared In
CFStringEncodingExt.h*/
typedef enum {
   kCFStringEncodingMacJapanese = 1,
   kCFStringEncodingMacChineseTrad = 2,
   kCFStringEncodingMacKorean = 3,
   kCFStringEncodingMacArabic = 4,
   kCFStringEncodingMacHebrew = 5,
   kCFStringEncodingMacGreek = 6,
   kCFStringEncodingMacCyrillic = 7,
   kCFStringEncodingMacDevanagari = 9,
   kCFStringEncodingMacGurmukhi = 10,
   kCFStringEncodingMacGujarati = 11,
   kCFStringEncodingMacOriya = 12,
   kCFStringEncodingMacBengali = 13,
   kCFStringEncodingMacTamil = 14,
   kCFStringEncodingMacTelugu = 15,
   kCFStringEncodingMacKannada = 16,
   kCFStringEncodingMacMalayalam = 17,
   kCFStringEncodingMacSinhalese = 18,
   kCFStringEncodingMacBurmese = 19,
   kCFStringEncodingMacKhmer = 20,
   kCFStringEncodingMacThai = 21,
   kCFStringEncodingMacLaotian = 22,
   kCFStringEncodingMacGeorgian = 23,
   kCFStringEncodingMacArmenian = 24,
   kCFStringEncodingMacChineseSimp = 25,
   kCFStringEncodingMacTibetan = 26,
   kCFStringEncodingMacMongolian = 27,
   kCFStringEncodingMacEthiopic = 28,
   kCFStringEncodingMacCentralEurRoman = 29,
   kCFStringEncodingMacVietnamese = 30,
   kCFStringEncodingMacExtArabic = 31,
   kCFStringEncodingMacSymbol = 33,
   kCFStringEncodingMacDingbats = 34,
   kCFStringEncodingMacTurkish = 35,
   kCFStringEncodingMacCroatian = 36,
   kCFStringEncodingMacIcelandic = 37,
   kCFStringEncodingMacRomanian = 38,
   kCFStringEncodingMacCeltic = 39,
   kCFStringEncodingMacGaelic = 40,
   kCFStringEncodingMacFarsi = 0x8C,
   kCFStringEncodingMacUkrainian = 0x98,
   kCFStringEncodingMacInuit = 0xEC,
   kCFStringEncodingMacVT100 = 0xFC,
   kCFStringEncodingMacHFS = 0xFF,
   kCFStringEncodingISOLatin1 = 0x0201,
   kCFStringEncodingISOLatin2 = 0x0202,
   kCFStringEncodingISOLatin3 = 0x0203,
   kCFStringEncodingISOLatin4 = 0x0204,
   kCFStringEncodingISOLatinCyrillic = 0x0205,
   kCFStringEncodingISOLatinArabic = 0x0206,
   kCFStringEncodingISOLatinGreek = 0x0207,
   kCFStringEncodingISOLatinHebrew = 0x0208,
   kCFStringEncodingISOLatin5 = 0x0209,
   kCFStringEncodingISOLatin6 = 0x020A,
   kCFStringEncodingISOLatinThai = 0x020B,
   kCFStringEncodingISOLatin7 = 0x020D,
   kCFStringEncodingISOLatin8 = 0x020E,
   kCFStringEncodingISOLatin9 = 0x020F,
   kCFStringEncodingISOLatin10 = 0x0210,
   kCFStringEncodingDOSLatinUS = 0x0400,
   kCFStringEncodingDOSGreek = 0x0405,
   kCFStringEncodingDOSBalticRim = 0x0406,
   kCFStringEncodingDOSLatin1 = 0x0410,
   kCFStringEncodingDOSGreek1 = 0x0411,
   kCFStringEncodingDOSLatin2 = 0x0412,
   kCFStringEncodingDOSCyrillic = 0x0413,
   kCFStringEncodingDOSTurkish = 0x0414,
   kCFStringEncodingDOSPortuguese = 0x0415,
   kCFStringEncodingDOSIcelandic = 0x0416,
   kCFStringEncodingDOSHebrew = 0x0417,
   kCFStringEncodingDOSCanadianFrench = 0x0418,
   kCFStringEncodingDOSArabic = 0x0419,
   kCFStringEncodingDOSNordic = 0x041A,
   kCFStringEncodingDOSRussian = 0x041B,
   kCFStringEncodingDOSGreek2 = 0x041C,
   kCFStringEncodingDOSThai = 0x041D,
   kCFStringEncodingDOSJapanese = 0x0420,
   kCFStringEncodingDOSChineseSimplif = 0x0421,
   kCFStringEncodingDOSKorean = 0x0422,
   kCFStringEncodingDOSChineseTrad = 0x0423,
   kCFStringEncodingWindowsLatin1 = 0x0500,
   kCFStringEncodingWindowsLatin2 = 0x0501,
   kCFStringEncodingWindowsCyrillic = 0x0502,
   kCFStringEncodingWindowsGreek = 0x0503,
   kCFStringEncodingWindowsLatin5 = 0x0504,
   kCFStringEncodingWindowsHebrew = 0x0505,
   kCFStringEncodingWindowsArabic = 0x0506,
   kCFStringEncodingWindowsBalticRim = 0x0507,
   kCFStringEncodingWindowsVietnamese = 0x0508,
   kCFStringEncodingWindowsKoreanJohab = 0x0510,
   kCFStringEncodingASCII = 0x0600,
   kCFStringEncodingANSEL = 0x0601,
   kCFStringEncodingJIS_X0201_76 = 0x0620,
   kCFStringEncodingJIS_X0208_83 = 0x0621,
   kCFStringEncodingJIS_X0208_90 = 0x0622,
   kCFStringEncodingJIS_X0212_90 = 0x0623,
   kCFStringEncodingJIS_C6226_78 = 0x0624,
   kCFStringEncodingShiftJIS_X0213_00 = 0x0628,
   kCFStringEncodingShiftJIS_X0213_MenKuTen = 0x0629,
   kCFStringEncodingGB_2312_80 = 0x0630,
   kCFStringEncodingGBK_95 = 0x0631,
   kCFStringEncodingGB_18030_2000 = 0x0632,
   kCFStringEncodingKSC_5601_87 = 0x0640,
   kCFStringEncodingKSC_5601_92_Johab = 0x0641,
   kCFStringEncodingCNS_11643_92_P1 = 0x0651,
   kCFStringEncodingCNS_11643_92_P2 = 0x0652,
   kCFStringEncodingCNS_11643_92_P3 = 0x0653,
   kCFStringEncodingISO_2022_JP = 0x0820,
   kCFStringEncodingISO_2022_JP_2 = 0x0821,
   kCFStringEncodingISO_2022_JP_1 = 0x0822,
   kCFStringEncodingISO_2022_JP_3 = 0x0823,
   kCFStringEncodingISO_2022_CN = 0x0830,
   kCFStringEncodingISO_2022_CN_EXT = 0x0831,
   kCFStringEncodingISO_2022_KR = 0x0840,
   kCFStringEncodingEUC_JP = 0x0920,
   kCFStringEncodingEUC_CN = 0x0930,
   kCFStringEncodingEUC_TW = 0x0931,
   kCFStringEncodingEUC_KR = 0x0940,
   kCFStringEncodingShiftJIS = 0x0A01,
   kCFStringEncodingKOI8_R = 0x0A02,
   kCFStringEncodingBig5 = 0x0A03,
   kCFStringEncodingMacRomanLatin1 = 0x0A04,
   kCFStringEncodingHZ_GB_2312 = 0x0A05,
   kCFStringEncodingBig5_HKSCS_1999 = 0x0A06,
   kCFStringEncodingVISCII = 0x0A07,
   kCFStringEncodingKOI8_U = 0x0A08,
   kCFStringEncodingBig5_E = 0x0A09,
   kCFStringEncodingNextStepLatin = 0x0B01,
   kCFStringEncodingNextStepJapanese = 0x0B02,
   kCFStringEncodingEBCDIC_US = 0x0C01,
   kCFStringEncodingEBCDIC_CP037 = 0x0C02
} CFStringEncodings;


#ifdef __cplusplus
}
#endif

#endif