#ifndef CFDATE_H
#define CFDATE_H



#include <CoreFoundation/CFBase.h>

#if defined(__cplusplus)
extern "C" {
#endif

/*CFGregorianUnits

Structure used to represent a time interval in Gregorian units.

struct CFGregorianUnits {
   SInt32 years;
   SInt32 months;
   SInt32 days;
   SInt32 hours;
   SInt32 minutes;
   double seconds;
};
typedef struct CFGregorianUnits CFGregorianUnits;
Discussion

A CFGregorianUnits is used to represent arbitrary time intervals. Each field can take values up to the maximum possible for its data type. Negative values are also valid. To represent a point in time using Gregorian units, use a CFGregorianDate.*/
struct CFGregorianUnits {
   SInt32 years;
   SInt32 months;
   SInt32 days;
   SInt32 hours;
   SInt32 minutes;
   double seconds;
};
typedef struct CFGregorianUnits CFGregorianUnits;

/*CFTimeZoneRef

A reference to a CFTimeZone object. 

typedef const struct __CFTimeZone *CFTimeZoneRef;
Availability
Available in Mac OS X v10.0 and later.*/
typedef const struct __CFTimeZone *CFTimeZoneRef;

/*CFGregorianDate

Structure used to represent a point in time using the Gregorian calendar.

struct CFGregorianDate {
   SInt32 year;
   SInt8 month;
   SInt8 day;
   SInt8 hour;
   SInt8 minute;
   double second;
};
typedef struct CFGregorianDate CFGregorianDate;
Discussion

CFGregorianDate is implemented using the smallest data type appropriate for the range of possible values. For example, there are only 12 months in the Gregorian year, so there is no need to use an integer type larger than 8 bits. To represent a time interval in Gregorian units, use a CFGregorianUnits.*/

struct CFGregorianDate {
   SInt32 year;
   SInt8 month;
   SInt8 day;
   SInt8 hour;
   SInt8 minute;
   double second;
};
typedef struct CFGregorianDate CFGregorianDate;

/*CFDateRef

A reference to an immutable CFDate object.

typedef const struct __CFDate *CFDateRef;
Availability
Available in Mac OS X v10.0 and later*/
typedef const struct __CFDate *CFDateRef;



/*CFTimeInterval

Type used to represent elapsed time in seconds.

typedef double CFTimeInterval;
Availability
Available in Mac OS X v10.0 and later.*/
typedef double CFTimeInterval;

/*CFAbsoluteTime

Type used to represent a specific point in time relative to the absolute reference date of 1 Jan 2001 00:00:00 GMT.

typedef CFTimeInterval CFAbsoluteTime;
Discussion

Absolute time is measured by the number of seconds between the reference date and the specified date. Negative values indicate dates/times before the reference date. Positive values indicate dates/times after the reference date. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef CFTimeInterval CFAbsoluteTime;

//function

/*CFDateGetTypeID

Returns the type identifier for the CFDate opaque type.

CFTypeID CFDateGetTypeID ();
Return Value

The type identifier for the CFDate opaque type. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFTypeID CFDateGetTypeID ();

/*CFAbsoluteTimeGetCurrent

Returns the current system absolute time.

CFAbsoluteTime CFAbsoluteTimeGetCurrent ();
Return Value

The current absolute time. 
Discussion

Absolute time is measured in seconds relative to the absolute reference date of Jan 1 2001 00:00:00 GMT. A positive value represents a date after the reference date, a negative value represents a date before it. For example, the absolute time -32940326 is equivalent to December 16th, 1999 at 17:54:34. Repeated calls to this function do not guarantee monotonically increasing results. The system time may decrease due to synchronization with external time references or due to an explicit user change of the clock.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/
CFAbsoluteTime CFAbsoluteTimeGetCurrent ();

/*CFDateCreate

Creates a CFDate object given an absolute time.

CFDateRef CFDateCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime at
);
Parameters
allocator

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator. 
at

The absolute time to converted to a CFDate object. 
Return Value

A date object that represents the absolute time at. Ownership follows the Create Rule.
Discussion

CFDate objects must always be created using absolute time. Time intervals are not supported. 
Availability
Available in CarbonLib v1.0 and later.
Available in Mac OS X v10.0 and later.*/
CFDateRef CFDateCreate (
   CFAllocatorRef allocator,
   CFAbsoluteTime at
);

/*(CFGregorianDateGetAbsoluteTime

Converts a Gregorian date value into an absolute time value.

CFAbsoluteTime CFGregorianDateGetAbsoluteTime (
   CFGregorianDate gdate,
   CFTimeZoneRef tz
);
Parameters
gdate

The Gregorian date to convert. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
Return Value

The absolute time equivalent of gdate. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/

CFAbsoluteTime CFGregorianDateGetAbsoluteTime (
   CFGregorianDate gdate,
   CFTimeZoneRef tz
);

/*CFAbsoluteTimeGetDayOfWeek

Returns an integer representing the day of the week indicated by the specified absolute time.

SInt32 CFAbsoluteTimeGetDayOfWeek (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
);
Parameters
at

The absolute time to convert. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
Return Value

An integer (1-7) representing the day of the week specified by at. Per ISO-8601, Monday is represented by 1, Tuesday by 2, and so on.
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/

SInt32 CFAbsoluteTimeGetDayOfWeek (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
);

/*CFAbsoluteTimeAddGregorianUnits

Adds a time interval, expressed as Gregorian units, to a given absolute time.

CFAbsoluteTime CFAbsoluteTimeAddGregorianUnits (
   CFAbsoluteTime at,
   CFTimeZoneRef tz,
   CFGregorianUnits units
);
Parameters
at

The absolute time to which the interval is added. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
units

The time interval to add to at. 
Return Value

An absolute time value equal to the sum of at and units. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/

CFAbsoluteTime CFAbsoluteTimeAddGregorianUnits (
   CFAbsoluteTime at,
   CFTimeZoneRef tz,
   CFGregorianUnits units
);

/*CFAbsoluteTimeGetGregorianDate

Converts an absolute time value into a Gregorian date.

CFGregorianDate CFAbsoluteTimeGetGregorianDate (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
);
Parameters
at

The absolute time value to convert. 
tz

The time zone to use for time correction. Pass NULL for GMT. 
Return Value

The Gregorian date equivalent for at. 
Availability
Available in Mac OS X v10.0 and later.
Declared In
CFDate.h*/
CFGregorianDate CFAbsoluteTimeGetGregorianDate (
   CFAbsoluteTime at,
   CFTimeZoneRef tz
);


#ifdef __cplusplus
}
#endif

#endif