#ifndef COLORPICKER_H
#define COLORPICKER_H

#ifndef APPLICATIONSERVICES_H
#include <ApplicationServices/ApplicationServices.h>
#endif

#ifndef EVENTS_H
#include <HIToolbox/Events.h>
#endif

#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Color Picker Flags

Specify a variety of options to apply when displaying the color picker dialog.

enum {
   kColorPickerDialogIsMoveable = 1,
   kColorPickerDialogIsModal = 2,
   kColorPickerCanModifyPalette = 4,
   kColorPickerCanAnimatePalette = 8,
   kColorPickerAppIsColorSyncAware = 16,
   kColorPickerInSystemDialog = 32,
   kColorPickerInApplicationDialog = 64,
   kColorPickerInPickerDialog = 128,
   kColorPickerDetachedFromChoices = 256,
   kColorPickerCallColorProcLive = 512
};
Constants
kColorPickerDialogIsMoveable

If your application sets the bit represented by this constant when creating a custom dialog box, then the color picker dialog box is moveable by the user.

Available in Mac OS X v10.0 and later.
kColorPickerDialogIsModal

If your application sets the bit represented by this constant when creating a custom dialog box, then the color picker dialog box is a modal dialog box.

Available in Mac OS X v10.0 and later.
kColorPickerCanModifyPalette

Your application should set the bit represented by this constant if your application can install a palette of its own that may modify (but not animate) the current color table. If you do not want the colors in the document to change as the user makes choices in the color picker dialog box, do not set this flag.

Available in Mac OS X v10.0 and later.
kColorPickerCanAnimatePalette

If your application sets the bit represented by this constant, then the color picker may modify or animate the palette.

Available in Mac OS X v10.0 and later.
kColorPickerAppIsColorSyncAware

Your application should set the bit represented by this constant if your application uses ColorSync color matching. If your application sets this bit, a color may be returned to your application in a different color space than the one initially passed to the PickColor function. For example, your application could pass an RGB color with no color-matching profile in the field theColor in ColorPickerInfo, and the Color Picker Manager could return a CMYK color with its associated profile. If your application does not set this flag, the Color Picker Manager automatically converts any color it receives back from the color picker to an RGB color. 

This version of the Color Picker Manager uses ColorSync 1.0 profiles only. The ColorSync 1.0 profile is a handle-based profile. The profile format is defined by Apple Computer. You cannot use version 2.0 profiles, which are identified by profile references, with this version of the Color Picker Manager. ColorSync 1.0 profiles typically reside in the ColorSyncTM Profiles folder (within the Preferences folder of the System Folder). They may also be embedded with the images to which they pertain in graphics files. 

Available in Mac OS X v10.0 and later.
kColorPickerInSystemDialog

The color picker sets this flag to indicate that the color picker is in a system-owned dialog box.

Available in Mac OS X v10.0 and later.
kColorPickerInApplicationDialog

The color picker sets this flag to indicate that the color picker is in an application-owned dialog box. 

Available in Mac OS X v10.0 and later.
kColorPickerInPickerDialog

The color picker sets this flag to indicate that the color picker is in its own dialog box.

Available in Mac OS X v10.0 and later.
kColorPickerDetachedFromChoices

The color picker sets this flag to indicate that the color picker has been detached from the choices list.

Available in Mac OS X v10.0 and later.
kColorPickerCallColorProcLive

Available in Mac OS X v10.0 and later.
Discussion

In the flags field of the ColorPickerInfo (Old) parameter block your application specifies characteristics for the color picker dialog box. 

The color picker may set any of the InSystemDialog, InApplicationDialog, InPickerDialog, or DetachedFromChoices flags and override your application settings. 
Special Considerations*/
enum {
   kColorPickerDialogIsMoveable = 1,
   kColorPickerDialogIsModal = 2,
   kColorPickerCanModifyPalette = 4,
   kColorPickerCanAnimatePalette = 8,
   kColorPickerAppIsColorSyncAware = 16,
   kColorPickerInSystemDialog = 32,
   kColorPickerInApplicationDialog = 64,
   kColorPickerInPickerDialog = 128,
   kColorPickerDetachedFromChoices = 256,
   kColorPickerCallColorProcLive = 512
};



/*PickerMenuItemInfo

Contains information needed for your application to specify an Edit menu for use when a color picker dialog box is displayed.

struct PickerMenuItemInfo {
   short editMenuID;
   short cutItem;
   short copyItem;
   short pasteItem;
   short clearItem;
   short undoItem;
};
typedef struct PickerMenuItemInfo PickerMenuItemInfo;
Fields
editMenuID

The resource ID of the Edit menu for the color picker.
cutItem

The item number of the Cut command.
copyItem

The item number of the Copy command.
pasteItem

The item number of the Paste command.
clearItem

The item number of the Clear command.
undoItem

The item number of the Undo command.
Availability
Available in Mac OS X v10.0 and later.*/

struct PickerMenuItemInfo {
   short editMenuID;
   short cutItem;
   short copyItem;
   short pasteItem;
   short clearItem;
   short undoItem;
};
typedef struct PickerMenuItemInfo PickerMenuItemInfo;


/*Dialog Placement Constants

Specify where on the screen to place the color picker dialog.

typedef SInt16 DialogPlacementSpec;
enum {
   kAtSpecifiedOrigin = 0,
   kDeepestColorScreen = 1,
   kCenterOnMainScreen = 2
};
Constants
kAtSpecifiedOrigin

Specify to place the top-left corner of the color picker dialog at the point specified in the dialogOrigin field of the color picker parameter block.

Available in Mac OS X v10.0 and later.
kDeepestColorScreen

Specify to center the color picker dialog on the screen with the greatest color depth.

Available in Mac OS X v10.0 and later.
kCenterOnMainScreen

Specify to center the color picker dialog on the main screen.

Available in Mac OS X v10.0 and later.
Discussion

In the placeWhere field of the ColorPickerInfo (Old) , your application specifies where to place the color picker dialog box. Your application uses the DialogPlacementSpec enumeration to specify the position of the color picker dialog box.*/
typedef SInt16 DialogPlacementSpec;
enum {
   kAtSpecifiedOrigin = 0,
   kDeepestColorScreen = 1,
   kCenterOnMainScreen = 2
};

/*NPMColor

Contains a color profile and a color.

struct NPMColor {
   CMProfileRef profile;
   CMColor color;
};
typedef struct NPMColor NPMColor;
typedef NPMColor * NPMColorPtr;
Fields
profile
color
Availability
Available in Mac OS X v10.0 and later.*/
struct NPMColor {
   CMProfileRef profile;
   CMColor color;
};
typedef struct NPMColor NPMColor;
typedef NPMColor * NPMColorPtr;

/*UserEventProcPtr

Defines a pointer to your event filter callback function, which determines whether your application or the Color Picker Manager handles this user event.

typedef Boolean (*UserEventProcPtr) (
   EventRecord *event
);

If you name your function MyUserEventProc, you would declare it like this:

Boolean MyUserEventProc (
   EventRecord *event
);
Parameters
event

A pointer to an event record. 
Return Value

True if your application handles the event, false otherwise. The Color Picker Manager will process the event further only if false is returned. 
Discussion

Your application should supply the eventProc field of the color picker parameter block with a pointer to your filter function. Your filter function should examine the event record passed in the first parameter to determine whether your application needs to handle the event contained in the record.

Applications can generally allow the Color Picker Manager to handle all events that might occur while displaying the standard dialog box. Update events are exceptions to this, however.

The PickColor function calls the Dialog Manager function DialogSelect. DialogSelect does not allow background windows to receive update events; therefore, at a minimum, your event filter function should handle update events. If your application needs to filter or preprocess other events before DialogSelect handles them, your application should do so in its event filter function.*/

typedef Boolean (*UserEventProcPtr) (
   EventRecord *event
);


/*UserEventUPP

Defines a universal procedure pointer to an event-filter callback.

typedef UserEventProcPtr UserEventUPP;
Discussion

For more information, see the description of the UserEventProcPtr callback function.*/
typedef UserEventProcPtr UserEventUPP;

/*NColorChangedProcPtr

Defines a pointer to your color-changed callback function, which applies a new color to a user’s document.

typedef void (*NColorChangedProcPtr)
(
   SInt32 userData,
   NPMColor *newColor
);

If you name your function MyNColorChangedProc, you would declare it like this:

void MyNColorChangedProc (
   SInt32 userData,
   NPMColor *newColor
);
Parameters
newColor*/

typedef void (*NColorChangedProcPtr)
(
   SInt32 userData,
   NPMColor *newColor
);


/*NColorChangedUPP

Defines a universal procedure pointer to your color-changed callback.

typedef NColorChangedProcPtr NColorChangedUPP;
Discussion

For more information, see the description of the NColorChangedProcPtr callback function.*/
typedef NColorChangedProcPtr NColorChangedUPP;


/*NColorPickerInfo

Contains information needed to display a standard color picker dialog.

struct NColorPickerInfo {
   NPMColor theColor;
   CMProfileRef dstProfile;
   UInt32 flags;
   DialogPlacementSpec placeWhere;
   Point dialogOrigin;
   OSType pickerType;
   UserEventUPP eventProc;
   NColorChangedUPP colorProc;
   UInt32 colorProcData;
   Str255 prompt;
   PickerMenuItemInfo mInfo;
   Boolean newColorChosen;
   UInt8 reserved;
};
typedef struct NColorPickerInfo NColorPickerInfo;
Fields
theColor

An NPMColor structure that contains a color profile and a color.
dstProfile

The destination profile.
flags

The options to apply when displaying the color picker dialog. For information on the flags that you can supply, see Color Picker Flags.
dialogOrigin

A constant that specifies where on the screen to place the color picker dialog. The constant kAtSpecifiedOrigin specifies to place the top-left corner of the color picker dialog at the point specified in the dialogOrigin field of the color picker parameter block. The constant kDeepestColorScreen specifies to center the color picker dialog on the screen with the greatest color depth. The constant kCenterOnMainScreen specifies to center the color picker dialog on the main screen.
pickerType

The type of color picker.
eventProc

A a universal procedure pointer to an event-filter callback.
colorProc

A universal procedure pointer to a color-changed callback.
colorProcData

Data needed for your color-changed callback.
prompt

A string to use as a prompt.
mInfo

A structure that contains information needed for your application to specify an Edit menu for use when a color picker dialog box is displayed.
newColorChosen

A Boolean value that specifies wheter or not a new color was chosen.
reserved

Reservered for future use.
Availability
Available in Mac OS X v10.0 and later.*/

struct NColorPickerInfo {
   NPMColor theColor;
   CMProfileRef dstProfile;
   UInt32 flags;
   DialogPlacementSpec placeWhere;
   Point dialogOrigin;
   OSType pickerType;
   UserEventUPP eventProc;
   NColorChangedUPP colorProc;
   UInt32 colorProcData;
   Str255 prompt;
   PickerMenuItemInfo mInfo;
   Boolean newColorChosen;
   UInt8 reserved;
};
typedef struct NColorPickerInfo NColorPickerInfo;

/*PMColor

Contains a color profile and a color.

{
CMProfileHandle profile;
CMColor color;
};
typedef struct PMColor PMColor;
typedef PMColor * PMColorPtr;
Fields
profile

A handle to a color-matching profile (CMProfile structure). If your application sets this field to NULL, then the Color Picker Manager uses the default system profile. 
color

A color, as specified in a color-matching structure. 
Discussion

For defining colors, version 2.0 of the Color Picker Manager uses a picker color structure. For example, when your application creates a ColorPickerInfo parameter block to pass to PickColor , your application supplies a picker color structure. The color that your application supplies in this field is passed to the color picker for editing. After the user clicks either the OK or Cancel button to close the dialog box, this field contains the color last chosen by the user.

The picker color structure includes a ColorSync 1.0 profile, a structure that matches colors among hardware devices such as displays, printers, and scanners. This color-matching profile (a data structure of type CMProfile) defines the color space of the color (which includes the type of color—RGB, CMYK, HSL, and so on). Using the dstProfile field of ColorPickerInfo (Old) or the PickerSetProfile function, your application can specify a destination color-matching profile, which describes the color space of the device for which the color is being chosen. Given information about the destination profile, color pickers that are ColorSync aware can help the user choose a color that’s within the destination device’s gamut.

This version of the Color Picker Manager uses ColorSync 1.0 profiles only. The ColorSync 1.0 profile is a handle-based profile. The profile format is defined by Apple Computer. You cannot use version 2.0 profiles, which are identified by profile references, with this version of the Color Picker Manager. ColorSync 1.0 profiles typically reside in the ColorSyncTM Profiles folder (within the Preferences folder of the System Folder). They may also be embedded with the images to which they pertain in graphics files. 
Availability
Available in Mac OS X v10.0 and later.*/

struct PMColor  {
CMProfileHandle profile;
CMColor color;
};
typedef struct PMColor PMColor;
typedef PMColor * PMColorPtr;

/*ColorChangedProcPtr

Defines a pointer to your color-changed callback function, which applies a new color to a user document.

typedef void (*ColorChangedProcPtr) (
   SInt32 userData,
   PMColor *newColor
);

If you name your function MyColorChangedProc, you would declare it like this:

void MyColorChangedProc (
   SInt32 userData,
   PMColor *newColor
);
Parameters
userData

Data that your application supplies in the colorProcData field of ColorPickerInfo (Old). Your application can use this value for any purpose it needs. 
newColor

A pointer to a PMColor structure that contains the new color selected by the user. Your color-changed function should update the user’s document to use this color. 
Discussion

Your application should supply the colorProc field of the color picker parameter with a pointer to your color change callback function.*/

typedef void (*ColorChangedProcPtr) (
   SInt32 userData,
   PMColor *newColor
);


/*ColorChangedUPP

Defines a universal procedure pointer to a color-changed callback.

typedef ColorChangedProcPtr ColorChangedUPP;
Discussion

For more information, see the description of the ColorChangedProcPtr callback function.*/
typedef ColorChangedProcPtr ColorChangedUPP;



/*ColorPickerInfo (Old)

Contains information needed to display a standard color picker dialog box.

struct ColorPickerInfo {
   PMColor theColor;
   CMProfileHandle dstProfile;
   UInt32 flags;
   DialogPlacementSpec placeWhere;
   Point dialogOrigin;
   OSType pickerType;
   UserEventUPP eventProc;
   ColorChangedUPP colorProc;
   UInt32 colorProcData;
   Str255 prompt;
   PickerMenuItemInfo mInfo;
   Boolean newColorChosen;
   SInt8 filler;
};
typedef struct ColorPickerInfo ColorPickerInfo;
Fields
theColor

A PMColor structure. The color that your application supplies in this field is passed to the color picker for editing. This becomes the original color for the color picker. After the user clicks either the OK or Cancel button to close the dialog box, this field contains the new color, that is, the color last chosen by the user. Although the new colors selected by the user may vary widely, the original color remains fixed for comparison. 
dstProfile

A handle to a ColorSync 1.0 profile for the final output device. To use the default system profile, set this field to NULL. 
flags

Bits representing the color picker flags, which are described in detail in “Color Picker Flags”. Your application can set any of the following flags: CanModifyPalette, CanAnimatePalette, AppIsColorSyncAware. The color picker may set any of the following flags and override your application settings: InSystemDialog, InApplicationDialog, InPickerDialog, DetachedFromChoices.
placeWhere

A specification for where to position the dialog box. Your application uses one of the following constants (described in “Dialog Placement Constants”) to specify the position for the color picker dialog box: kAtSpecifiedOrigin, kDeepestColorScreen, kCenterOnMainScreen. 
dialogOrigin

The point, in global coordinates, at which to locate the upper-left corner of the dialog box. This origin point is used only if your application supplies the kAtSpecifiedOrigin specifier in the placeWhere field. 
pickerType

The component subtype of the initial color picker. If your application sets this field to 0, the default color picker is used (that is, the last color picker chosen by the user). When PickColor returns, this field contains the component subtype of the color picker that was chosen when the user closed the color picker dialog box. 
eventProc

A pointer to an application-defined event filter function for handling user events meant for your application. If your filter function returns true, the Color Picker Manager will not process the event any further. If your filter function returns false, the Color Picker Manager handles the event as if it were meant for the color picker. The event filter function you can supply here is described in UserEventProcPtr. 
colorProc

A pointer to an application-defined function to handle color changes. This function, described in ColorChangedProcPtr, should support the updating of colors in a document as the user selects them. 
colorProcData

A long integer that the Color Picker Manager passes to the application-defined function supplied in the colorProc field. Your application-defined function can use this value for any purpose it needs.
prompt

A text string prompting the user to choose a color for a particular use (for example, “Choose a highlight color:”). 
mInfo

A PickerMenuItemInfo structure. This structure allows your application to specify your Edit menu for use when a color picker dialog box is displayed. 
newColorChosen

True if the user chose a color and clicked the OK button, and false if the user clicked Cancel. 
filler
Discussion

When your application calls the PickColor function to display a standard color picker dialog box, your application uses a color picker parameter block to specify information to and obtain information from the Color Picker Manager. The color picker parameter block is defined by the ColorPickerInfo data type.

This version of the Color Picker Manager uses ColorSync 1.0 profiles only. The ColorSync 1.0 profile is a handle-based profile. The profile format is defined by Apple Computer. You cannot use version 2.0 profiles, which are identified by profile references, with this version of the Color Picker Manager. ColorSync 1.0 profiles typically reside in the ColorSyncTM Profiles folder (within the Preferences folder of the System Folder). They may also be embedded with the images to which they pertain in graphics files. 
Availability
Available in Mac OS X v10.0 and later.*/
struct ColorPickerInfo {
   PMColor theColor;
   CMProfileHandle dstProfile;
   UInt32 flags;
   DialogPlacementSpec placeWhere;
   Point dialogOrigin;
   OSType pickerType;
   UserEventUPP eventProc;
   ColorChangedUPP colorProc;
   UInt32 colorProcData;
   Str255 prompt;
   PickerMenuItemInfo mInfo;
   Boolean newColorChosen;
   SInt8 filler;
};
typedef struct ColorPickerInfo ColorPickerInfo;

//function

/*NPickColor

Displays the Color Picker dialog.

OSErr NPickColor (
   NColorPickerInfo * theColorInfo
);
Parameters
theColorInfo

A pointer to a color picker parameter (NColorPickerInfo) data structure. On input, you specify information such as the location of the dialog. On output, the data structure specifies information such as whether the user changed the color. 
Return Value

A result code. See “Color Picker Result Codes”.
Discussion

The NPickColor function displays the standard dialog for color pickers. Use the color picker parameter data structure to specify information to and obtain information from the Color Picker Manager. 
Availability
Available in CarbonLib 1.0 and later when ColorPicker 2.1 or later is present.
Available in Mac OS X 10.0 and later.
Carbon Porting Notes

This call is identical to the unsupported function PickColor , but it replaces the older ColorSync 1.0 data types with new ColorSync 2.x profile references. When filling out the parameter block for a call to the function NPickColor, you must replace all profile handles with profile references. The optional color-changed proc you has also changed; a new data structure NCMColor replaces the CMColor data type and uses profile references.
Declared In
ColorPicker.h*/
OSErr NPickColor (
   NColorPickerInfo * theColorInfo
);

/*NewUserEventUPP

Creates a universal procedure pointer (UPP) to an event filter callback.

UserEventUPP NewUserEventUPP (
   UserEventProcPtr userRoutine
);
Parameters
userRoutine
Return Value

See the description of the UserEventUPP data type.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X 10.0 and later.
Declared In
ColorPicker.h*/
UserEventUPP NewUserEventUPP (
   UserEventProcPtr userRoutine
);

/*PickColor

Requests the user to choose a color from the standard color picker dialog box.

OSErr PickColor (
   ColorPickerInfo * theColorInfo
);
Parameters
theColorInfo

A pointer to the ColorPickerInfo (Old) structure, to specify information to and obtain information from the Color Picker Manager. 
Return Value

A result code. See “Color Picker Result Codes”.
Discussion

The PickColor function displays the standard modal dialog box for color pickers. When the user clicks the OK button, PickColor removes the dialog box and returns true in the newColorChosen field and the user’s selected color in the theColor field of theColorInfo. When the user clicks the Cancel button, PickColor removes the dialog box and returns false in the newColorChosen field. 
Availability
Available in CarbonLib 1.0 and later when ColorPicker 2.0 or later is present.
Available in Mac OS X 10.0 and later.
Declared In
ColorPicker.h*/

OSErr PickColor (
   ColorPickerInfo * theColorInfo
);

/*GetColor

Requests the user to choose a color. This function is obsolete; use the PickColor function instead.

Boolean GetColor (
   Point where,
   ConstStr255Param prompt,
   const RGBColor * inColor,
   RGBColor * outColor
);
Parameters
where

A point defining the location of the upper-left corner of the dialog box. If you set this parameter to (0,0), the dialog box is centered horizontally on the main screen, with one-third of the empty space above the box and two-thirds below, regardless of the screen size. If you set this parameter to (–1,–1), the GetColor function displays the dialog box on the screen supporting the greatest pixel depth. 
prompt

Text for prompting the user to choose a color. This string is displayed in the upper-left corner of the dialog box. 
inColor

A pointer to an RGBColor structure for a color at entry to the picker. This is the original color, which the user may want for comparison. 
outColor

A pointer to an RGBColor structure describing the new color. This is set to the last color that the user picked before clicking OK. On entry, the outColor parameter is treated as undefined, so the output color sample initially matches the input. Although the color being picked may vary widely, the input color sample remains fixed, and clicking the input sample resets the output color sample to match it.
Return Value

True if the user clicks the OK button; false if the user clicks the Cancel button. In either case, the dialog box is removed. 
Discussion

The GetColor function does not support ColorSync 1.0 color matching; however, the PickColor function does. This function was designed for use for version 1.0 of the Color Picker Package and is still supported for backward compatibility. 
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X 10.0 and later.
Declared In
ColorPicker.h*/
Boolean GetColor (
   Point where,
   ConstStr255Param prompt,
   const RGBColor * inColor,
   RGBColor * outColor
);

#ifdef __cplusplus
}
#endif

#endif