#ifndef FP_H
#define FP_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif


#ifndef __USE_ISOC99
#define __USE_ISOC99
#endif
#include <math.h>


#include <AvailabilityMacros.h>
//#include <HYS/CarbonCore/fp.h>
#include <APPLE/CarbonCore/fp.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

//define mathdefs.h
#ifndef _MATH_H_MATHDEF
# if defined __FLT_EVAL_METHOD__ && __FLT_EVAL_METHOD__ == 0
/* When using -mfpmath=sse, values are computed with the precission of the
   used type.  */
typedef float float_t;		/* `float' expressions are evaluated as `float'.  */
typedef double double_t;	/* `double' expressions are evaluated as
				   `double'.  */
# else
/* The ix87 FPUs evaluate all values in the 80 bit floating-point format
   which is also available for the user as `long double'.  Therefore we
   define:  */
typedef long double float_t;	/* `float' expressions are evaluated as
				   `long double'.  */
typedef long double double_t;	/* `double' expressions are evaluated as
				   `long double'.  */
# endif
//defined bits/mathdefs.h
#endif

/*x80tod


double x80tod (
   const extended80 * x80
);
Parameters
x80
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
fp.h*/
double x80tod (
   const extended80 * x80
);

/*dtox80


void dtox80 (
   const double * x,
   extended80 * x80
);
Parameters
x
x80
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
fp.h*/
void dtox80 (
   const double * x,
   extended80 * x80
);

/*rinttol


long rinttol (
   double_t x
);
Parameters
x
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
fp.h*/

long rinttol (
   double_t x
);

/*pi


pi ();
Parameters
Return Value
Availability
Declared In
fp.h*/
void pi ();

/*roundtol


long roundtol (
   double_t round
);
Parameters
round
Return Value
Availability
Available in Mac OS X version 10.0 and later. 
Declared In
fp.h*/
long roundtol (
   double_t round
);

/*Data Exchange Routines
#ifdef powerc
void x80told(const extended80 *x80, long double *x);
void ldtox80(const long double *x, extended80 *x80);
#endif // powerc  */

void x80told(const extended80 *x80, long double *x);
void ldtox80(const long double *x, extended80 *x80);


#ifdef __cplusplus
}
#endif

#endif
