#ifndef ENDIAN_H
#define ENDIAN_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*BigEndianOSType

Protects a big-endian OSType value from being changed by little-endian code.

// Little-endian host
struct BigEndianOSType {
   OSType    bigEndianValue;
};
typedef struct BigEndianOStype  BigEndianOStype;
// Big-endian host
typedef OSType BigEndianOSType;
Fields
bigEndianValue

An OSType value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
// Little-endian host

struct BigEndianOSType {
   OSType    bigEndianValue;
};
typedef struct BigEndianOSType  BigEndianOSType;

// Big-endian host
//typedef OSType BigEndianOSType;

/*BigEndianLong

Protects a big-endian long value from being changed by little-endian code.

// Little-endian host
struct BigEndianLong {
   long bigEndianValue;
};
typedef struct BigEndianLong  BigEndianLong;
// Big-endian host
typedef long  BigEndianLong;
Fields
bigEndianValue

A long value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
struct BigEndianLong {
   long bigEndianValue;
};
typedef struct BigEndianLong  BigEndianLong;
// Big-endian host
//typedef long  BigEndianLong;


//FUNC
/*EndianU32_NtoB

Converts an unsigned 32-bit value in the computer’s native format to the equivalent big-endian value.

UInt32 EndianU32_NtoB (
   UInt32    value
);
Parameters
value

An unsigned 32-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt32 EndianU32_NtoB (
   UInt32    value
);

/*EndianU32_BtoN

Converts an unsigned 32-bit big-endian value to the equivalent value in the computer’s native format.

UInt32 EndianU32_BtoN (
   UInt32    value
);
Parameters
value

An unsigned 32-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt32 EndianU32_BtoN (
   UInt32    value
);

/*EndianS16_BtoN

Converts a signed 16-bit big-endian value to the equivalent value in the computer’s native format.

SInt16 EndianS16_BtoN (
   SInt16    value
);
Parameters
value

A signed 16-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
SInt16 EndianS16_BtoN (
   SInt16    value
);

/*EndianS32_BtoN

Converts a signed 32-bit big-endian value to the equivalent value in the computer’s native format.

SInt32 EndianS32_BtoN (
   SInt32    value
);
Parameters
value

A signed 32-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

SInt32 EndianS32_BtoN (
   SInt32    value
);

/*EndianU16_BtoN

Converts an unsigned 16-bit big-endian value to the equivalent value in the computer’s native format.

UInt16 EndianU16_BtoN (
   UInt16    value
);
Parameters
value

An unsigned 16-bit big-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt16 EndianU16_BtoN (
   UInt16    value
);

/*EndianU16_NtoB

Converts an unsigned 16-bit value in the computer’s native format to the equivalent big-endian value.

UInt16 EndianU16_NtoB (
   UInt16    value
);
Parameters
value

An unsigned 16-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/

UInt16 EndianU16_NtoB (
   UInt16    value
);


/*EndianS32_NtoB

Converts a signed 32-bit value in the computer’s native format to the equivalent big-endian value.

SInt32 EndianS32_NtoB (
   SInt32    value
);
Parameters
value

A signed 32-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
SInt32 EndianS32_NtoB (
   SInt32    value
);

/*EndianU32_LtoN

Converts an unsigned 32-bit little-endian value to the equivalent value in the computer’s native format.

UInt32 EndianU32_LtoN (
   UInt32    value
);
Parameters
value

An unsigned 32-bit little-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
UInt32 EndianU32_LtoN (
   UInt32    value
);

/*EndianU16_LtoN

Converts an unsigned 16-bit little-endian value to the equivalent value in the computer’s native format.

UInt16 EndianU16_LtoN (
   UInt16    value
);
Parameters
value

An unsigned 16-bit little-endian value.
Return Value

The equivalent value in the computer’s native format.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
UInt16 EndianU16_LtoN (
   UInt16    value
);

/*EndianS16_NtoB

Converts a signed 16-bit value in the computer’s native format to the equivalent big-endian value.

SInt16 EndianS16_NtoB (
   SInt16    value
);
Parameters
value

A signed 16-bit value in the computer’s native format.
Return Value

The equivalent big-endian value.
Availability
Available in Mac OS X v10.0 and later.
Available in QuickTime 4 and later for Windows.*/
SInt16 EndianS16_NtoB (
   SInt16    value
);

#ifdef __cplusplus
}
#endif

#endif
