#ifndef DRIVERSYNCHRONIZATION_H
#define DRIVERSYNCHRONIZATION_H

#ifndef CONDITIONALMACROS_H
#include <CarbonCore/ConditionalMacros.h>
#endif

#ifndef MACTYPES_H
#include <CarbonCore/MacTypes.h>
#endif



#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*Byte Operations

The Driver Services Library provides several 32-, 16-, and 8-bit atomic memory operations for use by device drivers. These routines take logical address pointers and ensure that the operations are atomic with respect to all devices (for example, other processors and DMA engines) that participate in the coherency architecture of the Power Macintosh system.

IMPORTANT

Memory locations used by these operations must be long word aligned; if they are stored in a structure, you should use the compiler directive #pragma options align=power. 
Boolean
CompareAndSwap (long oldValue, long newValue, long *Value); 

SInt32      IncrementAtomic     (SInt32 *value);
SInt32      DecrementAtomic     (SInt32 *value); 

SInt32      AddAtomic           (SInt32 amount,         SInt32 *value); 

UInt32      BitAndAtomic        (UInt32 mask,           UInt32 *value);
UInt32      BitOrAtomic         (UInt32 mask,           UInt32 *value);
UInt32      BitXorAtomic        (UInt32 mask,           UInt32 *value); 

SInt16      IncrementAtomic16   (SInt16 *value);
SInt16      DecrementAtomic16   (SInt16 *value);
SInt16      AddAtomic16         (SInt32 amount,         SInt16 *value);
UInt16      BitAndAtomic16      (UInt32 mask,           UInt16 *value);
UInt16      BitOrAtomic16       (UInt32 mask,           UInt16 *value);
UInt16      BitXorAtomic16      (UInt32 mask,           UInt16 *value); 

SInt8       IncrementAtomic8    (SInt8 *value);
SInt8       DecrementAtomic8    (SInt8 *value);
SInt8       AddAtomic8          (SInt32 amount,         SInt8 *value);
UInt8       BitAndAtomic8       (UInt32 mask,           UInt8 *value);
UInt8       BitOrAtomic8        (UInt32 mask,           UInt8 *value);
UInt8       BitXorAtomic8       (UInt32 mask,           UInt8 *value); 
DESCRIPTION

The atomic routines perform various operations on the memory address specified by value : 
The CompareAndSwap routine compares the value at the specified address with oldValue. The value of newValue is written to the specified address only if oldValue and the value at the specified address are equal. CompareAndSwap returns true if newValue is written to the specified address; otherwise, it returns false. A false return value does not imply that oldValue and the value at the specified address are not equal; it only implies that CompareAndSwap did not write newValue to the specified address.
IncrementAtomic increments the value by 1 and DecrementAtomic decrements it by 1. These functions return the value as it was before the change.
AddAtomic adds the specified amount to the value at the specified address and returns the result. 
BitAndAtomic performs a logical and operation between the bits of the specified mask and the value at the specified address, returning the result. Similarly, BitOrAtomic performs a logical OR operation and BitXorAtomic performs a logical XOR operation.
EXECUTION CONTEXT

The atomic operation routines may be called from task level, secondary interrupt level, or hardware interrupt level.*/
Boolean CompareAndSwap (long oldValue, long newValue, long *Value);

SInt32      IncrementAtomic     (SInt32 *value);
SInt32      DecrementAtomic     (SInt32 *value); 

SInt32      AddAtomic           (SInt32 amount,         SInt32 *value);

UInt32      BitAndAtomic        (UInt32 mask,           UInt32 *value);
UInt32      BitOrAtomic         (UInt32 mask,           UInt32 *value);
UInt32      BitXorAtomic        (UInt32 mask,           UInt32 *value);
SInt16      IncrementAtomic16   (SInt16 *value);
SInt16      DecrementAtomic16   (SInt16 *value);
SInt16      AddAtomic16         (SInt32 amount,         SInt16 *value);
UInt16      BitAndAtomic16      (UInt32 mask,           UInt16 *value);
UInt16      BitOrAtomic16       (UInt32 mask,           UInt16 *value);
UInt16      BitXorAtomic16      (UInt32 mask,           UInt16 *value);
SInt8       IncrementAtomic8    (SInt8 *value);
SInt8       DecrementAtomic8    (SInt8 *value);
SInt8       AddAtomic8          (SInt32 amount,         SInt8 *value);
UInt8       BitAndAtomic8       (UInt32 mask,           UInt8 *value);
UInt8       BitOrAtomic8        (UInt32 mask,           UInt8 *value);
UInt8       BitXorAtomic8       (UInt32 mask,           UInt8 *value);

/*Bit Operations
Boolean TestAndSet(
                     UInt32 bit
                     UInt8 *startAddress); Boolean TestAndClear(
                     UInt32 bit
                     UInt8 *startAddress); 
--> bit 
The bit number in the range 0 through 7.
--> startAddress 
The address of the byte in which the bit is located.
DESCRIPTION

TestAndSet sets and TestAndClear clears a single bit in a byte at a specified address. They return true if the bit was already set or cleared respectively and false otherwise.
EXECUTION CONTEXT

TestAndSet and TestAndClear may be called from task level, secondary interrupt level, or hardware interrupt level.*/
Boolean TestAndSet(
                     UInt32 bit,
                     UInt8 *startAddress); 
Boolean TestAndClear(
                     UInt32 bit,
                     UInt8 *startAddress); 

#ifdef __cplusplus
}
#endif

#endif