#ifndef  CFHTTPAUTHENTICATION_H
#define  CFHTTPAUTHENTICATION_H

#ifndef  CFNETWORKDEFS_H
#include <CFNetwork/CFNetworkDefs.h>
#endif

#ifndef  COREFOUNDATION_H
#include <CoreFoundation/CoreFoundation.h>
#endif

#ifndef  CFHTTPMESSAGE_H
#include <CFNetwork/CFHTTPMessage.h>
#endif


#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*CFHTTPMessageApplyCredentialDictionary Keys

Constants for keys in the dictionary passed to CFHTTPMessageApplyCredentialDictionary.

const CFStringRef kCFHTTPAuthenticationUserName;
const CFStringRef kCFHTTPAuthenticationPassword;
const CFStringRef kCFHTTPAuthenticationAccountDomain;
Constants
kCFHTTPAuthenticationUserName

Username to use for authentication.
kCFHTTPAuthenticationPassword

Password to use for authentication.

Available in Mac OS X v10.4 and later.
kCFHTTPAuthenticationAccountDomain

Account domain to use for authentication.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
extern const CFStringRef kCFHTTPAuthenticationUsername;
extern const CFStringRef kCFHTTPAuthenticationPassword;
extern const CFStringRef kCFHTTPAuthenticationAccountDomain;


/*CFStream HTTP Authentication Error Constants

Authentication error codes that may be returned when trying to apply authentication to a request.

enum CFStreamErrorHTTPAuthentication{
   kCFStreamErrorHTTPAuthenticationTypeUnsupported = -1000,
   kCFStreamErrorHTTPAuthenticationBadUserName = -1001,
   kCFStreamErrorHTTPAuthenticationBadPassword = -1002
};
typedef enum CFStreamErrorHTTPAuthentication CFStreamErrorHTTPAuthentication;
Constants
kCFStreamErrorHTTPAuthenticationTypeUnsupported

Specified authentication type is not supported.

Available in Mac OS X v10.4 and later.
kCFStreamErrorHTTPAuthenticationBadUserName

User name is in a format that is not suitable for the request. Currently, user names are decoded using kCFStringEncodingISOLatin1.

Available in Mac OS X v10.4 and later.
kCFStreamErrorHTTPAuthenticationBadPassword

Password is in a format that is not suitable for the request. Currently, passwords are decoded using kCFStringEncodingISOLatin1.

Available in Mac OS X v10.4 and later.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
enum CFStreamErrorHTTPAuthentication{
   kCFStreamErrorHTTPAuthenticationTypeUnsupported = -1000,
   kCFStreamErrorHTTPAuthenticationBadUserName = -1001,
   kCFStreamErrorHTTPAuthenticationBadPassword = -1002
};
typedef enum CFStreamErrorHTTPAuthentication CFStreamErrorHTTPAuthentication;


/*CFHTTPAuthenticationRef

An opaque reference representing HTTP authentication information.

typedef struct __CFHTTPAuthentication *CFHTTPAuthenticationRef;
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
typedef struct __CFHTTPAuthentication *CFHTTPAuthenticationRef;

//function

/*CFHTTPAuthenticationCreateFromResponse

Uses an authentication failure response to create a CFHTTPAuthentication object.

CFHTTPAuthenticationRef CFHTTPAuthenticationCreateFromResponse (
    CFAllocatorRef alloc,
    CFHTTPMessageRef response
);
Parameters
alloc

The allocator to use to allocate memory for the new object. Pass NULL or kCFAllocatorDefault to use the current default allocator.
response

Response indicating an authentication failure; usually a 401 or a 407 response.
Return Value

CFHTTPAuthentication object that can be used for adding credentials to future requests. Ownership follows the Create Rule.
Discussion

This function uses a response containing authentication failure information to create a reference to a CFHTTPAuthentication object. You can use the object to add credentials to future requests. You can query the object to get the following information:
whether it can be used and re-used to authenticate with its corresponding server [CFHTTPAuthenticationIsValid]
the authentication method that will be used when it is used to perform an authentication [CFHTTPAuthenticationCopyMethod]
whether it is associated with a particular CFHTTPMessageRef [CFHTTPAuthenticationAppliesToRequest
whether a user name and a password will be required when it is used to perform an authentication [CFHTTPAuthenticationRequiresUserNameAndPassword]
whether an account domain will be required when it is used to perform an authentication [CFHTTPAuthenticationRequiresAccountDomain]
whether authentication requests should be sent one at a time to the corresponding server [CFHTTPAuthenticationRequiresOrderedRequests]
the namespace (if any) that the domain uses to prompt for a name and password [CFHTTPAuthenticationCopyRealm]
the domain URLs the instance applies to [CFHTTPAuthenticationCopyDomains]

When you have determined what information will be needed to perform the authentication and accumulated that information, call CFHTTPMessageApplyCredentials or CFHTTPMessageApplyCredentialDictionary to perform the authentication.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
CFHTTPAuthenticationRef CFHTTPAuthenticationCreateFromResponse (
    CFAllocatorRef alloc,
    CFHTTPMessageRef response
);

/*CFHTTPAuthenticationIsValid

Returns a Boolean value that indicates whether a CFHTTPAuthentication object is valid.

Boolean CFHTTPAuthenticationIsValid (
    CFHTTPAuthenticationRef auth,
    CFStreamError *error
);
Parameters
auth

The CFHTTPAuthentication object to examine.
error

Pointer to a CFStreamError structure, whose fields, if an error has occurred, are set to the error and the error’s domain.
Return Value

TRUE if auth contains enough information to be applied to a request.

If this function returns FALSE, the CFHTTPAuthentication object may still contain useful information, such as the name of an unsupported authentication method.
Discussion

If this function returns TRUE for auth, the object is good for use with functions such as CFHTTPMessageApplyCredentials and CFHTTPMessageApplyCredentialDictionary. If this function returns FALSE, auth is invalid, and authentications using it will not succeed.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
Boolean CFHTTPAuthenticationIsValid (
    CFHTTPAuthenticationRef auth,
    CFStreamError *error
);

/*CFHTTPAuthenticationRequiresUserNameAndPassword

Returns a Boolean value that indicates whether a CFHTTPAuthentication object uses an authentication method that requires a username and a password.

Boolean CFHTTPAuthenticationRequiresUserNameAndPassword (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

TRUE if auth requires a username and password when it is applied to a request; otherwise, FALSE.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
Boolean CFHTTPAuthenticationRequiresUserNameAndPassword (
    CFHTTPAuthenticationRef auth
);

/*CFHTTPAuthenticationRequiresAccountDomain

Returns a Boolean value that indicates whether a CFHTTPAuthentication object uses an authentication method that requires an account domain.

Boolean CFHTTPAuthenticationRequiresAccountDomain (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

TRUE if auth uses an authentication method that requires an account domain, otherwise FALSE.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/

Boolean CFHTTPAuthenticationRequiresAccountDomain (
    CFHTTPAuthenticationRef auth
);

/*CFHTTPAuthenticationCopyRealm

Gets an authentication information’s namespace.

CFStringRef CFHTTPAuthenticationCopyRealm (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

The namespace, if there is one; otherwise NULL. Ownership follows the Create Rule.
Discussion

Some authentication methods provide a namespace, and it is usually used to prompt the user for a name and password.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
CFStringRef CFHTTPAuthenticationCopyRealm (
    CFHTTPAuthenticationRef auth
);

/*CFHTTPMessageApplyCredentialDictionary

Use a dictionary containing authentication credentials to perform the authentication method specified by a CFHTTPAuthentication object.

Boolean CFHTTPMessageApplyCredentialDictionary (
CFHTTPMessageRef request,
CFHTTPAuthenticationRef auth,
CFDictionaryRef dict,
CFStreamError * error);
Parameters
request

The request for which the authentication method is to be performed.
auth

A CFHTTPAuthentication object specifying the authentication method to perform.
dict

A dictionary containing authentication credentials to be applied to the request. For information on the keys in this dictionary, see CFHTTPAuthenticationRef.
error

If an error occurs, upon return contains a CFStreamError object that describes the error and the error’s domain. Pass NULL if you don’t want to receive error information.
Return Value

TRUE if the authentication was successful, otherwise, FALSE.
Discussion

This function performs the authentication method specified by auth on behalf of the request specified by request using the credentials contained in the dictionary specified by dict. The dictionary must contain values for the kCFHTTPAuthenticationUsername and kCFHTTPAuthenticationPassword keys. If CFHTTPAuthenticationRequiresAccountDomain returns TRUE for auth, the dictionary must also contain a value for the kCFHTTPAuthenticationAccountDomain key.
Special Considerations

This function is thread safe as long as another thread does not alter the same CFHTTPAuthentication object at the same time.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
Boolean CFHTTPMessageApplyCredentialDictionary (
CFHTTPMessageRef request,
CFHTTPAuthenticationRef auth,
CFDictionaryRef dict,
CFStreamError * error);

/*CFHTTPAuthenticationAppliesToRequest

Returns a Boolean value that indicates whether a CFHTTPAuthentication object is associated with a CFHTTPMessage object.

Boolean CFHTTPAuthenticationAppliesToRequest (
    CFHTTPAuthenticationRef auth,
    CFHTTPMessageRef request
);
Parameters
auth

The CFHTTPAuthentication object to examine.
request

Request that auth is to be tested against.
Return Value

TRUE if auth is associated with request, otherwise FALSE.
Discussion

If this function returns TRUE, you can use auth to provide authentication information when using request.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
Boolean CFHTTPAuthenticationAppliesToRequest (
    CFHTTPAuthenticationRef auth,
    CFHTTPMessageRef request
);

/*CFHTTPAuthenticationCopyMethod

Gets the strongest authentication method that will be used when a CFHTTPAuthentication object is applied to a request.

CFStringRef CFHTTPAuthenticationCopyMethod (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

A string containing the authentication method that will be used auth is applied to a request. If more than one authentication method is available, the strongest authentication method is returned. Ownership follows the Create Rule.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/

CFStringRef CFHTTPAuthenticationCopyMethod (
    CFHTTPAuthenticationRef auth
);

/*CFHTTPAuthenticationCopyDomains

Returns an array of domain URLs to which a given CFHTTPAuthentication object can be applied.

CFArrayRef CFHTTPAuthenticationCopyDomains (
    CFHTTPAuthenticationRef auth
);
Parameters
auth

The CFHTTPAuthentication object to examine.
Return Value

A CFArray object that contains the domain URL’s to which auth should be applied. Ownership follows the Create Rule.
Discussion

This function is provided for informational purposes only.
Availability
Available in Mac OS X version 10.4 and later.
Declared In
CFNetwork/CFHTTPAuthentication.h*/
CFArrayRef CFHTTPAuthenticationCopyDomains (
    CFHTTPAuthenticationRef auth
);


#ifdef __cplusplus
}
#endif

#endif 

