#ifndef AUDIOCONVERTER_H
#define AUDIOCONVERTER_H


#include <AvailabilityMacros.h>
#include <CoreAudio/CoreAudioTypes.h>

#include <CoreFoundation/CFBase.h>//hys

#if defined(__cplusplus)
extern "C"
{
#endif

/*AudioConverterRef


A reference to an AudioConverter object. 
typedef struct OpaqueAudioConverter * AudioConverterRef;  */
typedef struct OpaqueAudioConverter * AudioConverterRef;

/*AudioConverterComplexInputDataProc


Callback function for supplying input data to AudioConverterFillComplexBuffer.
typedef OSStatus (*AudioConverterComplexInputDataProc)(
    AudioConverterRef inAudioConverter, 
    UInt32*ioNumberDataPackets, 
    AudioBufferList*ioData, 
    AudioStreamPacketDescription** outDataPacketDescription, 
    void*inUserData);  
Parameters
inAudioConverter
The AudioConverter requesting input.
ioNumberDataPackets
On entry, the minimum number of packets of input audio data the converter would like in order to fulfill its current FillBuffer request. On exit, the number of packets of audio data actually being provided for input, or 0 if there is no more input.
ioData
On exit, the members of ioData should be set to point to the audio data being provided for input.
outDataPacketDescription
If non-null, on exit, the callback is expected to fill this in with an AudioStreamPacketDescription for each packet of input data being provided.
inUserData
The inInputDataProcUserData parameter passed to AudioConverterFillBuffer().
Return Value

An OSStatus result code. 

Discussion 

This callback function supplies input to AudioConverterFillComplexBuffer. 

The AudioConverter requests a minimum number of packets (*ioNumberDataPackets). The callback may return one or more packets. If this is less than than the minimum, the callback will simply be called again in the near future. 

The callback manipulates the members of ioData to point to one or more buffers of audio data (multiple buffers are used with non-interleaved PCM data). The callback is responsible for not freeing or altering this buffer until it is called again. 

If the callback returns an error, it must return zero packets of data. AudioConverterFillComplexBuffer will stop producing output and return whatever output has already been produced to its caller, along with the error code. This mechanism can be used when an input proc has temporarily run out of data, but has not yet reached end of stream.*/
typedef OSStatus (*AudioConverterComplexInputDataProc)(
    AudioConverterRef inAudioConverter, 
    UInt32*ioNumberDataPackets, 
    AudioBufferList*ioData, 
    AudioStreamPacketDescription** outDataPacketDescription, 
    void*inUserData);  

/*AudioConverterPropertyID


The properties of an AudioConverter, accessible via AudioConverterGetProperty() and AudioConverterSetProperty().
enum // typedef UInt32 AudioConverterPropertyID 
{ 
    kAudioConverterPropertyMinimumInputBufferSize = 'mibs', 
    kAudioConverterPropertyMinimumOutputBufferSize = 'mobs', 
    kAudioConverterPropertyMaximumInputBufferSize = 'xibs', 
    kAudioConverterPropertyMaximumInputPacketSize = 'xips', 
    kAudioConverterPropertyMaximumOutputPacketSize = 'xops', 
    kAudioConverterPropertyCalculateInputBufferSize = 'cibs', 
    kAudioConverterPropertyCalculateOutputBufferSize = 'cobs', 
    kAudioConverterPropertyInputCodecParameters = 'icdp', 
    kAudioConverterPropertyOutputCodecParameters = 'ocdp', 
    kAudioConverterSampleRateConverterAlgorithm = 'srci', 
    kAudioConverterSampleRateConverterQuality = 'srcq', 
    kAudioConverterCodecQuality = 'cdqu', 
    kAudioConverterPrimeMethod = 'prmm', 
    kAudioConverterPrimeInfo = 'prim', 
    kAudioConverterChannelMap = 'chmp', 
    kAudioConverterDecompressionMagicCookie = 'dmgc', 
    kAudioConverterCompressionMagicCookie = 'cmgc', 
    kAudioConverterEncodeBitRate = 'brat', 
    kAudioConverterEncodeAdjustableSampleRate = 'ajsr', 
    kAudioConverterInputChannelLayout = 'icl ', 
    kAudioConverterOutputChannelLayout = 'ocl ', 
    kAudioConverterApplicableEncodeBitRates = 'aebr', 
    kAudioConverterAvailableEncodeBitRates = 'vebr', 
    kAudioConverterApplicableEncodeSampleRates = 'aesr', 
    kAudioConverterAvailableEncodeSampleRates = 'vesr', 
    kAudioConverterAvailableEncodeChannelLayoutTags = 'aecl', 
    kAudioConverterCurrentOutputStreamDescription = 'acod', 
    kAudioConverterCurrentInputStreamDescription = 'acid', 
    kAudioConverterPropertySettings = 'acps', 
    kAudioConverterPropertyBitDepthHint = 'acbd' 
};  
Constants
kAudioConverterPropertyMinimumInputBufferSize
a UInt32 that indicates the size in bytes of the smallest buffer of input data that can be supplied via the AudioConverterInputProc or as the input to AudioConverterConvertBuffer
kAudioConverterPropertyMinimumOutputBufferSize
a UInt32 that indicates the size in bytes of the smallest buffer of output data that can be supplied to AudioConverterFillBuffer or as the output to AudioConverterConvertBuffer
kAudioConverterPropertyMaximumInputBufferSize
a UInt32 that indicates the size in bytes of the largest buffer of input data that will be requested from the AudioConverterInputProc. This is mostly useful for variable bit rate compressed data. This will be equal to 0xFFFFFFFF if the maximum value depends on what is requested from the output, which is usually the case for constant bit rate formats.
kAudioConverterPropertyMaximumInputPacketSize
a UInt32 that indicates the size in bytes of the largest single packet of data in the input format. This is mostly useful for variable bit rate compressed data (decoders).
kAudioConverterPropertyMaximumOutputPacketSize
a UInt32 that indicates the size in bytes of the largest single packet of data in the output format. This is mostly useful for variable bit rate compressed data (encoders).
kAudioConverterPropertyCalculateInputBufferSize
a UInt32 that on input holds a size in bytes that is desired for the output data. On output, it will hold the size in bytes of the input buffer required to generate that much output data. Note that some converters cannot do this calculation.
kAudioConverterPropertyCalculateOutputBufferSize
a UInt32 that on input holds a size in bytes that is desired for the input data. On output, it will hold the size in bytes of the output buffer required to hold the output data that will be generated. Note that some converters cannot do this calculation.
kAudioConverterPropertyInputCodecParameters
The value of this property varies from format to format and is considered private to the format. It is treated as a buffer of untyped data.
kAudioConverterPropertyOutputCodecParameters
The value of this property varies from format to format and is considered private to the format. It is treated as a buffer of untyped data.
kAudioConverterSampleRateConverterAlgorithm
DEPRECATED: please use kAudioConverterSampleRateConverterQuality instead 

An OSType that specifies the sample rate converter to use (as defined in AudioUnit/AudioUnitProperties.h -- for now only Apple SRC's can be used)
kAudioConverterSampleRateConverterQuality
A UInt32 that specifies rendering quality of the sample rate converter (see enum constants below)
kAudioConverterCodecQuality
A UInt32 that specifies rendering quality of a codec (see enum constants below)
kAudioConverterPrimeMethod
a UInt32 specifying priming method (usually for sample-rate converter) see explanation for struct AudioConverterPrimeInfo below along with enum constants
kAudioConverterPrimeInfo
A pointer to AudioConverterPrimeInfo (see explanation for struct AudioConverterPrimeInfo below)
kAudioConverterChannelMap
An array of SInt32's. The size of the array is the number of output channels, and each element specifies which input channel's data is routed to that output channel (using a 0-based index of the input channels), or -1 if no input channel is to be routed to that output channel. The default behavior is as follows. I = number of input channels, O = number of output channels. When I > O, the first O inputs are routed to the first O outputs, and the remaining puts discarded. When O > I, the first I inputs are routed to the first O outputs, and the remaining outputs are zeroed. 

A simple example for splitting mono input to stereo output (instead of routing the input to only the first output channel): 

   // this should be as large as the number of output channels:
  SInt32 channelMap[2] = { 0, 0 };
  AudioConverterSetProperty(theConverter, kAudioConverterChannelMap, 
    sizeof(channelMap), channelMap);
kAudioConverterDecompressionMagicCookie
A void * pointing to memory set up by the caller. Required by some formats in order to decompress the input data.
kAudioConverterCompressionMagicCookie
A void * pointing to memory set up by the caller. Returned by the converter so that it may be stored along with the output data. It can then be passed back to the converter for decompression at a later time.
kAudioConverterEncodeBitRate
A UInt32 containing the number of bits per second to aim for when encoding data. This property is only relevant to encoders.
kAudioConverterEncodeAdjustableSampleRate
For encoders where the AudioConverter was created with an output sample rate of zero, and the codec can do rate conversion on its input, this provides a way to set the output sample rate. The property value is a Float64.
kAudioConverterInputChannelLayout
The property value is an AudioChannelLayout.
kAudioConverterOutputChannelLayout
The property value is an AudioChannelLayout.
kAudioConverterApplicableEncodeBitRates
The property value is an array of AudioValueRange describing applicable bit rates based on current settings.
kAudioConverterAvailableEncodeBitRates
The property value is an array of AudioValueRange describing available bit rates based on the input format. You can get all available bit rates from the AudioFormat API.
kAudioConverterApplicableEncodeSampleRates
The property value is an array of AudioValueRange describing applicable sample rates based on current settings.
kAudioConverterAvailableEncodeSampleRates
The property value is an array of AudioValueRange describing available sample rates based on the input format. You can get all available sample rates from the AudioFormat API.
kAudioConverterAvailableEncodeChannelLayoutTags
The property value is an array of AudioChannelLayoutTags for the format and number of channels specified in the input format going to the encoder.
kAudioConverterCurrentOutputStreamDescription
Returns the current completely specified output AudioStreamBasicDescription. For example when encoding to AAC, your original output stream description will not have been completely filled out.
kAudioConverterCurrentInputStreamDescription
Returns the current completely specified input AudioStreamBasicDescription.
kAudioConverterPropertySettings
Returns the a CFArray of property settings for converters.
kAudioConverterPropertyBitDepthHint
A UInt32 of the source bit depth to preserve. This is a hint to some encoders like lossless about how many bits to preserve in the input. The converter usually tries to preserve as many as possible, but a lossless encoder will do poorly if more bits are supplied than are desired in the output.*/
enum // typedef UInt32 AudioConverterPropertyID 
{ 
    kAudioConverterPropertyMinimumInputBufferSize = 'mibs', 
    kAudioConverterPropertyMinimumOutputBufferSize = 'mobs', 
    kAudioConverterPropertyMaximumInputBufferSize = 'xibs', 
    kAudioConverterPropertyMaximumInputPacketSize = 'xips', 
    kAudioConverterPropertyMaximumOutputPacketSize = 'xops', 
    kAudioConverterPropertyCalculateInputBufferSize = 'cibs', 
    kAudioConverterPropertyCalculateOutputBufferSize = 'cobs', 
    kAudioConverterPropertyInputCodecParameters = 'icdp', 
    kAudioConverterPropertyOutputCodecParameters = 'ocdp', 
    kAudioConverterSampleRateConverterAlgorithm = 'srci', 
    kAudioConverterSampleRateConverterQuality = 'srcq', 
    kAudioConverterCodecQuality = 'cdqu', 
    kAudioConverterPrimeMethod = 'prmm', 
    kAudioConverterPrimeInfo = 'prim', 
    kAudioConverterChannelMap = 'chmp', 
    kAudioConverterDecompressionMagicCookie = 'dmgc', 
    kAudioConverterCompressionMagicCookie = 'cmgc', 
    kAudioConverterEncodeBitRate = 'brat', 
    kAudioConverterEncodeAdjustableSampleRate = 'ajsr', 
    kAudioConverterInputChannelLayout = 'icl ', 
    kAudioConverterOutputChannelLayout = 'ocl ', 
    kAudioConverterApplicableEncodeBitRates = 'aebr', 
    kAudioConverterAvailableEncodeBitRates = 'vebr', 
    kAudioConverterApplicableEncodeSampleRates = 'aesr', 
    kAudioConverterAvailableEncodeSampleRates = 'vesr', 
    kAudioConverterAvailableEncodeChannelLayoutTags = 'aecl', 
    kAudioConverterCurrentOutputStreamDescription = 'acod', 
    kAudioConverterCurrentInputStreamDescription = 'acid', 
    kAudioConverterPropertySettings = 'acps', 
    kAudioConverterPropertyBitDepthHint = 'acbd' 
};
typedef UInt32 AudioConverterPropertyID;

//function
/*AudioConverterSetProperty

Sets the property data to inPropertyData.

extern OSStatus AudioConverterSetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 inPropertyDataSize,
const void* inPropertyData
);
Discussion

The inPropertyDataSize should be the size of data being input, and inPropertyData should point to the data to be set for inPropertyID.
Availability
Available in Mac OS X v10.1 and later.*/
extern OSStatus AudioConverterSetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 inPropertyDataSize,
const void* inPropertyData
);

/*AudioConverterGetProperty

Returns the requested property data.

extern OSStatus AudioConverterGetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* ioPropertyDataSize,
void* outPropertyData
);
Discussion

The ioPropertyDataSize parameter should be the value obtained from calling AudioConverterGetPropertyInfo(); the output value of ioPropertyDataSize will be the actual data size of the returned data, for reference.
Availability
Available in Mac OS X v10.1 and later.*/
extern OSStatus AudioConverterGetProperty(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* ioPropertyDataSize,
void* outPropertyData
);



/*AudioConverterGetPropertyInfo

Retrieves the size and writable state of the data belonging to the queried property.

extern OSStatus AudioConverterGetPropertyInfo(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32* outSize,
Boolean* outWritable
);
Discussion

The outSize value returned reflects the size, in bytes, of the data returned by calling AudioConverterGetProperty() with the respective property.
Availability
Available in Mac OS X v10.1 and later.*/
extern OSStatus AudioConverterGetPropertyInfo(
AudioConverterRef inAudioConverter,
AudioConverterPropertyID inPropertyID,
UInt32 * outSize,
Boolean * outWritable
);

/*AudioConverterFillComplexBuffer

Fills the AudioBufferList with converted data.

extern OSStatus AudioConverterFillComplexBuffer(
AudioConverterRef inAudioConverter,
AudioConverterComplexInputDataProc inInputDataProc,
void* inInputDataProcUserData,
UInt32* ioOutputDataPacketSize,
AudioBufferList* outOutputData,
AudioStreamPacketDescription* outPacketDescription
);
Discussion

Using the callback provided in inInputDataProc, this function will convert input data using inAudioConverter and will place the resulting converted data in outOutputData. Any relevant data for the callback should be passed in via inInputDataProcUserData, while outPacketDescription will contain the format of the returned data. On input, ioOutDataPacketSize should contain the number of packets requested, and as output, will contain the number of packets returned.
Availability
Available in Mac OS X v10.2 and later.*/
extern OSStatus AudioConverterFillComplexBuffer(
AudioConverterRef inAudioConverter,
AudioConverterComplexInputDataProc inInputDataProc,
void* inInputDataProcUserData,
UInt32* ioOutputDataPacketSize,
AudioBufferList* outOutputData,
AudioStreamPacketDescription* outPacketDescription
);

/*AudioConverterDispose

Destroys an audio converter.

extern OSStatus AudioConverterDispose(AudioConverterRef inAudioConverter);
Discussion

This function deallocates the memory used by inAudioConverter.
Availability
Available in Mac OS X v10.1 and later.*/
extern OSStatus AudioConverterDispose(AudioConverterRef inAudioConverter);


/*AudioConverterNew

Creates a new audio converter.

extern OSStatus AudioConverterNew(
const AudioStreamBasicDescription* inSourceFormat,
const AudioStreamBasicDescription* inDestinationFormat, AudioConverterRef* outAudioConverter
);
Discussion

This function takes in two AudioStreamBasicDescription instances, one for the source, and one for the destination, sets up all of the internal links needed for the conversion, and returns a pointer for the new converter. Note that if the setup fails, an error is returned which specifies the error that was encountered.
Availability
Available in Mac OS X v10.1 and later.*/
extern OSStatus AudioConverterNew(
const AudioStreamBasicDescription* inSourceFormat,
const AudioStreamBasicDescription* inDestinationFormat, AudioConverterRef* outAudioConverter
);


#ifdef __cplusplus
}
#endif

#endif