#ifndef ABTYPEDEFS_H
#define ABTYPEDEFS_H

/*ABSearchComparison

Constants used to specify the type of comparison being made.

enum ABSearchComparison {
   kABEqual,
   kABNotEqual,
   kABLessThan,
   kABLessThanOrEqual,
   kABGreaterThan,
   kABGreaterThanOrEqual,
   kABEqualCaseInsensitive,
   kABContainsSubString,
   kABContainsSubStringCaseInsensitive,
   kABPrefixMatch,
   kABPrefixMatchCaseInsensitive,
   kABBitsInBitFieldMatch,
   kABDoesNotContainSubString,
   kABDoesNotContainSubStringCaseInsensitive,
   kABNotEqualCaseInsensitive,
   kABSuffixMatch,
   kABSuffixMatchCaseInsensitive,
   kABWithinIntervalAroundToday,
   kABWithinIntervalAroundTodayYearless,
   kABNotWithinIntervalAroundToday,
   kABNotWithinIntervalAroundTodayYearless,
   kABWithinIntervalFromToday,
   kABWithinIntervalFromTodayYearless,
   kABNotWithinIntervalFromToday,
   kABNotWithinIntervalFromTodayYearless
};
Constants
kABEqual

Search for elements that are equal to the value.

Available in Mac OS X v10.2 and later.
kABNotEqual

Search for elements that are not equal to the value.

Available in Mac OS X v10.2 and later.
kABNotEqualCaseInsensitive

Search for elements that are not equal to the value, ignoring case.

Available in Mac OS X v10.4 and later.
kABLessThan

Search for elements that are less than the value.

Available in Mac OS X v10.2 and later.
kABLessThanOrEqual

Search for elements that are less than or equal to the value.

Available in Mac OS X v10.2 and later.
kABGreaterThan

Search for elements that are greater than the value.

Available in Mac OS X v10.2 and later.
kABGreaterThanOrEqual

Search for elements that are greater than or equal to the value.

Available in Mac OS X v10.2 and later.
kABEqualCaseInsensitive

Search for elements that are equal to the value, ignoring case.

Available in Mac OS X v10.2 and later.
kABContainsSubString

Search for elements that contain the value.

Available in Mac OS X v10.2 and later.
kABContainsSubStringCaseInsensitive

Search for elements that contain the value, ignoring case.

Available in Mac OS X v10.2 and later.
kABPrefixMatch

Search for elements that begin with the value.

Available in Mac OS X v10.2 and later.
kABPrefixMatchCaseInsensitive

Search for elements that begin with the value, ignoring case.

Available in Mac OS X v10.2 and later.
kABSuffixMatch

Search for elements that end with the value.

Available in Mac OS X v10.4 and later.
kABSuffixMatchCaseInsensitive

Search for elements that end with the value, ignoring case.

Available in Mac OS X v10.4 and later.
kABBitsInBitFieldMatch

Search for elements that match the bits in ABPersonFlags.

Available in Mac OS X v10.3 and later.
kABDoesNotContainSubString

Search for elements that do not contain the value.

Available in Mac OS X v10.4 and later.
kABDoesNotContainSubStringCaseInsensitive

Search for elements that do not contain the value, ignoring case.

Available in Mac OS X v10.4 and later.
kABWithinIntervalAroundToday

Search for elements that are within a time interval (in seconds) forward or backward from today.

Available in Mac OS X v10.4 and later.
kABWithinIntervalAroundTodayYearless

Search for elements that are within a time interval (in seconds) forward or backward from this day in any year.

Available in Mac OS X v10.4 and later.
kABNotWithinIntervalAroundToday

Search for elements that are not within a time interval (in seconds) forward or backward from today.

Available in Mac OS X v10.4 and later.
kABNotWithinIntervalAroundTodayYearless

Search for elements that are not within a time interval (in seconds) forward or backward from this day in any year.

Available in Mac OS X v10.4 and later.
kABWithinIntervalFromToday

Search for elements that are within a time interval (in seconds) forward from today.

Available in Mac OS X v10.4 and later.
kABWithinIntervalFromTodayYearless

Search for elements that are within a time interval (in seconds) forward from this day in any year.

Available in Mac OS X v10.4 and later.
kABNotWithinIntervalFromToday

Search for elements that are not within a time interval (in seconds) forward from today.

Available in Mac OS X v10.4 and later.
kABNotWithinIntervalFromTodayYearless

Search for elements that are not within a time interval (in seconds) forward from this day in any year.

Available in Mac OS X v10.4 and later.
Discussion

These constants are used in a call to the ABGroupCreateSearchElement or ABPersonCreateSearchElement function to specify the type of comparison being made.
Version Notes*/
enum ABSearchComparison {
   kABEqual,
   kABNotEqual,
   kABLessThan,
   kABLessThanOrEqual,
   kABGreaterThan,
   kABGreaterThanOrEqual,
   kABEqualCaseInsensitive,
   kABContainsSubString,
   kABContainsSubStringCaseInsensitive,
   kABPrefixMatch,
   kABPrefixMatchCaseInsensitive,
   kABBitsInBitFieldMatch,
   kABDoesNotContainSubString,
   kABDoesNotContainSubStringCaseInsensitive,
   kABNotEqualCaseInsensitive,
   kABSuffixMatch,
   kABSuffixMatchCaseInsensitive,
   kABWithinIntervalAroundToday,
   kABWithinIntervalAroundTodayYearless,
   kABNotWithinIntervalAroundToday,
   kABNotWithinIntervalAroundTodayYearless,
   kABWithinIntervalFromToday,
   kABWithinIntervalFromTodayYearless,
   kABNotWithinIntervalFromToday,
   kABNotWithinIntervalFromTodayYearless
};
typedef enum  ABSearchComparison ABSearchComparison;

#endif
