//incl
#ifndef AEDATAMODEL_H
#define AEDATAMODEL_H


#ifndef CORESERVICES_H
#include <CoreServices/CoreServices.h>
#endif

//#include <HYS/AE/AEDataModel.h>
#include <APPLE/AE/AEDataModel.h>
#include <AvailabilityMacros.h>

#if PRAGMA_ONCE
#pragma once
#endif

#ifdef __cplusplus
extern "C" {
#endif

/*typeMachPort

For specifying a Mach port.

enum {
   typeMachPort = 'port'
};
Constants
typeMachPort

Indicates a descriptor that specifies a Mach port.

Available in Mac OS X v10.0 and later.
Discussion

You might use this constant as part of sending an Apple event to an arbitrary Mach port. Your code for creating the descriptor might look like the following:mach_port_t port = lookupPortForTarget(); // User routine to get  port. // Now create a descriptor with it: AECreateDesc(typeMachPort, &port, sizeof(port), &desc);


Actually sending an Apple event to a Mach port is an advanced technique and is not documented here.
Availability
Mac OS X only.*/
enum {
   typeMachPort = 'port'
};


/*Keyword Attribute Constants

Specify keyword values for Apple event attributes.

enum {
   keyTransactionIDAttr = 'tran',
   keyReturnIDAttr = 'rtid',
   keyEventClassAttr = 'evcl',
   keyEventIDAttr = 'evid',
   keyAddressAttr = 'addr',
   keyOptionalKeywordAttr = 'optk',
   keyTimeoutAttr = 'timo',
   keyInteractLevelAttr = 'inte',
   keyEventSourceAttr = 'esrc',
   keyMissedKeywordAttr = 'miss',
   keyOriginalAddressAttr = 'from',
   keyAcceptTimeoutAttr = 'actm',
   keyReplyRequestedAttr = 'repq'
};
Constants
keyTransactionIDAttr

Transaction ID identifying a series of Apple events that are part of one transaction.

Available in Mac OS X v10.0 and later.
keyReturnIDAttr

Return ID for a reply Apple event.

Available in Mac OS X v10.0 and later.
keyEventClassAttr

Event class of an Apple event. See AEAddressDesc.

Available in Mac OS X v10.0 and later.
keyEventIDAttr

Event ID of an Apple event. See AEAddressDesc.

Available in Mac OS X v10.0 and later.
keyAddressAttr

Address of a target or client application. See also AEAddressDesc.

Available in Mac OS X v10.0 and later.
keyOptionalKeywordAttr

List of keywords for parameters of an Apple event that should be treated as optional by the target application.

Available in Mac OS X v10.0 and later.
keyTimeoutAttr

Length of time, in ticks, that the client will wait for a reply or a result from the server.

Available in Mac OS X v10.0 and later.
keyInteractLevelAttr

Settings for when to allow the Apple Event Manager to bring a server application to the foreground, if necessary, to interact with the user. See AEAddressDesc. (Read only.)

Available in Mac OS X v10.0 and later.
keyEventSourceAttr

Nature of the source application. (Read only.)

Available in Mac OS X v10.0 and later.
keyMissedKeywordAttr

Keyword for first required parameter remaining in an Apple event. (Read only.)

After extracting all known Apple event parameters from an event, your handler should check whether the keyMissedKeywordAttr attribute exists. If so, your handler has not retrieved all the parameters that the source application considered to be required, and it should return an error.

Available in Mac OS X v10.0 and later.
keyOriginalAddressAttr

Address of original source of Apple event if the event has been forwarded (available only in version 1.01 or later versions of the Apple Event Manager). See also AEAddressDesc.

Available in Mac OS X v10.0 and later.
keyReplyRequestedAttr

A Boolean value indicating whether the Apple event expects to be replied to.

Available in Mac OS X v10.3 and later.
Discussion

These constants are keyword constants for Apple event attributes. An Apple event consists of attributes (which identify the Apple event and denote its task) and, often, parameters (which contain information to be used by the target application). An Apple event attribute is a descriptor that identifies the event class, event ID, target application, or some other characteristic of the Apple event. Taken together, the attributes of an Apple event denote the task to be performed on any data specified in the Apple event’s parameters.

Keywords are arbitrary names used by the Apple Event Manager to keep track of various descriptors. Your application cannot examine the contents of an Apple event directly. Instead, you call Apple Event Manager routines such as those described in “Getting Data or Descriptors From Apple Events” to request attributes and parameters by keyword.

See also “Keyword Parameter Constants”.
Version Notes

The constant keyReplyRequestedAttr was added in Mac OS X version 10.3.*/
enum {
   keyTransactionIDAttr = 'tran',
   keyReturnIDAttr = 'rtid',
   keyEventClassAttr = 'evcl',
   keyEventIDAttr = 'evid',
   keyAddressAttr = 'addr',
   keyOptionalKeywordAttr = 'optk',
   keyTimeoutAttr = 'timo',
   keyInteractLevelAttr = 'inte',
   keyEventSourceAttr = 'esrc',
   keyMissedKeywordAttr = 'miss',
   keyOriginalAddressAttr = 'from',
   keyAcceptTimeoutAttr = 'actm',
   keyReplyRequestedAttr = 'repq'
};



/*Numeric Descriptor Type Constants

Specify types for numeric descriptors.

enum {
   typeSInt16 = 'shor',
   typeSInt32 = 'long',
   typeUInt32 = 'magn',
   typeSInt64 = 'comp',
   typeIEEE32BitFloatingPoint = 'sing',
   typeIEEE64BitFloatingPoint = 'doub',
   type128BitFloatingPoint = 'ldbl',
   typeDecimalStruct = 'decm'
};
Discussion

The constants described here specify the data type for a descriptor and show the kind of numeric data stored in a descriptor with that type. These constants are preferred over their older equivalents described in “typeSMInt”.

Descriptors are the building blocks used by the Apple Event Manager to construct Apple event attributes and parameters. A descriptor is a data structure of type AEDesc, which consists of data storage and a descriptor type that identifies the type of the data. A descriptor type is defined by the data type DescType. 

AppleScript defines descriptor type constants for a wide variety of common data types. For additional types, see “Descriptor Type Constants” and “Other Descriptor Type Constants”. For a complete listing, including data types such as units of length, weight, and volume, see the Apple Event Manager and Open Scripting Architecture header files.*/
enum {
   typeSInt16 = 'shor',
   typeSInt32 = 'long',
   typeUInt32 = 'magn',
   typeSInt64 = 'comp',
   typeIEEE32BitFloatingPoint = 'sing',
   typeIEEE64BitFloatingPoint = 'doub',
   type128BitFloatingPoint = 'ldbl',
   typeDecimalStruct = 'decm'
};


/*Timeout Constants

Specify a timeout value.

enum {
   kAEDefaultTimeout = -1,
   kNoTimeOut = -2
};
Constants
kAEDefaultTimeout

The timeout value is determined by the Apple Event Manager. The default timeout value is about one minute.

Available in Mac OS X v10.0 and later.
kNoTimeOut

Your application is willing to wait indefinitely. Most commonly, you instead provide a timeout value (in ticks) that will provide a reasonable amount of time for the current operation.

Available in Mac OS X v10.0 and later.
Discussion

Your application can use these constants when it calls the AEInteractWithUser function, or it can supply the specific amount of time (in ticks) that your handler is willing to wait for a response from the user. You can also use the constants with the AESend function.*/
enum {
   kAEDefaultTimeout = -1,
   kNoTimeOut = -2
};

/*Priority Constants for the AESend Function (deprecated in Mac OS X)

Specify a value for the sendPriority parameter of the AESend function.

enum {
   kAENormalPriority = 0x00000000,
   kAEHighPriority = 0x00000001
};
Constants
kAENormalPriority

The Apple Event Manager posts the event at the end of the event queue of the server process and the server processes the Apple event as soon as it has the opportunity.

Available in Mac OS X v10.0 and later.
kAEHighPriority

The Apple Event Manager posts the event at the beginning of the event queue of the server process.

Available in Mac OS X v10.0 and later.
Discussion

For related information, see the AESend function and “AESendMode”. 
Version Notes

The sendPriority parameter of the AESend function is deprecated in Mac OS X.*/
enum {
   kAENormalPriority = 0x00000000,
   kAEHighPriority = 0x00000001
};

/*AESendPriority

Specifies the processing priority for a sent Apple event.

typedef SInt16 AESendPriority;
Discussion

When you call the AESend function, you pass a value of type AESendPriority for the sendPriority parameter. “Priority Constants for the AESend Function (deprecated in Mac OS X)” lists the valid constant values for a variable or parameter of this type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 AESendPriority;

/*typeUnicodeText

enum {
   typeUTF16ExternalRepresentation = 'ut16',
   typeUnicodeText = 'utxt',
   typeStyledUnicodeText = 'sutx',
   typeUTF8Text = 'utf8',
   typeEncodedString = 'encs',
   typeCString = 'cstr',
   typePString = 'pstr'
};
Constants
typeUTF16ExternalRepresentation

Unicode text in 16-bit external representation with byte-order-mark (BOM).

Guarantees that either there is a BOM or the data is in UTF-16BE.

Available starting in Mac OS X version 10.4.
typeUnicodeText

Unicode text. Native byte ordering, optional BOM.

Available in Mac OS X v10.0 and later.
typeStyledUnicodeText

Styled Unicode text. Not implemented.

Available in Mac OS X v10.0 and later.
typeUTF8Text

8-bit Unicode (UTF-8 encoding).

Available in Mac OS X v10.2 and later.
typeEncodedString

Styled Unicode text. Not implemented.

Available in Mac OS X v10.0 and later.
typeCString

C string—MacRoman characters followed by a NULL byte. Deprecated.

Available in Mac OS X v10.0 and later.
typePString

Pascal string—unsigned length byte followed by MacRoman characters. Deprecated.

Available in Mac OS X v10.0 and later.
Version Notes

In Mac OS X version 10.4, you should use typeUTF16ExternalRepresentation or typeUTF8Text to represent text. In earlier versions of Mac OS X, the recommended text type is typeUnicodeText. All of the other constants in this enum are deprecated due to their lack of explicit encoding or byte order definition.

The implicitly encoded text types, typeText, typeCString, and typePString, are all deprecated in Mac OS X, because they are incapable of representing international characters and may be reinterpreted in unpredictable ways. Additionally, typeCString and typePString do not support the full range of text coercions, and will be removed entirely in a future release. typeStyledText and typeIntlText, while they have explicit encodings, are not recommended, since they are incapable of representing Unicode-only characters, such as Hungarian, Arabic, or Thai.*/
enum {
   typeUTF16ExternalRepresentation = 'ut16',
   typeUnicodeText = 'utxt',
   typeStyledUnicodeText = 'sutx',
   typeUTF8Text = 'utf8',
   typeEncodedString = 'encs',
   typeCString = 'cstr',
   typePString = 'pstr'
};

/*typeSMInt

Where possible, you should use the constants defined in “Numeric Descriptor Type Constants”, rather than those defined here.

enum {
   typeSMInt = 'shor',
   typeShortInteger = 'shor',
   typeInteger = 'long',
   typeLongInteger = 'long',
   typeMagnitude = 'magn',
   typeComp = 'comp',
   typeSMFloat = 'sing',
   typeShortFloat = 'sing',
   typeFloat = 'doub',
   typeLongFloat = 'doub',
   typeExtended = 'exte'
};
Constants
typeSMInt

16-bit integer.

Available in Mac OS X v10.0 and later.
typeShortInteger

16-bit integer.

Available in Mac OS X v10.0 and later.
typeInteger

32-bit integer.

Available in Mac OS X v10.0 and later.
typeLongInteger

32-bit integer.

Available in Mac OS X v10.0 and later.
typeMagnitude

Unsigned 32-bit integer.

Available in Mac OS X v10.0 and later.
typeComp

Standard Apple Numerics Environment (SANE) comparison operator.

Available in Mac OS X v10.0 and later.
typeSMFloat

SANE single.

Available in Mac OS X v10.0 and later.
typeShortFloat

SANE single.

Available in Mac OS X v10.0 and later.
typeFloat

SANE double.

Available in Mac OS X v10.0 and later.
typeLongFloat

SANE double.

Available in Mac OS X v10.0 and later.
typeExtended

SANE extended.

Available in Mac OS X v10.0 and later.*/
enum {
   typeSMInt = 'shor',
   typeShortInteger = 'shor',
   typeInteger = 'long',
   typeLongInteger = 'long',
   typeMagnitude = 'magn',
   typeComp = 'comp',
   typeSMFloat = 'sing',
   typeShortFloat = 'sing',
   typeFloat = 'doub',
   typeLongFloat = 'doub',
   typeExtended = 'exte'
};


/*Descriptor Type Constants

Specify types for descriptors.

enum {
   typeAEList = 'list',
   typeAERecord = 'reco',
   typeAppleEvent = 'aevt',
   typeEventRecord = 'evrc',
   typeTrue = 'true',
   typeFalse = 'fals',
   typeAlias = 'alis',
   typeEnumerated = 'enum',
   typeType = 'type',
   typeAppParameters = 'appa',
   typeProperty = 'prop',
   typeFSS = 'fss ',
   typeFSRef = 'fsrf',
   typeFileURL = 'furl',
   typeKeyword = 'keyw',
   typeSectionH = 'sect',
   typeWildCard = '****',
   typeApplSignature = 'sign',
   typeQDRectangle = 'qdrt',
   typeFixed = 'fixd',
   typeProcessSerialNumber = 'psn ',
   typeApplicationURL = 'aprl',
   typeNull = 'null'
};
Constants
typeAEList

List of descriptors.

Available in Mac OS X v10.0 and later.
typeAERecord

List of keyword-specified descriptors.

Available in Mac OS X v10.0 and later.
typeAppleEvent

Apple event.

Available in Mac OS X v10.0 and later.
typeTrue

TRUE Boolean value.

Available in Mac OS X v10.0 and later.
typeFalse

FALSE Boolean value.

Available in Mac OS X v10.0 and later.
typeAlias

Alias.

Available in Mac OS X v10.0 and later.
typeEnumerated

Enumerated data.

Available in Mac OS X v10.0 and later.
typeType

Four-character code for event class or event ID

Available in Mac OS X v10.0 and later.
typeAppParameters

Process Manager launch parameters.

Available in Mac OS X v10.0 and later.
typeProperty

Apple event object property.

Available in Mac OS X v10.0 and later.
typeFSS

File system specification. Deprecated in Mac OS X. Use file system references (typeFSRef) instead.

Available in Mac OS X v10.0 and later.
typeFSRef

File system reference. Use in preference to file system specifications (typeFSS).

Available in Mac OS X v10.0 and later.
typeFileURL

A file URL. A descriptor of this type doesn't represent a CFURL, it represents a C-string-style file path.

Available in Mac OS X v10.1 and later.
typeKeyword

Apple event keyword.

Available in Mac OS X v10.0 and later.
typeSectionH

Handle to a section record. (Deprecated.)

Available in Mac OS X v10.0 and later.
typeWildCard

Matches any type.

Available in Mac OS X v10.0 and later.
typeApplSignature

Application signature.

Available in Mac OS X v10.0 and later.
typeProcessSerialNumber

A process serial number. See also AEAddressDesc.

Available in Mac OS X v10.0 and later.
typeApplicationURL

For specifying an application by URL. See Discussion session below for format.

Available in Mac OS X v10.1 and later.
typeNull

A null data storage pointer. When resolving an object specifier, an object with a null storage pointer specifies the default container at the top of the container hierarchy.

Available in Mac OS X v10.0 and later.
Discussion

The constants described here specify the data type for a descriptor and show the kind of data stored in a descriptor with that type.

Descriptors are the building blocks used by the Apple Event Manager to construct Apple event attributes and parameters. A descriptor is a data structure of type AEDesc, which consists of data storage and a descriptor type that identifies the type of the data. A descriptor type is defined by the data type DescType. 

AppleScript defines descriptor type constants for a wide variety of common data types. For additional types, see “Numeric Descriptor Type Constants” and “Other Descriptor Type Constants”. For a complete listing, including data types such as units of length, weight, and volume, see the Apple Event Manager and Open Scripting Architecture header files.

For the constant typeApplicationURL, the data that specifies the application URL takes the following format:eppc://[username[:password]@]host/AppName[[?uid=#]&[pid=#]]


As indicated by this format:
username is optional. If present, an '@' must appear before the host name. password is optional. If present, username is not optional, and the password must be separated from the username by a ':' and must precede the '@'. AppName is not optional; if it contains non-UTF-8 characters or white space, it must be URL-encoded (for example, My%20Application).
uid and pid are optional. If pid is present, uid and AppName are ignored and the event is delivered only to applications with the given process id. If uid is present, events are directed to the application name owned by the given user id.

The following are examples of valid URLs:eppc://Steve%20Zellers:wombat@grrr.apple.com/Microsoft%20Word
eppc://Steve%20Zellers:wombat@grrr.apple.com/Microsoft%20Word?pid=1284
AEDatamodel.h*/
enum {
   typeAEList = 'list',
   typeAERecord = 'reco',
   typeAppleEvent = 'aevt',
   typeEventRecord = 'evrc',
   typeTrue = 'true',
   typeFalse = 'fals',
   typeAlias = 'alis',
   typeEnumerated = 'enum',
   typeType = 'type',
   typeAppParameters = 'appa',
   typeProperty = 'prop',
   typeFSS = 'fss ',
   typeFSRef = 'fsrf',
   typeFileURL = 'furl',
   typeKeyword = 'keyw',
   typeSectionH = 'sect',
   typeWildCard = '****',
   typeApplSignature = 'sign',
   typeQDRectangle = 'qdrt',
   typeFixed = 'fixd',
   typeProcessSerialNumber = 'psn ',
   typeApplicationURL = 'aprl',
   typeNull = 'null'
};

/*AETransactionID

Specifies a transaction ID.

typedef SInt32 AETransactionID;
Discussion

A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the client’s initial request for a service. When you call the AECreateAppleEvent function, you pass a value of type AETransactionID for the transactionID parameter. “ID Constants for the AECreateAppleEvent Function” lists the valid constant values for a variable or parameter of this type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt32 AETransactionID;

/*AEReturnID

Specifies a return ID for a created Apple event.

typedef SInt16 AEReturnID;
Discussion

When you call the AECreateAppleEvent function, you pass a value of type AEReturnID for the returnID parameter. “ID Constants for the AECreateAppleEvent Function” lists the valid constant values for a variable or parameter of this type. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef SInt16 AEReturnID;

/*AEDataStorage

A pointer to an opaque data type that provides storage for an AEDesc descriptor.

typedef AEStorageDataType * AEDataStorage;
Discussion

The Apple Event Manager defines the AEDataStorage data type to serve as a data storage field in the AEDesc structure. Your application doesn’t access the data pointed to by a data storage pointer directly. Rather, you work with the following functions:
AEGetDescDataSize
AEGetDescData
AEGetDescDataRange
AEReplaceDescData
Availability
Available in Mac OS X v10.0 and later.*/

typedef struct AEStorageDataType * AEDataStorage;

/*DescType

Specifies the type of the data stored in an AEDesc descriptor.

typedef ResType DescType;
Discussion

A DescType data type is a four-character code that stores a value that identifies the data in an AEDesc descriptor, the basic building block for all Apple events.

The descriptor type constants used by the Apple Event Manager are described in “Descriptor Type Constants” and “Key Form and Descriptor Type Object Specifier Constants”. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef ResType DescType;

/*AEDesc

Stores data and an accompanying descriptor type to form the basic building block of all Apple Events.

struct AEDesc {
   DescType descriptorType;
   AEDataStorage dataHandle;
};
typedef struct AEDesc AEDesc;
Fields
descriptorType

A four-character code of type DescType that indicates the type of data in the structure. See DescType.
dataHandle

An opaque storage type that points to the storage for the descriptor data. Your application doesn’t access this data directly—rather, it calls one of the functions AEGetDescDataSize, AEGetDescData, or AEReplaceDescData. See AEDataStorage.
Discussion

The Apple Event Manager uses one or more descriptors to construct Apple event attributes and parameters, object specifiers, tokens, and many other types of data it works with. (Token is defined in AEDisposeToken.) A descriptor consists of an opaque data storage container and a descriptor type that identifies the type of the data stored in the descriptor.

The descriptor type is a structure of type DescType, which in turn is of data type ResType—that is, a four-character code. “Descriptor Type Constants” lists the constants for the basic descriptor types used by the Apple Event Manager. For information about descriptor types used with object specifiers, see “Key Form and Descriptor Type Object Specifier Constants”. 
Version Notes

Prior to Carbon, the AEDataStorage data type was defined as follows:typedef Handle AEDataStorage;

Availability
Available in Mac OS X v10.0 and later.*/
struct AEDesc {
   DescType descriptorType;
   AEDataStorage dataHandle;
};
typedef struct AEDesc AEDesc;


/*AEAddressDesc

A descriptor that contains the address of an application. Typically used to describe the target application for an Apple event.

typedef AEDesc AEAddressDesc;
Discussion

An address descriptor is identical to a descriptor of data type AEDesc; however, the data for an address descriptor must always consist of the address of an application.

Every Apple event includes an attribute specifying the address of the target application. The address in an address descriptor can be specified as one of these types (or as any other descriptor type you define that can be coerced to one of these types): typeApplSignature, typeSessionID, or typeProcessSerialNumber. These constants are described in “Descriptor Type Constants”. You can also use typeApplicationBundleID.

If your application sends Apple events to itself using a typeProcessSerialNumber address descriptor with the lowLongOfPSN field set to kCurrentProcess (and the highLongOfPSN field set to 0), the Apple Event Manager jumps directly to the appropriate Apple event handler without going through the normal event-processing sequence. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef AEDesc AEAddressDesc;

/*AESendMode

Specify send preferences to the AESend function.

typedef SInt32 AESendMode;
enum {
   kAENoReply = 0x00000001,
   kAEQueueReply = 0x00000002,
   kAEWaitReply = 0x00000003,
   kAEDontReconnect = 0x00000080,
   kAEWantReceipt = 0x00000200,
   kAENeverInteract = 0x00000010,
   kAECanInteract = 0x00000020,
   kAEAlwaysInteract = 0x00000030,
   kAECanSwitchLayer = 0x00000040,
   kAEDontRecord = 0x00001000,
   kAEDontExecute = 0x00002000,
   kAEProcessNonReplyEvents = 0x00008000
};
Constants
kAENoReply

The reply preference—your application does not want a reply Apple event. If you set the bit specified by this constant, the server processes the Apple event as soon as it has the opportunity.

Available in Mac OS X v10.0 and later.
kAEQueueReply

The reply preference—your application wants a reply Apple event. If you set the bit specified by this constant, the reply appears in your event queue as soon as the server has the opportunity to process and respond to your Apple event.

Available in Mac OS X v10.0 and later.
kAEWaitReply

The reply preference—your application wants a reply Apple event and is willing to give up the processor while waiting for the reply. For example, if the server application is on the same computer as your application, your application yields the processor to allow the server to respond to your Apple event.

If you set the bit specified by this constant, you must provide an idle function. This function should process any update events, null events, operating-system events, or activate events that occur while your application is waiting for a reply. For more information on idle routines, see AEInteractWithUser.

Available in Mac OS X v10.0 and later.
kAEDontReconnect

Deprecated and unsupported in Mac OS X. The reconnection preference—the Apple Event Manager must not automatically try to reconnect if it receives a sessClosedErr result code from the PPC Toolbox. If you don’t set this flag, the Apple Event Manager automatically attempts to reconnect and reestablish the session.

Available in Mac OS X v10.0 and later.
kAEWantReceipt

Deprecated and unsupported in Mac OS X. The return receipt preference—the sender wants to receive a return receipt for this Apple event from the Event Manager. (A return receipt means only that the receiving application accepted the Apple event the Apple event may or may not be handled successfully after it is accepted.) If the receiving application does not send a return receipt before the request times out, AESend returns errAETimeout as its function result.

Available in Mac OS X v10.0 and later.
kAENeverInteract

The user interaction preference—the server application should never interact with the user in response to the Apple event. If you set the bit specified by this constant, the AEInteractWithUser function (when called by the server) returns the errAENoUserInteraction result code. When you send an Apple event to a remote application, the default is to set this bit.

Available in Mac OS X v10.0 and later.
kAECanInteract

The user interaction preference—the server application can interact with the user in response to the Apple event. By convention, you set the bit specified by this constant if the user needs to supply information to the server. If you set the bit and the server allows interaction, the AEInteractWithUser function either brings the server application to the foreground or posts a notification request. When you send an Apple event to a local application, the default is to set this bit.

Available in Mac OS X v10.0 and later.
kAEAlwaysInteract

The user interaction preference—the server application should always interact with the user in response to the Apple event. By convention, you set the bit specified by this constant whenever the server application normally asks a user to confirm a decision or interact in any other way, even if no additional information is needed from the user. If you set the bit specified by this constant, the AEInteractWithUser function either brings the server application to the foreground or posts a notification request.

Available in Mac OS X v10.0 and later.
kAECanSwitchLayer

The application switch preference—if both the client and server allow interaction, and if the client application is the active application on the local computer and is waiting for a reply (that is, it has set the kAEWaitReply flag), AEInteractWithUser brings the server directly to the foreground. Otherwise, AEInteractWithUser uses the Notification Manager to request that the user bring the server application to the foreground.

You should specify the kAECanSwitchLayer flag only when the client and server applications reside on the same computer. In general, you should not set this flag if it would be confusing or inconvenient to the user for the server application to come to the front unexpectedly. This flag is ignored if you are sending an Apple event to a remote computer.

Available in Mac OS X v10.0 and later.
kAEDontRecord

The recording preference—your application is sending an event to itself but does not want the event recorded. When Apple event recording is on, the Apple Event Manager records a copy of every event your application sends to itself except for those events for which this flag is set.

Available in Mac OS X v10.0 and later.
kAEDontExecute

The execution preference—your application is sending an Apple event to itself for recording purposes only—that is, you want the Apple Event Manager to send a copy of the event to the recording process but you do not want your application actually to receive the event.

Available in Mac OS X v10.0 and later.
kAEProcessNonReplyEvents

Allow processing of non-reply Apple events while awaiting a synchronous Apple event reply (you specified kAEWaitReply for the reply preference).

Available in Mac OS X v10.0 and later.
Discussion

You use these constants with the sendMode parameter to the AESend function to specify how the server application should handle the reply mode, the interaction level, the application switch mode, the reconnection mode, the return receipt mode, the recording mode, and whether to process non-reply Apple events. To obtain a value for this parameter, you add together constants to set the appropriate bits for the Apple event you are about to send. The following paragraphs provide additional information about how you use these constants.

You can set only one flag reply preference (kAENoReply, kAEQueueReply, or kAEWaitReply), one user interaction preference (kAENeverInteract, kAECanInteract, or kAEAlwaysInteract), and one recording and execution preference (kAEDontRecord or kAEDontExecute). 

Before the Apple Event Manager sends a reply event back to the client application, the keyAddressAttr attribute contains the address of the client application. After the client receives the reply event, the keyAddressAttr attribute contains the address of the server application.

If you specify kAEWaitReply, the Apple Event Manager uses the Event Manager to send the event. The Apple Event Manager then calls the WaitNextEvent function on behalf of your application, causing your application to yield the processor and giving the server application a chance to receive and handle the Apple event. Your application continues to yield the processor until the server handles the Apple event or the request times out.

Specify the kAEWantReceipt flag if your application wants notification that the server application has accepted the Apple event. If you specify this flag, your application receives a return receipt as a high-level event.

If you specify the kAEWantReceipt flag and the server application does not accept the Apple event within the time specified by the timeOutInTicks parameter to AESend, the AESend function returns a timeout error. Note that AESend also returns a timeout error if your application sets the kAEWaitReply flag and does not receive the reply Apple event within the time specified by the timeOutInTicks parameter.

You use one of the three flags—kAENeverInteract, kAECanInteract, and kAEAlwaysInteract—to specify whether the server should interact with the user when handling the Apple event. Specify kAENeverInteract if the server should not interact with the user when handling the Apple event. You might specify this constant if you don’t want the user to be interrupted while the server is handling the Apple event.

Use the kAECanInteract flag if the server should interact with the user when the user needs to supply information to the server. Use the kAEAlwaysInteract flag if the server should interact with the user whenever the server normally asks a user to confirm a decision or interact in any other way, even if no additional information is needed from the user. Note that it is the responsibility of the server and client applications to agree on how to interpret the kAEAlwaysInteract flag. 

If the client application does not set any one of the user interaction flags, the Apple Event Manager sets a default, depending on tAESendMode

Specify send preferences to the AESend function.

typedef SInt32 AESendMode;
enum {
   kAENoReply = 0x00000001,
   kAEQueueReply = 0x00000002,
   kAEWaitReply = 0x00000003,
   kAEDontReconnect = 0x00000080,
   kAEWantReceipt = 0x00000200,
   kAENeverInteract = 0x00000010,
   kAECanInteract = 0x00000020,
   kAEAlwaysInteract = 0x00000030,
   kAECanSwitchLayer = 0x00000040,
   kAEDontRecord = 0x00001000,
   kAEDontExecute = 0x00002000,
   kAEProcessNonReplyEvents = 0x00008000
};
Constants
kAENoReply

The reply preference—your application does not want a reply Apple event. If you set the bit specified by this constant, the server processes the Apple event as soon as it has the opportunity.

Available in Mac OS X v10.0 and later.
kAEQueueReply

The reply preference—your application wants a reply Apple event. If you set the bit specified by this constant, the reply appears in your event queue as soon as the server has the opportunity to process and respond to your Apple event.

Available in Mac OS X v10.0 and later.
kAEWaitReply

The reply preference—your application wants a reply Apple event and is willing to give up the processor while waiting for the reply. For example, if the server application is on the same computer as your application, your application yields the processor to allow the server to respond to your Apple event.

If you set the bit specified by this constant, you must provide an idle function. This function should process any update events, null events, operating-system events, or activate events that occur while your application is waiting for a reply. For more information on idle routines, see AEInteractWithUser.

Available in Mac OS X v10.0 and later.
kAEDontReconnect

Deprecated and unsupported in Mac OS X. The reconnection preference—the Apple Event Manager must not automatically try to reconnect if it receives a sessClosedErr result code from the PPC Toolbox. If you don’t set this flag, the Apple Event Manager automatically attempts to reconnect and reestablish the session.

Available in Mac OS X v10.0 and later.
kAEWantReceipt

Deprecated and unsupported in Mac OS X. The return receipt preference—the sender wants to receive a return receipt for this Apple event from the Event Manager. (A return receipt means only that the receiving application accepted the Apple event the Apple event may or may not be handled successfully after it is accepted.) If the receiving application does not send a return receipt before the request times out, AESend returns errAETimeout as its function result.

Available in Mac OS X v10.0 and later.
kAENeverInteract

The user interaction preference—the server application should never interact with the user in response to the Apple event. If you set the bit specified by this constant, the AEInteractWithUser function (when called by the server) returns the errAENoUserInteraction result code. When you send an Apple event to a remote application, the default is to set this bit.

Available in Mac OS X v10.0 and later.
kAECanInteract

The user interaction preference—the server application can interact with the user in response to the Apple event. By convention, you set the bit specified by this constant if the user needs to supply information to the server. If you set the bit and the server allows interaction, the AEInteractWithUser function either brings the server application to the foreground or posts a notification request. When you send an Apple event to a local application, the default is to set this bit.

Available in Mac OS X v10.0 and later.
kAEAlwaysInteract

The user interaction preference—the server application should always interact with the user in response to the Apple event. By convention, you set the bit specified by this constant whenever the server application normally asks a user to confirm a decision or interact in any other way, even if no additional information is needed from the user. If you set the bit specified by this constant, the AEInteractWithUser function either brings the server application to the foreground or posts a notification request.

Available in Mac OS X v10.0 and later.
kAECanSwitchLayer

The application switch preference—if both the client and server allow interaction, and if the client application is the active application on the local computer and is waiting for a reply (that is, it has set the kAEWaitReply flag), AEInteractWithUser brings the server directly to the foreground. Otherwise, AEInteractWithUser uses the Notification Manager to request that the user bring the server application to the foreground.

You should specify the kAECanSwitchLayer flag only when the client and server applications reside on the same computer. In general, you should not set this flag if it would be confusing or inconvenient to the user for the server application to come to the front unexpectedly. This flag is ignored if you are sending an Apple event to a remote computer.

Available in Mac OS X v10.0 and later.
kAEDontRecord

The recording preference—your application is sending an event to itself but does not want the event recorded. When Apple event recording is on, the Apple Event Manager records a copy of every event your application sends to itself except for those events for which this flag is set.

Available in Mac OS X v10.0 and later.
kAEDontExecute

The execution preference—your application is sending an Apple event to itself for recording purposes only—that is, you want the Apple Event Manager to send a copy of the event to the recording process but you do not want your application actually to receive the event.

Available in Mac OS X v10.0 and later.
kAEProcessNonReplyEvents

Allow processing of non-reply Apple events while awaiting a synchronous Apple event reply (you specified kAEWaitReply for the reply preference).

Available in Mac OS X v10.0 and later.
Discussion

You use these constants with the sendMode parameter to the AESend function to specify how the server application should handle the reply mode, the interaction level, the application switch mode, the reconnection mode, the return receipt mode, the recording mode, and whether to process non-reply Apple events. To obtain a value for this parameter, you add together constants to set the appropriate bits for the Apple event you are about to send. The following paragraphs provide additional information about how you use these constants.

You can set only one flag reply preference (kAENoReply, kAEQueueReply, or kAEWaitReply), one user interaction preference (kAENeverInteract, kAECanInteract, or kAEAlwaysInteract), and one recording and execution preference (kAEDontRecord or kAEDontExecute). 

Before the Apple Event Manager sends a reply event back to the client application, the keyAddressAttr attribute contains the address of the client application. After the client receives the reply event, the keyAddressAttr attribute contains the address of the server application.

If you specify kAEWaitReply, the Apple Event Manager uses the Event Manager to send the event. The Apple Event Manager then calls the WaitNextEvent function on behalf of your application, causing your application to yield the processor and giving the server application a chance to receive and handle the Apple event. Your application continues to yield the processor until the server handles the Apple event or the request times out.

Specify the kAEWantReceipt flag if your application wants notification that the server application has accepted the Apple event. If you specify this flag, your application receives a return receipt as a high-level event.

If you specify the kAEWantReceipt flag and the server application does not accept the Apple event within the time specified by the timeOutInTicks parameter to AESend, the AESend function returns a timeout error. Note that AESend also returns a timeout error if your application sets the kAEWaitReply flag and does not receive the reply Apple event within the time specified by the timeOutInTicks parameter.

You use one of the three flags—kAENeverInteract, kAECanInteract, and kAEAlwaysInteract—to specify whether the server should interact with the user when handling the Apple event. Specify kAENeverInteract if the server should not interact with the user when handling the Apple event. You might specify this constant if you don’t want the user to be interrupted while the server is handling the Apple event.

Use the kAECanInteract flag if the server should interact with the user when the user needs to supply information to the server. Use the kAEAlwaysInteract flag if the server should interact with the user whenever the server normally asks a user to confirm a decision or interact in any other way, even if no additional information is needed from the user. Note that it is the responsibility of the server and client applications to agree on how to interpret the kAEAlwaysInteract flag. 

If the client application does not set any one of the user interaction flags, the Apple Event Manager sets a default, depending on the location of the target of the Apple event. If the server application is on a remote computer, the Apple Event Manager sets the kAENeverInteract flag as the default. If the target of the Apple event is on the local computer, the Apple Event Manager sets the kAECanInteract flag as the default.

The server application should call AEInteractWithUser if it needs to interact with the user. If both the client and the server allow user interaction, the Apple Event Manager attempts to bring the server to the foreground if it is not already the foreground process. If both the kAECanSwitchLayer and the kAEWaitReply flags are set, and if the client application is the active application on the local computer, the Apple Event Manager brings the server application directly to the front. Otherwise, the Apple Event Manager posts a notification request asking the user to bring the server application to the front, regardless of whether the kAECanSwitchLayer flag is set. This ensures that the user will not be interrupted by an unexpected application switch. 

Specify the kAEDontRecord flag if your application is sending an Apple event to itself that you don’t want to be recorded. When Apple event recording has been turned on, every event that your application sends to itself will be automatically recorded by the Apple Event Manager except those sent with the kAEDontRecord flag set.

Specify the kAEDontExecute flag if your application is sending an Apple event to itself for recording purposes only—that is, if you want the Apple Event Manager to send a copy of the event to the recording process but you do not want your application actually to receive the event.

See also “Requesting User Interaction”.
Version Notes

The kAEDontReconnect and kAEWantReceipt constants are deprecated and unsupported in Mac OS X.he location of the target of the Apple event. If the server application is on a remote computer, the Apple Event Manager sets the kAENeverInteract flag as the default. If the target of the Apple event is on the local computer, the Apple Event Manager sets the kAECanInteract flag as the default.

The server application should call AEInteractWithUser if it needs to interact with the user. If both the client and the server allow user interaction, the Apple Event Manager attempts to bring the server to the foreground if it is not already the foreground process. If both the kAECanSwitchLayer and the kAEWaitReply flags are set, and if the client application is the active application on the local computer, the Apple Event Manager brings the server application directly to the front. Otherwise, the Apple Event Manager posts a notification request asking the user to bring the server application to the front, regardless of whether the kAECanSwitchLayer flag is set. This ensures that the user will not be interrupted by an unexpected application switch. 

Specify the kAEDontRecord flag if your application is sending an Apple event to itself that you don’t want to be recorded. When Apple event recording has been turned on, every event that your application sends to itself will be automatically recorded by the Apple Event Manager except those sent with the kAEDontRecord flag set.

Specify the kAEDontExecute flag if your application is sending an Apple event to itself for recording purposes only—that is, if you want the Apple Event Manager to send a copy of the event to the recording process but you do not want your application actually to receive the event.

See also “Requesting User Interaction”.
Version Notes

The kAEDontReconnect and kAEWantReceipt constants are deprecated and unsupported in Mac OS X.*/

typedef SInt32 AESendMode;
enum {
   kAENoReply = 0x00000001,
   kAEQueueReply = 0x00000002,
   kAEWaitReply = 0x00000003,
   kAEDontReconnect = 0x00000080,
   kAEWantReceipt = 0x00000200,
   kAENeverInteract = 0x00000010,
   kAECanInteract = 0x00000020,
   kAEAlwaysInteract = 0x00000030,
   kAECanSwitchLayer = 0x00000040,
   kAEDontRecord = 0x00001000,
   kAEDontExecute = 0x00002000,
   kAEProcessNonReplyEvents = 0x00008000
};



/*Other Descriptor Type Constants

Specify types for Boolean and character descriptors.

enum {
   typeBoolean = 'bool',
   typeChar = 'TEXT'
};
Constants
typeBoolean

Boolean value—single byte with value 0 or 1.

Available in Mac OS X v10.0 and later.
typeChar

Unterminated string of system script characters.

See the Version Notes section below for important information.

Available in Mac OS X v10.0 and later.
Discussion

The constants described here specify the data type for a descriptor and show the kind of data stored in a descriptor with that type.

Descriptors are the building blocks used by the Apple Event Manager to construct Apple event attributes and parameters. A descriptor is a data structure of type AEDesc, which consists of data storage and a descriptor type that identifies the type of the data. A descriptor type is defined by the data type DescType. 

AppleScript defines descriptor type constants for a wide variety of common data types. For additional types, see “Descriptor Type Constants” and “Numeric Descriptor Type Constants”. For a complete listing, including data types such as units of length, weight, and volume, see the Apple Event Manager and Open Scripting Architecture header files.
Version Notes

On Mac OS X typeChar type is deprecated in favor of typeUTF8Text or typeUTF16ExternalRepresentation. For more information, see typeUTF16ExternalRepresentation.
AEDataModel.h*/
enum {
   typeBoolean = 'bool',
   typeChar = 'TEXT'
};


/*ID Constants for the AECreateAppleEvent Function

Specify values for the ID parameters of the AECreateAppleEvent function.

enum {
   kAutoGenerateReturnID = -1,
   kAnyTransactionID = 0
};
Constants
kAutoGenerateReturnID

If you pass this value for the returnID parameter of the AECreateAppleEvent function, the Apple Event Manager assigns to the created Apple event a return ID that is unique to the current session.

Available in Mac OS X v10.0 and later.
kAnyTransactionID

You pass this value for the transactionID parameter of the AECreateAppleEvent function if the Apple event is not one of a series of interdependent Apple events.

A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the client’s initial request for a service. All Apple events that are part of a transaction must have the same transaction ID.

Available in Mac OS X v10.0 and later.
Discussion

You use these constants with the AECreateAppleEvent function.
AEDataModel.h*/
enum {
   kAutoGenerateReturnID = -1,
   kAnyTransactionID = 0
};

/*DescType

Specifies the type of the data stored in an AEDesc descriptor.

typedef ResType DescType;
Discussion

A DescType data type is a four-character code that stores a value that identifies the data in an AEDesc descriptor, the basic building block for all Apple events.

The descriptor type constants used by the Apple Event Manager are described in “Descriptor Type Constants” and “Key Form and Descriptor Type Object Specifier Constants”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef ResType DescType;



/*AEDescList

A descriptor whose data consists of a list of one or more descriptors.

typedef AEDesc AEDescList;
Discussion

A descriptor list is identical to a descriptor of data type AEDesc ?the only difference is that the data in a descriptor list must always consist of a list of other descriptors.

Descriptor lists are a key building block of Apple events. Many Apple Event Manager functions take or return lists of descriptors in descriptor lists. For example, see the functions described in Counting the Items in Descriptor Lists and Getting Items From Descriptor Lists.

The format of the data in the dataHandle of the descriptor is private. You can only operate on the contained elements with Apple Event Manager functions, including those described in Counting the Items in Descriptor Lists and Getting Items From Descriptor Lists. 
Availability
Available in Mac OS X v10.0 and later.
AEDaraModel.h*/
typedef AEDesc AEDescList;



/*AERecord

A descriptor whose data is a list of keyword-specified descriptors.

typedef AEDescList AERecord;
Discussion

The Apple Event Manager provides routines that allow your application to create Apple event records and extract data from them when creating or responding to Apple events. You also work with Apple event records if your application resolves or creates object specifiers. Functions that use Apple event records are described in “Getting Data or Descriptors From Apple Events” and “Adding Parameters and Attributes to an Apple Event”. 

The descriptor list of keyword-specified descriptors in an Apple event record must specify Apple event parameters—they cannot specify Apple event attributes. Only descriptor lists of type Apple event can contain both attributes and parameters.
Availability
Available in Mac OS X v10.0 and later.*/
typedef AEDescList AERecord;


/*AppleEvent

A descriptor whose data is a list of descriptors containing both attributes and parameters that make up an Apple event.

typedef AERecord AppleEvent;
Discussion

The Apple event data type describes a full-fledged Apple event. Like the data for an Apple event record (data type AERecord), the data for an Apple event consists of a list of keyword-specified descriptors. Unlike an Apple event record, the data for an Apple event is conceptually divided into two parts, one for attributes and one for parameters. This division within the Apple event allows the Apple Event Manager to distinguish between an event’s attributes and its parameters.

For additional information on the structure of an Apple event and on how to build one, see “Building an Apple Event” in Apple Events Programming Guide.

Many functions work with Apple events, including the functions described in “Getting Data or Descriptors From Apple Events”, “Adding Parameters and Attributes to an Apple Event”, “Creating an Apple Event”, and “Sending an Apple Event”. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef AERecord AppleEvent;


/*AEEventID

Specifies the event ID of an Apple event.

typedef FourCharCode AEEventID;
Discussion

Apple events are identified by their event class and event ID attributes. The event ID is the attribute that identifies a particular Apple event within its event class. In conjunction with the event class, the event ID uniquely identifies the Apple event and communicates what action the Apple event should perform.

For more information on Apple event IDs, see “Event ID Constants”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef FourCharCode AEEventID;






/*AEEventHandlerProcPtr

Defines a pointer to a function that handles one or more Apple events. Your Apple event handler function performs any action requested by the Apple event, adds parameters to the reply Apple event if appropriate (possibly including error information), and returns a result code.

typedef OSErr (*AEEventHandlerProcPtr)
(
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon
);

If you name your function MyAEEventHandlerCallback, you would declare it like this:

OSErr MyAEEventHandlerCallback (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon
);
Parameters
theAppleEvent

A pointer to the Apple event to handle. See AppleEvent.
reply

A pointer to the default reply Apple event provided by the Apple Event Manager. See AppleEvent. If no reply is expected, reply has descriptor type typeNull.
handlerRefcon

The reference constant stored in the Apple event dispatch table when you install the handler function for the Apple event. You can store any 32-bit value in the dispatch table and use it any way you want when the handler is called. The reference constant may have a value of NULL.
Return Value

A result code. See “Apple Event Manager Result Codes”. Your handler should always return noErr if it successfully handled the Apple event. If an error occurs, your handler should return either errAEEventNotHandled or some other nonzero result code. For more information, see the Discussion section.
Discussion

An Apple event handler should extract any parameters and attributes from the Apple event, perform the requested action, and add parameters to the reply Apple event if appropriate. You must provide an Apple event handler for each Apple event your application supports. The AEProcessAppleEvent function calls one of your Apple event handlers when it processes an Apple event.

If an error occurs because your application cannot understand the event, return errAEEventNotHandled, so that the Apple Event Manager may be able to find another handler to handle the event. If the error occurs because the event is impossible to handle as specified, return the result code returned by whatever function caused the failure, or whatever other result code is appropriate.

For example, suppose your application receives a kAEGetData event that requests the name of the current printer, and your application cannot handle such an event. In this situation, you should return errAEEventNotHandled so that another handler available to the Apple Event Manager can have a chance to handle the event. This strategy allows users to take advantage of system capabilities from within your application via system handlers.

If your Apple event handler calls the AEResolve function and AEResolve calls an object accessor function in the system object accessor dispatch table, your Apple event handler may not recognize the descriptor type of the token returned by the function. In this case, your handler should return the result code errAEUnknownObjectType. When your handler returns this result code, the Apple Event Manager attempts to locate a system Apple event handler that can recognize the token.

For additional information on dealing with error conditions, see OSLGetErrDescProcPtr.

To provide a pointer to your event handler callback function, you create a universal procedure pointer (UPP) of type AEEventHandlerUPP, using the function NewAEEventHandlerUPP. You can do so with code like the following:AEEventHandlerUPP MyEventHandlerUPP;
MyEventHandlerUPP = NewAEEventHandlerUPP (&MyEventHandlerCallback)


You can then pass the UPP MyEventHandlerUPP as a parameter to any function that installs or removes a handler, such as AEInstallEventHandler. If your application installs the same event handler to handle more than one kind of event (more than one pair of event class and event ID), you can use the same UPP to install the handler multiple times.

If you wish to call your event handler callback function directly, you can use the InvokeAEEventHandlerUPP function.

After you are finished with an event handler callback function, and have removed it with the AERemoveEventHandler function, you can dispose of the UPP with the DisposeAEEventHandlerUPP function. However, don’t dispose of the UPP if any remaining handler uses it or if you plan to install the handler again. 
Version Notes

Your application should not install a handler in a system dispatch table with the goal that the handler will get called when other applications receive an Apple event—this won’t work in Mac OS X. For more information, see “The System Dispatch Table” in “Apple Event Dispatching” in Apple Events Programming Guide.
AEDataModel.h*/
typedef OSErr (*AEEventHandlerProcPtr)
(
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon
);


/*AppleEvent

A descriptor whose data is a list of descriptors containing both attributes and parameters that make up an Apple event.

typedef AERecord AppleEvent;
Discussion

The Apple event data type describes a full-fledged Apple event. Like the data for an Apple event record (data type AERecord), the data for an Apple event consists of a list of keyword-specified descriptors. Unlike an Apple event record, the data for an Apple event is conceptually divided into two parts, one for attributes and one for parameters. This division within the Apple event allows the Apple Event Manager to distinguish between an events attributes and its parameters.

For additional information on the structure of an Apple event and on how to build one, see Building an Apple Event in Apple Events Programming Guide.

Many functions work with Apple events, including the functions described in Getting Data or Descriptors From Apple Events, Adding Parameters and Attributes to an Apple Event, Creating an Apple Event, and Sending an Apple Event. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef AERecord AppleEvent;


/*AEEventHandlerUPP

Defines a data type for the universal procedure pointer for the AEEventHandlerUPP callback function pointer.

typedef AEEventHandlerProcPtr AEEventHandlerUPP;
Discussion

For a description of an event handler callback function, see AEEventHandlerProcPtr.
AEDataModel.h*/
typedef AEEventHandlerProcPtr AEEventHandlerUPP;


/*AppleEvent

A descriptor whose data is a list of descriptors containing both attributes and parameters that make up an Apple event.

typedef AERecord AppleEvent;
Discussion

The Apple event data type describes a full-fledged Apple event. Like the data for an Apple event record (data type AERecord), the data for an Apple event consists of a list of keyword-specified descriptors. Unlike an Apple event record, the data for an Apple event is conceptually divided into two parts, one for attributes and one for parameters. This division within the Apple event allows the Apple Event Manager to distinguish between an event’s attributes and its parameters.

For additional information on the structure of an Apple event and on how to build one, see “Building an Apple Event” in Apple Events Programming Guide.

Many functions work with Apple events, including the functions described in “Getting Data or Descriptors From Apple Events”, “Adding Parameters and Attributes to an Apple Event”, “Creating an Apple Event”, and “Sending an Apple Event”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef AERecord AppleEvent;



/*AERecord

A descriptor whose data is a list of keyword-specified descriptors.

typedef AEDescList AERecord;
Discussion

The Apple Event Manager provides routines that allow your application to create Apple event records and extract data from them when creating or responding to Apple events. You also work with Apple event records if your application resolves or creates object specifiers. Functions that use Apple event records are described in Getting Data or Descriptors From Apple Events and Adding Parameters and Attributes to an Apple Event. 

The descriptor list of keyword-specified descriptors in an Apple event record must specify Apple event parameters?they cannot specify Apple event attributes. Only descriptor lists of type Apple event can contain both attributes and parameters.
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef AEDescList AERecord;




/*AEEventClass

Specifies the event class of an Apple event.

typedef FourCharCode AEEventClass;
Discussion

Apple events are identified by their event class and event ID attributes. The event class is the attribute that identifies a group of related Apple events. When you call the AEProcessAppleEvent function, the Apple Event Manager uses these attributes to identify a handler for a specific Apple event.

For more information on Apple event classes, see “Event Class Constants”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef FourCharCode AEEventClass;


/*AEKeyword

A four-character code that uniquely identifies a descriptor in an Apple event record or an Apple event.

typedef FourCharCode AEKeyword;
Discussion

The Apple Event Manager uniquely identifies the various parts of an Apple event by means of keywords associated with corresponding descriptors. Keywords are arbitrary names, stored as four-character codes of type AEKeyword. A keyword combined with a descriptor forms a keyword-specified descriptor, which is defined by a data structure of type AERemoteProcessResolverContext.

The Apple Event Manager also uses keywords for Apple event attributes. Keyword constants used by the Apple Event Manager are defined in “Keyword Attribute Constants” and “Keyword Parameter Constants”. 
Availability
Available in Mac OS X v10.0 and later.
AEDataModel.h*/
typedef FourCharCode AEKeyword;

/*AECoercePtrProcPtr

Defines a pointer to a function that coerces data stored in a buffer. Your pointer coercion callback routine coerces the data from the passed buffer to the specified type, returning the coerced data in a descriptor.

typedef OSErr (*AECoercePtrProcPtr) (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   DescType toType,
   long handlerRefcon,
   AEDesc * result
);

If you name your function MyAECoercePtrCallback, you would declare it like this:

OSErr MyAECoercePtrCallback (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   DescType toType,
   long handlerRefcon,
   AEDesc * result
);
Parameters
typeCode

The descriptor type of the original data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data to coerce.
dataSize

The length, in bytes, of the data to coerce.
toType

The desired descriptor type for the resulting descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
handlerRefcon

A reference constant that is stored in the coercion dispatch table entry for the handler. The Apple Event Manager passes this value to the handler each time it calls it. The reference constant may have a value of NULL.
result

A pointer to a descriptor where your coercion routine must store the descriptor that contains the coerced data. If your routine cannot coerce the data, return a null descriptor. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”. Your handler should return noErr if it successfully handled the coercion, errAECoercionFailed if it can’t handle the coercion and it wants the Apple Event Manager to continue dispatching to other coercion handlers, or a nonzero result code otherwise.
Discussion

To provide a pointer to your coercion callback function, you create a universal procedure pointer (UPP) of type AECoercePtrUPP, using the function NewAECoercePtrUPP. You can do so with code like the following:AECoercePtrUPP MyCoercePtrUPP;
MyCoercePtrUPP = NewAECoercePtrUPP (&MyCoercePtrCallback)


You can then pass the UPP MyCoercePtrUPP as a parameter to any function that installs or removes a coercion handler, such as AEInstallCoercionHandler. If your application installs the same coercion handler to coerce more than one type of data, you can use the same UPP to install the handler multiple times.

If you wish to call your coercion callback function directly, you can use the InvokeAECoercePtrUPP function.

After you are finished with a coercion callback function, and have removed it with the AERemoveCoercionHandler function, you can dispose of the UPP with the DisposeAECoercePtrUPP function. However, don’t dispose of the UPP if any remaining coercion handler uses it or if you plan to install the coercion handler again.*/
typedef OSErr (*AECoercePtrProcPtr) (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   DescType toType,
   long handlerRefcon,
   AEDesc * result
);


/*AECoercePtrUPP

Defines a data type for the universal procedure pointer for the AECoercePtrProcPtr callback function pointer.

typedef AECoercePtrProcPtr AECoercePtrUPP;
Discussion

For a description of a coerce pointer callback function, see AECoercePtrProcPtr.*/
typedef AECoercePtrProcPtr AECoercePtrUPP;

/*AECoerceDescProcPtr

Defines a pointer to a function that coerces data stored in a descriptor. Your descriptor coercion callback function coerces the data from the passed descriptor to the specified type, returning the coerced data in a second descriptor.

typedef OSErr (*AECoerceDescProcPtr)
(
   const AEDesc * fromDesc,
   DescType toType,
   long handlerRefcon,
   AEDesc * toDesc
);

If you name your function MyAECoerceDescCallback, you would declare it like this:

OSErr MyAECoerceDescCallback (
   const AEDesc * fromDesc,
   DescType toType,
   long handlerRefcon,
   AEDesc * toDesc
);
Parameters
fromDesc

A pointer to the descriptor that contains the data to coerce. See AEDesc.
toType

The desired descriptor type for the resulting descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
handlerRefcon

A reference constant that is stored in the coercion dispatch table entry for the handler. The Apple Event Manager passes this value to the handler each time it calls it. The reference constant may have a value of 0.
toDesc

A pointer to a descriptor where your coercion routine must store the descriptor that contains the coerced data. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”. Your handler should return noErr if it successfully handled the coercion, errAECoercionFailed if it can’t handle the coercion and it wants the Apple Event Manager to continue dispatching to other coercion handlers, or a nonzero result code otherwise.
Discussion

Your coercion handler should coerce the data to the desired descriptor type and return the resulting data in the descriptor specified by the result parameter.

To provide a pointer to your descriptor coercion callback function, you create a universal procedure pointer (UPP) of type AECoerceDescUPP, using the function NewAECoerceDescUPP. You can do so with code like the following:AECoerceDescUPP MyCoerceDescUPP;
MyCoerceDescUPP = NewAECoerceDescUPP (&MyCoerceDescCallback)


You can then pass the UPP MyCoerceDescUPP as a parameter to any function that installs or removes a coercion handler, such as AEInstallCoercionHandler. If your application installs the same coercion handler to coerce more than one type of data, you can use the same UPP to install the handler multiple times.

If you wish to call your descriptor coercion callback function directly, you can use the InvokeAECoerceDescUPP function.

After you are finished with a descriptor coercion callback function, and have removed it with the AERemoveCoercionHandler function, you can dispose of the UPP with the DisposeAECoerceDescUPP function. However, don’t dispose of the UPP if any remaining coercion handler uses it or if you plan to install the coercion handler again.*/
typedef OSErr (*AECoerceDescProcPtr)
(
   const AEDesc * fromDesc,
   DescType toType,
   long handlerRefcon,
   AEDesc * toDesc
);

/*AECoerceDescUPP

Defines a data type for the universal procedure pointer for the AECoerceDescProcPtr callback function pointer.

typedef AECoerceDescProcPtr AECoerceDescUPP;
Discussion

For a description of a coerce descriptor callback function, see AECoerceDescProcPtr.*/
typedef AECoerceDescProcPtr AECoerceDescUPP;

/*AECoercionHandlerUPP

Defines a data type for the universal procedure pointer for the AECoercionHandlerUPP callback function pointer.

typedef AECoerceDescUPP AECoercionHandlerUPP;
Discussion

For a description of a coercion handler callback function, see AECoercePtrProcPtr. 
Availability
Available in Mac OS X v10.0 and later.*/
typedef AECoerceDescUPP AECoercionHandlerUPP;

//function


/*AEDisposeDesc

Deallocates the memory used by a descriptor.

OSErr AEDisposeDesc (
   AEDesc * theAEDesc
);
Parameters
theAEDesc

A pointer to the descriptor to deallocate. On return, a null descriptor. If you pass a null descriptor in this parameter, AEDisposeDesc returns noErr. See AEDesc.
Return Value

A result code. See Apple Event Manager Result Codes. As currently implemented, AEDisposeDesc always returns noErr.
Discussion

The AEDisposeDesc function deallocates the memory used by a descriptor. After calling this method, the descriptor becomes an empty descriptor with a type of typeNULL. Because all Apple event structures (except for keyword-specified descriptors) are descriptors, you can use AEDisposeDesc for any of them.

Do not call AEDisposeDesc on a descriptor obtained from another Apple Event Manager function (such as the reply event from a call to AESend) unless that function returns successfully.
Special Considerations

If the AEDesc might contain an OSL token, dispose of it with AEDisposeToken.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
extern OSErr AEDisposeDesc (
   AEDesc * theAEDesc
);

/*AEGetParamDesc

Gets a copy of the descriptor for a keyword-specified Apple event parameter from an Apple event or an Apple event record (type AERecord); typically used when your application needs to pass the extracted data to another function as a descriptor. 

OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result
);
Parameters
theAppleEvent

A pointer to the Apple event to get the parameter descriptor from. See AppleEvent.
theAEKeyword

A keyword that specifies the desired Apple event parameter. Some keyword constants are described in “Keyword Parameter Constants”. See AEKeyword.
desiredType

The descriptor type for the desired Apple event parameter. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the requested Apple event parameter is not of the desired type, the Apple Event Manager attempts to coerce it to the desired type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the returned descriptor is the same as the descriptor type of the Apple event parameter.

See DescType.
result

A pointer to a descriptor. On successful return, a copy of the descriptor for the specified Apple event parameter, coerced, if necessary, to the descriptor type specified by the desiredType parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

To get Apple event parameter data for your application to use directly, call AEGetParamPtr. To get a descriptor for an Apple event parameter to pass on to another Apple Event Manager routine, call AEGetParamDesc.

If the actual parameter you are getting with AEGetParamDesc is a record, AEGetParamDesc will only allow you to request it as a typeAERecord, typeAEList, or typeWildcard. For any other type, it will return errAECoercionFail.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

extern OSErr AEGetParamDesc (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   AEDesc * result
);

/*NewAEEventHandlerUPP

Creates a new universal procedure pointer to an event handler function.

AEEventHandlerUPP NewAEEventHandlerUPP (
   AEEventHandlerProcPtr userRoutine
);
Return Value

See AEEventHandlerUPP.
Discussion

See the AEEventHandlerProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

extern AEEventHandlerUPP NewAEEventHandlerUPP (
   AEEventHandlerProcPtr userRoutine
);

/*AECountItems

Counts the number of descriptors in a descriptor list.

OSErr AECountItems (
   const AEDescList * theAEDescList,
   long * theCount
);
Parameters
theAEDescList

A pointer to the descriptor list to count. See AEDescList.
theCount

A pointer to a count variable. On return, the number of descriptors in the specified descriptor list.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application typically counts the descriptors in a descriptor list when it is extracting data from an Apple event. You can use the functions in “Getting Items From Descriptor Lists” to get an individual item from a descriptor list or to iterate through the items. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
extern OSErr AECountItems (
   const AEDescList * theAEDescList,
   long * theCount
);

/*AEGetNthPtr

Gets a copy of the data from a descriptor at a specified position in a descriptor list; typically used when your application needs to work with the extracted data directly.

OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAEDescList

A pointer to the descriptor list that contains the descriptor. See AEDescList.
index

A one-based positive integer indicating the position in the descriptor list of the descriptor to get the data from. AEGetNthPtr returns an error if you pass zero, a negative number, or a value that is out of range.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the index parameter is not of the desired type, AEGetNthPtr attempts to coerce the data to this type. If you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the copied data is the same as the descriptor type of the original descriptor.

See DescType.
theAEKeyword

A pointer to a keyword. On return, the keyword for the specified descriptor, if you are getting data from a list of keyword-specified descriptors; otherwise, AEGetNthPtr returns the value typeWildCard. Some keyword constants are described in “Keyword Attribute Constants” and “Keyword Parameter Constants”. See AEKeyword.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the data pointed to by dataPtr. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor at the position in the descriptor list specified by the index parameter.
maximumSize

The maximum length, in bytes, of the expected data. The AEGetNthPtr function will not return more data than you specify in this parameter. 
actualSize

A pointer to a size variable. On return, the length, in bytes, of the data for the specified descriptor. If this value is larger than the value of the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the descriptor, though AEGetNthPtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetNthPtr again.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AEGetNthPtr function uses a buffer to return the data for a specified descriptor from a specified descriptor list. The function attempts to coerce the descriptor to the descriptor type specified by the desiredType parameter.

Before calling AEGetNthPtr, you can call the AESizeOfNthItem function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AESizeOfNthItem may coerce the data, which may cause the size of the data to change. If you are using AEGetNthPtr to iterate through a list of descriptors of the same type with a fixed size, such as a list of descriptors of type typeFSS, you can get the size once, allocate a buffer, and reuse it for each call.

The order of items in an Apple event record may change after an insertion or deletion. In addition, duplicating an Apple event record is not guaranteed to preserve the item order. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
extern OSErr AEGetNthPtr (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);

/*AEGetDescData

Gets the data from the specified descriptor.

OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize
);
Parameters
theAEDesc

A pointer to the descriptor to get the data from. See AEDesc.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes should be the same as the value you pass in the maximumSize parameter. On return, contains the data from the descriptor.
maximumSize

The length, in bytes, of the expected descriptor data. The AEGetDescData function will not return more data than you specify in this parameter. You typically determine the maximum size by calling AEGetDescDataSize.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Your application can call AEGetDescDataSize to get the size, in bytes, of the data in a descriptor, allocate a buffer or variable of that size, then call AEGetDescData to get the data. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

extern OSErr AEGetDescData (
   const AEDesc * theAEDesc,
   void * dataPtr,
   Size maximumSize
);


/*AECreateDesc

Creates a new descriptor that incorporates the specified data.

OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result
);
Parameters
typeCode

The descriptor type for the new descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the new descriptor. This data is copied into a newly-allocated block of memory for the descriptor that is created. To minimize copying overhead, consider using AECreateDescFromExternalPtr.
dataSize

The length, in bytes, of the data for the new descriptor.
result

A pointer to a descriptor. On successful return, a descriptor that incorporates the data specified by the dataPtr parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

While it is possible to create an Apple event descriptor or a descriptor list or a descriptor with the AECreateDesc function (assuming you have access to the raw data for an Apple event, list, or descriptor), you typically create these structured objects with their specific creation routines—AECreateAppleEvent, AECreateList, or AECreateDesc. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
extern OSErr AECreateDesc (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   AEDesc * result
);

/*AEGetParamPtr

Gets a copy of the data for a specified Apple event parameter from an Apple event or an Apple event record (type AERecord); typically used when your application needs to work with the extracted data directly.

OSErr AEGetParamPtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAppleEvent

A pointer to the Apple event to get the parameter data from. See AppleEvent.
theAEKeyword

The keyword that specifies the desired Apple event parameter. Some keyword constants are described in “Keyword Parameter Constants”. See AEKeyword.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the theAEKeyword parameter is not of the desired type, AEGetParamPtr attempts to coerce the data to this type. However, if the desired type is typeWildCard, no coercion is performed.

On return, you can determine the actual descriptor type by examining the typeCode parameter.

See DescType.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the data pointed to by dataPtr. The returned type is either the same as the type specified by the desiredType parameter or, if the desired type was type wildcard, the true type of the descriptor. Specify NULL if you do not care about this return value. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
dataPtr

A pointer to a buffer, local variable, or other storage location created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the parameter data. Specify NULL if you do not care about this return value. 
maximumSize

The maximum length, in bytes, of the expected Apple event parameter data. The AEGetParamPtr function will not return more data than you specify in this parameter.
actualSize

A pointer to a variable of type Size. On return, the length, in bytes, of the data for the specified Apple event parameter. If this value is larger than the value you passed in the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the parameter, though AEGetParamPtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetParamPtr again. Specify NULL if you do not care about this return value.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

You should use this function only to extract data from value descriptors such as typeUTF8Text.

Because this function allows you to specify a desired type, it can result in coercion. When used correctly, this has the positive effect of returning the data in the desired format. However, it can have side effects you may not be expecting, such as the overhead of calls to coercion handlers. See also the Version Notes section below for possible problems with coercion.

To get Apple event parameter data for your application to use directly, call AEGetParamPtr. To get a descriptor for an Apple event parameter to pass on to another Apple Event Manager routine, call AEGetParamDesc.

Before calling AEGetParamPtr, you can call the AESizeOfParam function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AEGetParamPtr may coerce the data, which may cause the size of the data to change. 

In some cases, you may get improved efficiency extracting information from an Apple event with the AEGetDescDataRange function.
Version Notes

Thread safe starting in Mac OS X v10.2.

If the actual parameter you are getting with AEGetParamPtr is a record, AEGetParamPtr will erroneously allow you to get the parameter as any type at all, when it really should allow only typeAERecord, typeAEList, or typeWildcard. For other types, it will place raw record data into the designated buffer. With AppleScript 1.1.2, it would then return errAECoercionFail, as expected. With AppleScript 1.3 and later, however, it returns noErr.

You can work around this problem by checking the returned parameter from any call to AEGetParamPtr. If the source type is typeAERecord and the type you asked for was anything other than typeAERecord, typeAEList, or typeWildcard, you should assume the coercion failed.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetParamPtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);

/*AEGetNthDesc

Copies a descriptor from a specified position in a descriptor list into a specified descriptor; typically used when your application needs to pass the extracted data to another function as a descriptor.

OSErr AEGetNthDesc (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   AEDesc * result
);
Parameters
theAEDescList

A pointer to the descriptor list to get the descriptor from. See AEDescList.
index

A one-based positive integer indicating the position of the descriptor to get. AEGetNthDesc returns an error if you pass zero, a negative number, or a value that is out of range.
desiredType

The desired descriptor type for the descriptor to copy. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the index parameter is not of the desired type, AEGetNthDesc attempts to coerce it to this type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the copied descriptor is the same as the descriptor type of the original descriptor.

See DescType.
theAEKeyword

A pointer to a keyword. On successful return, the keyword for the specified descriptor, if you are getting data from a list of keyword-specified descriptors; otherwise, AEGetNthDesc returns the value typeWildCard. Some keyword constants are described in “Keyword Attribute Constants” and “Keyword Parameter Constants”. See AEKeyword.
result

A pointer to a descriptor. On successful return, a copy of the descriptor specified by the index parameter, coerced, if necessary, to the descriptor type specified by the desiredType parameter. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

If the Nth descriptor in the list is itself an Apple event record and the desired type is not wildcard, record, or list, AEGetNthDesc will fail with an errAECoercionFailed error. This behavior prevents coercion problems. 

You may find the AEGetNthPtr function convenient for retrieving data for direct use in your application, as it includes automatic coercion. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEGetNthDesc (
   const AEDescList * theAEDescList,
   long index,
   DescType desiredType,
   AEKeyword * theAEKeyword,
   AEDesc * result
);

/*AECreateAppleEvent

Creates an Apple event with several important attributes but no parameters.

OSErr AECreateAppleEvent (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   const AEAddressDesc * target,
   AEReturnID returnID,
   AETransactionID transactionID,
   AppleEvent * result
);
Parameters
theAEEventClass

The event class of the Apple event to create. This parameter becomes accessible through the keyEventClassAttr attribute of the Apple event. Some event classes are described in “Event Class Constants”. See AEEventClass.
theAEEventID

The event ID of the Apple event to create. This parameter becomes accessible through the keyEventIDAttr attribute of the Apple event. Some event IDs are described in “Event ID Constants”. See AEEventID.
target

A pointer to an address descriptor. Before calling AECreateAppleEvent, you set the descriptor to identify the target (or server) application for the Apple event. This parameter becomes accessible through the keyAddressAttr attribute of the Apple event. See AEAddressDesc.
returnID

The return ID for the created Apple event. If you pass a value of kAutoGenerateReturnID, the Apple Event Manager assigns the created Apple event a return ID that is unique to the current session. If you pass any other value, the Apple Event Manager assigns that value for the ID. This parameter becomes accessible through the keyReturnIDAttr attribute of the Apple event. The return ID constant is described in “ID Constants for the AECreateAppleEvent Function”. See AEReturnID.
transactionID

The transaction ID for this Apple event. A transaction is a sequence of Apple events that are sent back and forth between the client and server applications, beginning with the client’s initial request for a service. All Apple events that are part of a transaction must have the same transaction ID. You can specify the kAnyTransactionID constant if the Apple event is not one of a series of interdependent Apple events. This parameter becomes accessible through the keyTransactionIDAttr attribute of the Apple event. This transaction ID constant is described in “ID Constants for the AECreateAppleEvent Function”. See AETransactionID.
result

A pointer to an Apple event. On successful return, the new Apple event. On error, a null descriptor (one with descriptor type typeNull). If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting Apple event after it has finished using it. See the AppleEvent data type.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AECreateAppleEvent function creates an empty Apple event. You can add parameters to the Apple event after you create it with the functions described in “Adding Parameters and Attributes to an Apple Event”. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECreateAppleEvent (
   AEEventClass theAEEventClass,
   AEEventID theAEEventID,
   const AEAddressDesc * target,
   AEReturnID returnID,
   AETransactionID transactionID,
   AppleEvent * result
);

/*AEPutParamDesc

Puts a descriptor and a keyword into an Apple event or Apple event record as an Apple event parameter.

OSErr AEPutParamDesc (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   const AEDesc * theAEDesc
);
Parameters
theAppleEvent

A pointer to the Apple event to add a parameter to. See the AppleEvent data type.
theAEKeyword

The keyword specifying the parameter to add. If the Apple event already has a parameter with this keyword, the parameter is replaced.

Some keyword constants are described in “Keyword Parameter Constants”.

See AEKeyword.
theAEDesc

A pointer to the descriptor for the parameter to add. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEPutParamDesc (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   const AEDesc * theAEDesc
);

/*AECreateList

Creates an empty descriptor list or Apple event record.

OSErr AECreateList (
   const void * factoringPtr,
   Size factoredSize,
   Boolean isRecord,
   AEDescList * resultList
);
Parameters
factoringPtr

A pointer to the data at the beginning of each descriptor that is the same for all descriptors in the list. If there is no common data, or if you decide not to isolate the common data, pass NULL as the value of this parameter.
factoredSize

The size of the common data. If there is no common data, or if you decide not to isolate the common data, pass 0 as the value of this parameter. (See the Discussion section for more information.)
isRecord

A Boolean value that specifies the kind of list to create. Pass a value of TRUE to create an Apple event record (a data structure of type AERecord) or FALSE to create a descriptor list.
resultList

A pointer to a descriptor list variable. On successful return, the descriptor list or Apple event record that the AECreateList function creates. On error, a null descriptor. See AEDescList.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

The AECreateList function creates an empty descriptor list or Apple event record. You can use the functions described in “Adding Items to Descriptor Lists” to populate the list as part of creating an Apple event. After sending the Apple event with the AESend function, you should dispose of the descriptor list with the AEDisposeDesc function when you no longer need it.

If you intend to use a descriptor list for a factored Apple event array, you must provide, in the factoringPtr parameter, a pointer to the data shared by all items in the array and, in the factoredSize parameter, the size of the common data. The common data must be 4, 8, or more than 8 bytes in length because it always consists of (a) the descriptor type (4 bytes) (b) the descriptor type (4 bytes) and the size of each item’s data (4 bytes) or (c) the descriptor type (4 bytes), the size of each item’s data (4 bytes), and some portion of the data itself (1 or more bytes).

For information about data types used with Apple event arrays, see “Apple Event Manager Data Types”.
Version Notes

The factoringPtr and factoredSize parameters are not supported in Mac OS X v10.2 and later. You should pass NULL and zero, respectively, for these parameters.

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECreateList (
   const void * factoringPtr,
   Size factoredSize,
   Boolean isRecord,
   AEDescList * resultList
);

/*AECoercePtr

Coerces data to a desired descriptor type and creates a descriptor containing the newly coerced data.

OSErr AECoercePtr (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   DescType toType,
   AEDesc * result
);
Parameters
typeCode

The descriptor type of the source data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data to coerce.
dataSize

The length, in bytes, of the data to coerce.
toType

The desired descriptor type of the resulting descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.
result

A pointer to a descriptor. On successful return, a descriptor containing the coerced data and matching the descriptor type specified in toType. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Starting in Mac OS X version 10.2, pointer-based coercion handlers are not called if the input type is “structured”—that is, if the type to be coerced is typeAEList, typeAERecord, or coerced typeAERecord. If you want to add a coercion handler for one of these types, it must be a descriptor-based handler. This does not mean you are required to use descriptor-based coercion handlers everywhere—for “flat” data types, such as typeText, pointer-based handlers are still fine.

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECoercePtr (
   DescType typeCode,
   const void * dataPtr,
   Size dataSize,
   DescType toType,
   AEDesc * result
);

/*AECoerceDesc

Coerces the data in a descriptor to another descriptor type and creates a descriptor containing the newly coerced data.

OSErr AECoerceDesc (
   const AEDesc * theAEDesc,
   DescType toType,
   AEDesc * result
);
Parameters
theAEDesc

A pointer to the descriptor containing the data to coerce. See AEDesc.
toType

The desired descriptor type of the resulting descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
result

A pointer to a descriptor. On successful return, a descriptor containing the coerced data and matching the descriptor type specified in toType. On error, a null descriptor. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it.
Return Value

A result code. See “Apple Event Manager Result Codes”. If AECoerceDesc returns a nonzero result code, it returns a null descriptor record (a descriptor record of type typeNull, which does not contain any data) unless the Apple Event Manager is not available because of limited memory.
Version Notes

See the Version Notes section for the AECoercePtr function for information on when to use descriptor-based versus pointer-based coercion handlers starting in Mac OS X version 10.2.

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AECoerceDesc (
   const AEDesc * theAEDesc,
   DescType toType,
   AEDesc * result
);

/*AEPutParamPtr

Puts a pointer to data, a descriptor type, and a keyword into an Apple event or Apple event record as an Apple event parameter.

OSErr AEPutParamPtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);
Parameters
theAppleEvent

A pointer to the Apple event to add a parameter to. See the AppleEvent data type.
theAEKeyword

The keyword for the parameter to add. If the Apple event already includes an parameter with this keyword, the parameter is replaced.

Some keyword constants are described in “Keyword Parameter Constants”.

See AEKeyword.
typeCode

The descriptor type for the parameter to add. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the parameter to add.
dataSize

The length, in bytes, of the data for the parameter to add.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEPutParamPtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);

/*AEInitializeDesc

Initializes a new descriptor. 

void AEInitializeDesc (
   AEDesc * desc
);
Parameters
desc

A pointer to a new descriptor. See AEDesc.
Discussion

The function sets the type of the descriptor to typeNull and sets the data handle to NULL. If you need to initialize a descriptor that already has some data in it, use AEDisposeDesc to deallocate the memory and initialize the descriptor.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.4 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

void AEInitializeDesc (
   AEDesc * desc
);

/*AEGetDescDataSize

Gets the size, in bytes, of the data in the specified descriptor.

Size AEGetDescDataSize (
   const AEDesc * theAEDesc
);
Parameters
theAEDesc

A pointer to the descriptor to obtain the data size for. See AEDesc.
Return Value

Returns the size, in bytes, of the data in the specified descriptor.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
Size AEGetDescDataSize (
   const AEDesc * theAEDesc
);

/*AEPutDesc

Adds a descriptor to any descriptor list, possibly replacing an existing descriptor in the list.

OSErr AEPutDesc (
   AEDescList * theAEDescList,
   long index,
   const AEDesc * theAEDesc
);
Parameters
theAEDescList

A pointer to the descriptor list to add a descriptor to. See AEDescList.
index

A one-based positive integer indicating the position to insert the descriptor at. If there is already a descriptor in the specified position, it is replaced.

You can pass a value of zero or count + 1 to add the descriptor at the end of the list. AEPutDesc returns an error (AEIllegalIndex) if you pass a negative number or a value that is out of range.
theAEDesc

A pointer to the descriptor to add to the list. See AEDesc.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEPutDesc (
   AEDescList * theAEDescList,
   long index,
   const AEDesc * theAEDesc
);

/*AEPutPtr

Puts data specified in a buffer to a descriptor list as a descriptor, possibly replacing an existing descriptor in the list.

OSErr AEPutPtr (
   AEDescList * theAEDescList,
   long index,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);
Parameters
theAEDescList

A pointer to the descriptor list to add a descriptor to. See AEDescList.
index

A one-based positive integer indicating the position to insert the descriptor at. If there is already a descriptor in the specified position, it is replaced.

You can pass a value of zero or count + 1 to add the descriptor at the end of the list. AEPutPtr returns an error (AEIllegalIndex) if you pass a negative number or a value that is out of range.
typeCode

The descriptor type for the descriptor to be put into the list. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the descriptor to add.
dataSize

The length, in bytes, of the data for the descriptor to add.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/OSErr AEPutPtr (
   AEDescList * theAEDescList,
   long index,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);

/*DisposeAEEventHandlerUPP

Disposes of a universal procedure pointer to an event handler function.

void DisposeAEEventHandlerUPP (
   AEEventHandlerUPP userUPP
);
Discussion

See the AEEventHandlerProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

void DisposeAEEventHandlerUPP (
   AEEventHandlerUPP userUPP
);

/*AEGetAttributePtr

Gets a copy of the data for a specified Apple event attribute from an Apple event; typically used when your application needs to work with the data directly.

OSErr AEGetAttributePtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);
Parameters
theAppleEvent

A pointer to the Apple event to get the attribute data from. See AppleEvent.
theAEKeyword

The keyword that specifies the desired attribute. Some keyword constants are described in “Keyword Attribute Constants”. See AEKeyword.
desiredType

The desired descriptor type for the copied data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If the descriptor specified by the theAEKeyword parameter is not of the desired type, AEGetAttributePtr attempts to coerce the data to this type. However, if you pass a value of typeWildCard, no coercion is performed, and the descriptor type of the returned data is the same as the descriptor type of the Apple event attribute.

On return, you can determine the actual descriptor type by examining the typeCode parameter.

See DescType.
typeCode

A pointer to a descriptor type. On return, specifies the descriptor type of the attribute data pointed to by dataPtr. The returned type is either the same as the type specified by the desiredType parameter or, if the desired type was type wildcard, the true type of the descriptor. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to a buffer, local variable, or other storage location, created and disposed of by your application. The size in bytes must be at least as large as the value you pass in the maximumSize parameter. On return, contains the attribute data.
maximumSize

The maximum length, in bytes, of the expected attribute data. The AEGetAttributePtr function will not return more data than you specify in this parameter. 
actualSize

A pointer to a size variable. On return, the length, in bytes, of the data for the specified Apple event attribute. If this value is larger than the value you passed in the maximumSize parameter, the buffer pointed to by dataPtr was not large enough to contain all of the data for the attribute, though AEGetAttributePtr does not write beyond the end of the buffer. If the buffer was too small, you can resize it and call AEGetAttributePtr again.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

To get Apple event attribute data for your application to use directly, call AEGetAttributePtr. To get a descriptor for an Apple event attribute to pass on to another Apple Event Manager routine, call AEGetAttributeDesc.

Before calling AEGetAttributePtr, you can call the AESizeOfAttribute function to determine a size for the dataPtr buffer. However, unless you specify typeWildCard for the desiredType parameter, AEGetAttributePtr may coerce the data, which may cause the size of the data to change. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/

OSErr AEGetAttributePtr (
   const AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType desiredType,
   DescType * typeCode,
   void * dataPtr,
   Size maximumSize,
   Size * actualSize
);

/*AEDuplicateDesc

Creates a copy of a descriptor.

OSErr AEDuplicateDesc (
   const AEDesc * theAEDesc,
   AEDesc * result
);
Parameters
theAEDesc

A pointer to the descriptor to duplicate. See AEDesc.
result

A pointer to a descriptor. On return, the descriptor contains a copy of the descriptor specified by the theAEDesc parameter. If the function returns successfully, your application should call the AEDisposeDesc function to dispose of the resulting descriptor after it has finished using it.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

It is common for applications to send Apple events that have one or more attributes or parameters in common. For example, if you send a series of Apple events to the same application, the address attribute is the same. In these cases, the most efficient way to create the necessary Apple events is to make a template Apple event that you can then copy—by calling the AEDuplicateDesc function—as needed. You then fill in or change the remaining parameters and attributes of the copy, send the copy by calling the AESend function and, after AESend returns a result code, dispose of the copy by calling AEDisposeDesc. You can use this approach to prepare structures of type AEDesc, AEDescList, AERecord, and AppleEvent. 
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEDuplicateDesc (
   const AEDesc * theAEDesc,
   AEDesc * result
);

/*Getting Data and Keyword-Specified Descriptor Records Out of AE Records
pascal OSErr AEGetKeyPtr(const AERecord *theAERecord, 
AEKeyword theAEKeyword, DescType desiredType, 
DescType *typeCode, void* dataPtr, 
Size maximumSize, Size *actualSize);
pascal OSErr AEGetKeyDesc(const AERecord *theAERecord, 
AEKeyword theAEKeyword, DescType desiredType, 
AEDesc *result);*/
pascal OSErr AEGetKeyDesc(const AERecord *theAERecord, 
AEKeyword theAEKeyword, DescType desiredType, 
AEDesc *result);

/*AEPutAttributePtr

Adds a pointer to data, a descriptor type, and a keyword to an Apple event as an attribute.

OSErr AEPutAttributePtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);
Parameters
theAppleEvent

A pointer to the Apple event to add an attribute to. See the AppleEvent data type.
theAEKeyword

The keyword for the attribute to add. If the Apple event already includes an attribute with this keyword, the attribute is replaced.

Some keyword constants are described in “Keyword Attribute Constants”.

See AEKeyword.
typeCode

The descriptor type for the attribute to add. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
dataPtr

A pointer to the data for the attribute to add.
dataSize

The length, in bytes, of the data for the attribute to add.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Version Notes

Thread safe starting in Mac OS X v10.2.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEPutAttributePtr (
   AppleEvent * theAppleEvent,
   AEKeyword theAEKeyword,
   DescType typeCode,
   const void * dataPtr,
   Size dataSize
);

/*InvokeAEEventHandlerUPP

Calls an event handler universal procedure pointer.

OSErr InvokeAEEventHandlerUPP (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon,
   AEEventHandlerUPP userUPP
);
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

See the AEEventHandlerProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr InvokeAEEventHandlerUPP (
   const AppleEvent * theAppleEvent,
   AppleEvent * reply,
   long handlerRefcon,
   AEEventHandlerUPP userUPP
);

/*NewAECoercePtrUPP

Creates a new universal procedure pointer to a function that coerces data stored in a buffer.

AECoercePtrUPP NewAECoercePtrUPP (
   AECoercePtrProcPtr userRoutine
);
Return Value

See AECoercePtrUPP.
Discussion

See the AECoercePtrProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
AECoercePtrUPP NewAECoercePtrUPP (
   AECoercePtrProcPtr userRoutine
);

/*AEInstallCoercionHandler

Installs a coercion handler in either the application or system coercion handler dispatch table.

OSErr AEInstallCoercionHandler (
   DescType fromType,
   DescType toType,
   AECoercionHandlerUPP handler,
   long handlerRefcon,
   Boolean fromTypeIsDesc,
   Boolean isSysHandler
);
Parameters
fromType

The descriptor type of the data coerced by the handler. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”. See DescType.
toType

The descriptor type of the resulting data. For a list of AppleScript’s predefined descriptor types, see “Descriptor Type Constants”.

If there was already an entry in the specified coercion handler table for the same source descriptor type and result descriptor type, the existing entry is replaced. See DescType.
handler

A universal procedure pointer to the coercion handler function to install. See AECoercionHandlerUPP.
handlerRefcon

A reference constant. The Apple Event Manager passes this value to the handler each time it calls it. If your handler doesn’t require a reference constant, pass 0 for this parameter.
fromTypeIsDesc

Specifies the form of the data to coerce. Pass TRUE if the coercion handler expects the data as a descriptor or FALSE if the coercion handler expects a pointer to the data. The Apple Event Manager can provide a pointer to data more efficiently than it can provide a descriptor, so all coercion functions should accept a pointer to data if possible.
isSysHandler

Specifies the coercion table to add the handler to. Pass TRUE to add the handler to the system coercion table or FALSE to add the handler to your application’s coercion table. Use of the system coercion table is not recommended.
Return Value

A result code. See “Apple Event Manager Result Codes”.
Discussion

Before using AEInstallCoercionHandler to install a handler for a particular descriptor type, you can use the AEGetCoercionHandler function to determine whether the table already contains a coercion handler for that type. 
Version Notes

See the Version Notes section for the AECoercePtr function for information on when to use descriptor-based versus pointer-based coercion handlers starting in Mac OS X version 10.2.

Thread safe starting in Mac OS X v10.2.

Your application should not install a coercion handler in a system coercion handler dispatch table with the goal that the handler will get called when other applications perform coercions—this won’t work in Mac OS X. For more information, see “Writing and Installing Coercion Handlers” in Apple Events Programming Guide.
Availability
Available in CarbonLib 1.0 and later when running Mac OS 8.1 or later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
OSErr AEInstallCoercionHandler (
   DescType fromType,
   DescType toType,
   AECoercionHandlerUPP handler,
   long handlerRefcon,
   Boolean fromTypeIsDesc,
   Boolean isSysHandler
);

/*NewAECoerceDescUPP

Creates a new universal procedure pointer to a function that coerces data stored in a descriptor.

AECoerceDescUPP NewAECoerceDescUPP (
   AECoerceDescProcPtr userRoutine
);
Return Value

See AECoerceDescUPP.
Discussion

See the AECoerceDescProcPtr callback function. 
Availability
Available in CarbonLib 1.0 and later.
Available in Mac OS X v10.0 and later.
Declared In
AEDataModel.h*/
AECoerceDescUPP NewAECoerceDescUPP (
   AECoerceDescProcPtr userRoutine
);

#ifdef __cplusplus
}
#endif
#endif