/*EXCHANGEDATA(2)             BSD System Calls Manual            EXCHANGEDATA(2)

NAME
     exchangedata -- atomically exchange data between two files

SYNOPSIS
     #include <unistd.h>

     int
     exchangedata(const char * path1, const char * path2,
         unsigned long options);

DESCRIPTION
     The exchangedata() function swaps the contents of the files referenced by
     path1 and path2 in an atomic fashion.  That is, all concurrent processes
     will either see the pre-exchanged state or the post-exchanged state; they
     can never see the files in an inconsistent state.  The data in all forks
     is swapped in this way.  The options parameter lets you control specific
     aspects of the function's behaviour.

     Open file descriptors follow the swapped data.  Thus, a descriptor that
     previously referenced path1 will now reference the data that's accessible
     via path2, and vice versa.

     In general, the file attributes (metadata) are not exchanged.  Specifi-cally, Specifically,
     cally, the object identifier attributes (that is, the ATTR_CMN_OBJID and
     ATTR_CMN_OBJPERMANENTID attributes as defined by the getattrlist(2) func-tion) function)
     tion) are not swapped.  An exception to this general rule is that the
     modification time attribute ( ATTR_CMN_MODTIME ) is swapped.

     When combined, these features allow you to implement a 'safe save' func-tion function
     tion that does not break references to the file (for example, aliases).
     You first save the new contents to a temporary file and then exchange the
     data of the original file and the temporary.  Programs that reference the
     file via an object identifier will continue to reference the original
     file, but now it has the new data.

     The path1 and path2 parameters must both reference valid files.  All
     directories listed in the path names leading to these files must be
     searchable.  You must have write access to the files.

     The options parameter is a bit set that controls the behaviour of
     exchangedata().  The following option bits are defined.

     FSOPT_NOFOLLOW  If this bit is set, exchangedata() will not follow a sym-link symlink
                     link if it occurs as the last component of path1 or
                     path2.

RETURN VALUES
     Upon successful completion a value of 0 is returned.  Otherwise, a value
     of -1 is returned and errno is set to indicate the error.

COMPATIBILITY
     Not all volumes support exchangedata().  You can test whether a volume
     supports exchangedata() by using getattrlist(2) to get the volume capa-bilities capabilities
     bilities attribute ATTR_VOL_CAPABILITIES, and then testing the
     VOL_CAP_INT_EXCHANGEDATA flag.

ERRORS
     exchangedata() will fail if:

     [ENOTSUP]          The volume does not support exchangedata().

     [ENOTDIR]          A component of the path prefix is not a directory.

     [ENAMETOOLONG]     A component of a path name exceeded NAME_MAX charac-ters, characters,
                        ters, or an entire path name exceeded PATH_MAX charac-ters. characters.
                        ters.

     [ENOENT]           Either file does not exist.

     [EACCES]           Search permission is denied for a component of the
                        path prefix.

     [ELOOP]            Too many symbolic links were encountered in translat-ing translating
                        ing the pathname.

     [EFAULT]           path1 or path2 points to an invalid address.

     [EXDEV]            path1 and path2 are on different volumes (mounted file
                        systems).

     [EINVAL]           path1 or path2 reference the same file.

     [EINVAL]           You try to exchange something other than a regular
                        file (for example, a directory).

     [EIO]              An I/O error occurred while reading from or writing to
                        the file system.

SEE ALSO
     getattrlist(2)

HISTORY
     A exchangedata() function call appeared in Darwin 1.3.1 (Mac OS X version
     10.0).

Darwin                         December 15, 2003                        Darwin*/
 int exchangedata(
const char * path1, 
const char * path2,
unsigned long options);

/*GETOPT(3)                BSD Library Functions Manual                GETOPT(3)


NAME
     getopt -- get option character from command line argument list

LIBRARY
     Standard C Library (libc, -lc)

SYNOPSIS
     #include <unistd.h>

     extern char *optarg;
     extern int optind;
     extern int optopt;
     extern int opterr;
     extern int optreset;

     int
     getopt(int argc, char * const argv[], const char *optstring);

DESCRIPTION
     The getopt() function incrementally parses a command line argument list
     argv and returns the next known option character.  An option character is
     known if it has been specified in the string of accepted option charac-ters, characters,
     ters, optstring.

     The option string optstring may contain the following elements: individ-ual individual
     ual characters, and characters followed by a colon to indicate an option
     argument is to follow.  For example, an option string "x" recognizes an
     option ``-x'', and an option string "x:" recognizes an option and argu-ment argument
     ment ``-x argument''.  It does not matter to getopt() if a following
     argument has leading white space.

     On return from getopt(), optarg points to an option argument, if it is
     anticipated, and the variable optind contains the index to the next argv
     argument for a subsequent call to getopt().  The variable optopt saves
     the last known option character returned by getopt().

     The variables opterr and optind are both initialized to 1.  The optind
     variable may be set to another value before a set of calls to getopt() in
     order to skip over more or less argv entries.

     In order to use getopt() to evaluate multiple sets of arguments, or to
     evaluate a single set of arguments multiple times, the variable optreset
     must be set to 1 before the second and each additional set of calls to
     getopt(), and the variable optind must be reinitialized.

     The getopt() function returns -1 when the argument list is exhausted.
     The interpretation of options in the argument list may be cancelled by
     the option `--' (double dash) which causes getopt() to signal the end of
     argument processing and return -1.  When all options have been processed
     (i.e., up to the first non-option argument), getopt() returns -1.

RETURN VALUES
     The getopt() function returns the next known option character in
     optstring.  If getopt() encounters a character not found in optstring or
     if it detects a missing option argument, it returns `?' (question mark).
     If optstring has a leading `:' then a missing option argument causes `:'
     to be returned instead of `?'.  In either case, the variable optopt is
     set to the character that caused the error.  The getopt() function
     returns -1 when the argument list is exhausted.

EXAMPLES
     #include <unistd.h>
     int bflag, ch, fd;

     bflag = 0;
     while ((ch = getopt(argc, argv, "bf:")) != -1) {
             switch (ch) {
             case 'b':
                     bflag = 1;
                     break;
             case 'f':
                     if ((fd = open(optarg, O_RDONLY, 0)) < 0) {
                             (void)fprintf(stderr,
                                 "myname: %s: %s\n", optarg, strerror(errno));
                             exit(1);
                     }
                     break;
             case '?':
             default:
                     usage();
             }
     }
     argc -= optind;
     argv += optind;

DIAGNOSTICS
     If the getopt() function encounters a character not found in the string
     optstring or detects a missing option argument it writes an error message
     to the stderr and returns `?'.  Setting opterr to a zero will disable
     these error messages.  If optstring has a leading `:' then a missing
     option argument causes a `:' to be returned in addition to suppressing
     any error messages.

     Option arguments are allowed to begin with ``-''; this is reasonable but
     reduces the amount of error checking possible.

SEE ALSO
     getopt(1), getopt_long(3), getsubopt(3)

STANDARDS
     The optreset variable was added to make it possible to call the getopt()
     function multiple times.  This is an extension to the IEEE Std 1003.2
     (``POSIX.2'') specification.

HISTORY
     The getopt() function appeared in 4.3BSD.

BUGS
     The getopt() function was once specified to return EOF instead of -1.
     This was changed by IEEE Std 1003.2-1992 (``POSIX.2'') to decouple
     getopt() from <stdio.h>.

     A single dash ``-'' may be specified as a character in optstring, however
     it should never have an argument associated with it.  This allows
     getopt() to be used with programs that expect ``-'' as an option flag.
     This practice is wrong, and should not be used in any current develop-ment. development.
     ment.  It is provided for backward compatibility only.  Care should be
     taken not to use `-' as the first character in optstring to avoid a
     semantic conflict with GNU getopt(), which assigns different meaning to
     an optstring that begins with a `-'.  By default, a single dash causes
     getopt() to return -1.

     It is also possible to handle digits as option letters.  This allows
     getopt() to be used with programs that expect a number (``-3'') as an
     option.  This practice is wrong, and should not be used in any current
     development.  It is provided for backward compatibility only.  The fol-lowing following
     lowing code fragment works in most cases.

           int ch;
           long length;
           char *p, *ep;

           while ((ch = getopt(argc, argv, "0123456789")) != -1)
                   switch (ch) {
                   case '0': case '1': case '2': case '3': case '4':
                   case '5': case '6': case '7': case '8': case '9':
                           p = argv[optind - 1];
                           if (p[0] == '-' && p[1] == ch && !p[2]) {
                                   length = ch - '0';
                                   ep = "";
                           } else if (argv[optind] && argv[optind][1] == ch) {
                                   length = strtol((p = argv[optind] + 1),
                                       &ep, 10);
                                   optind++;
                                   optreset = 1;
                           } else
                                   usage();
                           if (*ep != '\0')
                                   errx(EX_USAGE, "illegal number -- %s", p);
                           break;
                   }

BSD                             April 27, 1995                             BSD*/

extern int optreset;