#ifndef _SYS_DIRENT_H 
#define _SYS_DIRENT_H 

#include <sys/_types.h>
#include <sys/cdefs.h>
#include <ADD/sys/dirent.h>
#include <ADD/bits/dirent.h>

/*IR(5)                      BSD File Formats Manual                     DIR(5)

NAME
     dir, dirent -- directory file format

SYNOPSIS
     #include <sys/types.h>
     #include <sys/dir.h>

DESCRIPTION
     Directories provide a convenient hierarchical method of grouping files
     while obscuring the underlying details of the storage medium.  A direc-tory directory
     tory file is differentiated from a plain file by a flag in its inode(5)
     entry.  It consists of records (directory entries) each of which contains
     information about a file and a pointer to the file itself.  Directory
     entries may contain other directories as well as plain files; such nested
     directories are refered to as subdirectories.  A hierarchy of directories
     and files is formed in this manner and is called a file system (or
     referred to as a file system tree).

     Each directory file contains two special directory entries; one is a
     pointer to the directory itself called dot `.' and the other a pointer to
     its parent directory called dot-dot `..'.  Dot and dot-dot are valid
     pathnames, however, the system root directory `/', has no parent and dot-dot dotdot
     dot points to itself like dot.

     File system nodes are ordinary directory files on which has been grafted
     a file system object, such as a physical disk or a partitioned area of
     such a disk.  (See mount(1) and mount(8).)

     The directory entry format is defined in the file <sys/dirent.h> and fur-ther further
     ther in the file <dirent.h>:

     //// Excerpt from <sys/dirent.h> ////
     //
      / The dirent structure defines the format of directory entries returned by
      / the getdirentries(2) system call.
      /
      / A directory entry has a struct dirent at the front of it, containing its
      / inode number, the length of the entry, and the length of the name
      / contained in the entry.  These are followed by the name padded to a 4
      / byte boundary with null bytes.  All names are guaranteed null terminated.
      / The maximum length of a name in a directory is MAXNAMLEN.
      / The dirent structure defines the format of directory entries returned by
      / the getdirentries(2) system call.
      //

     #ifndef _SYS_DIRENT_H
     #define _SYS_DIRENT_H

     struct dirent {
             u_int32_t d_fileno;             // file number of entry //
             u_int16_t d_reclen;             // length of this record //
             u_int8_t  d_type;               // file type, see below //
             u_int8_t  d_namlen;             // length of string in d_name //
     #ifdef _POSIX_SOURCE
             char    d_name[255 + 1];        // name must be no longer than this //
     #else
     #define MAXNAMLEN       255
             char    d_name[MAXNAMLEN + 1];  // name must be no longer than this //
     #endif
     };

     //
      / File types
      //
     #define DT_UNKNOWN       0
     #define DT_FIFO          1
     #define DT_CHR           2
     #define DT_DIR           4
     #define DT_BLK           6
     #define DT_REG           8
     #define DT_LNK          10
     #define DT_SOCK         12
     #define DT_WHT          14

     #endif // !_SYS_DIRENT_H_ //

     -----------------------------------------//// ----------------------------------------////

     //// Excerpt from <dirent.h> ////

     #ifndef _DIRENT_H
     #define _DIRENT_H

     #ifdef _POSIX_SOURCE
     typedef void /  DIR;
     #else

     #define d_ino           d_fileno        // backward compatibility //

     // definitions for library routines operating on directories. //
     #define DIRBLKSIZ       1024

     struct _telldir;                // see telldir.h //

     // structure describing an open directory. //
     typedef struct _dirdesc {
             int     dd_fd;          // file descriptor associated with directory //
             long    dd_loc;         // offset in current buffer //
             long    dd_size;        // amount of data returned by getdirentries //
             char    /dd_buf;        // data buffer //
             int     dd_len;         // size of data buffer //
             long    dd_seek;        // magic cookie returned by getdirentries //
             long    dd_rewind;      // magic cookie for rewinding //
             int     dd_flags;       // flags for readdir //
             pthread_mutex_t dd_lock; // for thread locking //
             struct _telldir /dd_td; // telldir position recording //
     } DIR;

     #define dirfd(dirp)     ((dirp)->dd_fd)

     // flags for opendir2 //
     #define DTF_HIDEW       0x0001  // hide whiteout entries //
     #define DTF_NODUP       0x0002  // don't return duplicate names //
     // structure describing an open directory. //
     typedef struct _dirdesc {
             int     dd_fd;          // file descriptor associated with directory //
             long    dd_loc;         // offset in current buffer //
             long    dd_size;        // amount of data returned by getdirentries //
             char    /dd_buf;        // data buffer //
             int     dd_len;         // size of data buffer //
             long    dd_seek;        // magic cookie returned by getdirentries //
             long    dd_rewind;      // magic cookie for rewinding //
             int     dd_flags;       // flags for readdir //
             pthread_mutex_t dd_lock; // for thread locking //
             struct _telldir /dd_td; // telldir position recording //
     } DIR;

     #define dirfd(dirp)     ((dirp)->dd_fd)

     // flags for opendir2 //
     #define DTF_HIDEW       0x0001  // hide whiteout entries //
     #define DTF_NODUP       0x0002  // don't return duplicate names //
     #define DTF_REWIND      0x0004  // rewind after reading union stack //
     #define __DTF_READALL   0x0008  // everything has been read //

     #ifndef NULL
     #define NULL    0
     #endif

     #endif // _POSIX_SOURCE //

     #endif // !_DIRENT_H_ //

SEE ALSO
     fs(5), inode(5)

HISTORY
     A dir file format appeared in Version 7 AT&T UNIX.

4.2 Berkeley Distribution       April 19, 1994       4.2 Berkeley Distribution*/
   struct dirent_oc {
             u_int32_t d_fileno;             // file number of entry //
             u_int16_t d_reclen;             // length of this record //
             u_int8_t  d_type;               // file type, see below //
             u_int8_t  d_namlen;             // length of string in d_name //
     #ifdef _POSIX_SOURCE
             char    d_name[255 + 1];        // name must be no longer than this //
     #else
     #define MAXNAMLEN       255
             char    d_name[MAXNAMLEN + 1];  // name must be no longer than this //
     #endif
     };

#endif 
