#import <AppKit/NSKeyValueBinding.h>

/*NSIsControllerMarker

Tests whether a given object is special marker object used for indicating the state of a selection in relation to a key.

BOOL NSIsControllerMarker(id object)
Discussion

This function helps you to create bindings between user interface elements and controller objects. The Application Kit predefines several special marker objects used as values for indicating selection state; currently these are NSMultipleValuesMarker, NSNoSelectionMarker, and NSNotApplicableMarker. These markers are typed as id and only exist for the purpose of indicating a state; they are never archived and cannot be used as object values in controls. You use this function to test whether a given object value is a marker, in which case it is not directly assignable to the object that is bound. This check is important, especially since additional markers may be added in the future.

See the NSKeyValueBinding.h header file for further details.
Availability
Available in Mac OS X v10.3 and later.*/
BOOL NSIsControllerMarker(id object);

/*Constants

The following values are used as keys in the options dictionary passed to the bind:toObject:withKeyPath:options: method. These keys are also used in the dictionary returned as the NSOptionsKey value of infoForBinding:. See the Cocoa Bindings Reference for more information.
Constant	
Description
NSAllowsEditingMultipleValuesSelectionBindingOption	
An NSNumber object containing a Boolean value that determines if the binding allows editing when the value represents a multiple selection.

Available in Mac OS X v10.4 and later.
NSAllowsNullArgumentBindingOption	
An NSNumber object containing a Boolean value that determines if the argument bindings allows passing argument values of nil. 

Available in Mac OS X v10.4 and later.
NSConditionallySetsEditableBindingOption	
An NSNumber object containing a Boolean value that determines if the editable state of the user interface item is automatically configured based on the controller's selection. 

Available in Mac OS X v10.4 and later.
NSConditionallySetsEnabledBindingOption	
An NSNumber object containing a Boolean value that determines if the enabled state of the user interface item is automatically configured based on the controller's selection. 

Available in Mac OS X v10.4 and later.
NSConditionallySetsHiddenBindingOption	
An NSNumber object containing a Boolean value that determines if the hidden state of the user interface item is automatically configured based on the controller's selection. 

Available in Mac OS X v10.4 and later.
NSContinuouslyUpdatesValueBindingOption	
An NSNumber object containing a Boolean value that determines whether the value of the binding is updated as edits are made to the user interface item or is updated only when the user interface item resigns as the responder. 

Available in Mac OS X v10.4 and later.
NSCreatesSortDescriptorBindingOption	
An NSNumber object containing a Boolean value that determines if a sort descriptor is created for a table column. 

If this value is NO, then the table column does not allow sorting. 

Available in Mac OS X v10.4 and later.
NSDeletesObjectsOnRemoveBindingsOption	
An NSNumber object containing a Boolean value that determines if an object is deleted from the managed context immediately upon being removed from a relationship. 

Available in Mac OS X v10.4 and later.
NSDisplayNameBindingOption	
An NSString object containing a human readable string to be displayed for a predicate. 

Available in Mac OS X v10.4 and later.
NSDisplayPatternBindingOption	
An NSString object that specifies a format string used to construct the final value of a string. 

Available in Mac OS X v10.4 and later.
NSHandlesContentAsCompoundValueBindingOption	
An NSNumber object containing a Boolean value that determines if the content is treated as a compound value. 

Available in Mac OS X v10.4 and later.
NSInsertsNullPlaceholderBindingOption	
An NSNumber object containing a Boolean value that determines if an additional item which represents nil is inserted into a matrix or pop-up menu before the items in the content array. 

Available in Mac OS X v10.4 and later.
NSInvokesSeparatelyWithArrayObjectsBindingOption	
An NSNumber object containing a Boolean value that determines whether the specified selector is invoked with the array as the argument or is invoked repeatedly with each array item as an argument. 

Available in Mac OS X v10.4 and later.
NSMultipleValuesPlaceholderBindingOption	
An object that is used as a placeholder when the key path of the bound controller returns the NSMultipleValuesMarker marker for a binding. 

Available in Mac OS X v10.4 and later.
NSNoSelectionPlaceholderBindingOption	
An object that is used as a placeholder when the key path of the bound controller returns the NSNoSelectionMarker marker for a binding. 

Available in Mac OS X v10.4 and later.
NSNotApplicablePlaceholderBindingOption	
An object that is used as a placeholder when the key path of the bound controller returns the NSNotApplicableMarker marker for a binding. 

Available in Mac OS X v10.4 and later.
NSNullPlaceholderBindingOption	
An object that is used as a placeholder when the key path of the bound controller returns nil for a binding. 

Available in Mac OS X v10.4 and later.
NSPredicateFormatBindingOption	
An NSString object containing the predicate pattern string for the predicate bindings. Use $value to refer to the value in the search field. 

Available in Mac OS X v10.4 and later.
NSRaisesForNotApplicableKeysBindingOption	
An NSNumber object containing a Boolean value that specifies if an exception is raised when the binding is bound to a key that is not applicable—for example when an object is not key-value coding compliant for a key. 

Available in Mac OS X v10.4 and later.
NSSelectorNameBindingOption	
An NSString object that specifies the method selector invoked by the target binding when the user interface item is clicked. 

Available in Mac OS X v10.4 and later.
NSSelectsAllWhenSettingContentBindingOption	
An NSNumber object containing a Boolean value that specifies if all the items in the array controller are selected when the content is set. 

Available in Mac OS X v10.4 and later.
NSValidatesImmediatelyBindingOption	
An NSNumber object containing a Boolean value that determines if the contents of the binding are validated immediately. 

Available in Mac OS X v10.4 and later.
NSValueTransformerNameBindingOption	
The value for this key is an identifier of a registered NSValueTransformer instance that is applied to the bound value. 

Available in Mac OS X v10.4 and later.
NSValueTransformerBindingOption	
An NSValueTransformer instance that is applied to the bound value. 

Available in Mac OS X v10.4 and later.*/
extern NSString * NSAllowsEditingMultipleValuesSelectionBindingOption;	
//An NSNumber object containing a Boolean value that determines if the binding allows editing when the value represents a multiple selection.

//Available in Mac OS X v10.4 and later.
extern NSString * NSAllowsNullArgumentBindingOption;
//An NSNumber object containing a Boolean value that determines if the argument bindings allows passing argument values of nil. 

//Available in Mac OS X v10.4 and later.
extern NSString *  NSConditionallySetsEditableBindingOption	;
//An NSNumber object containing a Boolean value that determines if the editable state of the /user interface item is automatically configured based on the controller's selection. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSConditionallySetsEnabledBindingOption;
//An NSNumber object containing a Boolean value that determines if the enabled state of the user interface item is automatically configured based on the controller's selection. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSConditionallySetsHiddenBindingOption	;
//An NSNumber object containing a Boolean value that determines if the hidden state of the user interface item is automatically configured based on the controller's selection. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSContinuouslyUpdatesValueBindingOption	;
//An NSNumber object containing a Boolean value that determines whether the value of the binding is updated as edits are made to the user interface item or is updated only when the user interface item resigns as the responder. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSCreatesSortDescriptorBindingOption	;
//An NSNumber object containing a Boolean value that determines if a sort descriptor is created for a table column. 

//If this value is NO, then the table column does not allow sorting. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSDeletesObjectsOnRemoveBindingsOption	;
//An NSNumber object containing a Boolean value that determines if an object is deleted from the managed context immediately upon being removed from a relationship. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSDisplayNameBindingOption	;
//An NSString object containing a human readable string to be displayed for a predicate. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSDisplayPatternBindingOption	;
//An NSString object that specifies a format string used to construct the final value of a string. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSHandlesContentAsCompoundValueBindingOption	;
//An NSNumber object containing a Boolean value that determines if the content is treated as a compound value. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSInsertsNullPlaceholderBindingOption	;
//An NSNumber object containing a Boolean value that determines if an additional item which represents nil is inserted into a matrix or pop-up menu before the items in the content array. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSInvokesSeparatelyWithArrayObjectsBindingOption	;
//An NSNumber object containing a Boolean value that determines whether the specified selector is invoked with the array as the argument or is invoked repeatedly with each array item as an argument. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSMultipleValuesPlaceholderBindingOption	;
//An object that is used as a placeholder when the key path of the bound controller returns the NSMultipleValuesMarker marker for a binding. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSNoSelectionPlaceholderBindingOption	;
//An object that is used as a placeholder when the key path of the bound controller returns the NSNoSelectionMarker marker for a binding. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSNotApplicablePlaceholderBindingOption	;
//An object that is used as a placeholder when the key path of the bound controller returns the NSNotApplicableMarker marker for a binding. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSNullPlaceholderBindingOption	;
//An object that is used as a placeholder when the key path of the bound controller returns nil for a binding. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSPredicateFormatBindingOption	;
//An NSString object containing the predicate pattern string for the predicate bindings. Use $value to refer to the value in the search field. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSRaisesForNotApplicableKeysBindingOption	;
//An NSNumber object containing a Boolean value that specifies if an exception is raised when the binding is bound to a key that is not applicable—for example when an object is not key-value coding compliant for a key. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSSelectorNameBindingOption	;
//An NSString object that specifies the method selector invoked by the target binding when the user interface item is clicked. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSSelectsAllWhenSettingContentBindingOption	;
//An NSNumber object containing a Boolean value that specifies if all the items in the array controller are selected when the content is set. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSValidatesImmediatelyBindingOption	;
//An NSNumber object containing a Boolean value that determines if the contents of the binding are validated immediately. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSValueTransformerNameBindingOption	;
//The value for this key is an identifier of a registered NSValueTransformer instance that is applied to the bound value. 

//Available in Mac OS X v10.4 and later.
extern NSString * NSValueTransformerBindingOption	;
//An NSValueTransformer instance that is applied to the bound value. 

//Available in Mac OS X v10.4 and later.