/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#include <stdlib.h>
#include <string.h>
#include <sys/time.h>
#include <time.h>

#include "types.h"
#include "utils.h"

/**
   ޸  Լ.
 */
void
dump_mem (char *r, int size)
{
  int i;

  for (i=0; i<size; i++)
    {
      fprintf (stderr, "0x%x ", r[i] & 0xff);
    }

  fprintf (stderr, "\n");
}

/**
   ־ ð T ŭ sleep  Ѵ.

   @param t	Sleep  ð.
 */
void 
rc_sleep (rc_interval_time_t t)
{
  apr_sleep (t);
}

/**
     Ͽ ȯѴ.

   @return  ð.
*/
rc_time_t 
rc_time_now (void)
{
  return apr_time_now ();
}

/**
   ܼ malloc wrapper.

   @param size	Ҵ ޸ ũ.
   @return	Ҵ ޸𸮸 ȯѴ.
 */
void *
rc_malloc (size)
     size_t size;
{
  return malloc (size);
}

void *
rc_realloc (ptr, size)
     void *ptr;
     size_t size;
{
  return realloc (ptr, size);
}

/**
   ܼ calloc wrapper

   @param nmemb	Element ũ
   @param size	Ʈ ũ
   @return	Ҵ ޸𸮸 ȯѴ.
 */
void *
rc_calloc (nmemb, size)
     size_t nmemb, size;
{
  return calloc (nmemb, size);
}

/**
   ܼ free wrapper.

   @param r	Release  ʿ ޸ 
 */
void
rc_free (r)
     void *r;
{
  free (r);
}

/**
    ð output Ѵ.

   !! ޸𸮸 Ҵ  ¿ ̱ , printf () 
      κп  Ѵ.   ȯ,  ϴ operation
    Ͼ ȵȴ.

   @return	 ð ȯѴ.
*/
char *
get_current_timestr (void)
{
  time_t t;
  char *time_string;
  
  t = time (NULL);
  time_string = ctime (&t);
  time_string[strlen (time_string) - 1] = '\0';
  
  return time_string;
}

/**
   STRDUP   Ȱ ϴ Լ.

   @param p      ڿ  
   @param l      ڿ 
   @return        ڿ
 */
char *
rc_strndup (char *p, int l)
{
  char *ret;

  ret = (char *) rc_malloc (l + 1);
  if (!ret)
    return NULL;

  memcpy (ret, p, l);
  ret[l] = '\0';

  return ret;
}

/**
   ڿ մϴ. 
*/
char *
rc_strdup (char *p)
{
  return strdup (p);
}
