/*  -
   Copyright (C) 2006 Weongyo Jeong (weongyo@gmail.com)

This file is part of ROVM.

ROVM is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free
Software Foundation; either version 2, or (at your option) any later
version.

ROVM is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or
FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
for more details.

You should have received a copy of the GNU General Public License
along with GCC; see the file COPYING.  If not, write to the Free
Software Foundation, 59 Temple Place - Suite 330, Boston, MA
02111-1307, USA.  */

#ifndef _ROVMLOG_H
#define _ROVMLOG_H

#define	ROVMLOG_EMERG		0	/* system is unusable */
#define	ROVMLOG_ALERT		1	/* action must be taken immediately */
#define	ROVMLOG_CRIT		2	/* critical conditions */
#define	ROVMLOG_ERR		3	/* error conditions */
#define	ROVMLOG_WARNING		4	/* warning conditions */
#define	ROVMLOG_NOTICE		5	/* normal but significant condition */
#define	ROVMLOG_INFO		6	/* informational */
#define	ROVMLOG_DEBUG		7	/* debug-level messages */

#define	ROVMLOG_LEVELMASK	7	/* mask off the level value */

#ifndef DEFAULT_LOGLEVEL
#define DEFAULT_LOGLEVEL	ROVMLOG_DEBUG
#endif

#define ROVMLOG_WITHERRNO	(ROVMLOG_LEVELMASK + 1)
#define ROVMLOG_MARK		__FILE__,__LINE__

extern void rovm_log (struct rovm *, int, const char *, int, const char *, ...);
extern void rovm_rlog (request_rec *, int, const char *, int, const char *, ...);

#endif
