#ifndef _ROVM_CLASS_H
#define _ROVM_CLASS_H

/**  Class  ã   ,   ȯϰ ˴ϴ.  */
#define NULL_CLASS              (RvClass *) 0
/**  ã ϴ Class   ROVM  ƴ ݿ ִ Class  ,
      ȯϰ ˴ϴ.  */
#define REMOTE_CLASS            (RvClass *) 1

#define NULL_FIELD              (RvField *) 0
#define NULL_METHOD             (RvMethod *) 0
#define NULL_OBJECT             (RvObject *) 0

typedef unsigned short u2;
typedef unsigned char u1;
typedef unsigned int u4;
typedef struct eclass RvClass;
#define ROVM_ECLASS_TYPEDEF     /**< el.h  浹  .  */
typedef struct eclass_field RvField;
typedef struct eclass_method RvMethod;
typedef struct eobject RvObject;
#define ROVM_EOBJECT_TYPEDEF    /**< el.h  浹  .  */

enum access_flag
  {
    ACCESS_NATIVE = 0x1
  };

#define FIELD_NAME(NODE)                ((NODE)->name)
#define FIELD_TYPE(NODE)                ((NODE)->type)
#define FIELD_INDEX(NODE)               ((NODE)->index)
#define FIELD_NEXT(NODE)                ((NODE)->next)

struct eclass_field
{
  /** Field  ̸  ִ ڿ Դϴ.  */
  u1 *name;
  /** Field  Ÿ Ű ڿ Դϴ.  */
  u1 *type;

  /** Field  , ObjectRef      field  
       ʿѵ, ش   field  ϴ ġ Ű 
      index ȣԴϴ.  */
  u2 index;

  /**  field   .  */
  struct eclass_field *next;
};

#define MTYPE_STR(NODE)                 ((NODE)->str)
#define MTYPE_ARGC(NODE)                ((NODE)->argc)
#define MTYPE_ARGV(NODE)                ((NODE)->argv)
#define MTYPE_RET(NODE)                 ((NODE)->ret)

/**
   Method  Type  мϿ ׿     ִ üԴϴ.
 */
struct eclass_method_type
{
  /** Method  Type Դϴ.  */
  u1 *str;

  /** Type  Argument    ֽϴ.  */
  u2 argc;
  /** Type   Argument  ġ  offset   ֽϴ.  */
  u2 *argv;
  /** Type  Return   ġ offset   ֽϴ.  */
  u2 ret;
};

#define METHOD_FLAG(NODE)               ((NODE)->flag)
#define METHOD_NAME(NODE)               ((NODE)->name)
#define METHOD_TYPE(NODE)               ((NODE)->type)
#define METHOD_MAX_LOCALS(NODE)         ((NODE)->max_locals)
#define METHOD_OPLEN(NODE)              ((NODE)->oplen)
#define METHOD_OP(NODE)                 ((NODE)->op)
#define METHOD_NATIVE(NODE)             ((NODE)->native)
#define METHOD_NEXT(NODE)               ((NODE)->next)

/**
   ϳ Method  Ÿ üԴϴ.
 */
struct eclass_method
{
  /**  Method  پ ɼ ϱ  flag .  */
  enum access_flag flag;

  /** Method  ̸  ִ ڿ Դϴ.  */
  u1 *name;
  /** Method  Ÿ ؼ ·  ִ ü.  */
  struct eclass_method_type *type;

  /** Method ο    ִ ũ.  */
  u2 max_locals;

  /**  Method  ROVM opcode  Ǿ  , ش opcode  
      ü ̸ ϴ .  */
  u4 oplen;
  /**  Method  ROVM opcode  Ǿ  , ش opcode  
      .  */
  rc_opcode_t *op;

  /**  Method  flag  ACCESS_NATIVE  Ǿ  ,  Լ
      Ͱ ˴ϴ.   Ʒ  ACCESS_NATIVE   Դϴ.  */
  int (*native) (RvObject *cls, RvValue *arg, RvValue *ret);

  /**  method   .  */
  struct eclass_method *next;
};

#define CLASS_FLAG(NODE)                ((NODE)->flag)
#define CLASS_ROVM(NODE)                ((NODE)->r)
#define CLASS_NAME(NODE)                ((NODE)->name)
#define CLASS_FIELD(NODE)               ((NODE)->f)
#define CLASS_FIELD_COUNT(NODE)         ((NODE)->field_count)
#define CLASS_METHOD(NODE)              ((NODE)->m)
#define CLASS_NATIVE_HANDLE(NODE)       ((NODE)->native_handle)

/**
   ENVLANG File Format  ǵǾ ִ Ŭ C  ǥ ü
   Դϴ.

   (20050206)   ſ ϸ, field, exception    
              ʽϴ.
 */
struct eclass
{
  /**  Class  پ ɼ ϱ  flag .  */
  enum access_flag flag;
  /** ROVM ü    ؼ, ̿  ͸ Ѵ.  */
  struct rovm *r;
  /**  RvClass  flag  ACCESS_NATIVE  Ǿ  ,   ȴ.  */
  rc_dso_handle_t *native_handle;

  /**  RvClass  ̸  ֽϴ.   Ҵ ̸ ܼ debug
       Ǹ,  ̸ ̿Ͽ class  ã    .  */
  u1 *name;

  /**  RvClass  ǵǾ ִ field 鿡  linked list Դϴ.  */
  struct eclass_field *f;
  /**  RvClass  ǵǾ ִ field     ֽϴ.  */
  u2 field_count;

  /**  RvClass  ǵǾ ִ method 鿡  linked list Դϴ.  */
  struct eclass_method *m;
};

#define OBJECT_REQUEST(NODE)            ((NODE)->r)
#define OBJECT_TICKET(NODE)             ((NODE)->tk)
#define OBJECT_TYPE(NODE)               ((NODE)->type)
/**  ObjectRef  local  ŵϴ.  */
#define LOCAL_OBJECT                    0
/**  ObjectRef  remote  ŵϴ.  */
#define REMOTE_OBJECT                   1
#define OBJECT_IS_STRING(NODE)          ((NODE)->is_string)
#define OBJECT_IS_ARRAY(NODE)           ((NODE)->is_array)
#define OBJECT_CTIME(NODE)              ((NODE)->ctime)
#define OBJECT_MAX_USERDATA             16
#define OBJECT_USERDATA(NODE)           ((NODE)->userdata)
#define OBJECT_USERDATA_IDX(NODE, IDX)  ((NODE)->userdata[(IDX)])
#define OBJECTL_CLASS(NODE)             ((NODE)->cls)
#define OBJECTL_ROVM(NODE)              CLASS_ROVM (OBJECTL_CLASS (NODE))
#define OBJECTL_FIELD(NODE)             ((NODE)->f)
#define OBJECTL_FIELD_IDX(NODE, IDX)    (&((NODE)->f[(IDX)]))

/**
   RvObject ü ؼ մϴ.
 */
struct eobject
{
  /** request   üν Ȯ ʿ ߻ϴ  ޼
      ڿ ǳ  ֵ ϱ ؼ մϴ.

        method ȣ ̷   Ǵ request_rec
      ü   ǰ ˴ϴ.  */
  request_rec *r;
  /**   ObjectRef  ҼӵǾ ִ Ticket ü Ų.  */
  struct ticket *tk;

  /**   RvObject  local Ŭ   ObjectRef  remote
      ObjectRef    Ÿ Դϴ.    0  ,
      local  ǹϸ, 1   remote  ǹմϴ.
      ()  */
  unsigned type : 1;
  /**  1  ,   ObjectRef  String ü ǹմϴ.  */
  unsigned is_string : 1;
  /**  1  ,   ObjectRef  Array ü ǹմϴ.  */
  unsigned is_array : 1;
  unsigned unused : 29;

  /**  ObjectRef  * ð*    ֽϴ.   
      Garbage Collector  ϰ ϱ ؼ մϴ. 
      ()  */
  rc_time_t ctime;

  /** ڰ ڽ  ӽ   ִ  οѴ.  */
  unsigned long userdata[OBJECT_MAX_USERDATA];

  /**  Ϻ eobject ü  ƴ, Ʒ  LOCAL_OBJECT 
       ش, Ŭ Ǵ ̴.  */
  RvClass *cls;

  /** LOCAL_OBJECT  , ش Ŭ ʵ尪   Ҵȴ.  */
  RvValue *f;
};

extern int rc_expandarray (RvObject *, int);
extern RvClass *rc_getclassbyhost (request_rec *, int, char *, unsigned short, char *);
extern RvObject *NewRemoteRvObject (request_rec *, int, char *, unsigned short, char *);
extern RvObject *NewRvObject (struct rovm *, struct ticket *, RvClass *);
extern RvObject *NewRvArray (struct rovm *, struct ticket *, int);
extern RvObject *NewRvStringObject (struct rovm *, struct ticket *, const char *, size_t);

extern int rc_callmethod (request_rec *, struct ticket *, char *, char *, u2, u2 *);

extern RvValue *rc_getfieldvalue (RvObject *self, const char *fname, const char *ftype);
extern int rc_getinfo_string (RvObject *obj, char **str, int *len);
extern int rc_getinfo_array (RvObject *obj, RvValue **entry, int *arrlen);

#endif

