'''
$Log: clickyLib.py,v $
Revision 1.33  2006/05/08 06:39:26  jangc
.

Revision 1.32  2006/05/08 04:24:19  jangc
admin page...modified

Revision 1.31  2006/05/07 05:41:34  jangc
.

Revision 1.29  2006/05/06 16:56:47  jangc
.

Revision 1.28  2006/05/06 16:45:13  jangc
----

Revision 1.27  2006/04/16 03:23:22  jangc
sort method is added

Revision 1.26  2006/04/06 13:47:30  jangc
skin is modified

Revision 1.25  2006/03/27 03:39:41  jangc
deadline of release 0.4 is comming.

Revision 1.24  2006/02/26 05:11:47  jangc
move bug is modifed

Revision 1.23  2006/02/25 03:41:00  jangc
login is added

Revision 1.22  2006/02/24 13:27:15  jangc
.

Revision 1.21  2006/02/24 01:57:09  jangc
modified

Revision 1.20  2006/02/05 07:01:29  jangc
makeTree function, treectrl.js are added

Revision 1.19  2005/10/30 06:26:46  jangc
shell mode is added

Revision 1.18  2005/07/24 08:06:17  jangc
skin is modified

Revision 1.17  2005/06/26 07:42:56  jangc
setUrl method is added. link is added to file, folder skin

Revision 1.16  2005/06/19 07:32:14  jangc
download action is added

Revision 1.15  2005/04/10 03:10:50  jangc
minor changes
'''
import os
import shutil
import stat
import time
import urllib
import re
import zipfile
import cPickle
import random
import cgi

import config
import exceptionLib 
from templateProcessor import templateProcessor, getTemplate 

class FObject:
    def moveTo(self, destination):
        return

    def chmodByBin(self, binMode):
        digitMode = bin2digit(binMode)
        os.chmod(self.path, eval('0%s' % oct(digitMode)))

    def setUrl(self): # FIXME
        self.url = None
        homeUrl = config.homeUrl
        homePath = os.path.realpath(config.homePath)
        if homePath in self.path:
            self.url = self.path.replace(homePath, homeUrl)
        return self.url

    def chown(self): # FIXME only for *nix
        pass

    def sort(self, by, order):
        pass
    def rename(self, newName):
        invalidChars = '/\?|<>*":' # FIXME window linux  ʿ䰡  ?
        for char in invalidChars:
            if char in newName:
               return False
            
        newPath = os.path.join(os.path.split(self.path)[0], newName)
        if os.path.exists(newPath):
            return False
        os.rename(self.path, newPath)
        self.path = os.path.realpath(newPath)
        self.name = newName
        return True

    def checkType(self): # FIXME
        if os.path.isdir(self.path): 
            fType = 'Folder'
            self.icon = 'folder.gif'
        elif os.path.isfile(self.path): 
            fType = 'File'
            self.icon = 'file.gif'
        else: fType = '?????'
        return fType

    def setFObjInfomation(self):
        stats = os.stat(self.path)
        self.fileSize = stats[stat.ST_SIZE]
        self.aDate = stats[stat.ST_ATIME]
        self.mDate = stats[stat.ST_MTIME]
        self.prettyTime = time.strftime('%Y-%m-%d %H:%M:%S', time.localtime(self.mDate))

        self.fType = self.checkType()
        perm = getPermission(self.path)
        self.ownerRead, self.ownerWrite, self.ownerExecute = [int(d) for d in bin(perm, 9)[:3]]
        self.groupRead, self.groupWrite, self.groupExecute = [int(d) for d in bin(perm, 9)[3:6]]
        self.otherRead, self.otherWrite, self.otherExecute = [int(d) for d in bin(perm, 9)[6:9]]

        perm = oct(perm)
        self.permission = len(perm) > 3 and perm[1:] or perm
 
class File(FObject): 
    def __init__(self, path):
        self.path = os.path.realpath(path)
        self.name = os.path.split(path)[-1]
        self.url = self.setUrl()  
        
        self.setFObjInfomation()

    def write(self, contents):
        file(self.path, 'w').write(contents)
        
    def read(self):
        return file(self.path).read()
        
    def moveTo(self, destination): # FIXME overap... 
        newDest = os.path.realpath(destination)
        if not os.path.exists(newDest):
            raise exceptionLib.IllegalDestination
        if os.path.isdir(newDest):
            newDest = os.path.join(newDest, self.name)
        if os.path.exists(newDest):
            raise exceptionLib.IllegalDestination
        if self.path == newDest:
            raise exceptionLib.IllegalDestination
        shutil.move(self.path, newDest)
        self.path = newDest
        return True

    def copyTo(self, destination):
        destination = os.path.realpath(destination)
        newDest = os.path.join(destination, self.name)
        if os.path.exists(newDest):
            raise exceptionLib.IllegalDestination
        shutil.copy(self.path, newDest) 
        return True
 
    def remove(self):
        try:
            os.remove(self.path)
        except OSError:
            return False
        return True

    def toHTML(self, globalNS={}, localNS={}, skinFile='file.teul'):
        teul = getTemplate('skin/'+skinFile) 
        globalNS.update(globals())
        localNS.update(locals())
        localNS['self'] = self
        localNS.update(self.__dict__)
        return templateProcessor(teul, globalNS, localNS)

class Folder(FObject):
    def __init__(self, path):
        self.path = os.path.realpath(path)
        self.name = os.path.split(self.path)[-1]
        self.url = self.setUrl()
        self.setFObjInfomation()
          
    def copyTo(self, destination):
        destination = os.path.realpath(destination)
        newDest = os.path.join(destination, self.name)
        if isUpperFolder(self.path, destination): 
            raise exceptionLib.IllegalDestination
        if os.path.exists(newDest):
            raise exceptionLib.IllegalDestination
        shutil.copytree(self.path, newDest)
        return True
        
    def remove(self):
        try:
            shutil.rmtree(self.path)
        except OSError:
            return False 
        return True 

    def moveTo(self, destination): # FIXME ĥ. ڱ ڽ  
        destination = os.path.realpath(destination)
        if not os.path.exists(destination):
            raise exceptionLib.IllegalDestination
        if isUpperFolder(self.path, destination):
            raise exceptionLib.IllegalDestination
        newDest = os.path.join(destination, self.name)
        if self.path == newDest:
            raise exceptionLib.IllegalDestination
        shutil.move(self.path, newDest)
        self.path = os.path.realpath(newDest)
        return True


    def toHTML(self, globalNS={}, localNS={}, skinFile='folder.teul'):
        teul = getTemplate('skin/'+skinFile) 
        globalNS.update(globals())
        localNS.update(locals())
        localNS['self'] = self
        localNS.update(self.__dict__)
        return templateProcessor(teul, globalNS, localNS)
    
def makeTree(path, curPath=None): 
    path = os.path.realpath(path)
    curPath = os.path.realpath(curPath)
    g = os.walk(path)
    n = g.next()[1]
    id = 'f_%s' % str(random.random())[2:]
    folderName = os.path.split(path)[-1] 
    willBePrintedPath = path == curPath and '<b>%s</b>' % folderName or folderName
    folderIcon = path == curPath and 'tree_icon_selected_folder.gif' or 'tree_icon_folder.gif'
    print '''
        <table border="0" cellpadding="0" cellspacing="0">
        <tr valign="top">
            <td nowrap>&nbsp;'''
    if len(n) != 0:
        print '''<font onclick="javascript:folding('%s')"> <img name="icon_%s" src="./skin/images/tree_icon_minus.gif"/> </font>''' % (id, id)
    else:
        print '''<img src="./skin/images/tree_icon_fake.gif"/>''' 
    print '''
            </td>
            <td nowrap>&nbsp;
                <a href="clicky.py?curPath=%s">''' % cgi.escape(path)
    print '''<img src="./skin/images/%s"/> %s</a>
            </td></tr>''' % (folderIcon, willBePrintedPath)  
    if len(n) is not 0: 
        print '<tr><td></td><td id="%s">' % id
        for i in range(len(n)):
            makeTree(os.path.normpath(os.path.join(path,n[i])), curPath)
        print '</td></tr>'
    print '</tr>'
    print '</table>'

def getFileOrFolderInstanceByPath(path):
    if os.path.isdir(path):
        return Folder(path)
    elif os.path.isfile(path):
        return File(path)
    else:
        return None

getFObject = getFileOrFolderInstanceByPath

class Directory(list): # FIXME MyName
    def __init__(self, path):
        self.path = os.path.realpath(path)
        if not os.path.isdir(self.path):
            raise exceptionLib.DirectoryDoesNotExist, self.path
        
        self.msg = None # FIXME change my name   
        try: 
            generator = os.walk(path)
            dot, self.folderNameList, self.fileNameList = generator.next()
            self.folderObjList = [Folder(os.path.join(self.path, name)) for name in self.folderNameList] 
            self.fileObjList = [File(os.path.join(self.path, name)) for name in self.fileNameList]
            self.extend(self.folderObjList + self.fileObjList)
        except Exception, msg: 
            self.msg = 'Failed'

    def sortBy(self, by, order='asc'): # FIXME
        self.folderObjList.sort(lambda a, b: cmp(getattr(a, by), getattr(b, by)))
        if order == "desc":
            self.folderObjList.reverse()
        self.fileObjList.sort(lambda a, b: cmp(getattr(a, by), getattr(b, by)))
        if order == "desc":
            self.fileObjList.reverse()
        while self:
            self.pop()
        self.extend(self.folderObjList + self.fileObjList)

    def getUpstairsPath(self):
        return os.path.split(self.path)[0]
        
    def createFile(self, name, own=None, mod='777'):
        pass
    def createFolder(self, name, own=None, mod='777'):
        pass
    def refresh(self):
        pass

    def toHTML(self, globalNS={}, localNS={}):
        fname = 'directory.teul'
        teul = getTemplate('skin/'+fname) 
        globalNS.update(globals())
        localNS.update(locals())
        localNS['self'] = self
        localNS.update(self.__dict__)
        return templateProcessor(teul, globalNS, localNS)

class Search(list):
    def __init__(self, root=None, keyword=None, recusive=False):
        self.search(root, keyword, recusive)

    def search(self, root, keyword, recusive=False):
        g = os.walk(root)
        curPath, dirs, files = g.next()
        fnameList = dirs + files
        for fname in fnameList:
            if fname.find(keyword.lower()) >= 0:
                self.append(getFObject(os.path.join(curPath, fname)))
        if recusive:
            for infos in g:
                curPath, dirs, files = infos
                fnameList = dirs + files
                for fname in fnameList:
                    if fname.find(keyword) >= 0:
                        self.append(getFObject(os.path.join(curPath, fname)))

    def sortBy(self, by, order='asc'): # FIXME
        self.sort(lambda a, b: cmp(getattr(a, by), getattr(b, by)))
        if order == "desc":
            self.reverse()

    def toHTML(self, globalNS={}, localNS={}):
        fname = 'searchResultList.teul'
        teul = getTemplate('skin/'+fname) 
        globalNS.update(globals())
        localNS.update(locals())
        localNS['self'] = self
        localNS.update(self.__dict__)
        return templateProcessor(teul, globalNS, localNS)


        
class User:
    def __init__(self):
        pass

def isUpperFolder(path1, path2):
    path1 = path1 + '/'
    path2 = path2 + '/'
    if path1 in path2:
        return True
    return False

def escapeWhiteSpace(text):
    sp = re.compile(' ( +)')
    def spacerepl(match):
        s = match.group()
        return ' '+'&nbsp;'*(len(s)-1)
    text = text.expandtabs()
    text = sp.sub(spacerepl, text)
    text = text.replace('\n', '<br/>\n') # FIXME
    return text

def convertPlainIntoHTML(text):
    text = text.replace('&', '&amp;') 
    text = text.replace('<', '&lt;') 
    text = text.replace('"', '&quot;') 
    text = escapeWhiteSpace(text)
    return text

def getPermission(path):
    mode = os.stat(path)[stat.ST_MODE] 
    return stat.S_IMODE(mode)

def bin(d, width=0):
    ret = ''
    while d:
        ret = str(d % 2) + ret
        d = d / 2
    ret = ret.zfill(width)
    return ret

def bin2digit(bin):
    ret = 0
    d = 1
    bin = bin[::-1]
    for i in bin:
        if not i in ['1', '0']:
            return False
        ret = ret + int(i) * d
        d = d << 1
    return int(ret)

def fileUpload(uploadPath, fileName, fileStr):
    if not os.path.exists(uploadPath):
        os.makedirs(uploadPath)
    filePath = os.path.join(uploadPath, fileName)
    open(filePath, 'wb').write(fileStr)
    return True 

def getFileNameAndValue(form, name):
    try:
        fileName = form[name].filename
        fileStr = form[name].value
    except:
        fileName = ''
        fileStr = ''
    fileName = fileName.replace('\\', '/')
    fileName = os.path.split(fileName)[1]
    if not (fileName and fileStr):
        fileName = ''
        fileStr = ''
    return fileName, fileStr

def zipFile(fname, fileList, arcNames=[]):
    if os.path.exists(fname):
        return False
    if len(fileList) == 0:
        return False
    z = zipfile.ZipFile(file(fname, 'wb'), 'w')#, zipfile.ZIP_DEFLATED)
    fileList = zip(fileList, arcNames)
    for path, name in fileList:
        if os.path.isfile(path):
            z.write(path, name)
    z.close()
    return True

def unzipFile(path, targetPath):
    if not zipfile.is_zipfile(path):
        return False
    if not os.path.exists(targetPath):
        try:
            os.makedirs(dirs)
        except:
            pass
    z = zipfile.ZipFile(path)
    for name in z.namelist():
        if os.path.exists(name):
            continue
        if '/' in name:
            dirs = os.path.split(name)[0]
            try:
                os.makedirs(os.path.join(targetPath, dirs))
            except OSError:
                pass
        if name.endswith('/'):
            continue
        s=z.read(name)
        file(os.path.join(targetPath, name), 'wb').write(s)
    return True

invalidChars = '/\?|<>*":' # FIXME window linux  ʿ䰡  ?

def createFolder(currentFolder, folderName):
    for char in invalidChars:
        if char in folderName:
            return False
    os.mkdir(os.path.realpath(os.path.join(currentFolder, folderName))) 
    return True

def createFile(currentFolder, fileName, contents):
    for char in invalidChars:
        if char in fileName:
            return False
    fullpath = os.path.realpath(os.path.join(currentFolder, fileName))
    file(fullpath, 'w').write(contents)
    return True

def getBookmarks():
    try:
        bookmarks = cPickle.load(file('bookmarks'))
    except:
        bookmarks = {}
    return bookmarks

def addBookmark(name, path): # FIXME  
    bookmarks = getBookmarks()
    bookmarks[name] = os.path.realpath(path)
    cPickle.dump(bookmarks, file('bookmarks', 'w'))
    return True

def removeBookmark(name):
    bookmarks  = cPickle.load(file('bookmarks'))
    ret = bookmarks.pop(name, None)
    cPickle.dump(bookmarks, file('bookmarks', 'w'))
    return ret 

def userPermCheck(user):
    if user.uid == 'anonymous':
        return False
    return True

def cmdChecker(cmd):
    if cmd.strip() == '':
        return False
    return True

def loadInfoOfExts():
    return []
    
