package com.babukuma.util.dbunit;

import java.sql.Connection;

import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.ext.mssql.MsSqlConnection;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;

/**
 * MS-SQL용 데이터 생성 클래스
 * @author BABUKUMA
 */
public class MSSQLDataCreator extends AbstractDataCreator {

    /**
     * @param classLocation JDBC Class Location
     * @param jdbcDriver JDBC Driver Name
     * @param url DB Connect URL
     * @param userID DB Connect User ID
     * @param password DB Connect User Password
     * @param schema 사용할 DB schema
     */
    public MSSQLDataCreator(String classLocation, String jdbcDriver,
        String url, String userID, String password, String schema) {
        super(classLocation, jdbcDriver, url, userID, password, schema);
    }

    /**
     * MS-SQL용 Connection을 얻어온다.
     * @param connection Connection
     * @return IDatabaseConnection
     */
    protected IDatabaseConnection getDatabaseConnection(Connection connection) {
        IDatabaseConnection databaseConnection = null;
        try {
            databaseConnection = new MsSqlConnection(connection, getSchema());
            DatabaseConfig config = databaseConnection.getConfig();
            config.setProperty(DatabaseConfig.PROPERTY_DATATYPE_FACTORY,
                new MsSqlDataTypeFactory());
        } catch (Exception e) {
            e.printStackTrace();
        }

        return databaseConnection;
    }

}
